/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.effect.EffectPlay;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class WandTemplate
implements com.elmakers.mine.bukkit.api.wand.WandTemplate {
    private final MageController controller;
    private final String key;
    private final ConfigurationSection configuration;
    private Map<String, Collection<EffectPlayer>> effects = new HashMap<String, Collection<EffectPlayer>>();
    private Collection<EffectPlay> currentEffects = new ArrayList<EffectPlay>();
    private Set<String> tags;
    private Set<String> categories = ImmutableSet.of();
    private String creator;
    private String creatorId;
    private String migrateTemplate;
    private String migrateIcon;
    private String icon;
    private boolean soul;
    private boolean restorable;
    private Map<String, String> migrateIcons;

    public WandTemplate(MageController controller, String key, ConfigurationSection node) {
        List<String> tagList;
        this.key = key;
        this.configuration = node;
        this.controller = controller;
        this.effects.clear();
        this.creator = node.getString("creator");
        this.creatorId = node.getString("creator_id");
        this.migrateTemplate = node.getString("migrate_to");
        this.migrateIcon = node.getString("migrate_icon");
        this.restorable = node.getBoolean("restorable", true);
        this.icon = node.getString("icon");
        this.soul = node.getBoolean("soul", false);
        ConfigurationSection migrateConfig = node.getConfigurationSection("migrate_icons");
        if (migrateConfig != null) {
            this.migrateIcons = new HashMap<String, String>();
            Set keys = migrateConfig.getKeys(false);
            for (String migrateKey : keys) {
                this.migrateIcons.put(migrateKey, migrateConfig.getString(migrateKey));
            }
        }
        if (node.contains("effects")) {
            ConfigurationSection effectsNode = node.getConfigurationSection("effects");
            Set effectKeys = effectsNode.getKeys(false);
            for (String effectKey : effectKeys) {
                if (effectsNode.isString(effectKey)) {
                    String referenceKey = effectsNode.getString(effectKey);
                    if (!this.effects.containsKey(referenceKey)) continue;
                    this.effects.put(effectKey, new ArrayList<EffectPlayer>(this.effects.get(referenceKey)));
                    continue;
                }
                this.effects.put(effectKey, EffectPlayer.loadEffects(controller.getPlugin(), effectsNode, effectKey));
            }
        }
        this.tags = (tagList = ConfigurationUtils.getStringList(node, "tags")) != null ? new HashSet<String>(tagList) : null;
        List<String> categoriesList = ConfigurationUtils.getStringList(node, "categories");
        if (categoriesList != null) {
            this.categories = ImmutableSet.copyOf(categoriesList);
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public ConfigurationSection getConfiguration() {
        return this.configuration;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> getEffects(String key) {
        Collection<EffectPlayer> effectList = this.effects.get(key);
        if (effectList == null) {
            return new ArrayList<com.elmakers.mine.bukkit.api.effect.EffectPlayer>();
        }
        return new ArrayList<com.elmakers.mine.bukkit.api.effect.EffectPlayer>(effectList);
    }

    @Override
    public void playEffects(Mage mage, String key) {
        this.playEffects(mage, key, 1.0f);
    }

    @Override
    public void playEffects(Mage mage, String effectName, float scale) {
        this.currentEffects.clear();
        Location wandLocation = null;
        Location location = mage.getLocation();
        Location eyeLocation = mage.getEyeLocation();
        Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> effects = this.getEffects(effectName);
        if (effects.size() > 0) {
            Entity sourceEntity = mage.getEntity();
            for (com.elmakers.mine.bukkit.api.effect.EffectPlayer player : effects) {
                Location source;
                player.setEffectPlayList(this.currentEffects);
                player.setScale(scale);
                player.setColor(mage.getEffectColor());
                String overrideParticle = mage.getEffectParticleName();
                player.setParticleOverride(overrideParticle);
                Location location2 = source = player.shouldUseEyeLocation() ? eyeLocation : location;
                if (player.shouldUseWandLocation()) {
                    if (wandLocation == null) {
                        wandLocation = mage.getWandLocation();
                    }
                    location = wandLocation;
                }
                player.start(source, sourceEntity, null, null, null);
            }
        }
    }

    @Override
    public boolean hasTag(String tag) {
        return this.tags != null && this.tags.contains(tag);
    }

    @Override
    public String getCreatorId() {
        return this.creatorId;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public Set<String> getCategories() {
        return this.categories;
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.WandTemplate getMigrateTemplate() {
        return this.migrateTemplate == null ? null : this.controller.getWandTemplate(this.migrateTemplate);
    }

    @Override
    public String migrateIcon(String currentIcon) {
        String newIcon;
        if (this.icon != null && this.migrateIcon != null && this.migrateIcon.equals(currentIcon)) {
            return this.icon;
        }
        if (this.migrateIcons != null && (newIcon = this.migrateIcons.get(currentIcon)) != null) {
            return newIcon;
        }
        return currentIcon;
    }

    @Override
    public boolean isSoul() {
        return this.soul;
    }

    @Override
    public boolean isRestorable() {
        return this.restorable;
    }
}

