/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.Target;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

@Deprecated
public class ForceSpell
extends TargetingSpell {
    LivingEntity targetEntity = null;
    private Color effectColor = null;
    private static final int DEFAULT_MAGNITUDE = 3;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Mage targetMage;
        this.effectColor = this.mage.getEffectColor();
        if (this.effectColor == null) {
            this.effectColor = Color.fromRGB((int)Integer.parseInt(parameters.getString("effect_color", "FF0000"), 16));
        }
        if (this.targetEntity != null) {
            Location location = this.getLocation();
            World targetWorld = this.targetEntity.getWorld();
            if (!this.targetEntity.isValid() || this.targetEntity.isDead()) {
                this.releaseTarget();
            } else if (targetWorld == null || location == null || !targetWorld.getName().equals(location.getWorld().getName())) {
                this.releaseTarget();
            } else if (location.distanceSquared(this.targetEntity.getLocation()) > this.getMaxRangeSquared()) {
                this.releaseTarget();
            }
            if (this.targetEntity != null && this.controller.isMage((Entity)this.targetEntity) && this.isSuperProtected(targetMage = this.controller.getMage((Entity)this.targetEntity))) {
                this.releaseTarget();
            }
        }
        if (this.targetEntity == null) {
            Target target = this.getTarget();
            if (!target.hasEntity() || !(target.getEntity() instanceof LivingEntity)) {
                return SpellResult.NO_TARGET;
            }
            this.releaseTarget();
            LivingEntity checkTarget = (LivingEntity)target.getEntity();
            if (this.controller.isMage((Entity)checkTarget)) {
                targetMage = this.controller.getMage((Entity)checkTarget);
                if (targetMage == null) {
                    return SpellResult.NO_TARGET;
                }
                if (this.isSuperProtected(targetMage)) {
                    return SpellResult.NO_TARGET;
                }
            }
            this.selectTarget(checkTarget);
            return SpellResult.TARGET_SELECTED;
        }
        double multiplier = parameters.getDouble("size", 1.0);
        int magnitude = parameters.getInt("entity_force", 3);
        this.forceEntity((Entity)this.targetEntity, multiplier, magnitude);
        return SpellResult.CAST;
    }

    protected void forceEntity(Entity target, double multiplier, int magnitude) {
        magnitude = (int)((double)magnitude * multiplier);
        Vector forceVector = this.mage.getLocation().getDirection();
        forceVector.normalize();
        forceVector.multiply(magnitude);
        target.setVelocity(forceVector);
    }

    protected void selectTarget(LivingEntity entity) {
        this.releaseTarget();
        this.targetEntity = entity;
        this.getCurrentTarget().setEntity((Entity)entity);
        if (this.effectColor != null) {
            CompatibilityUtils.addPotionEffect(this.targetEntity, this.effectColor);
        }
    }

    protected void releaseTarget() {
        if (this.targetEntity != null && this.effectColor != null) {
            CompatibilityUtils.removePotionEffect(this.targetEntity);
        }
        this.targetEntity = null;
    }

    @Override
    public boolean onCancel() {
        if (this.targetEntity != null) {
            this.releaseTarget();
            return true;
        }
        return false;
    }
}

