/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.WandTemplate;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandAction;
import com.elmakers.mine.bukkit.wand.WandMode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class WandCommandExecutor
extends MagicTabExecutor {
    public WandCommandExecutor(MagicAPI api) {
        super(api);
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        String commandName = command.getName();
        if (commandName.equalsIgnoreCase("wandp")) {
            if (args.length == 0) {
                sender.sendMessage("Usage: /wandp [player] [wand name/command]");
                return true;
            }
            Player player = DeprecatedUtils.getPlayer(args[0]);
            if (player == null) {
                sender.sendMessage("Can't find player " + args[0]);
                return true;
            }
            if (!player.isOnline()) {
                sender.sendMessage("Player " + args[0] + " is not online");
                return true;
            }
            String[] args2 = Arrays.copyOfRange(args, 1, args.length);
            return this.processWandCommand("wandp", sender, player, args2);
        }
        if (commandName.equalsIgnoreCase("wand") && args.length > 0 && args[0].equalsIgnoreCase("list")) {
            if (!this.api.hasPermission(sender, "Magic.commands.wand.list")) {
                this.sendNoPermission(sender);
                return true;
            }
            this.onWandList(sender);
            return true;
        }
        if (commandName.equalsIgnoreCase("wand") && args.length > 0 && args[0].equalsIgnoreCase("delete")) {
            if (!this.api.hasPermission(sender, "Magic.commands.wand.delete")) {
                this.sendNoPermission(sender);
                return true;
            }
            if (args.length < 2) {
                sender.sendMessage("Usage: /wand delete <wandkey>");
                return true;
            }
            this.onWandDelete(sender, args[1]);
            return true;
        }
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (commandName.equalsIgnoreCase("wand")) {
            return this.processWandCommand("wand", sender, player, args);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        String subCommand;
        ArrayList<String> options = new ArrayList<String>();
        Player player = sender instanceof Player ? (Player)sender : null;
        String permissionKey = "wand";
        if (commandName.contains("wandp")) {
            permissionKey = "wandp";
            if (args.length > 0) {
                player = DeprecatedUtils.getPlayer(args[0]);
            }
            if (args.length == 1) {
                options.addAll(this.api.getPlayerNames());
                return options;
            }
            if (args.length > 1) {
                args = Arrays.copyOfRange(args, 1, args.length);
            }
        }
        if (args.length == 1) {
            this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".", "add");
            this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".", "remove");
            this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".", "name");
            this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".", "fill");
            this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".", "configure");
            this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".", "override");
            this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".", "organize");
            this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".", "alphabetize");
            this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".", "combine");
            this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".", "upgrade");
            this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".", "describe");
            this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".", "enchant");
            this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".", "unenchant");
            this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".", "duplicate");
            this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".", "restore");
            this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".", "unlock");
            this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".", "bind");
            this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".", "unbind");
            this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".", "save");
            this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".", "delete");
            Collection<String> allWands = this.api.getWandKeys();
            for (String wandKey : allWands) {
                this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".wand.", wandKey, true);
            }
        }
        if (args.length == 2) {
            File wandFolder;
            Collection<SpellTemplate> spellList;
            subCommand = args[0];
            String subCommandPNode = "Magic.commands." + permissionKey + "." + subCommand;
            if (!this.api.hasPermission(sender, subCommandPNode)) {
                return options;
            }
            subCommandPNode = subCommandPNode + ".";
            if (subCommand.equalsIgnoreCase("add")) {
                spellList = this.api.getSpellTemplates(sender.hasPermission("Magic.bypass_hidden"));
                for (SpellTemplate spellTemplate : spellList) {
                    this.addIfPermissible(sender, options, subCommandPNode, spellTemplate.getKey(), true);
                }
                this.addIfPermissible(sender, options, subCommandPNode, "material", true);
            }
            if (subCommand.equalsIgnoreCase("configure")) {
                for (String key : Wand.PROPERTY_KEYS) {
                    options.add(key);
                }
            }
            if (subCommand.equalsIgnoreCase("override")) {
                spellList = this.api.getController().getSpellTemplates(true);
                String partial = args[1];
                if (partial.indexOf(46) > 0) {
                    String[] stringArray = StringUtils.split((String)partial, (char)'.');
                    String spellKey = stringArray[0];
                    SpellTemplate spellTemplate = this.api.getController().getSpellTemplate(spellKey);
                    if (spellTemplate != null) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        spellTemplate.getParameters(arrayList);
                        for (String option : arrayList) {
                            options.add(spellKey + "." + option);
                        }
                    }
                } else {
                    for (SpellTemplate spell3 : spellList) {
                        String string = spell3.getKey();
                        if (!this.api.hasPermission(sender, subCommandPNode + string, true)) continue;
                        options.add(string + ".");
                    }
                }
            }
            if (subCommand.equalsIgnoreCase("remove")) {
                com.elmakers.mine.bukkit.api.wand.Wand activeWand = null;
                if (player != null) {
                    Mage mage = this.api.getMage((CommandSender)player);
                    activeWand = mage.getActiveWand();
                }
                if (activeWand != null) {
                    Collection<String> spellNames = activeWand.getSpells();
                    for (String spellName : spellNames) {
                        options.add(spellName);
                    }
                    options.add("material");
                }
            }
            if (subCommand.equalsIgnoreCase("combine")) {
                Collection<String> allWands = this.api.getWandKeys();
                for (String string : allWands) {
                    this.addIfPermissible(sender, options, "Magic.commands." + permissionKey + ".combine.", string, true);
                }
            }
            if (subCommand.equalsIgnoreCase("delete") && (wandFolder = new File(this.api.getController().getConfigFolder(), "wands")).exists()) {
                void var13_42;
                File[] files;
                File[] fileArray = files = wandFolder.listFiles();
                int len$ = fileArray.length;
                boolean bl = false;
                while (var13_42 < len$) {
                    File file = fileArray[var13_42];
                    if (file.getName().endsWith(".yml")) {
                        options.add(file.getName().replace(".yml", ""));
                    }
                    ++var13_42;
                }
            }
        }
        if (args.length == 3) {
            String subCommandPNode;
            String[] pieces;
            subCommand = args[0];
            String subCommand2 = args[1];
            String commandPNode = "Magic.commands." + permissionKey + "." + subCommand;
            if (!this.api.hasPermission(sender, commandPNode)) {
                return options;
            }
            if (subCommand.equalsIgnoreCase("override") && (pieces = StringUtils.split((String)subCommand2, (char)'.')).length > 1) {
                String string = pieces[0];
                String argument = pieces[1];
                SpellTemplate spellTemplate = this.api.getSpellTemplate(string);
                if (spellTemplate != null) {
                    spellTemplate.getParameterOptions(options, argument);
                }
            }
            if (subCommand.equalsIgnoreCase("configure") || subCommand.equalsIgnoreCase("upgrade")) {
                if (subCommand2.equals("effect_sound")) {
                    void var13_46;
                    Sound[] sounds;
                    Sound[] soundArray = sounds = Sound.values();
                    int len$ = soundArray.length;
                    boolean bl = false;
                    while (var13_46 < len$) {
                        Sound sound = soundArray[var13_46];
                        options.add(sound.name().toLowerCase());
                        ++var13_46;
                    }
                } else if (subCommand2.equals("effect_particle")) {
                    void var13_48;
                    ParticleEffect[] particleTypes;
                    ParticleEffect[] particleEffectArray = particleTypes = ParticleEffect.values();
                    int len$ = particleEffectArray.length;
                    boolean bl = false;
                    while (var13_48 < len$) {
                        ParticleEffect particleEffect = particleEffectArray[var13_48];
                        options.add(particleEffect.name().toLowerCase());
                        ++var13_48;
                    }
                } else if (subCommand2.equals("mode")) {
                    for (Enum enum_ : WandMode.values()) {
                        options.add(enum_.name().toLowerCase());
                    }
                } else if (subCommand2.equals("left_click") || subCommand2.equals("right_click") || subCommand2.equals("drop") || subCommand2.equals("swap")) {
                    for (Enum enum_ : WandAction.values()) {
                        options.add(enum_.name().toLowerCase());
                    }
                }
            }
            if (!this.api.hasPermission(sender, subCommandPNode = "Magic.commands." + permissionKey + "." + subCommand + "." + subCommand2)) {
                return options;
            }
            if (subCommand.equalsIgnoreCase("remove") && subCommand2.equalsIgnoreCase("material")) {
                void var11_29;
                Object var11_27 = null;
                if (player != null) {
                    Mage mage = this.api.getMage((CommandSender)player);
                    com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
                }
                if (var11_29 != null) {
                    Collection<String> materialNames = var11_29.getBrushes();
                    for (String string : materialNames) {
                        options.add(string);
                    }
                }
            }
            if (subCommand.equalsIgnoreCase("add") && subCommand2.equalsIgnoreCase("material")) {
                options.addAll(this.api.getBrushes());
            }
        }
        return options;
    }

    protected boolean processWandCommand(String command, CommandSender sender, Player player, String[] args) {
        String subCommand = "";
        String[] args2 = args;
        if (args.length > 0) {
            subCommand = args[0];
            args2 = new String[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
                args2[i - 1] = args[i];
            }
        }
        if (subCommand.equalsIgnoreCase("list")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandList(sender);
            return true;
        }
        if (subCommand.equalsIgnoreCase("add")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            if (args2.length > 0 && args2[0].equals("material") && !this.api.hasPermission(sender, "Magic.commands.wand.add." + args2[0], true)) {
                return true;
            }
            if (args2.length > 0 && !this.api.hasPermission(sender, "Magic.commands.wand.add.spell." + args2[0], true)) {
                return true;
            }
            this.onWandAdd(sender, player, args2);
            return true;
        }
        if (subCommand.equalsIgnoreCase("configure")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandConfigure(sender, player, args2, false);
            return true;
        }
        if (subCommand.equalsIgnoreCase("override")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandOverride(sender, player, args2);
            return true;
        }
        if (subCommand.equalsIgnoreCase("enchant")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            if (args2.length > 0) {
                this.onWandEnchant(sender, player, args2[0]);
            } else {
                this.onWandEnchant(sender, player);
            }
            return true;
        }
        if (subCommand.equalsIgnoreCase("unenchant")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandUnenchant(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("bind")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandBind(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("unbind")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandUnbind(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("duplicate")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandDuplicate(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("save")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandSave(sender, player, args2);
            return true;
        }
        if (subCommand.equalsIgnoreCase("restore")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandRestore(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("unlock")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandUnlock(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("organize")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandOrganize(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("alphabetize")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandAlphabetize(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("combine")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            if (args2.length > 0 && !this.api.hasPermission(sender, "Magic.commands." + command + ".combine." + args2[0], true)) {
                return true;
            }
            this.onWandCombine(sender, player, args2);
            return true;
        }
        if (subCommand.equalsIgnoreCase("describe")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandDescribe(sender, player, args2.length > 0);
            return true;
        }
        if (subCommand.equalsIgnoreCase("upgrade")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandConfigure(sender, player, args2, true);
            return true;
        }
        if (subCommand.equalsIgnoreCase("organize")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandOrganize(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("fill")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            int maxLevel = this.api.getController().getMaxWandFillLevel();
            if (args2.length > 0) {
                if (args2[0].equalsIgnoreCase("max")) {
                    maxLevel = 0;
                } else {
                    try {
                        maxLevel = Integer.parseInt(args2[0]);
                    }
                    catch (Exception ex) {
                        sender.sendMessage("Invalid level: " + args2[0]);
                        return true;
                    }
                }
            }
            this.onWandFill(sender, player, maxLevel);
            return true;
        }
        if (subCommand.equalsIgnoreCase("remove")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandRemove(sender, player, args2);
            return true;
        }
        if (subCommand.equalsIgnoreCase("name")) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandName(sender, player, args2);
            return true;
        }
        if (subCommand.length() == 0) {
            if (!this.api.hasPermission(sender, "Magic.commands." + command)) {
                return true;
            }
            if (!this.api.hasPermission(sender, "Magic.commands." + command + ".create")) {
                return true;
            }
            if (!this.api.hasPermission(sender, "Magic.commands." + command + ".wand.default", true)) {
                return true;
            }
        } else {
            if (!this.api.hasPermission(sender, "Magic.commands." + command + ".create")) {
                return true;
            }
            if (!this.api.hasPermission(sender, "Magic.commands." + command + ".wand." + subCommand, true)) {
                return true;
            }
        }
        return this.onWand(sender, player, args);
    }

    public boolean onWandList(CommandSender sender) {
        Collection<WandTemplate> templates = this.api.getController().getWandTemplates();
        TreeMap<String, ConfigurationSection> nameMap = new TreeMap<String, ConfigurationSection>();
        for (WandTemplate template : templates) {
            nameMap.put(template.getKey(), template.getConfiguration());
        }
        for (ConfigurationSection templateConfig : nameMap.values()) {
            if (templateConfig.getBoolean("hidden", false)) continue;
            String key = templateConfig.getString("key");
            String name = this.api.getMessages().get("wands." + key + ".name", this.api.getMessages().get("wand.default_name"));
            String description = this.api.getMessages().get("wands." + key + ".description", "");
            description = ChatColor.YELLOW + description;
            if (!name.equals(key)) {
                description = ChatColor.BLUE + name + ChatColor.WHITE + " : " + description;
            }
            sender.sendMessage(ChatColor.AQUA + key + ChatColor.WHITE + " : " + description);
        }
        return true;
    }

    public boolean onWandDescribe(CommandSender sender, Player player, boolean details) {
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand == null) {
            if (sender != player) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_no_item", "$name", player.getName()));
            } else {
                player.sendMessage(this.api.getMessages().get("wand.no_item"));
            }
            return true;
        }
        boolean isWand = false;
        if (this.api.isSpell(itemInHand)) {
            String spellKey = this.api.getSpell(itemInHand);
            sender.sendMessage(ChatColor.GOLD + "Spell: " + spellKey);
            SpellTemplate spell = this.api.getSpellTemplate(spellKey);
            if (spell != null) {
                sender.sendMessage(" " + ChatColor.GOLD + spell.getName());
            } else {
                sender.sendMessage(ChatColor.RED + " (Unknown Spell)");
            }
        } else if (this.api.isBrush(itemInHand)) {
            String brushKey = this.api.getBrush(itemInHand);
            sender.sendMessage(ChatColor.GRAY + "Brush: " + brushKey);
            MaterialAndData brush = new MaterialAndData(brushKey);
            sender.sendMessage(" " + ChatColor.GRAY + brush.getName());
        } else if (this.api.isWand(itemInHand)) {
            isWand = true;
            com.elmakers.mine.bukkit.api.wand.Wand wand = this.api.getWand(itemInHand);
            wand.describe(sender);
        } else {
            details = true;
        }
        if (details) {
            String skullUrl;
            if (isWand) {
                long wandId = System.identityHashCode(NMSUtils.getHandle(itemInHand));
                sender.sendMessage(ChatColor.AQUA + "Id: " + ChatColor.DARK_AQUA + Long.toHexString(wandId));
                com.elmakers.mine.bukkit.api.wand.Wand activeWand = this.api.getMage((CommandSender)player).getActiveWand();
                if (activeWand == null) {
                    if (this.api.isWand(itemInHand) && !this.api.isUpgrade(itemInHand)) {
                        sender.sendMessage(ChatColor.RED + "Mis-match - player has no active wand!");
                    }
                } else {
                    long activeWandId = System.identityHashCode(NMSUtils.getHandle(activeWand.getItem()));
                    if (activeWandId != wandId) {
                        sender.sendMessage(ChatColor.RED + " Mis-match - Active wand id: " + ChatColor.DARK_RED + Long.toHexString(activeWandId));
                    }
                }
            }
            if (itemInHand.getType() == Material.SKULL_ITEM && (skullUrl = InventoryUtils.getSkullURL(itemInHand)) != null) {
                sender.sendMessage(ChatColor.AQUA + "Player skull:");
                sender.sendMessage(skullUrl);
            }
            YamlConfiguration configuration = new YamlConfiguration();
            configuration.set("item", (Object)itemInHand);
            String itemString = configuration.saveToString().replace("item:", "").replace('\u00a7', '&');
            sender.sendMessage(itemString);
        }
        return true;
    }

    public boolean onWandOrganize(CommandSender sender, Player player) {
        if (!this.checkWand(sender, player, true)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        wand.organizeInventory(mage);
        mage.sendMessage(this.api.getMessages().get("wand.reorganized").replace("$wand", wand.getName()));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_reorganized", "$name", player.getName()).replace("$wand", wand.getName()));
        }
        return true;
    }

    public boolean onWandAlphabetize(CommandSender sender, Player player) {
        if (!this.checkWand(sender, player, true)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        wand.alphabetizeInventory();
        mage.sendMessage(this.api.getMessages().get("wand.alphabetized").replace("$wand", wand.getName()));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_alphabetized", "$name", player.getName()).replace("$wand", wand.getName()));
        }
        return true;
    }

    public boolean onWandEnchant(CommandSender sender, Player player, String levelString) {
        if (!this.checkWand(sender, player)) {
            return false;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        int xpLevels = 0;
        boolean useXp = levelString.equalsIgnoreCase("xp");
        if (useXp) {
            xpLevels = mage.getLevel();
        } else {
            try {
                xpLevels = Integer.parseInt(levelString);
            }
            catch (Exception ex) {
                sender.sendMessage("Invalid parameter: " + levelString);
            }
        }
        int levels = wand.enchant(xpLevels);
        if (levels > 0 && useXp) {
            mage.setLevel(Math.max(0, mage.getLevel() - levels));
        }
        if (sender != player) {
            if (levels > 0) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_upgraded", "$name", player.getName()));
            } else {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_not_upgraded", "$name", player.getName()));
            }
        }
        return true;
    }

    public boolean onWandEnchant(CommandSender sender, Player player) {
        Mage mage = this.api.getMage((CommandSender)player);
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        if (heldItem == null || heldItem.getType() == Material.AIR) {
            mage.sendMessage(this.api.getMessages().get("wand.no_item"));
            if (sender != player) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_no_item", "$name", player.getName()));
            }
            return false;
        }
        if (this.api.isWand(heldItem) || this.api.isSpell(heldItem) || this.api.isBrush(heldItem)) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.already_enchanted", "$item", MaterialAndData.getMaterialName(heldItem)));
            return false;
        }
        com.elmakers.mine.bukkit.api.wand.Wand wand = this.api.createWand(heldItem);
        player.getInventory().setItemInMainHand(wand.getItem());
        wand.activate(mage);
        mage.sendMessage(this.api.getMessages().getParameterized("wand.enchanted", "$item", MaterialAndData.getMaterialName(heldItem)));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_enchanted", "$item", MaterialAndData.getMaterialName(heldItem), "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandBind(CommandSender sender, Player player) {
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        wand.bind();
        mage.sendMessage(this.api.getMessages().get("wand.setbound"));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_setbound", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandUnbind(CommandSender sender, Player player) {
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        wand.unbind();
        mage.sendMessage(this.api.getMessages().get("wand.unbound"));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_unbound", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandUnenchant(CommandSender sender, Player player) {
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        if (wand == null || !this.api.isWand(player.getInventory().getItemInMainHand())) {
            mage.sendMessage(this.api.getMessages().get("wand.no_wand"));
            if (sender != player) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_no_wand", "$name", player.getName()));
            }
            return false;
        }
        wand.deactivate();
        wand.unenchant();
        player.getInventory().setItemInMainHand(wand.getItem());
        mage.sendMessage(this.api.getMessages().get("wand.unenchanted"));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_unenchanted", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandDuplicate(CommandSender sender, Player player) {
        if (!this.checkWand(sender, player, false, false)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        com.elmakers.mine.bukkit.api.wand.Wand newWand = wand.duplicate();
        this.api.giveItemToPlayer(player, newWand.getItem());
        mage.sendMessage(this.api.getMessages().get("wand.duplicated"));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_duplicated", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandRestore(CommandSender sender, Player player) {
        Mage mage = this.api.getMage((CommandSender)player);
        if (mage.restoreWand()) {
            mage.sendMessage(this.api.getMessages().get("wand.restored"));
            if (sender != player) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_restored", "$name", player.getName()));
            }
        } else {
            mage.sendMessage(this.api.getMessages().get("wand.not_restored"));
            if (sender != player) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_not_restored", "$name", player.getName()));
            }
        }
        return true;
    }

    public boolean onWandUnlock(CommandSender sender, Player player) {
        if (!this.checkWand(sender, player, true, true, false)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        wand.unlock();
        mage.sendMessage(this.api.getMessages().get("wand.unlocked"));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_unlocked", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandOverride(CommandSender sender, Player player, String[] parameters) {
        if (!this.checkWand(sender, player, true, true, false)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        if (parameters.length == 0) {
            Map<String, String> overrides = wand.getOverrides();
            if (overrides.size() == 0) {
                sender.sendMessage(ChatColor.DARK_AQUA + "This wand has no overrides");
            } else {
                for (Map.Entry<String, String> override : overrides.entrySet()) {
                    sender.sendMessage(ChatColor.AQUA + override.getKey() + ChatColor.WHITE + " = " + ChatColor.DARK_AQUA + override.getValue());
                }
            }
            return true;
        }
        if (!this.checkWand(sender, player)) {
            return true;
        }
        if (parameters.length == 1) {
            wand.removeOverride(parameters[0]);
            sender.sendMessage(ChatColor.DARK_AQUA + "Removed override " + parameters[0]);
            return true;
        }
        String value = "";
        for (int i = 1; i < parameters.length; ++i) {
            if (i != 1) {
                value = value + " ";
            }
            value = value + parameters[i];
        }
        wand.setOverride(parameters[0], value);
        sender.sendMessage(ChatColor.DARK_AQUA + "Added override " + ChatColor.AQUA + parameters[0] + ChatColor.WHITE + " = " + ChatColor.DARK_AQUA + parameters[1]);
        return true;
    }

    public boolean onWandConfigure(CommandSender sender, Player player, String[] parameters, boolean safe) {
        if (parameters.length < 1) {
            sender.sendMessage("Use: /wand configure <property> <value>");
            sender.sendMessage("Properties: " + StringUtils.join(Wand.PROPERTY_KEYS, (String)", "));
            return true;
        }
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        HashMap<String, Object> node = new HashMap<String, Object>();
        String value = "";
        for (int i = 1; i < parameters.length; ++i) {
            if (i != 1) {
                value = value + " ";
            }
            value = value + parameters[i];
        }
        node.put(parameters[0], value);
        wand.deactivate();
        if (safe) {
            wand.upgrade(node);
        } else {
            wand.configure(node);
        }
        wand.activate(mage);
        mage.sendMessage(this.api.getMessages().get("wand.reconfigured"));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_reconfigured", "$name", player.getName()));
        }
        return true;
    }

    protected boolean checkWand(CommandSender sender, Player player) {
        return this.checkWand(sender, player, false, false);
    }

    protected boolean checkWand(CommandSender sender, Player player, boolean skipModifiable) {
        return this.checkWand(sender, player, skipModifiable, false);
    }

    protected boolean checkWand(CommandSender sender, Player player, boolean skipModifiable, boolean skipBound) {
        return this.checkWand(sender, player, skipModifiable, skipBound, false);
    }

    protected boolean checkWand(CommandSender sender, Player player, boolean skipModifiable, boolean skipBound, boolean quiet) {
        boolean bypassLocked;
        Mage mage = this.api.getMage((CommandSender)player);
        if (mage == null) {
            return false;
        }
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        if (wand == null) {
            if (!quiet) {
                mage.sendMessage(this.api.getMessages().get("wand.no_wand"));
            }
            if (sender != player) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_no_wand", "$name", player.getName()));
            }
            return false;
        }
        boolean bl = bypassLocked = sender instanceof Player && this.api.hasPermission(sender, "Magic.wand.override_locked");
        if (!skipModifiable && wand.isLocked() && !bypassLocked) {
            if (!quiet) {
                mage.sendMessage(this.api.getMessages().get("wand.unmodifiable"));
            }
            if (sender != player) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_unmodifiable", "$name", player.getName()));
            }
            return false;
        }
        if (!skipBound && !wand.canUse(mage.getPlayer())) {
            if (!quiet) {
                mage.sendMessage(this.api.getMessages().get("wand.bound_to_other"));
            }
            if (sender != player) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_unmodifiable", "$name", player.getName()));
            }
            return false;
        }
        return true;
    }

    public boolean onWandCombine(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage("Use: /wand combine <wandname>");
            return false;
        }
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        String wandName = parameters[0];
        com.elmakers.mine.bukkit.api.wand.Wand newWand = this.api.createWand(wandName);
        if (newWand == null) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.unknown_template", "$name", wandName));
            return false;
        }
        wand.deactivate();
        boolean result = wand.add(newWand);
        wand.activate(mage);
        if (sender != player) {
            if (result) {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_upgraded", "$name", player.getName()));
            } else {
                sender.sendMessage(this.api.getMessages().getParameterized("wand.player_not_upgraded", "$name", player.getName()));
            }
        }
        return true;
    }

    public boolean onWandFill(CommandSender sender, Player player, int maxLevel) {
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        wand.fill(player, maxLevel);
        mage.sendMessage(this.api.getMessages().get("wand.filled").replace("$wand", wand.getName()));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_filled", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandDelete(CommandSender sender, String wandKey) {
        Player player;
        MageController controller = this.api.getController();
        WandTemplate existing = controller.getWandTemplate(wandKey);
        if (existing == null) {
            sender.sendMessage(ChatColor.RED + "Unknown wand: " + wandKey);
            return true;
        }
        boolean hasPermission = true;
        if (sender instanceof Player && !(player = (Player)sender).hasPermission("Magic.wand.overwrite")) {
            String creatorId;
            hasPermission = player.hasPermission("Magic.wand.overwrite_own") ? (creatorId = existing.getCreatorId()) != null && creatorId.equalsIgnoreCase(player.getUniqueId().toString()) : false;
        }
        if (!hasPermission) {
            sender.sendMessage(ChatColor.RED + "You don't have permission to delete " + wandKey);
            return true;
        }
        File wandFolder = new File(controller.getConfigFolder(), "wands");
        File wandFile = new File(wandFolder, wandKey + ".yml");
        if (!wandFile.exists()) {
            sender.sendMessage(ChatColor.RED + "File doesn't exist: " + wandFile.getName());
            return true;
        }
        wandFile.delete();
        controller.unloadWandTemplate(wandKey);
        sender.sendMessage("Deleted wand " + wandKey);
        return true;
    }

    public boolean onWandSave(CommandSender sender, Player player, String[] parameters) {
        String template;
        if (parameters.length < 1) {
            sender.sendMessage("Use: /wand save <filename>");
            return true;
        }
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        MageController controller = this.api.getController();
        WandTemplate existing = controller.getWandTemplate(template = parameters[0]);
        if (existing != null && !player.hasPermission("Magic.wand.overwrite")) {
            boolean isCreator;
            String creatorId = existing.getCreatorId();
            boolean bl = isCreator = creatorId != null && creatorId.equalsIgnoreCase(player.getUniqueId().toString());
            if (!player.hasPermission("Magic.wand.overwrite_own") || !isCreator) {
                sender.sendMessage(ChatColor.RED + "The " + template + " wand already exists and you don't have permission to overwrite it.");
                return true;
            }
        }
        YamlConfiguration wandConfig = new YamlConfiguration();
        ConfigurationSection wandSection = wandConfig.createSection(template);
        wand.save(wandSection, true);
        wandSection.set("creator_id", (Object)player.getUniqueId().toString());
        wandSection.set("creator", (Object)player.getName());
        File wandFolder = new File(controller.getConfigFolder(), "wands");
        File wandFile = new File(wandFolder, template + ".yml");
        wandFolder.mkdirs();
        try {
            wandConfig.save(wandFile);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            sender.sendMessage(ChatColor.RED + "Can't write to file " + wandFile.getName());
            return true;
        }
        controller.loadWandTemplate(template, wandSection);
        String message = "Wand saved as " + template;
        if (existing != null) {
            message = message + ChatColor.GOLD + " (Replaced Existing)";
        }
        sender.sendMessage(message);
        return true;
    }

    public boolean onWandAdd(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage("Use: /wand add <spell|material> [material:data]");
            return true;
        }
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        Messages messages = this.api.getMessages();
        String spellName = parameters[0];
        if (spellName.equals("material")) {
            if (parameters.length < 2) {
                sender.sendMessage("Use: /wand add material <material:data>");
                return true;
            }
            String materialKey = parameters[1];
            if (!MaterialBrush.isValidMaterial(materialKey, false)) {
                sender.sendMessage(materialKey + " is not a valid material");
                return true;
            }
            if (wand.addBrush(materialKey)) {
                wand.setActiveBrush(materialKey);
                mage.sendMessage(messages.get("wand.brush_added").replace("$wand", wand.getName()).replace("$name", MaterialBrush.getMaterialName(messages, materialKey)));
                if (sender != player) {
                    sender.sendMessage("Added material '" + materialKey + "' to " + player.getName() + "'s wand");
                }
            } else {
                wand.setActiveBrush(materialKey);
                mage.sendMessage("Material activated: " + materialKey);
                if (sender != player) {
                    sender.sendMessage(player.getName() + "'s wand already has material " + materialKey);
                }
            }
            return true;
        }
        MageSpell spell = mage.getSpell(spellName);
        if (spell == null) {
            sender.sendMessage("Spell '" + spellName + "' unknown, Use /spells for spell list");
            return true;
        }
        SpellTemplate currentSpell = wand.getBaseSpell(spellName);
        if (wand.addSpell(spellName)) {
            wand.setActiveSpell(spellName);
            if (currentSpell != null) {
                String levelDescription = spell.getLevelDescription();
                if (levelDescription == null || levelDescription.isEmpty()) {
                    levelDescription = spell.getName();
                }
                mage.sendMessage(this.api.getMessages().get("wand.spell_upgraded").replace("$name", currentSpell.getName()).replace("$level", levelDescription));
                if (sender != player) {
                    sender.sendMessage(this.api.getMessages().get("wand.player_spell_upgraded").replace("$player", player.getName()).replace("$name", currentSpell.getName()).replace("$level", levelDescription));
                }
            } else {
                mage.sendMessage(messages.get("wand.spell_added").replace("$name", spellName).replace("$wand", wand.getName()));
                if (sender != player) {
                    sender.sendMessage("Added '" + spell.getName() + "' to " + player.getName() + "'s wand");
                }
            }
        } else {
            wand.setActiveSpell(spellName);
            mage.sendMessage(spell.getName() + " activated");
            if (sender != player) {
                sender.sendMessage(player.getName() + "'s wand already has " + spell.getName());
            }
        }
        return true;
    }

    public boolean onWandRemove(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage("Use: /wand remove <spell|material> [material:data]");
            return true;
        }
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        String spellName = parameters[0];
        if (spellName.equals("material")) {
            if (parameters.length < 2) {
                sender.sendMessage("Use: /wand remove material <material:data>");
                return true;
            }
            String materialKey = parameters[1];
            if (wand.removeBrush(materialKey)) {
                mage.sendMessage("Material '" + materialKey + "' has been removed from your wand");
                if (sender != player) {
                    sender.sendMessage("Removed material '" + materialKey + "' from " + player.getName() + "'s wand");
                }
            } else if (sender != player) {
                sender.sendMessage(player.getName() + "'s wand does not have material " + materialKey);
            }
            return true;
        }
        if (wand.removeSpell(spellName)) {
            SpellTemplate template = this.api.getSpellTemplate(spellName);
            if (template != null) {
                spellName = template.getName();
            }
            mage.sendMessage("Spell '" + spellName + "' has been removed from your wand");
            if (sender != player) {
                sender.sendMessage("Removed '" + spellName + "' from " + player.getName() + "'s wand");
            }
        } else if (sender != player) {
            sender.sendMessage(player.getName() + "'s wand does not have " + spellName);
        }
        return true;
    }

    public boolean onWandName(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage("Use: /wand name <name>");
            return true;
        }
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.api.getMage((CommandSender)player);
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        wand.setName(StringUtils.join((Object[])parameters, (String)" "));
        mage.sendMessage(this.api.getMessages().get("wand.renamed"));
        if (sender != player) {
            sender.sendMessage(this.api.getMessages().getParameterized("wand.player_renamed", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWand(CommandSender sender, Player player, String[] parameters) {
        String wandName = null;
        if (parameters.length > 0) {
            wandName = parameters[0];
        }
        return this.giveWand(sender, player, wandName, false, true, false, false);
    }
}

