/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SpellProgressAction
extends BaseSpellAction
implements GUIAction {
    private CastContext context;

    @Override
    public void deactivated() {
    }

    @Override
    public void dragged(InventoryDragEvent event) {
        event.setCancelled(true);
    }

    @Override
    public void clicked(InventoryClickEvent event) {
        event.setCancelled(true);
        if (this.context != null) {
            Mage mage = this.context.getMage();
            com.elmakers.mine.bukkit.api.wand.Wand wand = this.context.getWand();
            ItemStack item = event.getCurrentItem();
            if (wand != null && Wand.isSpell(item)) {
                String spellKey = Wand.getSpell(item);
                SpellKey upgradeKey = new SpellKey(spellKey);
                wand.setActiveSpell(upgradeKey.getBaseKey());
            }
            mage.deactivateGUI();
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Mage mage = context.getMage();
        com.elmakers.mine.bukkit.api.wand.Wand wand = context.getWand();
        this.context = context;
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        if (wand == null) {
            return SpellResult.FAIL;
        }
        Collection<String> spells = wand.getSpells();
        ArrayList<ItemStack> upgrades = new ArrayList<ItemStack>();
        Messages messages = context.getController().getMessages();
        for (String spellKey : spells) {
            long castCount;
            ItemStack spellItem;
            MageSpell spell = mage.getSpell(spellKey);
            SpellTemplate upgradeSpell = spell.getUpgrade();
            if (upgradeSpell == null || (spellItem = MagicPlugin.getAPI().createSpellItem(upgradeSpell.getKey())) == null) continue;
            long requiredCastCount = spell.getRequiredUpgradeCasts();
            String requiredPathKey = spell.getRequiredUpgradePath();
            Set<String> requiredPathTags = spell.getRequiredUpgradeTags();
            ItemMeta meta = spellItem.getItemMeta();
            ArrayList<String> lore = new ArrayList<String>();
            String levelDescription = upgradeSpell.getLevelDescription();
            if (levelDescription == null || levelDescription.isEmpty()) {
                levelDescription = upgradeSpell.getName();
            }
            lore.add(levelDescription);
            String upgradeDescription = upgradeSpell.getUpgradeDescription();
            if (upgradeDescription != null && !upgradeDescription.isEmpty()) {
                InventoryUtils.wrapText(upgradeDescription, BaseSpell.MAX_LORE_LENGTH, lore);
            }
            com.elmakers.mine.bukkit.api.wand.WandUpgradePath currentPath = wand.getPath();
            if (requiredPathKey != null && currentPath == null) continue;
            if (!upgradeSpell.getName().equals(spell.getName())) {
                lore.add(context.getMessage("upgrade_name_change", "&r&4Upgrades: &r$name").replace("$name", spell.getName()));
            }
            if (requiredPathKey != null && !currentPath.hasPath(requiredPathKey)) {
                WandUpgradePath upgradePath = WandUpgradePath.getPath(requiredPathKey = currentPath.translatePath(requiredPathKey));
                if (upgradePath == null) continue;
                lore.add(context.getMessage("level_requirement").replace("$path", upgradePath.getName()));
            }
            if (requiredPathTags != null && !requiredPathTags.isEmpty() && !currentPath.hasAllTags(requiredPathTags)) {
                Set<String> tags = currentPath.getMissingTags(requiredPathTags);
                lore.add(context.getMessage("tags_requirement").replace("$tags", messages.formatList("tags", tags, "name")));
            }
            if ((castCount = Math.min(spell.getCastCount(), requiredCastCount)) == requiredCastCount) {
                lore.add(ChatColor.GREEN + context.getMessage("cast_requirement").replace("$current", Long.toString(castCount)).replace("$required", Long.toString(requiredCastCount)));
            } else {
                lore.add(ChatColor.RED + context.getMessage("cast_requirement").replace("$current", Long.toString(castCount)).replace("$required", Long.toString(requiredCastCount)));
            }
            meta.setLore(lore);
            spellItem.setItemMeta(meta);
            upgrades.add(spellItem);
        }
        String inventoryTitle = context.getMessage("title", "Spell Upgrades");
        int invSize = (upgrades.size() + 9) / 9 * 9;
        Inventory displayInventory = CompatibilityUtils.createInventory(null, invSize, inventoryTitle);
        for (ItemStack item : upgrades) {
            displayInventory.addItem(new ItemStack[]{item});
        }
        mage.activateGUI(this, displayInventory);
        return SpellResult.CAST;
    }
}

