/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.heroes.HeroesManager;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class SkillsSelector
implements GUIAction {
    private int page;
    private List<SkillDescription> allSkills = new ArrayList<SkillDescription>();
    private final MagicAPI api;
    private final Player player;
    private String inventoryTitle;

    public SkillsSelector(MagicAPI api, Player player) {
        this.api = api;
        this.player = player;
    }

    public void show(int page) {
        this.page = page;
        MageController apiController = this.api.getController();
        if (!(apiController instanceof MagicController)) {
            return;
        }
        MagicController controller = (MagicController)apiController;
        Messages messages = controller.getMessages();
        HeroesManager heroes = controller.getHeroes();
        this.allSkills.clear();
        if (controller.useHeroesSkills() && heroes != null) {
            String classString = heroes.getClassName(this.player);
            String class2String = heroes.getSecondaryClassName(this.player);
            String messageKey = !class2String.isEmpty() ? "skills.inventory_title_secondary" : "skills.inventory_title";
            this.inventoryTitle = this.api.getMessages().get(messageKey, "Skills ($page/$pages)");
            this.inventoryTitle = this.inventoryTitle.replace("$class2", class2String).replace("$class", classString);
            List<String> heroesSkills = heroes.getSkillList(this.player, true, true);
            for (String heroesSkill : heroesSkills) {
                this.allSkills.add(new SkillDescription(null, heroesSkill));
            }
        } else {
            this.inventoryTitle = messages.get("skills.inventory_title");
        }
        if (controller.usePermissionSkills()) {
            boolean bypassHidden = this.player.hasPermission("Magic.bypass_hidden");
            Collection<SpellTemplate> spells = controller.getSpellTemplates(bypassHidden);
            for (SpellTemplate spell : spells) {
                SpellKey key = spell.getSpellKey();
                if (key.isVariant() || key.getBaseKey().startsWith("heroes*") || !spell.hasCastPermission((CommandSender)this.player)) continue;
                this.allSkills.add(new SkillDescription(spell, null));
            }
        }
        if (this.allSkills.size() == 0) {
            this.player.sendMessage(messages.get("skills.none"));
            return;
        }
        Collections.sort(this.allSkills);
        this.openInventory();
    }

    protected void openInventory() {
        MageController apiController = this.api.getController();
        if (!(apiController instanceof MagicController)) {
            return;
        }
        MagicController controller = (MagicController)apiController;
        HeroesManager heroes = controller.getHeroes();
        int inventorySize = 9 * controller.getSkillInventoryRows();
        int numPages = (int)Math.ceil((float)this.allSkills.size() / (float)inventorySize);
        if (this.page < 1) {
            this.page = numPages;
        } else if (this.page > numPages) {
            this.page = 1;
        }
        Mage mage = controller.getMage(this.player);
        int pageIndex = this.page - 1;
        int startIndex = pageIndex * inventorySize;
        int maxIndex = (pageIndex + 1) * inventorySize - 1;
        ArrayList<SkillDescription> skills = new ArrayList<SkillDescription>();
        for (int i = startIndex; i <= maxIndex && i < this.allSkills.size(); ++i) {
            skills.add(this.allSkills.get(i));
        }
        if (skills.size() == 0) {
            String messageTemplate = controller.getMessages().get("skills.none_on_page", "$page");
            this.player.sendMessage(messageTemplate.replace("$page", Integer.toString(this.page)));
            return;
        }
        int invSize = (int)Math.ceil((float)skills.size() / 9.0f) * 9;
        String title = this.inventoryTitle;
        title = title.replace("$pages", Integer.toString(numPages)).replace("$page", Integer.toString(this.page));
        Inventory displayInventory = CompatibilityUtils.createInventory(null, invSize, title);
        for (SkillDescription skill : skills) {
            ItemStack skillItem = this.api.createItem(skill.getSpellKey(), mage);
            if (skillItem == null) continue;
            if (skill.isHeroes() && heroes != null && !heroes.canUseSkill(this.player, skill.heroesSkill)) {
                String nameTemplate = controller.getMessages().get("skills.item_name_unavailable", "$skill");
                CompatibilityUtils.setDisplayName(skillItem, nameTemplate.replace("$skill", skill.heroesSkill));
                skillItem.setAmount(99);
            }
            displayInventory.addItem(new ItemStack[]{skillItem});
        }
        mage.deactivateGUI();
        mage.activateGUI(this, displayInventory);
    }

    @Override
    public void deactivated() {
    }

    @Override
    public void clicked(InventoryClickEvent event) {
        InventoryAction action = event.getAction();
        if (action == InventoryAction.NOTHING) {
            int direction = event.getClick() == ClickType.LEFT ? 1 : -1;
            this.page += direction;
            this.openInventory();
            event.setCancelled(true);
            return;
        }
        com.elmakers.mine.bukkit.api.magic.Mage mage = this.api.getMage((CommandSender)this.player);
        if (action == InventoryAction.PICKUP_HALF && mage != null) {
            ItemStack clickedItem = event.getCurrentItem();
            MageSpell spell = mage.getSpell(Wand.getSpell(clickedItem));
            if (spell != null) {
                spell.cast();
            }
            this.player.closeInventory();
            event.setCancelled(true);
        }
    }

    @Override
    public void dragged(InventoryDragEvent event) {
    }

    class SkillDescription
    implements Comparable<SkillDescription> {
        public String heroesSkill;
        public SpellTemplate spell;

        public SkillDescription(SpellTemplate spell, String heroesSkill) {
            this.heroesSkill = heroesSkill;
            this.spell = spell;
        }

        public String getSpellKey() {
            if (this.spell != null) {
                return "skill:" + this.spell.getKey();
            }
            return "skill:heroes*" + this.heroesSkill;
        }

        public String getSpellName() {
            if (this.spell != null) {
                return this.spell.getName();
            }
            return this.heroesSkill;
        }

        public boolean isHeroes() {
            return this.heroesSkill != null;
        }

        @Override
        public int compareTo(SkillDescription other) {
            return this.getSpellName().compareTo(other.getSpellName());
        }
    }
}

