/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class DamageAction
extends BaseSpellAction {
    private double entityDamage;
    private double playerDamage;
    private double elementalDamage;
    private boolean magicDamage;
    private boolean magicEntityDamage;
    private Double percentage;
    private Double knockbackResistance;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        double damage = parameters.getDouble("damage", 1.0);
        this.entityDamage = parameters.getDouble("entity_damage", damage);
        this.playerDamage = parameters.getDouble("player_damage", damage);
        this.elementalDamage = parameters.getDouble("elemental_damage", damage);
        this.percentage = parameters.contains("percentage") ? Double.valueOf(parameters.getDouble("percentage")) : null;
        this.magicDamage = parameters.getBoolean("magic_damage", true);
        this.magicEntityDamage = parameters.getBoolean("magic_entity_damage", true);
        this.knockbackResistance = parameters.contains("knockback_resistance") ? Double.valueOf(parameters.getDouble("knockback_resistance")) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpellResult perform(CastContext context) {
        AttributeInstance knockBackAttribute;
        Entity entity = context.getTargetEntity();
        if (entity == null || !(entity instanceof Damageable) || entity.isDead()) {
            return SpellResult.NO_TARGET;
        }
        double damage = 1.0;
        Damageable targetEntity = (Damageable)entity;
        LivingEntity livingTarget = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        context.registerDamaged((Entity)targetEntity);
        Mage mage = context.getMage();
        MageController controller = context.getController();
        double previousKnockbackResistance = 0.0;
        try {
            if (this.knockbackResistance != null && livingTarget != null) {
                knockBackAttribute = livingTarget.getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE);
                previousKnockbackResistance = knockBackAttribute.getBaseValue();
                knockBackAttribute.setBaseValue(this.knockbackResistance.doubleValue());
            }
            if (controller.isElemental(entity)) {
                damage = this.elementalDamage;
                controller.damageElemental(entity, damage * (double)mage.getDamageMultiplier(), 0, mage.getCommandSender());
            } else {
                damage = this.percentage != null ? this.percentage * targetEntity.getMaxHealth() : (targetEntity instanceof Player ? this.playerDamage : this.entityDamage);
                damage *= (double)mage.getDamageMultiplier();
                if (this.magicDamage && (this.magicEntityDamage || targetEntity instanceof Player)) {
                    CompatibilityUtils.magicDamage(targetEntity, damage, mage.getEntity());
                } else {
                    CompatibilityUtils.damage(targetEntity, damage, mage.getEntity());
                }
            }
        }
        finally {
            if (this.knockbackResistance != null && livingTarget != null) {
                knockBackAttribute = livingTarget.getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE);
                knockBackAttribute.setBaseValue(previousKnockbackResistance);
            }
        }
        return SpellResult.CAST;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("damage");
        parameters.add("player_damage");
        parameters.add("entity_damage");
        parameters.add("elemental_damage");
        parameters.add("magic_damage");
        parameters.add("percentage");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("damage") || parameterKey.equals("player_damage") || parameterKey.equals("entity_damage") || parameterKey.equals("elemental_damage")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("magic_damage")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("percentage")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_PERCENTAGES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }
}

