/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.block.BrushMode;
import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.event.AddSpellEvent;
import com.elmakers.mine.bukkit.api.event.SpellUpgradeEvent;
import com.elmakers.mine.bukkit.api.event.WandActivatedEvent;
import com.elmakers.mine.bukkit.api.event.WandPreActivateEvent;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.CastingCost;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.WandTemplate;
import com.elmakers.mine.bukkit.effect.SoundEffect;
import com.elmakers.mine.bukkit.effect.builtin.EffectRing;
import com.elmakers.mine.bukkit.heroes.HeroesManager;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.utility.ColorHD;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.wand.LostWand;
import com.elmakers.mine.bukkit.wand.UnknownWandException;
import com.elmakers.mine.bukkit.wand.WandAction;
import com.elmakers.mine.bukkit.wand.WandLevel;
import com.elmakers.mine.bukkit.wand.WandManaMode;
import com.elmakers.mine.bukkit.wand.WandMode;
import com.elmakers.mine.bukkit.wand.WandOrganizer;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class Wand
implements CostReducer,
com.elmakers.mine.bukkit.api.wand.Wand {
    public static final int INVENTORY_SIZE = 27;
    public static final int PLAYER_INVENTORY_SIZE = 36;
    public static final int HOTBAR_SIZE = 9;
    public static final int HOTBAR_INVENTORY_SIZE = 8;
    public static final float DEFAULT_SPELL_COLOR_MIX_WEIGHT = 1.0E-4f;
    public static final float DEFAULT_WAND_COLOR_MIX_WEIGHT = 1.0f;
    public static int MAX_LORE_LENGTH = 24;
    public static String DEFAULT_WAND_TEMPLATE = "default";
    public static final String[] EMPTY_PARAMETERS = new String[0];
    public static final String[] PROPERTY_KEYS = new String[]{"active_spell", "active_material", "path", "template", "passive", "mana", "mana_regeneration", "mana_max", "mana_max_boost", "mana_regeneration_boost", "mana_per_damage", "bound", "soul", "has_uses", "uses", "upgrade", "indestructible", "undroppable", "consume_reduction", "cost_reduction", "cooldown_reduction", "effect_bubbles", "effect_color", "effect_particle", "effect_particle_count", "effect_particle_data", "effect_particle_interval", "effect_particle_min_velocity", "effect_particle_radius", "effect_particle_offset", "effect_sound", "effect_sound_interval", "effect_sound_pitch", "effect_sound_volume", "cast_spell", "cast_parameters", "cast_interval", "cast_min_velocity", "cast_velocity_direction", "hotbar_count", "hotbar", "icon", "icon_inactive", "icon_inactive_delay", "mode", "brush_mode", "keep", "locked", "quiet", "force", "randomize", "rename", "rename_description", "power", "overrides", "protection", "protection_physical", "protection_projectiles", "protection_falling", "protection_fire", "protection_explosions", "potion_effects", "materials", "spells", "powered", "protected", "heroes", "enchant_count", "max_enchant_count", "quick_cast", "left_click", "right_click", "drop", "swap"};
    public static final String[] HIDDEN_PROPERTY_KEYS = new String[]{"id", "owner", "owner_id", "name", "description", "organize", "alphabetize", "fill", "stored", "upgrade_icon", "mana_timestamp", "upgrade_template", "haste", "health_regeneration", "hunger_regeneration", "xp", "xp_regeneration", "xp_max", "xp_max_boost", "xp_regeneration_boost", "mode_cast", "mode_drop"};
    public static final String[] ALL_PROPERTY_KEYS = (String[])ArrayUtils.addAll((Object[])PROPERTY_KEYS, (Object[])HIDDEN_PROPERTY_KEYS);
    protected ItemStack item;
    protected MagicController controller;
    protected Mage mage;
    private String id = "";
    private List<Inventory> hotbars;
    private List<Inventory> inventories;
    private Map<String, Integer> spells = new HashMap<String, Integer>();
    private Map<String, Integer> spellLevels = new HashMap<String, Integer>();
    private Map<String, Integer> brushes = new HashMap<String, Integer>();
    private String activeSpell = "";
    private String activeMaterial = "";
    protected String wandName = "";
    protected String description = "";
    private String owner = "";
    private String ownerId = "";
    private String template = "";
    private String path = "";
    private boolean superProtected = false;
    private boolean superPowered = false;
    private boolean glow = false;
    private boolean soul = false;
    private boolean bound = false;
    private boolean indestructible = false;
    private boolean undroppable = false;
    private boolean keep = false;
    private boolean passive = false;
    private boolean autoOrganize = false;
    private boolean autoAlphabetize = false;
    private boolean autoFill = false;
    private boolean isUpgrade = false;
    private boolean randomize = false;
    private boolean rename = false;
    private boolean renameDescription = false;
    private boolean quickCast = false;
    private boolean quickCastDisabled = false;
    private boolean manualQuickCastDisabled = false;
    private WandAction leftClickAction = WandAction.CAST;
    private WandAction rightClickAction = WandAction.TOGGLE;
    private WandAction dropAction = WandAction.CYCLE_HOTBAR;
    private WandAction swapAction = WandAction.NONE;
    private com.elmakers.mine.bukkit.block.MaterialAndData icon = null;
    private com.elmakers.mine.bukkit.block.MaterialAndData upgradeIcon = null;
    private com.elmakers.mine.bukkit.block.MaterialAndData inactiveIcon = null;
    private int inactiveIconDelay = 0;
    private String upgradeTemplate = null;
    protected float costReduction = 0.0f;
    protected float consumeReduction = 0.0f;
    protected float cooldownReduction = 0.0f;
    protected float damageReduction = 0.0f;
    protected float damageReductionPhysical = 0.0f;
    protected float damageReductionProjectiles = 0.0f;
    protected float damageReductionFalling = 0.0f;
    protected float damageReductionFire = 0.0f;
    protected float damageReductionExplosions = 0.0f;
    private float power = 0.0f;
    private int maxEnchantCount = 0;
    private int enchantCount = 0;
    private boolean hasInventory = false;
    private boolean locked = false;
    private boolean forceUpgrade = false;
    private boolean isHeroes = false;
    private int uses = 0;
    private boolean hasUses = false;
    private boolean isSingleUse = false;
    private float mana = 0.0f;
    private float manaMaxBoost = 0.0f;
    private float manaRegenerationBoost = 0.0f;
    private int manaRegeneration = 0;
    private int manaMax = 0;
    private long lastManaRegeneration = 0L;
    private float manaPerDamage = 0.0f;
    private int effectiveManaMax = 0;
    private int effectiveManaRegeneration = 0;
    private ColorHD effectColor = null;
    private float effectColorSpellMixWeight = 1.0E-4f;
    private float effectColorMixWeight = 1.0f;
    private ParticleEffect effectParticle = null;
    private float effectParticleData = 0.0f;
    private int effectParticleCount = 0;
    private int effectParticleInterval = 0;
    private double effectParticleMinVelocity = 0.0;
    private double effectParticleRadius = 0.2;
    private double effectParticleOffset = 0.3;
    private boolean effectBubbles = false;
    private EffectRing effectPlayer = null;
    private int castInterval = 0;
    private double castMinVelocity = 0.0;
    private Vector castVelocityDirection = null;
    private String castSpell = null;
    private ConfigurationSection castParameters = null;
    private Map<PotionEffectType, Integer> potionEffects = new HashMap<PotionEffectType, Integer>();
    private SoundEffect effectSound = null;
    private int effectSoundInterval = 0;
    private int quietLevel = 0;
    private Map<String, String> castOverrides = null;
    private boolean effectBubblesApplied = false;
    private boolean hasSpellProgression = false;
    private long lastLocationTime;
    private Vector lastLocation;
    private long lastSoundEffect;
    private long lastParticleEffect;
    private long lastSpellCast;
    private WandMode mode = null;
    private WandMode brushMode = null;
    private int openInventoryPage = 0;
    private boolean inventoryIsOpen = false;
    private Inventory displayInventory = null;
    private int currentHotbar = 0;
    private boolean suspendSave = false;
    public static WandManaMode manaMode = WandManaMode.BAR;
    public static WandManaMode spMode = WandManaMode.NUMBER;
    public static boolean regenWhileInactive = true;
    public static Material DefaultUpgradeMaterial = Material.NETHER_STAR;
    public static Material DefaultWandMaterial = Material.BLAZE_ROD;
    public static Material EnchantableWandMaterial = null;
    public static boolean SpellGlow = false;
    public static boolean BrushGlow = false;
    public static boolean BrushItemGlow = true;
    public static boolean LiveHotbar = true;
    public static boolean LiveHotbarCooldown = true;
    public static boolean Unbreakable = false;
    public static boolean Undroppable = true;
    public static SoundEffect inventoryOpenSound = null;
    public static SoundEffect inventoryCloseSound = null;
    public static SoundEffect inventoryCycleSound = null;
    public static SoundEffect noActionSound = null;
    public static String WAND_KEY = "wand";
    public static String WAND_SELF_DESTRUCT_KEY = null;
    public static byte HIDE_FLAGS = (byte)60;
    public static String brushSelectSpell = "";
    private Inventory storedInventory = null;
    private int storedSlot;

    public Wand(MagicController controller, ItemStack itemStack) {
        this.controller = controller;
        this.wandName = controller.getMessages().get("wand.default_name");
        this.hotbars = new ArrayList<Inventory>();
        this.setHotbarCount(1);
        if (itemStack.getType() == Material.AIR) {
            itemStack.setType(DefaultWandMaterial);
        }
        this.icon = new com.elmakers.mine.bukkit.block.MaterialAndData(itemStack);
        this.inventories = new ArrayList<Inventory>();
        this.item = itemStack;
        this.loadState();
        this.updateName();
        this.updateLore();
    }

    protected void setHotbarCount(int count) {
        this.hotbars.clear();
        while (this.hotbars.size() < count) {
            this.hotbars.add(CompatibilityUtils.createInventory(null, 8, "Wand"));
        }
        while (this.hotbars.size() > count) {
            this.hotbars.remove(0);
        }
    }

    public Wand(MagicController controller) {
        this(controller, DefaultWandMaterial, 0);
    }

    public Wand(MagicController controller, ConfigurationSection config) {
        this(controller, DefaultWandMaterial, 0);
        this.loadProperties(config);
        this.updateName();
        this.updateLore();
        this.saveItemState();
    }

    protected Wand(MagicController controller, String templateName) throws UnknownWandException {
        this(controller);
        ConfigurationSection wandConfig;
        WandTemplate template;
        this.suspendSave = true;
        String wandName = controller.getMessages().get("wand.default_name");
        String wandDescription = "";
        if (templateName == null || templateName.length() == 0) {
            templateName = DEFAULT_WAND_TEMPLATE;
        }
        int level = 0;
        if (templateName.contains("(")) {
            String levelString = templateName.substring(templateName.indexOf(40) + 1, templateName.length() - 1);
            try {
                level = Integer.parseInt(levelString);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
            templateName = templateName.substring(0, templateName.indexOf(40));
        }
        if ((template = controller.getWandTemplate(templateName)) == null) {
            throw new UnknownWandException(templateName);
        }
        WandTemplate migrateTemplate = template.getMigrateTemplate();
        if (migrateTemplate != null) {
            template = migrateTemplate;
            templateName = migrateTemplate.getKey();
        }
        if ((wandConfig = template.getConfiguration()) == null) {
            throw new UnknownWandException(templateName);
        }
        wandName = wandConfig.getString("name", wandName);
        wandName = controller.getMessages().get("wands." + templateName + ".name", wandName);
        wandDescription = wandConfig.getString("description", wandDescription);
        wandDescription = controller.getMessages().get("wands." + templateName + ".description", wandDescription);
        this.loadProperties(wandConfig);
        InventoryUtils.applyEnchantments(this.item, wandConfig.getConfigurationSection("enchantments"));
        if (level > 0) {
            boolean wasLocked = this.locked;
            this.locked = false;
            this.randomize(level, false, null, true);
            this.locked = wasLocked;
        }
        this.setDescription(wandDescription);
        this.setName(wandName);
        if (!this.randomize) {
            this.randomize();
        }
        this.setTemplate(templateName);
        this.suspendSave = false;
        this.saveItemState();
    }

    public Wand(MagicController controller, Material icon, short iconData) {
        this(controller, InventoryUtils.makeReal(new ItemStack(icon, 1, iconData)));
        this.saveItemState();
        this.updateName();
    }

    @Override
    public void unenchant() {
        this.item = new ItemStack(this.item.getType(), 1, this.item.getDurability());
    }

    public void setIcon(Material material, byte data) {
        this.setIcon(material == null ? null : new com.elmakers.mine.bukkit.block.MaterialAndData(material, data));
    }

    public void updateIcon() {
        this.setIcon(this.icon);
    }

    @Override
    public void setIcon(MaterialAndData materialData) {
        if (materialData instanceof com.elmakers.mine.bukkit.block.MaterialAndData) {
            this.setIcon((com.elmakers.mine.bukkit.block.MaterialAndData)materialData);
        } else {
            this.setIcon(new com.elmakers.mine.bukkit.block.MaterialAndData(materialData));
        }
    }

    public void setIcon(com.elmakers.mine.bukkit.block.MaterialAndData materialData) {
        if (materialData == null || !materialData.isValid()) {
            return;
        }
        if (materialData.getMaterial() == Material.AIR || materialData.getMaterial() == null) {
            materialData.setMaterial(DefaultWandMaterial);
        }
        this.icon = materialData;
        if (this.icon != null) {
            Short durability = null;
            if (!this.indestructible && !this.isUpgrade && this.icon.getMaterial().getMaxDurability() > 0) {
                durability = this.item.getDurability();
            }
            try {
                if (this.inactiveIcon == null || this.mage != null && this.getMode() == WandMode.INVENTORY && this.isInventoryOpen()) {
                    this.icon.applyToItem(this.item);
                } else {
                    this.inactiveIcon.applyToItem(this.item);
                }
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.WARNING, "Unable to apply wand icon", ex);
                this.item.setType(DefaultWandMaterial);
            }
            if (durability != null) {
                this.item.setDurability(durability.shortValue());
            }
        }
        if ((this.indestructible || Unbreakable || this.isUpgrade) && !manaMode.useDurability()) {
            CompatibilityUtils.makeUnbreakable(this.item);
        } else {
            CompatibilityUtils.removeUnbreakable(this.item);
        }
        CompatibilityUtils.hideFlags(this.item, HIDE_FLAGS);
    }

    @Override
    public void makeUpgrade() {
        if (!this.isUpgrade) {
            this.isUpgrade = true;
            String oldName = this.wandName;
            this.wandName = this.controller.getMessages().get("wand.upgrade_name");
            this.wandName = this.wandName.replace("$name", oldName);
            this.description = this.controller.getMessages().get("wand.upgrade_default_description");
            if (this.template != null && this.template.length() > 0) {
                this.description = this.controller.getMessages().get("wands." + this.template + ".upgrade_description", this.description);
            }
            this.setIcon(DefaultUpgradeMaterial, (byte)0);
            this.saveItemState();
            this.updateName(true);
            this.updateLore();
        }
    }

    public void newId() {
        this.id = !this.isUpgrade && !this.isSingleUse ? UUID.randomUUID().toString() : null;
    }

    public void checkId() {
        if (!(this.id != null && this.id.length() != 0 || this.isUpgrade)) {
            this.newId();
            this.saveItemState();
        }
    }

    @Override
    public String getId() {
        return this.isSingleUse ? this.template : this.id;
    }

    public float getManaRegenerationBoost() {
        return this.manaRegenerationBoost;
    }

    public float getManaMaxBoost() {
        return this.manaMaxBoost;
    }

    @Override
    public int getManaRegeneration() {
        return this.manaRegeneration;
    }

    @Override
    public int getManaMax() {
        return this.manaMax;
    }

    @Override
    public void setMana(float mana) {
        this.mana = Math.max(0.0f, mana);
    }

    @Override
    public void setManaMax(int manaMax) {
        this.manaMax = Math.max(0, manaMax);
    }

    @Override
    public float getMana() {
        return this.mana;
    }

    @Override
    public void removeMana(float amount) {
        HeroesManager heroes;
        if (this.isHeroes && this.mage != null && (heroes = this.controller.getHeroes()) != null) {
            heroes.removeMana(this.mage.getPlayer(), (int)Math.ceil(amount));
        }
        this.mana = Math.max(0.0f, this.mana - amount);
        this.updateMana();
    }

    public boolean isModifiable() {
        return !this.locked;
    }

    @Override
    public boolean isIndestructible() {
        return this.indestructible;
    }

    @Override
    public boolean isUndroppable() {
        return this.undroppable || this.isInventoryOpen();
    }

    public boolean isUpgrade() {
        return this.isUpgrade;
    }

    public boolean usesMana() {
        if (this.isCostFree()) {
            return false;
        }
        return this.manaMax > 0 || this.isHeroes;
    }

    @Override
    public float getCooldownReduction() {
        return this.controller.getCooldownReduction() + this.cooldownReduction * this.controller.getMaxCooldownReduction();
    }

    @Override
    public float getCostReduction() {
        if (this.isCostFree()) {
            return 1.0f;
        }
        return this.controller.getCostReduction() + this.costReduction * this.controller.getMaxCostReduction();
    }

    @Override
    public float getConsumeReduction() {
        return this.consumeReduction;
    }

    @Override
    public float getCostScale() {
        return 1.0f;
    }

    public void setCooldownReduction(float reduction) {
        this.cooldownReduction = reduction;
    }

    public boolean getHasInventory() {
        return this.hasInventory;
    }

    @Override
    public float getPower() {
        return this.power;
    }

    @Override
    public boolean isSuperProtected() {
        return this.superProtected;
    }

    @Override
    public boolean isSuperPowered() {
        return this.superPowered;
    }

    @Override
    public boolean isCostFree() {
        return this.costReduction > 1.0f;
    }

    @Override
    public boolean isConsumeFree() {
        return this.consumeReduction >= 1.0f;
    }

    @Override
    public boolean isCooldownFree() {
        return this.cooldownReduction > 1.0f;
    }

    public float getDamageReduction() {
        return this.damageReduction;
    }

    public float getDamageReductionPhysical() {
        return this.damageReductionPhysical;
    }

    public float getDamageReductionProjectiles() {
        return this.damageReductionProjectiles;
    }

    public float getDamageReductionFalling() {
        return this.damageReductionFalling;
    }

    public float getDamageReductionFire() {
        return this.damageReductionFire;
    }

    public float getDamageReductionExplosions() {
        return this.damageReductionExplosions;
    }

    @Override
    public String getName() {
        return this.wandName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    @Override
    public long getWorth() {
        long worth = 0L;
        Collection spells = this.getSpells();
        for (String spellKey : spells) {
            SpellTemplate spell = this.controller.getSpellTemplate(spellKey);
            if (spell == null) continue;
            worth = (long)((double)worth + spell.getWorth());
        }
        return worth;
    }

    @Override
    public void setName(String name) {
        this.wandName = ChatColor.stripColor((String)name);
        this.updateName();
    }

    public void setTemplate(String templateName) {
        this.template = templateName;
    }

    @Override
    public String getTemplateKey() {
        return this.template;
    }

    @Override
    public boolean hasTag(String tag) {
        WandTemplate template = this.getTemplate();
        return template != null && template.hasTag(tag);
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.WandUpgradePath getPath() {
        String pathKey = this.path;
        if (pathKey == null || pathKey.length() == 0) {
            pathKey = this.controller.getDefaultWandPath();
        }
        return WandUpgradePath.getPath(pathKey);
    }

    public boolean hasPath() {
        return this.path != null && this.path.length() > 0;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
        this.updateLore();
    }

    public boolean tryToOwn(Player player) {
        if (this.ownerId == null || this.ownerId.length() == 0) {
            this.takeOwnership(player);
            return true;
        }
        return false;
    }

    protected void takeOwnership(Player player) {
        this.takeOwnership(player, this.controller != null && this.controller.bindWands(), this.controller != null && this.controller.keepWands());
    }

    public void takeOwnership(Player player, boolean setBound, boolean setKeep) {
        if (this.mage != null && (this.ownerId == null || this.ownerId.length() == 0) && this.quietLevel < 2) {
            com.elmakers.mine.bukkit.api.wand.WandUpgradePath path;
            this.mage.sendMessage(this.getMessage("bound_instructions", "").replace("$wand", this.getName()));
            Spell spell = this.getActiveSpell();
            if (spell != null) {
                String message = this.getMessage("spell_instructions", "").replace("$wand", this.getName());
                this.mage.sendMessage(message.replace("$spell", spell.getName()));
            }
            if (this.spells.size() > 1) {
                this.mage.sendMessage(this.getMessage("inventory_instructions", "").replace("$wand", this.getName()));
            }
            if ((path = this.getPath()) != null) {
                String message = this.getMessage("enchant_instructions", "").replace("$wand", this.getName());
                this.mage.sendMessage(message);
            }
        }
        this.owner = ChatColor.stripColor((String)player.getDisplayName());
        this.ownerId = player.getUniqueId().toString();
        if (setBound) {
            this.bound = true;
        }
        if (setKeep) {
            this.keep = true;
        }
        this.updateLore();
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public MaterialAndData getIcon() {
        return this.icon;
    }

    protected List<Inventory> getAllInventories() {
        ArrayList<Inventory> allInventories = new ArrayList<Inventory>(this.inventories.size() + this.hotbars.size());
        allInventories.addAll(this.hotbars);
        allInventories.addAll(this.inventories);
        return allInventories;
    }

    public Set<String> getSpells() {
        return this.spells.keySet();
    }

    protected String getSpellString() {
        TreeSet<String> spellNames = new TreeSet<String>();
        for (Map.Entry<String, Integer> spellSlot : this.spells.entrySet()) {
            Integer slot = spellSlot.getValue();
            String spellKey = spellSlot.getKey();
            if (slot != null) {
                spellKey = spellKey + "@" + slot;
            }
            spellNames.add(spellKey);
        }
        return StringUtils.join(spellNames, (String)",");
    }

    public Set<String> getBrushes() {
        return this.brushes.keySet();
    }

    protected String getMaterialString() {
        TreeSet<String> materialNames = new TreeSet<String>();
        for (Map.Entry<String, Integer> brushSlot : this.brushes.entrySet()) {
            Integer slot = brushSlot.getValue();
            String materialKey = brushSlot.getKey();
            if (slot != null) {
                materialKey = materialKey + "@" + slot;
            }
            materialNames.add(materialKey);
        }
        return StringUtils.join(materialNames, (String)",");
    }

    protected Integer parseSlot(String[] pieces) {
        Integer slot = null;
        if (pieces.length > 1) {
            try {
                slot = Integer.parseInt(pieces[1]);
            }
            catch (Exception ex) {
                slot = null;
            }
            if (slot != null && slot < 0) {
                slot = null;
            }
        }
        return slot;
    }

    protected void addToInventory(ItemStack itemStack) {
        String brushKey;
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return;
        }
        if (this.getBrushMode() != WandMode.INVENTORY && Wand.isBrush(itemStack) && (!com.elmakers.mine.bukkit.block.MaterialBrush.isSpecialMaterialKey(brushKey = Wand.getBrush(itemStack)) || com.elmakers.mine.bukkit.block.MaterialBrush.isSchematic(brushKey))) {
            return;
        }
        List<Inventory> checkInventories = this.getAllInventories();
        boolean added = false;
        for (Inventory inventory : checkInventories) {
            HashMap returned = inventory.addItem(new ItemStack[]{itemStack});
            if (returned.size() != 0) continue;
            added = true;
            break;
        }
        if (!added) {
            Inventory newInventory = CompatibilityUtils.createInventory(null, 27, "Wand");
            newInventory.addItem(new ItemStack[]{itemStack});
            this.inventories.add(newInventory);
        }
    }

    protected Inventory getDisplayInventory() {
        if (this.displayInventory == null) {
            int inventorySize = 36;
            this.displayInventory = CompatibilityUtils.createInventory(null, inventorySize, "Wand");
        }
        return this.displayInventory;
    }

    protected Inventory getInventoryByIndex(int inventoryIndex) {
        while (inventoryIndex >= this.inventories.size()) {
            this.inventories.add(CompatibilityUtils.createInventory(null, 27, "Wand"));
        }
        return this.inventories.get(inventoryIndex);
    }

    protected int getHotbarSize() {
        return this.hotbars.size() * 8;
    }

    protected Inventory getInventory(Integer slot) {
        Inventory inventory = null;
        int hotbarSize = this.getHotbarSize();
        if (slot >= hotbarSize) {
            int inventoryIndex = (slot - hotbarSize) / 27;
            inventory = this.getInventoryByIndex(inventoryIndex);
        } else {
            inventory = this.hotbars.get(slot / 8);
        }
        return inventory;
    }

    protected int getInventorySlot(Integer slot) {
        int hotbarSize = this.getHotbarSize();
        if (slot < hotbarSize) {
            return slot % 8;
        }
        return (slot - hotbarSize) % 27;
    }

    protected void addToInventory(ItemStack itemStack, Integer slot) {
        if (slot == null) {
            this.addToInventory(itemStack);
            return;
        }
        Inventory inventory = this.getInventory(slot);
        slot = this.getInventorySlot(slot);
        ItemStack existing = inventory.getItem(slot.intValue());
        inventory.setItem(slot.intValue(), itemStack);
        if (existing != null && existing.getType() != Material.AIR) {
            this.addToInventory(existing);
        }
    }

    protected void parseInventoryStrings(String spellString, String materialString) {
        String[] spellNames;
        this.displayInventory = null;
        for (Inventory hotbar : this.hotbars) {
            hotbar.clear();
        }
        this.inventories.clear();
        this.spells.clear();
        this.spellLevels.clear();
        this.brushes.clear();
        spellString = spellString.replaceAll("[\\]\\[]", "");
        for (String spellName : spellNames = StringUtils.split((String)spellString, (String)",")) {
            ItemStack itemStack;
            String[] pieces = spellName.split("@");
            Integer slot = this.parseSlot(pieces);
            String loadedKey = pieces[0].trim();
            SpellKey spellKey = new SpellKey(loadedKey);
            SpellTemplate spell = this.controller.getSpellTemplate(loadedKey);
            while (spell == null && spellKey.getLevel() > 0) {
                spellKey = new SpellKey(spellKey.getBaseKey(), spellKey.getLevel() - 1);
                spell = this.controller.getSpellTemplate(spellKey.getKey());
            }
            if (spell != null) {
                spellKey = spell.getSpellKey();
                Integer currentLevel = this.spellLevels.get(spellKey.getBaseKey());
                if (currentLevel == null || currentLevel < spellKey.getLevel()) {
                    this.spellLevels.put(spellKey.getBaseKey(), spellKey.getLevel());
                    this.spells.put(spellKey.getKey(), slot);
                    if (currentLevel != null) {
                        SpellKey oldKey = new SpellKey(spellKey.getBaseKey(), currentLevel);
                        this.spells.remove(oldKey.getKey());
                    }
                }
                if (this.activeSpell == null || this.activeSpell.length() == 0) {
                    this.activeSpell = spellKey.getKey();
                }
            }
            if ((itemStack = Wand.createSpellItem(spell, "", this.controller, this.getActivePlayer(), this, false)) == null) continue;
            this.addToInventory(itemStack, slot);
        }
        materialString = materialString.replaceAll("[\\]\\[]", "");
        String[] materialNames = StringUtils.split((String)materialString, (String)",");
        WandMode brushMode = this.getBrushMode();
        for (String materialName : materialNames) {
            boolean addToInventory;
            String[] pieces = materialName.split("@");
            Integer slot = this.parseSlot(pieces);
            String materialKey = pieces[0].trim();
            this.brushes.put(materialKey, slot);
            boolean bl = addToInventory = brushMode == WandMode.INVENTORY || com.elmakers.mine.bukkit.block.MaterialBrush.isSpecialMaterialKey(materialKey) && !com.elmakers.mine.bukkit.block.MaterialBrush.isSchematic(materialKey);
            if (!addToInventory) continue;
            ItemStack itemStack = this.createBrushIcon(materialKey);
            if (itemStack == null) {
                this.controller.getPlugin().getLogger().warning("Unable to create material icon for key " + materialKey);
                continue;
            }
            if (this.activeMaterial == null || this.activeMaterial.length() == 0) {
                this.activeMaterial = materialKey;
            }
            this.addToInventory(itemStack, slot);
        }
        this.updateHasInventory();
        if (this.openInventoryPage >= this.inventories.size()) {
            this.openInventoryPage = 0;
        }
    }

    protected ItemStack createSpellIcon(SpellTemplate spell) {
        return Wand.createSpellItem(spell, "", this.controller, this.getActivePlayer(), this, false);
    }

    public static ItemStack createSpellItem(String spellKey, MagicController controller, Wand wand, boolean isItem) {
        String[] split = spellKey.split(" ", 2);
        return Wand.createSpellItem(controller.getSpellTemplate(split[0]), split.length > 1 ? split[1] : "", controller, wand == null ? null : wand.getActivePlayer(), wand, isItem);
    }

    public static ItemStack createSpellItem(String spellKey, MagicController controller, com.elmakers.mine.bukkit.api.magic.Mage mage, Wand wand, boolean isItem) {
        String[] split = spellKey.split(" ", 2);
        return Wand.createSpellItem(controller.getSpellTemplate(split[0]), split.length > 1 ? split[1] : "", controller, mage, wand, isItem);
    }

    public static ItemStack createSpellItem(SpellTemplate spell, String args, MagicController controller, com.elmakers.mine.bukkit.api.magic.Mage mage, Wand wand, boolean isItem) {
        if (spell == null) {
            return null;
        }
        String iconURL = spell.getIconURL();
        ItemStack itemStack = null;
        if (iconURL != null && controller.isUrlIconsEnabled()) {
            itemStack = InventoryUtils.getURLSkull(iconURL);
        }
        if (itemStack == null) {
            ItemStack originalItemStack = null;
            MaterialAndData icon = spell.getIcon();
            if (icon == null) {
                controller.getPlugin().getLogger().warning("Unable to create spell icon for " + spell.getName() + ", missing material");
                return null;
            }
            try {
                originalItemStack = new ItemStack(icon.getMaterial(), 1, icon.getData().shortValue());
                itemStack = InventoryUtils.makeReal(originalItemStack);
            }
            catch (Exception ex) {
                itemStack = null;
            }
            if (itemStack == null) {
                if (icon != null && icon.getMaterial() != Material.AIR) {
                    String iconName = icon == null ? "Unknown" : icon.getName();
                    controller.getPlugin().getLogger().warning("Unable to create spell icon for " + spell.getKey() + " with material " + iconName);
                }
                return originalItemStack;
            }
        }
        InventoryUtils.makeUnbreakable(itemStack);
        InventoryUtils.hideFlags(itemStack, (byte)63);
        Wand.updateSpellItem(controller.getMessages(), itemStack, spell, args, mage, wand, wand == null ? null : wand.activeMaterial, isItem);
        return itemStack;
    }

    protected ItemStack createBrushIcon(String materialKey) {
        return Wand.createBrushItem(materialKey, this.controller, this, false);
    }

    public static ItemStack createBrushItem(String materialKey, MageController controller, Wand wand, boolean isItem) {
        com.elmakers.mine.bukkit.block.MaterialBrush brushData = com.elmakers.mine.bukkit.block.MaterialBrush.parseMaterialKey(materialKey);
        if (brushData == null) {
            return null;
        }
        ItemStack itemStack = brushData.getItem(controller, isItem);
        if (BrushGlow || isItem && BrushItemGlow) {
            CompatibilityUtils.addGlow(itemStack);
        }
        InventoryUtils.makeUnbreakable(itemStack);
        InventoryUtils.hideFlags(itemStack, (byte)63);
        Wand.updateBrushItem(controller.getMessages(), itemStack, brushData, wand);
        return itemStack;
    }

    public void checkItem(ItemStack newItem) {
        if (newItem.getAmount() > this.item.getAmount()) {
            this.item.setAmount(newItem.getAmount());
        }
    }

    @Override
    public void saveState() {
        this.saveInventory();
        this.saveItemState();
    }

    public void saveItemState() {
        int currentSlot;
        ItemStack storedItem;
        String storedId;
        Player player;
        ItemStack itemInHand;
        String itemId;
        Player player2;
        if (this.suspendSave) {
            return;
        }
        if (this.mage != null && (player2 = this.mage.getPlayer()) != null && (itemId = Wand.getWandId(itemInHand = player2.getItemInHand())) != null && itemId.equals(this.id)) {
            this.item = itemInHand;
            this.updateIcon();
            this.updateName();
            this.updateLore();
        }
        if (this.item == null || this.item.getType() == Material.AIR) {
            return;
        }
        MemoryConfiguration stateNode = new MemoryConfiguration();
        this.saveProperties((ConfigurationSection)stateNode);
        Object wandNode = InventoryUtils.createNode(this.item, WAND_KEY);
        if (wandNode == null) {
            this.controller.getLogger().warning("Failed to save wand state for wand to : " + this.item);
            Thread.dumpStack();
        } else {
            InventoryUtils.saveTagsToNBT((ConfigurationSection)stateNode, wandNode, ALL_PROPERTY_KEYS);
        }
        if (this.mage != null && (player = this.mage.getPlayer()) != null && this.storedInventory != null && this.item != null && (storedId = Wand.getWandId(storedItem = this.storedInventory.getItem(currentSlot = player.getInventory().getHeldItemSlot()))) != null && storedId.equals(this.id)) {
            this.storedInventory.setItem(currentSlot, this.item);
        }
    }

    protected void loadState() {
        if (this.item == null) {
            return;
        }
        Object wandNode = InventoryUtils.getNode(this.item, WAND_KEY);
        if (wandNode == null) {
            return;
        }
        MemoryConfiguration stateNode = new MemoryConfiguration();
        InventoryUtils.loadTagsFromNBT((ConfigurationSection)stateNode, wandNode, ALL_PROPERTY_KEYS);
        this.loadProperties((ConfigurationSection)stateNode);
    }

    protected String getPotionEffectString() {
        if (this.potionEffects.size() == 0) {
            return null;
        }
        ArrayList<String> effectStrings = new ArrayList<String>();
        for (Map.Entry<PotionEffectType, Integer> entry : this.potionEffects.entrySet()) {
            String effectString = entry.getKey().getName();
            if (entry.getValue() > 0) {
                effectString = effectString + ":" + entry.getValue();
            }
            effectStrings.add(effectString);
        }
        return StringUtils.join(effectStrings, (String)",");
    }

    @Override
    public void save(ConfigurationSection node, boolean filtered) {
        this.saveProperties(node);
        if (filtered) {
            node.set("id", null);
            node.set("owner_id", null);
            node.set("owner", null);
            node.set("template", null);
            Set keys = node.getKeys(false);
            for (String key : keys) {
                String value = node.getString(key);
                if (value != null && value.length() != 0 && !value.equals("0") && !value.equals("0.0") && !value.equals("false")) continue;
                node.set(key, null);
            }
        }
        if (node.contains("spells")) {
            node.set("spells", (Object)StringUtils.split((String)node.getString("spells"), (String)","));
        }
        if (node.contains("materials")) {
            node.set("materials", (Object)StringUtils.split((String)node.getString("materials"), (String)","));
        }
        if (node.contains("overrides")) {
            node.set("overrides", (Object)StringUtils.split((String)node.getString("overrides"), (String)","));
        }
        if (node.contains("potion_effects")) {
            node.set("potion_effects", (Object)StringUtils.split((String)node.getString("potion_effects"), (String)","));
        }
    }

    public void saveProperties(ConfigurationSection node) {
        String iconKey;
        node.set("id", (Object)this.id);
        node.set("materials", (Object)this.getMaterialString());
        node.set("spells", (Object)this.getSpellString());
        node.set("potion_effects", (Object)this.getPotionEffectString());
        node.set("hotbar_count", (Object)this.hotbars.size());
        node.set("hotbar", (Object)this.currentHotbar);
        node.set("active_spell", (Object)this.activeSpell);
        node.set("active_material", (Object)this.activeMaterial);
        node.set("name", (Object)this.wandName);
        node.set("description", (Object)this.description);
        node.set("owner", (Object)this.owner);
        node.set("owner_id", (Object)this.ownerId);
        node.set("cost_reduction", (Object)Float.valueOf(this.costReduction));
        node.set("consume_reduction", (Object)Float.valueOf(this.consumeReduction));
        node.set("cooldown_reduction", (Object)Float.valueOf(this.cooldownReduction));
        node.set("power", (Object)Float.valueOf(this.power));
        node.set("enchant_count", (Object)this.enchantCount);
        node.set("max_enchant_count", (Object)this.maxEnchantCount);
        node.set("protection", (Object)Float.valueOf(this.damageReduction));
        node.set("protection_physical", (Object)Float.valueOf(this.damageReductionPhysical));
        node.set("protection_projectiles", (Object)Float.valueOf(this.damageReductionProjectiles));
        node.set("protection_falling", (Object)Float.valueOf(this.damageReductionFalling));
        node.set("protection_fire", (Object)Float.valueOf(this.damageReductionFire));
        node.set("protection_explosions", (Object)Float.valueOf(this.damageReductionExplosions));
        node.set("mana", (Object)Float.valueOf(this.mana));
        node.set("mana_regeneration", (Object)this.manaRegeneration);
        node.set("mana_max", (Object)this.manaMax);
        node.set("mana_max_boost", (Object)Float.valueOf(this.manaMaxBoost));
        node.set("mana_regeneration_boost", (Object)Float.valueOf(this.manaRegenerationBoost));
        node.set("mana_timestamp", (Object)this.lastManaRegeneration);
        node.set("mana_per_damage", (Object)Float.valueOf(this.manaPerDamage));
        node.set("uses", (Object)this.uses);
        node.set("has_uses", (Object)this.hasUses);
        node.set("locked", (Object)this.locked);
        node.set("effect_color", (Object)(this.effectColor == null ? "none" : this.effectColor.toString()));
        node.set("effect_bubbles", (Object)this.effectBubbles);
        node.set("effect_particle_data", (Object)Float.toString(this.effectParticleData));
        node.set("effect_particle_count", (Object)this.effectParticleCount);
        node.set("effect_particle_min_velocity", (Object)this.effectParticleMinVelocity);
        node.set("effect_particle_interval", (Object)this.effectParticleInterval);
        node.set("effect_particle_radius", (Object)this.effectParticleRadius);
        node.set("effect_particle_offset", (Object)this.effectParticleOffset);
        node.set("effect_sound_interval", (Object)this.effectSoundInterval);
        node.set("cast_interval", (Object)this.castInterval);
        node.set("cast_min_velocity", (Object)this.castMinVelocity);
        String directionString = null;
        if (this.castVelocityDirection != null) {
            directionString = ConfigurationUtils.fromVector(this.castVelocityDirection);
        }
        node.set("cast_velocity_direction", (Object)directionString);
        node.set("cast_spell", (Object)this.castSpell);
        String castParameterString = null;
        if (this.castParameters != null) {
            castParameterString = ConfigurationUtils.getParameters(this.castParameters);
        }
        node.set("cast_parameters", (Object)castParameterString);
        node.set("quiet", (Object)this.quietLevel);
        node.set("passive", (Object)this.passive);
        node.set("keep", (Object)this.keep);
        node.set("randomize", (Object)this.randomize);
        node.set("rename", (Object)this.rename);
        node.set("rename_description", (Object)this.renameDescription);
        node.set("bound", (Object)this.bound);
        node.set("soul", (Object)this.soul);
        node.set("force", (Object)this.forceUpgrade);
        node.set("indestructible", (Object)this.indestructible);
        node.set("protected", (Object)this.superProtected);
        node.set("powered", (Object)this.superPowered);
        node.set("glow", (Object)this.glow);
        node.set("undroppable", (Object)this.undroppable);
        node.set("heroes", (Object)this.isHeroes);
        node.set("fill", (Object)this.autoFill);
        node.set("upgrade", (Object)this.isUpgrade);
        node.set("organize", (Object)this.autoOrganize);
        node.set("alphabetize", (Object)this.autoAlphabetize);
        if (this.castOverrides != null && this.castOverrides.size() > 0) {
            ArrayList<String> parameters = new ArrayList<String>();
            for (Map.Entry<String, String> entry : this.castOverrides.entrySet()) {
                String value = entry.getValue();
                parameters.add(entry.getKey() + " " + value.replace(",", "\\,"));
            }
            node.set("overrides", (Object)StringUtils.join(parameters, (String)","));
        } else {
            node.set("overrides", null);
        }
        if (this.effectSound != null) {
            node.set("effect_sound", (Object)this.effectSound.toString());
        } else {
            node.set("effectSound", null);
        }
        if (this.effectParticle != null) {
            node.set("effect_particle", (Object)this.effectParticle.name());
        } else {
            node.set("effect_particle", null);
        }
        if (this.mode != null) {
            node.set("mode", (Object)this.mode.name());
        } else {
            node.set("mode", null);
        }
        node.set("left_click", (Object)this.leftClickAction.name());
        node.set("right_click", (Object)this.rightClickAction.name());
        node.set("drop", (Object)this.dropAction.name());
        node.set("swap", (Object)this.swapAction.name());
        if (this.quickCast) {
            node.set("quick_cast", (Object)"true");
        } else if (this.quickCastDisabled) {
            if (this.manualQuickCastDisabled) {
                node.set("quick_cast", (Object)"disable");
            } else {
                node.set("quick_cast", (Object)"manual");
            }
        } else {
            node.set("quick_cast", null);
        }
        if (this.brushMode != null) {
            node.set("brush_mode", (Object)this.brushMode.name());
        } else {
            node.set("brush_mode", null);
        }
        if (this.icon != null && this.icon.getMaterial() != null && this.icon.getMaterial() != Material.AIR) {
            iconKey = this.icon.getKey();
            if (iconKey != null && iconKey.length() > 0) {
                node.set("icon", (Object)iconKey);
            } else {
                node.set("icon", null);
            }
        } else {
            node.set("icon", null);
        }
        if (this.inactiveIcon != null && this.inactiveIcon.getMaterial() != null && this.inactiveIcon.getMaterial() != Material.AIR) {
            iconKey = this.inactiveIcon.getKey();
            if (iconKey != null && iconKey.length() > 0) {
                node.set("icon_inactive", (Object)iconKey);
            } else {
                node.set("icon_inactive", null);
            }
        } else {
            node.set("icon_inactive", null);
        }
        node.set("icon_inactive_delay", (Object)this.inactiveIconDelay);
        if (this.upgradeIcon != null) {
            iconKey = this.upgradeIcon.getKey();
            if (iconKey != null && iconKey.length() > 0) {
                node.set("upgrade_icon", (Object)iconKey);
            } else {
                node.set("upgrade_icon", null);
            }
        } else {
            node.set("upgrade_icon", null);
        }
        if (this.upgradeTemplate != null && this.upgradeTemplate.length() > 0) {
            node.set("upgrade_template", (Object)this.upgradeTemplate);
        } else {
            node.set("upgrade_template", null);
        }
        if (this.template != null && this.template.length() > 0) {
            node.set("template", (Object)this.template);
        } else {
            node.set("template", null);
        }
        if (this.path != null && this.path.length() > 0) {
            node.set("path", (Object)this.path);
        } else {
            node.set("path", null);
        }
    }

    public void loadProperties(ConfigurationSection wandConfig) {
        this.loadProperties(wandConfig, false);
    }

    public void setEffectColor(String hexColor) {
        if (hexColor.contains(".")) {
            hexColor = hexColor.substring(0, hexColor.indexOf(46));
        }
        if (hexColor == null || hexColor.length() == 0 || hexColor.equals("none")) {
            this.effectColor = null;
            return;
        }
        this.effectColor = new ColorHD(hexColor);
    }

    public static void addPotionEffects(Map<PotionEffectType, Integer> effects, ItemStack item) {
        Wand.addPotionEffects(effects, Wand.getWandString(item, "potion_effects"));
    }

    protected static void addPotionEffects(Map<PotionEffectType, Integer> effects, String effectsString) {
        String[] effectStrings;
        if (effectsString == null || effectsString.isEmpty()) {
            return;
        }
        effectsString = effectsString.replaceAll("[\\]\\[]", "");
        for (String effectString : effectStrings = StringUtils.split((String)effectsString, (String)",")) {
            try {
                PotionEffectType type;
                effectString = effectString.trim();
                int power = 0;
                if (effectString.contains(":")) {
                    String[] pieces = effectString.split(":");
                    type = PotionEffectType.getByName((String)pieces[0].toUpperCase());
                    power = Integer.parseInt(pieces[1]);
                } else {
                    type = PotionEffectType.getByName((String)effectString.toUpperCase());
                }
                if (type == null) {
                    throw new Exception("Invalid potion effect");
                }
                Integer existing = effects.get(type);
                if (existing != null && existing >= power) continue;
                effects.put(type, power);
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.WARNING, "Invalid potion effect: " + effectString);
            }
        }
    }

    public void loadProperties(ConfigurationSection wandConfig, boolean safe) {
        this.locked = wandConfig.getBoolean("locked", this.locked);
        float _consumeReduction = (float)wandConfig.getDouble("consume_reduction", (double)this.consumeReduction);
        this.consumeReduction = safe ? Math.max(_consumeReduction, this.consumeReduction) : _consumeReduction;
        float _costReduction = (float)wandConfig.getDouble("cost_reduction", (double)this.costReduction);
        this.costReduction = safe ? Math.max(_costReduction, this.costReduction) : _costReduction;
        float _cooldownReduction = (float)wandConfig.getDouble("cooldown_reduction", (double)this.cooldownReduction);
        this.cooldownReduction = safe ? Math.max(_cooldownReduction, this.cooldownReduction) : _cooldownReduction;
        float _power = (float)wandConfig.getDouble("power", (double)this.power);
        this.power = safe ? Math.max(_power, this.power) : _power;
        float _damageReduction = (float)wandConfig.getDouble("protection", (double)this.damageReduction);
        this.damageReduction = safe ? Math.max(_damageReduction, this.damageReduction) : _damageReduction;
        float _damageReductionPhysical = (float)wandConfig.getDouble("protection_physical", (double)this.damageReductionPhysical);
        this.damageReductionPhysical = safe ? Math.max(_damageReductionPhysical, this.damageReductionPhysical) : _damageReductionPhysical;
        float _damageReductionProjectiles = (float)wandConfig.getDouble("protection_projectiles", (double)this.damageReductionProjectiles);
        this.damageReductionProjectiles = safe ? Math.max(_damageReductionProjectiles, this.damageReductionPhysical) : _damageReductionProjectiles;
        float _damageReductionFalling = (float)wandConfig.getDouble("protection_falling", (double)this.damageReductionFalling);
        this.damageReductionFalling = safe ? Math.max(_damageReductionFalling, this.damageReductionFalling) : _damageReductionFalling;
        float _damageReductionFire = (float)wandConfig.getDouble("protection_fire", (double)this.damageReductionFire);
        this.damageReductionFire = safe ? Math.max(_damageReductionFire, this.damageReductionFire) : _damageReductionFire;
        float _damageReductionExplosions = (float)wandConfig.getDouble("protection_explosions", (double)this.damageReductionExplosions);
        this.damageReductionExplosions = safe ? Math.max(_damageReductionExplosions, this.damageReductionExplosions) : _damageReductionExplosions;
        int _manaRegeneration = wandConfig.getInt("mana_regeneration", wandConfig.getInt("xp_regeneration", this.manaRegeneration));
        this.manaRegeneration = safe ? Math.max(_manaRegeneration, this.manaRegeneration) : _manaRegeneration;
        int _manaMax = wandConfig.getInt("mana_max", wandConfig.getInt("xp_max", this.manaMax));
        this.manaMax = safe ? Math.max(_manaMax, this.manaMax) : _manaMax;
        int _mana = wandConfig.getInt("mana", wandConfig.getInt("xp", (int)this.mana));
        this.mana = safe ? Math.max((float)_mana, this.mana) : (float)_mana;
        float _manaMaxBoost = (float)wandConfig.getDouble("mana_max_boost", wandConfig.getDouble("xp_max_boost", (double)this.manaMaxBoost));
        this.manaMaxBoost = safe ? Math.max(_manaMaxBoost, this.manaMaxBoost) : _manaMaxBoost;
        float _manaRegenerationBoost = (float)wandConfig.getDouble("mana_regeneration_boost", wandConfig.getDouble("xp_regeneration_boost", (double)this.manaRegenerationBoost));
        this.manaRegenerationBoost = safe ? Math.max(_manaRegenerationBoost, this.manaRegenerationBoost) : _manaRegenerationBoost;
        int _uses = wandConfig.getInt("uses", this.uses);
        this.uses = safe ? Math.max(_uses, this.uses) : _uses;
        String tempId = wandConfig.getString("id", this.id);
        this.isSingleUse = (tempId == null || tempId.isEmpty()) && this.uses == 1;
        this.hasUses = wandConfig.getBoolean("has_uses", this.hasUses) || this.uses > 0;
        float _manaPerDamage = (float)wandConfig.getDouble("mana_per_damage", (double)this.manaPerDamage);
        this.manaPerDamage = safe ? Math.max(_manaPerDamage, this.manaPerDamage) : _manaPerDamage;
        float healthRegeneration = (float)wandConfig.getDouble("health_regeneration", 0.0);
        float hungerRegeneration = (float)wandConfig.getDouble("hunger_regeneration", 0.0);
        float speedIncrease = (float)wandConfig.getDouble("haste", 0.0);
        if (speedIncrease > 0.0f) {
            this.potionEffects.put(PotionEffectType.SPEED, 1);
        }
        if (healthRegeneration > 0.0f) {
            this.potionEffects.put(PotionEffectType.REGENERATION, 1);
        }
        if (hungerRegeneration > 0.0f) {
            this.potionEffects.put(PotionEffectType.SATURATION, 1);
        }
        this.lastManaRegeneration = regenWhileInactive ? wandConfig.getLong("mana_timestamp") : System.currentTimeMillis();
        if (wandConfig.contains("effect_color") && !safe) {
            this.setEffectColor(wandConfig.getString("effect_color"));
        }
        if (!safe) {
            com.elmakers.mine.bukkit.api.wand.WandUpgradePath upgradePath;
            String migrateTemplate;
            String quickCastType;
            WandMode newMode;
            this.id = wandConfig.getString("id", this.id);
            this.isUpgrade = wandConfig.getBoolean("upgrade", this.isUpgrade);
            this.quietLevel = wandConfig.getInt("quiet", this.quietLevel);
            this.effectBubbles = wandConfig.getBoolean("effect_bubbles", this.effectBubbles);
            this.keep = wandConfig.getBoolean("keep", this.keep);
            this.passive = wandConfig.getBoolean("passive", this.passive);
            this.indestructible = wandConfig.getBoolean("indestructible", this.indestructible);
            this.superPowered = wandConfig.getBoolean("powered", this.superPowered);
            this.superProtected = wandConfig.getBoolean("protected", this.superProtected);
            this.glow = wandConfig.getBoolean("glow", this.glow);
            this.undroppable = wandConfig.getBoolean("undroppable", this.undroppable);
            this.isHeroes = wandConfig.getBoolean("heroes", this.isHeroes);
            this.bound = wandConfig.getBoolean("bound", this.bound);
            this.soul = wandConfig.getBoolean("soul", this.soul);
            this.forceUpgrade = wandConfig.getBoolean("force", this.forceUpgrade);
            this.autoOrganize = wandConfig.getBoolean("organize", this.autoOrganize);
            this.autoAlphabetize = wandConfig.getBoolean("alphabetize", this.autoAlphabetize);
            this.autoFill = wandConfig.getBoolean("fill", this.autoFill);
            this.randomize = wandConfig.getBoolean("randomize", this.randomize);
            this.rename = wandConfig.getBoolean("rename", this.rename);
            this.renameDescription = wandConfig.getBoolean("rename_description", this.renameDescription);
            this.enchantCount = wandConfig.getInt("enchant_count", this.enchantCount);
            this.maxEnchantCount = wandConfig.getInt("max_enchant_count", this.maxEnchantCount);
            if (wandConfig.contains("effect_particle")) {
                this.effectParticle = ConfigurationUtils.toParticleEffect(wandConfig.getString("effect_particle"));
                this.effectParticleData = 0.0f;
            }
            if (wandConfig.contains("effect_sound")) {
                this.effectSound = ConfigurationUtils.toSoundEffect(wandConfig.getString("effect_sound"));
            }
            this.effectParticleData = (float)wandConfig.getDouble("effect_particle_data", (double)this.effectParticleData);
            this.effectParticleCount = wandConfig.getInt("effect_particle_count", this.effectParticleCount);
            this.effectParticleRadius = wandConfig.getDouble("effect_particle_radius", this.effectParticleRadius);
            this.effectParticleOffset = wandConfig.getDouble("effect_particle_offset", this.effectParticleOffset);
            this.effectParticleInterval = wandConfig.getInt("effect_particle_interval", this.effectParticleInterval);
            this.effectParticleMinVelocity = wandConfig.getDouble("effect_particle_min_velocity", this.effectParticleMinVelocity);
            this.effectSoundInterval = wandConfig.getInt("effect_sound_interval", this.effectSoundInterval);
            this.castInterval = wandConfig.getInt("cast_interval", this.castInterval);
            this.castMinVelocity = wandConfig.getDouble("cast_min_velocity", this.castMinVelocity);
            this.castVelocityDirection = ConfigurationUtils.getVector(wandConfig, "cast_velocity_direction", this.castVelocityDirection);
            this.castSpell = wandConfig.getString("cast_spell", this.castSpell);
            String castParameterString = wandConfig.getString("cast_parameters", null);
            if (castParameterString != null && !castParameterString.isEmpty()) {
                this.castParameters = new MemoryConfiguration();
                ConfigurationUtils.addParameters(StringUtils.split((String)castParameterString, (String)" "), this.castParameters);
            }
            boolean needsInventoryUpdate = false;
            if (wandConfig.contains("mode") && (newMode = Wand.parseWandMode(wandConfig.getString("mode"), this.mode)) != this.mode) {
                this.setMode(newMode);
                needsInventoryUpdate = true;
            }
            if (wandConfig.contains("brush_mode")) {
                this.setBrushMode(Wand.parseWandMode(wandConfig.getString("brush_mode"), this.brushMode));
            }
            if ((quickCastType = wandConfig.getString("quick_cast", wandConfig.getString("mode_cast"))) != null) {
                if (quickCastType.equalsIgnoreCase("true")) {
                    this.quickCast = true;
                    this.quickCastDisabled = true;
                    this.manualQuickCastDisabled = false;
                } else if (quickCastType.equalsIgnoreCase("manual")) {
                    this.quickCast = false;
                    this.quickCastDisabled = true;
                    this.manualQuickCastDisabled = false;
                } else if (quickCastType.equalsIgnoreCase("disable")) {
                    this.quickCast = false;
                    this.quickCastDisabled = true;
                    this.manualQuickCastDisabled = true;
                } else {
                    this.quickCast = false;
                    this.quickCastDisabled = false;
                    this.manualQuickCastDisabled = false;
                }
            }
            if (wandConfig.getBoolean("mode_drop", false)) {
                this.dropAction = WandAction.TOGGLE;
                this.swapAction = WandAction.CYCLE_HOTBAR;
                this.rightClickAction = WandAction.NONE;
            } else if (this.mode == WandMode.CAST) {
                this.leftClickAction = WandAction.CAST;
                this.rightClickAction = WandAction.CAST;
                this.swapAction = WandAction.NONE;
                this.dropAction = WandAction.NONE;
            }
            this.leftClickAction = Wand.parseWandAction(wandConfig.getString("left_click"), this.leftClickAction);
            this.rightClickAction = Wand.parseWandAction(wandConfig.getString("right_click"), this.rightClickAction);
            this.dropAction = Wand.parseWandAction(wandConfig.getString("drop"), this.dropAction);
            this.swapAction = Wand.parseWandAction(wandConfig.getString("swap"), this.swapAction);
            this.owner = wandConfig.getString("owner", this.owner);
            this.ownerId = wandConfig.getString("owner_id", this.ownerId);
            this.wandName = wandConfig.getString("name", this.wandName);
            this.description = wandConfig.getString("description", this.description);
            this.template = wandConfig.getString("template", this.template);
            this.upgradeTemplate = wandConfig.getString("upgrade_template", this.upgradeTemplate);
            this.path = wandConfig.getString("path", this.path);
            this.activeSpell = wandConfig.getString("active_spell", this.activeSpell);
            this.activeMaterial = wandConfig.getString("active_material", this.activeMaterial);
            String wandMaterials = "";
            String wandSpells = "";
            if (wandConfig.contains("hotbar_count")) {
                int newCount = Math.max(1, wandConfig.getInt("hotbar_count"));
                if (!safe && newCount != this.hotbars.size() || newCount > this.hotbars.size()) {
                    if (this.isInventoryOpen()) {
                        this.closeInventory();
                    }
                    needsInventoryUpdate = true;
                    this.setHotbarCount(newCount);
                }
            }
            if (wandConfig.contains("hotbar")) {
                int hotbar = wandConfig.getInt("hotbar");
                int n = this.currentHotbar = hotbar < 0 || hotbar >= this.hotbars.size() ? 0 : hotbar;
            }
            if (needsInventoryUpdate) {
                wandSpells = this.getSpellString();
                wandMaterials = this.getMaterialString();
            }
            wandMaterials = wandConfig.getString("materials", wandMaterials);
            wandSpells = wandConfig.getString("spells", wandSpells);
            if (wandMaterials.length() > 0 || wandSpells.length() > 0) {
                wandMaterials = wandMaterials.length() == 0 ? this.getMaterialString() : wandMaterials;
                wandSpells = wandSpells.length() == 0 ? this.getSpellString() : wandSpells;
                this.parseInventoryStrings(wandSpells, wandMaterials);
            }
            if (wandConfig.contains("icon_inactive")) {
                this.inactiveIcon = new com.elmakers.mine.bukkit.block.MaterialAndData(wandConfig.getString("icon_inactive"));
            }
            if (this.inactiveIcon != null && (this.inactiveIcon.getMaterial() == null || this.inactiveIcon.getMaterial() == Material.AIR)) {
                this.inactiveIcon = null;
            }
            this.inactiveIconDelay = wandConfig.getInt("icon_inactive_delay", this.inactiveIconDelay);
            ConfigurationSection templateConfig = null;
            if (this.template != null && !this.template.isEmpty()) {
                templateConfig = this.controller.getWandTemplateConfiguration(this.template);
            }
            String string = migrateTemplate = templateConfig == null ? null : templateConfig.getString("migrate_to");
            if (migrateTemplate != null) {
                this.template = migrateTemplate;
                templateConfig = this.controller.getWandTemplateConfiguration(this.template);
            }
            WandTemplate wandTemplate = this.getTemplate();
            if (templateConfig != null) {
                InventoryUtils.applyAttributes(this.item, templateConfig.getConfigurationSection("attributes"), templateConfig.getString("attribute_slot", null));
            }
            if (wandConfig.contains("randomize_icon")) {
                this.setIcon(new com.elmakers.mine.bukkit.block.MaterialAndData(wandConfig.getString("randomize_icon")));
                this.randomize = true;
            } else if (!this.randomize && wandConfig.contains("icon")) {
                String iconKey = wandConfig.getString("icon");
                if (wandTemplate != null) {
                    iconKey = wandTemplate.migrateIcon(iconKey);
                }
                if (iconKey.contains(",")) {
                    Random r = new Random();
                    String[] keys = StringUtils.split((String)iconKey, (char)',');
                    iconKey = keys[r.nextInt(keys.length)];
                }
                if (templateConfig != null && iconKey.contains("i.imgur.com")) {
                    iconKey = templateConfig.getString("icon");
                }
                this.setIcon(new com.elmakers.mine.bukkit.block.MaterialAndData(iconKey));
            } else if (this.isUpgrade) {
                this.setIcon(new com.elmakers.mine.bukkit.block.MaterialAndData(DefaultUpgradeMaterial));
            }
            if (wandConfig.contains("upgrade_icon")) {
                this.upgradeIcon = new com.elmakers.mine.bukkit.block.MaterialAndData(wandConfig.getString("upgrade_icon"));
            }
            if ((upgradePath = this.getPath()) != null) {
                this.hasSpellProgression = upgradePath.getSpells().size() > 0 || upgradePath.getExtraSpells().size() > 0 || upgradePath.getRequiredSpells().size() > 0;
                upgradePath.checkMigration(this);
            } else {
                this.hasSpellProgression = false;
            }
            if (wandConfig.contains("overrides")) {
                this.castOverrides = null;
                String overrides = wandConfig.getString("overrides", null);
                if (overrides != null && !overrides.isEmpty()) {
                    String[] pairs;
                    overrides = overrides.replaceAll("[\\]\\[]", "");
                    overrides = overrides.replace("\\,", ",");
                    char split = ',';
                    if (overrides.charAt(0) == '|') {
                        split = '|';
                        overrides = overrides.substring(1);
                    }
                    this.castOverrides = new HashMap<String, String>();
                    for (String pair : pairs = StringUtils.split((String)overrides, (char)split)) {
                        String[] keyValue = StringUtils.split((String)pair, (String)" ");
                        if (keyValue.length <= 0) continue;
                        String value = keyValue.length > 1 ? keyValue[1] : "";
                        this.castOverrides.put(keyValue[0], value);
                    }
                }
            }
            if (wandConfig.contains("potion_effects")) {
                this.potionEffects.clear();
                Wand.addPotionEffects(this.potionEffects, wandConfig.getString("potion_effects", null));
            }
        }
        if (this.effectSound == null) {
            this.effectSoundInterval = 0;
        } else {
            int n = this.effectSoundInterval = this.effectSoundInterval == 0 ? 5 : this.effectSoundInterval;
        }
        if (this.effectParticle == null) {
            this.effectParticleInterval = 0;
        }
        this.updateMaxMana(false);
        this.checkActiveMaterial();
        this.checkId();
    }

    @Override
    public void describe(CommandSender sender) {
        Object wandNode = InventoryUtils.getNode(this.item, WAND_KEY);
        if (wandNode == null) {
            sender.sendMessage("Found a wand with missing NBT data. This may be an old wand, or something may have wiped its data");
            return;
        }
        ChatColor wandColor = this.isModifiable() ? ChatColor.AQUA : ChatColor.RED;
        sender.sendMessage(wandColor + this.wandName);
        if (this.description.length() > 0) {
            sender.sendMessage(ChatColor.ITALIC + "" + ChatColor.GREEN + this.description);
        } else {
            sender.sendMessage(ChatColor.ITALIC + "" + ChatColor.GREEN + "(No Description)");
        }
        if (this.owner.length() > 0 || this.ownerId.length() > 0) {
            sender.sendMessage(ChatColor.ITALIC + "" + ChatColor.WHITE + this.owner + " (" + ChatColor.GRAY + this.ownerId + ChatColor.WHITE + ")");
        } else {
            sender.sendMessage(ChatColor.ITALIC + "" + ChatColor.WHITE + "(No Owner)");
        }
        for (String key : PROPERTY_KEYS) {
            String value = InventoryUtils.getMeta(wandNode, key);
            if (value == null || value.length() <= 0) continue;
            sender.sendMessage(key + ": " + value);
        }
    }

    private static String getBrushDisplayName(Messages messages, com.elmakers.mine.bukkit.block.MaterialBrush brush) {
        String materialName;
        String string = materialName = brush == null ? null : brush.getName(messages);
        if (materialName == null) {
            materialName = "none";
        }
        return ChatColor.GRAY + materialName;
    }

    private static String getSpellDisplayName(Messages messages, SpellTemplate spell, com.elmakers.mine.bukkit.block.MaterialBrush brush) {
        String name = "";
        if (spell != null) {
            name = brush != null && spell.usesBrush() ? ChatColor.GOLD + spell.getName() + " " + Wand.getBrushDisplayName(messages, brush) + ChatColor.WHITE : ChatColor.GOLD + spell.getName() + ChatColor.WHITE;
        }
        return name;
    }

    private String getActiveWandName(SpellTemplate spell, com.elmakers.mine.bukkit.block.MaterialBrush brush) {
        boolean showSpell;
        int remaining = this.getRemainingUses();
        ChatColor wandColor = this.hasUses && remaining <= 1 ? ChatColor.DARK_RED : (this.isModifiable() ? (this.bound ? ChatColor.DARK_AQUA : ChatColor.AQUA) : (this.path != null && this.path.length() > 0 ? ChatColor.LIGHT_PURPLE : ChatColor.GOLD));
        String name = wandColor + this.getDisplayName();
        if (this.randomize) {
            return name;
        }
        Collection spells = this.getSpells();
        Messages messages = this.controller.getMessages();
        boolean bl = showSpell = this.isModifiable() && this.hasPath();
        if (spell != null && !this.quickCast && (spells.size() > 1 || showSpell)) {
            name = Wand.getSpellDisplayName(messages, spell, brush) + " (" + name + ChatColor.WHITE + ")";
        }
        if (remaining > 1) {
            String message = this.getMessage("uses_remaining_brief");
            name = name + ChatColor.DARK_RED + " (" + ChatColor.RED + message.replace("$count", Integer.valueOf(remaining).toString()) + ChatColor.DARK_RED + ")";
        }
        return name;
    }

    private String getActiveWandName(SpellTemplate spell) {
        return this.getActiveWandName(spell, com.elmakers.mine.bukkit.block.MaterialBrush.parseMaterialKey(this.activeMaterial));
    }

    private String getActiveWandName(com.elmakers.mine.bukkit.block.MaterialBrush brush) {
        SpellTemplate spell = null;
        if (this.activeSpell != null && this.activeSpell.length() > 0) {
            spell = this.controller.getSpellTemplate(this.activeSpell);
        }
        return this.getActiveWandName(spell, brush);
    }

    private String getActiveWandName() {
        SpellTemplate spell = null;
        if (this.activeSpell != null && this.activeSpell.length() > 0) {
            spell = this.controller.getSpellTemplate(this.activeSpell);
        }
        return this.getActiveWandName(spell);
    }

    protected String getDisplayName() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)(this.randomize ? this.getMessage("randomized_name") : this.wandName));
    }

    public void updateName(boolean isActive) {
        if (isActive) {
            CompatibilityUtils.setDisplayName(this.item, !this.isUpgrade ? this.getActiveWandName() : ChatColor.GOLD + this.getDisplayName());
        } else {
            CompatibilityUtils.setDisplayName(this.item, ChatColor.stripColor((String)this.getDisplayName()));
        }
        if (this.glow) {
            CompatibilityUtils.addGlow(this.item);
        }
    }

    private void updateName() {
        this.updateName(true);
    }

    protected static String convertToHTML(String line) {
        int tagCount = 1;
        line = "<span style=\"color:white\">" + line;
        for (ChatColor c : ChatColor.values()) {
            tagCount += StringUtils.countMatches((String)line, (String)c.toString());
            String replaceStyle = "";
            if (c == ChatColor.ITALIC) {
                replaceStyle = "font-style: italic";
            } else if (c == ChatColor.BOLD) {
                replaceStyle = "font-weight: bold";
            } else if (c == ChatColor.UNDERLINE) {
                replaceStyle = "text-decoration: underline";
            } else {
                String color = c.name().toLowerCase().replace("_", "");
                if (c == ChatColor.LIGHT_PURPLE) {
                    color = "mediumpurple";
                }
                replaceStyle = "color:" + color;
            }
            line = line.replace(c.toString(), "<span style=\"" + replaceStyle + "\">");
        }
        for (int i = 0; i < tagCount; ++i) {
            line = line + "</span>";
        }
        return line;
    }

    public String getHTMLDescription() {
        List<String> rawLore = this.getLore();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("<h2>" + Wand.convertToHTML(this.getActiveWandName()) + "</h2>");
        for (String line : rawLore) {
            lore.add(Wand.convertToHTML(line));
        }
        return "<div style=\"background-color: black; margin: 8px; padding: 8px\">" + StringUtils.join(lore, (String)"<br/>") + "</div>";
    }

    protected List<String> getLore() {
        return this.getLore(this.getSpells().size(), this.getBrushes().size());
    }

    protected void addPropertyLore(List<String> lore) {
        SpellTemplate spell;
        if (this.usesMana()) {
            String fullMessage;
            if (this.effectiveManaMax != this.manaMax) {
                fullMessage = Wand.getLevelString(this.controller.getMessages(), "wand.mana_amount_boosted", this.manaMax, this.controller.getMaxMana());
                lore.add(ChatColor.LIGHT_PURPLE + "" + ChatColor.ITALIC + fullMessage.replace("$mana", Integer.toString(this.effectiveManaMax)));
            } else {
                lore.add(ChatColor.LIGHT_PURPLE + "" + ChatColor.ITALIC + Wand.getLevelString(this.controller.getMessages(), "wand.mana_amount", this.manaMax, this.controller.getMaxMana()));
            }
            if (this.manaRegeneration > 0) {
                if (this.effectiveManaRegeneration != this.manaRegeneration) {
                    fullMessage = Wand.getLevelString(this.controller.getMessages(), "wand.mana_regeneration_boosted", this.manaRegeneration, this.controller.getMaxManaRegeneration());
                    lore.add(ChatColor.LIGHT_PURPLE + "" + ChatColor.ITALIC + fullMessage.replace("$mana", Integer.toString(this.effectiveManaRegeneration)));
                } else {
                    lore.add(ChatColor.RESET + "" + ChatColor.LIGHT_PURPLE + Wand.getLevelString(this.controller.getMessages(), "wand.mana_regeneration", this.manaRegeneration, this.controller.getMaxManaRegeneration()));
                }
            }
            if (this.manaPerDamage > 0.0f) {
                lore.add(ChatColor.DARK_RED + "" + ChatColor.ITALIC + Wand.getLevelString(this.controller.getMessages(), "wand.mana_per_damage", this.manaPerDamage, this.controller.getMaxManaRegeneration()));
            }
        }
        if (this.superPowered) {
            lore.add(ChatColor.DARK_AQUA + this.getMessage("super_powered"));
        }
        if (this.manaMaxBoost != 0.0f) {
            lore.add(ChatColor.LIGHT_PURPLE + "" + ChatColor.ITALIC + Wand.getPercentageString(this.controller.getMessages(), "wand.mana_boost", this.manaMaxBoost));
        }
        if (this.manaRegenerationBoost != 0.0f) {
            lore.add(ChatColor.LIGHT_PURPLE + "" + ChatColor.ITALIC + Wand.getPercentageString(this.controller.getMessages(), "wand.mana_regeneration_boost", this.manaRegenerationBoost));
        }
        if (this.castSpell != null && (spell = this.controller.getSpellTemplate(this.castSpell)) != null) {
            lore.add(ChatColor.AQUA + this.getMessage("spell_aura").replace("$spell", spell.getName()));
        }
        for (Map.Entry<PotionEffectType, Integer> effect : this.potionEffects.entrySet()) {
            String effectName = effect.getKey().getName();
            String effectFirst = effectName.substring(0, 1);
            effectName = effectName.substring(1).toLowerCase().replace("_", " ");
            effectName = effectFirst + effectName;
            lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.potion_effect", effect.getValue().intValue(), 5.0f).replace("$effect", effectName));
        }
        if (this.consumeReduction > 0.0f) {
            lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.consume_reduction", this.consumeReduction));
        }
        if (this.costReduction > 0.0f) {
            lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.cost_reduction", this.costReduction));
        }
        if (this.cooldownReduction > 0.0f) {
            lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.cooldown_reduction", this.cooldownReduction));
        }
        if (this.power > 0.0f) {
            lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.power", this.power));
        }
        if (this.superProtected) {
            lore.add(ChatColor.DARK_AQUA + this.getMessage("super_protected"));
        } else {
            if (this.damageReduction > 0.0f) {
                lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.protection", this.damageReduction));
            }
            if (this.damageReductionPhysical > 0.0f) {
                lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.protection_physical", this.damageReductionPhysical));
            }
            if (this.damageReductionProjectiles > 0.0f) {
                lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.protection_projectile", this.damageReductionProjectiles));
            }
            if (this.damageReductionFalling > 0.0f) {
                lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.protection_fall", this.damageReductionFalling));
            }
            if (this.damageReductionFire > 0.0f) {
                lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.protection_fire", this.damageReductionFire));
            }
            if (this.damageReductionExplosions > 0.0f) {
                lore.add(ChatColor.AQUA + Wand.getLevelString(this.controller.getMessages(), "wand.protection_blast", this.damageReductionExplosions));
            }
        }
    }

    public static String getLevelString(Messages messages, String templateName, float amount) {
        return Wand.getLevelString(messages, templateName, amount, 1.0f);
    }

    public static String getLevelString(Messages messages, String templateName, float amount, float max) {
        String templateString = messages.get(templateName);
        if (templateString.contains("$roman")) {
            if (max != 1.0f) {
                amount /= max;
            }
            templateString = templateString.replace("$roman", Wand.getRomanString(messages, amount));
        }
        return templateString.replace("$amount", Integer.toString((int)amount));
    }

    public static String getPercentageString(Messages messages, String templateName, float amount) {
        String templateString = messages.get(templateName);
        return templateString.replace("$amount", Integer.toString((int)(amount * 100.0f)));
    }

    private static String getRomanString(Messages messages, float amount) {
        String roman = "";
        roman = amount > 1.0f ? messages.get("wand.enchantment_level_max") : ((double)amount > 0.8 ? messages.get("wand.enchantment_level_5") : ((double)amount > 0.6 ? messages.get("wand.enchantment_level_4") : ((double)amount > 0.4 ? messages.get("wand.enchantment_level_3") : ((double)amount > 0.2 ? messages.get("wand.enchantment_level_2") : messages.get("wand.enchantment_level_1")))));
        return roman;
    }

    protected List<String> getLore(int spellCount, int materialCount) {
        int remaining;
        ArrayList<String> lore = new ArrayList<String>();
        if (this.description.length() > 0) {
            if (this.description.contains("$path")) {
                String pathName = "Unknown";
                com.elmakers.mine.bukkit.api.wand.WandUpgradePath path = this.getPath();
                if (path != null) {
                    pathName = path.getName();
                }
                String description = this.description;
                description = description.replace("$path", pathName);
                InventoryUtils.wrapText(ChatColor.ITALIC + "" + ChatColor.GREEN, description, MAX_LORE_LENGTH, lore);
            } else if (this.description.contains("$")) {
                String randomDescription = this.getMessage("randomized_lore");
                if (randomDescription.length() > 0) {
                    InventoryUtils.wrapText(ChatColor.ITALIC + "" + ChatColor.DARK_GREEN, randomDescription, MAX_LORE_LENGTH, lore);
                }
            } else {
                InventoryUtils.wrapText(ChatColor.ITALIC + "" + ChatColor.GREEN, this.description, MAX_LORE_LENGTH, lore);
            }
        }
        if (this.randomize) {
            return lore;
        }
        SpellTemplate spell = this.controller.getSpellTemplate(this.activeSpell);
        Messages messages = this.controller.getMessages();
        if (spell != null && spellCount == 1 && !this.hasInventory && !this.isUpgrade && this.hasPath() && !spell.isHidden()) {
            Wand.addSpellLore(messages, spell, lore, this.getActivePlayer(), this);
        } else if (spell != null && spellCount == 1 && !this.isUpgrade && this.hasPath()) {
            long effectiveDuration;
            String cooldownDescription = spell.getCooldownDescription();
            if (cooldownDescription != null && !cooldownDescription.isEmpty()) {
                lore.add(messages.get("cooldown.description").replace("$time", cooldownDescription));
            }
            if ((effectiveDuration = spell.getDuration()) > 0L) {
                long seconds = effectiveDuration / 1000L;
                if (seconds > 3600L) {
                    long hours = seconds / 3600L;
                    lore.add(ChatColor.GRAY + messages.get("duration.lasts_hours").replace("$hours", Long.valueOf(hours).toString()));
                } else if (seconds > 60L) {
                    long minutes = seconds / 60L;
                    lore.add(ChatColor.GRAY + messages.get("duration.lasts_minutes").replace("$minutes", Long.valueOf(minutes).toString()));
                } else {
                    lore.add(ChatColor.GRAY + messages.get("duration.lasts_seconds").replace("$seconds", Long.valueOf(seconds).toString()));
                }
            }
        }
        if (materialCount == 1 && this.activeMaterial != null && this.activeMaterial.length() > 0) {
            lore.add(Wand.getBrushDisplayName(messages, com.elmakers.mine.bukkit.block.MaterialBrush.parseMaterialKey(this.activeMaterial)));
        }
        if (!this.isUpgrade && this.owner.length() > 0) {
            String ownerDescription;
            if (this.bound) {
                if (this.soul) {
                    ownerDescription = this.getMessage("soulbound_description", "$name").replace("$name", this.owner);
                    lore.add(ChatColor.ITALIC + "" + ChatColor.DARK_AQUA + ownerDescription);
                } else {
                    ownerDescription = this.getMessage("bound_description", "$name").replace("$name", this.owner);
                    lore.add(ChatColor.ITALIC + "" + ChatColor.DARK_AQUA + ownerDescription);
                }
            } else {
                ownerDescription = this.getMessage("owner_description", "$name").replace("$name", this.owner);
                lore.add(ChatColor.ITALIC + "" + ChatColor.DARK_GREEN + ownerDescription);
            }
        }
        if (spellCount > 0) {
            if (this.isUpgrade) {
                lore.add(this.getMessage("upgrade_spell_count").replace("$count", Integer.valueOf(spellCount).toString()));
            } else if (spellCount > 1) {
                lore.add(this.getMessage("spell_count").replace("$count", Integer.valueOf(spellCount).toString()));
            }
        }
        if (materialCount > 0) {
            if (this.isUpgrade) {
                lore.add(this.getMessage("upgrade_material_count").replace("$count", Integer.valueOf(materialCount).toString()));
            } else if (materialCount > 1) {
                lore.add(this.getMessage("material_count").replace("$count", Integer.valueOf(materialCount).toString()));
            }
        }
        if ((remaining = this.getRemainingUses()) > 0) {
            if (this.isUpgrade) {
                String message = remaining == 1 ? this.getMessage("upgrade_uses_singular") : this.getMessage("upgrade_uses");
                lore.add(ChatColor.RED + message.replace("$count", Integer.valueOf(remaining).toString()));
            } else {
                String message = remaining == 1 ? this.getMessage("uses_remaining_singular") : this.getMessage("uses_remaining_brief");
                lore.add(ChatColor.RED + message.replace("$count", Integer.valueOf(remaining).toString()));
            }
        }
        this.addPropertyLore(lore);
        if (this.isUpgrade) {
            lore.add(ChatColor.YELLOW + this.getMessage("upgrade_item_description"));
        }
        return lore;
    }

    protected void updateLore() {
        CompatibilityUtils.setLore(this.item, this.getLore());
        if (this.glow) {
            CompatibilityUtils.addGlow(this.item);
        }
    }

    public void save() {
        this.saveItemState();
        this.updateName();
        this.updateLore();
    }

    public int getRemainingUses() {
        return this.uses;
    }

    public void makeEnchantable(boolean enchantable) {
        if (EnchantableWandMaterial == null) {
            return;
        }
        if (!enchantable) {
            this.item.setType(this.icon.getMaterial());
            this.item.setDurability(this.icon.getData().shortValue());
        } else {
            Set<Material> enchantableMaterials = this.controller.getMaterialSet("enchantable");
            if (!enchantableMaterials.contains(this.item.getType())) {
                this.item.setType(EnchantableWandMaterial);
                this.item.setDurability((short)0);
            }
        }
        this.updateName();
    }

    public static boolean hasActiveWand(Player player) {
        if (player == null) {
            return false;
        }
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    public static Wand getActiveWand(MagicController spells, Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        if (Wand.isWand(activeItem)) {
            return new Wand(spells, activeItem);
        }
        return null;
    }

    public static boolean isWand(ItemStack item) {
        return item != null && InventoryUtils.hasMeta(item, WAND_KEY) && !Wand.isUpgrade(item);
    }

    public static boolean isBound(ItemStack item) {
        Object wandSection = InventoryUtils.getNode(item, WAND_KEY);
        if (wandSection == null) {
            return false;
        }
        String boundValue = InventoryUtils.getMeta(wandSection, "bound");
        return boundValue != null && boundValue.equalsIgnoreCase("true");
    }

    public static boolean isSelfDestructWand(ItemStack item) {
        return item != null && WAND_SELF_DESTRUCT_KEY != null && InventoryUtils.hasMeta(item, WAND_SELF_DESTRUCT_KEY);
    }

    public static boolean isSP(ItemStack item) {
        return InventoryUtils.hasMeta(item, "sp");
    }

    public static Integer getSP(ItemStack item) {
        if (item == null) {
            return null;
        }
        String spNode = InventoryUtils.getMeta(item, "sp");
        if (spNode == null) {
            return null;
        }
        Integer sp = null;
        try {
            sp = Integer.parseInt(spNode);
        }
        catch (Exception ex) {
            sp = null;
        }
        return sp;
    }

    public static boolean isSingleUse(ItemStack item) {
        if (item == null) {
            return false;
        }
        Object wandNode = InventoryUtils.getNode(item, WAND_KEY);
        if (wandNode == null) {
            return false;
        }
        String useCount = InventoryUtils.getMeta(wandNode, "uses");
        String wandId = InventoryUtils.getMeta(wandNode, "id");
        return useCount != null && useCount.equals("1") && (wandId == null || wandId.isEmpty());
    }

    public static boolean isUpgrade(ItemStack item) {
        if (item == null) {
            return false;
        }
        Object wandNode = InventoryUtils.getNode(item, WAND_KEY);
        if (wandNode == null) {
            return false;
        }
        String upgradeData = InventoryUtils.getMeta(wandNode, "upgrade");
        return upgradeData != null && upgradeData.equals("true");
    }

    public static boolean isSpell(ItemStack item) {
        return item != null && InventoryUtils.hasMeta(item, "spell");
    }

    public static boolean isSkill(ItemStack item) {
        return item != null && InventoryUtils.hasMeta(item, "skill");
    }

    public static boolean isBrush(ItemStack item) {
        return item != null && InventoryUtils.hasMeta(item, "brush");
    }

    public static String getWandTemplate(ItemStack item) {
        Object wandNode = InventoryUtils.getNode(item, WAND_KEY);
        if (wandNode == null) {
            return null;
        }
        return InventoryUtils.getMeta(wandNode, "template");
    }

    public static String getWandId(ItemStack item) {
        Object wandNode = InventoryUtils.getNode(item, WAND_KEY);
        if (wandNode == null || Wand.isUpgrade(item)) {
            return null;
        }
        if (Wand.isSingleUse(item)) {
            return Wand.getWandTemplate(item);
        }
        return InventoryUtils.getMeta(wandNode, "id");
    }

    public static String getSpell(ItemStack item) {
        Object spellNode = InventoryUtils.getNode(item, "spell");
        if (spellNode == null) {
            return null;
        }
        return InventoryUtils.getMeta(spellNode, "key");
    }

    public static String getSpellArgs(ItemStack item) {
        Object spellNode = InventoryUtils.getNode(item, "spell");
        if (spellNode == null) {
            return null;
        }
        return InventoryUtils.getMeta(spellNode, "args");
    }

    public static String getBrush(ItemStack item) {
        Object brushNode = InventoryUtils.getNode(item, "brush");
        if (brushNode == null) {
            return null;
        }
        return InventoryUtils.getMeta(brushNode, "key");
    }

    protected void updateInventoryName(ItemStack item, boolean activeName) {
        if (Wand.isSpell(item)) {
            MageSpell spell = this.mage.getSpell(Wand.getSpell(item));
            if (spell != null) {
                Wand.updateSpellItem(this.controller.getMessages(), item, spell, "", this.getActivePlayer(), activeName ? this : null, this.activeMaterial, false);
            }
        } else if (Wand.isBrush(item)) {
            Wand.updateBrushItem(this.controller.getMessages(), item, Wand.getBrush(item), activeName ? this : null);
        }
    }

    public static void updateSpellItem(Messages messages, ItemStack itemStack, SpellTemplate spell, String args, Wand wand, String activeMaterial, boolean isItem) {
        Wand.updateSpellItem(messages, itemStack, spell, args, wand == null ? null : wand.getActivePlayer(), wand, activeMaterial, isItem);
    }

    public static void updateSpellItem(Messages messages, ItemStack itemStack, SpellTemplate spell, String args, com.elmakers.mine.bukkit.api.magic.Mage mage, Wand wand, String activeMaterial, boolean isItem) {
        String displayName = wand != null && !wand.isQuickCast() ? wand.getActiveWandName(spell) : Wand.getSpellDisplayName(messages, spell, com.elmakers.mine.bukkit.block.MaterialBrush.parseMaterialKey(activeMaterial));
        CompatibilityUtils.setDisplayName(itemStack, displayName);
        ArrayList<String> lore = new ArrayList<String>();
        Wand.addSpellLore(messages, spell, lore, mage, wand);
        if (isItem) {
            lore.add(ChatColor.YELLOW + messages.get("wand.spell_item_description"));
        }
        CompatibilityUtils.setLore(itemStack, lore);
        Object spellNode = CompatibilityUtils.createNode(itemStack, "spell");
        CompatibilityUtils.setMeta(spellNode, "key", spell.getKey());
        CompatibilityUtils.setMeta(spellNode, "args", args);
        if (SpellGlow) {
            CompatibilityUtils.addGlow(itemStack);
        }
    }

    public static void updateBrushItem(Messages messages, ItemStack itemStack, String materialKey, Wand wand) {
        Wand.updateBrushItem(messages, itemStack, com.elmakers.mine.bukkit.block.MaterialBrush.parseMaterialKey(materialKey), wand);
    }

    public static void updateBrushItem(Messages messages, ItemStack itemStack, com.elmakers.mine.bukkit.block.MaterialBrush brush, Wand wand) {
        Spell activeSpell;
        String displayName = wand != null ? ((activeSpell = wand.getActiveSpell()) != null && activeSpell.usesBrush() ? wand.getActiveWandName(brush) : ChatColor.RED + brush.getName(messages)) : brush.getName(messages);
        CompatibilityUtils.setDisplayName(itemStack, displayName);
        Object brushNode = CompatibilityUtils.createNode(itemStack, "brush");
        CompatibilityUtils.setMeta(brushNode, "key", brush.getKey());
    }

    public void updateHotbar() {
        if (this.mage == null) {
            return;
        }
        if (!this.isInventoryOpen()) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        if (!this.hasStoredInventory()) {
            return;
        }
        WandMode wandMode = this.getMode();
        if (wandMode == WandMode.INVENTORY) {
            PlayerInventory inventory = player.getInventory();
            this.updateHotbar(inventory);
            player.updateInventory();
        }
    }

    private void updateInventory() {
        if (this.mage == null) {
            return;
        }
        if (!this.isInventoryOpen()) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        WandMode wandMode = this.getMode();
        if (wandMode == WandMode.INVENTORY) {
            if (!this.hasStoredInventory()) {
                return;
            }
            PlayerInventory inventory = player.getInventory();
            for (int i = 0; i < 36; ++i) {
                inventory.setItem(i, null);
            }
            this.updateHotbar(inventory);
            this.updateInventory((Inventory)inventory, false);
            this.updateName();
            player.updateInventory();
        } else if (wandMode == WandMode.CHEST) {
            Inventory inventory = this.getDisplayInventory();
            inventory.clear();
            this.updateInventory(inventory, true);
            player.updateInventory();
        }
    }

    private void updateHotbar(PlayerInventory playerInventory) {
        if (this.getMode() != WandMode.INVENTORY) {
            return;
        }
        Inventory hotbar = this.getHotbar();
        if (hotbar == null) {
            return;
        }
        int currentSlot = playerInventory.getHeldItemSlot();
        ItemStack currentItem = playerInventory.getItem(currentSlot);
        String currentId = Wand.getWandId(currentItem);
        if (currentId != null && !currentId.equals(this.id)) {
            return;
        }
        playerInventory.setItemInHand(this.item);
        int targetOffset = 0;
        for (int hotbarSlot = 0; hotbarSlot < 8; ++hotbarSlot) {
            if (hotbarSlot == currentSlot) {
                targetOffset = 1;
            }
            ItemStack hotbarItem = hotbar.getItem(hotbarSlot);
            this.updateInventoryName(hotbarItem, true);
            playerInventory.setItem(hotbarSlot + targetOffset, hotbarItem);
        }
    }

    private void updateInventory(Inventory targetInventory, boolean addHotbars) {
        ItemStack inventoryItem;
        int i;
        ItemStack[] contents;
        Inventory inventory;
        int currentOffset = addHotbars ? 0 : 9;
        List<Inventory> inventories = this.inventories;
        if (this.openInventoryPage < inventories.size()) {
            inventory = inventories.get(this.openInventoryPage);
            contents = inventory.getContents();
            for (i = 0; i < contents.length; ++i) {
                inventoryItem = contents[i];
                this.updateInventoryName(inventoryItem, false);
                targetInventory.setItem(currentOffset, inventoryItem);
                ++currentOffset;
            }
        }
        if (addHotbars && this.openInventoryPage < this.hotbars.size()) {
            inventory = this.hotbars.get(this.openInventoryPage);
            contents = inventory.getContents();
            for (i = 0; i < contents.length; ++i) {
                inventoryItem = contents[i];
                this.updateInventoryName(inventoryItem, false);
                targetInventory.setItem(currentOffset, inventoryItem);
                ++currentOffset;
            }
        }
    }

    protected static void addSpellLore(Messages messages, SpellTemplate spell, List<String> lore, com.elmakers.mine.bukkit.api.magic.Mage mage, Wand wand) {
        spell.addLore(messages, mage, wand, lore);
    }

    protected Inventory getOpenInventory() {
        while (this.openInventoryPage >= this.inventories.size()) {
            this.inventories.add(CompatibilityUtils.createInventory(null, 27, "Wand"));
        }
        return this.inventories.get(this.openInventoryPage);
    }

    public void saveInventory() {
        if (this.mage == null) {
            return;
        }
        if (!this.isInventoryOpen()) {
            return;
        }
        if (this.mage.getPlayer() == null) {
            return;
        }
        if (this.getMode() != WandMode.INVENTORY) {
            return;
        }
        if (!this.hasStoredInventory()) {
            return;
        }
        if (this.mage.isDead()) {
            return;
        }
        Player player = this.mage.getPlayer();
        PlayerInventory playerInventory = player.getInventory();
        Inventory hotbar = this.getHotbar();
        if (hotbar != null) {
            int saveOffset = 0;
            for (int i = 0; i < 9; ++i) {
                ItemStack playerItem = playerInventory.getItem(i);
                if (Wand.isWand(playerItem)) {
                    saveOffset = -1;
                    continue;
                }
                int hotbarOffset = i + saveOffset;
                if (hotbarOffset >= hotbar.getSize()) break;
                if (!this.updateSlot(i + saveOffset + this.currentHotbar * 8, playerItem)) {
                    playerItem = new ItemStack(Material.AIR);
                    playerInventory.setItem(i, playerItem);
                }
                hotbar.setItem(i + saveOffset, playerItem);
            }
        }
        int hotbarOffset = this.getHotbarSize();
        Inventory openInventory = this.getOpenInventory();
        for (int i = 0; i < openInventory.getSize(); ++i) {
            ItemStack playerItem = playerInventory.getItem(i + 9);
            if (!this.updateSlot(i + hotbarOffset + this.openInventoryPage * 27, playerItem)) {
                playerItem = new ItemStack(Material.AIR);
                playerInventory.setItem(i + 9, playerItem);
            }
            openInventory.setItem(i, playerItem);
        }
    }

    protected boolean updateSlot(int slot, ItemStack item) {
        String spellKey = Wand.getSpell(item);
        if (spellKey != null) {
            this.spells.put(spellKey, slot);
        } else {
            String brushKey = Wand.getBrush(item);
            if (brushKey != null) {
                this.brushes.put(brushKey, slot);
            } else if (this.mage != null && item != null && item.getType() != Material.AIR) {
                this.mage.giveItem(item);
                return false;
            }
        }
        return true;
    }

    @Override
    public int enchant(int totalLevels, com.elmakers.mine.bukkit.api.magic.Mage mage, boolean addSpells) {
        return this.randomize(totalLevels, true, mage, addSpells);
    }

    @Override
    public int enchant(int totalLevels, com.elmakers.mine.bukkit.api.magic.Mage mage) {
        return this.randomize(totalLevels, true, mage, true);
    }

    @Override
    public int enchant(int totalLevels) {
        return this.randomize(totalLevels, true, null, true);
    }

    protected int randomize(int totalLevels, boolean additive, com.elmakers.mine.bukkit.api.magic.Mage enchanter, boolean addSpells) {
        if (enchanter == null && this.mage != null) {
            enchanter = this.mage;
        }
        if (this.maxEnchantCount > 0 && this.enchantCount >= this.maxEnchantCount) {
            if (enchanter != null) {
                enchanter.sendMessage(this.getMessage("max_enchanted").replace("$wand", this.getName()));
            }
            return 0;
        }
        WandUpgradePath path = (WandUpgradePath)this.getPath();
        if (path == null) {
            if (enchanter != null) {
                enchanter.sendMessage(this.getMessage("no_path").replace("$wand", this.getName()));
            }
            return 0;
        }
        int minLevel = path.getMinLevel();
        if (totalLevels < minLevel) {
            if (enchanter != null) {
                String levelMessage = this.getMessage("need_more_levels");
                levelMessage = levelMessage.replace("$levels", Integer.toString(minLevel));
                enchanter.sendMessage(levelMessage);
            }
            return 0;
        }
        int maxLevel = path.getMaxLevel();
        totalLevels = Math.min(totalLevels, maxLevel * 50);
        int addLevels = Math.min(totalLevels, maxLevel);
        int levels = 0;
        boolean modified = true;
        while (addLevels >= minLevel && modified) {
            WandUpgradePath nextPath;
            boolean hasUpgrade = path.hasUpgrade();
            WandLevel level = path.getLevel(addLevels);
            if (!path.canEnchant(this) && (path.hasSpells() || path.hasMaterials())) {
                nextPath = path.getUpgrade();
                if (nextPath != null) {
                    if (!path.checkUpgradeRequirements(this, enchanter)) break;
                    path.upgrade(this, enchanter);
                    break;
                }
                enchanter.sendMessage(this.getMessage("fully_enchanted").replace("$wand", this.getName()));
                break;
            }
            modified = level.randomizeWand(enchanter, this, additive, hasUpgrade, addSpells);
            totalLevels -= maxLevel;
            if (modified) {
                if (enchanter != null) {
                    path.enchanted(enchanter);
                }
                levels += addLevels;
                nextPath = path.getUpgrade();
                if (nextPath != null && path.checkUpgradeRequirements(this, null) && !path.canEnchant(this)) {
                    path.upgrade(this, enchanter);
                    path = nextPath;
                }
            } else if (path.canEnchant(this)) {
                if (enchanter != null && levels == 0 && addSpells) {
                    String message = this.getMessage("require_more_levels");
                    enchanter.sendMessage(message);
                }
            } else if (hasUpgrade) {
                if (path.checkUpgradeRequirements(this, enchanter)) {
                    path.upgrade(this, enchanter);
                    levels += addLevels;
                }
            } else if (enchanter != null) {
                enchanter.sendMessage(this.getMessage("fully_enchanted").replace("$wand", this.getName()));
            }
            addLevels = Math.min(totalLevels, maxLevel);
            additive = true;
        }
        if (levels > 0) {
            ++this.enchantCount;
        }
        this.saveItemState();
        this.updateName();
        this.updateLore();
        return levels;
    }

    public static ItemStack createItem(MagicController controller, String templateName) {
        Wand wand;
        ItemStack item = Wand.createSpellItem(templateName, controller, null, true);
        if (item == null && (item = Wand.createBrushItem(templateName, controller, null, true)) == null && (wand = Wand.createWand(controller, templateName)) != null) {
            item = wand.getItem();
        }
        return item;
    }

    public static Wand createWand(MagicController controller, String templateName) {
        if (controller == null) {
            return null;
        }
        Wand wand = null;
        try {
            wand = new Wand(controller, templateName);
        }
        catch (UnknownWandException ignore) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return wand;
    }

    public static Wand createWand(MagicController controller, ItemStack itemStack) {
        if (controller == null) {
            return null;
        }
        Wand wand = null;
        try {
            wand = new Wand(controller, InventoryUtils.makeReal(itemStack));
            wand.saveItemState();
            wand.updateName();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return wand;
    }

    protected void sendAddMessage(com.elmakers.mine.bukkit.api.magic.Mage mage, String messageKey, String nameParam) {
        if (mage == null) {
            return;
        }
        String message = this.getMessage(messageKey).replace("$name", nameParam).replace("$wand", this.getName());
        mage.sendMessage(message);
    }

    public boolean add(Wand other) {
        return this.add(other, (com.elmakers.mine.bukkit.api.magic.Mage)this.mage);
    }

    @Override
    public boolean add(com.elmakers.mine.bukkit.api.wand.Wand other, com.elmakers.mine.bukkit.api.magic.Mage mage) {
        if (other instanceof Wand) {
            return this.add((Wand)other, mage);
        }
        return false;
    }

    public boolean add(Wand other, com.elmakers.mine.bukkit.api.magic.Mage mage) {
        Player player;
        int newCount;
        if (!(this.isModifiable() || other.isUpgrade() && other.path != null && this.path != null && !other.path.isEmpty() && !this.path.isEmpty() && other.path.equals(this.path))) {
            return false;
        }
        if (this.hasUses || other.hasUses) {
            return false;
        }
        if (this.isHeroes || other.isHeroes) {
            return false;
        }
        if (other.isForcedUpgrade()) {
            String template = other.getTemplateKey();
            ConfigurationSection templateConfig = this.controller.getWandTemplateConfiguration(template);
            if (templateConfig == null) {
                return false;
            }
            templateConfig = ConfigurationUtils.cloneConfiguration(templateConfig);
            templateConfig.set("name", (Object)templateConfig.getString("upgrade_name"));
            templateConfig.set("description", (Object)templateConfig.getString("upgrade_description"));
            templateConfig.set("force", null);
            templateConfig.set("upgrade", null);
            templateConfig.set("icon", (Object)templateConfig.getString("upgrade_icon"));
            templateConfig.set("indestructible", null);
            templateConfig.set("key", null);
            this.loadProperties(templateConfig, false);
            this.saveItemState();
            return true;
        }
        if (!(!other.isUpgrade() || other.path == null || other.path.isEmpty() || this.path != null && this.path.equals(other.path))) {
            return false;
        }
        boolean modified = false;
        Messages messages = this.controller.getMessages();
        if (other.costReduction > this.costReduction) {
            this.costReduction = other.costReduction;
            modified = true;
            if (this.costReduction > 0.0f) {
                this.sendAddMessage(mage, "upgraded_property", Wand.getLevelString(messages, "wand.cost_reduction", this.costReduction));
            }
        }
        if (other.consumeReduction > this.consumeReduction) {
            this.consumeReduction = other.consumeReduction;
            modified = true;
            if (this.consumeReduction > 0.0f) {
                this.sendAddMessage(mage, "upgraded_property", Wand.getLevelString(messages, "wand.consume_reduction", this.consumeReduction));
            }
        }
        if (other.power > this.power) {
            this.power = other.power;
            modified = true;
            if (this.power > 0.0f) {
                this.sendAddMessage(mage, "upgraded_property", Wand.getLevelString(messages, "wand.power", this.power));
            }
        }
        if (other.damageReduction > this.damageReduction) {
            this.damageReduction = other.damageReduction;
            modified = true;
            if (this.damageReduction > 0.0f) {
                this.sendAddMessage(mage, "upgraded_property", Wand.getLevelString(messages, "wand.protection", this.damageReduction));
            }
        }
        if (other.damageReductionPhysical > this.damageReductionPhysical) {
            this.damageReductionPhysical = other.damageReductionPhysical;
            modified = true;
            if (this.damageReductionPhysical > 0.0f) {
                this.sendAddMessage(mage, "upgraded_property", Wand.getLevelString(messages, "wand.protection_physical", this.damageReductionPhysical));
            }
        }
        if (other.damageReductionProjectiles > this.damageReductionProjectiles) {
            this.damageReductionProjectiles = other.damageReductionProjectiles;
            modified = true;
            if (this.damageReductionProjectiles > 0.0f) {
                this.sendAddMessage(mage, "upgraded_property", Wand.getLevelString(messages, "wand.protection_projectile", this.damageReductionProjectiles));
            }
        }
        if (other.damageReductionFalling > this.damageReductionFalling) {
            this.damageReductionFalling = other.damageReductionFalling;
            modified = true;
            if (this.damageReductionFalling > 0.0f) {
                this.sendAddMessage(mage, "upgraded_property", Wand.getLevelString(messages, "wand.protection_fall", this.damageReductionFalling));
            }
        }
        if (other.damageReductionFire > this.damageReductionFire) {
            this.damageReductionFire = other.damageReductionFire;
            modified = true;
            if (this.damageReductionFire > 0.0f) {
                this.sendAddMessage(mage, "upgraded_property", Wand.getLevelString(messages, "wand.protection_fire", this.damageReductionFire));
            }
        }
        if (other.damageReductionExplosions > this.damageReductionExplosions) {
            this.damageReductionExplosions = other.damageReductionExplosions;
            modified = true;
            if (this.damageReductionExplosions > 0.0f) {
                this.sendAddMessage(mage, "upgraded_property", Wand.getLevelString(messages, "wand.protection_blast", this.damageReductionExplosions));
            }
        }
        if (other.manaRegenerationBoost > this.manaRegenerationBoost) {
            this.manaRegenerationBoost = other.manaRegenerationBoost;
            modified = true;
            if (this.manaRegenerationBoost > 0.0f) {
                this.sendAddMessage(mage, "upgraded_property", Wand.getLevelString(messages, "wand.mana_regeneration_boost", this.manaRegenerationBoost));
            }
        }
        if (other.manaMaxBoost > this.manaMaxBoost) {
            this.manaMaxBoost = other.manaMaxBoost;
            modified = true;
            if (this.manaMaxBoost > 0.0f) {
                this.sendAddMessage(mage, "upgraded_property", Wand.getLevelString(messages, "wand.mana_boost", this.manaMaxBoost));
            }
        }
        boolean needsInventoryUpdate = false;
        if (other.hotbars.size() > this.hotbars.size() && (newCount = Math.max(1, other.hotbars.size())) != this.hotbars.size()) {
            if (this.isInventoryOpen()) {
                this.closeInventory();
            }
            this.setHotbarCount(newCount);
            needsInventoryUpdate = true;
            modified = true;
            if (this.getMode() == WandMode.INVENTORY) {
                this.sendAddMessage(mage, "hotbar_added", Integer.toString(newCount));
            }
        }
        if (other.effectColor != null) {
            this.effectColor = this.effectColor == null || other.isUpgrade() && other.effectColor != null ? other.effectColor : this.effectColor.mixColor(other.effectColor, (double)other.effectColorMixWeight);
            modified = true;
        }
        if (other.rename && other.template != null && other.template.length() > 0) {
            ConfigurationSection template = this.controller.getWandTemplateConfiguration(other.template);
            this.wandName = messages.get("wands." + other.template + ".name", this.wandName);
            this.wandName = template.getString("name", this.wandName);
            this.updateName();
        }
        if (other.renameDescription && other.template != null && other.template.length() > 0) {
            ConfigurationSection template = this.controller.getWandTemplateConfiguration(other.template);
            this.description = messages.get("wands." + other.template + ".description", this.description);
            this.description = template.getString("description", this.description);
            this.updateLore();
        }
        if (other.quietLevel < 0) {
            int quiet = -other.quietLevel - 1;
            modified = this.quietLevel != quiet;
            this.quietLevel = quiet;
        }
        for (Map.Entry<PotionEffectType, Integer> otherEffects : other.potionEffects.entrySet()) {
            Integer current = this.potionEffects.get(otherEffects.getKey());
            if (current != null && current >= otherEffects.getValue()) continue;
            this.potionEffects.put(otherEffects.getKey(), otherEffects.getValue());
            modified = true;
        }
        modified |= !this.keep && other.keep;
        modified |= !this.bound && other.bound;
        modified |= !this.effectBubbles && other.effectBubbles;
        modified |= !this.undroppable && other.undroppable;
        modified |= !this.indestructible && other.indestructible;
        modified |= !this.superPowered && other.superPowered;
        modified |= !this.superProtected && other.superProtected;
        modified |= !this.glow && other.glow;
        this.keep = this.keep || other.keep;
        this.bound = this.bound || other.bound;
        this.indestructible = this.indestructible || other.indestructible;
        this.superPowered = this.superPowered || other.superPowered;
        this.superProtected = this.superProtected || other.superProtected;
        this.glow = this.glow || other.glow;
        this.undroppable = this.undroppable || other.undroppable;
        boolean bl = this.effectBubbles = this.effectBubbles || other.effectBubbles;
        if (other.effectParticle != null && (other.isUpgrade || this.effectParticle == null)) {
            modified |= this.effectParticle != other.effectParticle;
            this.effectParticle = other.effectParticle;
            modified |= this.effectParticleData != other.effectParticleData;
            this.effectParticleData = other.effectParticleData;
            modified |= this.effectParticleCount != other.effectParticleCount;
            this.effectParticleCount = other.effectParticleCount;
            modified |= this.effectParticleInterval != other.effectParticleInterval;
            this.effectParticleInterval = other.effectParticleInterval;
            modified |= this.effectParticleRadius != other.effectParticleRadius;
            this.effectParticleRadius = other.effectParticleRadius;
            modified |= this.effectParticleOffset != other.effectParticleOffset;
            this.effectParticleOffset = other.effectParticleOffset;
            modified |= this.effectParticleMinVelocity < other.effectParticleOffset;
            this.effectParticleMinVelocity = Math.max(this.effectParticleMinVelocity, other.effectParticleMinVelocity);
        }
        if (other.castSpell != null && (other.isUpgrade || this.castSpell == null || !this.castSpell.equals(other.castSpell))) {
            modified = true;
            this.castSpell = other.castSpell;
            this.castParameters = ConfigurationUtils.addConfigurations(this.castParameters, other.castParameters);
            this.castInterval = other.castInterval;
            this.castVelocityDirection = other.castVelocityDirection;
            this.castMinVelocity = other.castMinVelocity;
        }
        if (other.effectSound != null && (other.isUpgrade || this.effectSound == null)) {
            modified |= this.effectSound == null || !this.effectSound.equals(other.effectSound);
            this.effectSound = other.effectSound;
            modified |= this.effectSoundInterval != other.effectSoundInterval;
            this.effectSoundInterval = other.effectSoundInterval;
        }
        if ((this.template == null || this.template.length() == 0) && other.template != null && other.template.length() > 0) {
            modified = true;
            this.template = other.template;
        }
        if (other.isUpgrade && other.upgradeTemplate != null && (this.template == null || !this.template.equals(other.template))) {
            this.template = other.upgradeTemplate;
            modified = true;
        }
        if (other.isUpgrade && other.mode != null && this.mode != other.mode) {
            if (this.isInventoryOpen()) {
                this.closeInventory();
            }
            needsInventoryUpdate = true;
            modified = true;
            this.setMode(other.mode);
        }
        if (needsInventoryUpdate) {
            String wandSpells = this.getSpellString();
            String wandMaterials = this.getMaterialString();
            if (wandMaterials.length() > 0 || wandSpells.length() > 0) {
                this.parseInventoryStrings(wandSpells, wandMaterials);
            }
        }
        if (other.isUpgrade && other.brushMode != null) {
            modified |= this.brushMode != other.brushMode;
            this.setBrushMode(other.brushMode);
        }
        if (other.upgradeIcon != null && (this.icon == null || this.icon.getMaterial() != other.upgradeIcon.getMaterial() || this.icon.getData() != other.upgradeIcon.getData())) {
            modified = true;
            this.setIcon(other.upgradeIcon);
        }
        if (other.isUpgrade && other.inactiveIcon != null && other.inactiveIcon.getMaterial() != Material.AIR && other.inactiveIcon.getMaterial() != null && (this.inactiveIcon == null || this.inactiveIcon.getMaterial() != other.inactiveIcon.getMaterial() || this.inactiveIcon.getData() != other.inactiveIcon.getData())) {
            this.inactiveIcon = other.inactiveIcon;
            this.inactiveIcon.applyToItem(this.item);
            modified = true;
        }
        if (this.isCostFree()) {
            this.manaRegeneration = 0;
            this.manaMax = 0;
            this.mana = 0.0f;
        } else {
            if (other.manaRegeneration > this.manaRegeneration) {
                this.manaRegeneration = other.manaRegeneration;
                modified = true;
                this.sendAddMessage(mage, "upgraded_property", Wand.getLevelString(messages, "wand.mana_regeneration", this.manaRegeneration, this.controller.getMaxManaRegeneration()));
            }
            if (other.manaPerDamage > this.manaPerDamage) {
                this.manaPerDamage = other.manaPerDamage;
                modified = true;
                this.sendAddMessage(mage, "upgraded_property", Wand.getLevelString(messages, "wand.mana_per_damage", this.manaPerDamage, this.controller.getMaxManaRegeneration()));
            }
            if (other.manaMax > this.manaMax) {
                this.manaMax = other.manaMax;
                modified = true;
                this.sendAddMessage(mage, "upgraded_property", Wand.getLevelString(messages, "wand.mana_amount", this.manaMax, this.controller.getMaxMana()));
            }
            if (other.mana > this.mana) {
                float previousMana = this.mana;
                this.mana = Math.min((float)this.manaMax, other.mana);
                if (this.mana > previousMana) {
                    if (mage != null) {
                        String message = this.getMessage("mana_added").replace("$value", Integer.toString((int)this.mana)).replace("$wand", this.getName());
                        mage.sendMessage(message);
                    }
                    modified = true;
                }
            }
        }
        Collection spells = other.getSpells();
        for (String spellKey : spells) {
            SpellTemplate currentSpell = this.getBaseSpell(spellKey);
            if (!this.addSpell(spellKey)) continue;
            modified = true;
            String spellName = spellKey;
            SpellTemplate spell = this.controller.getSpellTemplate(spellKey);
            if (spell != null) {
                spellName = spell.getName();
            }
            if (mage == null) continue;
            if (currentSpell != null) {
                String levelDescription = spell.getLevelDescription();
                if (levelDescription == null || levelDescription.isEmpty()) {
                    levelDescription = spellName;
                }
                mage.sendMessage(messages.get("wand.spell_upgraded").replace("$name", currentSpell.getName()).replace("$level", levelDescription).replace("$wand", this.getName()));
                mage.sendMessage(spell.getUpgradeDescription().replace("$name", currentSpell.getName()));
                SpellUpgradeEvent upgradeEvent = new SpellUpgradeEvent(mage, this, currentSpell, spell);
                Bukkit.getPluginManager().callEvent((Event)upgradeEvent);
                continue;
            }
            mage.sendMessage(messages.get("wand.spell_added").replace("$name", spellName).replace("$wand", this.getName()));
            AddSpellEvent addEvent = new AddSpellEvent(mage, this, spell);
            Bukkit.getPluginManager().callEvent((Event)addEvent);
        }
        Collection materials = other.getBrushes();
        for (String materialKey : materials) {
            if (!this.addBrush(materialKey)) continue;
            modified = true;
            if (mage == null) continue;
            mage.sendMessage(messages.get("wand.brush_added").replace("$wand", this.getName()).replace("$name", com.elmakers.mine.bukkit.block.MaterialBrush.getMaterialName(messages, materialKey)));
        }
        if (other.castOverrides != null && other.castOverrides.size() > 0) {
            if (this.castOverrides == null) {
                this.castOverrides = new HashMap<String, String>();
            }
            HashSet<String> upgradedSpells = new HashSet<String>();
            for (Map.Entry<String, String> entry : other.castOverrides.entrySet()) {
                String overrideKey = entry.getKey();
                String currentValue = this.castOverrides.get(overrideKey);
                String value = entry.getValue();
                if (currentValue != null) {
                    try {
                        double currentDouble = Double.parseDouble(currentValue);
                        double newDouble = Double.parseDouble(value);
                        if (newDouble < currentDouble) {
                            value = currentValue;
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                boolean addOverride = currentValue == null || !value.equals(currentValue);
                boolean bl2 = modified = modified || addOverride;
                if (addOverride && mage != null && overrideKey.contains(".")) {
                    String spellKey;
                    String[] pieces = StringUtils.split((String)overrideKey, (char)'.');
                    String spellName = spellKey = pieces[0];
                    if (!upgradedSpells.contains(spellKey)) {
                        SpellTemplate spell = this.controller.getSpellTemplate(spellKey);
                        if (spell != null) {
                            spellName = spell.getName();
                        }
                        mage.sendMessage(messages.get("wand.spell_override_upgraded").replace("$name", spellName));
                        upgradedSpells.add(spellKey);
                    }
                }
                this.castOverrides.put(entry.getKey(), entry.getValue());
            }
        }
        Player player2 = player = mage == null ? null : mage.getPlayer();
        if (other.autoFill && player != null) {
            this.fill(player, this.controller.getMaxWandFillLevel());
            modified = true;
            if (mage != null) {
                mage.sendMessage(this.getMessage("filled").replace("$wand", this.getName()));
            }
        }
        if (other.autoOrganize && mage != null) {
            this.organizeInventory(mage);
            modified = true;
            if (mage != null) {
                mage.sendMessage(this.getMessage("reorganized").replace("$wand", this.getName()));
            }
        }
        if (other.autoAlphabetize) {
            this.alphabetizeInventory();
            modified = true;
            if (mage != null) {
                mage.sendMessage(this.getMessage("alphabetized").replace("$wand", this.getName()));
            }
        }
        this.saveItemState();
        this.updateName();
        this.updateMaxMana(false);
        this.updateLore();
        return modified;
    }

    public boolean isForcedUpgrade() {
        return this.isUpgrade && this.forceUpgrade;
    }

    public boolean keepOnDeath() {
        return this.keep;
    }

    public static WandMode parseWandMode(String modeString, WandMode defaultValue) {
        if (modeString != null && !modeString.isEmpty()) {
            try {
                defaultValue = WandMode.valueOf(modeString.toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static WandAction parseWandAction(String actionString, WandAction defaultValue) {
        if (actionString != null && !actionString.isEmpty()) {
            try {
                defaultValue = WandAction.valueOf(actionString.toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private void updateActiveMaterial() {
        if (this.mage == null) {
            return;
        }
        if (this.activeMaterial == null) {
            this.mage.clearBuildingMaterial();
        } else {
            MaterialBrush brush = this.mage.getBrush();
            brush.update(this.activeMaterial);
        }
    }

    public void cycleActive(int direction) {
        Player player;
        Player player2 = player = this.mage != null ? this.mage.getPlayer() : null;
        if (player != null && player.isSneaking()) {
            Spell activeSpell = this.getActiveSpell();
            boolean cycleMaterials = false;
            if (activeSpell != null) {
                cycleMaterials = activeSpell.usesBrushSelection();
            }
            if (cycleMaterials) {
                this.cycleMaterials(direction);
            } else {
                this.cycleSpells(direction);
            }
        } else {
            this.cycleSpells(direction);
        }
    }

    public void toggleInventory() {
        MageSpell brushSelect;
        if (this.mage != null && this.mage.cancel()) {
            this.mage.playSoundEffect(noActionSound);
            return;
        }
        Player player = this.mage == null ? null : this.mage.getPlayer();
        boolean isSneaking = player != null && player.isSneaking();
        Spell currentSpell = this.getActiveSpell();
        if (this.getBrushMode() == WandMode.CHEST && brushSelectSpell != null && !brushSelectSpell.isEmpty() && isSneaking && currentSpell != null && currentSpell.usesBrushSelection() && (brushSelect = this.mage.getSpell(brushSelectSpell)) != null) {
            brushSelect.cast();
            return;
        }
        if (!this.hasInventory) {
            if (this.activeSpell == null || this.activeSpell.length() == 0) {
                Collection spells = this.getSpells();
                this.updateHasInventory();
                if (spells.size() > 0) {
                    this.activeSpell = (String)spells.iterator().next();
                }
            }
            this.updateName();
            return;
        }
        if (!this.isInventoryOpen()) {
            this.openInventory();
        } else {
            this.closeInventory();
        }
    }

    public void updateHasInventory() {
        int inventorySize = this.getSpells().size() + this.getBrushes().size();
        this.hasInventory = inventorySize > 1 || inventorySize == 1 && this.hasPath();
    }

    public void cycleInventory(int direction) {
        if (!this.hasInventory) {
            return;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
            int inventoryCount = this.inventories.size();
            this.openInventoryPage = inventoryCount == 0 ? 0 : (this.openInventoryPage + inventoryCount + direction) % inventoryCount;
            this.updateInventory();
            if (this.mage != null && this.inventories.size() > 1) {
                if (inventoryCycleSound != null) {
                    this.mage.playSoundEffect(inventoryCycleSound);
                }
                this.mage.getPlayer().updateInventory();
            }
        }
    }

    @Override
    public void cycleHotbar() {
        this.cycleHotbar(1);
    }

    public void cycleHotbar(int direction) {
        if (!this.hasInventory || this.getMode() != WandMode.INVENTORY) {
            return;
        }
        if (this.isInventoryOpen() && this.mage != null && this.hotbars.size() > 1) {
            this.saveInventory();
            int hotbarCount = this.hotbars.size();
            this.currentHotbar = hotbarCount == 0 ? 0 : (this.currentHotbar + hotbarCount + direction) % hotbarCount;
            this.updateHotbar();
            if (inventoryCycleSound != null) {
                this.mage.playSoundEffect(inventoryCycleSound);
            }
            this.updateHotbarStatus();
            this.mage.getPlayer().updateInventory();
        }
    }

    public void cycleInventory() {
        this.cycleInventory(1);
    }

    public void openInventory() {
        if (this.mage == null) {
            return;
        }
        WandMode wandMode = this.getMode();
        if (wandMode == WandMode.CHEST) {
            this.inventoryIsOpen = true;
            if (inventoryOpenSound != null) {
                this.mage.playSoundEffect(inventoryOpenSound);
            }
            this.playEffects("open");
            this.updateInventory();
            this.mage.getPlayer().openInventory(this.getDisplayInventory());
        } else if (wandMode == WandMode.INVENTORY) {
            if (this.hasStoredInventory()) {
                return;
            }
            if (this.storeInventory()) {
                this.inventoryIsOpen = true;
                if (inventoryOpenSound != null) {
                    this.mage.playSoundEffect(inventoryOpenSound);
                }
                this.showActiveIcon(true);
                this.playEffects("open");
                this.updateInventory();
                this.updateHotbarStatus();
                this.mage.getPlayer().updateInventory();
            }
        }
    }

    @Override
    public void closeInventory() {
        if (!this.isInventoryOpen()) {
            return;
        }
        this.controller.disableItemSpawn();
        WandMode mode = this.getMode();
        try {
            this.saveInventory();
            this.inventoryIsOpen = false;
            if (this.mage != null) {
                if (inventoryCloseSound != null) {
                    this.mage.playSoundEffect(inventoryCloseSound);
                }
                this.playEffects("close");
                if (mode == WandMode.INVENTORY) {
                    this.restoreInventory();
                    this.showActiveIcon(false);
                } else {
                    this.mage.getPlayer().closeInventory();
                }
                PlayerInventory inventory = this.mage.getPlayer().getInventory();
                ItemStack testItem = inventory.getHelmet();
                if (Wand.isSpell(testItem) || Wand.isBrush(testItem)) {
                    inventory.setHelmet(new ItemStack(Material.AIR));
                    this.mage.getPlayer().updateInventory();
                }
                if (Wand.isSpell(testItem = inventory.getBoots()) || Wand.isBrush(testItem)) {
                    inventory.setBoots(new ItemStack(Material.AIR));
                    this.mage.getPlayer().updateInventory();
                }
                if (Wand.isSpell(testItem = inventory.getLeggings()) || Wand.isBrush(testItem)) {
                    inventory.setLeggings(new ItemStack(Material.AIR));
                    this.mage.getPlayer().updateInventory();
                }
                if (Wand.isSpell(testItem = inventory.getChestplate()) || Wand.isBrush(testItem)) {
                    inventory.setChestplate(new ItemStack(Material.AIR));
                    this.mage.getPlayer().updateInventory();
                }
                if (Wand.isSpell(testItem = inventory.getItemInOffHand()) || Wand.isBrush(testItem)) {
                    inventory.setItemInOffHand(new ItemStack(Material.AIR));
                    this.mage.getPlayer().updateInventory();
                }
            }
        }
        catch (Throwable ex) {
            this.restoreInventory();
        }
        if (mode == WandMode.INVENTORY && this.mage != null) {
            try {
                this.mage.getPlayer().closeInventory();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        this.controller.enableItemSpawn();
    }

    @Override
    public boolean fill(Player player) {
        return this.fill(player, 0);
    }

    @Override
    public boolean fill(Player player, int maxLevel) {
        ArrayList currentSpells = new ArrayList(this.getSpells());
        for (String spellKey : currentSpells) {
            SpellTemplate spell = this.controller.getSpellTemplate(spellKey);
            if (spell.hasCastPermission((CommandSender)player)) continue;
            this.removeSpell(spellKey);
        }
        Collection<SpellTemplate> allSpells = this.controller.getPlugin().getSpellTemplates();
        for (SpellTemplate spell : allSpells) {
            String key = spell.getKey();
            if (maxLevel > 0 && spell.getSpellKey().getLevel() > maxLevel || key.startsWith("heroes*") || !spell.hasCastPermission((CommandSender)player) || !spell.hasIcon() || spell.isHidden()) continue;
            this.addSpell(key);
        }
        this.autoFill = false;
        this.saveItemState();
        return true;
    }

    protected void randomize() {
        ConfigurationSection wandConfig;
        String newDescription;
        boolean modified = this.randomize;
        this.randomize = false;
        if (this.description.contains("$") && !(newDescription = this.controller.getMessages().escape(this.description)).equals(this.description)) {
            this.description = newDescription;
            modified = true;
            this.updateLore();
            this.updateName();
        }
        if (this.template != null && this.template.length() > 0 && (wandConfig = this.controller.getWandTemplateConfiguration(this.template)) != null && wandConfig.contains("icon")) {
            String iconKey = wandConfig.getString("icon");
            if (iconKey.contains(",")) {
                Random r = new Random();
                String[] keys = StringUtils.split((String)iconKey, (char)',');
                iconKey = keys[r.nextInt(keys.length)];
            }
            this.setIcon(ConfigurationUtils.toMaterialAndData(iconKey));
            modified = true;
        }
        if (modified) {
            this.saveItemState();
        }
    }

    protected void checkActiveMaterial() {
        Collection materials;
        if ((this.activeMaterial == null || this.activeMaterial.length() == 0) && (materials = this.getBrushes()).size() > 0) {
            this.activeMaterial = (String)materials.iterator().next();
        }
    }

    @Override
    public boolean addItem(ItemStack item) {
        Integer sp;
        if (this.isUpgrade) {
            return false;
        }
        if (this.isModifiable() && Wand.isSpell(item) && !Wand.isSkill(item)) {
            SpellTemplate spell;
            String spellKey = Wand.getSpell(item);
            SpellTemplate currentSpell = this.getBaseSpell(spellKey);
            Collection spells = this.getSpells();
            if (!spells.contains(spellKey) && this.addSpell(spellKey) && (spell = this.controller.getSpellTemplate(spellKey)) != null) {
                if (this.mage != null) {
                    if (currentSpell != null) {
                        String levelDescription = spell.getLevelDescription();
                        if (levelDescription == null || levelDescription.isEmpty()) {
                            levelDescription = spell.getName();
                        }
                        this.mage.sendMessage(this.getMessage("spell_upgraded").replace("$wand", this.getName()).replace("$name", currentSpell.getName()).replace("$level", levelDescription));
                        this.mage.sendMessage(spell.getUpgradeDescription().replace("$name", currentSpell.getName()));
                        SpellUpgradeEvent upgradeEvent = new SpellUpgradeEvent(this.mage, this, currentSpell, spell);
                        Bukkit.getPluginManager().callEvent((Event)upgradeEvent);
                    } else {
                        this.mage.sendMessage(this.getMessage("spell_added").replace("$wand", this.getName()).replace("$name", spell.getName()));
                        this.activeSpell = spell.getKey();
                        AddSpellEvent addEvent = new AddSpellEvent(this.mage, this, spell);
                        Bukkit.getPluginManager().callEvent((Event)addEvent);
                    }
                }
                return true;
            }
        } else if (this.isModifiable() && Wand.isBrush(item)) {
            String materialKey = Wand.getBrush(item);
            Collection materials = this.getBrushes();
            if (!materials.contains(materialKey) && this.addBrush(materialKey)) {
                if (this.mage != null) {
                    Messages messages = this.controller.getMessages();
                    this.mage.sendMessage(messages.get("wand.brush_added").replace("$wand", this.getName()).replace("$name", com.elmakers.mine.bukkit.block.MaterialBrush.getMaterialName(messages, materialKey)));
                }
                return true;
            }
        } else if (Wand.isUpgrade(item)) {
            Wand wand = new Wand(this.controller, item);
            return this.add(wand);
        }
        if (this.mage != null && !this.mage.isAtMaxSkillPoints() && (sp = Wand.getSP(item)) != null) {
            this.mage.addSkillPoints(sp * item.getAmount());
            return true;
        }
        return false;
    }

    protected void updateEffects() {
        this.updateEffects(this.mage);
    }

    public void updateEffects(Mage mage) {
        double speedSquared;
        Vector velocity;
        double velocitySquared;
        boolean velocityCheck;
        if (mage == null) {
            return;
        }
        Player player = mage.getPlayer();
        if (player == null) {
            return;
        }
        if (this.effectBubbles && this.effectColor != null) {
            CompatibilityUtils.addPotionEffect((LivingEntity)player, this.effectColor.getColor());
            this.effectBubblesApplied = true;
        } else if (this.effectBubblesApplied) {
            this.effectBubblesApplied = false;
            CompatibilityUtils.removePotionEffect((LivingEntity)player);
        }
        Location location = mage.getLocation();
        long now = System.currentTimeMillis();
        Vector mageLocation = location.toVector();
        if (this.effectParticle != null && location != null && this.effectParticleInterval > 0 && this.effectParticleCount > 0) {
            velocityCheck = true;
            if (this.effectParticleMinVelocity > 0.0) {
                if (this.lastLocation != null && this.lastLocationTime != 0L) {
                    velocitySquared = this.effectParticleMinVelocity * this.effectParticleMinVelocity;
                    velocity = this.lastLocation.subtract(mageLocation);
                    velocity.setY(0);
                    speedSquared = velocity.lengthSquared() * 1000.0 / (double)(now - this.lastLocationTime);
                    velocityCheck = speedSquared > velocitySquared;
                } else {
                    velocityCheck = false;
                }
            }
            if (velocityCheck && (this.lastParticleEffect == 0L || now > this.lastParticleEffect + (long)this.effectParticleInterval)) {
                this.lastParticleEffect = now;
                Location effectLocation = player.getLocation();
                Location eyeLocation = player.getEyeLocation();
                effectLocation.setY(eyeLocation.getY() + this.effectParticleOffset);
                if (this.effectPlayer == null) {
                    this.effectPlayer = new EffectRing((Plugin)this.controller.getPlugin());
                    this.effectPlayer.setParticleCount(1);
                    this.effectPlayer.setIterations(1);
                    this.effectPlayer.setParticleOffset(0.0f, 0.0f, 0.0f);
                }
                this.effectPlayer.setMaterial(location.getBlock().getRelative(BlockFace.DOWN));
                if (this.effectParticleData == 0.0f) {
                    this.effectPlayer.setColor(this.getEffectColor());
                } else {
                    this.effectPlayer.setColor(null);
                }
                this.effectPlayer.setParticleType(this.effectParticle);
                this.effectPlayer.setParticleData(this.effectParticleData);
                this.effectPlayer.setSize(this.effectParticleCount);
                this.effectPlayer.setRadius((float)this.effectParticleRadius);
                this.effectPlayer.start(effectLocation, null);
            }
        }
        if (this.castSpell != null && location != null && this.castInterval > 0) {
            velocityCheck = true;
            if (this.castMinVelocity > 0.0) {
                if (this.lastLocation != null && this.lastLocationTime != 0L) {
                    velocitySquared = this.castMinVelocity * this.castMinVelocity;
                    velocity = this.lastLocation.subtract(mageLocation).multiply(-1);
                    if (this.castVelocityDirection != null) {
                        velocity = velocity.multiply(this.castVelocityDirection);
                        if (this.castVelocityDirection.getY() < 0.0) {
                            velocityCheck = velocity.getY() < 0.0;
                        } else {
                            boolean bl = velocityCheck = velocity.getY() > 0.0;
                        }
                    }
                    if (velocityCheck) {
                        speedSquared = velocity.lengthSquared() * 1000.0 / (double)(now - this.lastLocationTime);
                        velocityCheck = speedSquared > velocitySquared;
                    }
                } else {
                    velocityCheck = false;
                }
            }
            if (velocityCheck && (this.lastSpellCast == 0L || now > this.lastSpellCast + (long)this.castInterval)) {
                this.lastSpellCast = now;
                MageSpell spell = mage.getSpell(this.castSpell);
                if (spell != null) {
                    if (this.castParameters == null) {
                        this.castParameters = new MemoryConfiguration();
                    }
                    this.castParameters.set("track_casts", (Object)false);
                    mage.setCostReduction(100.0f);
                    mage.setQuiet(true);
                    try {
                        spell.cast(this.castParameters);
                    }
                    catch (Exception ex) {
                        this.controller.getLogger().log(Level.WARNING, "Error casting aura spell " + spell.getKey(), ex);
                    }
                    mage.setQuiet(false);
                    mage.setCostReduction(0.0f);
                }
            }
        }
        if (this.effectSound != null && location != null && this.controller.soundsEnabled() && this.effectSoundInterval > 0 && (this.lastSoundEffect == 0L || now > this.lastSoundEffect + (long)this.effectSoundInterval)) {
            this.lastSoundEffect = now;
            mage.getLocation().getWorld().playSound(location, this.effectSound.getSound(), this.effectSound.getVolume(), this.effectSound.getPitch());
        }
        this.lastLocation = mageLocation;
        this.lastLocationTime = now;
    }

    protected void updateDurability() {
        short maxDurability = this.item.getType().getMaxDurability();
        if (maxDurability > 0 && this.effectiveManaMax > 0) {
            int durability = (int)(this.mana * (float)maxDurability / (float)this.effectiveManaMax);
            if ((durability = maxDurability - durability) >= maxDurability) {
                durability = maxDurability - 1;
            } else if (durability < 0) {
                durability = 0;
            }
            this.item.setDurability((short)durability);
        }
    }

    public boolean usesXPBar() {
        return this.hasSpellProgression && spMode.useXP() || this.usesMana() && manaMode.useXP();
    }

    public boolean usesXPNumber() {
        return this.hasSpellProgression && spMode.useXPNumber() && this.controller.isSPEnabled() || this.usesMana() && manaMode.useXP();
    }

    public boolean hasSpellProgression() {
        return this.hasSpellProgression;
    }

    public boolean usesXPDisplay() {
        return this.usesXPBar() || this.usesXPNumber();
    }

    @Override
    public void updateMana() {
        Player player;
        Player player2 = player = this.mage == null ? null : this.mage.getPlayer();
        if (player == null) {
            return;
        }
        if (this.usesMana()) {
            if (manaMode.useGlow()) {
                if (this.mana == (float)this.effectiveManaMax) {
                    CompatibilityUtils.addGlow(this.item);
                } else {
                    CompatibilityUtils.removeGlow(this.item);
                }
            }
            if (manaMode.useDurability()) {
                this.updateDurability();
            }
        }
        if (this.usesXPDisplay()) {
            int playerLevel = player.getLevel();
            float playerProgress = player.getExp();
            if (this.usesMana() && manaMode.useXPNumber()) {
                playerLevel = (int)this.mana;
            }
            if (this.usesMana() && manaMode.useXPBar()) {
                playerProgress = Math.max(0.0f, this.mana / (float)this.effectiveManaMax);
            }
            if (this.controller.isSPEnabled() && spMode.useXPNumber() && this.hasSpellProgression) {
                playerLevel = this.mage.getSkillPoints();
            }
            this.mage.sendExperience(playerProgress, playerLevel);
        }
    }

    @Override
    public boolean isInventoryOpen() {
        return this.mage != null && this.inventoryIsOpen;
    }

    @Override
    public void unbind() {
        if (!this.bound) {
            return;
        }
        com.elmakers.mine.bukkit.api.magic.Mage owningMage = this.mage;
        this.deactivate();
        if (this.ownerId != null) {
            if (owningMage == null || !owningMage.getId().equals(this.ownerId)) {
                owningMage = this.controller.getRegisteredMage(this.ownerId);
            }
            if (owningMage != null) {
                owningMage.unbind(this);
            }
            this.ownerId = null;
        }
        this.bound = false;
        this.owner = null;
        this.saveState();
    }

    @Override
    public void bind() {
        if (this.bound) {
            return;
        }
        Mage holdingMage = this.mage;
        this.deactivate();
        this.bound = true;
        this.saveState();
        if (holdingMage != null) {
            holdingMage.checkWand();
        }
    }

    @Override
    public void deactivate() {
        if (this.mage == null) {
            return;
        }
        this.playEffects("deactivate");
        Mage mage = this.mage;
        Player player = mage.getPlayer();
        if (this.effectBubblesApplied && player != null) {
            CompatibilityUtils.removePotionEffect((LivingEntity)player);
            this.effectBubblesApplied = false;
        }
        if (this.isInventoryOpen()) {
            this.closeInventory();
        }
        this.showActiveIcon(false);
        this.storedInventory = null;
        if (this.usesXPNumber() || this.usesXPBar()) {
            mage.resetSentExperience();
        }
        this.saveItemState();
        mage.setActiveWand(null);
        this.mage = null;
        this.updateMaxMana(true);
    }

    @Override
    public Spell getActiveSpell() {
        if (this.mage == null || this.activeSpell == null || this.activeSpell.length() == 0) {
            return null;
        }
        return this.mage.getSpell(this.activeSpell);
    }

    @Override
    public SpellTemplate getBaseSpell(String spellName) {
        SpellKey key = new SpellKey(spellName);
        Integer spellLevel = this.spellLevels.get(key.getBaseKey());
        if (spellLevel == null) {
            return null;
        }
        String spellKey = key.getBaseKey();
        if (key.isVariant()) {
            spellKey = spellKey + "|" + key.getLevel();
        }
        return this.controller.getSpellTemplate(spellKey);
    }

    @Override
    public String getActiveSpellKey() {
        return this.activeSpell;
    }

    @Override
    public String getActiveBrushKey() {
        return this.activeMaterial;
    }

    @Override
    public void damageDealt(double damage, Entity target) {
        if (this.effectiveManaMax == 0 && this.manaMax > 0) {
            this.effectiveManaMax = this.manaMax;
        }
        if (this.manaPerDamage > 0.0f && this.effectiveManaMax > 0 && this.mana < (float)this.effectiveManaMax) {
            this.mana = Math.min((float)this.effectiveManaMax, this.mana + (float)damage * this.manaPerDamage);
            this.updateMana();
        }
    }

    @Override
    public boolean cast() {
        return this.cast(this.getActiveSpell());
    }

    public boolean cast(Spell spell) {
        if (spell != null) {
            ArrayList<String> castParameters = null;
            if (this.castOverrides != null && this.castOverrides.size() > 0) {
                castParameters = new ArrayList<String>();
                for (Map.Entry<String, String> entry : this.castOverrides.entrySet()) {
                    String[] key = StringUtils.split((String)entry.getKey(), (String)".");
                    if (key.length == 0 || key.length == 2 && !key[0].equals("default") && !key[0].equals(spell.getSpellKey().getBaseKey()) && !key[0].equals(spell.getSpellKey().getKey())) continue;
                    castParameters.add(key.length == 2 ? key[1] : key[0]);
                    castParameters.add(entry.getValue());
                }
            }
            if (spell.cast(castParameters == null ? null : castParameters.toArray(EMPTY_PARAMETERS))) {
                Color spellColor = spell.getColor();
                this.use();
                if (spellColor != null && this.effectColor != null) {
                    this.effectColor = this.effectColor.mixColor(spellColor, (double)this.effectColorSpellMixWeight);
                }
                this.updateHotbarStatus();
                return true;
            }
        }
        return false;
    }

    protected void use() {
        if (this.mage == null) {
            return;
        }
        if (this.hasUses) {
            ItemStack item = this.getItem();
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
            } else {
                if (this.uses > 0) {
                    --this.uses;
                }
                if (this.uses <= 0) {
                    Player player = this.mage.getPlayer();
                    this.deactivate();
                    PlayerInventory playerInventory = player.getInventory();
                    item = player.getItemInHand();
                    if (item.getAmount() > 1) {
                        item.setAmount(item.getAmount() - 1);
                    } else {
                        playerInventory.setItemInHand(new ItemStack(Material.AIR, 1));
                    }
                    player.updateInventory();
                } else {
                    this.saveItemState();
                    this.updateName();
                    this.updateLore();
                }
            }
        }
    }

    public static int getExpToLevel(int expLevel) {
        return expLevel >= 30 ? 112 + (expLevel - 30) * 9 : (expLevel >= 15 ? 37 + (expLevel - 15) * 5 : 7 + expLevel * 2);
    }

    public static int getExperience(int expLevel, float expProgress) {
        int xp = 0;
        for (int level = 0; level < expLevel; ++level) {
            xp += Wand.getExpToLevel(level);
        }
        return xp + (int)(expProgress * (float)Wand.getExpToLevel(expLevel));
    }

    protected void updateHotbarStatus() {
        Player player;
        Player player2 = player = this.mage == null ? null : this.mage.getPlayer();
        if (player != null && LiveHotbar && this.getMode() == WandMode.INVENTORY && this.isInventoryOpen()) {
            Location location = this.mage.getLocation();
            for (int i = 0; i < 9; ++i) {
                int mana;
                int targetAmount;
                MageSpell spell;
                ItemStack spellItem = player.getInventory().getItem(i);
                String spellKey = Wand.getSpell(spellItem);
                if (spellKey == null || (spell = this.mage.getSpell(spellKey)) == null) continue;
                long remainingCooldown = spell.getRemainingCooldown();
                CastingCost requiredCost = spell.getRequiredCost();
                if (spell.canCast(location) && remainingCooldown == 0L && requiredCost == null) {
                    if (spellItem.getAmount() == 1) continue;
                    InventoryUtils.setCount(spellItem, 1);
                    continue;
                }
                int n = targetAmount = LiveHotbarCooldown ? (int)Math.min(Math.ceil((double)remainingCooldown / 1000.0), 99.0) : 0;
                if (LiveHotbarCooldown && requiredCost != null && (mana = requiredCost.getMana()) <= this.effectiveManaMax && this.effectiveManaRegeneration > 0) {
                    float remainingMana = (float)mana - this.mana;
                    int targetManaTime = (int)Math.min(Math.ceil(remainingMana / (float)this.effectiveManaRegeneration), 99.0);
                    targetAmount = Math.max(targetManaTime, targetAmount);
                }
                targetAmount = -targetAmount;
                if (spellItem.getAmount() == targetAmount) continue;
                InventoryUtils.setCount(spellItem, targetAmount);
            }
        }
    }

    public boolean tickMana(Player player) {
        boolean updated = false;
        if (this.usesMana()) {
            long now = System.currentTimeMillis();
            if (this.isHeroes) {
                HeroesManager heroes = this.controller.getHeroes();
                if (heroes != null) {
                    this.effectiveManaMax = heroes.getMaxMana(player);
                    this.effectiveManaRegeneration = heroes.getManaRegen(player);
                    this.manaMax = this.effectiveManaMax;
                    this.manaRegeneration = this.effectiveManaRegeneration;
                    this.mana = heroes.getMana(player);
                    updated = true;
                }
            } else if (this.manaRegeneration > 0 && this.lastManaRegeneration > 0L && this.effectiveManaRegeneration > 0) {
                long delta = now - this.lastManaRegeneration;
                if (this.effectiveManaMax == 0 && this.manaMax > 0) {
                    this.effectiveManaMax = this.manaMax;
                }
                this.mana = Math.min((float)this.effectiveManaMax, this.mana + (float)this.effectiveManaRegeneration * (float)delta / 1000.0f);
                updated = true;
            }
            this.lastManaRegeneration = now;
        }
        return updated;
    }

    public void tick() {
        if (this.mage == null || this.item == null) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        if (this.tickMana(player)) {
            this.updateMana();
        }
        this.updateHotbarStatus();
        if (!this.passive) {
            if (this.damageReductionFire > 0.0f && player.getFireTicks() > 0) {
                player.setFireTicks(0);
            }
            this.updateEffects();
        }
    }

    public void armorUpdated() {
        this.updateMaxMana(true);
    }

    protected void updateMaxMana(boolean updateLore) {
        if (this.isHeroes) {
            return;
        }
        int currentMana = this.effectiveManaMax;
        int currentManaRegen = this.effectiveManaRegeneration;
        float effectiveBoost = this.manaMaxBoost;
        float effectiveRegenBoost = this.manaRegenerationBoost;
        if (this.mage != null) {
            Collection<Wand> activeArmor = this.mage.getActiveArmor();
            for (Wand armorWand : activeArmor) {
                effectiveBoost += armorWand.getManaMaxBoost();
                effectiveRegenBoost += armorWand.getManaRegenerationBoost();
            }
        }
        this.effectiveManaMax = this.manaMax;
        if (effectiveBoost != 0.0f) {
            this.effectiveManaMax = (int)Math.ceil((float)this.effectiveManaMax + effectiveBoost * (float)this.effectiveManaMax);
        }
        this.effectiveManaRegeneration = this.manaRegeneration;
        if (effectiveRegenBoost != 0.0f) {
            this.effectiveManaRegeneration = (int)Math.ceil((float)this.effectiveManaRegeneration + effectiveRegenBoost * (float)this.effectiveManaRegeneration);
        }
        if (updateLore && (currentMana != this.effectiveManaMax || this.effectiveManaRegeneration != currentManaRegen)) {
            this.updateLore();
        }
    }

    public static Float getWandFloat(ItemStack item, String key) {
        try {
            String value;
            Object wandNode = InventoryUtils.getNode(item, WAND_KEY);
            if (wandNode != null && (value = InventoryUtils.getMeta(wandNode, key)) != null && !value.isEmpty()) {
                return Float.valueOf(Float.parseFloat(value));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getWandString(ItemStack item, String key) {
        try {
            Object wandNode = InventoryUtils.getNode(item, WAND_KEY);
            if (wandNode != null) {
                return InventoryUtils.getMeta(wandNode, key);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public MagicController getMaster() {
        return this.controller;
    }

    public void cycleSpells(int direction) {
        Collection spellsSet = this.getSpells();
        ArrayList spells = new ArrayList(spellsSet);
        if (spells.size() == 0) {
            return;
        }
        if (this.activeSpell == null) {
            this.activeSpell = ((String)spells.get(0)).split("@")[0];
            return;
        }
        int spellIndex = 0;
        for (int i = 0; i < spells.size(); ++i) {
            if (!((String)spells.get(i)).split("@")[0].equals(this.activeSpell)) continue;
            spellIndex = i;
            break;
        }
        spellIndex = (spellIndex + direction) % spells.size();
        this.setActiveSpell(((String)spells.get(spellIndex)).split("@")[0]);
    }

    public void cycleMaterials(int direction) {
        Collection materialsSet = this.getBrushes();
        ArrayList materials = new ArrayList(materialsSet);
        if (materials.size() == 0) {
            return;
        }
        if (this.activeMaterial == null) {
            this.activeMaterial = ((String)materials.get(0)).split("@")[0];
            return;
        }
        int materialIndex = 0;
        for (int i = 0; i < materials.size(); ++i) {
            if (!((String)materials.get(i)).split("@")[0].equals(this.activeMaterial)) continue;
            materialIndex = i;
            break;
        }
        materialIndex = (materialIndex + direction) % materials.size();
        this.setActiveBrush(((String)materials.get(materialIndex)).split("@")[0]);
    }

    public Mage getActivePlayer() {
        return this.mage;
    }

    public Color getEffectColor() {
        return this.effectColor == null ? null : this.effectColor.getColor();
    }

    public ParticleEffect getEffectParticle() {
        return this.effectParticle;
    }

    public Inventory getHotbar() {
        if (this.hotbars.size() == 0) {
            return null;
        }
        if (this.currentHotbar < 0 || this.currentHotbar >= this.hotbars.size()) {
            this.currentHotbar = 0;
        }
        return this.hotbars.get(this.currentHotbar);
    }

    public int getHotbarCount() {
        if (this.getMode() != WandMode.INVENTORY) {
            return 0;
        }
        return this.hotbars.size();
    }

    public List<Inventory> getHotbars() {
        return this.hotbars;
    }

    @Override
    public boolean isQuickCastDisabled() {
        return this.quickCastDisabled;
    }

    public boolean isManualQuickCastDisabled() {
        return this.manualQuickCastDisabled;
    }

    @Override
    public boolean isQuickCast() {
        return this.quickCast;
    }

    public WandMode getMode() {
        Player player;
        WandMode wandMode = this.mode != null ? this.mode : this.controller.getDefaultWandMode();
        Player player2 = player = this.mage == null ? null : this.mage.getPlayer();
        if (wandMode == WandMode.INVENTORY && player != null && player.getGameMode() == GameMode.CREATIVE) {
            wandMode = WandMode.CHEST;
        }
        return wandMode;
    }

    public WandMode getBrushMode() {
        return this.brushMode != null ? this.brushMode : this.controller.getDefaultBrushMode();
    }

    public void setMode(WandMode mode) {
        this.mode = mode;
    }

    public void setBrushMode(WandMode mode) {
        this.brushMode = mode;
    }

    @Override
    public boolean showCastMessages() {
        return this.quietLevel == 0;
    }

    @Override
    public boolean showMessages() {
        return this.quietLevel < 2;
    }

    public boolean isStealth() {
        return this.quietLevel > 2;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public boolean isLost(com.elmakers.mine.bukkit.api.wand.LostWand lostWand) {
        return this.id != null && this.id.equals(lostWand.getId());
    }

    @Override
    public LostWand makeLost(Location location) {
        return new LostWand(this, location);
    }

    @Override
    public void activate(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        Player player = mage.getPlayer();
        if (!Wand.hasActiveWand(player)) {
            this.controller.getLogger().warning("Wand activated without holding a wand!");
            return;
        }
        if (mage instanceof Mage) {
            this.activate((Mage)mage);
        }
    }

    protected void showActiveIcon(boolean show) {
        if (this.icon == null || this.inactiveIcon == null || this.inactiveIcon.getMaterial() == Material.AIR || this.inactiveIcon.getMaterial() == null) {
            return;
        }
        if (this.icon.getMaterial() == Material.AIR || this.icon.getMaterial() == null) {
            this.icon.setMaterial(DefaultWandMaterial);
        }
        if (show) {
            if (this.inactiveIconDelay > 0) {
                MagicPlugin plugin = this.controller.getPlugin();
                plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

                    @Override
                    public void run() {
                        Player player;
                        Wand.this.updateIcon();
                        if (Wand.this.mage != null && (player = Wand.this.mage.getPlayer()) != null) {
                            player.getInventory().setItem(Wand.this.storedSlot, Wand.this.item);
                        }
                    }
                }, (long)(this.inactiveIconDelay * 20 / 1000));
            } else {
                this.icon.applyToItem(this.item);
            }
        } else {
            this.inactiveIcon.applyToItem(this.item);
        }
    }

    public void setMage(Mage mage) {
        this.mage = mage;
    }

    public void activate(Mage mage) {
        HeroesManager heroes;
        if (mage == null) {
            return;
        }
        Player player = mage.getPlayer();
        if (player != null) {
            if (!this.controller.hasWandPermission(player, this)) {
                return;
            }
            InventoryView openInventory = player.getOpenInventory();
            InventoryType inventoryType = openInventory.getType();
            if (inventoryType == InventoryType.ENCHANTING || inventoryType == InventoryType.ANVIL) {
                return;
            }
        }
        if (!this.canUse(player)) {
            mage.sendMessage(this.getMessage("bound").replace("$name", this.getOwner()));
            mage.setActiveWand(null);
            return;
        }
        WandTemplate template = this.getTemplate();
        Wand soulWand = mage.getSoulWand();
        if (template != null && template.isSoul() && soulWand != this) {
            if (!this.soul) {
                this.add(soulWand);
                MemoryConfiguration soulConfiguration = new MemoryConfiguration();
                this.saveProperties((ConfigurationSection)soulConfiguration);
                soulWand.loadProperties((ConfigurationSection)soulConfiguration);
                this.soul = true;
                this.saveState();
            }
            soulWand.soul = true;
            soulWand.item = this.item;
            soulWand.activate(mage);
            return;
        }
        this.newId();
        if (this.getMode() != WandMode.INVENTORY) {
            this.showActiveIcon(true);
        }
        if (this.isUpgrade) {
            this.controller.getLogger().warning("Activated an upgrade item- this shouldn't happen");
            return;
        }
        WandPreActivateEvent preActivateEvent = new WandPreActivateEvent(mage, this);
        Bukkit.getPluginManager().callEvent((Event)preActivateEvent);
        if (preActivateEvent.isCancelled()) {
            return;
        }
        this.mage = mage;
        boolean forceUpdate = false;
        if (!this.isUpgrade && (this.controller.fillWands() || this.autoFill)) {
            this.fill(mage.getPlayer(), this.controller.getMaxWandFillLevel());
        }
        if (this.isHeroes && player != null && (heroes = this.controller.getHeroes()) != null) {
            Set<String> skills = heroes.getSkills(player);
            ArrayList currentSpells = new ArrayList(this.getSpells());
            for (String spellKey : currentSpells) {
                if (!spellKey.startsWith("heroes*") || skills.contains(spellKey.substring(7))) continue;
                this.removeSpell(spellKey);
            }
            this.mage = null;
            for (String skillKey : skills) {
                String heroesKey = "heroes*" + skillKey;
                if (this.spells.containsKey(heroesKey)) continue;
                this.addSpell(heroesKey);
            }
            this.mage = mage;
        }
        if (this.autoOrganize && !this.isUpgrade) {
            this.organizeInventory(mage);
        }
        if (this.autoAlphabetize && !this.isUpgrade) {
            this.alphabetizeInventory();
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack[] items = inventory.getContents();
        for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            if (!this.addItem(item)) continue;
            inventory.setItem(i, null);
            forceUpdate = true;
        }
        if (this.bound) {
            boolean ownerRenamed;
            String mageName = ChatColor.stripColor((String)mage.getPlayer().getDisplayName());
            String mageId = mage.getPlayer().getUniqueId().toString();
            boolean bl = ownerRenamed = this.owner != null && this.ownerId != null && this.ownerId.equals(mageId) && !this.owner.equals(mageName);
            if (this.ownerId == null || this.ownerId.length() == 0 || this.owner == null || ownerRenamed) {
                this.takeOwnership(mage.getPlayer());
            }
        }
        if (this.randomize) {
            this.randomize();
            forceUpdate = true;
        }
        this.checkActiveMaterial();
        mage.setActiveWand(this);
        this.tick();
        this.saveItemState();
        this.updateMaxMana(false);
        this.updateActiveMaterial();
        this.updateName();
        this.updateLore();
        this.playEffects("activate");
        this.lastSoundEffect = 0L;
        this.lastParticleEffect = 0L;
        this.lastSpellCast = 0L;
        this.lastLocationTime = 0L;
        this.lastLocation = null;
        if (forceUpdate) {
            player.updateInventory();
        }
        WandActivatedEvent activatedEvent = new WandActivatedEvent(mage, this);
        Bukkit.getPluginManager().callEvent((Event)activatedEvent);
    }

    @Override
    public void organizeInventory(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        WandOrganizer organizer = new WandOrganizer(this, mage);
        organizer.organize();
        this.openInventoryPage = 0;
        this.currentHotbar = 0;
        this.autoOrganize = false;
        this.autoAlphabetize = false;
        this.saveItemState();
        this.loadState();
        this.updateInventory();
    }

    @Override
    public void alphabetizeInventory() {
        WandOrganizer organizer = new WandOrganizer(this);
        organizer.alphabetize();
        this.openInventoryPage = 0;
        this.currentHotbar = 0;
        this.autoOrganize = false;
        this.autoAlphabetize = false;
        this.saveItemState();
        this.loadState();
        this.updateInventory();
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand duplicate() {
        ItemStack newItem = InventoryUtils.getCopy(this.item);
        Wand newWand = new Wand(this.controller, newItem);
        newWand.saveItemState();
        return newWand;
    }

    @Override
    public boolean configure(Map<String, Object> properties) {
        HashMap<String, Object> convertedProperties = new HashMap<String, Object>(properties);
        this.loadProperties(ConfigurationUtils.toConfigurationSection(convertedProperties), false);
        this.saveItemState();
        this.updateName();
        this.updateLore();
        return true;
    }

    @Override
    public boolean upgrade(Map<String, Object> properties) {
        HashMap<String, Object> convertedProperties = new HashMap<String, Object>(properties);
        this.loadProperties(ConfigurationUtils.toConfigurationSection(convertedProperties), true);
        this.saveItemState();
        this.updateName();
        this.updateLore();
        return true;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void unlock() {
        this.locked = false;
    }

    public boolean isPassive() {
        return this.passive;
    }

    @Override
    public boolean canUse(Player player) {
        if (!this.bound || this.ownerId == null || this.ownerId.length() == 0) {
            return true;
        }
        if (this.controller.hasPermission(player, "Magic.wand.override_bind", false)) {
            return true;
        }
        return this.ownerId.equalsIgnoreCase(player.getUniqueId().toString());
    }

    @Override
    public boolean addSpell(String spellName) {
        SpellKey currentKey;
        SpellTemplate template;
        if (!this.isModifiable()) {
            return false;
        }
        SpellKey spellKey = new SpellKey(spellName);
        if (this.hasSpell(spellKey)) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        if ((template = this.controller.getSpellTemplate(spellName)) == null) {
            this.controller.getLogger().warning("Tried to add unknown spell to wand: " + spellName);
            return false;
        }
        if (this.hasSpell(template.getKey())) {
            return false;
        }
        ItemStack spellItem = this.createSpellIcon(template);
        if (spellItem == null) {
            return false;
        }
        spellKey = template.getSpellKey();
        int level = spellKey.getLevel();
        int inventoryCount = this.inventories.size();
        int spellCount = this.spells.size();
        Integer inventorySlot = null;
        Integer currentLevel = this.spellLevels.get(spellKey.getBaseKey());
        if (currentLevel != null && this.activeSpell != null && !this.activeSpell.isEmpty() && (currentKey = new SpellKey(this.activeSpell)).getBaseKey().equals(spellKey.getBaseKey())) {
            this.activeSpell = spellKey.getKey();
        }
        ArrayList<SpellKey> spellsToRemove = new ArrayList<SpellKey>(template.getSpellsToRemove().size());
        for (SpellKey key : template.getSpellsToRemove()) {
            if (this.spellLevels.get(key.getBaseKey()) == null) continue;
            spellsToRemove.add(key);
        }
        if (currentLevel != null || !spellsToRemove.isEmpty()) {
            List<Inventory> allInventories = this.getAllInventories();
            int currentSlot = 0;
            for (Inventory inventory : allInventories) {
                ItemStack[] items = inventory.getContents();
                for (int index = 0; index < items.length; ++index) {
                    ItemStack itemStack = items[index];
                    if (Wand.isSpell(itemStack)) {
                        SpellKey checkKey = new SpellKey(Wand.getSpell(itemStack));
                        if (checkKey.getBaseKey().equals(spellKey.getBaseKey())) {
                            inventorySlot = currentSlot;
                            inventory.setItem(index, null);
                            this.spells.remove(checkKey.getKey());
                        } else {
                            for (SpellKey key : spellsToRemove) {
                                if (!checkKey.getBaseKey().equals(key.getBaseKey())) continue;
                                inventory.setItem(index, null);
                                this.spells.remove(key.getKey());
                                this.spellLevels.remove(key.getBaseKey());
                            }
                        }
                    }
                    ++currentSlot;
                }
            }
        }
        if (this.activeSpell == null || this.activeSpell.isEmpty()) {
            this.activeSpell = spellKey.getKey();
        }
        this.spellLevels.put(spellKey.getBaseKey(), level);
        this.spells.put(template.getKey(), inventorySlot);
        this.addToInventory(spellItem, inventorySlot);
        this.updateInventory();
        this.updateHasInventory();
        this.saveItemState();
        this.updateLore();
        if (this.mage != null && this.spells.size() != spellCount) {
            if (spellCount == 0) {
                String message = this.getMessage("spell_instructions", "").replace("$wand", this.getName());
                this.mage.sendMessage(message.replace("$spell", template.getName()));
            } else if (spellCount == 1) {
                this.mage.sendMessage(this.getMessage("inventory_instructions", "").replace("$wand", this.getName()));
            }
            if (inventoryCount == 1 && this.inventories.size() > 1) {
                this.mage.sendMessage(this.getMessage("page_instructions", "").replace("$wand", this.getName()));
            }
        }
        return true;
    }

    public String getMessage(String key) {
        return this.getMessage(key, "");
    }

    public String getMessage(String key, String defaultValue) {
        String message = this.controller.getMessages().get("wand." + key, defaultValue);
        if (this.template != null && !this.template.isEmpty()) {
            message = this.controller.getMessages().get("wands." + this.template + "." + key, message);
        }
        return message;
    }

    @Override
    public boolean add(com.elmakers.mine.bukkit.api.wand.Wand other) {
        if (other instanceof Wand) {
            return this.add((Wand)other);
        }
        return false;
    }

    @Override
    public boolean hasBrush(String materialKey) {
        return this.getBrushes().contains(materialKey);
    }

    @Override
    public boolean hasSpell(String spellName) {
        return this.hasSpell(new SpellKey(spellName));
    }

    public boolean hasSpell(SpellKey spellKey) {
        Integer level = this.spellLevels.get(spellKey.getBaseKey());
        return level != null && level >= spellKey.getLevel();
    }

    @Override
    public boolean addBrush(String materialKey) {
        ItemStack itemStack;
        if (!this.isModifiable()) {
            return false;
        }
        if (this.hasBrush(materialKey)) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        if ((itemStack = this.createBrushIcon(materialKey)) == null) {
            return false;
        }
        int inventoryCount = this.inventories.size();
        int brushCount = this.brushes.size();
        this.brushes.put(materialKey, null);
        this.addToInventory(itemStack);
        if (this.activeMaterial == null || this.activeMaterial.length() == 0) {
            this.activateBrush(materialKey);
        } else {
            this.updateInventory();
        }
        this.updateHasInventory();
        this.saveItemState();
        this.updateLore();
        if (this.mage != null) {
            if (brushCount == 0) {
                this.mage.sendMessage(this.getMessage("brush_instructions").replace("$wand", this.getName()));
            }
            if (inventoryCount == 1 && this.inventories.size() > 1) {
                this.mage.sendMessage(this.getMessage("page_instructions").replace("$wand", this.getName()));
            }
        }
        return true;
    }

    @Override
    public void setActiveBrush(String materialKey) {
        MaterialBrush brush;
        this.activateBrush(materialKey);
        if (materialKey != null && this.mage != null && (brush = this.mage.getBrush()) != null) {
            boolean eraseWasActive = brush.isEraseModifierActive();
            brush.activate(this.mage.getLocation(), materialKey);
            if (this.mage != null) {
                BrushMode mode = brush.getMode();
                if (mode == BrushMode.CLONE) {
                    this.mage.sendMessage(this.getMessage("clone_material_activated"));
                } else if (mode == BrushMode.REPLICATE) {
                    this.mage.sendMessage(this.getMessage("replicate_material_activated"));
                }
                if (!eraseWasActive && brush.isEraseModifierActive()) {
                    this.mage.sendMessage(this.getMessage("erase_modifier_activated"));
                }
            }
        }
    }

    public void setActiveBrush(ItemStack itemStack) {
        if (!Wand.isBrush(itemStack)) {
            return;
        }
        this.setActiveBrush(Wand.getBrush(itemStack));
    }

    public void activateBrush(String materialKey) {
        this.activeMaterial = materialKey;
        this.saveItemState();
        this.updateName();
        this.updateActiveMaterial();
        this.updateHotbar();
    }

    @Override
    public void setActiveSpell(String activeSpell) {
        SpellKey spellKey = new SpellKey(activeSpell);
        if (!this.spellLevels.containsKey(activeSpell = spellKey.getBaseKey())) {
            return;
        }
        spellKey = new SpellKey(spellKey.getBaseKey(), this.spellLevels.get(activeSpell));
        this.activeSpell = spellKey.getKey();
        this.saveItemState();
        this.updateName();
    }

    @Override
    public boolean removeBrush(String materialKey) {
        if (!this.isModifiable() || materialKey == null) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        if (materialKey.equals(this.activeMaterial)) {
            this.activeMaterial = null;
        }
        this.brushes.remove(materialKey);
        List<Inventory> allInventories = this.getAllInventories();
        boolean found = false;
        block0: for (Inventory inventory : allInventories) {
            ItemStack[] items = inventory.getContents();
            for (int index = 0; index < items.length; ++index) {
                ItemStack itemStack = items[index];
                if (itemStack == null || !Wand.isBrush(itemStack)) continue;
                String itemKey = Wand.getBrush(itemStack);
                if (itemKey.equals(materialKey)) {
                    found = true;
                    inventory.setItem(index, null);
                } else if (this.activeMaterial == null) {
                    this.activeMaterial = materialKey;
                }
                if (found && this.activeMaterial != null) continue block0;
            }
        }
        this.updateActiveMaterial();
        this.updateInventory();
        this.saveItemState();
        this.updateName();
        this.updateLore();
        return found;
    }

    @Override
    public boolean removeSpell(String spellName) {
        if (!this.isModifiable()) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        if (spellName.equals(this.activeSpell)) {
            this.activeSpell = null;
        }
        this.spells.remove(spellName);
        SpellKey spellKey = new SpellKey(spellName);
        this.spellLevels.remove(spellKey.getBaseKey());
        List<Inventory> allInventories = this.getAllInventories();
        boolean found = false;
        block0: for (Inventory inventory : allInventories) {
            ItemStack[] items = inventory.getContents();
            for (int index = 0; index < items.length; ++index) {
                ItemStack itemStack = items[index];
                if (itemStack == null || itemStack.getType() == Material.AIR || !Wand.isSpell(itemStack)) continue;
                if (Wand.getSpell(itemStack).equals(spellName)) {
                    found = true;
                    inventory.setItem(index, null);
                } else if (this.activeSpell == null) {
                    this.activeSpell = Wand.getSpell(itemStack);
                }
                if (found && this.activeSpell != null) continue block0;
            }
        }
        this.updateInventory();
        this.updateHasInventory();
        this.saveItemState();
        this.updateName();
        this.updateLore();
        return found;
    }

    @Override
    public Map<String, String> getOverrides() {
        return this.castOverrides == null ? new HashMap<String, String>() : new HashMap<String, String>(this.castOverrides);
    }

    @Override
    public void setOverrides(Map<String, String> overrides) {
        this.castOverrides = overrides == null ? null : new HashMap<String, String>(overrides);
    }

    @Override
    public void removeOverride(String key) {
        if (this.castOverrides != null) {
            this.castOverrides.remove(key);
        }
    }

    @Override
    public void setOverride(String key, String value) {
        if (this.castOverrides == null) {
            this.castOverrides = new HashMap<String, String>();
        }
        if (value == null || value.length() == 0) {
            this.castOverrides.remove(key);
        } else {
            this.castOverrides.put(key, value);
        }
    }

    public boolean hasStoredInventory() {
        return this.storedInventory != null;
    }

    public Inventory getStoredInventory() {
        return this.storedInventory;
    }

    public boolean addToStoredInventory(ItemStack item) {
        if (this.storedInventory == null) {
            return false;
        }
        HashMap remainder = this.storedInventory.addItem(new ItemStack[]{item});
        return remainder.size() == 0;
    }

    public void setStoredSlot(int slot) {
        this.storedSlot = slot;
    }

    public boolean storeInventory() {
        if (this.storedInventory != null) {
            if (this.mage != null) {
                this.mage.sendMessage("Your wand contains a previously stored inventory and will not activate, let go of it to clear.");
            }
            this.controller.getLogger().warning("Tried to store an inventory with one already present: " + (this.mage == null ? "?" : this.mage.getName()));
            return false;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return false;
        }
        PlayerInventory inventory = player.getInventory();
        this.storedInventory = CompatibilityUtils.createInventory(null, 36, "Stored Inventory");
        for (int i = 0; i < 36; ++i) {
            ItemStack item = inventory.getItem(i);
            if (!Wand.isSpell(item) || Wand.isSkill(item)) {
                this.storedInventory.setItem(i, item);
            }
            inventory.setItem(i, null);
        }
        this.storedSlot = inventory.getHeldItemSlot();
        inventory.setItem(this.storedSlot, this.item);
        return true;
    }

    public boolean restoreInventory() {
        if (this.storedInventory == null) {
            return false;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return false;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack storedItem = this.storedInventory.getItem(this.storedSlot);
        ItemStack currentItem = inventory.getItem(this.storedSlot);
        String currentId = Wand.getWandId(currentItem);
        String storedId = Wand.getWandId(storedItem);
        if (storedId != null && storedId.equals(this.id) && currentId != this.id) {
            if (Wand.isSpell(currentItem)) {
                currentItem = null;
            }
            this.storedInventory.setItem(this.storedSlot, currentItem);
            this.controller.info("Cleared wand on inv close for player " + player.getName());
        }
        for (int i = 0; i < this.storedInventory.getSize(); ++i) {
            inventory.setItem(i, this.storedInventory.getItem(i));
        }
        this.storedInventory = null;
        this.saveItemState();
        inventory.setHeldItemSlot(this.storedSlot);
        player.updateInventory();
        return true;
    }

    @Override
    public boolean isSoul() {
        return this.soul;
    }

    @Override
    public boolean isBound() {
        return this.bound;
    }

    @Override
    public Spell getSpell(String spellKey, com.elmakers.mine.bukkit.api.magic.Mage mage) {
        if (mage == null) {
            return null;
        }
        SpellKey key = new SpellKey(spellKey);
        String baseKey = key.getBaseKey();
        Integer level = this.spellLevels.get(baseKey);
        if (level == null) {
            return null;
        }
        SpellKey levelKey = new SpellKey(baseKey, level);
        return mage.getSpell(levelKey.getKey());
    }

    @Override
    public SpellTemplate getSpellTemplate(String spellKey) {
        SpellKey key = new SpellKey(spellKey);
        String baseKey = key.getBaseKey();
        Integer level = this.spellLevels.get(baseKey);
        if (level == null) {
            return null;
        }
        SpellKey levelKey = new SpellKey(baseKey, level);
        return this.controller.getSpellTemplate(levelKey.getKey());
    }

    @Override
    public Spell getSpell(String spellKey) {
        return this.getSpell(spellKey, this.mage);
    }

    @Override
    public int getSpellLevel(String spellKey) {
        SpellKey key = new SpellKey(spellKey);
        Integer level = this.spellLevels.get(key.getBaseKey());
        return level == null ? 0 : level;
    }

    @Override
    public MageController getController() {
        return this.controller;
    }

    protected Map<String, Integer> getSpellInventory() {
        return new HashMap<String, Integer>(this.spells);
    }

    protected Map<String, Integer> getBrushInventory() {
        return new HashMap<String, Integer>(this.brushes);
    }

    protected void updateSpellInventory(Map<String, Integer> updateSpells) {
        for (Map.Entry<String, Integer> spellEntry : this.spells.entrySet()) {
            String spellKey = spellEntry.getKey();
            Integer slot = updateSpells.get(spellKey);
            if (slot == null) continue;
            spellEntry.setValue(slot);
        }
    }

    protected void updateBrushInventory(Map<String, Integer> updateBrushes) {
        for (Map.Entry<String, Integer> brushEntry : this.brushes.entrySet()) {
            String brushKey = brushEntry.getKey();
            Integer slot = updateBrushes.get(brushKey);
            if (slot == null) continue;
            brushEntry.setValue(slot);
        }
    }

    public Map<PotionEffectType, Integer> getPotionEffects() {
        return this.potionEffects;
    }

    @Override
    public float getHealthRegeneration() {
        Integer level = this.potionEffects.get(PotionEffectType.REGENERATION);
        return level != null && level > 0 ? (float)level.intValue() : 0.0f;
    }

    @Override
    public float getHungerRegeneration() {
        Integer level = this.potionEffects.get(PotionEffectType.SATURATION);
        return level != null && level > 0 ? (float)level.intValue() : 0.0f;
    }

    @Override
    public WandTemplate getTemplate() {
        if (this.template == null || this.template.isEmpty()) {
            return null;
        }
        return this.controller.getWandTemplate(this.template);
    }

    @Override
    public void playEffects(String effects) {
        WandTemplate wandTemplate = this.getTemplate();
        if (wandTemplate != null && this.mage != null) {
            wandTemplate.playEffects(this.mage, effects);
        }
    }

    public WandAction getDropAction() {
        return this.dropAction;
    }

    public WandAction getRightClickAction() {
        return this.rightClickAction;
    }

    public WandAction getLeftClickAction() {
        return this.leftClickAction;
    }

    public WandAction getSwapAction() {
        return this.swapAction;
    }

    public boolean performAction(WandAction action) {
        WandMode mode = this.getMode();
        switch (action) {
            case CAST: {
                this.cast();
                break;
            }
            case TOGGLE: {
                if (mode != WandMode.CHEST && mode != WandMode.INVENTORY) {
                    return false;
                }
                this.toggleInventory();
                break;
            }
            case CYCLE: {
                this.cycleActive(1);
                break;
            }
            case CYCLE_REVERSE: {
                this.cycleActive(-1);
                break;
            }
            case CYCLE_HOTBAR: {
                if (mode != WandMode.INVENTORY || !this.isInventoryOpen()) {
                    return false;
                }
                if (this.getHotbarCount() > 1) {
                    this.cycleHotbar(1);
                    break;
                }
                this.closeInventory();
                break;
            }
            case CYCLE_HOTBAR_REVERSE: {
                if (mode != WandMode.INVENTORY) {
                    return false;
                }
                if (this.getHotbarCount() > 1) {
                    this.cycleHotbar(-1);
                    break;
                }
                if (this.isInventoryOpen()) {
                    this.closeInventory();
                    break;
                }
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean checkAndUpgrade(boolean quiet) {
        com.elmakers.mine.bukkit.api.wand.WandUpgradePath nextPath;
        com.elmakers.mine.bukkit.api.wand.WandUpgradePath path = this.getPath();
        com.elmakers.mine.bukkit.api.wand.WandUpgradePath wandUpgradePath = nextPath = path != null ? path.getUpgrade() : null;
        if (nextPath == null || path.canEnchant(this)) {
            return true;
        }
        if (!path.checkUpgradeRequirements(this, quiet ? null : this.mage)) {
            return false;
        }
        path.upgrade(this, this.mage);
        return true;
    }
}

