/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.magic.Automaton;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.SpellCategory;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.LostWand;
import com.elmakers.mine.bukkit.citizens.CitizensController;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.command.CastCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MageCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicGiveCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicItemCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicMapCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicMobCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicSaveCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicServerCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicSkillsCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicTraitCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.SpellsCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.WandCommandExecutor;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MagicPlugin
extends JavaPlugin
implements MagicAPI {
    private static MagicPlugin instance;
    private MagicController controller = null;

    public MagicPlugin() {
        instance = this;
    }

    public void onEnable() {
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        if (this.controller == null) {
            this.controller = new MagicController(this);
        }
        if (NMSUtils.getFailed()) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[Magic] Something went wrong with some Deep Magic, plugin will not load.");
            Bukkit.getConsoleSender().sendMessage(ChatColor.DARK_RED + "[Magic] Please make sure you are running a compatible version of " + ChatColor.RED + "Spigot (1.9 or Higher)!");
        } else {
            if (NMSUtils.isLegacy()) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.YELLOW + "[Magic] Using backwards-compatibility layer. It is highly recommended that you update to the latest Spigot version.");
            }
            this.initialize();
        }
    }

    protected void initialize() {
        this.controller.initialize();
        MagicCommandExecutor magicCommand = new MagicCommandExecutor(this);
        this.getCommand("magic").setExecutor((CommandExecutor)magicCommand);
        this.getCommand("magic").setTabCompleter((TabCompleter)magicCommand);
        MageCommandExecutor mageCommand = new MageCommandExecutor(this);
        this.getCommand("mage").setExecutor((CommandExecutor)mageCommand);
        this.getCommand("mage").setTabCompleter((TabCompleter)mageCommand);
        MagicGiveCommandExecutor magicGiveCommand = new MagicGiveCommandExecutor(this);
        this.getCommand("mgive").setExecutor((CommandExecutor)magicGiveCommand);
        this.getCommand("mgive").setTabCompleter((TabCompleter)magicGiveCommand);
        MagicItemCommandExecutor magicItemCommand = new MagicItemCommandExecutor(this);
        this.getCommand("mitem").setExecutor((CommandExecutor)magicItemCommand);
        this.getCommand("mitem").setTabCompleter((TabCompleter)magicItemCommand);
        MagicMobCommandExecutor magicMobCommand = new MagicMobCommandExecutor(this);
        this.getCommand("mmob").setExecutor((CommandExecutor)magicMobCommand);
        this.getCommand("mmob").setTabCompleter((TabCompleter)magicMobCommand);
        MagicMapCommandExecutor magicMapCommand = new MagicMapCommandExecutor(this);
        this.getCommand("mmap").setExecutor((CommandExecutor)magicMapCommand);
        this.getCommand("mmap").setTabCompleter((TabCompleter)magicMapCommand);
        MagicServerCommandExecutor magicServerCommand = new MagicServerCommandExecutor(this);
        this.getCommand("mserver").setExecutor((CommandExecutor)magicServerCommand);
        this.getCommand("mserver").setTabCompleter((TabCompleter)magicServerCommand);
        MagicSaveCommandExecutor magicSaveCommand = new MagicSaveCommandExecutor(this);
        this.getCommand("msave").setExecutor((CommandExecutor)magicSaveCommand);
        this.getCommand("msave").setTabCompleter((TabCompleter)magicSaveCommand);
        MagicSkillsCommandExecutor magicSkillsCommand = new MagicSkillsCommandExecutor(this);
        this.getCommand("mskills").setExecutor((CommandExecutor)magicSkillsCommand);
        this.getCommand("mskills").setTabCompleter((TabCompleter)magicSkillsCommand);
        CastCommandExecutor castCommand = new CastCommandExecutor(this);
        this.getCommand("cast").setExecutor((CommandExecutor)castCommand);
        this.getCommand("cast").setTabCompleter((TabCompleter)castCommand);
        this.getCommand("castp").setExecutor((CommandExecutor)castCommand);
        this.getCommand("castp").setTabCompleter((TabCompleter)castCommand);
        WandCommandExecutor wandCommand = new WandCommandExecutor(this);
        this.getCommand("wand").setExecutor((CommandExecutor)wandCommand);
        this.getCommand("wand").setTabCompleter((TabCompleter)wandCommand);
        this.getCommand("wandp").setExecutor((CommandExecutor)wandCommand);
        this.getCommand("wandp").setTabCompleter((TabCompleter)wandCommand);
        SpellsCommandExecutor spellsCommand = new SpellsCommandExecutor(this);
        this.getCommand("spells").setExecutor((CommandExecutor)spellsCommand);
        CitizensController citizens = this.controller.getCitizens();
        if (citizens != null) {
            MagicTraitCommandExecutor magicTraitCommand = new MagicTraitCommandExecutor(this, citizens);
            this.getCommand("mtrait").setExecutor((CommandExecutor)magicTraitCommand);
            this.getCommand("mtrait").setTabCompleter((TabCompleter)magicTraitCommand);
        }
    }

    public void onDisable() {
        if (this.controller != null) {
            this.controller.clear();
            this.controller.save();
        }
    }

    @Override
    public Plugin getPlugin() {
        return this;
    }

    @Override
    public boolean hasPermission(CommandSender sender, String pNode) {
        return this.controller.hasPermission(sender, pNode);
    }

    @Override
    public boolean hasPermission(CommandSender sender, String pNode, boolean defaultPermission) {
        return this.controller.hasPermission(sender, pNode, defaultPermission);
    }

    @Override
    public void save() {
        this.controller.save();
    }

    @Override
    public void reload() {
        this.controller.loadConfiguration();
    }

    @Override
    public void reload(CommandSender sender) {
        this.controller.loadConfiguration(sender);
    }

    @Override
    public void clearCache() {
        this.controller.clearCache();
    }

    @Override
    public boolean commit() {
        return this.controller.commitAll();
    }

    @Override
    public Collection<Mage> getMages() {
        return this.controller.getMages();
    }

    @Override
    public Collection<Mage> getMagesWithPendingBatches() {
        ArrayList<Mage> mages = new ArrayList<Mage>();
        Collection<Mage> internal = this.controller.getPending();
        mages.addAll(internal);
        return mages;
    }

    @Override
    public Collection<UndoList> getPendingUndo() {
        ArrayList<UndoList> undo = new ArrayList<UndoList>();
        undo.addAll(this.controller.getPendingUndo());
        return undo;
    }

    @Override
    public Collection<LostWand> getLostWands() {
        ArrayList<LostWand> lostWands = new ArrayList<LostWand>();
        lostWands.addAll(this.controller.getLostWands());
        return lostWands;
    }

    @Override
    public Collection<Automaton> getAutomata() {
        ArrayList<Automaton> automata = new ArrayList<Automaton>();
        automata.addAll(this.controller.getAutomata());
        return automata;
    }

    @Override
    public void removeLostWand(String id) {
        this.controller.removeLostWand(id);
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand getWand(ItemStack itemStack) {
        return new Wand(this.controller, itemStack);
    }

    @Override
    public boolean isWand(ItemStack item) {
        return Wand.isWand(item);
    }

    @Override
    public String getSpell(ItemStack item) {
        return Wand.getSpell(item);
    }

    @Override
    public boolean isBrush(ItemStack item) {
        return Wand.isBrush(item);
    }

    @Override
    public boolean isSpell(ItemStack item) {
        return Wand.isSpell(item);
    }

    @Override
    public String getBrush(ItemStack item) {
        return Wand.getBrush(item);
    }

    @Override
    public boolean isUpgrade(ItemStack item) {
        return Wand.isUpgrade(item);
    }

    @Override
    public void giveItemToPlayer(Player player, ItemStack itemStack) {
        this.controller.giveItemToPlayer(player, itemStack);
    }

    @Override
    public void giveExperienceToPlayer(Player player, int xp) {
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage != null) {
            mage.giveExperience(xp);
        } else {
            player.giveExp(xp);
        }
    }

    @Override
    public Mage getMage(CommandSender sender) {
        return this.controller.getMage(sender);
    }

    @Override
    public Mage getMage(Entity entity, CommandSender sender) {
        return this.controller.getMage(entity);
    }

    @Override
    public String describeItem(ItemStack item) {
        return this.controller.describeItem(item);
    }

    @Override
    public boolean takeItem(Player player, ItemStack item) {
        return this.controller.takeItem(player, item);
    }

    @Override
    public boolean hasItem(Player player, ItemStack item) {
        return this.controller.hasItem(player, item);
    }

    @Override
    public ItemStack createItem(String magicKey) {
        return this.createItem(magicKey, null);
    }

    @Override
    public ItemStack createItem(String magicKey, Mage mage) {
        ItemStack itemStack = null;
        if (this.controller == null) {
            this.getLogger().log(Level.WARNING, "Calling API before plugin is initialized");
            return null;
        }
        if (magicKey.contains("skill:")) {
            String spellKey = magicKey.substring(6);
            itemStack = Wand.createSpellItem(spellKey, this.controller, mage, null, false);
            InventoryUtils.setMeta(itemStack, "skill", "true");
            return itemStack;
        }
        return this.controller.createItem(magicKey);
    }

    @Override
    public ItemStack createGenericItem(String itemKey) {
        return this.controller.createItem(itemKey);
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand createWand(String wandKey) {
        return Wand.createWand(this.controller, wandKey);
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand createUpgrade(String wandKey) {
        Wand wand = Wand.createWand(this.controller, wandKey);
        if (!wand.isUpgrade()) {
            wand.makeUpgrade();
        }
        return wand;
    }

    @Override
    public String getItemKey(ItemStack item) {
        return this.controller.getItemKey(item);
    }

    @Override
    public ItemStack createSpellItem(String spellKey) {
        return Wand.createSpellItem(spellKey, this.controller, null, true);
    }

    @Override
    public ItemStack createBrushItem(String brushKey) {
        return Wand.createBrushItem(brushKey, this.controller, null, true);
    }

    @Override
    public boolean cast(String spellName, String[] parameters) {
        return this.cast(spellName, parameters, null, null);
    }

    @Override
    public Collection<SpellTemplate> getSpellTemplates() {
        return this.controller.getSpellTemplates();
    }

    @Override
    public Collection<SpellTemplate> getSpellTemplates(boolean showHidden) {
        return this.controller.getSpellTemplates(showHidden);
    }

    @Override
    public Collection<String> getWandKeys() {
        return this.controller.getWandTemplateKeys();
    }

    @Override
    public boolean cast(String spellName, String[] parameters, CommandSender sender, Entity entity) {
        MemoryConfiguration config = null;
        if (parameters != null && parameters.length > 0) {
            config = new MemoryConfiguration();
            ConfigurationUtils.addParameters(parameters, (ConfigurationSection)config);
        }
        return this.controller.cast(null, spellName, (ConfigurationSection)config, sender, entity);
    }

    @Override
    public boolean cast(String spellName, ConfigurationSection parameters, CommandSender sender, Entity entity) {
        return this.controller.cast(null, spellName, parameters, sender, entity);
    }

    @Override
    public Collection<String> getPlayerNames() {
        return this.controller.getPlayerNames();
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand createWand(Material iconMaterial, short iconData) {
        return new Wand(this.controller, iconMaterial, iconData);
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand createWand(ItemStack item) {
        return Wand.createWand(this.controller, item);
    }

    @Override
    public SpellTemplate getSpellTemplate(String key) {
        return this.controller.getSpellTemplate(key);
    }

    @Override
    public Collection<String> getSchematicNames() {
        return this.controller.getSchematicNames();
    }

    @Override
    public Collection<String> getBrushes() {
        return this.controller.getBrushKeys();
    }

    @Override
    public MageController getController() {
        return this.controller;
    }

    @Override
    public ItemStack getSpellBook(SpellCategory category, int count) {
        return this.controller.getSpellBook(category, count);
    }

    @Override
    public Messages getMessages() {
        return this.controller.getMessages();
    }

    public static MagicAPI getAPI() {
        return instance;
    }
}

