/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import uk.thinkofdeath.minecraft.physics.PhysicsPlugin;
import uk.thinkofdeath.minecraft.physics.api.PhysicsAPI;
import uk.thinkofdeath.minecraft.physics.api.PhysicsBlock;

public class BlockPhysicsManager {
    private final Plugin plugin;
    private final PhysicsAPI api;
    private double velocityScale = 1.0;

    public BlockPhysicsManager(Plugin owningPlugin, Plugin physicsPlugin) {
        this.plugin = owningPlugin;
        this.api = physicsPlugin instanceof PhysicsPlugin ? ((PhysicsPlugin)physicsPlugin).getAPI(owningPlugin) : null;
    }

    public boolean isEnabled() {
        return this.api != null;
    }

    public void spawnPhysicsBlock(Location location, Material material, short data, Vector velocity) {
        if (this.api == null) {
            return;
        }
        PhysicsBlock block = this.api.spawnBlock(location, new MaterialData(material, (byte)data));
        if (velocity != null) {
            block.applyForce(velocity.multiply(this.velocityScale));
        }
    }

    public void setVelocityScale(double scale) {
        this.velocityScale = scale;
    }
}

