/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.batch.Batch;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.block.UndoQueue;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class UndoAction
extends BaseSpellAction {
    private String undoListName;
    private int timeout;
    private int blockTimeout;
    private String targetSpellKey;
    private boolean targetSelf;
    private boolean targetDown;
    private boolean targetBlocks;
    private boolean targetOtherBlocks;
    private boolean cancel;
    private String adminPermission;
    private int undoOldest;
    private int undoToSize;
    private int undone;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.timeout = parameters.getInt("target_timeout", 0);
        this.blockTimeout = parameters.getInt("target_block_timeout", this.timeout);
        this.targetSelf = parameters.getBoolean("target_caster", false);
        this.targetDown = parameters.getBoolean("target_down", false);
        this.targetBlocks = parameters.getBoolean("target_blocks", true);
        this.targetOtherBlocks = parameters.getBoolean("target_other_blocks", false);
        this.cancel = parameters.getBoolean("cancel", true);
        this.targetSpellKey = parameters.getString("target_spell", null);
        this.adminPermission = parameters.getString("admin_permission", null);
        this.undoOldest = parameters.getInt("undo_oldest", 0);
        this.undoToSize = parameters.getInt("undo_to", 0);
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.undone = 0;
    }

    protected SpellResult performNew(CastContext context) {
        UndoList undoList = context.getUndoList();
        if (undoList.size() == 0) {
            return SpellResult.NO_ACTION;
        }
        boolean undid = false;
        while (context.getWorkAllowed() > 0 && (this.undoToSize <= 0 || undoList.size() > this.undoToSize) && undoList.undoNext(false) != null) {
            undid = true;
            ++this.undone;
            context.addWork(10);
            if (this.undoOldest <= 0 || this.undone <= this.undoOldest) continue;
        }
        if (!undid) {
            return SpellResult.NO_ACTION;
        }
        return this.undoOldest == 0 || this.undone >= this.undoOldest ? SpellResult.CAST : SpellResult.PENDING;
    }

    @Override
    public SpellResult perform(CastContext context) {
        if (this.undoOldest > 0 || this.undoToSize > 0) {
            return this.performNew(context);
        }
        Entity targetEntity = context.getTargetEntity();
        SpellResult result = SpellResult.CAST;
        Mage mage = context.getMage();
        if (this.targetSelf) {
            targetEntity = context.getEntity();
            context.setTargetName(mage.getName());
            result = SpellResult.ALTERNATE_UP;
        }
        MageController controller = context.getController();
        if (targetEntity != null && controller.isMage(targetEntity)) {
            UndoQueue queue;
            UndoList undoList;
            Mage targetMage = controller.getMage(targetEntity);
            mage.sendDebugMessage(ChatColor.AQUA + "Undo checking last spell of " + ChatColor.GOLD + targetMage + ChatColor.AQUA + " with timeout of " + ChatColor.YELLOW + this.timeout + ChatColor.AQUA + " for targe spellKey" + ChatColor.BLUE + this.targetSpellKey, 2);
            Batch batch = targetMage.cancelPending(this.targetSpellKey);
            if (batch != null) {
                this.undoListName = batch.getName();
                if (this.cancel) {
                    return SpellResult.DEACTIVATE;
                }
            }
            if ((undoList = (queue = targetMage.getUndoQueue()).undoRecent(this.timeout, this.targetSpellKey)) != null) {
                this.undoListName = undoList.getName();
            }
            return undoList != null ? result : SpellResult.NO_TARGET;
        }
        if (!this.targetBlocks) {
            return SpellResult.NO_TARGET;
        }
        Block targetBlock = context.getTargetBlock();
        if (this.targetDown) {
            targetBlock = context.getLocation().getBlock();
        }
        if (targetBlock != null) {
            boolean undoAny = this.targetOtherBlocks;
            undoAny = undoAny || this.adminPermission != null && context.getController().hasPermission(context.getMage().getCommandSender(), this.adminPermission, false);
            boolean bl = undoAny = undoAny || mage.isSuperPowered();
            if (undoAny) {
                mage.sendDebugMessage(ChatColor.AQUA + "Looking for recent cast at " + ChatColor.GOLD + targetBlock + ChatColor.AQUA + " with timeout of " + ChatColor.YELLOW + this.blockTimeout, 2);
                UndoList undid = controller.undoRecent(targetBlock, this.blockTimeout);
                if (undid != null) {
                    Mage targetMage = undid.getOwner();
                    this.undoListName = undid.getName();
                    if (targetMage != null) {
                        context.setTargetName(targetMage.getName());
                    }
                    return result;
                }
            } else {
                mage.sendDebugMessage(ChatColor.AQUA + "Looking for recent self-cast at " + ChatColor.GOLD + targetBlock, 2);
                context.setTargetName(mage.getName());
                UndoList undoList = mage.undo(targetBlock);
                if (undoList != null) {
                    this.undoListName = undoList.getName();
                    return result;
                }
            }
        }
        return SpellResult.NO_TARGET;
    }

    @Override
    public String transformMessage(String message) {
        return message.replace("$spell", this.undoListName == null ? "Unknown" : this.undoListName);
    }
}

