/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.block.BlockBanner;
import com.elmakers.mine.bukkit.block.BlockCommand;
import com.elmakers.mine.bukkit.block.BlockExtraData;
import com.elmakers.mine.bukkit.block.BlockMobSpawner;
import com.elmakers.mine.bukkit.block.BlockSign;
import com.elmakers.mine.bukkit.block.BlockSkull;
import com.elmakers.mine.bukkit.block.BlockTileEntity;
import com.elmakers.mine.bukkit.integration.VaultController;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.SkullType;
import org.bukkit.TreeSpecies;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class MaterialAndData
implements com.elmakers.mine.bukkit.api.block.MaterialAndData {
    protected Material material;
    protected Short data;
    protected BlockExtraData extraData;
    protected boolean isValid = true;
    public Material DEFAULT_MATERIAL;

    public MaterialAndData() {
        this.material = this.DEFAULT_MATERIAL = Material.AIR;
        this.data = 0;
    }

    public MaterialAndData(Material material) {
        this.DEFAULT_MATERIAL = Material.AIR;
        this.material = material;
        this.data = 0;
    }

    public MaterialAndData(Material material, short data) {
        this.DEFAULT_MATERIAL = Material.AIR;
        this.material = material;
        this.data = data;
    }

    public MaterialAndData(ItemStack item) {
        ItemMeta meta;
        this.DEFAULT_MATERIAL = Material.AIR;
        this.material = item.getType();
        this.data = item.getDurability();
        if (this.material == Material.SKULL_ITEM) {
            ItemMeta meta2 = item.getItemMeta();
            Object profile = InventoryUtils.getSkullProfile(meta2);
            SkullType skullType = SkullType.PLAYER;
            try {
                skullType = SkullType.values()[this.data];
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.extraData = new BlockSkull(profile, skullType);
        } else if ((this.material == Material.STANDING_BANNER || this.material == Material.WALL_BANNER || this.material == Material.BANNER) && (meta = item.getItemMeta()) != null && meta instanceof BannerMeta) {
            BannerMeta banner = (BannerMeta)meta;
            this.extraData = new BlockBanner(banner.getPatterns(), banner.getBaseColor());
        }
    }

    public MaterialAndData(Block block) {
        this.DEFAULT_MATERIAL = Material.AIR;
        this.updateFrom(block);
    }

    public MaterialAndData(com.elmakers.mine.bukkit.api.block.MaterialAndData other) {
        this.DEFAULT_MATERIAL = Material.AIR;
        this.updateFrom(other);
    }

    public MaterialAndData(String materialKey) {
        this();
        this.update(materialKey);
    }

    public void update(String materialKey) {
        Material material;
        Short data;
        block23: {
            if (materialKey == null || materialKey.length() == 0) {
                this.isValid = false;
                return;
            }
            String[] pieces = MaterialAndData.splitMaterialKey(materialKey);
            data = 0;
            material = null;
            try {
                if (pieces.length > 0 && !pieces[0].equals("*")) {
                    try {
                        Integer id = Integer.parseInt(pieces[0]);
                        material = DeprecatedUtils.getMaterial(id);
                    }
                    catch (Exception ex) {
                        material = Material.getMaterial((String)pieces[0].toUpperCase());
                    }
                }
            }
            catch (Exception ex) {
                material = null;
            }
            try {
                if (pieces.length <= 1) break block23;
                if (pieces[1].equals("*")) {
                    data = null;
                    break block23;
                }
                if (material == Material.MOB_SPAWNER) {
                    this.extraData = new BlockMobSpawner(pieces[1]);
                    this.setMaterial(Material.MOB_SPAWNER, (short)0);
                    return;
                }
                if (material == Material.SKULL_ITEM) {
                    if (pieces.length > 2) {
                        this.setMaterial(Material.SKULL_ITEM, (short)3);
                        String dataString = pieces[1];
                        for (int i = 2; i < pieces.length; ++i) {
                            dataString = dataString + ":" + pieces[i];
                        }
                        ItemStack item = InventoryUtils.getURLSkull(dataString);
                        this.extraData = new BlockSkull(InventoryUtils.getSkullProfile(item.getItemMeta()), SkullType.PLAYER);
                    } else {
                        try {
                            data = Short.parseShort(pieces[1]);
                            this.setMaterial(Material.SKULL_ITEM, data);
                        }
                        catch (Exception ex) {
                            this.setMaterial(Material.SKULL_ITEM, (short)3);
                            ItemStack item = InventoryUtils.getPlayerSkull(pieces[1]);
                            this.extraData = new BlockSkull(InventoryUtils.getSkullProfile(item.getItemMeta()), SkullType.PLAYER);
                        }
                    }
                    return;
                }
                if (material == Material.STANDING_BANNER || material == Material.WALL_BANNER || material == Material.BANNER) {
                    DyeColor color = null;
                    try {
                        short colorIndex = Short.parseShort(pieces[1]);
                        this.setMaterial(material, colorIndex);
                        color = DyeColor.values()[colorIndex];
                    }
                    catch (Exception ex) {
                        color = null;
                    }
                    this.extraData = color == null ? null : new BlockBanner(color);
                    return;
                }
                try {
                    data = Short.parseShort(pieces[1]);
                }
                catch (Exception ex) {
                    data = 0;
                }
            }
            catch (Exception ex) {
                material = null;
            }
        }
        if (material == null) {
            this.setMaterial(null, null);
            this.isValid = false;
        } else {
            this.setMaterial(material, data);
        }
    }

    public int hashCode() {
        return (this.material == null ? -1 : this.material.getId() << 16) | (this.data == null ? -1 : (int)this.data.shortValue());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof com.elmakers.mine.bukkit.api.block.MaterialAndData)) {
            return false;
        }
        com.elmakers.mine.bukkit.api.block.MaterialAndData other = (com.elmakers.mine.bukkit.api.block.MaterialAndData)obj;
        return other.getData() == this.data && other.getMaterial() == this.material;
    }

    @Override
    public void updateFrom(com.elmakers.mine.bukkit.api.block.MaterialAndData other) {
        this.material = other.getMaterial();
        this.data = other.getData();
        if (other instanceof MaterialAndData) {
            MaterialAndData o = (MaterialAndData)other;
            this.extraData = o.extraData != null ? o.extraData.clone() : null;
            this.isValid = o.isValid;
        }
    }

    @Override
    public void setMaterial(Material material, short data) {
        this.setMaterial(material, (Short)data);
    }

    public void setMaterial(Material material, Short data) {
        this.material = material;
        this.data = data;
        this.extraData = null;
        this.isValid = true;
    }

    public void setMaterialId(int id) {
        this.material = Material.getMaterial((int)id);
    }

    @Override
    public void setMaterial(Material material) {
        this.setMaterial(material, (short)0);
    }

    @Override
    public void updateFrom(Block block) {
        this.updateFrom(block, null);
    }

    public void updateFrom(Block block, Set<Material> restrictedMaterials) {
        if (block == null) {
            this.isValid = false;
            return;
        }
        if (!block.getChunk().isLoaded()) {
            block.getChunk().load(true);
            return;
        }
        Material blockMaterial = block.getType();
        if (restrictedMaterials != null && restrictedMaterials.contains(blockMaterial)) {
            this.isValid = false;
            return;
        }
        this.extraData = null;
        this.material = blockMaterial;
        this.data = block.getData();
        try {
            BlockState blockState = block.getState();
            if (this.material == Material.FLOWER_POT || blockState instanceof InventoryHolder || blockState instanceof Sign) {
                this.extraData = new BlockTileEntity(NMSUtils.getTileEntityData(block.getLocation()));
            } else if (blockState instanceof CommandBlock) {
                CommandBlock command = (CommandBlock)blockState;
                this.extraData = new BlockCommand(command.getCommand(), command.getName());
            } else if (blockState instanceof Skull) {
                Skull skull = (Skull)blockState;
                this.data = (short)skull.getSkullType().ordinal();
                this.extraData = new BlockSkull(CompatibilityUtils.getSkullProfile(skull), skull.getSkullType(), skull.getRotation());
            } else if (blockState instanceof CreatureSpawner) {
                CreatureSpawner spawner = (CreatureSpawner)blockState;
                this.extraData = new BlockMobSpawner(spawner.getCreatureTypeName());
            } else if ((blockMaterial == Material.STANDING_BANNER || blockMaterial == Material.WALL_BANNER) && blockState != null && blockState instanceof Banner) {
                Banner banner = (Banner)blockState;
                DyeColor color = banner.getBaseColor();
                this.extraData = new BlockBanner(banner.getPatterns(), color);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.isValid = true;
    }

    @Override
    public void modify(Block block) {
        this.modify(block, false);
    }

    @Override
    public void modify(Block block, boolean applyPhysics) {
        if (!this.isValid) {
            return;
        }
        try {
            BlockState blockState = block.getState();
            if (blockState instanceof InventoryHolder) {
                NMSUtils.clearItems(block.getLocation());
            }
            if (this.material != null) {
                byte blockData = this.data != null ? (byte)this.data.shortValue() : block.getData();
                block.setTypeIdAndData(this.material.getId(), blockData, applyPhysics);
                blockState = block.getState();
            }
            if (blockState != null && blockState instanceof CommandBlock && this.extraData != null && this.extraData instanceof BlockCommand) {
                CommandBlock command = (CommandBlock)blockState;
                BlockCommand commandData = (BlockCommand)this.extraData;
                command.setCommand(commandData.command);
                if (commandData.customName != null) {
                    command.setName(commandData.customName);
                }
                command.update();
            } else if (this.extraData != null && this.extraData instanceof BlockTileEntity) {
                NMSUtils.setTileEntityData(block.getLocation(), ((BlockTileEntity)this.extraData).data);
            } else if (blockState != null && (this.material == Material.STANDING_BANNER || this.material == Material.WALL_BANNER) && this.extraData != null && this.extraData instanceof BlockBanner) {
                if (blockState instanceof Banner) {
                    BlockBanner bannerData = (BlockBanner)this.extraData;
                    Banner banner = (Banner)blockState;
                    if (bannerData.patterns != null) {
                        banner.setPatterns(bannerData.patterns);
                    }
                    if (bannerData.baseColor != null) {
                        banner.setBaseColor(bannerData.baseColor);
                    }
                }
                blockState.update(true, false);
            } else if (blockState != null && blockState instanceof Skull && this.extraData != null && this.extraData instanceof BlockSkull) {
                Skull skull = (Skull)blockState;
                BlockSkull skullData = (BlockSkull)this.extraData;
                if (skullData.skullType != null) {
                    skull.setSkullType(skullData.skullType);
                }
                if (skullData.rotation != null) {
                    skull.setRotation(skullData.rotation);
                }
                if (skullData.profile != null) {
                    CompatibilityUtils.setSkullProfile(skull, skullData.profile);
                }
                skull.update(true, false);
            } else if (blockState != null && blockState instanceof CreatureSpawner && this.extraData != null && this.extraData instanceof BlockMobSpawner) {
                BlockMobSpawner spawnerData = (BlockMobSpawner)this.extraData;
                if (spawnerData.mobName != null && !spawnerData.mobName.isEmpty()) {
                    CreatureSpawner spawner = (CreatureSpawner)blockState;
                    spawner.setCreatureTypeByName(spawnerData.mobName);
                    spawner.update();
                }
            } else if (blockState != null && blockState instanceof Sign && this.extraData != null && this.extraData instanceof BlockSign) {
                BlockSign signData = (BlockSign)this.extraData;
                Sign sign = (Sign)blockState;
                for (int i = 0; i < signData.lines.length; ++i) {
                    sign.setLine(i, signData.lines[i]);
                }
                sign.update();
            }
        }
        catch (Exception ex) {
            Bukkit.getLogger().warning("Error updating block state: " + ex.getMessage());
        }
    }

    @Override
    public Short getData() {
        return this.data;
    }

    @Override
    public Byte getBlockData() {
        return this.data == null ? null : Byte.valueOf((byte)this.data.shortValue());
    }

    @Override
    public Material getMaterial() {
        return this.material;
    }

    @Override
    public String getKey() {
        return this.getKey(this.data);
    }

    public String getKey(Short data) {
        String materialKey;
        String string = materialKey = this.material == null ? "*" : this.material.name().toLowerCase();
        if (data == null) {
            materialKey = materialKey + ":*";
        } else if (this.material == Material.SKULL_ITEM && this.extraData != null && this.extraData instanceof BlockSkull) {
            materialKey = materialKey + ":" + InventoryUtils.getProfileURL(((BlockSkull)this.extraData).profile);
        } else if (this.material == Material.MOB_SPAWNER && this.extraData != null && this.extraData instanceof BlockMobSpawner) {
            BlockMobSpawner spawnerData = (BlockMobSpawner)this.extraData;
            if (spawnerData.mobName != null && !spawnerData.mobName.isEmpty()) {
                materialKey = materialKey + ":" + spawnerData.mobName;
            }
        } else if ((this.material == Material.STANDING_BANNER || this.material == Material.WALL_BANNER || this.material == Material.BANNER) && this.extraData != null && this.extraData instanceof BlockBanner) {
            materialKey = materialKey + ":" + ((BlockBanner)this.extraData).baseColor.ordinal();
        } else if (data != 0) {
            materialKey = materialKey + ":" + data;
        }
        return materialKey;
    }

    public String getWildDataKey() {
        return this.getKey(null);
    }

    @Override
    public boolean is(Block block) {
        return this.material == block.getType() && this.data.shortValue() == block.getData();
    }

    @Override
    public boolean isDifferent(Block block) {
        CommandBlock command;
        Material blockMaterial = block.getType();
        byte blockData = block.getData();
        if (this.material != null && blockMaterial != this.material || this.data != null && blockData != this.data) {
            return true;
        }
        if (this.material == Material.WALL_BANNER || this.material == Material.STANDING_BANNER) {
            return true;
        }
        BlockState blockState = block.getState();
        if (blockState instanceof Sign) {
            return true;
        }
        return blockState instanceof CommandBlock && this.extraData != null && this.extraData instanceof BlockCommand ? !(command = (CommandBlock)blockState).getCommand().equals(((BlockCommand)this.extraData).command) : blockState instanceof InventoryHolder;
    }

    @Override
    public ItemStack getItemStack(int amount) {
        if (this.material == null) {
            return null;
        }
        switch (this.material) {
            case SKULL: {
                this.material = Material.SKULL_ITEM;
                break;
            }
            case WALL_BANNER: {
                this.material = Material.BANNER;
                break;
            }
            case STANDING_BANNER: {
                this.material = Material.BANNER;
                break;
            }
            case WOODEN_DOOR: {
                this.material = Material.WOOD_DOOR;
                break;
            }
            case IRON_DOOR_BLOCK: {
                this.material = Material.IRON_DOOR;
                break;
            }
            case WALL_SIGN: {
                this.material = Material.SIGN;
                break;
            }
            case SIGN_POST: {
                this.material = Material.SIGN;
                break;
            }
            case ACACIA_DOOR: {
                this.material = Material.ACACIA_DOOR_ITEM;
                break;
            }
            case JUNGLE_DOOR: {
                this.material = Material.JUNGLE_DOOR_ITEM;
                break;
            }
            case DARK_OAK_DOOR: {
                this.material = Material.DARK_OAK_DOOR_ITEM;
                break;
            }
            case BIRCH_DOOR: {
                this.material = Material.BIRCH_DOOR_ITEM;
                break;
            }
            case SPRUCE_DOOR: {
                this.material = Material.SPRUCE_DOOR_ITEM;
                break;
            }
        }
        ItemStack stack = new ItemStack(this.material, amount, this.data == null ? (short)0 : this.data);
        this.applyToItem(stack);
        return stack;
    }

    public ItemStack applyToItem(ItemStack stack) {
        ItemMeta meta;
        stack.setType(this.material);
        if (this.data != null) {
            stack.setDurability(this.data.shortValue());
        }
        if (this.material == Material.SKULL_ITEM) {
            ItemMeta meta2 = stack.getItemMeta();
            if (meta2 != null && meta2 instanceof SkullMeta && this.extraData != null && this.extraData instanceof BlockSkull) {
                BlockSkull skullData = (BlockSkull)this.extraData;
                if (skullData.skullType == SkullType.PLAYER && skullData.profile != null) {
                    SkullMeta skullMeta = (SkullMeta)meta2;
                    InventoryUtils.setSkullProfile((ItemMeta)skullMeta, ((BlockSkull)this.extraData).profile);
                    stack.setItemMeta(meta2);
                }
            }
        } else if ((this.material == Material.STANDING_BANNER || this.material == Material.WALL_BANNER || this.material == Material.BANNER) && (meta = stack.getItemMeta()) != null && meta instanceof BannerMeta && this.extraData != null && this.extraData instanceof BlockBanner) {
            BannerMeta banner = (BannerMeta)meta;
            BlockBanner bannerData = (BlockBanner)this.extraData;
            if (bannerData.patterns != null) {
                banner.setPatterns(bannerData.patterns);
            }
            if (bannerData.baseColor != null) {
                banner.setBaseColor(bannerData.baseColor);
            }
            stack.setItemMeta(meta);
        }
        return stack;
    }

    public static String[] splitMaterialKey(String materialKey) {
        if (materialKey.contains("|")) {
            return StringUtils.split((String)materialKey, (String)"|");
        }
        if (materialKey.contains(":")) {
            return StringUtils.split((String)materialKey, (String)":");
        }
        return new String[]{materialKey};
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public static String getMaterialName(ItemStack item) {
        MaterialAndData material = new MaterialAndData(item);
        return material.getName();
    }

    public static String getMaterialName(Block block) {
        MaterialAndData material = new MaterialAndData(block);
        return material.getName();
    }

    @Override
    public String getName() {
        return this.getName(null);
    }

    @Override
    public String getBaseName() {
        if (this.material == null) {
            return null;
        }
        return this.material.name().toLowerCase().replace('_', ' ');
    }

    public String getName(Messages messages) {
        if (!this.isValid()) {
            return "";
        }
        VaultController controller = VaultController.getInstance();
        if (controller != null && this.data != null) {
            try {
                String vaultName = controller.getItemName(this.material, this.data);
                if (vaultName != null && !vaultName.isEmpty()) {
                    return vaultName;
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        String materialName = this.material.name();
        if (this.data != null) {
            DyeColor color;
            if (this.material == Material.CARPET || this.material == Material.STAINED_GLASS || this.material == Material.STAINED_CLAY || this.material == Material.STAINED_GLASS_PANE || this.material == Material.WOOL) {
                DyeColor color2 = DyeColor.getByWoolData((byte)((byte)this.data.shortValue()));
                if (color2 != null) {
                    materialName = color2.name().toLowerCase().replace('_', ' ') + " " + materialName;
                }
            } else if (this.material == Material.WOOD || this.material == Material.LOG || this.material == Material.SAPLING || this.material == Material.LEAVES || this.material == Material.LOG_2 || this.material == Material.LEAVES_2) {
                TreeSpecies treeSpecies = TreeSpecies.getByData((byte)((byte)this.data.shortValue()));
                if (treeSpecies != null) {
                    materialName = treeSpecies.name().toLowerCase().replace('_', ' ') + " " + materialName;
                }
            } else if (this.material == Material.MOB_SPAWNER && this.extraData != null && this.extraData instanceof BlockMobSpawner) {
                BlockMobSpawner spawnerData = (BlockMobSpawner)this.extraData;
                if (spawnerData.mobName != null && !spawnerData.mobName.isEmpty()) {
                    materialName = materialName + " (" + spawnerData.mobName + ")";
                }
            } else if ((this.material == Material.STANDING_BANNER || this.material == Material.WALL_BANNER || this.material == Material.BANNER) && this.extraData != null && this.extraData instanceof BlockBanner && (color = ((BlockBanner)this.extraData).baseColor) != null) {
                materialName = color.name().toLowerCase() + " " + materialName;
            }
        } else if (messages != null) {
            materialName = materialName + messages.get("material.wildcard");
        }
        materialName = materialName.toLowerCase().replace('_', ' ');
        return materialName;
    }

    @Override
    public void setCustomName(String customName) {
        if (this.extraData != null && this.extraData instanceof BlockCommand) {
            ((BlockCommand)this.extraData).customName = customName;
        } else {
            this.extraData = new BlockCommand(null, customName);
        }
    }

    @Override
    public void setCommandLine(String command) {
        if (this.extraData != null && this.extraData instanceof BlockCommand) {
            ((BlockCommand)this.extraData).command = command;
        } else {
            this.extraData = new BlockCommand(command);
        }
    }

    @Override
    public String getCommandLine() {
        if (this.extraData != null && this.extraData instanceof BlockCommand) {
            return ((BlockCommand)this.extraData).command;
        }
        return null;
    }

    @Override
    public void setData(Short data) {
        this.data = data;
    }

    @Override
    public void setRawData(Object data) {
        this.extraData = this.material == Material.SIGN_POST || this.material == Material.WALL_SIGN ? new BlockSign(data) : new BlockTileEntity(data);
    }

    public String toString() {
        return this.isValid() ? this.material + (this.data != 0 ? "@" + this.data : "") : "invalid";
    }
}

