/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Villager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.util.Vector;

public class SpawnEntityAction
extends BaseSpellAction {
    private final LinkedList<WeightedPair<String>> entityTypeProbability = new LinkedList();
    private CreatureSpawnEvent.SpawnReason spawnReason = CreatureSpawnEvent.SpawnReason.EGG;
    private WeakReference<Entity> current = null;
    private boolean track = true;
    private boolean loot = false;
    private boolean setTarget = false;
    private boolean force = false;
    private Vector direction = null;
    private double speed;
    private double dyOffset;
    private com.elmakers.mine.bukkit.api.entity.EntityData entityData;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.track = parameters.getBoolean("track", true);
        this.loot = parameters.getBoolean("loot", false);
        this.force = parameters.getBoolean("force", false);
        this.setTarget = parameters.getBoolean("set_target", false);
        this.speed = parameters.getDouble("speed", 0.0);
        this.direction = ConfigurationUtils.getVector(parameters, "direction");
        this.dyOffset = parameters.getDouble("dy_offset", 0.0);
        if (parameters.contains("type")) {
            String mobType = parameters.getString("type");
            this.entityData = context.getController().getMob(mobType);
            if (this.entityData == null) {
                this.entityData = new EntityData(context.getController(), parameters);
            }
        }
        if (parameters.contains("reason")) {
            String reasonText = parameters.getString("reason").toUpperCase();
            try {
                this.spawnReason = CreatureSpawnEvent.SpawnReason.valueOf((String)reasonText);
            }
            catch (Exception ex) {
                this.spawnReason = CreatureSpawnEvent.SpawnReason.EGG;
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Block targetBlock = context.getTargetBlock();
        Entity currentEntity = this.current == null ? null : (Entity)this.current.get();
        this.current = null;
        if (currentEntity != null) {
            currentEntity.remove();
        }
        targetBlock = targetBlock.getRelative(BlockFace.UP);
        Location spawnLocation = targetBlock.getLocation();
        Location sourceLocation = context.getLocation();
        spawnLocation.setPitch(sourceLocation.getPitch());
        spawnLocation.setYaw(sourceLocation.getYaw());
        MageController controller = context.getController();
        if (this.entityData == null) {
            String randomType = (String)RandomUtils.weightedRandom(this.entityTypeProbability);
            try {
                this.entityData = controller.getMob(randomType);
                if (this.entityData == null) {
                    this.entityData = new EntityData(EntityType.valueOf((String)randomType.toUpperCase()));
                }
            }
            catch (Throwable ex) {
                this.entityData = null;
            }
        }
        if (this.entityData == null) {
            return SpellResult.FAIL;
        }
        if (this.force) {
            controller.setForceSpawn(true);
        }
        Entity spawnedEntity = null;
        try {
            spawnedEntity = this.entityData.spawn(context.getController(), spawnLocation, this.spawnReason);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.force) {
            controller.setForceSpawn(false);
        }
        if (spawnedEntity == null) {
            return SpellResult.FAIL;
        }
        if (!this.loot) {
            spawnedEntity.setMetadata("nodrops", (MetadataValue)new FixedMetadataValue(controller.getPlugin(), (Object)true));
        }
        if (this.speed > 0.0) {
            Vector motion = this.direction;
            motion = motion == null ? context.getDirection() : motion.clone();
            if (this.dyOffset != 0.0) {
                motion.setY(motion.getY() + this.dyOffset);
            }
            motion.normalize();
            motion.multiply(this.speed);
            CompatibilityUtils.setEntityMotion(spawnedEntity, motion);
        }
        Collection<EffectPlayer> projectileEffects = context.getEffects("spawned");
        for (EffectPlayer effectPlayer : projectileEffects) {
            effectPlayer.start(spawnedEntity.getLocation(), spawnedEntity, null, null);
        }
        context.registerForUndo(spawnedEntity);
        if (this.track) {
            this.current = new WeakReference<Entity>(spawnedEntity);
        }
        if (this.setTarget) {
            context.setTargetEntity(spawnedEntity);
        }
        return SpellResult.CAST;
    }

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        if (parameters.contains("entity_types")) {
            RandomUtils.populateStringProbabilityMap(this.entityTypeProbability, ConfigurationUtils.getConfigurationSection(parameters, "entity_types"), 0, 0, 0.0f);
        } else {
            this.entityTypeProbability.add(new WeightedPair<String>(Float.valueOf(100.0f), "pig"));
        }
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("track");
        parameters.add("loot");
        parameters.add("baby");
        parameters.add("name");
        parameters.add("type");
        parameters.add("speed");
        parameters.add("reason");
        parameters.add("villager_profession");
        parameters.add("skeleton_type");
        parameters.add("ocelot_type");
        parameters.add("rabbit_type");
        parameters.add("horse_variant");
        parameters.add("horse_style");
        parameters.add("horse_color");
        parameters.add("color");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("type")) {
            for (EntityType type : EntityType.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("reason")) {
            for (CreatureSpawnEvent.SpawnReason type : CreatureSpawnEvent.SpawnReason.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("skeleton_type")) {
            for (Skeleton.SkeletonType type : Skeleton.SkeletonType.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("ocelot_type")) {
            for (Ocelot.Type type : Ocelot.Type.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("villager_profession")) {
            for (Villager.Profession profession : Villager.Profession.values()) {
                examples.add(profession.name().toLowerCase());
            }
        } else if (parameterKey.equals("rabbity_type")) {
            for (Rabbit.Type type : Rabbit.Type.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("horse_variant")) {
            for (Horse.Variant type : Horse.Variant.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("horse_style")) {
            for (Horse.Style type : Horse.Style.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("horse_color")) {
            for (Horse.Color type : Horse.Color.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("color")) {
            for (DyeColor type : DyeColor.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("track") || parameterKey.equals("loot") || parameterKey.equals("baby")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("name")) {
            examples.add("Philbert");
        } else if (parameterKey.equals("speed")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

