/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.wand.Wand;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AnvilController
implements Listener {
    private final MagicController controller;
    private boolean combiningEnabled = false;
    private boolean organizingEnabled = false;
    private boolean clearDescriptionOnRename = false;

    public AnvilController(MagicController controller) {
        this.controller = controller;
    }

    public void load(ConfigurationSection properties) {
        this.combiningEnabled = properties.getBoolean("enable_combining", this.combiningEnabled);
        this.organizingEnabled = properties.getBoolean("enable_organizing", this.organizingEnabled);
        this.clearDescriptionOnRename = properties.getBoolean("anvil_rename_clears_description", this.clearDescriptionOnRename);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        InventoryType inventoryType = event.getInventory().getType();
        InventoryType.SlotType slotType = event.getSlotType();
        Player player = (Player)event.getWhoClicked();
        Mage mage = this.controller.getMage(player);
        if (inventoryType == InventoryType.ANVIL) {
            ItemStack cursor = event.getCursor();
            ItemStack current = event.getCurrentItem();
            Inventory anvilInventory = event.getInventory();
            InventoryAction action = event.getAction();
            ItemStack firstItem = anvilInventory.getItem(0);
            ItemStack secondItem = anvilInventory.getItem(1);
            if (action == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                if (!Wand.isWand(current)) {
                    return;
                }
                if (slotType == InventoryType.SlotType.CRAFTING) {
                    Wand wand = new Wand(this.controller, current);
                    wand.updateName(true);
                } else if (slotType == InventoryType.SlotType.RESULT) {
                    if (!this.combiningEnabled && firstItem != null && secondItem != null) {
                        event.setCancelled(true);
                        return;
                    }
                    ItemMeta meta = current.getItemMeta();
                    String newName = meta.getDisplayName();
                    Wand wand = new Wand(this.controller, current);
                    if (!wand.canUse(player)) {
                        event.setCancelled(true);
                        mage.sendMessage(this.controller.getMessages().get("wand.bound").replace("$name", wand.getOwner()));
                        return;
                    }
                    wand.setName(newName);
                    if (this.organizingEnabled) {
                        wand.organizeInventory(this.controller.getMage(player));
                    }
                    wand.tryToOwn(player);
                } else {
                    Wand wand = new Wand(this.controller, current);
                    wand.updateName(false);
                }
                return;
            }
            if (slotType == InventoryType.SlotType.CRAFTING) {
                Wand wand;
                if (Wand.isWand(cursor)) {
                    wand = new Wand(this.controller, cursor);
                    wand.updateName(false);
                }
                if (Wand.isWand(current)) {
                    wand = new Wand(this.controller, current);
                    if (this.clearDescriptionOnRename) {
                        wand.setDescription("");
                    }
                    wand.updateName(true);
                    if (event.getWhoClicked() instanceof Player) {
                        wand.tryToOwn((Player)event.getWhoClicked());
                    }
                }
                return;
            }
            if (slotType == InventoryType.SlotType.RESULT && Wand.isWand(current)) {
                if (!this.combiningEnabled && firstItem != null && secondItem != null) {
                    event.setCancelled(true);
                    return;
                }
                ItemMeta meta = current.getItemMeta();
                String newName = meta.getDisplayName();
                Wand wand = new Wand(this.controller, current);
                if (!wand.canUse(player)) {
                    event.setCancelled(true);
                    mage.sendMessage(this.controller.getMessages().get("wand.bound").replace("$name", wand.getOwner()));
                    return;
                }
                wand.setName(newName);
                if (this.organizingEnabled) {
                    wand.organizeInventory(this.controller.getMage(player));
                }
                wand.tryToOwn(player);
                return;
            }
            if (this.combiningEnabled && slotType == InventoryType.SlotType.RESULT) {
                if (Wand.isWand(firstItem) && Wand.isWand(secondItem)) {
                    Wand firstWand = new Wand(this.controller, firstItem);
                    Wand secondWand = new Wand(this.controller, secondItem);
                    if (!firstWand.isModifiable() || !secondWand.isModifiable()) {
                        mage.sendMessage("One of your wands can not be combined");
                        return;
                    }
                    if (!firstWand.canUse(player) || !secondWand.canUse(player)) {
                        mage.sendMessage("One of those wands is not bound to you");
                        return;
                    }
                    if (!firstWand.add(secondWand)) {
                        mage.sendMessage("These wands can not be combined with each other");
                        return;
                    }
                    anvilInventory.setItem(0, null);
                    anvilInventory.setItem(1, null);
                    cursor.setType(Material.AIR);
                    if (this.organizingEnabled) {
                        firstWand.organizeInventory(mage);
                    }
                    firstWand.tryToOwn(player);
                    player.getInventory().addItem(new ItemStack[]{firstWand.getItem()});
                    mage.sendMessage("Your wands have been combined!");
                } else if (this.organizingEnabled && Wand.isWand(firstItem)) {
                    Wand firstWand = new Wand(this.controller, firstItem);
                    anvilInventory.setItem(0, null);
                    anvilInventory.setItem(1, null);
                    cursor.setType(Material.AIR);
                    firstWand.organizeInventory(mage);
                    firstWand.tryToOwn(player);
                    player.getInventory().addItem(new ItemStack[]{firstWand.getItem()});
                    mage.sendMessage("Your wand has been organized!");
                }
                return;
            }
        }
    }

    public boolean isCombiningEnabled() {
        return this.combiningEnabled;
    }

    public boolean isOrganizingEnabled() {
        return this.organizingEnabled;
    }
}

