/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effect;

import com.elmakers.mine.bukkit.effect.EffectPlayer;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public abstract class EffectRepeating
extends EffectPlayer
implements Runnable {
    protected int iterations = 4;
    protected int period = 1;
    protected boolean reverse = false;
    protected Integer taskId;
    protected int iteration = 0;

    public EffectRepeating() {
    }

    public EffectRepeating(Plugin plugin) {
        super(plugin);
    }

    @Override
    public void load(Plugin plugin, ConfigurationSection configuration) {
        super.load(plugin, configuration);
        this.iterations = configuration.getInt("iterations", this.iterations);
        this.period = configuration.getInt("period", this.period);
        if (this.period < 1) {
            this.period = 1;
        }
        this.reverse = configuration.getBoolean("reverse", this.reverse);
        if (configuration.contains("duration")) {
            this.iterations = (int)Math.ceil(configuration.getDouble("duration") / (double)this.period / 50.0);
        }
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    @Override
    public void play() {
        this.stop();
        this.iteration = 0;
        this.run();
    }

    public void stop() {
        this.iteration = this.iterations;
        if (this.taskId != null) {
            Bukkit.getScheduler().cancelTask(this.taskId.intValue());
            this.taskId = null;
        }
    }

    @Override
    public void run() {
        this.taskId = null;
        this.iterate();
        if (++this.iteration < this.iterations) {
            this.schedule();
        }
    }

    protected void schedule() {
        if (this.plugin == null) {
            return;
        }
        this.taskId = Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, (Runnable)this, (long)this.period);
    }

    public float scale(float maxValue) {
        return (float)this.scale((double)maxValue);
    }

    public double scale(double maxValue) {
        int maxIteration = this.iterations - 1;
        if (maxIteration <= 0) {
            return maxValue;
        }
        double i = this.reverse ? (double)(maxIteration - this.iteration) : (double)this.iteration;
        return maxValue * (i / (double)maxIteration) * (i / (double)maxIteration);
    }

    public abstract void iterate();
}

