/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.data;

import com.elmakers.mine.bukkit.api.data.MageData;
import com.elmakers.mine.bukkit.api.data.MageDataCallback;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.data.ConfigurationMageDataStore;
import com.elmakers.mine.bukkit.data.YamlDataFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class YamlMageDataStore
extends ConfigurationMageDataStore {
    private File playerDataFolder;
    private File migratedDataFolder;

    @Override
    public void initialize(MageController controller, ConfigurationSection configuration) {
        super.initialize(controller, configuration);
        Plugin plugin = controller.getPlugin();
        String playerFolder = configuration.getString("folder", "players");
        String migrateFolder = configuration.getString("migration_folder", "migrated");
        this.playerDataFolder = new File(plugin.getDataFolder(), playerFolder);
        this.playerDataFolder.mkdirs();
        this.migratedDataFolder = new File(plugin.getDataFolder(), migrateFolder);
    }

    @Override
    public void save(MageData mage, MageDataCallback callback) {
        File playerData = new File(this.playerDataFolder, mage.getId() + ".dat");
        YamlDataFile saveFile = new YamlDataFile(this.controller.getLogger(), playerData);
        this.save(mage, (ConfigurationSection)saveFile);
        saveFile.save();
        if (callback != null) {
            callback.run(mage);
        }
    }

    @Override
    public void load(String id, MageDataCallback callback) {
        File playerFile = new File(this.playerDataFolder, id + ".dat");
        if (!playerFile.exists()) {
            callback.run(null);
        }
        YamlConfiguration saveFile = YamlConfiguration.loadConfiguration((File)playerFile);
        MageData data = this.load(id, (ConfigurationSection)saveFile);
        if (callback != null) {
            callback.run(data);
        }
    }

    @Override
    public void delete(String id) {
        File playerData = new File(this.playerDataFolder, id + ".dat");
        if (playerData.exists()) {
            playerData.delete();
        }
    }

    @Override
    public Collection<String> getAllIds() {
        File[] files;
        ArrayList<String> ids = new ArrayList<String>();
        for (File file : files = this.playerDataFolder.listFiles()) {
            String filename = file.getName();
            int extensionIndex = filename.lastIndexOf(46);
            if (extensionIndex > 0) {
                filename = filename.substring(0, filename.lastIndexOf(46));
            }
            ids.add(filename);
        }
        return ids;
    }

    @Override
    public void migrate(String id) {
        File playerData = new File(this.playerDataFolder, id + ".dat");
        if (playerData.exists()) {
            this.migratedDataFolder.mkdir();
            File migratedData = new File(this.migratedDataFolder, id + ".dat.migrated");
            playerData.renameTo(migratedData);
        }
    }
}

