/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ComplexEntityPart;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class MountAction
extends BaseSpellAction {
    private boolean eject = false;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.eject = parameters.getBoolean("eject", false);
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity targetEntity;
        LivingEntity source = context.getLivingEntity();
        if (source == null) {
            return SpellResult.LIVING_ENTITY_REQUIRED;
        }
        if (this.eject) {
            source.eject();
            return SpellResult.CAST;
        }
        Entity current = source.getVehicle();
        if (current != null) {
            current.eject();
        }
        if ((targetEntity = context.getTargetEntity()) == null) {
            return SpellResult.NO_TARGET;
        }
        if (targetEntity == source.getPassenger() || source == targetEntity.getPassenger()) {
            return SpellResult.NO_TARGET;
        }
        while (targetEntity instanceof ComplexEntityPart) {
            targetEntity = ((ComplexEntityPart)targetEntity).getParent();
        }
        targetEntity.setPassenger((Entity)source);
        return SpellResult.CAST;
    }
}

