/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.integration.VaultController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class Messages
implements com.elmakers.mine.bukkit.api.magic.Messages {
    private static String PARAMETER_PATTERN_STRING = "\\$([^ :]+)";
    private static Pattern PARAMETER_PATTERN = Pattern.compile(PARAMETER_PATTERN_STRING);
    private static Random random = new Random();
    private Map<String, String> messageMap = new HashMap<String, String>();
    private Map<String, List<String>> randomized = new HashMap<String, List<String>>();
    private ConfigurationSection configuration = null;

    public void load(ConfigurationSection messages) {
        this.configuration = messages;
        Set keys = messages.getKeys(true);
        for (String key : keys) {
            if (key.equals("randomized")) {
                ConfigurationSection randomSection = messages.getConfigurationSection(key);
                Set randomKeys = randomSection.getKeys(false);
                for (String randomKey : randomKeys) {
                    this.randomized.put(randomKey, randomSection.getStringList(randomKey));
                }
                continue;
            }
            if (!messages.isString(key)) continue;
            String value = messages.getString(key);
            value = ChatColor.translateAlternateColorCodes((char)'&', (String)StringEscapeUtils.unescapeHtml((String)value));
            this.messageMap.put(key, value);
        }
    }

    @Override
    public List<String> getAll(String path) {
        if (this.configuration == null) {
            return new ArrayList<String>();
        }
        return this.configuration.getStringList(path);
    }

    public void reset() {
        this.messageMap.clear();
    }

    @Override
    public String get(String key, String defaultValue) {
        if (this.messageMap.containsKey(key)) {
            return this.messageMap.get(key);
        }
        if (defaultValue == null) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)defaultValue);
    }

    @Override
    public String get(String key) {
        return this.get(key, key);
    }

    @Override
    public String getParameterized(String key, String paramName, String paramValue) {
        return this.get(key, key).replace(paramName, paramValue);
    }

    @Override
    public String getParameterized(String key, String paramName1, String paramValue1, String paramName2, String paramValue2) {
        return this.get(key, key).replace(paramName1, paramValue1).replace(paramName2, paramValue2);
    }

    @Override
    public String getRandomized(String key) {
        if (!this.randomized.containsKey(key)) {
            return null;
        }
        List<String> options = this.randomized.get(key);
        if (options.size() == 0) {
            return "";
        }
        return options.get(random.nextInt(options.size()));
    }

    @Override
    public String escape(String source) {
        Matcher matcher = PARAMETER_PATTERN.matcher(source);
        String result = source;
        while (matcher.find()) {
            String randomized;
            String key = matcher.group(1);
            if (key == null || (randomized = this.getRandomized(key)) == null) continue;
            result = result.replace("$" + key, randomized);
        }
        return result;
    }

    @Override
    public String describeItem(ItemStack item) {
        ItemMeta meta;
        String displayName = null;
        if (item.hasItemMeta() && ((displayName = (meta = item.getItemMeta()).getDisplayName()) == null || displayName.isEmpty()) && meta instanceof BookMeta) {
            BookMeta book = (BookMeta)meta;
            displayName = book.getTitle();
        }
        if (displayName == null || displayName.isEmpty()) {
            MaterialAndData material = new MaterialAndData(item);
            displayName = material.getName();
        }
        return displayName;
    }

    @Override
    public String describeCurrency(double amount) {
        VaultController vault = VaultController.getInstance();
        String formatted = vault.format(amount);
        if (!vault.hasEconomy()) {
            formatted = this.get("costs.currency_amount").replace("$amount", formatted);
        }
        return formatted;
    }

    @Override
    public String getCurrency() {
        VaultController vault = VaultController.getInstance();
        if (vault.hasEconomy()) {
            return vault.getCurrency();
        }
        return this.get("costs.currency");
    }

    @Override
    public String getCurrencyPlural() {
        VaultController vault = VaultController.getInstance();
        if (vault.hasEconomy()) {
            return vault.getCurrencyPlural();
        }
        return this.get("costs.currency_plural");
    }

    @Override
    public String formatList(String basePath, Collection<String> nodes, String nameKey) {
        StringBuilder buffer = new StringBuilder();
        for (String node : nodes) {
            if (buffer.length() != 0) {
                buffer.append(", ");
            }
            String path = node;
            if (basePath != null) {
                path = basePath + "." + path;
            }
            if (nameKey != null) {
                path = path + "." + nameKey;
            }
            node = this.get(path, node);
            buffer.append(node);
        }
        return buffer.toString();
    }
}

