/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.traders;

import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import net.dandielo.core.items.dItem;
import net.dandielo.core.items.serialize.Attribute;
import net.dandielo.core.items.serialize.ItemAttribute;
import org.bukkit.inventory.ItemStack;

@Attribute(name="Magic Material Brush", key="magic_brush", priority=5)
public class BrushAttr
extends ItemAttribute {
    private String brushKey;

    public BrushAttr(dItem item, String key) {
        super(item, key);
    }

    public String serialize() {
        if (this.brushKey == null) {
            this.brushKey = "";
        }
        return this.brushKey.replace(":", "|");
    }

    public boolean deserialize(String s) {
        this.brushKey = s;
        if (this.brushKey != null) {
            this.brushKey = this.brushKey.replace("|", ":");
        }
        return this.brushKey != null;
    }

    public boolean onRefactor(ItemStack itemStack) {
        this.brushKey = null;
        if (itemStack != null) {
            MagicAPI api = MagicPlugin.getAPI();
            this.brushKey = api.getBrush(itemStack);
        }
        return this.brushKey != null;
    }

    public void onAssign(ItemStack itemStack, boolean unused) {
        if (this.brushKey != null && !this.brushKey.isEmpty()) {
            InventoryUtils.setMeta(itemStack, "brush", this.brushKey);
        }
    }

    public boolean equals(ItemAttribute other) {
        if (other instanceof BrushAttr) {
            return this.brushKey.equalsIgnoreCase(((BrushAttr)other).brushKey);
        }
        return false;
    }

    public boolean similar(ItemAttribute other) {
        if (other instanceof BrushAttr) {
            return this.brushKey.equalsIgnoreCase(((BrushAttr)other).brushKey);
        }
        return false;
    }
}

