/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.block.BlockList;
import com.elmakers.mine.bukkit.api.block.BoundingBox;
import com.elmakers.mine.bukkit.api.block.CurrencyItem;
import com.elmakers.mine.bukkit.api.block.UndoQueue;
import com.elmakers.mine.bukkit.api.data.MageData;
import com.elmakers.mine.bukkit.api.data.MageDataCallback;
import com.elmakers.mine.bukkit.api.data.MageDataStore;
import com.elmakers.mine.bukkit.api.data.SpellData;
import com.elmakers.mine.bukkit.api.event.LoadEvent;
import com.elmakers.mine.bukkit.api.event.SaveEvent;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.spell.CastingCost;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.WandTemplate;
import com.elmakers.mine.bukkit.block.Automaton;
import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.block.NegatedHashSet;
import com.elmakers.mine.bukkit.block.Schematic;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.block.WildcardHashSet;
import com.elmakers.mine.bukkit.citizens.CitizensController;
import com.elmakers.mine.bukkit.data.YamlDataFile;
import com.elmakers.mine.bukkit.dynmap.DynmapController;
import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.elementals.ElementalsController;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.essentials.MagicItemDb;
import com.elmakers.mine.bukkit.essentials.Mailer;
import com.elmakers.mine.bukkit.heroes.HeroesManager;
import com.elmakers.mine.bukkit.integration.BlockPhysicsManager;
import com.elmakers.mine.bukkit.integration.LibsDisguiseManager;
import com.elmakers.mine.bukkit.integration.VaultController;
import com.elmakers.mine.bukkit.item.ItemData;
import com.elmakers.mine.bukkit.magic.AutoSaveTask;
import com.elmakers.mine.bukkit.magic.BatchUpdateTask;
import com.elmakers.mine.bukkit.magic.ChangeServerTask;
import com.elmakers.mine.bukkit.magic.ConfigurationLoadTask;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MageUpdateTask;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.magic.PhysicsHandler;
import com.elmakers.mine.bukkit.magic.UndoUpdateTask;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.magic.listener.AnvilController;
import com.elmakers.mine.bukkit.magic.listener.BlockController;
import com.elmakers.mine.bukkit.magic.listener.CraftingController;
import com.elmakers.mine.bukkit.magic.listener.EnchantingController;
import com.elmakers.mine.bukkit.magic.listener.EntityController;
import com.elmakers.mine.bukkit.magic.listener.ExplosionController;
import com.elmakers.mine.bukkit.magic.listener.HangingController;
import com.elmakers.mine.bukkit.magic.listener.InventoryController;
import com.elmakers.mine.bukkit.magic.listener.ItemController;
import com.elmakers.mine.bukkit.magic.listener.LoadSchematicTask;
import com.elmakers.mine.bukkit.magic.listener.MinigamesListener;
import com.elmakers.mine.bukkit.magic.listener.MobController;
import com.elmakers.mine.bukkit.magic.listener.PlayerController;
import com.elmakers.mine.bukkit.maps.MapController;
import com.elmakers.mine.bukkit.metrics.CategoryCastPlotter;
import com.elmakers.mine.bukkit.metrics.DeltaPlotter;
import com.elmakers.mine.bukkit.metrics.SpellCastPlotter;
import com.elmakers.mine.bukkit.plugins.magic.mcstats.Metrics;
import com.elmakers.mine.bukkit.protection.BlockBreakManager;
import com.elmakers.mine.bukkit.protection.BlockBuildManager;
import com.elmakers.mine.bukkit.protection.FactionsManager;
import com.elmakers.mine.bukkit.protection.GriefPreventionManager;
import com.elmakers.mine.bukkit.protection.LocketteManager;
import com.elmakers.mine.bukkit.protection.MultiverseManager;
import com.elmakers.mine.bukkit.protection.NCPManager;
import com.elmakers.mine.bukkit.protection.PVPManager;
import com.elmakers.mine.bukkit.protection.PreciousStonesManager;
import com.elmakers.mine.bukkit.protection.PvPManagerManager;
import com.elmakers.mine.bukkit.protection.TownyManager;
import com.elmakers.mine.bukkit.protection.WorldGuardManager;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.SpellCategory;
import com.elmakers.mine.bukkit.traders.TradersController;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.Messages;
import com.elmakers.mine.bukkit.wand.LostWand;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandManaMode;
import com.elmakers.mine.bukkit.wand.WandMode;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import com.elmakers.mine.bukkit.warp.WarpController;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public class MagicController
implements MageController {
    private static final String BUILTIN_SPELL_CLASSPATH = "com.elmakers.mine.bukkit.spell.builtin";
    private final String SPELLS_FILE = "spells";
    private final String CONFIG_FILE = "config";
    private final String WANDS_FILE = "wands";
    private final String ENCHANTING_FILE = "enchanting";
    private final String CRAFTING_FILE = "crafting";
    private final String MESSAGES_FILE = "messages";
    private final String MATERIALS_FILE = "materials";
    private final String MOBS_FILE = "mobs";
    private final String ITEMS_FILE = "items";
    private final String LOST_WANDS_FILE = "lostwands";
    private final String SPELLS_DATA_FILE = "spells";
    private final String AUTOMATA_FILE = "automata";
    private final String URL_MAPS_FILE = "imagemaps";
    private boolean disableDefaultSpells = false;
    private boolean loadDefaultSpells = true;
    private boolean loadDefaultWands = true;
    private boolean loadDefaultEnchanting = true;
    private boolean loadDefaultCrafting = true;
    private boolean loadDefaultMobs = true;
    private boolean loadDefaultItems = true;
    private MaterialAndData redstoneReplacement = new MaterialAndData(Material.OBSIDIAN);
    private Set<Material> buildingMaterials = new HashSet<Material>();
    private Set<Material> indestructibleMaterials = new HashSet<Material>();
    private Set<Material> restrictedMaterials = new HashSet<Material>();
    private Set<Material> destructibleMaterials = new HashSet<Material>();
    private Set<Material> interactibleMaterials = new HashSet<Material>();
    private Set<Material> containerMaterials = new HashSet<Material>();
    private Set<Material> wearableMaterials = new HashSet<Material>();
    private Set<Material> meleeMaterials = new HashSet<Material>();
    private Map<String, Set<Material>> materialSets = new HashMap<String, Set<Material>>();
    private boolean backupInventories = true;
    private int undoTimeWindow = 6000;
    private int undoQueueDepth = 256;
    private int pendingQueueDepth = 16;
    private int undoMaxPersistSize = 0;
    private boolean commitOnQuit = false;
    private boolean saveNonPlayerMages = false;
    private String defaultWandPath = "";
    private WandMode defaultWandMode = WandMode.INVENTORY;
    private WandMode defaultBrushMode = WandMode.CHEST;
    private boolean showMessages = true;
    private boolean showCastMessages = false;
    private String messagePrefix = "";
    private String castMessagePrefix = "";
    private boolean soundsEnabled = true;
    private String welcomeWand = "";
    private int messageThrottle = 0;
    private boolean bindingEnabled = false;
    private boolean spellDroppingEnabled = false;
    private boolean keepingEnabled = false;
    private boolean fillingEnabled = false;
    private int maxFillLevel = 0;
    private boolean essentialsSignsEnabled = false;
    private boolean dynmapUpdate = true;
    private boolean dynmapShowWands = true;
    private boolean dynmapOnlyPlayerSpells = false;
    private boolean dynmapShowSpells = true;
    private boolean createWorldsEnabled = true;
    private float maxDamagePowerMultiplier = 2.0f;
    private float maxConstructionPowerMultiplier = 5.0f;
    private float maxRadiusPowerMultiplier = 2.5f;
    private float maxRadiusPowerMultiplierMax = 4.0f;
    private float maxRangePowerMultiplier = 3.0f;
    private float maxRangePowerMultiplierMax = 5.0f;
    private float maxPower = 100.0f;
    private float maxDamageReduction = 0.2f;
    private float maxDamageReductionExplosions = 0.2f;
    private float maxDamageReductionFalling = 0.2f;
    private float maxDamageReductionFire = 0.2f;
    private float maxDamageReductionPhysical = 0.2f;
    private float maxDamageReductionProjectiles = 0.2f;
    private float maxCostReduction = 0.5f;
    private float maxCooldownReduction = 0.5f;
    private int maxMana = 1000;
    private int maxManaRegeneration = 100;
    private double worthBase = 1.0;
    private double worthSkillPoints = 1.0;
    private String skillPointIcon = null;
    private double worthXP = 1.0;
    private CurrencyItem currencyItem = null;
    private boolean spEnabled = true;
    private int spMaximum = 0;
    private float castCommandCostReduction = 1.0f;
    private float castCommandCooldownReduction = 1.0f;
    private float castCommandPowerMultiplier = 0.0f;
    private float castConsoleCostReduction = 1.0f;
    private float castConsoleCooldownReduction = 1.0f;
    private float castConsolePowerMultiplier = 0.0f;
    private float costReduction = 0.0f;
    private float cooldownReduction = 0.0f;
    private int autoUndo = 0;
    private int autoSaveTaskId = 0;
    private boolean savePlayerData = true;
    private boolean externalPlayerData = false;
    private boolean asynchronousSaving = true;
    private WarpController warpController = null;
    private final Map<String, WandTemplate> wandTemplates = new HashMap<String, WandTemplate>();
    private final Map<String, SpellTemplate> spells = new HashMap<String, SpellTemplate>();
    private final Map<String, SpellTemplate> spellAliases = new HashMap<String, SpellTemplate>();
    private final Map<String, SpellCategory> categories = new HashMap<String, SpellCategory>();
    private final Map<String, ConfigurationSection> spellConfigurations = new HashMap<String, ConfigurationSection>();
    private final Map<String, ConfigurationSection> baseSpellConfigurations = new HashMap<String, ConfigurationSection>();
    private final Map<String, com.elmakers.mine.bukkit.api.magic.Mage> mages = new HashMap<String, com.elmakers.mine.bukkit.api.magic.Mage>();
    private final Set<com.elmakers.mine.bukkit.api.magic.Mage> pendingConstruction = new HashSet<com.elmakers.mine.bukkit.api.magic.Mage>();
    private final PriorityQueue<com.elmakers.mine.bukkit.api.block.UndoList> scheduledUndo = new PriorityQueue();
    private final Map<String, WeakReference<com.elmakers.mine.bukkit.api.block.Schematic>> schematics = new HashMap<String, WeakReference<com.elmakers.mine.bukkit.api.block.Schematic>>();
    private MageDataStore mageDataStore = null;
    private MagicPlugin plugin = null;
    private final File configFolder;
    private final File dataFolder;
    private final File defaultsFolder;
    private int toggleCooldown = 1000;
    private int toggleMessageRange = 1024;
    private int mageUpdateFrequency = 20;
    private int workFrequency = 1;
    private int undoFrequency = 10;
    private int workPerUpdate = 5000;
    private int logVerbosity = 0;
    private boolean showCastHoloText = false;
    private boolean showActivateHoloText = false;
    private int castHoloTextRange = 0;
    private int activateHoloTextRange = 0;
    private boolean urlIconsEnabled = true;
    private boolean spellUpgradesEnabled = true;
    private boolean autoSpellUpgradesEnabled = true;
    private boolean bypassBuildPermissions = false;
    private boolean bypassBreakPermissions = false;
    private boolean bypassPvpPermissions = false;
    private boolean bypassFriendlyFire = false;
    private boolean allPvpRestricted = false;
    private boolean useScoreboardTeams = false;
    private boolean protectLocked = true;
    private String extraSchematicFilePath = null;
    private Mailer mailer = null;
    private Material defaultMaterial = Material.DIRT;
    private Set<EntityType> undoEntityTypes = new HashSet<EntityType>();
    private PhysicsHandler physicsHandler = null;
    private Map<String, Map<Long, Automaton>> automata = new HashMap<String, Map<Long, Automaton>>();
    private Map<String, LostWand> lostWands = new HashMap<String, LostWand>();
    private Map<String, Set<String>> lostWandChunks = new HashMap<String, Set<String>>();
    private int metricsLevel = 5;
    private Metrics metrics = null;
    private boolean hasDynmap = false;
    private boolean hasEssentials = false;
    private boolean hasCommandBook = false;
    private String exampleDefaults = null;
    private Collection<String> addExamples = null;
    private boolean initialized = false;
    private boolean loaded = false;
    private String defaultSkillIcon = "stick";
    private int skillInventoryRows = 6;
    private boolean skillsUseHeroes = true;
    private boolean skillsUsePermissions = false;
    private final Object saveLock = new Object();
    protected static Random random = new Random();
    private CraftingController crafting = null;
    private MobController mobs = null;
    private ItemController items = null;
    private EnchantingController enchanting = null;
    private AnvilController anvil = null;
    private Messages messages = null;
    private MapController maps = null;
    private TradersController tradersController = null;
    private DynmapController dynmap = null;
    private ElementalsController elementals = null;
    private CitizensController citizens = null;
    private BlockController blockController = null;
    private HangingController hangingController = null;
    private PlayerController playerController = null;
    private EntityController entityController = null;
    private InventoryController inventoryController = null;
    private ExplosionController explosionController = null;
    private boolean citizensEnabled = true;
    private boolean libsDisguiseEnabled = true;
    private boolean enableResourcePackCheck = true;
    private String defaultResourcePack = null;
    private boolean checkedResourcePack = false;
    private FactionsManager factionsManager = new FactionsManager();
    private LocketteManager locketteManager = new LocketteManager();
    private WorldGuardManager worldGuardManager = new WorldGuardManager();
    private PvPManagerManager pvpManager = new PvPManagerManager();
    private MultiverseManager multiverseManager = new MultiverseManager();
    private PreciousStonesManager preciousStonesManager = new PreciousStonesManager();
    private TownyManager townyManager = new TownyManager();
    private GriefPreventionManager griefPreventionManager = new GriefPreventionManager();
    private NCPManager ncpManager = new NCPManager();
    private HeroesManager heroesManager = null;
    private BlockPhysicsManager blockPhysicsManager = null;
    private boolean useBlockPhysics = true;
    private LibsDisguiseManager libsDisguiseManager = null;
    private List<BlockBreakManager> blockBreakManagers = new ArrayList<BlockBreakManager>();
    private List<BlockBuildManager> blockBuildManagers = new ArrayList<BlockBuildManager>();
    private List<PVPManager> pvpManagers = new ArrayList<PVPManager>();

    public MagicController(MagicPlugin plugin) {
        this.plugin = plugin;
        this.configFolder = plugin.getDataFolder();
        this.configFolder.mkdirs();
        this.dataFolder = new File(this.configFolder, "data");
        this.dataFolder.mkdirs();
        this.defaultsFolder = new File(this.configFolder, "defaults");
        this.defaultsFolder.mkdirs();
    }

    @Override
    public com.elmakers.mine.bukkit.api.magic.Mage getRegisteredMage(String mageId) {
        if (!this.loaded) {
            return null;
        }
        return this.mages.get(mageId);
    }

    @Override
    public com.elmakers.mine.bukkit.api.magic.Mage getMage(String mageId, String mageName) {
        return this.getMage(mageId, mageName, null, null);
    }

    public com.elmakers.mine.bukkit.api.magic.Mage getMage(String mageId, CommandSender commandSender, Entity entity) {
        return this.getMage(mageId, null, commandSender, entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected com.elmakers.mine.bukkit.api.magic.Mage getMage(String mageId, String mageName, CommandSender commandSender, Entity entity) {
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = null;
        if (commandSender == null && entity == null) {
            commandSender = Bukkit.getConsoleSender();
        }
        if (!this.loaded) {
            if (commandSender instanceof Player) {
                this.getLogger().warning("Player data request for " + mageId + " (" + ((Player)commandSender).getName() + ") failed, plugin not loaded yet");
            }
            return null;
        }
        if (!this.mages.containsKey(mageId)) {
            if (commandSender instanceof Player && !((Player)commandSender).isOnline() && !this.isNPC((Entity)((Player)commandSender))) {
                this.getLogger().warning("Player data for " + mageId + " (" + ((Player)commandSender).getName() + ") loaded while offline!");
                Thread.dumpStack();
            }
            final Mage mage = new Mage(mageId, this);
            this.mages.put(mageId, mage);
            mage.setName(mageName);
            mage.setCommandSender(commandSender);
            mage.setEntity(entity);
            if (commandSender instanceof Player) {
                mage.setPlayer((Player)commandSender);
            }
            boolean isPlayer = commandSender instanceof Player;
            if (this.savePlayerData && this.mageDataStore != null) {
                if (this.asynchronousSaving && isPlayer) {
                    mage.setLoading(true);
                    this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = MagicController.this.saveLock;
                            synchronized (object) {
                                MagicController.this.info("Loading mage data for " + mage.getName() + " (" + mage.getId() + ")");
                                try {
                                    MagicController.this.mageDataStore.load(mage.getId(), new MageDataCallback(){

                                        @Override
                                        public void run(MageData data) {
                                            mage.load(data);
                                            MagicController.this.info(" Finished Loading mage data for " + mage.getName() + " (" + mage.getId() + ")");
                                        }
                                    });
                                }
                                catch (Exception ex) {
                                    MagicController.this.getLogger().warning("Failed to load mage data for " + mage.getName() + " (" + mage.getId() + ")");
                                    ex.printStackTrace();
                                }
                            }
                        }
                    });
                } else {
                    if (this.saveNonPlayerMages) {
                        this.info("Loading mage data for " + mage.getName() + " (" + mage.getId() + ") synchronously");
                        Object object = this.saveLock;
                        synchronized (object) {
                            try {
                                this.mageDataStore.load(mage.getId(), new MageDataCallback(){

                                    @Override
                                    public void run(MageData data) {
                                        mage.load(data);
                                    }
                                });
                            }
                            catch (Exception ex) {
                                this.getLogger().warning("Failed to load mage data for " + mage.getName() + " (" + mage.getId() + ")");
                                ex.printStackTrace();
                            }
                        }
                    }
                    mage.load(null);
                }
            } else if (this.externalPlayerData && (isPlayer || this.saveNonPlayerMages)) {
                mage.setLoading(true);
            } else {
                mage.load(null);
            }
            apiMage = mage;
        } else {
            apiMage = this.mages.get(mageId);
            if (apiMage instanceof Mage) {
                Mage mage = (Mage)apiMage;
                mage.setName(mageName);
                mage.setCommandSender(commandSender);
                mage.setEntity(entity);
                if (commandSender instanceof Player) {
                    mage.setPlayer((Player)commandSender);
                }
            }
        }
        if (apiMage == null) {
            this.getLogger().warning("getMage returning null mage for " + entity + " and " + commandSender);
            Thread.dumpStack();
        }
        return apiMage;
    }

    public void info(String message) {
        this.info(message, 1);
    }

    public void info(String message, int verbosity) {
        if (this.logVerbosity >= verbosity) {
            this.getLogger().info(message);
        }
    }

    @Override
    public com.elmakers.mine.bukkit.api.magic.Mage getMage(Player player) {
        return this.getMage((Entity)player, (CommandSender)player);
    }

    @Override
    public com.elmakers.mine.bukkit.api.magic.Mage getMage(Entity entity) {
        Player commandSender = entity instanceof Player ? (Player)entity : null;
        return this.getMage(entity, (CommandSender)commandSender);
    }

    public com.elmakers.mine.bukkit.api.magic.Mage getRegisteredMage(Entity entity) {
        if (entity == null) {
            return null;
        }
        String id = entity.getUniqueId().toString();
        return this.mages.get(id);
    }

    protected com.elmakers.mine.bukkit.api.magic.Mage getMage(Entity entity, CommandSender commandSender) {
        if (entity == null) {
            return this.getMage(commandSender);
        }
        String id = entity.getUniqueId().toString();
        return this.getMage(id, commandSender, entity);
    }

    @Override
    public com.elmakers.mine.bukkit.api.magic.Mage getMage(CommandSender commandSender) {
        String mageId = "COMMAND";
        if (commandSender instanceof ConsoleCommandSender) {
            mageId = "CONSOLE";
        } else {
            BlockCommandSender commandBlock;
            String commandName;
            if (commandSender instanceof Player) {
                return this.getMage((Player)commandSender);
            }
            if (commandSender instanceof BlockCommandSender && (commandName = (commandBlock = (BlockCommandSender)commandSender).getName()) != null && commandName.length() > 0) {
                mageId = "COMMAND-" + commandBlock.getName();
            }
        }
        return this.getMage(mageId, commandSender, null);
    }

    public void addSpell(Spell variant) {
        SpellTemplate conflict = this.spells.get(variant.getKey());
        if (conflict != null) {
            this.getLogger().log(Level.WARNING, "Duplicate spell key: '" + conflict.getKey() + "'");
        } else {
            this.spells.put(variant.getKey(), variant);
            String alias = variant.getAlias();
            if (alias != null && alias.length() > 0) {
                this.spellAliases.put(alias, variant);
            }
        }
    }

    public float getMaxDamagePowerMultiplier() {
        return this.maxDamagePowerMultiplier;
    }

    public float getMaxConstructionPowerMultiplier() {
        return this.maxConstructionPowerMultiplier;
    }

    public float getMaxRadiusPowerMultiplier() {
        return this.maxRadiusPowerMultiplier;
    }

    public float getMaxRadiusPowerMultiplierMax() {
        return this.maxRadiusPowerMultiplierMax;
    }

    public float getMaxRangePowerMultiplier() {
        return this.maxRangePowerMultiplier;
    }

    public float getMaxRangePowerMultiplierMax() {
        return this.maxRangePowerMultiplierMax;
    }

    public int getAutoUndoInterval() {
        return this.autoUndo;
    }

    public float getMaxPower() {
        return this.maxPower;
    }

    public float getMaxDamageReduction() {
        return this.maxDamageReduction;
    }

    public float getMaxDamageReductionExplosions() {
        return this.maxDamageReductionExplosions;
    }

    public float getMaxDamageReductionFalling() {
        return this.maxDamageReductionFalling;
    }

    public float getMaxDamageReductionFire() {
        return this.maxDamageReductionFire;
    }

    public float getMaxDamageReductionPhysical() {
        return this.maxDamageReductionPhysical;
    }

    public float getMaxDamageReductionProjectiles() {
        return this.maxDamageReductionProjectiles;
    }

    public float getMaxCostReduction() {
        return this.maxCostReduction;
    }

    public float getMaxCooldownReduction() {
        return this.maxCooldownReduction;
    }

    public int getMaxMana() {
        return this.maxMana;
    }

    public int getMaxManaRegeneration() {
        return this.maxManaRegeneration;
    }

    @Override
    public double getWorthBase() {
        return this.worthBase;
    }

    @Override
    public double getWorthXP() {
        return this.worthXP;
    }

    @Override
    public double getWorthSkillPoints() {
        return this.worthSkillPoints;
    }

    @Override
    public ItemStack getWorthItem() {
        return this.currencyItem == null ? null : this.currencyItem.getItem();
    }

    @Override
    public double getWorthItemAmount() {
        return this.currencyItem == null ? null : Double.valueOf(this.currencyItem.getWorth());
    }

    @Override
    public CurrencyItem getCurrency() {
        return this.currencyItem;
    }

    public int getUndoQueueDepth() {
        return this.undoQueueDepth;
    }

    public int getPendingQueueDepth() {
        return this.pendingQueueDepth;
    }

    @Override
    public String getMessagePrefix() {
        return this.messagePrefix;
    }

    public String getCastMessagePrefix() {
        return this.castMessagePrefix;
    }

    public boolean showCastMessages() {
        return this.showCastMessages;
    }

    public boolean showMessages() {
        return this.showMessages;
    }

    @Override
    public boolean soundsEnabled() {
        return this.soundsEnabled;
    }

    public boolean fillWands() {
        return this.fillingEnabled;
    }

    @Override
    public int getMaxWandFillLevel() {
        return this.maxFillLevel;
    }

    public boolean bindWands() {
        return this.bindingEnabled;
    }

    public boolean keepWands() {
        return this.keepingEnabled;
    }

    @Override
    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    public boolean isIndestructible(Location location) {
        return this.isIndestructible(location.getBlock());
    }

    public boolean isIndestructible(Block block) {
        return this.indestructibleMaterials.contains(block.getType());
    }

    public boolean isDestructible(Block block) {
        return this.destructibleMaterials.contains(block.getType());
    }

    protected boolean isRestricted(Material material) {
        return this.restrictedMaterials.contains(material);
    }

    public boolean hasBuildPermission(Player player, Location location) {
        return this.hasBuildPermission(player, location.getBlock());
    }

    public boolean hasBuildPermission(Player player, Block block) {
        if (this.bypassBuildPermissions) {
            return true;
        }
        if (player != null && player.hasPermission("Magic.bypass_build")) {
            return true;
        }
        boolean allowed = true;
        for (BlockBuildManager manager : this.blockBuildManagers) {
            if (manager.hasBuildPermission(player, block)) continue;
            allowed = false;
            break;
        }
        return allowed;
    }

    public boolean hasBreakPermission(Player player, Block block) {
        if (this.bypassBreakPermissions) {
            return true;
        }
        if (player != null && player.hasPermission("Magic.bypass_break")) {
            return true;
        }
        boolean allowed = true;
        for (BlockBreakManager manager : this.blockBreakManagers) {
            if (manager.hasBreakPermission(player, block)) continue;
            allowed = false;
            break;
        }
        return allowed;
    }

    @Override
    public boolean isPVPAllowed(Player player, Location location) {
        if (location == null) {
            return true;
        }
        if (this.bypassPvpPermissions) {
            return true;
        }
        if (player != null && player.hasPermission("Magic.bypass_pvp")) {
            return true;
        }
        if (location == null && player != null) {
            location = player.getLocation();
        }
        boolean allowed = true;
        for (PVPManager manager : this.pvpManagers) {
            if (manager.isPVPAllowed(player, location)) continue;
            allowed = false;
            break;
        }
        return allowed;
    }

    public void clearCache() {
        this.schematics.clear();
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            if (!(mage instanceof Mage)) continue;
            ((Mage)mage).clearCache();
        }
        this.maps.clearCache();
        this.maps.resetAll();
    }

    @Override
    public com.elmakers.mine.bukkit.api.block.Schematic loadSchematic(String schematicName) {
        com.elmakers.mine.bukkit.api.block.Schematic cached;
        WeakReference<com.elmakers.mine.bukkit.api.block.Schematic> schematic;
        if (schematicName == null || schematicName.length() == 0) {
            return null;
        }
        if (this.schematics.containsKey(schematicName) && (schematic = this.schematics.get(schematicName)) != null && (cached = (com.elmakers.mine.bukkit.api.block.Schematic)schematic.get()) != null) {
            return cached;
        }
        InputStream inputSchematic = null;
        try {
            File schematicFolder;
            File extraSchematicFile = null;
            File magicSchematicFolder = new File(this.plugin.getDataFolder(), "schematics");
            if (magicSchematicFolder.exists()) {
                extraSchematicFile = new File(magicSchematicFolder, schematicName + ".schematic");
                this.info("Checking for schematic: " + extraSchematicFile.getAbsolutePath(), 2);
                if (!extraSchematicFile.exists()) {
                    extraSchematicFile = null;
                }
            }
            if (extraSchematicFile == null && this.extraSchematicFilePath != null && this.extraSchematicFilePath.length() > 0 && (schematicFolder = new File(this.configFolder, "../" + this.extraSchematicFilePath)).exists()) {
                extraSchematicFile = new File(schematicFolder, schematicName + ".schematic");
                this.info("Checking for external schematic: " + extraSchematicFile.getAbsolutePath(), 2);
            }
            if (extraSchematicFile != null && extraSchematicFile.exists()) {
                inputSchematic = new FileInputStream(extraSchematicFile);
                this.info("Loading file: " + extraSchematicFile.getAbsolutePath());
            } else {
                String fileName = schematicName + ".schematic";
                inputSchematic = this.plugin.getResource("schematics/" + fileName);
                this.info("Loading builtin schematic: " + fileName);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (inputSchematic == null) {
            this.getLogger().warning("Could not load schematic: " + schematicName);
            return null;
        }
        Schematic schematic2 = new Schematic();
        this.schematics.put(schematicName, new WeakReference<Schematic>(schematic2));
        Thread loadThread = new Thread(new LoadSchematicTask(this, inputSchematic, schematic2));
        loadThread.start();
        return schematic2;
    }

    @Override
    public Collection<String> getBrushKeys() {
        Material[] materials;
        ArrayList<String> names = new ArrayList<String>();
        for (Material material : materials = Material.values()) {
            if (!material.isBlock()) continue;
            names.add(material.name().toLowerCase());
        }
        for (String string : MaterialBrush.SPECIAL_MATERIAL_KEYS) {
            names.add(string.toLowerCase());
        }
        Collection<String> collection = this.getSchematicNames();
        for (String schematic : collection) {
            names.add("schematic:" + schematic);
        }
        return names;
    }

    public Collection<String> getSchematicNames() {
        String schematicName;
        ArrayList<String> schematicNames = new ArrayList<String>();
        try {
            CodeSource codeSource = MagicTabExecutor.class.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                URL jar = codeSource.getLocation();
                ZipInputStream zip = new ZipInputStream(jar.openStream());
                ZipEntry entry = zip.getNextEntry();
                while (entry != null) {
                    String name = entry.getName();
                    if (name.startsWith("schematics/") && name.endsWith(".schematic")) {
                        schematicName = name.replace(".schematic", "").replace("schematics/", "");
                        schematicNames.add(schematicName);
                    }
                    entry = zip.getNextEntry();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (this.extraSchematicFilePath != null && this.extraSchematicFilePath.length() > 0) {
                File schematicFolder = new File(this.configFolder, "../" + this.extraSchematicFilePath);
                for (File schematicFile : schematicFolder.listFiles()) {
                    if (!schematicFile.getName().endsWith(".schematic")) continue;
                    schematicName = schematicFile.getName().replace(".schematic", "");
                    schematicNames.add(schematicName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return schematicNames;
    }

    public void initialize() {
        this.warpController = new WarpController();
        this.crafting = new CraftingController(this);
        this.mobs = new MobController(this);
        this.items = new ItemController(this);
        this.enchanting = new EnchantingController(this);
        this.anvil = new AnvilController(this);
        this.blockController = new BlockController(this);
        this.hangingController = new HangingController(this);
        this.entityController = new EntityController(this);
        this.playerController = new PlayerController(this);
        this.inventoryController = new InventoryController(this);
        this.explosionController = new ExplosionController(this);
        this.messages = new Messages();
        File urlMapFile = this.getDataFile("imagemaps");
        File imageCache = new File(this.dataFolder, "imagemapcache");
        imageCache.mkdirs();
        this.maps = new MapController((Plugin)this.plugin, urlMapFile, imageCache);
        if (EffectPlayer.initialize((Plugin)this.plugin)) {
            this.getLogger().info("EffectLib initialized");
        } else {
            this.getLogger().warning("Failed to initialize EffectLib");
        }
        this.load();
        this.checkResourcePack((CommandSender)Bukkit.getConsoleSender());
    }

    protected void finalizeIntegration() {
        block62: {
            Plugin libsDisguisePlugin;
            Plugin minigamesPlugin;
            PluginManager pluginManager = this.plugin.getServer().getPluginManager();
            if (this.useBlockPhysics) {
                Plugin blockPhysicsPlugin = pluginManager.getPlugin("BlockPhysics");
                if (blockPhysicsPlugin == null) {
                    this.getLogger().info("BlockPhysics not found- install BlockPhysics for physics-based block effects");
                } else {
                    this.blockPhysicsManager = new BlockPhysicsManager((Plugin)this.plugin, blockPhysicsPlugin);
                    if (this.blockPhysicsManager.isEnabled()) {
                        this.getLogger().info("Integrated with BlockPhysics, some spells will now use physics-based block effects");
                    } else {
                        this.getLogger().warning("Error integrating with BlockPhysics, you may want to set 'enable_block_physics: false' in config.yml");
                    }
                }
            }
            if ((minigamesPlugin = pluginManager.getPlugin("Minigames")) != null) {
                pluginManager.registerEvents((Listener)new MinigamesListener(this), (Plugin)this.plugin);
                this.getLogger().info("Integrated with Minigames plugin, wands will deactivate before joining a minigame");
            }
            if ((libsDisguisePlugin = pluginManager.getPlugin("LibsDisguises")) == null) {
                this.getLogger().info("LibsDisguises not found");
            } else {
                this.libsDisguiseManager = new LibsDisguiseManager((Plugin)this.plugin, libsDisguisePlugin);
                if (this.libsDisguiseManager.initialize()) {
                    if (this.libsDisguiseEnabled) {
                        this.getLogger().info("Integrated with LibsDisguises, most spells can't be cast while disguised");
                    } else {
                        this.getLogger().info("LibsDisguises integration disabled");
                    }
                }
            }
            Plugin vaultPlugin = pluginManager.getPlugin("Vault");
            if (vaultPlugin == null) {
                this.getLogger().info("Vault not found, virtual economy unavailable");
            } else if (VaultController.initialize((Plugin)this.plugin, vaultPlugin)) {
                this.getLogger().info("Integrated with Vault, virtual economy and descriptive item names available");
            } else {
                this.getLogger().warning("Vault integration failed");
            }
            Plugin essentials = pluginManager.getPlugin("Essentials");
            boolean bl = this.hasEssentials = essentials != null;
            if (this.hasEssentials) {
                if (this.warpController.setEssentials(essentials)) {
                    this.getLogger().info("Integrating with Essentials for Recall warps");
                }
                try {
                    this.mailer = new Mailer(essentials);
                }
                catch (Exception ex) {
                    this.getLogger().warning("Essentials found, but failed to hook up to Mailer");
                    this.mailer = null;
                }
            }
            if (this.essentialsSignsEnabled) {
                final MagicController me = this;
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Plugin essentials = me.plugin.getServer().getPluginManager().getPlugin("Essentials");
                            if (essentials != null) {
                                Class<?> essentialsClass = essentials.getClass();
                                Field itemDbField = essentialsClass.getDeclaredField("itemDb");
                                itemDbField.setAccessible(true);
                                Object oldEntry = itemDbField.get(essentials);
                                if (oldEntry == null) {
                                    MagicController.this.getLogger().info("Essentials integration failure");
                                    return;
                                }
                                if (oldEntry instanceof MagicItemDb) {
                                    MagicController.this.getLogger().info("Essentials integration already set up, skipping");
                                    return;
                                }
                                if (!oldEntry.getClass().getName().equals("com.earth2me.essentials.ItemDb")) {
                                    MagicController.this.getLogger().info("Essentials Item DB class unexepcted: " + oldEntry.getClass().getName() + ", skipping integration");
                                    return;
                                }
                                MagicItemDb newEntry = new MagicItemDb(me, essentials);
                                itemDbField.set(essentials, (Object)newEntry);
                                Field confListField = essentialsClass.getDeclaredField("confList");
                                confListField.setAccessible(true);
                                List confList = (List)confListField.get(essentials);
                                confList.remove(oldEntry);
                                confList.add(newEntry);
                                MagicController.this.getLogger().info("Essentials found, hooked up custom item handler");
                            }
                        }
                        catch (Throwable ex) {
                            ex.printStackTrace();
                        }
                    }
                }, 5L);
            }
            this.tradersController = null;
            try {
                Plugin tradersPlugin = this.plugin.getServer().getPluginManager().getPlugin("dtlTraders");
                if (tradersPlugin != null) {
                    this.tradersController = new TradersController();
                    this.tradersController.initialize(this, tradersPlugin);
                    this.getLogger().info("dtlTraders found, integrating for selling Wands, Spells, Brushes and Upgrades");
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                this.tradersController = null;
            }
            if (this.tradersController == null) {
                this.getLogger().info("dtlTraders not found, will not integrate.");
            }
            this.hasCommandBook = false;
            try {
                Plugin commandBookPlugin = this.plugin.getServer().getPluginManager().getPlugin("CommandBook");
                if (commandBookPlugin != null) {
                    if (this.warpController.setCommandBook(commandBookPlugin)) {
                        this.getLogger().info("CommandBook found, integrating for Recall warps");
                        this.hasCommandBook = true;
                    } else {
                        this.getLogger().warning("CommandBook integration failed");
                    }
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
            this.factionsManager.initialize((Plugin)this.plugin);
            this.worldGuardManager.initialize((Plugin)this.plugin);
            this.pvpManager.initialize((Plugin)this.plugin);
            this.multiverseManager.initialize((Plugin)this.plugin);
            this.preciousStonesManager.initialize((Plugin)this.plugin);
            this.townyManager.initialize((Plugin)this.plugin);
            this.locketteManager.initialize((Plugin)this.plugin);
            this.griefPreventionManager.initialize((Plugin)this.plugin);
            this.ncpManager.initialize((Plugin)this.plugin);
            try {
                Plugin heroesPlugin = this.plugin.getServer().getPluginManager().getPlugin("Heroes");
                this.heroesManager = heroesPlugin != null ? new HeroesManager((Plugin)this.plugin, heroesPlugin) : null;
            }
            catch (Throwable ex) {
                this.plugin.getLogger().warning(ex.getMessage());
            }
            try {
                Plugin dynmapPlugin = this.plugin.getServer().getPluginManager().getPlugin("dynmap");
                this.dynmap = dynmapPlugin != null ? new DynmapController((Plugin)this.plugin, dynmapPlugin) : null;
            }
            catch (Throwable ex) {
                this.plugin.getLogger().warning(ex.getMessage());
            }
            if (this.dynmap == null) {
                this.getLogger().info("dynmap not found, not integrating.");
            } else {
                this.getLogger().info("dynmap found, integrating.");
            }
            try {
                Plugin elementalsPlugin = this.plugin.getServer().getPluginManager().getPlugin("Splateds_Elementals");
                this.elementals = elementalsPlugin != null ? new ElementalsController(elementalsPlugin) : null;
            }
            catch (Throwable ex) {
                this.plugin.getLogger().warning(ex.getMessage());
            }
            if (this.elementals != null) {
                this.getLogger().info("Elementals found, integrating.");
            }
            if (this.citizensEnabled) {
                try {
                    Plugin citizensPlugin = this.plugin.getServer().getPluginManager().getPlugin("Citizens");
                    if (citizensPlugin != null) {
                        this.citizens = new CitizensController(citizensPlugin);
                        break block62;
                    }
                    this.citizens = null;
                    this.getLogger().info("Citizens not found, Magic trait unavailable.");
                }
                catch (Throwable ex) {
                    this.citizens = null;
                    this.getLogger().warning("Error integrating with Citizens");
                    this.plugin.getLogger().warning(ex.getMessage());
                }
            } else {
                this.citizens = null;
                this.getLogger().info("Citizens integration disabled.");
            }
        }
        this.activateMetrics();
        MageUpdateTask mageTask = new MageUpdateTask(this);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)mageTask, 0L, (long)this.mageUpdateFrequency);
        BatchUpdateTask blockTask = new BatchUpdateTask(this);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)blockTask, 0L, (long)this.workFrequency);
        UndoUpdateTask undoTask = new UndoUpdateTask(this);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)undoTask, 0L, (long)this.undoFrequency);
        this.registerListeners();
        Collection allPlayers = this.plugin.getServer().getOnlinePlayers();
        for (Player player : allPlayers) {
            this.getMage(player);
        }
        this.crafting.register((Plugin)this.plugin);
        this.blockBreakManagers.clear();
        this.blockBuildManagers.clear();
        this.pvpManagers.clear();
        if (this.worldGuardManager.isEnabled()) {
            this.pvpManagers.add(this.worldGuardManager);
        }
        if (this.pvpManager.isEnabled()) {
            this.pvpManagers.add(this.pvpManager);
        }
        if (this.multiverseManager.isEnabled()) {
            this.pvpManagers.add(this.multiverseManager);
        }
        if (this.preciousStonesManager.isEnabled()) {
            this.pvpManagers.add(this.preciousStonesManager);
        }
        if (this.townyManager.isEnabled()) {
            this.pvpManagers.add(this.townyManager);
        }
        if (this.griefPreventionManager.isEnabled()) {
            this.pvpManagers.add(this.griefPreventionManager);
        }
        if (this.worldGuardManager.isEnabled()) {
            this.blockBuildManagers.add(this.worldGuardManager);
        }
        if (this.factionsManager.isEnabled()) {
            this.blockBuildManagers.add(this.factionsManager);
        }
        if (this.locketteManager.isEnabled()) {
            this.blockBuildManagers.add(this.locketteManager);
        }
        if (this.preciousStonesManager.isEnabled()) {
            this.blockBuildManagers.add(this.preciousStonesManager);
        }
        if (this.townyManager.isEnabled()) {
            this.blockBuildManagers.add(this.townyManager);
        }
        if (this.griefPreventionManager.isEnabled()) {
            this.blockBuildManagers.add(this.griefPreventionManager);
        }
        if (this.worldGuardManager.isEnabled()) {
            this.blockBreakManagers.add(this.worldGuardManager);
        }
        if (this.factionsManager.isEnabled()) {
            this.blockBreakManagers.add(this.factionsManager);
        }
        if (this.locketteManager.isEnabled()) {
            this.blockBreakManagers.add(this.locketteManager);
        }
        if (this.preciousStonesManager.isEnabled()) {
            this.blockBreakManagers.add(this.preciousStonesManager);
        }
        if (this.townyManager.isEnabled()) {
            this.blockBreakManagers.add(this.townyManager);
        }
        if (this.griefPreventionManager.isEnabled()) {
            this.blockBreakManagers.add(this.griefPreventionManager);
        }
        this.initialized = true;
    }

    protected void processUndo() {
        com.elmakers.mine.bukkit.api.block.UndoList undo;
        long now = System.currentTimeMillis();
        while (this.scheduledUndo.size() > 0 && now >= (undo = this.scheduledUndo.peek()).getScheduledTime()) {
            this.scheduledUndo.poll();
            undo.undoScheduled();
        }
    }

    protected void processPendingBatches() {
        int remainingWork = this.workPerUpdate;
        if (this.pendingConstruction.isEmpty()) {
            return;
        }
        ArrayList<com.elmakers.mine.bukkit.api.magic.Mage> pending = new ArrayList<com.elmakers.mine.bukkit.api.magic.Mage>(this.pendingConstruction);
        while (remainingWork > 0 && !pending.isEmpty()) {
            int workPerMage = Math.max(10, remainingWork / pending.size());
            Iterator iterator = pending.iterator();
            while (iterator.hasNext()) {
                com.elmakers.mine.bukkit.api.magic.Mage apiMage = (com.elmakers.mine.bukkit.api.magic.Mage)iterator.next();
                if (!(apiMage instanceof Mage)) continue;
                Mage mage = (Mage)apiMage;
                int workPerformed = mage.processPendingBatches(workPerMage);
                if (!mage.hasPendingBatches()) {
                    iterator.remove();
                    this.pendingConstruction.remove(mage);
                } else if (workPerformed < workPerMage) {
                    iterator.remove();
                }
                remainingWork -= workPerformed;
            }
        }
    }

    protected void activateMetrics() {
        final MagicController controller = this;
        this.metrics = null;
        if (this.metricsLevel > 0) {
            try {
                this.metrics = new Metrics((Plugin)this.plugin);
                if (this.metricsLevel > 1) {
                    Metrics.Graph integrationGraph = this.metrics.createGraph("Plugin Integration");
                    integrationGraph.addPlotter(new Metrics.Plotter("Essentials"){

                        @Override
                        public int getValue() {
                            return controller.hasEssentials ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("Dynmap"){

                        @Override
                        public int getValue() {
                            return controller.hasDynmap ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("Factions"){

                        @Override
                        public int getValue() {
                            return controller.factionsManager.isEnabled() ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("WorldGuard"){

                        @Override
                        public int getValue() {
                            return controller.worldGuardManager.isEnabled() ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("Elementals"){

                        @Override
                        public int getValue() {
                            return controller.elementalsEnabled() ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("Citizens"){

                        @Override
                        public int getValue() {
                            return controller.citizens != null ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("Traders"){

                        @Override
                        public int getValue() {
                            return controller.tradersController != null ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("CommandBook"){

                        @Override
                        public int getValue() {
                            return controller.hasCommandBook ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("PvpManager"){

                        @Override
                        public int getValue() {
                            return controller.pvpManager.isEnabled() ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("Multiverse-Core"){

                        @Override
                        public int getValue() {
                            return controller.multiverseManager.isEnabled() ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("Towny"){

                        @Override
                        public int getValue() {
                            return controller.townyManager.isEnabled() ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("GriefPrevention"){

                        @Override
                        public int getValue() {
                            return controller.griefPreventionManager.isEnabled() ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("PreciousStones"){

                        @Override
                        public int getValue() {
                            return controller.preciousStonesManager.isEnabled() ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("Lockette"){

                        @Override
                        public int getValue() {
                            return controller.locketteManager.isEnabled() ? 1 : 0;
                        }
                    });
                    integrationGraph.addPlotter(new Metrics.Plotter("NoCheatPlus"){

                        @Override
                        public int getValue() {
                            return controller.ncpManager.isEnabled() ? 1 : 0;
                        }
                    });
                    Metrics.Graph featuresGraph = this.metrics.createGraph("Features Enabled");
                    featuresGraph.addPlotter(new Metrics.Plotter("Crafting"){

                        @Override
                        public int getValue() {
                            return controller.crafting.isEnabled() ? 1 : 0;
                        }
                    });
                    featuresGraph.addPlotter(new Metrics.Plotter("Enchanting"){

                        @Override
                        public int getValue() {
                            return controller.enchanting.isEnabled() ? 1 : 0;
                        }
                    });
                    featuresGraph.addPlotter(new Metrics.Plotter("Anvil Combining"){

                        @Override
                        public int getValue() {
                            return controller.anvil.isCombiningEnabled() ? 1 : 0;
                        }
                    });
                    featuresGraph.addPlotter(new Metrics.Plotter("Anvil Organizing"){

                        @Override
                        public int getValue() {
                            return controller.anvil.isOrganizingEnabled() ? 1 : 0;
                        }
                    });
                    featuresGraph.addPlotter(new Metrics.Plotter("Anvil Binding"){

                        @Override
                        public int getValue() {
                            return controller.bindingEnabled ? 1 : 0;
                        }
                    });
                    featuresGraph.addPlotter(new Metrics.Plotter("Anvil Keeping"){

                        @Override
                        public int getValue() {
                            return controller.keepingEnabled ? 1 : 0;
                        }
                    });
                }
                if (this.metricsLevel > 2) {
                    Metrics.Graph categoryGraph = this.metrics.createGraph("Casts by Category");
                    for (SpellCategory category : this.categories.values()) {
                        categoryGraph.addPlotter(new DeltaPlotter(new CategoryCastPlotter(category)));
                    }
                    Metrics.Graph totalCategoryGraph = this.metrics.createGraph("Total Casts by Category");
                    for (SpellCategory category : this.categories.values()) {
                        totalCategoryGraph.addPlotter(new CategoryCastPlotter(category));
                    }
                }
                if (this.metricsLevel > 3) {
                    Metrics.Graph spellGraph = this.metrics.createGraph("Casts");
                    for (SpellTemplate spell : this.spells.values()) {
                        if (!(spell instanceof Spell)) continue;
                        spellGraph.addPlotter(new DeltaPlotter(new SpellCastPlotter((Spell)spell)));
                    }
                    Metrics.Graph totalCastGraph = this.metrics.createGraph("Total Casts");
                    for (SpellTemplate spell : this.spells.values()) {
                        if (!(spell instanceof Spell)) continue;
                        totalCastGraph.addPlotter(new SpellCastPlotter((Spell)spell));
                    }
                }
                this.metrics.start();
                this.plugin.getLogger().info("Activated MCStats");
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("Failed to load MCStats: " + ex.getMessage());
            }
        }
    }

    protected void registerListeners() {
        PluginManager pm = this.plugin.getServer().getPluginManager();
        pm.registerEvents((Listener)this.crafting, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.mobs, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.items, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.enchanting, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.anvil, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.blockController, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.hangingController, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.entityController, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.playerController, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.inventoryController, (Plugin)this.plugin);
        pm.registerEvents((Listener)this.explosionController, (Plugin)this.plugin);
    }

    public Collection<com.elmakers.mine.bukkit.api.magic.Mage> getPending() {
        return this.pendingConstruction;
    }

    public Collection<com.elmakers.mine.bukkit.api.block.UndoList> getPendingUndo() {
        return this.scheduledUndo;
    }

    protected void addPending(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.pendingConstruction.add(mage);
    }

    public boolean removeMarker(String id, String group) {
        boolean removed = false;
        if (this.dynmap != null && this.dynmapShowWands) {
            return this.dynmap.removeMarker(id, group);
        }
        return removed;
    }

    public boolean addMarker(String id, String group, String title, String world, int x, int y, int z, String description) {
        boolean created = false;
        if (this.dynmap != null && this.dynmapShowWands) {
            created = this.dynmap.addMarker(id, group, title, world, x, y, z, description);
        }
        return created;
    }

    @Override
    public File getConfigFolder() {
        return this.configFolder;
    }

    protected File getDataFile(String fileName) {
        return new File(this.dataFolder, fileName + ".yml");
    }

    protected ConfigurationSection loadDataFile(String fileName) {
        File dataFile = this.getDataFile(fileName);
        if (!dataFile.exists()) {
            return null;
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)dataFile);
        return configuration;
    }

    protected YamlDataFile createDataFile(String fileName) {
        File dataFile = new File(this.dataFolder, fileName + ".yml");
        YamlDataFile configuration = new YamlDataFile(this.getLogger(), dataFile);
        return configuration;
    }

    protected ConfigurationSection loadConfigFile(String fileName, boolean loadDefaults) throws IOException, InvalidConfigurationException {
        return this.loadConfigFile(fileName, loadDefaults, false);
    }

    protected void enableAll(ConfigurationSection rootSection) {
        Set keys = rootSection.getKeys(false);
        for (String key : keys) {
            ConfigurationSection section = rootSection.getConfigurationSection(key);
            if (section.isSet("enabled")) continue;
            section.set("enabled", (Object)true);
        }
    }

    protected ConfigurationSection loadConfigFile(String fileName, boolean loadDefaults, boolean disableDefaults) throws IOException, InvalidConfigurationException {
        return this.loadConfigFile(fileName, loadDefaults, disableDefaults, false);
    }

    protected ConfigurationSection loadConfigFile(String fileName, boolean loadDefaults, boolean disableDefaults, boolean filesReplace) throws IOException, InvalidConfigurationException {
        InputStream input;
        String configFileName = fileName + ".yml";
        File configFile = new File(this.configFolder, configFileName);
        if (!configFile.exists()) {
            this.getLogger().info("Saving template " + configFileName + ", edit to customize configuration.");
            this.plugin.saveResource(configFileName, false);
        }
        boolean usingExample = this.exampleDefaults != null && this.exampleDefaults.length() > 0;
        String examplesFileName = usingExample ? "examples/" + this.exampleDefaults + "/" + fileName + ".yml" : null;
        String defaultsFileName = "defaults/" + fileName + ".defaults.yml";
        this.plugin.saveResource(defaultsFileName, true);
        this.getLogger().info("Loading " + configFile.getName());
        ConfigurationSection overrides = CompatibilityUtils.loadConfiguration(configFile);
        MemoryConfiguration config = new MemoryConfiguration();
        if (loadDefaults) {
            this.getLogger().info(" Based on defaults " + defaultsFileName);
            ConfigurationSection defaultConfig = CompatibilityUtils.loadConfiguration(this.plugin.getResource(defaultsFileName));
            if (disableDefaults) {
                Set keys = defaultConfig.getKeys(false);
                for (String key : keys) {
                    defaultConfig.getConfigurationSection(key).set("enabled", (Object)false);
                }
                this.enableAll(overrides);
            }
            config = ConfigurationUtils.addConfigurations((ConfigurationSection)config, defaultConfig);
        }
        if (usingExample && (input = this.plugin.getResource(examplesFileName)) != null) {
            ConfigurationSection exampleConfig = CompatibilityUtils.loadConfiguration(input);
            if (disableDefaults) {
                this.enableAll(exampleConfig);
            }
            config = ConfigurationUtils.addConfigurations((ConfigurationSection)config, exampleConfig);
            this.getLogger().info(" Using " + examplesFileName);
        }
        if (this.addExamples != null && this.addExamples.size() > 0) {
            for (String example : this.addExamples) {
                examplesFileName = "examples/" + example + "/" + fileName + ".yml";
                this.plugin.saveResource(examplesFileName, true);
                InputStream input2 = this.plugin.getResource(examplesFileName);
                if (input2 == null) continue;
                ConfigurationSection exampleConfig = CompatibilityUtils.loadConfiguration(input2);
                if (disableDefaults) {
                    this.enableAll(exampleConfig);
                }
                config = ConfigurationUtils.addConfigurations((ConfigurationSection)config, exampleConfig);
                this.getLogger().info(" Added " + examplesFileName);
            }
        }
        config = ConfigurationUtils.addConfigurations((ConfigurationSection)config, overrides);
        File configSubFolder = new File(this.configFolder, fileName);
        if (configSubFolder.exists()) {
            File[] files;
            for (File file : files = configSubFolder.listFiles()) {
                if (file.getName().startsWith(".")) continue;
                ConfigurationSection fileOverrides = CompatibilityUtils.loadConfiguration(file);
                this.getLogger().info("  Loading " + file.getName());
                config = filesReplace ? ConfigurationUtils.replaceConfigurations((ConfigurationSection)config, fileOverrides) : ConfigurationUtils.addConfigurations((ConfigurationSection)config, fileOverrides);
            }
        }
        return config;
    }

    protected ConfigurationSection loadExamples(ConfigurationSection properties) throws InvalidConfigurationException, IOException {
        this.logVerbosity = properties.getInt("log_verbosity", 0);
        this.exampleDefaults = properties.getString("example", this.exampleDefaults);
        this.addExamples = properties.getStringList("add_examples");
        if ((this.exampleDefaults != null && this.exampleDefaults.length() > 0 || this.addExamples != null && this.addExamples.size() > 0) && this.exampleDefaults != null && this.exampleDefaults.length() > 0) {
            this.getLogger().info("Overriding configuration with example: " + this.exampleDefaults);
            properties = this.loadConfigFile("config", true);
        }
        this.loadDefaultSpells = properties.getBoolean("load_default_spells", this.loadDefaultSpells);
        this.disableDefaultSpells = properties.getBoolean("disable_default_spells", this.disableDefaultSpells);
        this.loadDefaultWands = properties.getBoolean("load_default_wands", this.loadDefaultWands);
        this.loadDefaultCrafting = properties.getBoolean("load_default_crafting", this.loadDefaultCrafting);
        this.loadDefaultEnchanting = properties.getBoolean("load_default_enchanting", this.loadDefaultEnchanting);
        this.loadDefaultMobs = properties.getBoolean("load_default_mobs", this.loadDefaultMobs);
        this.loadDefaultItems = properties.getBoolean("load_default_items", this.loadDefaultItems);
        return properties;
    }

    protected ConfigurationSection loadMainConfiguration() throws InvalidConfigurationException, IOException {
        return this.loadConfigFile("config", true);
    }

    protected ConfigurationSection loadMessageConfiguration() throws InvalidConfigurationException, IOException {
        return this.loadConfigFile("messages", true);
    }

    protected ConfigurationSection loadMaterialsConfiguration() throws InvalidConfigurationException, IOException {
        return this.loadConfigFile("materials", true);
    }

    protected ConfigurationSection loadWandConfiguration() throws InvalidConfigurationException, IOException {
        return this.loadConfigFile("wands", this.loadDefaultWands, false, true);
    }

    protected ConfigurationSection loadEnchantingConfiguration() throws InvalidConfigurationException, IOException {
        return this.loadConfigFile("enchanting", this.loadDefaultEnchanting);
    }

    protected ConfigurationSection loadCraftingConfiguration() throws InvalidConfigurationException, IOException {
        return this.loadConfigFile("crafting", this.loadDefaultCrafting);
    }

    protected ConfigurationSection loadMobsConfiguration() throws InvalidConfigurationException, IOException {
        return this.loadConfigFile("mobs", this.loadDefaultItems);
    }

    protected ConfigurationSection loadItemsConfiguration() throws InvalidConfigurationException, IOException {
        return this.loadConfigFile("items", this.loadDefaultMobs);
    }

    protected Map<String, ConfigurationSection> loadAndMapSpells() throws InvalidConfigurationException, IOException {
        HashMap<String, ConfigurationSection> spellConfigs = new HashMap<String, ConfigurationSection>();
        ConfigurationSection config = this.loadConfigFile("spells", this.loadDefaultSpells, this.disableDefaultSpells);
        if (config == null) {
            return spellConfigs;
        }
        this.spellConfigurations.clear();
        this.baseSpellConfigurations.clear();
        Set spellKeys = config.getKeys(false);
        for (String key : spellKeys) {
            ConfigurationSection spellNode;
            if (key.equals("default") || (spellNode = this.getSpellConfig(key, config)) == null || !spellNode.getBoolean("enabled", true)) continue;
            if (this.allPvpRestricted) {
                spellNode.set("pvp_restricted", (Object)true);
            }
            spellConfigs.put(key, spellNode);
        }
        return spellConfigs;
    }

    protected void finalizeLoad(ConfigurationLoadTask loader, CommandSender sender) {
        if (!loader.success) {
            if (sender != null) {
                sender.sendMessage(ChatColor.RED + "An error occurred reloading configurations, please check server logs!");
            }
            if (!this.loaded) {
                this.getLogger().warning("*** An error occurred while loading configurations ***");
                this.getLogger().warning("***         Magic is temporarily disabled          ***");
                this.getLogger().warning("***   Please check the errors above, fix configs   ***");
                this.getLogger().warning("***    And '/magic load' or restart the server     ***");
            }
            return;
        }
        this.schematics.clear();
        this.loadProperties(loader.configuration);
        if (this.addExamples != null && this.addExamples.size() > 0) {
            this.getLogger().info("Adding examples: " + StringUtils.join(this.addExamples, (String)","));
        }
        this.messages.load(loader.messages);
        this.loadMaterials(loader.materials);
        this.mobs.load(loader.mobs);
        this.getLogger().info("Loaded " + this.mobs.getCount() + " mob templates");
        this.items.load(loader.items);
        this.getLogger().info("Loaded " + this.items.getCount() + " items");
        this.loadSpells(loader.spells);
        this.getLogger().info("Loaded " + this.spells.size() + " spells");
        this.enchanting.load(loader.enchanting);
        this.getLogger().info("Loaded " + this.enchanting.getCount() + " enchanting paths");
        this.loadWandTemplates(loader.wands);
        this.getLogger().info("Loaded " + this.getWandTemplates().size() + " wands");
        this.crafting.load(loader.crafting);
        this.getLogger().info("Loaded " + this.crafting.getCount() + " crafting recipes");
        if (!this.initialized) {
            this.finalizeIntegration();
        }
        LoadEvent loadEvent = new LoadEvent();
        Bukkit.getPluginManager().callEvent((Event)loadEvent);
        this.loaded = true;
        if (sender != null) {
            sender.sendMessage(ChatColor.AQUA + "Configuration reloaded.");
        }
    }

    public void loadConfiguration() {
        this.loadConfiguration(null);
    }

    public void loadConfiguration(CommandSender sender) {
        ConfigurationLoadTask loadTask = new ConfigurationLoadTask(this, sender);
        if (this.initialized) {
            this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)loadTask);
        } else {
            loadTask.runNow();
        }
    }

    protected void loadSpellData() {
        try {
            ConfigurationSection configNode = this.loadDataFile("spells");
            if (configNode == null) {
                return;
            }
            Set keys = configNode.getKeys(false);
            for (String key : keys) {
                SpellTemplate spell = this.getSpellTemplate(key);
                if (spell == null || !(spell instanceof MageSpell)) continue;
                SpellData templateData = new SpellData(key);
                ConfigurationSection spellSection = configNode.getConfigurationSection(key);
                templateData.setCastCount(spellSection.getLong("cast_count"));
                templateData.setLastCast(spellSection.getLong("last_cast"));
                ((MageSpell)spell).load(templateData);
            }
        }
        catch (Exception ex) {
            this.getLogger().warning("Failed to load spell metrics");
        }
    }

    public void load() {
        this.loadConfiguration();
        this.loadSpellData();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                MagicController.this.getLogger().info("Loading lost wand data");
                MagicController.this.loadLostWands();
                MagicController.this.getLogger().info("Loading automata data");
                MagicController.this.loadAutomata();
                try {
                    MagicController.this.maps.resetAll();
                    MagicController.this.maps.loadConfiguration();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                MagicController.this.getLogger().info("Finished loading data.");
            }
        }, 10L);
    }

    protected void loadLostWands() {
        try {
            ConfigurationSection lostWandConfiguration = this.loadDataFile("lostwands");
            if (lostWandConfiguration != null) {
                Set wandIds = lostWandConfiguration.getKeys(false);
                for (String wandId : wandIds) {
                    if (wandId == null || wandId.length() == 0) continue;
                    LostWand lostWand = new LostWand(wandId, lostWandConfiguration.getConfigurationSection(wandId));
                    if (!lostWand.isValid()) {
                        this.getLogger().info("Skipped invalid entry in lostwands.yml file, entry will be deleted. The wand is really lost now!");
                        continue;
                    }
                    this.addLostWand(lostWand);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.getLogger().info("Loaded " + this.lostWands.size() + " lost wands");
    }

    protected void saveSpellData(Collection<YamlDataFile> stores) {
        String lastKey = "";
        try {
            YamlDataFile spellsDataFile = this.createDataFile("spells");
            for (SpellTemplate spell : this.spells.values()) {
                lastKey = spell.getKey();
                ConfigurationSection spellNode = spellsDataFile.createSection(lastKey);
                if (spellNode == null) {
                    this.getLogger().warning("Error saving spell data for " + lastKey);
                    continue;
                }
                if (spell == null || !(spell instanceof MageSpell)) continue;
                SpellData templateData = new SpellData(lastKey);
                ((MageSpell)spell).save(templateData);
                spellNode.set("cast_count", (Object)templateData.getCastCount());
                spellNode.set("last_cast", (Object)templateData.getLastCast());
            }
            stores.add(spellsDataFile);
        }
        catch (Throwable ex) {
            this.getLogger().warning("Error saving spell data for " + lastKey);
            ex.printStackTrace();
        }
    }

    protected void saveLostWands(Collection<YamlDataFile> stores) {
        String lastKey = "";
        try {
            YamlDataFile lostWandsConfiguration = this.createDataFile("lostwands");
            for (Map.Entry<String, LostWand> wandEntry : this.lostWands.entrySet()) {
                lastKey = wandEntry.getKey();
                if (lastKey == null || lastKey.length() == 0) continue;
                ConfigurationSection wandNode = lostWandsConfiguration.createSection(lastKey);
                if (wandNode == null) {
                    this.getLogger().warning("Error saving lost wand data for " + lastKey);
                    continue;
                }
                if (!wandEntry.getValue().isValid()) {
                    this.getLogger().warning("Invalid lost and data for " + lastKey);
                    continue;
                }
                wandEntry.getValue().save(wandNode);
            }
            stores.add(lostWandsConfiguration);
        }
        catch (Throwable ex) {
            this.getLogger().warning("Error saving lost wand data for " + lastKey);
            ex.printStackTrace();
        }
    }

    protected void loadAutomata() {
        int automataCount = 0;
        try {
            ConfigurationSection toggleBlockData = this.loadDataFile("automata");
            if (toggleBlockData != null) {
                Set chunkIds = toggleBlockData.getKeys(false);
                for (String chunkId : chunkIds) {
                    ConfigurationSection chunkNode = toggleBlockData.getConfigurationSection(chunkId);
                    HashMap<Long, Automaton> restoreChunk = new HashMap<Long, Automaton>();
                    this.automata.put(chunkId, restoreChunk);
                    Set blockIds = chunkNode.getKeys(false);
                    for (String blockId : blockIds) {
                        ConfigurationSection toggleConfig = chunkNode.getConfigurationSection(blockId);
                        Automaton toggle = new Automaton(toggleConfig);
                        restoreChunk.put(toggle.getId(), toggle);
                        ++automataCount;
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.getLogger().info("Loaded " + automataCount + " automata");
    }

    protected void saveAutomata(Collection<YamlDataFile> stores) {
        try {
            YamlDataFile automataData = this.createDataFile("automata");
            for (Map.Entry<String, Map<Long, Automaton>> toggleEntry : this.automata.entrySet()) {
                Collection<Automaton> blocks = toggleEntry.getValue().values();
                if (blocks.size() <= 0) continue;
                ConfigurationSection chunkNode = automataData.createSection(toggleEntry.getKey());
                for (Automaton block : blocks) {
                    ConfigurationSection node = chunkNode.createSection(Long.toString(block.getId()));
                    block.save(node);
                }
            }
            stores.add(automataData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected String getChunkKey(Block block) {
        return this.getChunkKey(block.getLocation());
    }

    protected String getChunkKey(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return null;
        }
        return world.getName() + "|" + (location.getBlockX() >> 4) + "," + (location.getBlockZ() >> 4);
    }

    protected String getChunkKey(Chunk chunk) {
        return chunk.getWorld().getName() + "|" + chunk.getX() + "," + chunk.getZ();
    }

    public boolean addLostWand(LostWand lostWand) {
        this.lostWands.put(lostWand.getId(), lostWand);
        try {
            String chunkKey = this.getChunkKey(lostWand.getLocation());
            if (chunkKey == null) {
                return false;
            }
            Set<String> chunkWands = this.lostWandChunks.get(chunkKey);
            if (chunkWands == null) {
                chunkWands = new HashSet<String>();
                this.lostWandChunks.put(chunkKey, chunkWands);
            }
            chunkWands.add(lostWand.getId());
            if (this.dynmapShowWands) {
                this.addLostWandMarker(lostWand);
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Error loading lost wand id " + lostWand.getId() + " - is it in an unloaded world?", ex);
        }
        return true;
    }

    public boolean addLostWand(Wand wand, Location dropLocation) {
        this.addLostWand(wand.makeLost(dropLocation));
        return true;
    }

    public boolean removeLostWand(String wandId) {
        if (wandId == null || wandId.length() == 0 || !this.lostWands.containsKey(wandId)) {
            return false;
        }
        LostWand lostWand = this.lostWands.get(wandId);
        this.lostWands.remove(wandId);
        String chunkKey = this.getChunkKey(lostWand.getLocation());
        if (chunkKey == null) {
            return false;
        }
        Set<String> chunkWands = this.lostWandChunks.get(chunkKey);
        if (chunkWands != null) {
            chunkWands.remove(wandId);
            if (chunkWands.size() == 0) {
                this.lostWandChunks.remove(chunkKey);
            }
        }
        if (this.dynmapShowWands && this.removeMarker("wand-" + wandId, "Wands")) {
            this.info("Wand removed from map");
        }
        return true;
    }

    public WandMode getDefaultWandMode() {
        return this.defaultWandMode;
    }

    public WandMode getDefaultBrushMode() {
        return this.defaultBrushMode;
    }

    public String getDefaultWandPath() {
        return this.defaultWandPath;
    }

    protected void savePlayerData(Collection<MageData> stores) {
        try {
            for (Map.Entry<String, com.elmakers.mine.bukkit.api.magic.Mage> mageEntry : this.mages.entrySet()) {
                com.elmakers.mine.bukkit.api.magic.Mage mage = mageEntry.getValue();
                if (!mage.isPlayer() && !this.saveNonPlayerMages) continue;
                if (!mage.isLoading()) {
                    MageData mageData = new MageData(mage.getId());
                    if (!mage.save(mageData)) continue;
                    stores.add(mageData);
                    continue;
                }
                this.getLogger().info("Skipping save of mage, already loading: " + mage.getName());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void save() {
        this.save(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(boolean asynchronous) {
        if (!this.initialized) {
            return;
        }
        this.maps.save(asynchronous);
        final ArrayList<YamlDataFile> saveData = new ArrayList<YamlDataFile>();
        final ArrayList<MageData> saveMages = new ArrayList<MageData>();
        if (this.savePlayerData && this.mageDataStore != null) {
            this.savePlayerData(saveMages);
        }
        this.info("Saving " + saveMages.size() + " players");
        this.saveSpellData(saveData);
        this.saveLostWands(saveData);
        this.saveAutomata(saveData);
        if (this.mageDataStore != null) {
            if (asynchronous) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = MagicController.this.saveLock;
                        synchronized (object) {
                            for (MageData mageData : saveMages) {
                                MagicController.this.mageDataStore.save(mageData, null);
                            }
                            for (YamlDataFile config : saveData) {
                                config.save();
                            }
                            MagicController.this.info("Finished saving");
                        }
                    }
                });
            } else {
                Object object = this.saveLock;
                synchronized (object) {
                    for (MageData mageData : saveMages) {
                        this.mageDataStore.save(mageData, null);
                    }
                    for (YamlDataFile config : saveData) {
                        config.save();
                    }
                    this.info("Finished saving");
                }
            }
        }
        SaveEvent saveEvent = new SaveEvent(asynchronous);
        Bukkit.getPluginManager().callEvent((Event)saveEvent);
    }

    protected ConfigurationSection getSpellConfig(String key, ConfigurationSection config) {
        return this.getSpellConfig(key, config, true);
    }

    protected ConfigurationSection getSpellConfig(String key, ConfigurationSection config, boolean addInherited) {
        boolean processInherited;
        ConfigurationSection built;
        if (addInherited ? (built = this.spellConfigurations.get(key)) != null : (built = this.baseSpellConfigurations.get(key)) != null) {
            return built;
        }
        ConfigurationSection spellNode = config.getConfigurationSection(key);
        if (spellNode == null) {
            this.getLogger().warning("Spell " + key + " not known");
            return null;
        }
        spellNode = ConfigurationUtils.addConfigurations((ConfigurationSection)new MemoryConfiguration(), spellNode);
        SpellKey spellKey = new SpellKey(key);
        String inheritFrom = spellNode.getString("inherit");
        if (inheritFrom != null && inheritFrom.equalsIgnoreCase("false")) {
            inheritFrom = null;
        }
        String upgradeInheritsFrom = null;
        if (spellKey.isVariant()) {
            if (!this.spellUpgradesEnabled) {
                return null;
            }
            int level = spellKey.getLevel();
            upgradeInheritsFrom = spellKey.getBaseKey();
            if (level != 2) {
                upgradeInheritsFrom = upgradeInheritsFrom + "|" + (level - 1);
            }
        }
        boolean bl = processInherited = addInherited && inheritFrom != null;
        if (processInherited || upgradeInheritsFrom != null) {
            if (processInherited && key.equals(inheritFrom)) {
                this.getLogger().warning("Spell " + key + " inherits from itself");
            } else if (processInherited) {
                ConfigurationSection inheritConfig = this.getSpellConfig(inheritFrom, config);
                if (inheritConfig != null) {
                    spellNode = ConfigurationUtils.addConfigurations(spellNode, inheritConfig, false);
                } else {
                    this.getLogger().warning("Spell " + key + " inherits from unknown ancestor " + inheritFrom);
                }
            }
            if (upgradeInheritsFrom != null) {
                if (config.contains(upgradeInheritsFrom)) {
                    ConfigurationSection baseInheritConfig = this.getSpellConfig(upgradeInheritsFrom, config, inheritFrom == null);
                    spellNode = ConfigurationUtils.addConfigurations(spellNode, baseInheritConfig, inheritFrom != null);
                } else {
                    this.getLogger().warning("Spell upgrade " + key + " inherits from unknown level " + upgradeInheritsFrom);
                }
            }
        } else {
            ConfigurationSection defaults = config.getConfigurationSection("default");
            if (defaults != null) {
                spellNode = ConfigurationUtils.addConfigurations(spellNode, defaults, false);
            }
        }
        if (addInherited) {
            this.spellConfigurations.put(key, spellNode);
        } else {
            this.baseSpellConfigurations.put(key, spellNode);
        }
        return spellNode;
    }

    protected void loadSpells(Map<String, ConfigurationSection> spellConfigs) {
        if (spellConfigs == null) {
            return;
        }
        this.spells.clear();
        this.spellAliases.clear();
        this.categories.clear();
        for (Map.Entry<String, ConfigurationSection> entry : spellConfigs.entrySet()) {
            String icon;
            ConfigurationSection spellNode;
            String key = entry.getKey();
            if (key.equals("default") || (spellNode = entry.getValue()) == null) continue;
            Spell newSpell = null;
            try {
                newSpell = MagicController.loadSpell(key, spellNode, this);
            }
            catch (Exception ex) {
                newSpell = null;
                ex.printStackTrace();
            }
            if (newSpell == null) {
                this.getLogger().warning("Magic: Error loading spell " + key);
                continue;
            }
            if (!newSpell.hasIcon() && (icon = spellNode.getString("icon")) != null && !icon.isEmpty()) {
                this.getLogger().info("Couldn't load spell icon '" + icon + "' for spell: " + newSpell.getKey());
            }
            this.addSpell(newSpell);
        }
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            if (!(mage instanceof Mage)) continue;
            ((Mage)mage).loadSpells(this.spellConfigurations);
        }
    }

    public static Spell loadSpell(String name, ConfigurationSection node, MageController controller) {
        Object newObject;
        String className = node.getString("class");
        if (className == null || className.equalsIgnoreCase("action") || className.equalsIgnoreCase("actionspell")) {
            className = "com.elmakers.mine.bukkit.spell.ActionSpell";
        } else if (className.indexOf(46) <= 0) {
            className = "com.elmakers.mine.bukkit.spell.builtin." + className;
        }
        Class<?> spellClass = null;
        try {
            spellClass = Class.forName(className);
        }
        catch (Throwable ex) {
            controller.getLogger().warning("Error loading spell: " + className);
            return null;
        }
        try {
            newObject = spellClass.newInstance();
        }
        catch (Throwable ex) {
            controller.getLogger().warning("Error loading spell: " + className);
            return null;
        }
        if (newObject == null || !(newObject instanceof MageSpell)) {
            controller.getLogger().warning("Error loading spell: " + className + ", does it implement MageSpell?");
            return null;
        }
        MageSpell newSpell = (MageSpell)newObject;
        newSpell.initialize(controller);
        newSpell.loadTemplate(name, node);
        com.elmakers.mine.bukkit.api.spell.SpellCategory category = newSpell.getCategory();
        if (category instanceof SpellCategory) {
            ((SpellCategory)category).addSpellTemplate(newSpell);
        }
        return newSpell;
    }

    @Override
    public String getReflectiveMaterials(com.elmakers.mine.bukkit.api.magic.Mage mage, Location location) {
        return this.worldGuardManager.getReflective(mage.getPlayer(), location);
    }

    @Override
    public String getDestructibleMaterials(com.elmakers.mine.bukkit.api.magic.Mage mage, Location location) {
        return this.worldGuardManager.getDestructible(mage.getPlayer(), location);
    }

    @Override
    public Set<String> getSpellOverrides(com.elmakers.mine.bukkit.api.magic.Mage mage, Location location) {
        return this.worldGuardManager.getSpellOverrides(mage.getPlayer(), location);
    }

    protected void loadMaterials(ConfigurationSection materialNode) {
        if (materialNode == null) {
            return;
        }
        Set keys = materialNode.getKeys(false);
        for (String key : keys) {
            this.materialSets.put(key, ConfigurationUtils.getMaterials(materialNode, key));
        }
        if (this.materialSets.containsKey("building")) {
            this.buildingMaterials = this.materialSets.get("building");
        }
        if (this.materialSets.containsKey("indestructible")) {
            this.indestructibleMaterials = this.materialSets.get("indestructible");
        }
        if (this.materialSets.containsKey("restricted")) {
            this.restrictedMaterials = this.materialSets.get("restricted");
        }
        if (this.materialSets.containsKey("destructible")) {
            this.destructibleMaterials = this.materialSets.get("destructible");
        }
        if (this.materialSets.containsKey("interactible")) {
            this.interactibleMaterials = this.materialSets.get("interactible");
        }
        if (this.materialSets.containsKey("containers")) {
            this.containerMaterials = this.materialSets.get("containers");
        }
        if (this.materialSets.containsKey("wearable")) {
            this.wearableMaterials = this.materialSets.get("wearable");
        }
        if (this.materialSets.containsKey("melee")) {
            this.meleeMaterials = this.materialSets.get("melee");
        }
        if (this.materialSets.containsKey("attachable")) {
            UndoList.attachables = this.materialSets.get("attachable");
        }
        if (this.materialSets.containsKey("attachable_wall")) {
            UndoList.attachablesWall = this.materialSets.get("attachable_wall");
        }
        if (this.materialSets.containsKey("attachable_double")) {
            UndoList.attachablesDouble = this.materialSets.get("attachable_double");
        }
    }

    protected void loadProperties(ConfigurationSection properties) {
        block42: {
            if (properties == null) {
                return;
            }
            if (this.autoSaveTaskId > 0) {
                Bukkit.getScheduler().cancelTask(this.autoSaveTaskId);
                this.autoSaveTaskId = 0;
            }
            EffectPlayer.debugEffects(properties.getBoolean("debug_effects", false));
            CompatibilityUtils.USE_MAGIC_DAMAGE = properties.getBoolean("use_magic_damage", CompatibilityUtils.USE_MAGIC_DAMAGE);
            EffectPlayer.setParticleRange(properties.getInt("particle_range", EffectPlayer.PARTICLE_RANGE));
            this.enableResourcePackCheck = properties.getBoolean("enable_resource_pack_check", true);
            this.defaultResourcePack = properties.getString("default_resource_pack", null);
            this.showCastHoloText = properties.getBoolean("show_cast_holotext", this.showCastHoloText);
            this.showActivateHoloText = properties.getBoolean("show_activate_holotext", this.showCastHoloText);
            this.castHoloTextRange = properties.getInt("cast_holotext_range", this.castHoloTextRange);
            this.activateHoloTextRange = properties.getInt("activate_holotext_range", this.activateHoloTextRange);
            this.urlIconsEnabled = properties.getBoolean("url_icons_enabled", this.urlIconsEnabled);
            this.spellUpgradesEnabled = properties.getBoolean("enable_spell_upgrades", this.spellUpgradesEnabled);
            this.autoSpellUpgradesEnabled = properties.getBoolean("enable_automatic_spell_upgrades", this.autoSpellUpgradesEnabled);
            this.undoQueueDepth = properties.getInt("undo_depth", this.undoQueueDepth);
            this.workPerUpdate = properties.getInt("work_per_update", this.workPerUpdate);
            this.workFrequency = properties.getInt("work_frequency", this.workFrequency);
            this.mageUpdateFrequency = properties.getInt("mage_update_frequency", this.mageUpdateFrequency);
            this.undoFrequency = properties.getInt("undo_frequency", this.undoFrequency);
            this.pendingQueueDepth = properties.getInt("pending_depth", this.pendingQueueDepth);
            this.undoMaxPersistSize = properties.getInt("undo_max_persist_size", this.undoMaxPersistSize);
            this.commitOnQuit = properties.getBoolean("commit_on_quit", this.commitOnQuit);
            this.saveNonPlayerMages = properties.getBoolean("save_non_player_mages", this.saveNonPlayerMages);
            this.defaultWandPath = properties.getString("default_wand_path", "");
            Wand.DEFAULT_WAND_TEMPLATE = properties.getString("default_wand", "");
            this.defaultWandMode = Wand.parseWandMode(properties.getString("default_wand_mode", ""), this.defaultWandMode);
            this.defaultBrushMode = Wand.parseWandMode(properties.getString("default_brush_mode", ""), this.defaultBrushMode);
            this.backupInventories = properties.getBoolean("backup_player_inventory", true);
            Wand.brushSelectSpell = properties.getString("brush_select_spell", Wand.brushSelectSpell);
            this.showMessages = properties.getBoolean("show_messages", this.showMessages);
            this.showCastMessages = properties.getBoolean("show_cast_messages", this.showCastMessages);
            this.messageThrottle = properties.getInt("message_throttle", 0);
            this.soundsEnabled = properties.getBoolean("sounds", this.soundsEnabled);
            this.fillingEnabled = properties.getBoolean("fill_wands", this.fillingEnabled);
            this.maxFillLevel = properties.getInt("fill_wand_level", this.maxFillLevel);
            this.welcomeWand = properties.getString("welcome_wand", "");
            this.maxDamagePowerMultiplier = (float)properties.getDouble("max_power_damage_multiplier", (double)this.maxDamagePowerMultiplier);
            this.maxConstructionPowerMultiplier = (float)properties.getDouble("max_power_construction_multiplier", (double)this.maxConstructionPowerMultiplier);
            this.maxRangePowerMultiplier = (float)properties.getDouble("max_power_range_multiplier", (double)this.maxRangePowerMultiplier);
            this.maxRangePowerMultiplierMax = (float)properties.getDouble("max_power_range_multiplier_max", (double)this.maxRangePowerMultiplierMax);
            this.maxRadiusPowerMultiplier = (float)properties.getDouble("max_power_radius_multiplier", (double)this.maxRadiusPowerMultiplier);
            this.maxRadiusPowerMultiplierMax = (float)properties.getDouble("max_power_radius_multiplier_max", (double)this.maxRadiusPowerMultiplierMax);
            this.maxPower = (float)properties.getDouble("max_power", (double)this.maxPower);
            this.maxDamageReduction = (float)properties.getDouble("max_damage_reduction", (double)this.maxDamageReduction);
            this.maxDamageReductionExplosions = (float)properties.getDouble("max_damage_reduction_explosions", (double)this.maxDamageReductionExplosions);
            this.maxDamageReductionFalling = (float)properties.getDouble("max_damage_reduction_falling", (double)this.maxDamageReductionFalling);
            this.maxDamageReductionFire = (float)properties.getDouble("max_damage_reduction_fire", (double)this.maxDamageReductionFire);
            this.maxDamageReductionPhysical = (float)properties.getDouble("max_damage_reduction_physical", (double)this.maxDamageReductionPhysical);
            this.maxDamageReductionProjectiles = (float)properties.getDouble("max_damage_reduction_projectiles", (double)this.maxDamageReductionProjectiles);
            this.maxCostReduction = (float)properties.getDouble("max_cost_reduction", (double)this.maxCostReduction);
            this.maxCooldownReduction = (float)properties.getDouble("max_cooldown_reduction", (double)this.maxCooldownReduction);
            this.maxMana = properties.getInt("max_mana", this.maxMana);
            this.maxManaRegeneration = properties.getInt("max_mana_regeneration", this.maxManaRegeneration);
            this.worthSkillPoints = properties.getDouble("worth_sp", 1.0);
            this.skillPointIcon = properties.getString("sp_item_icon_url");
            this.worthBase = properties.getDouble("worth_base", 1.0);
            this.worthXP = properties.getDouble("worth_xp", 1.0);
            ConfigurationSection currencies = properties.getConfigurationSection("currency");
            if (currencies != null) {
                Set worthItemKeys = currencies.getKeys(true);
                for (String worthItemKey : worthItemKeys) {
                    MaterialAndData material = new MaterialAndData(worthItemKey);
                    if (material == null) {
                        this.getLogger().warning("Invalid item in worth_items: " + worthItemKey);
                        continue;
                    }
                    ConfigurationSection currencyConfig = currencies.getConfigurationSection(worthItemKey);
                    ItemStack worthItemType = material.getItemStack(1);
                    double worthItemAmount = currencyConfig.getDouble("worth");
                    String worthItemName = currencyConfig.getString("name");
                    String worthItemNamePlural = currencyConfig.getString("name_plural");
                    this.currencyItem = new CurrencyItem(worthItemType, worthItemAmount, worthItemName, worthItemNamePlural);
                    break;
                }
            } else {
                this.currencyItem = null;
            }
            CompatibilityUtils.setHitboxScale(properties.getDouble("hitbox_scale", 1.0));
            CompatibilityUtils.setHitboxScaleY(properties.getDouble("hitbox_scale_y", 1.0));
            CompatibilityUtils.setHitboxSneakScaleY(properties.getDouble("hitbox_sneaking_scale_y", 0.75));
            if (properties.contains("hitboxes")) {
                CompatibilityUtils.configureHitboxes(properties.getConfigurationSection("hitboxes"));
            }
            if (properties.contains("head_sizes")) {
                CompatibilityUtils.configureHeadSizes(properties.getConfigurationSection("head_sizes"));
            }
            if (properties.contains("max_height")) {
                CompatibilityUtils.configureMaxHeights(properties.getConfigurationSection("max_height"));
            }
            this.costReduction = (float)properties.getDouble("cost_reduction", (double)this.costReduction);
            this.cooldownReduction = (float)properties.getDouble("cooldown_reduction", (double)this.cooldownReduction);
            this.castCommandCostReduction = (float)properties.getDouble("cast_command_cost_reduction", (double)this.castCommandCostReduction);
            this.castCommandCooldownReduction = (float)properties.getDouble("cast_command_cooldown_reduction", (double)this.castCommandCooldownReduction);
            this.castCommandPowerMultiplier = (float)properties.getDouble("cast_command_power_multiplier", (double)this.castCommandPowerMultiplier);
            this.castConsoleCostReduction = (float)properties.getDouble("cast_console_cost_reduction", (double)this.castConsoleCostReduction);
            this.castConsoleCooldownReduction = (float)properties.getDouble("cast_console_cooldown_reduction", (double)this.castConsoleCooldownReduction);
            this.castConsolePowerMultiplier = (float)properties.getDouble("cast_console_power_multiplier", (double)this.castConsolePowerMultiplier);
            this.autoUndo = properties.getInt("auto_undo", this.autoUndo);
            this.spellDroppingEnabled = properties.getBoolean("allow_spell_dropping", this.spellDroppingEnabled);
            this.bindingEnabled = properties.getBoolean("enable_binding", this.bindingEnabled);
            this.keepingEnabled = properties.getBoolean("enable_keeping", this.keepingEnabled);
            this.essentialsSignsEnabled = properties.getBoolean("enable_essentials_signs", this.essentialsSignsEnabled);
            this.citizensEnabled = properties.getBoolean("enable_citizens", this.citizensEnabled);
            this.dynmapShowWands = properties.getBoolean("dynmap_show_wands", this.dynmapShowWands);
            this.dynmapShowSpells = properties.getBoolean("dynmap_show_spells", this.dynmapShowSpells);
            this.dynmapOnlyPlayerSpells = properties.getBoolean("dynmap_only_player_spells", this.dynmapOnlyPlayerSpells);
            this.dynmapUpdate = properties.getBoolean("dynmap_update", this.dynmapUpdate);
            this.protectLocked = properties.getBoolean("protected_locked", this.protectLocked);
            this.bypassBuildPermissions = properties.getBoolean("bypass_build", this.bypassBuildPermissions);
            this.bypassBreakPermissions = properties.getBoolean("bypass_break", this.bypassBreakPermissions);
            this.bypassPvpPermissions = properties.getBoolean("bypass_pvp", this.bypassPvpPermissions);
            this.bypassFriendlyFire = properties.getBoolean("bypass_friendly_fire", this.bypassFriendlyFire);
            this.allPvpRestricted = properties.getBoolean("pvp_restricted", this.allPvpRestricted);
            this.useScoreboardTeams = properties.getBoolean("use_scoreboard_teams", this.useScoreboardTeams);
            this.extraSchematicFilePath = properties.getString("schematic_files", this.extraSchematicFilePath);
            this.createWorldsEnabled = properties.getBoolean("enable_world_creation", this.createWorldsEnabled);
            this.defaultSkillIcon = properties.getString("default_skill_icon", this.defaultSkillIcon);
            this.skillInventoryRows = properties.getInt("skill_inventory_max_rows", this.skillInventoryRows);
            BaseSpell.MAX_LORE_LENGTH = properties.getInt("lore_wrap_limit", BaseSpell.MAX_LORE_LENGTH);
            this.libsDisguiseEnabled = properties.getBoolean("enable_libsdisguises", this.libsDisguiseEnabled);
            this.skillsUseHeroes = properties.getBoolean("skills_use_heroes", this.skillsUseHeroes);
            this.skillsUsePermissions = properties.getBoolean("skills_use_permissions", this.skillsUsePermissions);
            this.messagePrefix = properties.getString("message_prefix", this.messagePrefix);
            this.castMessagePrefix = properties.getString("cast_message_prefix", this.castMessagePrefix);
            this.redstoneReplacement = ConfigurationUtils.getMaterialAndData(properties, "redstone_replacement", this.redstoneReplacement);
            this.messagePrefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.messagePrefix);
            this.castMessagePrefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.castMessagePrefix);
            this.worldGuardManager.setEnabled(properties.getBoolean("region_manager_enabled", this.worldGuardManager.isEnabled()));
            this.factionsManager.setEnabled(properties.getBoolean("factions_enabled", this.factionsManager.isEnabled()));
            this.pvpManager.setEnabled(properties.getBoolean("pvp_manager_enabled", this.pvpManager.isEnabled()));
            this.multiverseManager.setEnabled(properties.getBoolean("multiverse_enabled", this.multiverseManager.isEnabled()));
            this.preciousStonesManager.setEnabled(properties.getBoolean("precious_stones_enabled", this.preciousStonesManager.isEnabled()));
            this.preciousStonesManager.setOverride(properties.getBoolean("precious_stones_override", true));
            this.townyManager.setEnabled(properties.getBoolean("towny_enabled", this.townyManager.isEnabled()));
            this.townyManager.setWildernessBypass(properties.getBoolean("towny_wilderness_bypass", true));
            this.locketteManager.setEnabled(properties.getBoolean("lockette_enabled", this.locketteManager.isEnabled()));
            this.griefPreventionManager.setEnabled(properties.getBoolean("grief_prevention_enabled", this.griefPreventionManager.isEnabled()));
            this.ncpManager.setEnabled(properties.getBoolean("ncp_enabled", false));
            this.metricsLevel = properties.getInt("metrics_level", this.metricsLevel);
            Wand.regenWhileInactive = properties.getBoolean("regenerate_while_inactive", Wand.regenWhileInactive);
            if (properties.contains("mana_display")) {
                String manaDisplay = properties.getString("mana_display");
                if (manaDisplay.equalsIgnoreCase("bar") || manaDisplay.equalsIgnoreCase("hybrid")) {
                    Wand.manaMode = WandManaMode.BAR;
                } else if (manaDisplay.equalsIgnoreCase("number")) {
                    Wand.manaMode = WandManaMode.NUMBER;
                } else if (manaDisplay.equalsIgnoreCase("durability")) {
                    Wand.manaMode = WandManaMode.DURABILITY;
                } else if (manaDisplay.equalsIgnoreCase("glow")) {
                    Wand.manaMode = WandManaMode.GLOW;
                } else if (manaDisplay.equalsIgnoreCase("none")) {
                    Wand.manaMode = WandManaMode.NONE;
                }
            }
            if (properties.contains("sp_display")) {
                String spDisplay = properties.getString("sp_display");
                Wand.spMode = spDisplay.equalsIgnoreCase("number") ? WandManaMode.NUMBER : WandManaMode.NONE;
            }
            this.spEnabled = properties.getBoolean("sp_enabled", true);
            this.spMaximum = properties.getInt("sp_max", 9999);
            this.undoEntityTypes.clear();
            if (properties.contains("entity_undo_types")) {
                this.undoEntityTypes = new HashSet<EntityType>();
                List<String> typeStrings = ConfigurationUtils.getStringList(properties, "entity_undo_types");
                for (String typeString : typeStrings) {
                    try {
                        this.undoEntityTypes.add(EntityType.valueOf((String)typeString.toUpperCase()));
                    }
                    catch (Exception ex) {
                        this.getLogger().warning("Unknown entity type: " + typeString);
                    }
                }
            }
            Wand.DefaultUpgradeMaterial = ConfigurationUtils.getMaterial(properties, "wand_upgrade_item", Wand.DefaultUpgradeMaterial);
            Wand.SpellGlow = properties.getBoolean("spell_glow", Wand.SpellGlow);
            Wand.LiveHotbar = properties.getBoolean("live_hotbar", Wand.LiveHotbar);
            Wand.LiveHotbarCooldown = properties.getBoolean("live_hotbar_cooldown", Wand.LiveHotbar);
            Wand.BrushGlow = properties.getBoolean("brush_glow", Wand.BrushGlow);
            Wand.BrushItemGlow = properties.getBoolean("brush_item_glow", Wand.BrushItemGlow);
            Wand.WAND_KEY = properties.getString("wand_key", "wand");
            Wand.WAND_SELF_DESTRUCT_KEY = properties.getString("wand_self_destruct_key", "");
            if (Wand.WAND_SELF_DESTRUCT_KEY.isEmpty()) {
                Wand.WAND_SELF_DESTRUCT_KEY = null;
            }
            Wand.HIDE_FLAGS = (byte)properties.getInt("wand_hide_flags", (int)Wand.HIDE_FLAGS);
            Wand.Unbreakable = properties.getBoolean("wand_unbreakable", Wand.Unbreakable);
            Wand.Undroppable = properties.getBoolean("wand_undroppable", Wand.Undroppable);
            MaterialBrush.CopyMaterial = ConfigurationUtils.getMaterial(properties, "copy_item", MaterialBrush.CopyMaterial);
            MaterialBrush.EraseMaterial = ConfigurationUtils.getMaterial(properties, "erase_item", MaterialBrush.EraseMaterial);
            MaterialBrush.CloneMaterial = ConfigurationUtils.getMaterial(properties, "clone_item", MaterialBrush.CloneMaterial);
            MaterialBrush.ReplicateMaterial = ConfigurationUtils.getMaterial(properties, "replicate_item", MaterialBrush.ReplicateMaterial);
            MaterialBrush.SchematicMaterial = ConfigurationUtils.getMaterial(properties, "schematic_item", MaterialBrush.SchematicMaterial);
            MaterialBrush.MapMaterial = ConfigurationUtils.getMaterial(properties, "map_item", MaterialBrush.MapMaterial);
            MaterialBrush.DefaultBrushMaterial = ConfigurationUtils.getMaterial(properties, "default_brush_item", MaterialBrush.DefaultBrushMaterial);
            MaterialBrush.configureReplacements(properties.getConfigurationSection("brush_replacements"));
            MaterialBrush.CopyCustomIcon = properties.getString("copy_icon_url", MaterialBrush.CopyCustomIcon);
            MaterialBrush.EraseCustomIcon = properties.getString("erase_icon_url", MaterialBrush.EraseCustomIcon);
            MaterialBrush.CloneCustomIcon = properties.getString("clone_icon_url", MaterialBrush.CloneCustomIcon);
            MaterialBrush.ReplicateCustomIcon = properties.getString("replicate_icon_url", MaterialBrush.ReplicateCustomIcon);
            MaterialBrush.SchematicCustomIcon = properties.getString("schematic_icon_url", MaterialBrush.SchematicCustomIcon);
            MaterialBrush.MapCustomIcon = properties.getString("map_icon_url", MaterialBrush.MapCustomIcon);
            MaterialBrush.DefaultBrushCustomIcon = properties.getString("default_brush_icon_url", MaterialBrush.DefaultBrushCustomIcon);
            Mage.WAND_LOCATION_OFFSET = properties.getDouble("wand_location_offset", Mage.WAND_LOCATION_OFFSET);
            Mage.WAND_LOCATION_VERTICAL_OFFSET = properties.getDouble("wand_location_offset_vertical", Mage.WAND_LOCATION_OFFSET);
            Mage.JUMP_EFFECT_FLIGHT_EXEMPTION_DURATION = properties.getInt("jump_exemption", 0);
            Wand.inventoryOpenSound = ConfigurationUtils.toSoundEffect(properties.getString("wand_inventory_open_sound"));
            Wand.inventoryCloseSound = ConfigurationUtils.toSoundEffect(properties.getString("wand_inventory_close_sound"));
            Wand.inventoryCycleSound = ConfigurationUtils.toSoundEffect(properties.getString("wand_inventory_cycle_sound"));
            Wand.noActionSound = ConfigurationUtils.toSoundEffect(properties.getString("wand_no_action_sound"));
            if (this.blockPhysicsManager != null) {
                this.blockPhysicsManager.setVelocityScale(properties.getDouble("block_physics_velocity_scale", 1.0));
            }
            this.explosionController.loadProperties(properties);
            this.blockController.setUndoOnWorldSave(properties.getBoolean("undo_on_world_save", false));
            this.blockController.setCreativeBreakFrequency(properties.getInt("prevent_creative_breaking", 0));
            this.inventoryController.setEnableItemHacks(properties.getBoolean("enable_custom_item_hacks", false));
            this.inventoryController.setDropChangesPages(properties.getBoolean("drop_changes_pages", false));
            this.entityController.setPreventMeleeDamage(properties.getBoolean("prevent_melee_damage", false));
            this.entityController.setMeleeDamageReduction(properties.getDouble("melee_damage_reduction", 0.0));
            this.entityController.setKeepWandsOnDeath(properties.getBoolean("keep_wands_on_death", true));
            this.entityController.setPreventWandMeleeDamage(properties.getBoolean("prevent_wand_melee_damage", true));
            this.entityController.setAgeDroppedItems(properties.getInt("age_dropped_items", 0));
            this.playerController.loadProperties(properties);
            EffectPlayer.SOUNDS_ENABLED = this.soundsEnabled;
            AutoSaveTask autoSave = new AutoSaveTask(this);
            int autoSaveIntervalTicks = properties.getInt("auto_save", 0) * 20 / 1000;
            if (autoSaveIntervalTicks > 1) {
                this.autoSaveTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)autoSave, (long)autoSaveIntervalTicks, (long)autoSaveIntervalTicks);
            }
            this.savePlayerData = properties.getBoolean("save_player_data", true);
            this.externalPlayerData = properties.getBoolean("external_player_data", false);
            if (this.externalPlayerData) {
                this.getLogger().info("Magic is expecting player data to be loaded from an external source");
            } else if (!this.savePlayerData) {
                this.getLogger().info("Magic player data saving is disabled");
            }
            this.asynchronousSaving = properties.getBoolean("save_player_data_asynchronously", true);
            ConfigurationSection mageDataStore = properties.getConfigurationSection("player_data_store");
            String dataStoreClassName = mageDataStore.getString("class");
            if (mageDataStore != null) {
                try {
                    Class<?> dataStoreClass = Class.forName(dataStoreClassName);
                    Object dataStore = dataStoreClass.newInstance();
                    if (dataStore == null || !(dataStore instanceof MageDataStore)) {
                        this.getLogger().log(Level.WARNING, "Invalid player_data_store class " + dataStoreClassName + ", does it implement MageDataStore? Player data saving is disabled!");
                        this.mageDataStore = null;
                        break block42;
                    }
                    this.mageDataStore = (MageDataStore)dataStore;
                    this.mageDataStore.initialize(this, mageDataStore);
                }
                catch (Exception ex) {
                    this.getLogger().log(Level.WARNING, "Failed to create player_data_store class from " + dataStoreClassName + " player data saving is disabled!");
                    this.mageDataStore = null;
                }
            } else {
                this.getLogger().log(Level.WARNING, "Missing player_data_store configuration, player data saving disabled!");
                this.mageDataStore = null;
            }
        }
        this.useBlockPhysics = properties.getBoolean("enable_block_physics", true);
        Wand.DefaultWandMaterial = ConfigurationUtils.getMaterial(properties, "wand_item", Wand.DefaultWandMaterial);
        Wand.EnchantableWandMaterial = ConfigurationUtils.getMaterial(properties, "wand_item_enchantable", Wand.EnchantableWandMaterial);
        this.enchanting.setEnabled(properties.getBoolean("enable_enchanting", this.enchanting.isEnabled()));
        if (this.enchanting.isEnabled()) {
            this.getLogger().info("Wand enchanting is enabled");
        }
        this.crafting.setEnabled(properties.getBoolean("enable_crafting", this.crafting.isEnabled()));
        if (this.crafting.isEnabled()) {
            this.getLogger().info("Wand crafting is enabled");
        }
        this.anvil.load(properties);
        if (this.anvil.isCombiningEnabled()) {
            this.getLogger().info("Wand anvil combining is enabled");
        }
        if (this.anvil.isOrganizingEnabled()) {
            this.getLogger().info("Wand anvil organizing is enabled");
        }
        if (this.isUrlIconsEnabled()) {
            this.getLogger().info("Skin-based custom icons enabled");
        } else {
            this.getLogger().info("Skin-based custom icons disabled");
        }
    }

    protected void clear() {
        this.initialized = false;
        ArrayList<com.elmakers.mine.bukkit.api.magic.Mage> saveMages = new ArrayList<com.elmakers.mine.bukkit.api.magic.Mage>(this.mages.values());
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : saveMages) {
            this.playerQuit(mage);
        }
        this.mages.clear();
        this.pendingConstruction.clear();
        this.spells.clear();
    }

    protected void unregisterPhysicsHandler(Listener listener) {
        BlockPhysicsEvent.getHandlerList().unregister(listener);
        this.physicsHandler = null;
    }

    @Override
    public void scheduleUndo(com.elmakers.mine.bukkit.api.block.UndoList undoList) {
        this.scheduledUndo.add(undoList);
    }

    @Override
    public void cancelScheduledUndo(com.elmakers.mine.bukkit.api.block.UndoList undoList) {
        this.scheduledUndo.remove(undoList);
    }

    public boolean hasWandPermission(Player player) {
        return this.hasPermission(player, "Magic.wand.use", true);
    }

    public boolean hasWandPermission(Player player, Wand wand) {
        if (player.hasPermission("Magic.bypass")) {
            return true;
        }
        if (wand.isSuperPowered() && !player.hasPermission("Magic.wand.use.powered")) {
            return false;
        }
        if (wand.isSuperProtected() && !player.hasPermission("Magic.wand.use.protected")) {
            return false;
        }
        Location location = player.getLocation();
        Boolean override = this.worldGuardManager.getWandPermission(player, wand, location);
        return override == null || override != false;
    }

    @Override
    public boolean hasCastPermission(CommandSender sender, SpellTemplate spell) {
        if (sender == null) {
            return true;
        }
        if (sender instanceof Player && ((Player)sender).hasPermission("Magic.bypass")) {
            return true;
        }
        return this.hasPermission(sender, spell.getPermissionNode(), true);
    }

    @Override
    public Boolean getRegionCastPermission(Player player, SpellTemplate spell, Location location) {
        if (player != null && player.hasPermission("Magic.bypass")) {
            return true;
        }
        return this.worldGuardManager.getCastPermission(player, spell, location);
    }

    @Override
    public Boolean getPersonalCastPermission(Player player, SpellTemplate spell, Location location) {
        if (player != null && player.hasPermission("Magic.bypass")) {
            return true;
        }
        return this.preciousStonesManager.getCastPermission(player, spell, location);
    }

    public boolean hasPermission(Player player, String pNode, boolean defaultValue) {
        boolean isSet;
        String parentNode;
        boolean isParentSet;
        if (player == null) {
            return true;
        }
        if (pNode.contains(".") && (isParentSet = player.isPermissionSet(parentNode = pNode.substring(0, pNode.lastIndexOf(46) + 1) + "*"))) {
            defaultValue = player.hasPermission(parentNode);
        }
        return (isSet = player.isPermissionSet(pNode)) ? player.hasPermission(pNode) : defaultValue;
    }

    public boolean hasPermission(Player player, String pNode) {
        return this.hasPermission(player, pNode, false);
    }

    public boolean hasPermission(CommandSender sender, String pNode) {
        if (!(sender instanceof Player)) {
            return true;
        }
        return this.hasPermission((Player)sender, pNode, false);
    }

    @Override
    public boolean hasPermission(CommandSender sender, String pNode, boolean defaultValue) {
        if (!(sender instanceof Player)) {
            return true;
        }
        return this.hasPermission((Player)sender, pNode, defaultValue);
    }

    public com.elmakers.mine.bukkit.api.block.UndoList getPendingUndo(Location location) {
        return UndoList.getUndoList(location);
    }

    public void registerFallingBlock(Entity fallingBlock, Block block) {
        com.elmakers.mine.bukkit.api.block.UndoList undoList = this.getPendingUndo(fallingBlock.getLocation());
        if (undoList != null) {
            undoList.fall(fallingBlock, block);
        }
    }

    public com.elmakers.mine.bukkit.api.block.UndoList getEntityUndo(Entity entity) {
        Projectile projectile;
        ProjectileSource source;
        com.elmakers.mine.bukkit.api.block.UndoList blockList = null;
        if (entity == null) {
            return null;
        }
        com.elmakers.mine.bukkit.api.magic.Mage mage = this.getRegisteredMage(entity);
        if (mage == null && entity instanceof Projectile && (source = (projectile = (Projectile)entity).getShooter()) instanceof LivingEntity) {
            entity = (LivingEntity)source;
            mage = this.getRegisteredMage(entity);
        }
        if (mage != null) {
            com.elmakers.mine.bukkit.api.block.UndoList undoList;
            if (mage instanceof Mage && (undoList = mage.getLastUndoList()) != null) {
                long now = System.currentTimeMillis();
                if (undoList.getModifiedTime() > now - (long)this.undoTimeWindow) {
                    blockList = undoList;
                }
            }
        } else {
            blockList = UndoList.getUndoList(entity);
        }
        return blockList;
    }

    public void onPlayerActivateIcon(com.elmakers.mine.bukkit.api.magic.Mage mage, Wand activeWand, ItemStack icon) {
        if (icon != null && icon.getType() != Material.AIR) {
            MageSpell spell = mage.getSpell(Wand.getSpell(icon));
            if (spell != null) {
                if (spell.isQuickCast() && !activeWand.isQuickCastDisabled()) {
                    activeWand.cast(spell);
                } else {
                    activeWand.setActiveSpell(spell.getKey());
                }
            } else if (Wand.isBrush(icon)) {
                activeWand.setActiveBrush(icon);
            }
        } else {
            activeWand.setActiveSpell("");
        }
        mage.getPlayer().updateInventory();
    }

    @Override
    public void giveItemToPlayer(Player player, ItemStack itemStack) {
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        mage.giveItem(itemStack);
    }

    @Override
    public boolean commitOnQuit() {
        return this.commitOnQuit;
    }

    public void playerQuit(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.playerQuit(mage, null);
    }

    protected void mageQuit(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.mageQuit(mage, null);
    }

    protected void mageQuit(com.elmakers.mine.bukkit.api.magic.Mage mage, MageDataCallback callback) {
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.getActiveWand();
        boolean isOpen = wand != null && wand.isInventoryOpen();
        mage.deactivate();
        mage.undoScheduled();
        if (!this.externalPlayerData || !mage.isPlayer()) {
            this.forgetMage(mage);
        }
        if (!mage.isLoading() && (mage.isPlayer() || this.saveNonPlayerMages) && this.loaded) {
            this.saveMage(mage, this.initialized, callback, isOpen);
        } else if (callback != null) {
            callback.run(null);
        }
    }

    protected void playerQuit(com.elmakers.mine.bukkit.api.magic.Mage mage, MageDataCallback callback) {
        this.maps.resend(mage.getName());
        this.mageQuit(mage, callback);
    }

    @Override
    public void removeMage(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.mages.remove(mage.getId());
    }

    @Override
    public void removeMage(String id) {
        this.mages.remove(id);
    }

    public void saveMage(com.elmakers.mine.bukkit.api.magic.Mage mage, boolean asynchronous) {
        this.saveMage(mage, asynchronous, null);
    }

    public void saveMage(com.elmakers.mine.bukkit.api.magic.Mage mage, boolean asynchronous, MageDataCallback callback) {
        this.saveMage(mage, asynchronous, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMage(com.elmakers.mine.bukkit.api.magic.Mage mage, boolean asynchronous, final MageDataCallback callback, boolean wandInventoryOpen) {
        if (!this.savePlayerData) {
            if (callback != null) {
                callback.run(null);
            }
            return;
        }
        this.info("Saving player data for " + mage.getName() + " (" + mage.getId() + ") " + (asynchronous ? "" : " synchronously"));
        final MageData mageData = new MageData(mage.getId());
        if (this.mageDataStore != null && mage.save(mageData)) {
            if (wandInventoryOpen) {
                mageData.setOpenWand(true);
            }
            if (asynchronous) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = MagicController.this.saveLock;
                        synchronized (object) {
                            try {
                                MagicController.this.mageDataStore.save(mageData, callback);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                });
            } else {
                Object object = this.saveLock;
                synchronized (object) {
                    try {
                        this.mageDataStore.save(mageData, callback);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    public ItemStack removeItemFromWand(Wand wand, ItemStack droppedItem) {
        if (wand == null || droppedItem == null || Wand.isWand(droppedItem)) {
            return null;
        }
        if (Wand.isSpell(droppedItem)) {
            String spellKey = Wand.getSpell(droppedItem);
            wand.removeSpell(spellKey);
            SpellTemplate spell = this.getSpellTemplate(spellKey);
            if (spell != null) {
                Wand.updateSpellItem(this.messages, droppedItem, spell, "", null, null, true);
            }
        } else if (Wand.isBrush(droppedItem)) {
            String brushKey = Wand.getBrush(droppedItem);
            wand.removeBrush(brushKey);
            Wand.updateBrushItem(this.getMessages(), droppedItem, brushKey, null);
        }
        return droppedItem;
    }

    public void onArmorUpdated(final Mage mage) {
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                mage.armorUpdated();
            }
        }, 1L);
    }

    @Override
    public boolean isLocked(Block block) {
        return this.protectLocked && this.containerMaterials.contains(block.getType()) && CompatibilityUtils.isLocked(block);
    }

    protected boolean addLostWandMarker(LostWand lostWand) {
        Location location = lostWand.getLocation();
        if (!lostWand.isIndestructible()) {
            return true;
        }
        return this.addMarker("wand-" + lostWand.getId(), "Wands", lostWand.getName(), location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ(), lostWand.getDescription());
    }

    public void toggleCastCommandOverrides(com.elmakers.mine.bukkit.api.magic.Mage apiMage, CommandSender sender, boolean override) {
        if (apiMage instanceof Mage) {
            Mage mage = (Mage)apiMage;
            if (sender instanceof BlockCommandSender) {
                mage.setCostReduction(override ? this.castCommandCostReduction : 0.0f);
                mage.setCooldownReduction(override ? this.castCommandCooldownReduction : 0.0f);
                mage.setPowerMultiplier(override ? this.castCommandPowerMultiplier : 1.0f);
            } else {
                mage.setCostReduction(override ? this.castConsoleCostReduction : 0.0f);
                mage.setCooldownReduction(override ? this.castConsoleCooldownReduction : 0.0f);
                mage.setPowerMultiplier(override ? this.castConsolePowerMultiplier : 1.0f);
            }
        }
    }

    public float getCooldownReduction() {
        return this.cooldownReduction;
    }

    public float getCostReduction() {
        return this.costReduction;
    }

    public Material getDefaultMaterial() {
        return this.defaultMaterial;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.wand.LostWand> getLostWands() {
        return new ArrayList<com.elmakers.mine.bukkit.api.wand.LostWand>(this.lostWands.values());
    }

    public Collection<Automaton> getAutomata() {
        ArrayList<Automaton> all = new ArrayList<Automaton>();
        for (Map<Long, Automaton> chunkList : this.automata.values()) {
            all.addAll(chunkList.values());
        }
        return all;
    }

    public boolean cast(com.elmakers.mine.bukkit.api.magic.Mage mage, String spellName, ConfigurationSection parameters, CommandSender sender, Entity entity) {
        SpellTemplate template;
        Location mageLocation;
        Player usePermissions;
        Player player = sender == entity && entity instanceof Player ? (Player)entity : (usePermissions = sender instanceof Player ? (Player)sender : null);
        if (entity == null && sender instanceof Player) {
            entity = (Player)sender;
        }
        Location targetLocation = null;
        if (mage == null) {
            CommandSender mageController;
            Object object = mageController = entity != null && entity instanceof Player ? (Player)entity : sender;
            if (sender != null) {
                if (sender instanceof BlockCommandSender) {
                    targetLocation = ((BlockCommandSender)sender).getBlock().getLocation();
                } else if (entity != null && sender != entity) {
                    targetLocation = entity.getLocation();
                }
            }
            mage = mageController == null ? this.getMage(entity) : this.getMage(mageController);
        }
        if (mage == null) {
            return false;
        }
        if (targetLocation != null && (mageLocation = mage.getLocation()) != null) {
            targetLocation.setPitch(mageLocation.getPitch());
            targetLocation.setYaw(mageLocation.getYaw());
        }
        if ((template = this.getSpellTemplate(spellName)) == null || !template.hasCastPermission((CommandSender)usePermissions)) {
            if (sender != null) {
                sender.sendMessage("Spell " + spellName + " unknown");
            }
            return false;
        }
        MageSpell spell = mage.getSpell(spellName);
        if (spell == null) {
            if (sender != null) {
                sender.sendMessage("Spell " + spellName + " unknown");
            }
            return false;
        }
        this.toggleCastCommandOverrides(mage, sender, true);
        boolean success = false;
        try {
            success = spell.cast(parameters, targetLocation);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.toggleCastCommandOverrides(mage, sender, false);
        return success;
    }

    public void onCast(com.elmakers.mine.bukkit.api.magic.Mage mage, Spell spell, SpellResult result) {
        if (this.dynmapShowSpells && this.dynmap != null && result.isSuccess()) {
            if (this.dynmapOnlyPlayerSpells && (mage == null || !mage.isPlayer())) {
                return;
            }
            this.dynmap.showCastMarker(mage, spell, result);
        }
        if (result.isSuccess() && this.getShowCastHoloText()) {
            mage.showHoloText(mage.getEyeLocation(), spell.getName(), 10000);
        }
    }

    @Override
    public com.elmakers.mine.bukkit.api.magic.Messages getMessages() {
        return this.messages;
    }

    @Override
    public MapController getMaps() {
        return this.maps;
    }

    public String getWelcomeWand() {
        return this.welcomeWand;
    }

    public void triggerBlockToggle(Chunk chunk) {
        String chunkKey = this.getChunkKey(chunk);
        Map<Long, Automaton> chunkData = this.automata.get(chunkKey);
        if (chunkData != null) {
            final ArrayList<Automaton> restored = new ArrayList<Automaton>();
            ArrayList<Long> blockKeys = new ArrayList<Long>(chunkData.keySet());
            long timeThreshold = System.currentTimeMillis() - (long)this.toggleCooldown;
            for (Long blockKey : blockKeys) {
                Automaton toggleBlock = chunkData.get(blockKey);
                if (toggleBlock.getCreatedTime() >= timeThreshold) continue;
                Block current = toggleBlock.getBlock();
                if (current.getType() == toggleBlock.getMaterial()) {
                    this.redstoneReplacement.modify(current, true);
                    restored.add(toggleBlock);
                }
                chunkData.remove(blockKey);
            }
            if (restored.size() > 0) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        for (Automaton restoreBlock : restored) {
                            restoreBlock.restore(true);
                        }
                    }
                }, 5L);
            }
            if (chunkData.size() == 0) {
                this.automata.remove(chunkKey);
            }
        }
    }

    public void sendToMages(String message, Location location, int range) {
        int rangeSquared = range * range;
        if (message != null && message.length() > 0) {
            for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
                if (!mage.isPlayer() || mage.isDead() || !mage.isOnline() || !mage.hasLocation() || !mage.getLocation().getWorld().equals(location.getWorld()) || !(mage.getLocation().toVector().distanceSquared(location.toVector()) < (double)rangeSquared)) continue;
                mage.sendMessage(message);
            }
        }
    }

    @Override
    public void forgetMage(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.mages.remove(mage.getId());
    }

    @Override
    public Automaton getAutomaton(Block block) {
        String chunkId = this.getChunkKey(block);
        Map<Long, Automaton> toReload = this.automata.get(chunkId);
        if (toReload != null) {
            return toReload.get(BlockData.getBlockId(block));
        }
        return null;
    }

    @Override
    public boolean isAutomata(Block block) {
        String chunkId = this.getChunkKey(block);
        Map<Long, Automaton> toReload = this.automata.get(chunkId);
        if (toReload != null) {
            return toReload.containsKey(BlockData.getBlockId(block));
        }
        return false;
    }

    @Override
    public boolean isNPC(Entity entity) {
        return entity != null && (entity.hasMetadata("NPC") || entity.hasMetadata("shopkeeper"));
    }

    @Override
    public void updateBlock(Block block) {
        this.updateBlock(block.getWorld().getName(), block.getX(), block.getY(), block.getZ());
    }

    @Override
    public void updateBlock(String worldName, int x, int y, int z) {
        if (this.dynmap != null && this.dynmapUpdate) {
            this.dynmap.triggerRenderOfBlock(worldName, x, y, z);
        }
    }

    @Override
    public void updateVolume(String worldName, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
        if (this.dynmap != null && this.dynmapUpdate && worldName != null && worldName.length() > 0) {
            this.dynmap.triggerRenderOfVolume(worldName, minx, miny, minz, maxx, maxy, maxz);
        }
    }

    public void update(String worldName, BoundingBox area) {
        if (this.dynmap != null && this.dynmapUpdate && area != null && worldName != null && worldName.length() > 0) {
            this.dynmap.triggerRenderOfVolume(worldName, area.getMin().getBlockX(), area.getMin().getBlockY(), area.getMin().getBlockZ(), area.getMax().getBlockX(), area.getMax().getBlockY(), area.getMax().getBlockZ());
        }
    }

    @Override
    public void update(BlockList blockList) {
        if (blockList != null) {
            this.update(blockList.getWorldName(), blockList.getArea());
        }
    }

    @Override
    public boolean canCreateWorlds() {
        return this.createWorldsEnabled;
    }

    @Override
    public Set<Material> getMaterialSet(String name) {
        Set<Material> materials = this.materialSets.get(name);
        if (materials == null) {
            String[] nameList;
            String materialString = name;
            if (name.equals("*")) {
                materials = new WildcardHashSet<Material>();
            } else if (name.startsWith("!")) {
                materialString = materialString.substring(1);
                materials = new NegatedHashSet<Material>();
            } else {
                materials = new HashSet<Material>();
            }
            for (String matName : nameList = StringUtils.split((String)materialString, (char)',')) {
                if (this.materialSets.containsKey(matName)) {
                    materials.addAll((Collection<Material>)this.materialSets.get(matName));
                    continue;
                }
                Material material = ConfigurationUtils.toMaterial(matName);
                if (material == null) continue;
                materials.add(material);
            }
            this.materialSets.put(name, materials);
        }
        return materials;
    }

    @Override
    public void sendToMages(String message, Location location) {
        this.sendToMages(message, location, this.toggleMessageRange);
    }

    @Override
    public void registerAutomata(Block block, String name, String message) {
        String chunkId = this.getChunkKey(block);
        if (chunkId == null) {
            return;
        }
        Map<Long, Automaton> toReload = this.automata.get(chunkId);
        if (toReload == null) {
            toReload = new HashMap<Long, Automaton>();
            this.automata.put(chunkId, toReload);
        }
        Automaton data = new Automaton(block, name, message);
        toReload.put(data.getId(), data);
    }

    @Override
    public boolean unregisterAutomata(Block block) {
        String chunkId = this.getChunkKey(block);
        Map<Long, Automaton> toReload = this.automata.get(chunkId);
        if (toReload != null) {
            toReload.remove(BlockData.getBlockId(block));
            if (toReload.size() == 0) {
                this.automata.remove(chunkId);
            }
        }
        return toReload != null;
    }

    @Override
    public int getMaxUndoPersistSize() {
        return this.undoMaxPersistSize;
    }

    public MagicPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public MagicAPI getAPI() {
        return this.plugin;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.magic.Mage> getMages() {
        return this.mages.values();
    }

    @Override
    public Set<Material> getBuildingMaterials() {
        return this.buildingMaterials;
    }

    @Override
    public Set<Material> getDestructibleMaterials() {
        return this.destructibleMaterials;
    }

    @Override
    public Set<Material> getRestrictedMaterials() {
        return this.restrictedMaterials;
    }

    @Override
    public int getMessageThrottle() {
        return this.messageThrottle;
    }

    @Override
    public boolean isMage(Entity entity) {
        if (entity == null) {
            return false;
        }
        return this.mages.containsKey(entity.getUniqueId().toString());
    }

    @Override
    public Collection<String> getMaterialSets() {
        return this.materialSets.keySet();
    }

    @Override
    public Collection<String> getPlayerNames() {
        ArrayList<String> playerNames = new ArrayList<String>();
        Collection players = this.plugin.getServer().getOnlinePlayers();
        for (Player player : players) {
            if (this.isNPC((Entity)player)) continue;
            playerNames.add(player.getName());
        }
        return playerNames;
    }

    @Override
    public void disablePhysics(int interval) {
        if (this.physicsHandler == null && interval > 0) {
            this.physicsHandler = new PhysicsHandler(this);
            Bukkit.getPluginManager().registerEvents((Listener)this.physicsHandler, (Plugin)this.plugin);
        }
        if (this.physicsHandler != null) {
            this.physicsHandler.setInterval(interval);
        }
    }

    @Override
    public boolean commitAll() {
        boolean undid = false;
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            undid = mage.commit() || undid;
        }
        UndoList.commitAll();
        return undid;
    }

    @Override
    public boolean canTarget(Entity attacker, Entity entity) {
        if (this.useScoreboardTeams && attacker instanceof Player && entity instanceof Player) {
            Player player1 = (Player)attacker;
            Player player2 = (Player)entity;
            Scoreboard scoreboard1 = player1.getScoreboard();
            Scoreboard scoreboard2 = player2.getScoreboard();
            if (scoreboard1 != null && scoreboard2 != null) {
                Team team1 = scoreboard1.getPlayerTeam((OfflinePlayer)player1);
                Team team2 = scoreboard2.getPlayerTeam((OfflinePlayer)player2);
                if (team1 != null && team2 != null && team1.equals(team2)) {
                    return false;
                }
            }
        }
        return this.preciousStonesManager.canTarget(attacker, entity) && this.townyManager.canTarget(attacker, entity);
    }

    @Override
    public Location getWarp(String warpName) {
        Location location = null;
        if (this.warpController != null) {
            try {
                location = this.warpController.getWarp(warpName);
            }
            catch (Exception ex) {
                location = null;
            }
        }
        return location;
    }

    @Override
    public Location getTownLocation(Player player) {
        return this.townyManager.getTownLocation(player);
    }

    @Override
    public Map<String, Location> getHomeLocations(Player player) {
        return this.preciousStonesManager.getFieldLocations(player);
    }

    public TownyManager getTowny() {
        return this.townyManager;
    }

    public PreciousStonesManager getPreciousStones() {
        return this.preciousStonesManager;
    }

    @Override
    public boolean sendMail(CommandSender sender, String fromPlayer, String toPlayer, String message) {
        if (this.mailer != null) {
            return this.mailer.sendMail(sender, fromPlayer, toPlayer, message);
        }
        return false;
    }

    @Override
    public com.elmakers.mine.bukkit.api.block.UndoList undoAny(Block target) {
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            com.elmakers.mine.bukkit.api.block.UndoList undid = mage.undo(target);
            if (undid == null) continue;
            return undid;
        }
        return null;
    }

    @Override
    public com.elmakers.mine.bukkit.api.block.UndoList undoRecent(Block target, int timeout) {
        for (com.elmakers.mine.bukkit.api.magic.Mage mage : this.mages.values()) {
            UndoQueue queue = mage.getUndoQueue();
            com.elmakers.mine.bukkit.api.block.UndoList undid = queue.undoRecent(target, timeout);
            if (undid == null) continue;
            return undid;
        }
        return null;
    }

    public CitizensController getCitizens() {
        return this.citizens;
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand getWand(ItemStack itemStack) {
        return new Wand(this, itemStack);
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand getWand(ConfigurationSection config) {
        return new Wand(this, config);
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand createWand(String wandKey) {
        return Wand.createWand(this, wandKey);
    }

    @Override
    public WandTemplate getWandTemplate(String key) {
        return this.wandTemplates.get(key);
    }

    @Override
    public Collection<WandTemplate> getWandTemplates() {
        return this.wandTemplates.values();
    }

    protected ConfigurationSection resolveConfiguration(String key, ConfigurationSection properties, Map<String, ConfigurationSection> configurations) {
        ConfigurationSection configuration = configurations.get(key);
        if (configuration == null) {
            ConfigurationSection baseConfiguration;
            configuration = properties.getConfigurationSection(key);
            if (configuration == null) {
                return null;
            }
            String inherits = configuration.getString("inherit");
            if (inherits != null && (baseConfiguration = this.resolveConfiguration(inherits, properties, configurations)) != null) {
                MemoryConfiguration newConfiguration = new MemoryConfiguration();
                ConfigurationUtils.addConfigurations((ConfigurationSection)newConfiguration, baseConfiguration);
                ConfigurationUtils.addConfigurations((ConfigurationSection)newConfiguration, configuration);
                newConfiguration.set("hidden", configuration.get("hidden"));
                configuration = newConfiguration;
            }
            configurations.put(key, configuration);
        }
        return configuration;
    }

    public void loadWandTemplates(ConfigurationSection properties) {
        this.wandTemplates.clear();
        Set wandKeys = properties.getKeys(false);
        HashMap<String, ConfigurationSection> templateConfigurations = new HashMap<String, ConfigurationSection>();
        for (String key : wandKeys) {
            this.loadWandTemplate(key, this.resolveConfiguration(key, properties, templateConfigurations));
        }
    }

    @Override
    public void loadWandTemplate(String key, ConfigurationSection wandNode) {
        wandNode.set("key", (Object)key);
        if (wandNode.getBoolean("enabled", true)) {
            this.wandTemplates.put(key, new com.elmakers.mine.bukkit.wand.WandTemplate(this, key, wandNode));
        }
    }

    @Override
    public void unloadWandTemplate(String key) {
        this.wandTemplates.remove(key);
    }

    public Collection<String> getWandTemplateKeys() {
        return this.wandTemplates.keySet();
    }

    public ConfigurationSection getWandTemplateConfiguration(String key) {
        WandTemplate template = this.getWandTemplate(key);
        return template == null ? null : template.getConfiguration();
    }

    @Override
    public boolean elementalsEnabled() {
        return this.elementals != null;
    }

    @Override
    public boolean createElemental(Location location, String templateName, CommandSender creator) {
        return this.elementals.createElemental(location, templateName, creator);
    }

    @Override
    public boolean isElemental(Entity entity) {
        if (this.elementals == null || entity.getType() != EntityType.FALLING_BLOCK) {
            return false;
        }
        return this.elementals.isElemental(entity);
    }

    @Override
    public boolean damageElemental(Entity entity, double damage, int fireTicks, CommandSender attacker) {
        if (this.elementals == null) {
            return false;
        }
        return this.elementals.damageElemental(entity, damage, fireTicks, attacker);
    }

    @Override
    public boolean setElementalScale(Entity entity, double scale) {
        if (this.elementals == null) {
            return false;
        }
        return this.elementals.setElementalScale(entity, scale);
    }

    @Override
    public double getElementalScale(Entity entity) {
        if (this.elementals == null) {
            return 0.0;
        }
        return this.elementals.getElementalScale(entity);
    }

    @Override
    public com.elmakers.mine.bukkit.api.spell.SpellCategory getCategory(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        SpellCategory category = this.categories.get(key);
        if (category == null) {
            category = new SpellCategory(key, this);
            this.categories.put(key, category);
        }
        return category;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.spell.SpellCategory> getCategories() {
        ArrayList<com.elmakers.mine.bukkit.api.spell.SpellCategory> allCategories = new ArrayList<com.elmakers.mine.bukkit.api.spell.SpellCategory>();
        allCategories.addAll(this.categories.values());
        return allCategories;
    }

    @Override
    public Collection<SpellTemplate> getSpellTemplates() {
        return this.getSpellTemplates(false);
    }

    @Override
    public Collection<SpellTemplate> getSpellTemplates(boolean showHidden) {
        ArrayList<SpellTemplate> allSpells = new ArrayList<SpellTemplate>();
        for (SpellTemplate spell : this.spells.values()) {
            if (!showHidden && spell.isHidden()) continue;
            allSpells.add(spell);
        }
        return allSpells;
    }

    @Override
    public SpellTemplate getSpellTemplate(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        SpellTemplate spell = this.spellAliases.get(name);
        if (spell == null) {
            spell = this.spells.get(name);
        }
        if (spell == null && name.startsWith("heroes*")) {
            if (this.heroesManager == null) {
                return null;
            }
            spell = this.heroesManager.createSkillSpell(this, name.substring(7));
            if (spell != null) {
                this.spells.put(name, spell);
            }
        }
        return spell;
    }

    @Override
    public String getEntityName(Entity target) {
        return this.getEntityName(target, false);
    }

    @Override
    public String getEntityDisplayName(Entity target) {
        return this.getEntityName(target, true);
    }

    protected String getEntityName(Entity target, boolean display) {
        if (target == null) {
            return "Unknown";
        }
        if (target instanceof Player) {
            return display ? ((Player)target).getDisplayName() : ((Player)target).getName();
        }
        if (this.isElemental(target)) {
            return "Elemental";
        }
        if (display) {
            if (target instanceof LivingEntity) {
                LivingEntity li = (LivingEntity)target;
                String customName = li.getCustomName();
                if (customName != null && customName.length() > 0) {
                    return customName;
                }
            } else if (target instanceof Item) {
                ItemMeta meta;
                Item item = (Item)target;
                ItemStack itemStack = item.getItemStack();
                if (itemStack.hasItemMeta() && (meta = itemStack.getItemMeta()).hasDisplayName()) {
                    return meta.getDisplayName();
                }
                MaterialAndData material = new MaterialAndData(itemStack);
                return material.getName();
            }
        }
        return target.getType().name().toLowerCase().replace('_', ' ');
    }

    public boolean getShowCastHoloText() {
        return this.showCastHoloText;
    }

    public boolean getShowActivateHoloText() {
        return this.showActivateHoloText;
    }

    public int getCastHoloTextRange() {
        return this.castHoloTextRange;
    }

    public int getActiveHoloTextRange() {
        return this.activateHoloTextRange;
    }

    public ItemStack getSpellBook(com.elmakers.mine.bukkit.api.spell.SpellCategory category, int count) {
        HashMap<String, ArrayList<SpellTemplate>> categories = new HashMap<String, ArrayList<SpellTemplate>>();
        Collection<SpellTemplate> spellVariants = this.spells.values();
        String categoryKey = category == null ? null : category.getKey();
        for (SpellTemplate spell : spellVariants) {
            com.elmakers.mine.bukkit.api.spell.SpellCategory spellCategory;
            if (spell.isHidden() || spell.getSpellKey().isVariant() || (spellCategory = spell.getCategory()) == null) continue;
            String spellCategoryKey = spellCategory.getKey();
            if (categoryKey != null && !spellCategoryKey.equalsIgnoreCase(categoryKey)) continue;
            ArrayList<SpellTemplate> categorySpells = (ArrayList<SpellTemplate>)categories.get(spellCategoryKey);
            if (categorySpells == null) {
                categorySpells = new ArrayList<SpellTemplate>();
                categories.put(spellCategoryKey, categorySpells);
            }
            categorySpells.add(spell);
        }
        ArrayList categoryKeys = new ArrayList(categories.keySet());
        Collections.sort(categoryKeys);
        CostReducer reducer = null;
        ItemStack bookItem = new ItemStack(Material.WRITTEN_BOOK, count);
        BookMeta book = (BookMeta)bookItem.getItemMeta();
        book.setAuthor(this.messages.get("books.default.author"));
        String title = null;
        title = category != null ? this.messages.get("books.default.title").replace("$category", category.getName()) : this.messages.get("books.all.title");
        book.setTitle(title);
        ArrayList<String> pages = new ArrayList<String>();
        Set<String> paths = WandUpgradePath.getPathKeys();
        for (String key : categoryKeys) {
            category = this.getCategory(key);
            title = this.messages.get("books.default.title").replace("$category", category.getName());
            String description = "" + ChatColor.BOLD + ChatColor.BLUE + title + "\n\n";
            description = description + "" + ChatColor.RESET + ChatColor.DARK_BLUE + category.getDescription();
            pages.add(description);
            List categorySpells = (List)categories.get(key);
            Collections.sort(categorySpells);
            for (SpellTemplate spell : categorySpells) {
                String spellExtendedDescription;
                String usage;
                long duration;
                WandUpgradePath checkPath;
                Collection<CastingCost> activeCosts;
                Collection<CastingCost> costs;
                String spellMageCooldownDescription;
                String spellCooldownDescription;
                ArrayList<String> lines = new ArrayList<String>();
                lines.add("" + ChatColor.GOLD + ChatColor.BOLD + spell.getName());
                lines.add("" + ChatColor.RESET);
                String spellDescription = spell.getDescription();
                if (spellDescription != null && spellDescription.length() > 0) {
                    lines.add("" + ChatColor.BLACK + spellDescription);
                    lines.add("");
                }
                if ((spellCooldownDescription = spell.getCooldownDescription()) != null && spellCooldownDescription.length() > 0) {
                    spellCooldownDescription = this.messages.get("cooldown.description").replace("$time", spellCooldownDescription);
                    lines.add("" + ChatColor.DARK_PURPLE + spellCooldownDescription);
                }
                if ((spellMageCooldownDescription = spell.getMageCooldownDescription()) != null && spellMageCooldownDescription.length() > 0) {
                    spellMageCooldownDescription = this.messages.get("cooldown.mage_description").replace("$time", spellMageCooldownDescription);
                    lines.add("" + ChatColor.RED + spellMageCooldownDescription);
                }
                if ((costs = spell.getCosts()) != null) {
                    for (CastingCost cost : costs) {
                        if (cost.isEmpty(reducer)) continue;
                        lines.add(ChatColor.DARK_PURPLE + this.messages.get("wand.costs_description").replace("$description", cost.getFullDescription(this.messages, reducer)));
                    }
                }
                if ((activeCosts = spell.getActiveCosts()) != null) {
                    for (CastingCost cost : activeCosts) {
                        if (cost.isEmpty(reducer)) continue;
                        lines.add(ChatColor.DARK_PURPLE + this.messages.get("wand.active_costs_description").replace("$description", cost.getFullDescription(this.messages, reducer)));
                    }
                }
                for (String pathKey : paths) {
                    checkPath = WandUpgradePath.getPath(pathKey);
                    if (checkPath.isHidden() || !checkPath.hasSpell(spell.getKey())) continue;
                    lines.add(ChatColor.DARK_BLUE + this.messages.get("spell.available_path").replace("$path", checkPath.getName()));
                    break;
                }
                for (String pathKey : paths) {
                    checkPath = WandUpgradePath.getPath(pathKey);
                    if (!checkPath.requiresSpell(spell.getKey())) continue;
                    lines.add(ChatColor.DARK_RED + this.messages.get("spell.required_path").replace("$path", checkPath.getName()));
                    break;
                }
                if ((duration = spell.getDuration()) > 0L) {
                    long seconds = duration / 1000L;
                    if (seconds > 3600L) {
                        long hours = seconds / 3600L;
                        lines.add(ChatColor.DARK_GREEN + this.messages.get("duration.lasts_hours").replace("$hours", Long.valueOf(hours).toString()));
                    } else if (seconds > 60L) {
                        long minutes = seconds / 60L;
                        lines.add(ChatColor.DARK_GREEN + this.messages.get("duration.lasts_minutes").replace("$minutes", Long.valueOf(minutes).toString()));
                    } else {
                        lines.add(ChatColor.DARK_GREEN + this.messages.get("duration.lasts_seconds").replace("$seconds", Long.valueOf(seconds).toString()));
                    }
                } else if (spell.showUndoable()) {
                    if (spell.isUndoable()) {
                        String undoable = this.messages.get("spell.undoable", "");
                        if (undoable != null && !undoable.isEmpty()) {
                            lines.add(undoable);
                        }
                    } else {
                        String notUndoable = this.messages.get("spell.not_undoable", "");
                        if (notUndoable != null && !notUndoable.isEmpty()) {
                            lines.add(notUndoable);
                        }
                    }
                }
                if (spell.usesBrush()) {
                    lines.add(ChatColor.DARK_GRAY + this.messages.get("spell.brush"));
                }
                SpellKey baseKey = spell.getSpellKey();
                SpellKey upgradeKey = new SpellKey(baseKey.getBaseKey(), baseKey.getLevel() + 1);
                SpellTemplate upgradeSpell = this.getSpellTemplate(upgradeKey.getKey());
                int spellLevels = 0;
                while (upgradeSpell != null) {
                    ++spellLevels;
                    upgradeKey = new SpellKey(upgradeKey.getBaseKey(), upgradeKey.getLevel() + 1);
                    upgradeSpell = this.getSpellTemplate(upgradeKey.getKey());
                }
                if (spellLevels > 0) {
                    lines.add(ChatColor.DARK_AQUA + this.messages.get("spell.levels_available").replace("$levels", Integer.toString(++spellLevels)));
                }
                if ((usage = spell.getUsage()) != null && usage.length() > 0) {
                    lines.add("" + ChatColor.GRAY + ChatColor.ITALIC + usage + ChatColor.RESET);
                    lines.add("");
                }
                if ((spellExtendedDescription = spell.getExtendedDescription()) != null && spellExtendedDescription.length() > 0) {
                    lines.add("" + ChatColor.BLACK + spellExtendedDescription);
                    lines.add("");
                }
                pages.add(StringUtils.join(lines, (String)"\n"));
            }
        }
        book.setPages(pages);
        bookItem.setItemMeta((ItemMeta)book);
        return bookItem;
    }

    @Override
    public MaterialAndData getRedstoneReplacement() {
        return this.redstoneReplacement;
    }

    @Override
    public boolean isUrlIconsEnabled() {
        return this.urlIconsEnabled;
    }

    @Override
    public Set<EntityType> getUndoEntityTypes() {
        return this.undoEntityTypes;
    }

    @Override
    public String describeItem(ItemStack item) {
        return this.messages.describeItem(item);
    }

    public boolean checkForItem(Player player, ItemStack requireItem, boolean take) {
        boolean foundItem = false;
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack item = contents[i];
            if (!this.itemsAreEqual(item, requireItem)) continue;
            Wand wand = null;
            if (Wand.isWand(item) && Wand.isBound(item) && !(wand = new Wand(this, item)).canUse(player)) continue;
            if (take) {
                player.getInventory().setItem(i, null);
                if (wand != null) {
                    wand.unbind();
                }
            }
            foundItem = true;
            break;
        }
        return foundItem;
    }

    @Override
    public boolean hasItem(Player player, ItemStack requireItem) {
        return this.checkForItem(player, requireItem, false);
    }

    @Override
    public boolean takeItem(Player player, ItemStack requireItem) {
        return this.checkForItem(player, requireItem, true);
    }

    @Override
    public String getItemKey(ItemStack item) {
        String url;
        if (item == null) {
            return "";
        }
        if (Wand.isUpgrade(item)) {
            return "upgrade:" + Wand.getWandTemplate(item);
        }
        if (Wand.isWand(item)) {
            return "wand:" + Wand.getWandTemplate(item);
        }
        if (Wand.isSpell(item)) {
            return "spell:" + Wand.getSpell(item);
        }
        if (Wand.isBrush(item)) {
            return "brush:" + Wand.getBrush(item);
        }
        if (item.getType() == Material.SKULL_ITEM && (url = InventoryUtils.getSkullURL(item)) != null && url.length() > 0) {
            return "skull_item:" + url;
        }
        MaterialAndData material = new MaterialAndData(item);
        return material.getKey();
    }

    @Override
    public ItemStack createItem(String magicItemKey) {
        return this.createItem(magicItemKey, false);
    }

    @Override
    public ItemStack createItem(String magicItemKey, boolean brief) {
        ItemStack itemStack = null;
        if (magicItemKey == null) {
            return null;
        }
        int amount = 1;
        if (magicItemKey.contains("@")) {
            String[] pieces = StringUtils.split((String)magicItemKey, (char)'@');
            magicItemKey = pieces[0];
            try {
                amount = Integer.parseInt(pieces[1]);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        magicItemKey = magicItemKey.replace("|", ":");
        try {
            String wandKey;
            if (magicItemKey.contains("skull:") || magicItemKey.contains("skull_item:")) {
                magicItemKey = magicItemKey.replace("skull:", "skull_item:");
                MaterialAndData skullData = new MaterialAndData(magicItemKey);
                itemStack = skullData.getItemStack(amount);
            } else if (magicItemKey.contains("book:")) {
                String bookCategory = magicItemKey.substring(5);
                com.elmakers.mine.bukkit.api.spell.SpellCategory category = null;
                if (!bookCategory.isEmpty() && !bookCategory.equalsIgnoreCase("all") && (category = this.getCategory(bookCategory)) == null) {
                    return null;
                }
                itemStack = this.getSpellBook(category, amount);
            } else if (magicItemKey.contains("sp:")) {
                String spAmount = magicItemKey.substring(3);
                itemStack = InventoryUtils.getURLSkull(this.skillPointIcon);
                ItemMeta meta = itemStack.getItemMeta();
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.get("sp.name")).replace("$amount", spAmount));
                String spDescription = this.messages.get("sp.description");
                if (spDescription.length() > 0) {
                    ArrayList<String> lore = new ArrayList<String>();
                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)spDescription));
                    meta.setLore(lore);
                }
                itemStack.setItemMeta(meta);
                InventoryUtils.setMeta(itemStack, "sp", spAmount);
            } else if (magicItemKey.contains("spell:")) {
                String spellKey = magicItemKey.substring(6);
                itemStack = this.createSpellItem(spellKey, brief);
            } else if (magicItemKey.contains("wand:")) {
                wandKey = magicItemKey.substring(5);
                com.elmakers.mine.bukkit.api.wand.Wand wand = this.createWand(wandKey);
                if (wand != null) {
                    itemStack = wand.getItem();
                }
            } else if (magicItemKey.contains("upgrade:")) {
                wandKey = magicItemKey.substring(8);
                com.elmakers.mine.bukkit.api.wand.Wand wand = this.createWand(wandKey);
                if (wand != null) {
                    wand.makeUpgrade();
                    itemStack = wand.getItem();
                }
            } else if (magicItemKey.contains("brush:")) {
                String brushKey = magicItemKey.substring(6);
                itemStack = this.createBrushItem(brushKey);
            } else if (magicItemKey.contains("item:")) {
                String itemKey = magicItemKey.substring(5);
                itemStack = this.createGenericItem(itemKey);
            } else {
                ItemData itemData = this.items.get(magicItemKey);
                if (itemData != null) {
                    return itemData.getItemStack(amount);
                }
                MaterialAndData item = new MaterialAndData(magicItemKey);
                if (item.isValid()) {
                    return item.getItemStack(amount);
                }
                com.elmakers.mine.bukkit.api.wand.Wand wand = this.createWand(magicItemKey);
                if (wand != null) {
                    return wand.getItem();
                }
                String spellKey = magicItemKey.replace(":", "|");
                itemStack = this.createSpellItem(spellKey, brief);
                if (itemStack != null) {
                    return itemStack;
                }
                itemStack = this.createBrushItem(magicItemKey);
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Error creating item: " + magicItemKey, ex);
        }
        return itemStack;
    }

    @Override
    public ItemStack createGenericItem(String key) {
        ConfigurationSection template = this.getWandTemplateConfiguration(key);
        if (template == null || !template.contains("icon")) {
            return null;
        }
        MaterialAndData icon = ConfigurationUtils.toMaterialAndData(template.getString("icon"));
        ItemStack item = icon.getItemStack(1);
        ItemMeta meta = item.getItemMeta();
        if (template.contains("name")) {
            meta.setDisplayName(template.getString("name"));
        } else {
            String name = this.messages.get("wands." + key + ".name");
            if (name != null && !name.isEmpty()) {
                meta.setDisplayName(name);
            }
        }
        ArrayList<String> lore = new ArrayList<String>();
        if (template.contains("description")) {
            lore.add(template.getString("description"));
        } else {
            String description = this.messages.get("wands." + key + ".description");
            if (description != null && !description.isEmpty()) {
                lore.add(description);
            }
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand createUpgrade(String wandKey) {
        Wand wand = Wand.createWand(this, wandKey);
        if (!wand.isUpgrade()) {
            wand.makeUpgrade();
        }
        return wand;
    }

    @Override
    public ItemStack createSpellItem(String spellKey) {
        return Wand.createSpellItem(spellKey, this, null, true);
    }

    @Override
    public ItemStack createSpellItem(String spellKey, boolean brief) {
        return Wand.createSpellItem(spellKey, this, null, !brief);
    }

    @Override
    public ItemStack createBrushItem(String brushKey) {
        return Wand.createBrushItem(brushKey, this, null, true);
    }

    @Override
    public boolean itemsAreEqual(ItemStack first, ItemStack second) {
        if (first == null || second == null) {
            return false;
        }
        if (first.getType() != second.getType() || first.getDurability() != second.getDurability()) {
            return false;
        }
        boolean firstIsWand = Wand.isWand(first);
        boolean secondIsWand = Wand.isWand(second);
        if (firstIsWand || secondIsWand) {
            if (!firstIsWand || !secondIsWand) {
                return false;
            }
            Wand firstWand = new Wand(this, InventoryUtils.getCopy(first));
            Wand secondWand = new Wand(this, InventoryUtils.getCopy(second));
            String firstTemplate = firstWand.getTemplateKey();
            String secondTemplate = secondWand.getTemplateKey();
            if (firstTemplate == null || secondTemplate == null) {
                return false;
            }
            return firstTemplate.equalsIgnoreCase(secondTemplate);
        }
        String firstSpellKey = Wand.getSpell(first);
        String secondSpellKey = Wand.getSpell(second);
        if (firstSpellKey != null || secondSpellKey != null) {
            if (firstSpellKey == null || secondSpellKey == null) {
                return false;
            }
            return firstSpellKey.equalsIgnoreCase(secondSpellKey);
        }
        String firstBrushKey = Wand.getBrush(first);
        String secondBrushKey = Wand.getBrush(second);
        if (firstBrushKey != null || secondBrushKey != null) {
            if (firstBrushKey == null || secondBrushKey == null) {
                return false;
            }
            return firstBrushKey.equalsIgnoreCase(secondBrushKey);
        }
        return true;
    }

    @Override
    public Set<String> getWandPathKeys() {
        return WandUpgradePath.getPathKeys();
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.WandUpgradePath getPath(String key) {
        return WandUpgradePath.getPath(key);
    }

    @Override
    public ItemStack deserialize(ConfigurationSection root, String key) {
        ConfigurationSection itemSection = root.getConfigurationSection(key);
        if (itemSection == null) {
            return null;
        }
        ItemStack item = itemSection.getItemStack("item");
        if (item == null) {
            return null;
        }
        if (itemSection.contains("wand")) {
            item = InventoryUtils.makeReal(item);
            ConfigurationSection stateNode = itemSection.getConfigurationSection("wand");
            Object wandNode = InventoryUtils.createNode(item, Wand.WAND_KEY);
            if (wandNode != null) {
                InventoryUtils.saveTagsToNBT(stateNode, wandNode, Wand.ALL_PROPERTY_KEYS);
            }
        } else if (itemSection.contains("spell")) {
            item = InventoryUtils.makeReal(item);
            InventoryUtils.setMeta(item, "spell", itemSection.getString("spell"));
            if (itemSection.contains("skill")) {
                InventoryUtils.setMeta(item, "skill", "true");
            }
        } else if (itemSection.contains("brush")) {
            item = InventoryUtils.makeReal(item);
            InventoryUtils.setMeta(item, "brush", itemSection.getString("brush"));
        }
        return item;
    }

    @Override
    public void serialize(ConfigurationSection root, String key, ItemStack item) {
        ConfigurationSection itemSection = root.createSection(key);
        itemSection.set("item", (Object)item);
        if (Wand.isWand(item)) {
            ConfigurationSection stateNode = itemSection.createSection("wand");
            Object wandNode = InventoryUtils.getNode(item, Wand.WAND_KEY);
            InventoryUtils.loadTagsFromNBT(stateNode, wandNode, Wand.ALL_PROPERTY_KEYS);
        } else if (Wand.isSpell(item)) {
            itemSection.set("spell", (Object)Wand.getSpell(item));
            if (Wand.isSkill(item)) {
                itemSection.set("skill", (Object)"true");
            }
        } else if (Wand.isBrush(item)) {
            itemSection.set("brush", (Object)Wand.getBrush(item));
        }
    }

    @Override
    public void disableItemSpawn() {
        this.entityController.setDisableItemSpawn(true);
    }

    @Override
    public void enableItemSpawn() {
        this.entityController.setDisableItemSpawn(false);
    }

    @Override
    public void setForceSpawn(boolean force) {
        this.entityController.setForceSpawn(force);
    }

    public HeroesManager getHeroes() {
        return this.heroesManager;
    }

    public String getDefaultSkillIcon() {
        return this.defaultSkillIcon;
    }

    public int getSkillInventoryRows() {
        return this.skillInventoryRows;
    }

    public boolean usePermissionSkills() {
        return this.skillsUsePermissions;
    }

    public boolean useHeroesSkills() {
        return this.skillsUseHeroes;
    }

    @Override
    public void addFlightExemption(Player player, int duration) {
        this.ncpManager.addFlightExemption(player, duration);
        CompatibilityUtils.addFlightExemption(player, duration * 20 / 1000);
    }

    public String getExtraSchematicFilePath() {
        return this.extraSchematicFilePath;
    }

    @Override
    public void warpPlayerToServer(Player player, String server, String warp) {
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.getMage(player);
        if (apiMage instanceof Mage) {
            ((Mage)apiMage).setDestinationWarp(warp);
            this.info("Cross-server warping " + player.getName() + " to warp " + warp, 1);
        }
        this.sendPlayerToServer(player, server);
    }

    @Override
    public void sendPlayerToServer(final Player player, final String server) {
        MageDataCallback callback = new MageDataCallback(){

            @Override
            public void run(MageData data) {
                Bukkit.getScheduler().runTaskLater((Plugin)MagicController.this.plugin, (Runnable)new ChangeServerTask((Plugin)MagicController.this.plugin, player, server), 1L);
            }
        };
        this.info("Moving " + player.getName() + " to server " + server, 1);
        com.elmakers.mine.bukkit.api.magic.Mage mage = this.getRegisteredMage((Entity)player);
        if (mage != null) {
            this.playerQuit(mage, callback);
        } else {
            callback.run(null);
        }
    }

    @Override
    public boolean spawnPhysicsBlock(Location location, Material material, short data, Vector velocity) {
        if (this.blockPhysicsManager == null) {
            return false;
        }
        this.blockPhysicsManager.spawnPhysicsBlock(location, material, data, velocity);
        return true;
    }

    @Override
    public boolean isDisguised(Entity entity) {
        return !this.libsDisguiseEnabled || this.libsDisguiseManager == null || entity == null ? false : this.libsDisguiseManager.isDisguised(entity);
    }

    @Override
    public boolean isSpellUpgradingEnabled() {
        return this.autoSpellUpgradesEnabled;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean areLocksProtected() {
        return this.protectLocked;
    }

    public boolean isContainer(Block block) {
        return block != null && this.containerMaterials.contains(block.getType());
    }

    public boolean isMeleeWeapon(ItemStack item) {
        return item != null && this.meleeMaterials.contains(item.getType());
    }

    public boolean isWearable(ItemStack item) {
        return item != null && this.wearableMaterials.contains(item.getType());
    }

    public boolean isInteractable(Block block) {
        return block != null && this.interactibleMaterials.contains(block.getType());
    }

    public boolean isSpellDroppingEnabled() {
        return this.spellDroppingEnabled;
    }

    @Override
    public boolean isSPEnabled() {
        return this.spEnabled;
    }

    @Override
    public int getSPMaximum() {
        return this.spMaximum;
    }

    @Override
    public void deleteMage(final String id) {
        com.elmakers.mine.bukkit.api.magic.Mage mage = this.getRegisteredMage(id);
        if (mage != null) {
            this.playerQuit(mage, new MageDataCallback(){

                @Override
                public void run(MageData data) {
                    MagicController.this.info("Deleted player id " + id);
                    MagicController.this.mageDataStore.delete(id);
                }
            });
        }
    }

    public long getPhysicsTimeout() {
        if (this.physicsHandler != null) {
            return this.physicsHandler.getTimeout();
        }
        return 0L;
    }

    @Override
    public String getSpell(ItemStack item) {
        return Wand.getSpell(item);
    }

    @Override
    public String getSpellArgs(ItemStack item) {
        return Wand.getSpellArgs(item);
    }

    @Override
    public Set<String> getMobKeys() {
        return this.mobs.getKeys();
    }

    @Override
    public Entity spawnMob(String key, Location location) {
        EntityData mobType = this.mobs.get(key);
        if (mobType != null) {
            return mobType.spawn(this, location);
        }
        EntityType entityType = EntityData.parseEntityType(key);
        if (entityType == null) {
            return null;
        }
        return location.getWorld().spawnEntity(location, entityType);
    }

    @Override
    public com.elmakers.mine.bukkit.api.entity.EntityData getMob(String key) {
        return this.mobs.get(key);
    }

    @Override
    public com.elmakers.mine.bukkit.api.entity.EntityData loadMob(ConfigurationSection configuration) {
        return new EntityData(this, configuration);
    }

    @Override
    public Set<String> getItemKeys() {
        return this.items.getKeys();
    }

    @Override
    public com.elmakers.mine.bukkit.api.item.ItemData getItem(String key) {
        return this.items.get(key);
    }

    @Override
    public com.elmakers.mine.bukkit.api.item.ItemData getItem(ItemStack match) {
        return this.items.get(match);
    }

    @Override
    public void unloadItemTemplate(String key) {
        this.items.remove(key);
    }

    @Override
    public void loadItemTemplate(String key, ConfigurationSection configuration) {
        this.items.loadItem(key, configuration);
    }

    @Override
    public Double getWorth(ItemStack item) {
        SpellTemplate spell;
        String spellKey = Wand.getSpell(item);
        if (spellKey != null && (spell = this.getSpellTemplate(spellKey)) != null) {
            return spell.getWorth();
        }
        ItemData configuredItem = this.items.get(item);
        if (configuredItem != null) {
            return configuredItem.getWorth();
        }
        return null;
    }

    public boolean isInventoryBackupEnabled() {
        return this.backupInventories;
    }

    @Override
    public String getBlockSkin(Material blockType) {
        String skinName = null;
        switch (blockType) {
            case CACTUS: {
                skinName = "MHF_Cactus";
                break;
            }
            case CHEST: {
                skinName = "MHF_Chest";
                break;
            }
            case MELON_BLOCK: {
                skinName = "MHF_Melon";
                break;
            }
            case TNT: {
                if (random.nextDouble() > 0.5) {
                    skinName = "MHF_TNT";
                    break;
                }
                skinName = "MHF_TNT2";
                break;
            }
            case LOG: {
                skinName = "MHF_OakLog";
                break;
            }
            case PUMPKIN: {
                skinName = "MHF_Pumpkin";
                break;
            }
        }
        return skinName;
    }

    @Override
    public void checkResourcePack(final CommandSender sender) {
        final Server server = this.plugin.getServer();
        final boolean initialLoad = !this.checkedResourcePack;
        String resourcePackURL = CompatibilityUtils.getResourcePack(server);
        final String resourcePackHash = CompatibilityUtils.getResourcePackHash(server);
        if (!this.checkedResourcePack && resourcePackHash != null && !resourcePackHash.isEmpty()) {
            sender.sendMessage("Resource pack hash already set- Magic skipping RP check");
            return;
        }
        this.checkedResourcePack = true;
        if (resourcePackURL == null || resourcePackURL.isEmpty()) {
            if (this.defaultResourcePack == null || this.defaultResourcePack.isEmpty()) {
                sender.sendMessage("No resource pack set, and default has been cleared- Magic skipping RP check");
                return;
            }
            resourcePackURL = this.defaultResourcePack;
            CompatibilityUtils.setResourcePack(server, resourcePackURL, resourcePackHash);
            sender.sendMessage("No resource pack set, using default from Magic configuration");
        }
        if (!this.enableResourcePackCheck) {
            sender.sendMessage("Resource pack updates disabled, Magic not checking for updates");
            return;
        }
        sender.sendMessage("Magic checking resource pack for updates: " + ChatColor.GRAY + resourcePackURL);
        final String finalResourcePack = resourcePackURL;
        server.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                String response = null;
                String newResourcePackHash = null;
                try {
                    HttpURLConnection.setFollowRedirects(false);
                    HttpURLConnection connection = (HttpURLConnection)new URL(finalResourcePack).openConnection();
                    connection.setInstanceFollowRedirects(false);
                    connection.setRequestMethod("HEAD");
                    if (connection.getResponseCode() == 200) {
                        String newHash = connection.getHeaderField("ETag");
                        if (newHash != null) {
                            newHash = newHash.replace("\"", "");
                        }
                        if (newHash == null || newHash.isEmpty()) {
                            response = ChatColor.RED + "Resource pack returned empty ETag in HTTP HEAD";
                        } else if (resourcePackHash != null && newHash.equals(resourcePackHash)) {
                            response = ChatColor.GREEN + "Resource pack hash has not changed";
                        } else {
                            response = initialLoad ? ChatColor.GREEN + "Resource pack hash set to " + ChatColor.GRAY + newHash : ChatColor.YELLOW + "Resource pack hash changed, clients will see updates after relogging";
                            if (newHash.length() != 40) {
                                response = response + ", " + ChatColor.YELLOW + "Padding resource pack hash to 40 chars";
                                newHash = newHash.length() < 40 ? newHash + new String(new char[40 - newHash.length()]).replace('\u0000', '0') : newHash.substring(0, 39);
                            }
                            if (!CompatibilityUtils.checkResourcePackHash(newHash)) {
                                response = response + ", " + ChatColor.RED + "Resource pack hash is not valid: " + newHash;
                            }
                            newResourcePackHash = newHash;
                        }
                    } else {
                        response = ChatColor.RED + "Could not find resource pack at: " + ChatColor.DARK_RED + finalResourcePack;
                    }
                }
                catch (Exception e) {
                    response = ChatColor.RED + "An error occurred while checking your resource pack (see logs): " + ChatColor.DARK_RED + finalResourcePack;
                    e.printStackTrace();
                }
                final String finalResponse = response;
                final String finalResourcePackHash = newResourcePackHash;
                server.getScheduler().runTask((Plugin)MagicController.this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        if (finalResponse != null) {
                            sender.sendMessage(finalResponse);
                        }
                        if (finalResourcePackHash != null) {
                            CompatibilityUtils.setResourcePack(server, finalResourcePack, finalResourcePackHash);
                        }
                    }
                });
            }
        });
    }

    @Override
    public String getMobSkin(EntityType mobType) {
        String mobSkin = null;
        switch (mobType) {
            case BLAZE: {
                mobSkin = "MHF_Blaze";
                break;
            }
            case CAVE_SPIDER: {
                mobSkin = "MHF_CaveSpider";
                break;
            }
            case CHICKEN: {
                mobSkin = "MHF_Chicken";
                break;
            }
            case COW: {
                mobSkin = "MHF_Cow";
                break;
            }
            case ENDERMAN: {
                mobSkin = "MHF_Enderman";
                break;
            }
            case GHAST: {
                mobSkin = "MHF_Ghast";
                break;
            }
            case IRON_GOLEM: {
                mobSkin = "MHF_Golem";
                break;
            }
            case MAGMA_CUBE: {
                mobSkin = "MHF_LavaSlime";
                break;
            }
            case MUSHROOM_COW: {
                mobSkin = "MHF_MushroomCow";
                break;
            }
            case OCELOT: {
                mobSkin = "MHF_Ocelot";
                break;
            }
            case PIG: {
                mobSkin = "MHF_Pig";
                break;
            }
            case PIG_ZOMBIE: {
                mobSkin = "MHF_PigZombie";
                break;
            }
            case SHEEP: {
                mobSkin = "MHF_Sheep";
                break;
            }
            case SLIME: {
                mobSkin = "MHF_Slime";
                break;
            }
            case SPIDER: {
                mobSkin = "MHF_Spider";
                break;
            }
            case SQUID: {
                mobSkin = "MHF_Squid";
                break;
            }
            case VILLAGER: {
                mobSkin = "MHF_Villager";
                break;
            }
            case WOLF: {
                mobSkin = "MHF_Wolf";
                break;
            }
            case CREEPER: {
                mobSkin = "MHF_Creeper";
                break;
            }
            case ZOMBIE: {
                mobSkin = "MHF_Zombie";
                break;
            }
            case SKELETON: {
                mobSkin = "MHF_Skeleton";
                break;
            }
            case GUARDIAN: {
                mobSkin = "MHF_Guardian";
                break;
            }
            case WITCH: {
                mobSkin = "MHF_Witch";
                break;
            }
        }
        return mobSkin;
    }
}

