/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionEffectAction
extends BaseSpellAction {
    private Set<PotionEffectType> removeEffects;
    private Collection<PotionEffect> addEffects;
    private Integer duration;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        if (parameters.contains("remove_effects")) {
            this.removeEffects = new HashSet<PotionEffectType>();
            List removeEffectKeys = parameters.getStringList("remove_effects");
            for (String removeKey : removeEffectKeys) {
                try {
                    PotionEffectType removeType = PotionEffectType.getByName((String)removeKey);
                    if (removeType == null) continue;
                    this.removeEffects.add(removeType);
                }
                catch (Exception ex) {
                    spell.getController().getLogger().log(Level.WARNING, "Invalid potion effect type: " + removeKey, ex);
                }
            }
        } else {
            this.removeEffects = null;
        }
        this.duration = parameters.contains("duration") ? Integer.valueOf(parameters.getInt("duration")) : null;
        this.addEffects = BaseSpell.getPotionEffects(parameters, this.duration);
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        if (parameters.contains("duration")) {
            int durationOverride = parameters.getInt("duration");
            if (this.duration == null || durationOverride != this.duration) {
                this.addEffects = BaseSpell.getPotionEffects(parameters, durationOverride);
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity entity = context.getTargetEntity();
        if (!(entity instanceof LivingEntity)) {
            return SpellResult.NO_TARGET;
        }
        LivingEntity targetEntity = (LivingEntity)entity;
        context.registerPotionEffects((Entity)targetEntity);
        boolean effected = false;
        if (this.addEffects != null && this.addEffects.size() > 0) {
            effected = true;
            CompatibilityUtils.applyPotionEffects(targetEntity, this.addEffects);
        }
        if (this.removeEffects != null) {
            Collection currentEffects = targetEntity.getActivePotionEffects();
            for (PotionEffect effect : currentEffects) {
                PotionEffectType removeType = effect.getType();
                if (!this.removeEffects.contains(removeType) || effect.getDuration() >= 0x1FFFFFFF) continue;
                targetEntity.removePotionEffect(removeType);
                effected = true;
            }
        }
        return effected ? SpellResult.CAST : SpellResult.NO_TARGET;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        PotionEffectType[] effectTypes;
        super.getParameterNames(spell, parameters);
        parameters.add("duration");
        for (PotionEffectType effectType : effectTypes = PotionEffectType.values()) {
            if (effectType == null) continue;
            parameters.add("effect_" + effectType.getName().toLowerCase());
        }
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("duration")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_DURATIONS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

