/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.Schematic;
import com.elmakers.mine.bukkit.utility.BoundingBox;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Rotation;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Skull;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Witch;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class CompatibilityUtils
extends NMSUtils {
    public static boolean USE_MAGIC_DAMAGE = true;
    public static boolean isDamaging = false;
    public static final int MAX_ENTITY_RANGE = 72;
    private static final Map<EntityType, BoundingBox> hitboxes = new HashMap<EntityType, BoundingBox>();
    private static final Map<EntityType, Double> headSizes = new HashMap<EntityType, Double>();
    private static final Map<World.Environment, Integer> maxHeights = new HashMap<World.Environment, Integer>();
    private static double hitboxScale = 1.0;
    private static double hitboxScaleY = 1.0;
    private static double hitboxSneakScaleY = 0.75;
    private static BoundingBox defaultHitbox;
    private static WeakReference<ThrownPotion> potionReference;

    public static void applyPotionEffects(LivingEntity entity, Collection<PotionEffect> effects) {
        for (PotionEffect effect : effects) {
            CompatibilityUtils.applyPotionEffect(entity, effect);
        }
    }

    public static void applyPotionEffect(LivingEntity entity, PotionEffect effect) {
        boolean applyEffect = true;
        Collection currentEffects = entity.getActivePotionEffects();
        for (PotionEffect currentEffect : currentEffects) {
            if (!currentEffect.getType().equals((Object)effect.getType())) continue;
            if (effect.getAmplifier() < 0) {
                applyEffect = false;
                entity.removePotionEffect(effect.getType());
                break;
            }
            if (currentEffect.getAmplifier() <= effect.getAmplifier() && effect.getDuration() <= 0x1FFFFFFF) continue;
            applyEffect = false;
            break;
        }
        if (applyEffect) {
            entity.addPotionEffect(effect, true);
        }
    }

    public static boolean setDisplayName(ItemStack itemStack, String displayName) {
        Object handle = CompatibilityUtils.getHandle(itemStack);
        if (handle == null) {
            return false;
        }
        Object tag = CompatibilityUtils.getTag(handle);
        if (tag == null) {
            return false;
        }
        Object displayNode = CompatibilityUtils.createNode(tag, "display");
        if (displayNode == null) {
            return false;
        }
        CompatibilityUtils.setMeta(displayNode, "Name", displayName);
        return true;
    }

    public static boolean setLore(ItemStack itemStack, Collection<String> lore) {
        Object handle = CompatibilityUtils.getHandle(itemStack);
        if (handle == null) {
            return false;
        }
        Object tag = CompatibilityUtils.getTag(handle);
        if (tag == null) {
            return false;
        }
        Object displayNode = CompatibilityUtils.createNode(tag, "display");
        if (displayNode == null) {
            return false;
        }
        Object loreList = CompatibilityUtils.setStringList(displayNode, "Lore", lore);
        return loreList != null;
    }

    public static Inventory createInventory(InventoryHolder holder, int size, String name) {
        Inventory inventory = null;
        try {
            String shorterName = name;
            if (shorterName.length() > 32) {
                shorterName = shorterName.substring(0, 31);
            }
            inventory = (Inventory)class_CraftInventoryCustom_constructor.newInstance(holder, size, ChatColor.translateAlternateColorCodes((char)'&', (String)shorterName));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return inventory;
    }

    public static void addPotionEffect(LivingEntity entity, Color color) {
        CompatibilityUtils.addPotionEffect(entity, color.asRGB());
    }

    public static void setInvulnerable(Entity entity) {
        CompatibilityUtils.setInvulnerable(entity, true);
    }

    public static void setInvulnerable(Entity entity, boolean flag) {
        try {
            Object handle = CompatibilityUtils.getHandle(entity);
            class_Entity_invulnerableField.set(handle, flag);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setSilent(Entity entity, boolean flag) {
        try {
            Object handle = CompatibilityUtils.getHandle(entity);
            class_Entity_setSilentMethod.invoke(handle, flag);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void removePotionEffect(LivingEntity entity) {
        CompatibilityUtils.watch((Entity)entity, 7, (Object)0);
    }

    private static Location getPaintingOffset(Location loc, BlockFace facing, Art art) {
        switch (art) {
            case ALBAN: 
            case AZTEC: 
            case AZTEC2: 
            case BOMB: 
            case KEBAB: 
            case PLANT: 
            case WASTELAND: {
                return loc;
            }
            case GRAHAM: 
            case WANDERER: {
                return loc.getBlock().getLocation().add(0.0, -1.0, 0.0);
            }
            case CREEBET: 
            case COURBET: 
            case POOL: 
            case SEA: 
            case SUNSET: 
            case DONKEYKONG: 
            case SKELETON: {
                if (facing == BlockFace.WEST) {
                    return loc.getBlock().getLocation().add(0.0, 0.0, -1.0);
                }
                if (facing == BlockFace.SOUTH) {
                    return loc.getBlock().getLocation().add(-1.0, 0.0, 0.0);
                }
                return loc;
            }
            case BUST: 
            case MATCH: 
            case SKULL_AND_ROSES: 
            case STAGE: 
            case VOID: 
            case WITHER: 
            case FIGHTERS: 
            case BURNINGSKULL: 
            case PIGSCENE: 
            case POINTER: {
                if (facing == BlockFace.WEST) {
                    return loc.getBlock().getLocation().add(0.0, -1.0, -1.0);
                }
                if (facing == BlockFace.SOUTH) {
                    return loc.getBlock().getLocation().add(-1.0, -1.0, 0.0);
                }
                return loc.add(0.0, -1.0, 0.0);
            }
        }
        return loc;
    }

    public static Painting spawnPainting(Location location, BlockFace facing, Art art) {
        Painting newPainting = null;
        try {
            location = CompatibilityUtils.getPaintingOffset(location, facing, art);
            Object worldHandle = CompatibilityUtils.getHandle(location.getWorld());
            Object newEntity = null;
            Object directionEnum = Enum.valueOf(class_EnumDirection, facing.name());
            Object blockLocation = class_BlockPositionConstructor.newInstance(location.getX(), location.getY(), location.getZ());
            newEntity = class_EntityPaintingConstructor.newInstance(worldHandle, blockLocation, directionEnum);
            if (newEntity != null) {
                Entity bukkitEntity = CompatibilityUtils.getBukkitEntity(newEntity);
                if (bukkitEntity == null || !(bukkitEntity instanceof Painting)) {
                    return null;
                }
                newPainting = (Painting)bukkitEntity;
                newPainting.setFacingDirection(facing, true);
                newPainting.setArt(art, true);
                class_World_addEntityMethod.invoke(worldHandle, newEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            newPainting = null;
        }
        return newPainting;
    }

    public static ItemFrame spawnItemFrame(Location location, BlockFace facing, Rotation rotation, ItemStack item) {
        ItemFrame newItemFrame = null;
        try {
            Object worldHandle = CompatibilityUtils.getHandle(location.getWorld());
            Object newEntity = null;
            Object directionEnum = Enum.valueOf(class_EnumDirection, facing.name());
            Object blockLocation = class_BlockPositionConstructor.newInstance(location.getX(), location.getY(), location.getZ());
            newEntity = class_EntityItemFrameConstructor.newInstance(worldHandle, blockLocation, directionEnum);
            if (newEntity != null) {
                Entity bukkitEntity = CompatibilityUtils.getBukkitEntity(newEntity);
                if (bukkitEntity == null || !(bukkitEntity instanceof ItemFrame)) {
                    return null;
                }
                newItemFrame = (ItemFrame)bukkitEntity;
                newItemFrame.setItem(CompatibilityUtils.getCopy(item));
                newItemFrame.setFacingDirection(facing, true);
                newItemFrame.setRotation(rotation);
                try {
                    class_World_addEntityMethod.invoke(worldHandle, newEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
                }
                catch (Exception ex) {
                    newItemFrame = null;
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return newItemFrame;
    }

    public static ArmorStand spawnArmorStand(Location location) {
        ArmorStand armorStand = null;
        try {
            Object worldHandle = CompatibilityUtils.getHandle(location.getWorld());
            Object newEntity = null;
            newEntity = class_ArmorStand_Constructor.newInstance(worldHandle);
            if (newEntity != null) {
                Entity bukkitEntity = CompatibilityUtils.getBukkitEntity(newEntity);
                if (bukkitEntity == null || !(bukkitEntity instanceof ArmorStand)) {
                    return null;
                }
                armorStand = (ArmorStand)bukkitEntity;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (armorStand != null) {
            armorStand.teleport(location);
        }
        return armorStand;
    }

    public static boolean addToWorld(World world, Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        try {
            Object worldHandle = CompatibilityUtils.getHandle(world);
            Object entityHandle = CompatibilityUtils.getHandle(entity);
            class_World_addEntityMethod.invoke(worldHandle, entityHandle, reason);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static void watch(Object entityHandle, int key, Object data) {
        if (class_DataWatcher_watchMethod == null) {
            return;
        }
        try {
            Method getDataWatcherMethod = class_Entity.getMethod("getDataWatcher", new Class[0]);
            Object dataWatcher = getDataWatcherMethod.invoke(entityHandle, new Object[0]);
            class_DataWatcher_watchMethod.invoke(dataWatcher, key, data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void watch(Entity entity, int key, Object data) {
        try {
            Method geHandleMethod = entity.getClass().getMethod("getHandle", new Class[0]);
            CompatibilityUtils.watch(geHandleMethod.invoke((Object)entity, new Object[0]), key, data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void addPotionEffect(LivingEntity entity, int color) {
        if (color == 0) {
            color = 65793;
        }
        CompatibilityUtils.watch((Entity)entity, 7, (Object)color);
    }

    public static List<Entity> getNearbyEntities(Location location, double x, double y, double z) {
        if (location == null) {
            return null;
        }
        Object worldHandle = CompatibilityUtils.getHandle(location.getWorld());
        try {
            x = Math.min(x, 72.0);
            z = Math.min(z, 72.0);
            Object bb = class_AxisAlignedBB_Constructor.newInstance(location.getX() - x, location.getY() - y, location.getZ() - z, location.getX() + x, location.getY() + y, location.getZ() + z);
            List entityList = (List)class_World_getEntitiesMethod.invoke(worldHandle, null, bb);
            ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(entityList.size());
            for (Object entity : entityList) {
                bukkitEntityList.add((Entity)class_Entity_getBukkitEntityMethod.invoke(entity, new Object[0]));
            }
            return bukkitEntityList;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Minecart spawnCustomMinecart(Location location, MaterialAndData display, int offset) {
        Minecart newMinecart = null;
        try {
            Constructor minecartConstructor = class_EntityMinecartRideable.getConstructor(class_World, Double.TYPE, Double.TYPE, Double.TYPE);
            Method addEntity = class_World.getMethod("addEntity", class_Entity, CreatureSpawnEvent.SpawnReason.class);
            Method setPositionRotationMethod = class_Entity.getMethod("setPositionRotation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            Object worldHandle = CompatibilityUtils.getHandle(location.getWorld());
            Object newEntity = minecartConstructor.newInstance(worldHandle, location.getX(), location.getY(), location.getZ());
            if (newEntity != null) {
                setPositionRotationMethod.invoke(newEntity, location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
                int materialId = display.getMaterial().getId() & 0xFFFF | display.getData() << 16;
                CompatibilityUtils.watch(newEntity, 20, (Object)materialId);
                CompatibilityUtils.watch(newEntity, 21, (Object)offset);
                CompatibilityUtils.watch(newEntity, 22, (Object)1);
                addEntity.invoke(worldHandle, newEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
                Entity bukkitEntity = CompatibilityUtils.getBukkitEntity(newEntity);
                if (bukkitEntity == null || !(bukkitEntity instanceof Minecart)) {
                    return null;
                }
                newMinecart = (Minecart)bukkitEntity;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return newMinecart;
    }

    public static Class<? extends Runnable> getTaskClass(BukkitTask task) {
        Class taskClass = null;
        try {
            Method getTaskClassMethod = class_CraftTask.getDeclaredMethod("getTaskClass", new Class[0]);
            getTaskClassMethod.setAccessible(true);
            taskClass = (Class)getTaskClassMethod.invoke((Object)task, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return taskClass;
    }

    public static Runnable getTaskRunnable(BukkitTask task) {
        Runnable runnable = null;
        try {
            Field taskField = class_CraftTask.getDeclaredField("task");
            taskField.setAccessible(true);
            runnable = (Runnable)taskField.get(task);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return runnable;
    }

    public static void ageItem(Item item, int ticksToAge) {
        try {
            Class<?> itemClass = CompatibilityUtils.fixBukkitClass("net.minecraft.server.EntityItem");
            Object handle = CompatibilityUtils.getHandle((Entity)item);
            Field ageField = itemClass.getDeclaredField("age");
            ageField.setAccessible(true);
            ageField.set(handle, ticksToAge);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void damage(LivingEntity target, double amount, Entity source) {
        if (target == null || target.isDead()) {
            return;
        }
        isDamaging = true;
        try {
            target.damage(amount, source);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        isDamaging = false;
    }

    public static void magicDamage(LivingEntity target, double amount, Entity source) {
        try {
            if (target == null || target.isDead()) {
                return;
            }
            if (!USE_MAGIC_DAMAGE || target instanceof Witch || target instanceof Enderman) {
                CompatibilityUtils.damage(target, amount, source);
                return;
            }
            Object targetHandle = CompatibilityUtils.getHandle(target);
            if (targetHandle == null) {
                return;
            }
            isDamaging = true;
            Object sourceHandle = CompatibilityUtils.getHandle(source);
            if (sourceHandle != null && source instanceof LivingEntity) {
                ThrownPotion potion = potionReference == null ? null : (ThrownPotion)potionReference.get();
                Location location = target.getLocation();
                if (potion == null) {
                    potion = (ThrownPotion)location.getWorld().spawnEntity(location, EntityType.SPLASH_POTION);
                    potion.remove();
                    potionReference = new WeakReference<ThrownPotion>(potion);
                }
                potion.teleport(location);
                potion.setShooter((ProjectileSource)((LivingEntity)source));
                Object potionHandle = CompatibilityUtils.getHandle((Entity)potion);
                Object damageSource = class_DamageSource_getMagicSourceMethod.invoke(null, potionHandle, sourceHandle);
                class_EntityDamageSource_setThornsMethod.invoke(damageSource, new Object[0]);
                class_EntityLiving_damageEntityMethod.invoke(targetHandle, damageSource, Float.valueOf((float)amount));
            } else {
                Object magicSource = class_DamageSource_MagicField.get(null);
                class_EntityLiving_damageEntityMethod.invoke(targetHandle, magicSource, Float.valueOf((float)amount));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        isDamaging = false;
    }

    public static double getKnockbackResistance(LivingEntity entity) {
        if (entity == null || entity.isDead()) {
            return 0.0;
        }
        try {
            Object entityHandle = CompatibilityUtils.getHandle(entity);
            if (entityHandle == null) {
                return 0.0;
            }
            Object attribute = class_EntityLiving_getAttributeInstanceMethod.invoke(entityHandle, class_GenericAttributes_KNOCKBACK_RESISTANCE);
            if (attribute == null) {
                return 0.0;
            }
            Object value = class_AttributeInstance_getValueMethod.invoke(attribute, new Object[0]);
            if (value instanceof Double) {
                return (Double)value;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return 0.0;
    }

    public static void setKnockbackResistance(LivingEntity entity, double amount) {
        amount = Math.min(Math.max(amount, 0.0), 1.0);
        if (entity == null || entity.isDead()) {
            return;
        }
        try {
            Object entityHandle = CompatibilityUtils.getHandle(entity);
            if (entityHandle == null) {
                return;
            }
            Object attribute = class_EntityLiving_getAttributeInstanceMethod.invoke(entityHandle, class_GenericAttributes_KNOCKBACK_RESISTANCE);
            if (attribute == null) {
                return;
            }
            class_AttributeInstance_setValueMethod.invoke(attribute, amount);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Deprecated
    public static void setTarget(LivingEntity entity, Location target) {
    }

    public static Location getEyeLocation(Entity entity) {
        if (entity instanceof LivingEntity) {
            return ((LivingEntity)entity).getEyeLocation();
        }
        return entity.getLocation();
    }

    public static Object getSkullProfile(Skull state) {
        Object profile = null;
        try {
            if (state == null || !class_CraftSkull.isInstance(state)) {
                return false;
            }
            profile = class_CraftSkull_profile.get(state);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return profile;
    }

    public static boolean setSkullProfile(Skull state, Object data) {
        try {
            if (state == null || !class_CraftSkull.isInstance(state)) {
                return false;
            }
            class_CraftSkull_profile.set(state, data);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean setSkullOwner(Skull state, String playerName, UUID playerId) {
        ItemStack skullItem = InventoryUtils.getPlayerSkull(playerName, playerId);
        if (skullItem == null) {
            return false;
        }
        return CompatibilityUtils.setSkullProfile(state, InventoryUtils.getSkullProfile(skullItem.getItemMeta()));
    }

    public static boolean setSkullOwner(Skull state, Player owner) {
        return CompatibilityUtils.setSkullOwner(state, owner.getName(), owner.getUniqueId());
    }

    public static ConfigurationSection loadConfiguration(String fileName) throws IOException, InvalidConfigurationException {
        YamlConfiguration configuration = new YamlConfiguration();
        try {
            configuration.load(fileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return configuration;
    }

    public static ConfigurationSection loadConfiguration(InputStream stream) throws IOException, InvalidConfigurationException {
        YamlConfiguration configuration = new YamlConfiguration();
        try {
            configuration.load(stream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return configuration;
    }

    public static ConfigurationSection loadConfiguration(File file) throws IOException, InvalidConfigurationException {
        YamlConfiguration configuration = new YamlConfiguration();
        try {
            configuration.load(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return configuration;
    }

    public static void setTNTSource(TNTPrimed tnt, LivingEntity source) {
        try {
            Object tntHandle = CompatibilityUtils.getHandle((Entity)tnt);
            Object sourceHandle = CompatibilityUtils.getHandle(source);
            class_EntityTNTPrimed_source.set(tntHandle, sourceHandle);
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.WARNING, "Unable to set TNT source", ex);
        }
    }

    public static void setEntityMotion(Entity entity, Vector motion) {
        try {
            Object handle = CompatibilityUtils.getHandle(entity);
            class_Entity_motXField.set(handle, motion.getX());
            class_Entity_motYField.set(handle, motion.getY());
            class_Entity_motZField.set(handle, motion.getZ());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static BoundingBox getHitbox(Block block) {
        int blockX = block.getX();
        int blockY = block.getY();
        int blockZ = block.getZ();
        return new BoundingBox((double)blockX + 0.001, (double)blockX + 0.999, (double)blockY + 0.001, (double)blockY + 0.999, (double)blockZ + 0.001, (double)blockZ + 0.999);
    }

    public static Vector getNormal(Block block, Location intersection) {
        double x = intersection.getX() - ((double)block.getX() + 0.5);
        double y = intersection.getY() - ((double)block.getY() + 0.5);
        double z = intersection.getZ() - ((double)block.getZ() + 0.5);
        double ax = Math.abs(x);
        double ay = Math.abs(y);
        double az = Math.abs(z);
        if (ax > ay && ax > az) {
            return new Vector(Math.signum(x), 0.0, 0.0);
        }
        if (ay > ax && ay > az) {
            return new Vector(0.0, Math.signum(y), 0.0);
        }
        return new Vector(0.0, 0.0, Math.signum(z));
    }

    public static BoundingBox getHitbox(Entity entity) {
        if (entity == null) {
            return null;
        }
        BoundingBox hitbox = hitboxes.get(entity.getType());
        if (hitbox != null) {
            return hitbox.center(entity.getLocation().toVector());
        }
        try {
            Object entityHandle = CompatibilityUtils.getHandle(entity);
            Object aabb = class_Entity_getBoundingBox.invoke(entityHandle, new Object[0]);
            if (aabb == null) {
                return defaultHitbox.center(entity.getLocation().toVector());
            }
            double scaleY = hitboxScaleY;
            if (entity instanceof Player && ((Player)entity).isSneaking()) {
                scaleY = hitboxSneakScaleY;
            }
            return new BoundingBox(class_AxisAlignedBB_minXField.getDouble(aabb), class_AxisAlignedBB_maxXField.getDouble(aabb), class_AxisAlignedBB_minYField.getDouble(aabb), class_AxisAlignedBB_maxYField.getDouble(aabb), class_AxisAlignedBB_minZField.getDouble(aabb), class_AxisAlignedBB_maxZField.getDouble(aabb)).scaleFromBase(hitboxScale, scaleY);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return defaultHitbox.center(entity.getLocation().toVector());
        }
    }

    public static void setHitboxScale(double scale) {
        hitboxScale = scale;
    }

    public static void setHitboxScaleY(double scaleY) {
        hitboxScaleY = scaleY;
    }

    public static void setHitboxSneakScaleY(double hitboxSneakScaleY) {
        CompatibilityUtils.hitboxSneakScaleY = hitboxSneakScaleY;
    }

    public static boolean isHeadshot(Entity target, Location hitLocation) {
        if (target == null) {
            return false;
        }
        Double headSize = headSizes.get(target.getType());
        if (headSize == null) {
            return false;
        }
        Location eyeLocation = null;
        eyeLocation = target instanceof LivingEntity ? ((LivingEntity)target).getEyeLocation() : target.getLocation();
        if (!eyeLocation.getWorld().equals(hitLocation.getWorld())) {
            return false;
        }
        double distance = Math.abs(hitLocation.getY() - eyeLocation.getY());
        return distance <= headSize;
    }

    public static void configureHeadSizes(ConfigurationSection config) {
        headSizes.clear();
        Set keys = config.getKeys(false);
        for (String key : keys) {
            try {
                double size = config.getDouble(key);
                EntityType entityType = EntityType.valueOf((String)key.toUpperCase());
                if (!(size > 0.0) || entityType == null) continue;
                headSizes.put(entityType, size);
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.WARNING, "Invalid entity type in head size definition: " + key, ex);
            }
        }
    }

    public static void configureHitboxes(ConfigurationSection config) {
        hitboxes.clear();
        Set keys = config.getKeys(false);
        for (String key : keys) {
            try {
                Vector bounds = ConfigurationUtils.getVector(config, key);
                String upperKey = key.toUpperCase();
                double halfX = bounds.getX() / 2.0;
                double halfZ = bounds.getZ() / 2.0;
                BoundingBox bb = new BoundingBox(-halfX, halfX, 0.0, bounds.getY(), -halfZ, halfZ).scaleFromBase(hitboxScale, hitboxScaleY);
                if (upperKey.equals("DEFAULT")) {
                    defaultHitbox = bb;
                    continue;
                }
                EntityType entityType = EntityType.valueOf((String)upperKey);
                if (bounds == null || entityType == null) continue;
                hitboxes.put(entityType, bb);
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.WARNING, "Invalid entity type in hitbox definition: " + key, ex);
            }
        }
    }

    public static boolean setLock(Block block, String lockName) {
        Object tileEntity = CompatibilityUtils.getTileEntity(block.getLocation());
        if (tileEntity == null) {
            return false;
        }
        if (!class_TileEntityContainer.isInstance(tileEntity)) {
            return false;
        }
        try {
            Object lock = class_ChestLock_Constructor.newInstance(lockName);
            class_TileEntityContainer_setLock.invoke(tileEntity, lock);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean clearLock(Block block) {
        Object tileEntity = CompatibilityUtils.getTileEntity(block.getLocation());
        if (tileEntity == null) {
            return false;
        }
        if (!class_TileEntityContainer.isInstance(tileEntity)) {
            return false;
        }
        try {
            class_TileEntityContainer_setLock.invoke(tileEntity, new Object[]{null});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean isLocked(Block block) {
        Object tileEntity = CompatibilityUtils.getTileEntity(block.getLocation());
        if (tileEntity == null) {
            return false;
        }
        if (!class_TileEntityContainer.isInstance(tileEntity)) {
            return false;
        }
        try {
            Object lock = class_TileEntityContainer_getLock.invoke(tileEntity, new Object[0]);
            if (lock == null) {
                return false;
            }
            return (Boolean)class_ChestLock_isEmpty.invoke(lock, new Object[0]) == false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static String getLock(Block block) {
        Object tileEntity = CompatibilityUtils.getTileEntity(block.getLocation());
        if (tileEntity == null) {
            return null;
        }
        if (!class_TileEntityContainer.isInstance(tileEntity)) {
            return null;
        }
        try {
            Object lock = class_TileEntityContainer_getLock.invoke(tileEntity, new Object[0]);
            if (lock == null) {
                return null;
            }
            return (String)class_ChestLock_getString.invoke(lock, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void setFallingBlockDamage(FallingBlock entity, float fallHurtAmount, int fallHurtMax) {
        Object entityHandle = CompatibilityUtils.getHandle((Entity)entity);
        if (entityHandle == null) {
            return;
        }
        try {
            class_EntityFallingBlock_hurtEntitiesField.set(entityHandle, true);
            class_EntityFallingBlock_fallHurtAmountField.set(entityHandle, Float.valueOf(fallHurtAmount));
            class_EntityFallingBlock_fallHurtMaxField.set(entityHandle, fallHurtMax);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void configureMaxHeights(ConfigurationSection config) {
        maxHeights.clear();
        Set keys = config.getKeys(false);
        for (String key : keys) {
            try {
                World.Environment worldType = World.Environment.valueOf((String)key.toUpperCase());
                if (worldType == null) continue;
                maxHeights.put(worldType, config.getInt(key));
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.WARNING, "Invalid environment type: " + key, ex);
            }
        }
    }

    public static int getMaxHeight(World world) {
        Integer maxHeight = maxHeights.get(world.getEnvironment());
        if (maxHeight == null) {
            maxHeight = world.getMaxHeight();
        }
        return maxHeight;
    }

    public static void setInvisible(ArmorStand armorStand, boolean invisible) {
        try {
            Object handle = CompatibilityUtils.getHandle((LivingEntity)armorStand);
            class_ArmorStand_setInvisible.invoke(handle, invisible);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setMarker(ArmorStand armorStand, boolean marker) {
        try {
            Object handle = CompatibilityUtils.getHandle((LivingEntity)armorStand);
            class_ArmorStand_setMarker.invoke(handle, marker);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setGravity(ArmorStand armorStand, boolean marker) {
        try {
            Object handle = CompatibilityUtils.getHandle((LivingEntity)armorStand);
            class_ArmorStand_setGravity.invoke(handle, marker);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setDisabledSlots(ArmorStand armorStand, int disabledSlots) {
        try {
            Object handle = CompatibilityUtils.getHandle((LivingEntity)armorStand);
            class_EntityArmorStand_disabledSlotsField.set(handle, disabledSlots);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setSmall(ArmorStand armorStand, boolean marker) {
        try {
            Object handle = CompatibilityUtils.getHandle((LivingEntity)armorStand);
            class_ArmorStand_setSmall.invoke(handle, marker);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setYawPitch(Entity entity, float yaw, float pitch) {
        try {
            Object handle = CompatibilityUtils.getHandle(entity);
            class_Entity_setYawPitchMethod.invoke(handle, Float.valueOf(yaw), Float.valueOf(pitch));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setLocation(Entity entity, double x, double y, double z, float yaw, float pitch) {
        try {
            Object handle = CompatibilityUtils.getHandle(entity);
            class_Entity_setLocationMethod.invoke(handle, x, y, z, Float.valueOf(yaw), Float.valueOf(pitch));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void addFlightExemption(Player player, int ticks) {
        try {
            Object handle = CompatibilityUtils.getHandle(player);
            Object connection = class_EntityPlayer_playerConnectionField.get(handle);
            class_PlayerConnection_floatCountField.set(connection, -ticks);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isValidProjectileClass(Class<?> projectileType) {
        return projectileType != null && (class_EntityArrow.isAssignableFrom(projectileType) || class_EntityProjectile.isAssignableFrom(projectileType) || class_EntityFireball.isAssignableFrom(projectileType));
    }

    public static Projectile spawnProjectile(Class<?> projectileType, Location location, Vector direction, ProjectileSource source, float speed, float spread, float spreadLocations, Random random) {
        Constructor<?> constructor = null;
        Method shootMethod = null;
        Method setPositionRotationMethod = null;
        Field projectileSourceField = null;
        Field dirXField = null;
        Field dirYField = null;
        Field dirZField = null;
        Object nmsWorld = CompatibilityUtils.getHandle(location.getWorld());
        Projectile projectile = null;
        try {
            Entity entity;
            constructor = projectileType.getConstructor(class_World);
            if (class_EntityFireball.isAssignableFrom(projectileType)) {
                dirXField = projectileType.getField("dirX");
                dirYField = projectileType.getField("dirY");
                dirZField = projectileType.getField("dirZ");
            }
            if (class_EntityProjectile.isAssignableFrom(projectileType) || class_EntityArrow.isAssignableFrom(projectileType)) {
                shootMethod = projectileType.getMethod("shoot", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            }
            setPositionRotationMethod = projectileType.getMethod("setPositionRotation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            projectileSourceField = projectileType.getField("projectileSource");
            Object nmsProjectile = null;
            try {
                nmsProjectile = constructor.newInstance(nmsWorld);
            }
            catch (Exception ex) {
                nmsProjectile = null;
            }
            if (nmsProjectile == null) {
                throw new Exception("Failed to spawn projectile of class " + projectileType.getName());
            }
            if (dirXField != null && dirYField != null && dirZField != null) {
                double spreadWeight = Math.min((double)0.4f, (double)spread * (double)0.0075f);
                double dx = (double)speed * (direction.getX() + random.nextGaussian() * spreadWeight);
                double dy = (double)speed * (direction.getY() + random.nextGaussian() * spreadWeight);
                double dz = (double)speed * (direction.getZ() + random.nextGaussian() * spreadWeight);
                dirXField.set(nmsProjectile, dx * 0.1);
                dirYField.set(nmsProjectile, dy * 0.1);
                dirZField.set(nmsProjectile, dz * 0.1);
            }
            Vector modifiedLocation = location.toVector().clone();
            if (class_EntityFireball.isAssignableFrom(projectileType) && spreadLocations > 0.0f) {
                modifiedLocation.setX(modifiedLocation.getX() + direction.getX() + random.nextGaussian() * (double)spread / 5.0);
                modifiedLocation.setY(modifiedLocation.getY() + direction.getY() + random.nextGaussian() * (double)spread / 5.0);
                modifiedLocation.setZ(modifiedLocation.getZ() + direction.getZ() + random.nextGaussian() * (double)spread / 5.0);
            }
            setPositionRotationMethod.invoke(nmsProjectile, modifiedLocation.getX(), modifiedLocation.getY(), modifiedLocation.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
            if (shootMethod != null) {
                shootMethod.invoke(nmsProjectile, direction.getX(), direction.getY(), direction.getZ(), Float.valueOf(speed), Float.valueOf(spread));
            }
            if ((entity = NMSUtils.getBukkitEntity(nmsProjectile)) == null || !(entity instanceof Projectile)) {
                throw new Exception("Got invalid bukkit entity from projectile of class " + projectileType.getName());
            }
            projectile = (Projectile)entity;
            if (source != null) {
                projectile.setShooter(source);
                projectileSourceField.set(nmsProjectile, source);
            }
            class_World_addEntityMethod.invoke(nmsWorld, nmsProjectile, CreatureSpawnEvent.SpawnReason.DEFAULT);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
        return projectile;
    }

    public static void setDamage(Projectile projectile, double damage) {
        try {
            Object handle = CompatibilityUtils.getHandle((Entity)projectile);
            class_EntityArrow_damageField.set(handle, damage);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void decreaseLifespan(Projectile projectile, int ticks) {
        try {
            Object handle = CompatibilityUtils.getHandle((Entity)projectile);
            int currentLife = (Integer)class_EntityArrow_lifeField.get(handle);
            if (currentLife < ticks) {
                class_EntityArrow_lifeField.set(handle, ticks);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Entity spawnEntity(Location target, EntityType entityType, CreatureSpawnEvent.SpawnReason spawnReason) {
        Entity entity = null;
        try {
            World world = target.getWorld();
            try {
                entity = (Entity)class_CraftWorld_spawnMethod.invoke((Object)world, target, entityType.getEntityClass(), spawnReason);
            }
            catch (Exception ex) {
                entity = target.getWorld().spawnEntity(target, entityType);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return entity;
    }

    public static String getResourcePack(Server server) {
        String rp = null;
        try {
            Object minecraftServer = CompatibilityUtils.getHandle(server);
            if (minecraftServer != null) {
                rp = (String)class_MinecraftServer_getResourcePackMethod.invoke(minecraftServer, new Object[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rp;
    }

    public static String getResourcePackHash(Server server) {
        String hash = null;
        try {
            Object minecraftServer = CompatibilityUtils.getHandle(server);
            if (minecraftServer != null) {
                hash = (String)class_MinecraftServer_getResourcePackHashMethod.invoke(minecraftServer, new Object[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return hash;
    }

    public static boolean setResourcePack(Server server, String rp, String hash) {
        try {
            Object minecraftServer = CompatibilityUtils.getHandle(server);
            if (minecraftServer == null) {
                return false;
            }
            class_MinecraftServer_setResourcePackMethod.invoke(minecraftServer, rp, hash);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean checkResourcePackHash(String hash) {
        return hash != null && !hash.isEmpty() && hash.matches("^[a-f0-9]{40}$");
    }

    public static boolean loadSchematic(File inputFile, Schematic schematic) {
        if (inputFile == null || !inputFile.exists() || schematic == null) {
            return false;
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(inputFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return CompatibilityUtils.loadSchematic(inputStream, schematic);
    }

    public static boolean loadSchematic(InputStream input, Schematic schematic) {
        if (input == null || schematic == null) {
            return false;
        }
        try {
            int i;
            int size;
            Object nbtData = class_NBTCompressedStreamTools_loadFileMethod.invoke(null, input);
            if (nbtData == null) {
                return false;
            }
            String materials = (String)class_NBTTagCompound_getStringMethod.invoke(nbtData, "Materials");
            if (!materials.equals("Alpha")) {
                Bukkit.getLogger().warning("Schematic is not in Alpha format");
                return false;
            }
            short width = (Short)class_NBTTagCompound_getShortMethod.invoke(nbtData, "Width");
            short height = (Short)class_NBTTagCompound_getShortMethod.invoke(nbtData, "Height");
            short length = (Short)class_NBTTagCompound_getShortMethod.invoke(nbtData, "Length");
            byte[] blockIds = (byte[])class_NBTTagCompound_getByteArrayMethod.invoke(nbtData, "Blocks");
            short[] blocks = new short[blockIds.length];
            byte[] addBlocks = new byte[]{};
            if (((Boolean)class_NBTTagCompound_hasKeyMethod.invoke(nbtData, "AddBlocks")).booleanValue()) {
                addBlocks = (byte[])class_NBTTagCompound_getByteArrayMethod.invoke(nbtData, "AddBlocks");
            }
            for (int index = 0; index < blocks.length; ++index) {
                blocks[index] = index >> 1 >= addBlocks.length ? (short)(blockIds[index] & 0xFF) : ((index & 1) == 0 ? (short)(((addBlocks[index >> 1] & 0xF) << 8) + (blockIds[index] & 0xFF)) : (short)(((addBlocks[index >> 1] & 0xF0) << 4) + (blockIds[index] & 0xFF)));
            }
            byte[] data = (byte[])class_NBTTagCompound_getByteArrayMethod.invoke(nbtData, "Data");
            ArrayList<Object> tileEntityData = new ArrayList<Object>();
            ArrayList<Object> entityData = new ArrayList<Object>();
            Object entityList = class_NBTTagCompound_getListMethod.invoke(nbtData, "Entities", 10);
            Object tileEntityList = class_NBTTagCompound_getListMethod.invoke(nbtData, "TileEntities", 10);
            if (entityList != null) {
                size = (Integer)class_NBTTagList_sizeMethod.invoke(entityList, new Object[0]);
                for (i = 0; i < size; ++i) {
                    Object entity = class_NBTTagList_getMethod.invoke(entityList, i);
                    entityData.add(entity);
                }
            }
            if (tileEntityList != null) {
                size = (Integer)class_NBTTagList_sizeMethod.invoke(tileEntityList, new Object[0]);
                for (i = 0; i < size; ++i) {
                    Object tileEntity = class_NBTTagList_getMethod.invoke(tileEntityList, i);
                    tileEntityData.add(tileEntity);
                }
            }
            int originX = (Integer)class_NBTTagCompound_getIntMethod.invoke(nbtData, "WEOriginX");
            int originY = (Integer)class_NBTTagCompound_getIntMethod.invoke(nbtData, "WEOriginY");
            int originZ = (Integer)class_NBTTagCompound_getIntMethod.invoke(nbtData, "WEOriginZ");
            int offsetX = (Integer)class_NBTTagCompound_getIntMethod.invoke(nbtData, "WEOffsetX");
            int offsetY = (Integer)class_NBTTagCompound_getIntMethod.invoke(nbtData, "WEOffsetY");
            int offsetZ = (Integer)class_NBTTagCompound_getIntMethod.invoke(nbtData, "WEOffsetZ");
            schematic.load(width, height, length, blocks, data, tileEntityData, entityData, new Vector(originX, originY, originZ), new Vector(offsetX, offsetY, offsetZ));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static void sendExperienceUpdate(Player player, float experience, int level) {
        try {
            Object packet = class_PacketPlayOutExperience_Constructor.newInstance(Float.valueOf(experience), player.getTotalExperience(), level);
            CompatibilityUtils.sendPacket(player, packet);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        potionReference = null;
    }
}

