/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.data.SpellData;
import com.elmakers.mine.bukkit.api.event.CastEvent;
import com.elmakers.mine.bukkit.api.event.PreCastEvent;
import com.elmakers.mine.bukkit.api.event.SpellUpgradeEvent;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellCategory;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.api.wand.WandUpgradePath;
import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.spell.CastingCost;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public abstract class BaseSpell
implements MageSpell,
Cloneable {
    public static int MAX_LORE_LENGTH = 24;
    protected static final double LOOK_THRESHOLD_RADIANS = 0.9;
    protected static final int MIN_Y = 1;
    protected static final Material DEFAULT_EFFECT_MATERIAL = Material.STATIONARY_WATER;
    public static final String[] EXAMPLE_VECTOR_COMPONENTS = new String[]{"-1", "-0.5", "0", "0.5", "1", "~-1", "~-0.5", "~0", "~0.5", "*1", "*-1", "*-0.5", "*0.5", "*1"};
    public static final String[] EXAMPLE_SIZES = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "12", "16", "32", "64"};
    public static final String[] EXAMPLE_BOOLEANS = new String[]{"true", "false"};
    public static final String[] EXAMPLE_DURATIONS = new String[]{"500", "1000", "2000", "5000", "10000", "60000", "120000"};
    public static final String[] EXAMPLE_PERCENTAGES = new String[]{"0", "0.1", "0.25", "0.5", "0.75", "1"};
    public static final String[] OTHER_PARAMETERS = new String[]{"transparent", "target", "target_type", "range", "duration", "player"};
    public static final String[] WORLD_PARAMETERS = new String[]{"pworld", "tworld", "otworld", "t2world"};
    protected static final Set<String> worldParameterMap = new HashSet<String>(Arrays.asList(WORLD_PARAMETERS));
    public static final String[] VECTOR_PARAMETERS = new String[]{"px", "py", "pz", "pdx", "pdy", "pdz", "tx", "ty", "tz", "otx", "oty", "otz", "t2x", "t2y", "t2z", "otdx", "otdy", "otdz"};
    protected static final Set<String> vectorParameterMap = new HashSet<String>(Arrays.asList(VECTOR_PARAMETERS));
    public static final String[] BOOLEAN_PARAMETERS = new String[]{"allow_max_range", "prevent_passthrough", "reverse_targeting", "passthrough", "bypass_protection", "bypass_build", "bypass_break", "bypass_pvp", "target_npc", "ignore_blocks", "target_self"};
    protected static final Set<String> booleanParameterMap = new HashSet<String>(Arrays.asList(BOOLEAN_PARAMETERS));
    public static final String[] PERCENTAGE_PARAMETERS = new String[]{"fizzle_chance", "backfire_chance", "cooldown_reduction"};
    protected static final Set<String> percentageParameterMap = new HashSet<String>(Arrays.asList(PERCENTAGE_PARAMETERS));
    public static final String[] COMMON_PARAMETERS = (String[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])VECTOR_PARAMETERS, (Object[])BOOLEAN_PARAMETERS), (Object[])OTHER_PARAMETERS), (Object[])WORLD_PARAMETERS), (Object[])PERCENTAGE_PARAMETERS);
    protected MageController controller;
    protected Mage mage;
    protected Location location;
    protected com.elmakers.mine.bukkit.action.CastContext currentCast;
    private SpellKey spellKey;
    private String inheritKey;
    private String name;
    private String alias;
    private String description;
    private String extendedDescription;
    private String levelDescription;
    private String upgradeDescription;
    private String usage;
    private double worth;
    private int earns;
    private Color color;
    private String particle;
    private SpellCategory category;
    private Set<String> tags;
    private BaseSpell template;
    private long requiredUpgradeCasts;
    private String requiredUpgradePath;
    private com.elmakers.mine.bukkit.block.MaterialAndData icon = new com.elmakers.mine.bukkit.block.MaterialAndData(Material.AIR);
    private String iconURL = null;
    private List<CastingCost> costs = null;
    private List<CastingCost> activeCosts = null;
    protected double cancelOnDamage = 0.0;
    protected boolean pvpRestricted = false;
    protected boolean disguiseRestricted = true;
    protected boolean worldBorderRestricted = true;
    protected boolean usesBrushSelection = false;
    protected boolean bypassFriendlyFire = false;
    protected boolean bypassPvpRestriction = false;
    protected boolean bypassBuildRestriction = false;
    protected boolean bypassBreakRestriction = false;
    protected boolean bypassProtection = false;
    protected boolean bypassConfusion = false;
    protected boolean bypassWeakness = false;
    protected boolean bypassPermissions = false;
    protected boolean castOnNoTarget = true;
    protected boolean bypassDeactivate = false;
    protected boolean quiet = false;
    protected boolean loud = false;
    protected boolean messageTargets = true;
    protected boolean targetSelf = false;
    protected boolean showUndoable = true;
    protected boolean cancellable = true;
    protected boolean quickCast = false;
    protected int verticalSearchDistance = 8;
    private boolean backfired = false;
    private boolean hidden = false;
    private boolean trackCasts = true;
    protected ConfigurationSection parameters = null;
    protected ConfigurationSection workingParameters = null;
    protected ConfigurationSection configuration = null;
    protected static Random random = new Random();
    private float cooldownReduction = 0.0f;
    private float costReduction = 0.0f;
    private float consumeReduction = 0.0f;
    private boolean bypassMageCooldown = false;
    private int mageCooldown = 0;
    private int cooldown = 0;
    private long cooldownExpiration = 0L;
    private int earnCooldown = 0;
    private int duration = 0;
    private int totalDuration = -1;
    private long lastCast = 0L;
    private long lastEarn = 0L;
    private long lastActiveCost = 0L;
    private float activeCostScale = 1.0f;
    private long castCount = 0L;
    private boolean isActive = false;
    private Map<String, Collection<EffectPlayer>> effects = new HashMap<String, Collection<EffectPlayer>>();
    private float fizzleChance = 0.0f;
    private float backfireChance = 0.0f;
    private long lastMessageSent = 0L;
    private Set<Material> preventPassThroughMaterials = null;
    private Set<Material> passthroughMaterials = null;
    private Set<Material> unsafeMaterials = null;

    public boolean allowPassThrough(Material mat) {
        if (this.mage != null && this.mage.isSuperPowered()) {
            return true;
        }
        if (this.passthroughMaterials != null && this.passthroughMaterials.contains(mat)) {
            return true;
        }
        return this.preventPassThroughMaterials == null || !this.preventPassThroughMaterials.contains(mat);
    }

    public boolean isPassthrough(Material mat) {
        return this.passthroughMaterials != null && this.passthroughMaterials.contains(mat);
    }

    public boolean isOkToStandIn(Material mat) {
        if (this.isHalfBlock(mat)) {
            return false;
        }
        return this.passthroughMaterials.contains(mat) && !this.unsafeMaterials.contains(mat);
    }

    public boolean isWater(Material mat) {
        return mat == Material.WATER || mat == Material.STATIONARY_WATER;
    }

    public boolean isOkToStandOn(Block block) {
        return this.isOkToStandOn(block.getType());
    }

    protected boolean isHalfBlock(Material mat) {
        return mat == Material.STEP || mat == Material.WOOD_STEP;
    }

    public boolean isOkToStandOn(Material mat) {
        if (this.isHalfBlock(mat)) {
            return true;
        }
        return mat != Material.AIR && !this.unsafeMaterials.contains(mat) && !this.passthroughMaterials.contains(mat);
    }

    public boolean isSafeLocation(Block block) {
        if (!block.getChunk().isLoaded()) {
            block.getChunk().load(true);
            return false;
        }
        if (block.getY() > CompatibilityUtils.getMaxHeight(block.getWorld())) {
            return false;
        }
        Block blockOneUp = block.getRelative(BlockFace.UP);
        Block blockOneDown = block.getRelative(BlockFace.DOWN);
        if (this.isUnderwater() && (blockOneDown.getType() == Material.STATIONARY_WATER || blockOneDown.getType() == Material.WATER) && blockOneUp.getType() == Material.AIR && block.getType() == Material.AIR) {
            return true;
        }
        Player player = this.mage.getPlayer();
        return (this.isOkToStandOn(blockOneDown) || player != null && player.isFlying()) && this.isOkToStandIn(blockOneUp.getType()) && this.isOkToStandIn(block.getType());
    }

    public boolean isSafeLocation(Location loc) {
        return this.isSafeLocation(loc.getBlock());
    }

    public Location tryFindPlaceToStand(Location targetLoc) {
        int maxHeight = CompatibilityUtils.getMaxHeight(targetLoc.getWorld());
        return this.tryFindPlaceToStand(targetLoc, maxHeight, maxHeight);
    }

    public Location findPlaceToStand(Location targetLoc) {
        return this.findPlaceToStand(targetLoc, this.verticalSearchDistance, this.verticalSearchDistance);
    }

    public Location tryFindPlaceToStand(Location targetLoc, int maxDownDelta, int maxUpDelta) {
        Location location = this.findPlaceToStand(targetLoc, maxDownDelta, maxUpDelta);
        return location == null ? targetLoc : location;
    }

    public Location findPlaceToStand(Location targetLoc, int maxDownDelta, int maxUpDelta) {
        if (!targetLoc.getBlock().getChunk().isLoaded()) {
            return null;
        }
        int minY = 1;
        int maxY = CompatibilityUtils.getMaxHeight(targetLoc.getWorld());
        int targetY = targetLoc.getBlockY();
        if (targetY >= minY && targetY <= maxY && this.isSafeLocation(targetLoc)) {
            return this.checkForHalfBlock(targetLoc);
        }
        Location location = null;
        if (targetY < minY) {
            location = targetLoc.clone();
            location.setY((double)minY);
            location = this.findPlaceToStand(location, true, maxUpDelta);
        } else if (targetY > maxY) {
            location = targetLoc.clone();
            location.setY((double)maxY);
            location = this.findPlaceToStand(location, false, maxDownDelta);
        } else {
            int testMaxY = Math.min(maxUpDelta, 3);
            location = this.findPlaceToStand(targetLoc, true, testMaxY);
            if (location == null) {
                int testMinY = Math.min(maxDownDelta, 4);
                location = this.findPlaceToStand(targetLoc, false, testMinY);
            }
            if (location == null) {
                location = this.findPlaceToStand(targetLoc, true, maxUpDelta);
            }
            if (location == null) {
                location = this.findPlaceToStand(targetLoc, false, maxDownDelta);
            }
        }
        return location;
    }

    public Location findPlaceToStand(Location target, boolean goUp) {
        return this.findPlaceToStand(target, goUp, this.verticalSearchDistance);
    }

    public Location findPlaceToStand(Location target, boolean goUp, int maxDelta) {
        int direction = goUp ? 1 : -1;
        Location targetLocation = target.clone();
        boolean minY = true;
        int maxY = CompatibilityUtils.getMaxHeight(targetLocation.getWorld());
        for (int yDelta = 0; (double)minY <= targetLocation.getY() && targetLocation.getY() <= (double)maxY && yDelta < maxDelta; ++yDelta) {
            Block block = targetLocation.getBlock();
            if (this.isSafeLocation(block)) {
                return this.checkForHalfBlock(targetLocation);
            }
            if (!this.allowPassThrough(block.getType())) {
                return null;
            }
            targetLocation.setY(targetLocation.getY() + (double)direction);
        }
        return null;
    }

    protected Location checkForHalfBlock(Location location) {
        boolean isHalfBlock = false;
        Block downBlock = location.getBlock().getRelative(BlockFace.DOWN);
        Material material = downBlock.getType();
        isHalfBlock = material == Material.STEP || material == Material.WOOD_STEP ? downBlock.getData() < 8 : this.isHalfBlock(material);
        if (isHalfBlock) {
            location.setY(location.getY() - 0.5);
        }
        return location;
    }

    public Block getPlayerBlock() {
        Location location = this.getLocation();
        if (location == null) {
            return null;
        }
        return location.getBlock().getRelative(BlockFace.DOWN);
    }

    public BlockFace getPlayerFacing() {
        return BaseSpell.getFacing(this.getLocation());
    }

    public static BlockFace getFacing(Location location) {
        float playerRot;
        for (playerRot = location.getYaw(); playerRot < 0.0f; playerRot += 360.0f) {
        }
        while (playerRot > 360.0f) {
            playerRot -= 360.0f;
        }
        BlockFace direction = BlockFace.NORTH;
        if (playerRot <= 45.0f || playerRot > 315.0f) {
            direction = BlockFace.SOUTH;
        } else if (playerRot > 45.0f && playerRot <= 135.0f) {
            direction = BlockFace.WEST;
        } else if (playerRot > 135.0f && playerRot <= 225.0f) {
            direction = BlockFace.NORTH;
        } else if (playerRot > 225.0f && playerRot <= 315.0f) {
            direction = BlockFace.EAST;
        }
        return direction;
    }

    @Override
    public void castMessage(String message) {
        Wand activeWand = this.mage.getActiveWand();
        if (!this.loud && activeWand != null && !activeWand.showCastMessages()) {
            return;
        }
        if (!this.quiet && this.canSendMessage() && message != null && message.length() > 0) {
            this.mage.castMessage(message);
            this.lastMessageSent = System.currentTimeMillis();
        }
    }

    @Override
    public void sendMessage(String message) {
        Wand activeWand = this.mage.getActiveWand();
        if (!this.loud && activeWand != null && !activeWand.showMessages()) {
            return;
        }
        if (!this.quiet && message != null && message.length() > 0) {
            this.mage.sendMessage(message);
            this.lastMessageSent = System.currentTimeMillis();
        }
    }

    @Override
    public Location getLocation() {
        if (this.location != null) {
            return this.location.clone();
        }
        if (this.mage != null) {
            return this.mage.getLocation();
        }
        return null;
    }

    public Location getWandLocation() {
        if (this.location != null) {
            return this.location.clone();
        }
        return this.mage.getWandLocation();
    }

    @Override
    public Location getEyeLocation() {
        if (this.location != null) {
            return this.location.clone();
        }
        return this.mage.getEyeLocation();
    }

    @Override
    public Vector getDirection() {
        if (this.location == null) {
            return this.mage.getDirection();
        }
        return this.location.getDirection();
    }

    public boolean isLookingUp() {
        Vector direction = this.getDirection();
        if (direction == null) {
            return false;
        }
        return direction.getY() > 0.9;
    }

    public boolean isLookingDown() {
        Vector direction = this.getDirection();
        if (direction == null) {
            return false;
        }
        return direction.getY() < -0.9;
    }

    public World getWorld() {
        Location location = this.getLocation();
        if (location != null) {
            return location.getWorld();
        }
        return null;
    }

    public boolean isUnderwater() {
        Block playerBlock = this.getPlayerBlock();
        if (playerBlock == null) {
            return false;
        }
        return (playerBlock = playerBlock.getRelative(BlockFace.UP)).getType() == Material.WATER || playerBlock.getType() == Material.STATIONARY_WATER;
    }

    protected String getBlockSkin(Material blockType) {
        return this.controller.getBlockSkin(blockType);
    }

    protected String getMobSkin(EntityType mobType) {
        return this.controller.getMobSkin(mobType);
    }

    public static Collection<PotionEffect> getPotionEffects(ConfigurationSection parameters) {
        return BaseSpell.getPotionEffects(parameters, null);
    }

    public static Collection<PotionEffect> getPotionEffects(ConfigurationSection parameters, Integer duration) {
        PotionEffectType[] effectTypes;
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (PotionEffectType effectType : effectTypes = PotionEffectType.values()) {
            String parameterName;
            if (effectType == null || !parameters.contains(parameterName = "effect_" + effectType.getName().toLowerCase())) continue;
            String value = parameters.getString(parameterName);
            int ticks = 10;
            int power = 1;
            try {
                if (value.contains(",")) {
                    String[] pieces = value.split(",");
                    ticks = (int)Float.parseFloat(pieces[0]);
                    power = (int)Float.parseFloat(pieces[1]);
                } else {
                    power = (int)Float.parseFloat(value);
                    if (duration != null) {
                        ticks = duration / 50;
                    }
                }
            }
            catch (Exception ex) {
                Bukkit.getLogger().warning("Error parsing potion effect for " + effectType + ": " + value);
            }
            PotionEffect effect = new PotionEffect(effectType, ticks, power, true);
            effects.add(effect);
        }
        return effects;
    }

    public boolean isInCircle(int x, int z, int R) {
        return x * x + z * z - R * R <= 0;
    }

    private boolean canSendMessage() {
        if (this.lastMessageSent == 0L) {
            return true;
        }
        int throttle = this.controller.getMessageThrottle();
        long now = System.currentTimeMillis();
        return this.lastMessageSent < now - (long)throttle;
    }

    protected Location getEffectLocation() {
        return this.getEyeLocation();
    }

    @Override
    public boolean hasBrushOverride() {
        return false;
    }

    @Override
    public boolean usesBrush() {
        return false;
    }

    @Override
    public boolean usesBrushSelection() {
        return (this.usesBrushSelection || this.usesBrush()) && !this.hasBrushOverride();
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    public void checkActiveCosts() {
        if (this.activeCosts == null) {
            return;
        }
        long now = System.currentTimeMillis();
        this.activeCostScale = (float)((double)(now - this.lastActiveCost) / 1000.0);
        this.lastActiveCost = now;
        for (CastingCost cost : this.activeCosts) {
            if (!cost.has(this)) {
                this.deactivate();
                break;
            }
            cost.use(this);
        }
        this.activeCostScale = 1.0f;
    }

    public void checkActiveDuration() {
        if (this.duration > 0 && this.lastCast < System.currentTimeMillis() - (long)this.duration) {
            this.deactivate();
        }
    }

    protected List<CastingCost> parseCosts(ConfigurationSection node) {
        if (node == null) {
            return null;
        }
        ArrayList<CastingCost> castingCosts = new ArrayList<CastingCost>();
        Set costKeys = node.getKeys(false);
        for (String key : costKeys) {
            castingCosts.add(new CastingCost(key, node.getInt(key, 1)));
        }
        return castingCosts;
    }

    protected void loadTemplate(ConfigurationSection node) {
        String baseKey = this.spellKey.getBaseKey();
        this.name = this.controller.getMessages().get("spells." + baseKey + ".name", baseKey);
        this.description = this.controller.getMessages().get("spells." + baseKey + ".description", "");
        this.extendedDescription = this.controller.getMessages().get("spells." + baseKey + ".extended_description", "");
        this.usage = this.controller.getMessages().get("spells." + baseKey + ".usage", "");
        this.requiredUpgradePath = node.getString("upgrade_required_path");
        this.requiredUpgradeCasts = node.getLong("upgrade_required_casts");
        this.inheritKey = node.getString("inherit");
        this.levelDescription = this.controller.getMessages().get("spells." + baseKey + ".level_description", this.levelDescription);
        this.upgradeDescription = this.controller.getMessages().get("spells." + baseKey + ".upgrade_description", this.upgradeDescription);
        if (this.spellKey.isVariant()) {
            String variantKey = this.spellKey.getKey();
            this.name = this.controller.getMessages().get("spells." + variantKey + ".name", this.name);
            this.description = this.controller.getMessages().get("spells." + variantKey + ".description", this.description);
            this.extendedDescription = this.controller.getMessages().get("spells." + variantKey + ".extended_description", this.extendedDescription);
            this.usage = this.controller.getMessages().get("spells." + variantKey + ".usage", this.usage);
            this.levelDescription = this.controller.getMessages().get("spell.level_description", this.levelDescription);
            this.levelDescription = this.controller.getMessages().get("spells." + variantKey + ".level_description", this.levelDescription);
            this.upgradeDescription = this.controller.getMessages().get("spells." + variantKey + ".upgrade_description", this.upgradeDescription);
        }
        this.name = node.getString("name", this.name);
        this.alias = node.getString("alias", "");
        this.extendedDescription = node.getString("extended_description", this.extendedDescription);
        this.description = node.getString("description", this.description);
        this.levelDescription = node.getString("level_description", this.levelDescription);
        if (this.levelDescription != null && !this.levelDescription.isEmpty()) {
            this.levelDescription = this.levelDescription.replace("$level", Integer.toString(this.spellKey.getLevel()));
        }
        this.icon = ConfigurationUtils.getMaterialAndData(node, "icon", this.icon);
        this.iconURL = node.getString("icon_url");
        this.color = ConfigurationUtils.getColor(node, "color", null);
        this.worth = node.getDouble("worth", 0.0);
        if (node.contains("worth_sp")) {
            this.worth = node.getDouble("worth_sp", 0.0) * this.controller.getWorthSkillPoints();
        }
        this.earns = node.getInt("earns_sp", 0);
        this.earnCooldown = node.getInt("earns_cooldown", 0);
        this.category = this.controller.getCategory(node.getString("category"));
        List<String> tagList = ConfigurationUtils.getStringList(node, "tags");
        this.tags = tagList != null ? new HashSet<String>(tagList) : null;
        this.costs = this.parseCosts(node.getConfigurationSection("costs"));
        this.activeCosts = this.parseCosts(node.getConfigurationSection("active_costs"));
        this.pvpRestricted = node.getBoolean("pvp_restricted", false);
        this.quickCast = node.getBoolean("quick_cast", false);
        this.disguiseRestricted = node.getBoolean("disguise_restricted", true);
        this.worldBorderRestricted = node.getBoolean("world_border_restricted", false);
        this.usesBrushSelection = node.getBoolean("brush_selection", false);
        this.castOnNoTarget = node.getBoolean("cast_on_no_target", true);
        this.hidden = node.getBoolean("hidden", false);
        this.showUndoable = node.getBoolean("show_undoable", true);
        this.cancellable = node.getBoolean("cancellable", true);
        this.parameters = node.getConfigurationSection("parameters");
        if (this.parameters != null) {
            this.bypassMageCooldown = this.parameters.getBoolean("bypass_mage_cooldown", false);
            this.cooldown = this.parameters.getInt("cooldown", 0);
            this.cooldown = this.parameters.getInt("cool", this.cooldown);
            this.mageCooldown = this.parameters.getInt("cooldown_mage", 0);
            this.bypassPvpRestriction = this.parameters.getBoolean("bypass_pvp", false);
            this.bypassPvpRestriction = this.parameters.getBoolean("bp", this.bypassPvpRestriction);
            this.bypassPermissions = this.parameters.getBoolean("bypass_permissions", false);
            this.bypassBuildRestriction = this.parameters.getBoolean("bypass_build", false);
            this.bypassBuildRestriction = this.parameters.getBoolean("bb", this.bypassBuildRestriction);
            this.bypassBreakRestriction = this.parameters.getBoolean("bypass_break", false);
            this.bypassProtection = this.parameters.getBoolean("bypass_protection", false);
            this.bypassProtection = this.parameters.getBoolean("bp", this.bypassProtection);
            this.duration = this.parameters.getInt("duration", 0);
            this.totalDuration = this.parameters.getInt("total_duration", -1);
        }
        this.effects.clear();
        if (node.contains("effects")) {
            ConfigurationSection effectsNode = node.getConfigurationSection("effects");
            Set effectKeys = effectsNode.getKeys(false);
            for (String effectKey : effectKeys) {
                if (effectsNode.isString(effectKey)) {
                    String referenceKey = effectsNode.getString(effectKey);
                    if (!this.effects.containsKey(referenceKey)) continue;
                    this.effects.put(effectKey, new ArrayList<EffectPlayer>(this.effects.get(referenceKey)));
                    continue;
                }
                this.effects.put(effectKey, EffectPlayer.loadEffects(this.controller.getPlugin(), effectsNode, effectKey));
            }
        }
    }

    protected void preCast() {
    }

    protected void reset() {
        Location mageLocation;
        Location location = mageLocation = this.mage != null ? this.mage.getLocation() : null;
        if (this.location != null && mageLocation != null) {
            this.location.setPitch(mageLocation.getPitch());
            this.location.setYaw(mageLocation.getYaw());
        }
        this.backfired = false;
        if (!this.isActive) {
            this.currentCast = null;
        }
    }

    @Override
    public boolean cast(String[] extraParameters, Location defaultLocation) {
        MemoryConfiguration parameters = null;
        if (extraParameters != null && extraParameters.length > 0) {
            parameters = new MemoryConfiguration();
            ConfigurationUtils.addParameters(extraParameters, (ConfigurationSection)parameters);
        }
        return this.cast((ConfigurationSection)parameters, defaultLocation);
    }

    @Override
    public boolean cast(ConfigurationSection parameters) {
        return this.cast(parameters, null);
    }

    @Override
    public boolean cast(ConfigurationSection extraParameters, Location defaultLocation) {
        Set<String> overrides;
        Set keys;
        if (this.mage.isPlayer() && this.mage.getPlayer().getGameMode() == GameMode.SPECTATOR) {
            if (this.mage.getDebugLevel() > 0 && extraParameters != null) {
                this.mage.sendDebugMessage("Cannot cast in spectator mode.");
            }
            return false;
        }
        if (this.mage.getDebugLevel() > 5 && extraParameters != null && (keys = extraParameters.getKeys(false)).size() > 0) {
            this.mage.sendDebugMessage(ChatColor.BLUE + "Cast " + ChatColor.GOLD + this.getName() + " " + ChatColor.GREEN + ConfigurationUtils.getParameters(extraParameters));
        }
        this.reset();
        Location location = this.mage.getLocation();
        if (location != null && (overrides = this.controller.getSpellOverrides(this.mage, location)) != null && !overrides.isEmpty()) {
            if (extraParameters == null) {
                extraParameters = new MemoryConfiguration();
            }
            for (String entry : overrides) {
                String fullKey;
                String[] key;
                String[] pieces = StringUtils.split((String)entry, (char)' ');
                if (pieces.length < 2 || (key = StringUtils.split((String)(fullKey = pieces[0]), (String)".")).length == 0 || key.length == 2 && !key[0].equals("default") && !key[0].equals(this.spellKey.getBaseKey()) && !key[0].equals(this.spellKey.getKey())) continue;
                fullKey = key.length == 2 ? key[1] : key[0];
                ConfigurationUtils.set(extraParameters, fullKey, pieces[1]);
            }
        }
        if (this.currentCast == null) {
            this.currentCast = new com.elmakers.mine.bukkit.action.CastContext();
            this.currentCast.setSpell(this);
        }
        if (this.parameters == null) {
            this.parameters = new MemoryConfiguration();
        }
        this.location = defaultLocation;
        this.workingParameters = new MemoryConfiguration();
        ConfigurationUtils.addConfigurations(this.workingParameters, this.parameters);
        ConfigurationUtils.addConfigurations(this.workingParameters, extraParameters);
        this.processParameters(this.workingParameters);
        PreCastEvent preCast = new PreCastEvent(this.mage, this);
        Bukkit.getPluginManager().callEvent((Event)preCast);
        if (preCast.isCancelled()) {
            this.processResult(SpellResult.CANCELLED, this.workingParameters);
            this.sendCastMessage(SpellResult.CANCELLED, " (no cast)");
            return false;
        }
        this.bypassConfusion = this.workingParameters.getBoolean("bypass_confusion", this.bypassConfusion);
        this.bypassWeakness = this.workingParameters.getBoolean("bypass_weakness", this.bypassWeakness);
        LivingEntity livingEntity = this.mage.getLivingEntity();
        if (livingEntity != null && !this.mage.isSuperPowered()) {
            if (!this.bypassConfusion && livingEntity.hasPotionEffect(PotionEffectType.CONFUSION)) {
                this.processResult(SpellResult.CURSED, this.workingParameters);
                this.sendCastMessage(SpellResult.CURSED, " (no cast)");
                return false;
            }
            if (!this.bypassWeakness && livingEntity.hasPotionEffect(PotionEffectType.WEAKNESS)) {
                this.processResult(SpellResult.CURSED, this.workingParameters);
                this.sendCastMessage(SpellResult.CURSED, " (no cast)");
                return false;
            }
        }
        if (!this.canCast(this.getLocation())) {
            this.processResult(SpellResult.INSUFFICIENT_PERMISSION, this.workingParameters);
            this.sendCastMessage(SpellResult.INSUFFICIENT_PERMISSION, " (no cast)");
            if (this.mage.getDebugLevel() > 1) {
                CommandSender messageTarget = this.mage.getDebugger();
                if (messageTarget == null) {
                    messageTarget = this.mage.getCommandSender();
                }
                if (messageTarget != null) {
                    this.mage.debugPermissions(messageTarget, this);
                }
            }
            return false;
        }
        this.preCast();
        this.bypassPvpRestriction = this.workingParameters.getBoolean("bypass_pvp", false);
        this.bypassPvpRestriction = this.workingParameters.getBoolean("bp", this.bypassPvpRestriction);
        this.bypassPermissions = this.workingParameters.getBoolean("bypass_permissions", this.bypassPermissions);
        this.bypassFriendlyFire = this.workingParameters.getBoolean("bypass_friendly_fire", false);
        this.cooldown = this.workingParameters.getInt("cooldown", this.cooldown);
        this.cooldown = this.workingParameters.getInt("cool", this.cooldown);
        this.mageCooldown = this.workingParameters.getInt("cooldown_mage", this.mageCooldown);
        this.color = ConfigurationUtils.getColor(this.workingParameters, "color", this.color);
        this.particle = this.workingParameters.getString("particle", null);
        double cooldownRemaining = (double)this.getRemainingCooldown() / 1000.0;
        String timeDescription = "";
        if (cooldownRemaining > 0.0) {
            if (cooldownRemaining > 3600.0) {
                long hours = (long)Math.ceil(cooldownRemaining / 3600.0);
                timeDescription = hours == 1L ? this.controller.getMessages().get("cooldown.wait_hour") : this.controller.getMessages().get("cooldown.wait_hours").replace("$hours", Long.valueOf(hours).toString());
            } else if (cooldownRemaining > 60.0) {
                long minutes = (long)Math.ceil(cooldownRemaining / 60.0);
                timeDescription = minutes == 1L ? this.controller.getMessages().get("cooldown.wait_minute") : this.controller.getMessages().get("cooldown.wait_minutes").replace("$minutes", Long.valueOf(minutes).toString());
            } else if (cooldownRemaining > 1.0) {
                long seconds = (long)Math.ceil(cooldownRemaining);
                timeDescription = this.controller.getMessages().get("cooldown.wait_seconds").replace("$seconds", Long.valueOf(seconds).toString());
            } else {
                timeDescription = this.controller.getMessages().get("cooldown.wait_moment");
            }
            this.castMessage(this.getMessage("cooldown").replace("$time", timeDescription));
            this.processResult(SpellResult.COOLDOWN, this.workingParameters);
            this.sendCastMessage(SpellResult.COOLDOWN, " (no cast)");
            return false;
        }
        CastingCost required = this.getRequiredCost();
        if (required != null) {
            String baseMessage = this.getMessage("insufficient_resources");
            String costDescription = required.getDescription(this.controller.getMessages(), this.mage);
            if (required.getAmount() > 0) {
                this.sendMessage(baseMessage.replace("$cost", costDescription));
            } else {
                this.castMessage(baseMessage.replace("$cost", costDescription));
            }
            this.processResult(SpellResult.INSUFFICIENT_RESOURCES, this.workingParameters);
            this.sendCastMessage(SpellResult.INSUFFICIENT_RESOURCES, " (no cast)");
            return false;
        }
        return this.finalizeCast(this.workingParameters);
    }

    @Override
    public boolean canCast(Location location) {
        if (location == null) {
            return true;
        }
        if (!this.hasCastPermission(this.mage.getCommandSender())) {
            return false;
        }
        Entity entity = this.mage.getEntity();
        if (this.disguiseRestricted && entity != null && entity instanceof Player && this.controller.isDisguised(entity)) {
            return false;
        }
        Boolean regionPermission = this.controller.getRegionCastPermission(this.mage.getPlayer(), this, location);
        if (regionPermission != null && regionPermission.booleanValue()) {
            return true;
        }
        Boolean personalPermission = this.controller.getPersonalCastPermission(this.mage.getPlayer(), this, location);
        if (personalPermission != null && personalPermission.booleanValue()) {
            return true;
        }
        if (regionPermission != null && !regionPermission.booleanValue()) {
            return false;
        }
        if (this.requiresBuildPermission() && !this.hasBuildPermission(location.getBlock())) {
            return false;
        }
        if (this.requiresBreakPermission() && !this.hasBreakPermission(location.getBlock())) {
            return false;
        }
        if (this.worldBorderRestricted) {
            WorldBorder border = location.getWorld().getWorldBorder();
            double borderSize = border.getSize() / 2.0 - (double)border.getWarningDistance();
            Location offset = location.subtract(border.getCenter());
            if (offset.getX() < -borderSize || offset.getX() > borderSize || offset.getZ() < -borderSize || offset.getZ() > borderSize) {
                return false;
            }
        }
        return !this.pvpRestricted || this.bypassPvpRestriction || this.mage.isPVPAllowed(location);
    }

    @Override
    public boolean isPvpRestricted() {
        return this.pvpRestricted && !this.bypassPvpRestriction;
    }

    @Override
    public boolean isDisguiseRestricted() {
        return this.disguiseRestricted;
    }

    @Override
    public boolean requiresBuildPermission() {
        return false;
    }

    @Override
    public boolean requiresBreakPermission() {
        return false;
    }

    public boolean hasBreakPermission(Location location) {
        if (location == null) {
            return true;
        }
        return this.hasBreakPermission(location.getBlock());
    }

    public boolean hasBreakPermission(Block block) {
        if (this.bypassBreakRestriction) {
            return true;
        }
        Boolean castPermission = this.controller.getRegionCastPermission(this.mage.getPlayer(), this, block.getLocation());
        if (castPermission != null && castPermission.booleanValue()) {
            return true;
        }
        if (castPermission != null && !castPermission.booleanValue()) {
            return false;
        }
        return this.mage.hasBreakPermission(block);
    }

    public boolean hasBuildPermission(Location location) {
        if (location == null) {
            return true;
        }
        return this.hasBuildPermission(location.getBlock());
    }

    public boolean hasBuildPermission(Block block) {
        if (this.bypassBuildRestriction) {
            return true;
        }
        Boolean castPermission = this.controller.getRegionCastPermission(this.mage.getPlayer(), this, block.getLocation());
        if (castPermission != null && castPermission.booleanValue()) {
            return true;
        }
        if (castPermission != null && !castPermission.booleanValue()) {
            return false;
        }
        return this.mage.hasBuildPermission(block);
    }

    protected void onBackfire() {
    }

    protected void backfire() {
        if (!this.backfired) {
            this.onBackfire();
        }
        this.backfired = true;
    }

    protected boolean finalizeCast(ConfigurationSection parameters) {
        Entity targetEntity;
        LivingEntity sourceEntity;
        SpellResult result = null;
        this.controller.disablePhysics(parameters.getInt("disable_physics", 0));
        if (!this.mage.isSuperPowered()) {
            if (this.backfireChance > 0.0f && random.nextDouble() < (double)this.backfireChance) {
                this.backfire();
            } else if (this.fizzleChance > 0.0f && random.nextDouble() < (double)this.fizzleChance) {
                result = SpellResult.FIZZLE;
            }
        }
        if (result == null) {
            result = this.onCast(parameters);
        }
        if (this.backfired) {
            result = SpellResult.BACKFIRE;
        }
        if (result == SpellResult.CAST && (sourceEntity = this.mage.getLivingEntity()) == (targetEntity = this.getTargetEntity())) {
            result = SpellResult.CAST_SELF;
        }
        this.processResult(result, parameters);
        boolean success = result.isSuccess();
        boolean free = result.isFree(this.castOnNoTarget);
        if (!free) {
            if (this.costs != null && !this.mage.isCostFree()) {
                for (CastingCost cost : this.costs) {
                    if (cost.isItem() && this.currentCast != null) {
                        this.currentCast.getUndoList().setConsumed(true);
                    }
                    cost.use(this);
                }
            }
            this.updateCooldown();
        }
        this.sendCastMessage(result, " (" + success + ")");
        return success;
    }

    protected void updateCooldown() {
        int reducedCooldown;
        Wand wand = this.currentCast != null ? this.currentCast.getWand() : null;
        boolean isCooldownFree = wand != null ? wand.isCooldownFree() : this.mage.isCooldownFree();
        double cooldownReduction = wand != null ? (double)wand.getCooldownReduction() : (double)this.mage.getCooldownReduction();
        cooldownReduction += (double)this.cooldownReduction;
        this.lastCast = System.currentTimeMillis();
        if (!isCooldownFree && this.cooldown > 0 && cooldownReduction < 1.0) {
            reducedCooldown = (int)Math.ceil((1.0 - cooldownReduction) * (double)this.cooldown);
            this.cooldownExpiration = Math.max(this.cooldownExpiration, System.currentTimeMillis() + (long)reducedCooldown);
        }
        if (!isCooldownFree && this.mageCooldown > 0 && cooldownReduction < 1.0) {
            reducedCooldown = (int)Math.ceil((1.0 - cooldownReduction) * (double)this.mageCooldown);
            this.mage.setRemainingCooldown(reducedCooldown);
        }
    }

    protected void sendCastMessage(SpellResult result, String message) {
        Location source = this.getEyeLocation();
        if (this.mage == null || source == null) {
            return;
        }
        this.mage.sendDebugMessage(ChatColor.WHITE + "Cast " + ChatColor.GOLD + this.getName() + ChatColor.WHITE + " from " + ChatColor.GRAY + source.getBlockX() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + source.getBlockY() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + source.getBlockZ() + ChatColor.WHITE + ": " + ChatColor.AQUA + result.name().toLowerCase() + ChatColor.DARK_AQUA + message);
    }

    @Override
    public String getMessage(String messageKey) {
        return this.getMessage(messageKey, "");
    }

    public String getMessage(String messageKey, String def) {
        String playerName;
        String message = this.controller.getMessages().get("spells.default." + messageKey, def);
        if (this.inheritKey != null && !this.inheritKey.isEmpty()) {
            message = this.controller.getMessages().get("spells." + this.inheritKey + "." + messageKey, message);
        }
        message = this.controller.getMessages().get("spells." + this.spellKey.getBaseKey() + "." + messageKey, message);
        if (this.spellKey.isVariant()) {
            message = this.controller.getMessages().get("spells." + this.spellKey.getKey() + "." + messageKey, message);
        }
        if (message == null) {
            message = "";
        } else if (!message.isEmpty() && (message = message.replace("$player", playerName = this.mage.getName())).contains("$material")) {
            String materialName = this.getDisplayMaterialName();
            materialName = materialName == null ? "None" : materialName;
            message = message.replace("$material", materialName);
        }
        return message;
    }

    protected String getDisplayMaterialName() {
        return "None";
    }

    protected void processResult(SpellResult result, ConfigurationSection parameters) {
        if (this.mage != null) {
            this.mage.onCast(this, result);
        }
        String resultName = result.name().toLowerCase();
        if (!this.mage.isQuiet()) {
            if (result.isSuccess()) {
                String message = null;
                if (result != SpellResult.CAST) {
                    message = this.getMessage("cast");
                }
                if (result.isAlternate() && result != SpellResult.ALTERNATE) {
                    message = this.getMessage("alternate", message);
                }
                message = this.getMessage(resultName, message);
                LivingEntity sourceEntity = this.mage.getLivingEntity();
                Entity targetEntity = this.getTargetEntity();
                if (targetEntity == sourceEntity) {
                    message = this.getMessage("cast_self", message);
                } else if (targetEntity instanceof Player) {
                    message = this.getMessage("cast_player", message);
                } else if (targetEntity instanceof LivingEntity) {
                    message = this.getMessage("cast_livingentity", message);
                } else if (targetEntity instanceof Entity) {
                    message = this.getMessage("cast_entity", message);
                }
                if (this.loud) {
                    this.sendMessage(message);
                } else {
                    this.castMessage(message);
                }
            } else if (result != SpellResult.INSUFFICIENT_RESOURCES && result != SpellResult.COOLDOWN) {
                String message = null;
                if (result.isFailure() && result != SpellResult.FAIL) {
                    message = this.getMessage("fail");
                }
                this.sendMessage(this.getMessage(resultName, message));
            }
        }
        this.playEffects(resultName);
        if (this.currentCast != null) {
            if (this.isLegacy()) {
                this.currentCast.addResult(result);
            }
            if (!this.isBatched()) {
                this.currentCast.finish();
            }
        }
    }

    protected boolean isBatched() {
        return false;
    }

    protected boolean isLegacy() {
        return true;
    }

    @Override
    public void messageTargets(String messageKey) {
        if (this.messageTargets && this.currentCast != null) {
            this.currentCast.messageTargets(messageKey);
        }
    }

    public void playEffects(String effectName, float scale, Block sourceBlock) {
        this.playEffects(effectName, this.getCurrentCast(), scale, sourceBlock);
    }

    public void playEffects(String effectName, float scale) {
        this.playEffects(effectName, this.getCurrentCast(), scale, null);
    }

    @Override
    public void playEffects(String effectName) {
        this.playEffects(effectName, 1.0f);
    }

    @Override
    public void playEffects(String effectName, CastContext context) {
        this.playEffects(effectName, context, 1.0f);
    }

    public void playEffects(String effectName, CastContext context, float scale, Block block) {
        context.playEffects(effectName, scale, block);
    }

    @Override
    public void playEffects(String effectName, CastContext context, float scale) {
        this.playEffects(effectName, context, scale, null);
    }

    @Override
    public void target() {
    }

    @Override
    public Location getTargetLocation() {
        return null;
    }

    @Override
    public boolean canTarget(Entity entity) {
        Player magePlayer;
        if (!this.bypassPvpRestriction && entity instanceof Player && (magePlayer = this.mage.getPlayer()) != null) {
            if (!this.controller.isPVPAllowed(magePlayer, entity.getLocation())) {
                return false;
            }
            if (!this.controller.isPVPAllowed(magePlayer, this.mage.getLocation())) {
                return false;
            }
        }
        if (!this.bypassProtection && !this.bypassFriendlyFire) {
            return this.controller.canTarget(this.mage.getEntity(), entity);
        }
        return true;
    }

    @Override
    public Entity getTargetEntity() {
        return null;
    }

    @Override
    public MaterialAndData getEffectMaterial() {
        return new com.elmakers.mine.bukkit.block.MaterialAndData(DEFAULT_EFFECT_MATERIAL);
    }

    public void processParameters(ConfigurationSection parameters) {
        this.fizzleChance = (float)parameters.getDouble("fizzle_chance", 0.0);
        this.backfireChance = (float)parameters.getDouble("backfire_chance", 0.0);
        Location defaultLocation = this.location == null ? this.mage.getLocation() : this.location;
        Location locationOverride = ConfigurationUtils.overrideLocation(parameters, "p", defaultLocation, this.controller.canCreateWorlds());
        if (locationOverride != null) {
            this.location = locationOverride;
        }
        this.costReduction = (float)parameters.getDouble("cost_reduction", 0.0);
        this.consumeReduction = (float)parameters.getDouble("consume_reduction", 0.0);
        this.cooldownReduction = (float)parameters.getDouble("cooldown_reduction", 0.0);
        this.bypassMageCooldown = parameters.getBoolean("bypass_mage_cooldown", false);
        this.cancelOnDamage = parameters.getDouble("cancel_on_damage", 0.0);
        this.preventPassThroughMaterials = parameters.contains("prevent_passthrough") ? this.controller.getMaterialSet(parameters.getString("prevent_passthrough")) : this.controller.getMaterialSet("indestructible");
        this.passthroughMaterials = parameters.contains("passthrough") ? this.controller.getMaterialSet(parameters.getString("passthrough")) : this.controller.getMaterialSet("passthrough");
        this.unsafeMaterials = parameters.contains("unsafe") ? this.controller.getMaterialSet(parameters.getString("unsafe")) : this.controller.getMaterialSet("unsafe");
        this.bypassDeactivate = parameters.getBoolean("bypass_deactivate", false);
        this.quiet = parameters.getBoolean("quiet", false);
        this.loud = parameters.getBoolean("loud", false);
        this.targetSelf = parameters.getBoolean("target_self", false);
        this.messageTargets = parameters.getBoolean("message_targets", true);
        this.verticalSearchDistance = parameters.getInt("vertical_range", 8);
        this.trackCasts = parameters.getBoolean("track_casts", true);
        this.cooldown = parameters.getInt("cooldown", 0);
        this.cooldown = parameters.getInt("cool", this.cooldown);
        this.bypassPvpRestriction = parameters.getBoolean("bypass_pvp", false);
        this.bypassPvpRestriction = parameters.getBoolean("bp", this.bypassPvpRestriction);
        this.bypassPermissions = parameters.getBoolean("bypass_permissions", false);
        this.bypassBuildRestriction = parameters.getBoolean("bypass_build", false);
        this.bypassBuildRestriction = parameters.getBoolean("bb", this.bypassBuildRestriction);
        this.bypassBreakRestriction = parameters.getBoolean("bypass_break", false);
        this.bypassProtection = parameters.getBoolean("bypass_protection", false);
        this.bypassProtection = parameters.getBoolean("bp", this.bypassProtection);
        this.duration = parameters.getInt("duration", 0);
        this.totalDuration = parameters.getInt("total_duration", 0);
    }

    @Override
    public String getPermissionNode() {
        return "Magic.cast." + this.spellKey.getBaseKey();
    }

    public boolean onCancel() {
        return false;
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
    }

    public void onPlayerDeath(EntityDeathEvent event) {
    }

    public void onPlayerDamage(EntityDamageEvent event) {
    }

    @Override
    public void initialize(MageController instance) {
        this.controller = instance;
    }

    @Override
    public long getCastCount() {
        return this.castCount;
    }

    @Override
    public void setCastCount(long count) {
        this.castCount = count;
    }

    public void onActivate() {
    }

    public void onDeactivate() {
    }

    public void onLoad(ConfigurationSection node) {
    }

    public void onSave(ConfigurationSection node) {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    @Override
    public float getConsumeReduction() {
        CostReducer reducer = this.currentCast != null ? this.currentCast.getWand() : this.mage;
        return this.consumeReduction + reducer.getConsumeReduction();
    }

    @Override
    public float getCostReduction() {
        CostReducer reducer = this.currentCast != null ? this.currentCast.getWand() : this.mage;
        return this.costReduction + reducer.getCostReduction();
    }

    @Override
    public float getCostScale() {
        return this.activeCostScale;
    }

    @Override
    public Spell createSpell() {
        BaseSpell spell = null;
        try {
            spell = (BaseSpell)this.getClass().newInstance();
            spell.initialize(this.controller);
            spell.loadTemplate(this.spellKey.getKey(), this.configuration);
            spell.template = this;
        }
        catch (Throwable ex) {
            this.controller.getLogger().log(Level.WARNING, "Error creating spell " + this.spellKey.getKey(), ex);
        }
        return spell;
    }

    @Override
    public boolean cast() {
        return this.cast((ConfigurationSection)null, null);
    }

    @Override
    public boolean cast(String[] extraParameters) {
        return this.cast(extraParameters, null);
    }

    @Override
    public final String getKey() {
        return this.spellKey.getKey();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getAlias() {
        return this.alias;
    }

    @Override
    public boolean isQuickCast() {
        return this.quickCast;
    }

    @Override
    public final MaterialAndData getIcon() {
        return this.icon;
    }

    @Override
    public boolean hasIcon() {
        return this.icon != null && this.icon.getMaterial() != Material.AIR;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final String getExtendedDescription() {
        return this.extendedDescription;
    }

    @Override
    public final String getLevelDescription() {
        return this.levelDescription;
    }

    @Override
    public final SpellKey getSpellKey() {
        return this.spellKey;
    }

    @Override
    public final String getUsage() {
        return this.usage;
    }

    @Override
    public final double getWorth() {
        return this.worth;
    }

    @Override
    public final double getEarns() {
        return this.earns;
    }

    @Override
    public final SpellCategory getCategory() {
        return this.category;
    }

    @Override
    public boolean hasTag(String tag) {
        if (this.category != null && this.category.getKey().equals(tag)) {
            return true;
        }
        return this.tags != null && this.tags.contains(tag);
    }

    @Override
    public boolean hasAnyTag(Collection<String> tagSet) {
        if (this.category != null && tagSet.contains(this.category.getKey())) {
            return true;
        }
        return this.tags != null && !Collections.disjoint(tagSet, this.tags);
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> getEffects(SpellResult result) {
        return this.getEffects(result.name().toLowerCase());
    }

    public boolean hasEffects(String key) {
        Collection<EffectPlayer> effectList = this.effects.get(key);
        return effectList != null && effectList.size() > 0;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> getEffects(String key) {
        Collection<EffectPlayer> effectList = this.effects.get(key);
        if (effectList == null) {
            return new ArrayList<com.elmakers.mine.bukkit.api.effect.EffectPlayer>();
        }
        return new ArrayList<com.elmakers.mine.bukkit.api.effect.EffectPlayer>(effectList);
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.spell.CastingCost> getCosts() {
        if (this.costs == null) {
            return null;
        }
        ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost> copy = new ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost>();
        copy.addAll(this.costs);
        return copy;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.spell.CastingCost> getActiveCosts() {
        if (this.activeCosts == null) {
            return null;
        }
        ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost> copy = new ArrayList<com.elmakers.mine.bukkit.api.spell.CastingCost>();
        copy.addAll(this.activeCosts);
        return copy;
    }

    @Override
    public ConfigurationSection getWorkingParameters() {
        return this.workingParameters;
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        parameters.addAll(Arrays.asList(COMMON_PARAMETERS));
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        if (parameterKey.equals("duration")) {
            examples.addAll(Arrays.asList(EXAMPLE_DURATIONS));
        } else if (parameterKey.equals("range")) {
            examples.addAll(Arrays.asList(EXAMPLE_SIZES));
        } else if (parameterKey.equals("transparent")) {
            examples.addAll(this.controller.getMaterialSets());
        } else if (parameterKey.equals("player")) {
            examples.addAll(this.controller.getPlayerNames());
        } else if (parameterKey.equals("target")) {
            TargetType[] targetTypes;
            for (TargetType targetType : targetTypes = TargetType.values()) {
                examples.add(targetType.name().toLowerCase());
            }
        } else if (parameterKey.equals("target")) {
            TargetType[] targetTypes;
            for (TargetType targetType : targetTypes = TargetType.values()) {
                examples.add(targetType.name().toLowerCase());
            }
        } else if (parameterKey.equals("target_type")) {
            EntityType[] entityTypes;
            for (EntityType entityType : entityTypes = EntityType.values()) {
                examples.add(entityType.name().toLowerCase());
            }
        } else if (booleanParameterMap.contains(parameterKey)) {
            examples.addAll(Arrays.asList(EXAMPLE_BOOLEANS));
        } else if (vectorParameterMap.contains(parameterKey)) {
            examples.addAll(Arrays.asList(EXAMPLE_VECTOR_COMPONENTS));
        } else if (worldParameterMap.contains(parameterKey)) {
            List worlds = Bukkit.getWorlds();
            for (World world : worlds) {
                examples.add(world.getName());
            }
        } else if (percentageParameterMap.contains(parameterKey)) {
            examples.addAll(Arrays.asList(EXAMPLE_PERCENTAGES));
        }
    }

    @Override
    public String getMageCooldownDescription() {
        return BaseSpell.getCooldownDescription(this.controller.getMessages(), this.mageCooldown);
    }

    @Override
    public String getCooldownDescription() {
        return BaseSpell.getCooldownDescription(this.controller.getMessages(), this.cooldown);
    }

    public static String getCooldownDescription(Messages messages, int cooldown) {
        if (cooldown > 0) {
            int cooldownInSeconds = cooldown / 1000;
            if (cooldownInSeconds > 3600) {
                int hours = cooldownInSeconds / 3600;
                if (hours == 1) {
                    return messages.get("cooldown.description_hour");
                }
                return messages.get("cooldown.description_hours").replace("$hours", Integer.valueOf(hours).toString());
            }
            if (cooldownInSeconds > 60) {
                int minutes = cooldownInSeconds / 60;
                if (minutes == 1) {
                    return messages.get("cooldown.description_minute");
                }
                return messages.get("cooldown.description_minutes").replace("$minutes", Integer.valueOf(minutes).toString());
            }
            if (cooldownInSeconds > 1) {
                return messages.get("cooldown.description_seconds").replace("$seconds", Integer.valueOf(cooldownInSeconds).toString());
            }
            return messages.get("cooldown.description_moment");
        }
        return null;
    }

    @Override
    public long getCooldown() {
        return this.cooldown;
    }

    @Override
    public CastingCost getRequiredCost() {
        if (!this.mage.isCostFree() && this.costs != null && !this.isActive) {
            for (CastingCost cost : this.costs) {
                if (cost.has(this)) continue;
                return cost;
            }
        }
        return null;
    }

    @Override
    public void clearCooldown() {
        this.cooldownExpiration = 0L;
    }

    @Override
    public void setRemainingCooldown(long ms) {
        this.cooldownExpiration = Math.max(ms + System.currentTimeMillis(), this.cooldownExpiration);
    }

    @Override
    public long getRemainingCooldown() {
        long remaining = 0L;
        if (this.mage.isCooldownFree()) {
            return 0L;
        }
        if (this.cooldownExpiration > 0L) {
            long now = System.currentTimeMillis();
            if (this.cooldownExpiration > now) {
                remaining = this.cooldownExpiration - now;
            } else {
                this.cooldownExpiration = 0L;
            }
        }
        return this.bypassMageCooldown ? remaining : Math.max(this.mage.getRemainingCooldown(), remaining);
    }

    @Override
    public long getDuration() {
        if (this.totalDuration >= 0) {
            return this.totalDuration;
        }
        return this.duration;
    }

    @Override
    public int getRange() {
        return 0;
    }

    @Override
    public void setMage(Mage mage) {
        this.mage = mage;
    }

    @Override
    public boolean cancel() {
        boolean cancelled = this.onCancel();
        if (cancelled) {
            this.sendMessage(this.getMessage("cancel"));
        }
        if (this.currentCast != null) {
            this.currentCast.cancelEffects();
        }
        return cancelled;
    }

    @Override
    public void setActive(boolean active) {
        if (active && !this.isActive) {
            this.onActivate();
        } else if (!active && this.isActive) {
            this.onDeactivate();
        }
        this.isActive = active;
        this.lastActiveCost = System.currentTimeMillis();
    }

    @Override
    public void activate() {
        if (!this.isActive) {
            this.mage.activateSpell(this);
        }
    }

    @Override
    public boolean deactivate() {
        this.updateCooldown();
        return this.deactivate(false, false);
    }

    @Override
    public boolean deactivate(boolean force, boolean quiet) {
        if (!force && this.bypassDeactivate) {
            return false;
        }
        if (this.isActive) {
            this.isActive = false;
            this.onDeactivate();
            this.mage.deactivateSpell(this);
            if (!quiet) {
                this.sendMessage(this.getMessage("deactivate"));
            }
            if (this.currentCast != null) {
                this.currentCast.cancelEffects();
            }
        }
        return true;
    }

    @Override
    public Mage getMage() {
        return this.mage;
    }

    @Override
    public void load(SpellData spellData) {
        try {
            this.castCount = spellData.getCastCount();
            this.lastCast = spellData.getLastCast();
            this.lastEarn = spellData.getLastEarn();
            this.cooldownExpiration = spellData.getCooldownExpiration();
            if (this.category != null && this.template == null) {
                this.category.addCasts(this.castCount, this.lastCast);
            }
            this.onLoad(spellData.getExtraData());
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().warning("Failed to load data for spell " + this.name + ": " + ex.getMessage());
        }
    }

    @Override
    public void save(SpellData spellData) {
        try {
            spellData.setCastCount(this.castCount);
            spellData.setLastCast(this.lastCast);
            spellData.setLastEarn(this.lastEarn);
            spellData.setCooldownExpiration(this.cooldownExpiration);
            spellData.setIsActive(this.isActive);
            this.onSave(spellData.getExtraData());
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().warning("Failed to save data for spell " + this.name);
            ex.printStackTrace();
        }
    }

    @Override
    public void loadTemplate(String key, ConfigurationSection node) {
        this.spellKey = new SpellKey(key);
        this.configuration = node;
        this.loadTemplate(node);
    }

    @Override
    public void tick() {
        this.checkActiveDuration();
        this.checkActiveCosts();
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public int compareTo(SpellTemplate other) {
        return this.name.compareTo(other.getName());
    }

    @Override
    public boolean hasCastPermission(CommandSender sender) {
        if (sender == null || this.bypassPermissions) {
            return true;
        }
        return this.controller.hasCastPermission(sender, this);
    }

    @Override
    public Color getColor() {
        if (this.color != null) {
            return this.color;
        }
        if (this.category != null) {
            return this.category.getColor();
        }
        return null;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public abstract SpellResult onCast(ConfigurationSection var1);

    @Override
    public MageController getController() {
        return this.controller;
    }

    @Override
    public String getIconURL() {
        return this.iconURL;
    }

    @Override
    public String getRequiredUpgradePath() {
        return this.requiredUpgradePath;
    }

    @Override
    public long getRequiredUpgradeCasts() {
        return this.requiredUpgradeCasts;
    }

    @Override
    public String getUpgradeDescription() {
        return this.upgradeDescription == null ? "" : this.upgradeDescription;
    }

    @Override
    public SpellTemplate getUpgrade() {
        if (this.requiredUpgradeCasts <= 0L && (this.requiredUpgradePath == null || this.requiredUpgradePath.isEmpty())) {
            return null;
        }
        SpellKey upgradeKey = new SpellKey(this.spellKey.getBaseKey(), this.spellKey.getLevel() + 1);
        return this.controller.getSpellTemplate(upgradeKey.getKey());
    }

    @Override
    public ConfigurationSection getConfiguration() {
        return this.configuration;
    }

    @Override
    public CastContext getCurrentCast() {
        if (this.currentCast == null) {
            this.currentCast = new com.elmakers.mine.bukkit.action.CastContext();
            this.currentCast.setSpell(this);
        }
        return this.currentCast;
    }

    @Override
    public Entity getEntity() {
        return this.mage.getEntity();
    }

    @Override
    public String getEffectParticle() {
        if (this.particle == null) {
            return this.mage.getEffectParticleName();
        }
        return this.particle;
    }

    @Override
    public Color getEffectColor() {
        if (this.color == null) {
            return this.mage.getEffectColor();
        }
        return this.color;
    }

    @Override
    public boolean showUndoable() {
        return this.showUndoable;
    }

    public int getVerticalSearchDistance() {
        return this.verticalSearchDistance;
    }

    @Override
    public void addLore(Messages messages, Mage mage, Wand wand, List<String> lore) {
        String earnsText;
        String brushText;
        long effectiveDuration;
        int range;
        String mageCooldownDescription;
        String cooldownDescription;
        String quickCastText;
        CostReducer reducer;
        CostReducer costReducer = reducer = wand == null ? mage : wand;
        if (this.levelDescription != null && this.levelDescription.length() > 0) {
            InventoryUtils.wrapText(ChatColor.GOLD + this.levelDescription, MAX_LORE_LENGTH, lore);
        }
        if (this.description != null && this.description.length() > 0) {
            InventoryUtils.wrapText(this.description, MAX_LORE_LENGTH, lore);
        }
        if (this.usage != null && this.usage.length() > 0) {
            InventoryUtils.wrapText(this.usage, MAX_LORE_LENGTH, lore);
        }
        if (this.quickCast && wand != null && !wand.isQuickCastDisabled() && !(quickCastText = messages.get("spell.quick_cast", "")).isEmpty()) {
            lore.add(quickCastText);
        }
        if ((cooldownDescription = this.getCooldownDescription()) != null && !cooldownDescription.isEmpty()) {
            lore.add(messages.get("cooldown.description").replace("$time", cooldownDescription));
        }
        if ((mageCooldownDescription = this.getMageCooldownDescription()) != null && !mageCooldownDescription.isEmpty()) {
            lore.add(messages.get("cooldown.mage_description").replace("$time", mageCooldownDescription));
        }
        if (this.costs != null) {
            for (com.elmakers.mine.bukkit.api.spell.CastingCost castingCost : this.costs) {
                if (!castingCost.hasCosts(reducer)) continue;
                lore.add(ChatColor.YELLOW + messages.get("wand.costs_description").replace("$description", castingCost.getFullDescription(messages, reducer)));
            }
        }
        if (this.activeCosts != null) {
            for (com.elmakers.mine.bukkit.api.spell.CastingCost castingCost : this.activeCosts) {
                if (!castingCost.hasCosts(reducer)) continue;
                lore.add(ChatColor.YELLOW + messages.get("wand.active_costs_description").replace("$description", castingCost.getFullDescription(messages, reducer)));
            }
        }
        if ((range = this.getRange()) > 0) {
            lore.add(ChatColor.GRAY + messages.get("wand.range_description").replace("$range", Integer.toString(range)));
        }
        if ((effectiveDuration = this.getDuration()) > 0L) {
            long seconds = effectiveDuration / 1000L;
            if (seconds > 3600L) {
                long hours = seconds / 3600L;
                lore.add(ChatColor.GRAY + messages.get("duration.lasts_hours").replace("$hours", Long.valueOf(hours).toString()));
            } else if (seconds > 60L) {
                long minutes = seconds / 60L;
                lore.add(ChatColor.GRAY + messages.get("duration.lasts_minutes").replace("$minutes", Long.valueOf(minutes).toString()));
            } else {
                lore.add(ChatColor.GRAY + messages.get("duration.lasts_seconds").replace("$seconds", Long.valueOf(seconds).toString()));
            }
        } else if (this.showUndoable()) {
            String undoableText;
            if (this.isUndoable()) {
                undoableText = messages.get("spell.undoable", "");
                if (!undoableText.isEmpty()) {
                    lore.add(undoableText);
                }
            } else {
                undoableText = messages.get("spell.not_undoable", "");
                if (!undoableText.isEmpty()) {
                    lore.add(undoableText);
                }
            }
        }
        if (this.usesBrush() && !(brushText = messages.get("spell.brush")).isEmpty()) {
            lore.add(ChatColor.GOLD + brushText);
        }
        if (this.earns > 0 && this.controller.isSPEnabled() && !(earnsText = messages.get("spell.earns").replace("$earns", Integer.toString(this.earns))).isEmpty()) {
            lore.add(earnsText);
        }
    }

    @Override
    public MaterialBrush getBrush() {
        if (this.mage == null) {
            return null;
        }
        return this.mage.getBrush();
    }

    @Override
    public boolean isCancellable() {
        return this.cancellable;
    }

    @Override
    public void finish(CastContext context) {
        boolean free;
        SpellResult result = context.getResult();
        CastEvent castEvent = new CastEvent(this.mage, this, result);
        Bukkit.getPluginManager().callEvent((Event)castEvent);
        if (result.isSuccess() && !this.mage.isQuiet()) {
            this.messageTargets("cast_player_message");
        }
        if (free = result.isFree(this.castOnNoTarget)) {
            this.clearCooldown();
        }
        if (result.isSuccess() && this.trackCasts) {
            Wand wand;
            WandUpgradePath path;
            ++this.castCount;
            if (this.template != null) {
                ++this.template.castCount;
            }
            WandUpgradePath wandUpgradePath = path = (wand = context.getWand()) == null ? null : wand.getPath();
            if (this.earns > 0 && wand != null && path != null && path.earnsSP() && this.controller.isSPEnabled() && !this.mage.isAtMaxSkillPoints()) {
                long now = System.currentTimeMillis();
                int scaledEarn = this.earns;
                if (this.lastEarn > 0L && this.earnCooldown > 0 && now < this.lastEarn + (long)this.earnCooldown) {
                    scaledEarn = (int)Math.floor((double)this.earns * (double)(now - this.lastEarn) / (double)this.earnCooldown);
                    if (scaledEarn > 0) {
                        context.playEffects("earn_scaled_sp");
                    }
                } else {
                    context.playEffects("earn_sp");
                }
                if (scaledEarn > 0) {
                    this.mage.addSkillPoints(scaledEarn);
                    this.lastEarn = now;
                }
            }
            if (wand != null && !wand.isLocked() && this.controller.isSpellUpgradingEnabled() && wand.getSpellLevel(this.spellKey.getKey()) == this.spellKey.getLevel()) {
                SpellTemplate upgrade = this.getUpgrade();
                long requiredCasts = this.getRequiredUpgradeCasts();
                if (upgrade != null && requiredCasts > 0L && this.getCastCount() >= requiredCasts) {
                    String upgradePath = this.getRequiredUpgradePath();
                    WandUpgradePath currentPath = wand.getPath();
                    if (upgradePath == null || upgradePath.isEmpty() || currentPath != null && currentPath.hasPath(upgradePath)) {
                        MageSpell newSpell = this.mage.getSpell(upgrade.getKey());
                        if (this.isActive()) {
                            this.deactivate(true, true);
                            if (newSpell != null && newSpell instanceof MageSpell) {
                                newSpell.activate();
                            }
                        }
                        wand.addSpell(upgrade.getKey());
                        Messages messages = this.controller.getMessages();
                        String levelDescription = upgrade.getLevelDescription();
                        if (levelDescription == null || levelDescription.isEmpty()) {
                            levelDescription = upgrade.getName();
                        }
                        this.playEffects("upgrade");
                        this.mage.sendMessage(messages.get("wand.spell_upgraded").replace("$name", upgrade.getName()).replace("$wand", this.getName()).replace("$level", levelDescription));
                        this.mage.sendMessage(upgrade.getUpgradeDescription().replace("$name", upgrade.getName()));
                        SpellUpgradeEvent upgradeEvent = new SpellUpgradeEvent(this.mage, wand, this, newSpell);
                        Bukkit.getPluginManager().callEvent((Event)upgradeEvent);
                    }
                }
            }
        }
    }

    public boolean getTargetsCaster() {
        return this.targetSelf;
    }

    public void setTargetsCaster(boolean target) {
        this.targetSelf = target;
    }

    @Override
    public double cancelOnDamage() {
        return this.cancelOnDamage;
    }

    @Override
    public ConfigurationSection getHandlerParameters(String handlerKey) {
        return null;
    }

    @Override
    public boolean hasHandlerParameters(String handlerKey) {
        return false;
    }
}

