/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.event.WandUpgradeEvent;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.PrerequisiteSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class WandUpgradePath
implements com.elmakers.mine.bukkit.api.wand.WandUpgradePath {
    private static Map<String, WandUpgradePath> paths = new HashMap<String, WandUpgradePath>();
    private TreeMap<Integer, WandLevel> levelMap = null;
    private Map<String, Collection<EffectPlayer>> effects = new HashMap<String, Collection<EffectPlayer>>();
    private List<String> upgradeCommands;
    private int[] levels = null;
    private final String key;
    private final WandUpgradePath parent;
    private final Set<String> spells = new HashSet<String>();
    private final Set<String> extraSpells = new HashSet<String>();
    private Collection<PrerequisiteSpell> requiredSpells = new HashSet<PrerequisiteSpell>();
    private Set<String> requiredSpellKeys = new HashSet<String>();
    private final Set<String> allSpells = new HashSet<String>();
    private final Set<String> allExtraSpells = new HashSet<String>();
    private final Set<String> allRequiredSpells = new HashSet<String>();
    private String upgradeKey;
    private String upgradeItemKey;
    private String name;
    private String description;
    private String followsPath;
    private Set<String> tags;
    private boolean hidden = false;
    private boolean earnsSP = true;
    private com.elmakers.mine.bukkit.block.MaterialAndData icon;
    private com.elmakers.mine.bukkit.block.MaterialAndData migrateIcon;
    private boolean matchSpellMana = true;
    private int maxUses = 500;
    private int maxMaxMana = 1500;
    private int maxManaRegeneration = 150;
    private float maxDamageReduction = 0.4f;
    private float maxDamageReductionExplosions = 0.3f;
    private float maxDamageReductionFalling = 0.9f;
    private float maxDamageReductionFire = 0.5f;
    private float maxDamageReductionPhysical = 0.1f;
    private float maxDamageReductionProjectiles = 0.2f;
    private float maxCostReduction = 0.5f;
    private float maxCooldownReduction = 0.5f;
    private float maxPower = 1.0f;
    private int minLevel = 10;
    private int maxLevel = 50;
    private float bonusLevelMultiplier = 0.5f;

    public WandUpgradePath(MageController controller, String key, WandUpgradePath inherit, ConfigurationSection template) {
        this.parent = inherit;
        this.key = key;
        this.levels = inherit.levels;
        this.maxMaxMana = inherit.maxMaxMana;
        this.maxManaRegeneration = inherit.maxManaRegeneration;
        this.maxDamageReduction = inherit.maxDamageReduction;
        this.maxDamageReductionExplosions = inherit.maxDamageReductionExplosions;
        this.maxDamageReductionFalling = inherit.maxDamageReductionFalling;
        this.maxDamageReductionFire = inherit.maxDamageReductionFire;
        this.maxDamageReductionPhysical = inherit.maxDamageReductionPhysical;
        this.maxDamageReductionProjectiles = inherit.maxDamageReductionProjectiles;
        this.maxCostReduction = inherit.maxCostReduction;
        this.maxPower = inherit.maxPower;
        this.minLevel = inherit.minLevel;
        this.maxLevel = inherit.maxLevel;
        this.matchSpellMana = inherit.matchSpellMana;
        this.earnsSP = inherit.earnsSP;
        this.levelMap = new TreeMap<Integer, WandLevel>((SortedMap<Integer, WandLevel>)inherit.levelMap);
        this.icon = inherit.icon;
        this.migrateIcon = inherit.migrateIcon;
        this.effects.putAll(inherit.effects);
        this.allRequiredSpells.addAll(inherit.allRequiredSpells);
        this.allSpells.addAll(inherit.allSpells);
        this.allExtraSpells.addAll(inherit.allExtraSpells);
        if (inherit.tags != null && !inherit.tags.isEmpty()) {
            this.tags = new HashSet<String>(inherit.tags);
        }
        this.load(controller, key, template);
        if ((this.upgradeCommands == null || this.upgradeCommands.size() == 0) && inherit.upgradeCommands != null) {
            this.upgradeCommands = new ArrayList<String>();
            this.upgradeCommands.addAll(inherit.upgradeCommands);
        }
    }

    public WandUpgradePath(MageController controller, String key, ConfigurationSection template) {
        this.key = key;
        this.parent = null;
        this.tags = null;
        this.load(controller, key, template);
    }

    protected void load(MageController controller, String key, ConfigurationSection template) {
        Collection<PrerequisiteSpell> pathSpells = ConfigurationUtils.getPrerequisiteSpells(template, "spells");
        for (PrerequisiteSpell prereq : pathSpells) {
            if (controller.getSpellTemplate(prereq.getSpellKey().getKey()) != null) {
                this.spells.add(prereq.getSpellKey().getKey());
                continue;
            }
            controller.getLogger().warning("Unknown or disabled spell " + prereq.getSpellKey().getKey() + " in enchanting path " + key + ", ignoring");
        }
        this.allSpells.addAll(this.spells);
        Collection<PrerequisiteSpell> pathExtraSpells = ConfigurationUtils.getPrerequisiteSpells(template, "extra_spells");
        for (PrerequisiteSpell prereq : pathExtraSpells) {
            if (controller.getSpellTemplate(prereq.getSpellKey().getKey()) != null) {
                this.extraSpells.add(prereq.getSpellKey().getKey());
                continue;
            }
            controller.getLogger().warning("Unknown or disabled spell " + prereq.getSpellKey().getKey() + " in enchanting path " + key + ", ignoring");
        }
        this.allExtraSpells.addAll(this.extraSpells);
        this.followsPath = template.getString("follows");
        this.upgradeKey = template.getString("upgrade");
        this.upgradeItemKey = template.getString("upgrade_item");
        Collection<PrerequisiteSpell> prerequisiteSpells = ConfigurationUtils.getPrerequisiteSpells(template, "required_spells");
        this.requiredSpells = new ArrayList<PrerequisiteSpell>(pathSpells.size() + prerequisiteSpells.size());
        this.requiredSpells.addAll(pathSpells);
        this.requiredSpells.addAll(prerequisiteSpells);
        this.requiredSpellKeys = new HashSet<String>(prerequisiteSpells.size());
        for (PrerequisiteSpell prereq : prerequisiteSpells) {
            this.requiredSpellKeys.add(prereq.getSpellKey().getKey());
            this.allRequiredSpells.add(prereq.getSpellKey().getKey());
        }
        this.icon = ConfigurationUtils.getMaterialAndData(template, "icon");
        this.migrateIcon = ConfigurationUtils.getMaterialAndData(template, "migrate_icon");
        for (PrerequisiteSpell requiredSpell : this.requiredSpells) {
            SpellTemplate spell = controller.getSpellTemplate(requiredSpell.getSpellKey().getKey());
            if (spell != null) continue;
            controller.getLogger().warning("Invalid spell required for upgrade: " + requiredSpell.getSpellKey().getKey() + ", upgrade path " + key + " will disable upgrades");
            this.upgradeKey = null;
        }
        this.matchSpellMana = template.getBoolean("match_spell_mana", this.matchSpellMana);
        this.hidden = template.getBoolean("hidden", false);
        this.earnsSP = template.getBoolean("earns_sp", this.earnsSP);
        Messages messages = controller.getMessages();
        this.name = template.getString("name", this.name);
        this.name = messages.get("paths." + key + ".name", this.name);
        this.description = template.getString("description", this.description);
        this.description = messages.get("paths." + key + ".description", this.description);
        this.upgradeCommands = template.getStringList("upgrade_commands");
        if (template.contains("effects")) {
            this.effects.clear();
            ConfigurationSection effectsNode = template.getConfigurationSection("effects");
            Set effectKeys = effectsNode.getKeys(false);
            for (String effectKey : effectKeys) {
                if (effectsNode.isString(effectKey)) {
                    String referenceKey = effectsNode.getString(effectKey);
                    if (!this.effects.containsKey(referenceKey)) continue;
                    this.effects.put(effectKey, new ArrayList<EffectPlayer>(this.effects.get(referenceKey)));
                    continue;
                }
                this.effects.put(effectKey, EffectPlayer.loadEffects(controller.getPlugin(), effectsNode, effectKey));
            }
        }
        this.maxUses = template.getInt("max_uses", this.maxUses);
        this.maxMaxMana = template.getInt("max_mana", this.maxMaxMana);
        this.maxManaRegeneration = template.getInt("max_mana_regeneration", this.maxManaRegeneration);
        this.minLevel = template.getInt("min_enchant_level", this.minLevel);
        this.maxLevel = template.getInt("max_enchant_level", this.maxLevel);
        this.maxDamageReduction = (float)template.getDouble("max_protection", (double)this.maxDamageReduction);
        this.maxDamageReductionExplosions = (float)template.getDouble("max_protection_explosions", (double)this.maxDamageReductionExplosions);
        this.maxDamageReductionFalling = (float)template.getDouble("max_protection_falling", (double)this.maxDamageReductionFalling);
        this.maxDamageReductionFire = (float)template.getDouble("max_protection_fire", (double)this.maxDamageReductionFire);
        this.maxDamageReductionPhysical = (float)template.getDouble("max_protection_physical", (double)this.maxDamageReductionPhysical);
        this.maxDamageReductionProjectiles = (float)template.getDouble("max_protection_projectiles", (double)this.maxDamageReductionProjectiles);
        this.maxCostReduction = (float)template.getDouble("max_cost_reduction", (double)this.maxCostReduction);
        this.maxCooldownReduction = (float)template.getDouble("max_cooldown_reduction", (double)this.maxCooldownReduction);
        List<String> tagList = ConfigurationUtils.getStringList(template, "tags");
        if (tagList != null && !tagList.isEmpty()) {
            if (this.tags == null) {
                this.tags = new HashSet<String>(tagList);
            } else {
                this.tags.addAll(tagList);
            }
        }
        if (this.levelMap == null) {
            this.levelMap = new TreeMap();
        }
        if (template.contains("levels")) {
            String[] levelStrings = StringUtils.split((String)template.getString("levels"), (String)",");
            this.levels = new int[levelStrings.length];
            for (int i = 0; i < this.levels.length; ++i) {
                this.levels[i] = Integer.parseInt(levelStrings[i]);
            }
        }
        if (this.levels == null) {
            this.levels = new int[1];
            this.levels[0] = 1;
        }
        for (int level = 1; level <= this.levels[this.levels.length - 1]; ++level) {
            int levelIndex;
            int nextLevelIndex = 0;
            float distance = 1.0f;
            for (levelIndex = 0; levelIndex < this.levels.length; ++levelIndex) {
                if (level == this.levels[levelIndex] || levelIndex == this.levels.length - 1) {
                    nextLevelIndex = levelIndex;
                    distance = 0.0f;
                    break;
                }
                if (level >= this.levels[levelIndex + 1]) continue;
                nextLevelIndex = levelIndex + 1;
                int previousLevel = this.levels[levelIndex];
                int nextLevel = this.levels[nextLevelIndex];
                distance = (float)(level - previousLevel) / (float)(nextLevel - previousLevel);
                break;
            }
            WandLevel wandLevel = this.levelMap.get(level);
            WandLevel newLevel = new WandLevel(this, controller, template, levelIndex, nextLevelIndex, distance);
            if (wandLevel == null) {
                wandLevel = newLevel;
            } else {
                newLevel.add(wandLevel);
                wandLevel = newLevel;
            }
            this.levelMap.put(level, wandLevel);
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public WandLevel getLevel(int level) {
        if (this.levelMap == null) {
            return null;
        }
        if (!this.levelMap.containsKey(level)) {
            if (level > this.levelMap.lastKey()) {
                return this.levelMap.lastEntry().getValue();
            }
            return this.levelMap.firstEntry().getValue();
        }
        return this.levelMap.get(level);
    }

    protected static WandUpgradePath getPath(MageController controller, String key, ConfigurationSection configuration) {
        WandUpgradePath path = paths.get(key);
        if (path == null) {
            ConfigurationSection parameters = configuration.getConfigurationSection(key);
            if (!parameters.getBoolean("enabled", true)) {
                return null;
            }
            String inheritKey = parameters.getString("inherit");
            if (inheritKey != null && !inheritKey.isEmpty()) {
                WandUpgradePath inherit = WandUpgradePath.getPath(controller, inheritKey, configuration);
                if (inherit == null) {
                    Bukkit.getLogger().warning("Failed to load inherited enchanting path '" + inheritKey + "' for path: " + key);
                    return null;
                }
                path = new WandUpgradePath(controller, key, inherit, parameters);
            } else {
                path = new WandUpgradePath(controller, key, parameters);
            }
            paths.put(key, path);
        }
        return path;
    }

    public static void loadPaths(MageController controller, ConfigurationSection configuration) {
        paths.clear();
        Set pathKeys = configuration.getKeys(false);
        for (String key : pathKeys) {
            WandUpgradePath.getPath(controller, key, configuration);
        }
    }

    public static Set<String> getPathKeys() {
        return paths.keySet();
    }

    public static WandUpgradePath getPath(String key) {
        return paths.get(key);
    }

    public int getMaxLevel() {
        if (this.levels == null) {
            return 0;
        }
        return Math.min(this.levels[this.levels.length - 1], this.maxLevel);
    }

    public Set<Integer> getLevels() {
        if (this.levelMap == null) {
            return null;
        }
        HashSet<Integer> filteredLevels = new HashSet<Integer>();
        for (Integer level : this.levelMap.keySet()) {
            if (level < this.minLevel || level > this.maxLevel) continue;
            filteredLevels.add(level);
        }
        return filteredLevels;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public int getMaxMaxMana() {
        return this.maxMaxMana;
    }

    public int getMaxManaRegeneration() {
        return this.maxManaRegeneration;
    }

    public float getMaxDamageReduction() {
        return this.maxDamageReduction;
    }

    public float getMaxDamageReductionExplosions() {
        return this.maxDamageReductionExplosions;
    }

    public float getMaxDamageReductionFalling() {
        return this.maxDamageReductionFalling;
    }

    public float getMaxDamageReductionFire() {
        return this.maxDamageReductionFire;
    }

    public float getMaxDamageReductionPhysical() {
        return this.maxDamageReductionPhysical;
    }

    public float getMaxDamageReductionProjectiles() {
        return this.maxDamageReductionProjectiles;
    }

    public float getMaxCostReduction() {
        return this.maxCostReduction;
    }

    public float getMaxCooldownReduction() {
        return this.maxCooldownReduction;
    }

    public float getMaxPower() {
        return this.maxPower;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    public boolean hasTag(String tag) {
        return this.tags != null && this.tags.contains(tag);
    }

    @Override
    public boolean hasAnyTag(Collection<String> tagSet) {
        return this.tags != null && !Collections.disjoint(tagSet, this.tags);
    }

    @Override
    public boolean hasAllTags(Collection<String> tagSet) {
        return this.tags != null && this.tags.containsAll(tagSet);
    }

    @Override
    public Set<String> getMissingTags(Collection<String> tagSet) {
        Set<String> tags = this.getTags();
        if (tags != null) {
            HashSet<String> s = new HashSet<String>(tagSet);
            s.removeAll(tags);
            tags = s;
        } else {
            tags = new HashSet<String>(tagSet);
        }
        return tags;
    }

    @Override
    public Collection<String> getSpells() {
        return new ArrayList<String>(this.allSpells);
    }

    @Override
    public Collection<String> getExtraSpells() {
        return new ArrayList<String>(this.allExtraSpells);
    }

    @Override
    public Collection<String> getRequiredSpells() {
        return new ArrayList<String>(this.allRequiredSpells);
    }

    @Override
    public boolean requiresSpell(String spellKey) {
        return this.requiredSpellKeys.contains(spellKey);
    }

    @Override
    public boolean hasSpell(String spellKey) {
        return this.spells.contains(spellKey);
    }

    @Override
    public boolean hasExtraSpell(String spellKey) {
        return this.extraSpells.contains(spellKey);
    }

    @Override
    public String getName() {
        return this.name == null ? this.key : this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected void playEffects(com.elmakers.mine.bukkit.api.magic.Mage mage, String effectType) {
        Collection<EffectPlayer> players = this.effects.get(effectType);
        if (players == null || mage == null) {
            return;
        }
        Entity sourceEntity = mage.getEntity();
        Location mageLocation = mage.getEyeLocation();
        for (EffectPlayer player : players) {
            player.setColor(mage.getEffectColor());
            player.start(mageLocation, sourceEntity, null, null);
        }
    }

    public void enchanted(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.playEffects(mage, "enchant");
    }

    private void applyUpgradeItem(Wand wand, com.elmakers.mine.bukkit.api.magic.Mage mage) {
        com.elmakers.mine.bukkit.api.wand.Wand upgradeWand;
        if (this.upgradeItemKey != null && !this.upgradeItemKey.isEmpty() && (upgradeWand = mage.getController().createWand(this.upgradeItemKey)) != null) {
            wand.add(upgradeWand);
        }
    }

    @Override
    public void checkMigration(com.elmakers.mine.bukkit.api.wand.Wand wand) {
        if (this.icon != null && this.migrateIcon != null && this.migrateIcon.equals(wand.getIcon())) {
            wand.setIcon(this.icon);
        }
    }

    @Override
    public MaterialAndData getIcon() {
        return this.icon;
    }

    public void upgraded(com.elmakers.mine.bukkit.api.wand.Wand wand, com.elmakers.mine.bukkit.api.magic.Mage mage) {
        com.elmakers.mine.bukkit.api.wand.Wand upgradeWand;
        boolean shouldRunCommands;
        ConsoleCommandSender sender = Bukkit.getConsoleSender();
        Location location = null;
        if (mage != null) {
            this.playEffects(mage, "upgrade");
            location = mage.getLocation();
        }
        Player player = mage != null ? mage.getPlayer() : null;
        boolean bl = shouldRunCommands = player == null || !player.hasPermission("Magic.bypass_upgrade_commands");
        if (this.upgradeCommands != null && shouldRunCommands) {
            for (String command : this.upgradeCommands) {
                if (command.contains("@uuid") || command.contains("@pn") || command.contains("@pd")) {
                    if (mage == null) {
                        Bukkit.getLogger().warning("Tried to upgrade with commands but no mage");
                        continue;
                    }
                    command = command.replace("@uuid", mage.getId()).replace("@pn", mage.getName()).replace("@pd", mage.getDisplayName());
                }
                if (location != null) {
                    command = command.replace("@world", location.getWorld().getName()).replace("@x", Double.toString(location.getX())).replace("@y", Double.toString(location.getY())).replace("@z", Double.toString(location.getZ()));
                }
                WandUpgradePath upgrade = WandUpgradePath.getPath(this.upgradeKey);
                command = command.replace("$path", upgrade.getName());
                command = ChatColor.translateAlternateColorCodes((char)'&', (String)command);
                wand.getController().getPlugin().getServer().dispatchCommand((CommandSender)sender, command);
            }
        }
        if (this.upgradeItemKey != null && !this.upgradeItemKey.isEmpty() && (upgradeWand = wand.getController().createWand(this.upgradeItemKey)) != null) {
            wand.add(upgradeWand, mage);
        }
    }

    @Override
    public boolean hasUpgrade() {
        return this.upgradeKey != null && !this.upgradeKey.isEmpty();
    }

    @Override
    public WandUpgradePath getUpgrade() {
        return WandUpgradePath.getPath(this.upgradeKey);
    }

    public boolean getMatchSpellMana() {
        return this.matchSpellMana;
    }

    @Override
    public boolean canEnchant(com.elmakers.mine.bukkit.api.wand.Wand apiWand) {
        if (!(apiWand instanceof Wand)) {
            return false;
        }
        Wand wand = (Wand)apiWand;
        if (this.levelMap == null) {
            return false;
        }
        WandLevel maxLevel = this.levelMap.get(this.levels[this.levels.length - 1]);
        int spellCount = maxLevel.getSpellCount();
        LinkedList<WeightedPair<String>> remainingSpells = maxLevel.getRemainingSpells(wand);
        Mage mage = wand.getActivePlayer();
        if (mage != null && mage.getDebugLevel() > 0) {
            mage.sendDebugMessage("Spells remaining: " + remainingSpells.size() + ", max per enchant: " + spellCount);
        }
        return spellCount > 0 && remainingSpells.size() > 0;
    }

    public boolean hasSpells() {
        WandLevel maxLevel = this.levelMap.get(this.levels[this.levels.length - 1]);
        return maxLevel.getSpellProbabilityCount() > 0 && maxLevel.getSpellCount() > 0;
    }

    public boolean hasMaterials() {
        WandLevel maxLevel = this.levelMap.get(this.levels[this.levels.length - 1]);
        return maxLevel.getMaterialProbabilityCount() > 0 && maxLevel.getMaterialCount() > 0;
    }

    @Override
    public boolean checkUpgradeRequirements(com.elmakers.mine.bukkit.api.wand.Wand wand, com.elmakers.mine.bukkit.api.magic.Mage mage) {
        if (this.requiredSpells == null || this.requiredSpells.isEmpty()) {
            return true;
        }
        for (PrerequisiteSpell prereq : this.requiredSpells) {
            SpellTemplate spell;
            if (!wand.hasSpell(prereq.getSpellKey().getKey())) {
                spell = wand.getController().getSpellTemplate(prereq.getSpellKey().getKey());
                if (spell == null) {
                    wand.getController().getLogger().warning("Invalid spell required for upgrade: " + prereq.getSpellKey().getKey());
                    return false;
                }
                if (mage != null) {
                    String message = wand.getController().getMessages().get("spell.required_spell").replace("$spell", spell.getName());
                    WandUpgradePath upgradePath = this.getUpgrade();
                    if (upgradePath != null) {
                        message = message.replace("$path", upgradePath.getName());
                    }
                    mage.sendMessage(message);
                }
                return false;
            }
            if (mage == null || PrerequisiteSpell.isSpellSatisfyingPrerequisite((Spell)(spell = wand.getSpell(prereq.getSpellKey().getKey())), prereq)) continue;
            if (spell != null) {
                String message = wand.getController().getMessages().get("spell.prerequisite_spell_level").replace("$name", spell.getName()).replace("$level", Integer.toString(prereq.getSpellKey().getLevel()));
                if (prereq.getProgressLevel() > 1L) {
                    message = message + wand.getController().getMessages().get("spell.prerequisite_spell_progress_level").replace("$level", Long.toString(prereq.getProgressLevel())).replace("$max_level", Long.toString(Math.max(1L, spell.getMaxProgressLevel())));
                }
                mage.sendMessage(message);
            }
            return false;
        }
        return true;
    }

    public float getBonusLevelMultiplier() {
        return this.bonusLevelMultiplier;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean hasPath(String pathName) {
        if (this.key.equalsIgnoreCase(pathName)) {
            return true;
        }
        if (this.followsPath != null && this.followsPath.equalsIgnoreCase(pathName)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.hasPath(pathName);
        }
        return false;
    }

    @Override
    public String translatePath(String pathKey) {
        if (this.followsPath != null) {
            if (this.followsPath.equalsIgnoreCase(pathKey)) {
                return this.key;
            }
            if (this.upgradeKey != null) {
                return this.getUpgrade().translatePath(pathKey);
            }
        }
        return pathKey;
    }

    @Override
    public void upgrade(com.elmakers.mine.bukkit.api.wand.Wand wand, com.elmakers.mine.bukkit.api.magic.Mage mage) {
        WandUpgradePath newPath = this.getUpgrade();
        if (newPath == null) {
            if (mage != null) {
                mage.sendMessage("Configuration issue, please check logs");
            }
            wand.getController().getLogger().warning("Invalid upgrade path: " + this.getUpgrade());
            return;
        }
        if (mage != null) {
            MageController controller = mage.getController();
            mage.sendMessage(controller.getMessages().get("wand.level_up").replace("$wand", wand.getName()).replace("$path", newPath.getName()));
        }
        this.upgraded(wand, mage);
        if (this.icon != null && this.icon.equals(wand.getIcon())) {
            wand.setIcon(newPath.getIcon());
        }
        wand.setPath(newPath.getKey());
        WandUpgradeEvent upgradeEvent = new WandUpgradeEvent(mage, wand, this, newPath);
        Bukkit.getPluginManager().callEvent((Event)upgradeEvent);
    }

    @Override
    public boolean earnsSP() {
        return this.earnsSP;
    }
}

