/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.math;

import com.elmakers.mine.bukkit.slikey.effectlib.math.Transform;
import com.elmakers.mine.bukkit.slikey.exp4j.Expression;
import com.elmakers.mine.bukkit.slikey.exp4j.ExpressionBuilder;
import com.elmakers.mine.bukkit.slikey.exp4j.function.Function;
import java.util.Random;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;

public class EquationTransform
implements Transform {
    private Expression expression;
    private static Function randFunction;
    private final String inputVariable;

    @Override
    public void load(ConfigurationSection parameters) {
        this.setEquation(parameters.getString("equation", ""));
    }

    public EquationTransform() {
        this.inputVariable = "t";
    }

    public EquationTransform(String equation) {
        this();
        this.setEquation(equation);
    }

    public EquationTransform(String equation, String inputVariable) {
        this.inputVariable = inputVariable;
        this.setEquation(equation);
    }

    public void setEquation(String equation) {
        try {
            if (randFunction == null) {
                randFunction = new Function("rand", 2){
                    private Random random;
                    {
                        this.random = new Random();
                    }

                    @Override
                    public double apply(double ... args) {
                        return this.random.nextDouble() * (args[1] - args[0]) + args[0];
                    }
                };
            }
            this.expression = new ExpressionBuilder(equation).function(randFunction).variables(this.inputVariable).build();
        }
        catch (Exception ex) {
            this.expression = null;
            Bukkit.getLogger().log(Level.WARNING, "Error parsing equation " + equation, ex);
        }
    }

    @Override
    public double get(double t) {
        if (this.expression == null) {
            return 0.0;
        }
        this.expression.setVariable(this.inputVariable, t);
        return this.expression.evaluate();
    }
}

