/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.effect;

import com.elmakers.mine.bukkit.slikey.effectlib.Effect;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectType;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationTransform;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.VectorUtils;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class EquationEffect
extends Effect {
    public ParticleEffect particle = ParticleEffect.REDSTONE;
    public String xEquation = "t";
    public String yEquation = "0";
    public String zEquation = "0";
    public int particles = 1;
    public boolean orient = true;
    public boolean cycle = false;
    private EquationTransform xTransform;
    private EquationTransform yTransform;
    private EquationTransform zTransform;
    private int step;

    public EquationEffect(EffectManager effectManager) {
        super(effectManager);
        this.type = EffectType.REPEATING;
        this.period = 1;
        this.iterations = 100;
        this.step = 0;
    }

    @Override
    public void onRun() {
        if (this.xTransform == null) {
            this.xTransform = new EquationTransform(this.xEquation);
            this.yTransform = new EquationTransform(this.yEquation);
            this.zTransform = new EquationTransform(this.zEquation);
        }
        Location location = this.getLocation();
        for (int i = 0; i < this.particles; ++i) {
            Double xValue = this.xTransform.get(this.step);
            Double yValue = this.yTransform.get(this.step);
            Double zValue = this.zTransform.get(this.step);
            Vector result = new Vector(xValue.doubleValue(), yValue.doubleValue(), zValue.doubleValue());
            if (this.orient) {
                result = VectorUtils.rotateVector(result, location);
            }
            Location targetLocation = location.clone();
            targetLocation.add(result);
            this.display(this.particle, targetLocation);
            ++this.step;
        }
        if (this.cycle) {
            this.step = 0;
        }
    }
}

