/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class PlayerController
implements Listener {
    private final MagicController controller;
    private int clickCooldown = 150;
    private boolean enableCreativeModeEjecting = true;
    private MaterialAndData enchantBlockMaterial;
    private String enchantClickSpell = "spellshop";
    private String enchantSneakClickSpell = "upgrades";
    private boolean openOnSneakDrop;
    private boolean cancelInteractOnCast = true;
    private boolean allowOffhandCasting = true;

    public PlayerController(MagicController controller) {
        this.controller = controller;
    }

    public void loadProperties(ConfigurationSection properties) {
        this.clickCooldown = properties.getInt("click_cooldown", 0);
        this.enableCreativeModeEjecting = properties.getBoolean("enable_creative_mode_ejecting", false);
        this.enchantBlockMaterial = new MaterialAndData(properties.getString("enchant_block", "enchantment_table"));
        this.enchantClickSpell = properties.getString("enchant_click");
        this.enchantSneakClickSpell = properties.getString("enchant_sneak_click");
        this.openOnSneakDrop = properties.getBoolean("open_wand_on_sneak_drop");
        this.cancelInteractOnCast = properties.getBoolean("cancel_interact_on_cast", true);
        this.allowOffhandCasting = properties.getBoolean("allow_offhand_casting", true);
    }

    @EventHandler
    public void onPlayerEquip(PlayerItemHeldEvent event) {
        boolean isQuickCast;
        if (!this.controller.isLoaded()) {
            return;
        }
        Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemStack next = inventory.getItem(event.getNewSlot());
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.controller.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        if (Wand.isSelfDestructWand(next)) {
            mage.sendMessageKey("wand.self_destruct");
            inventory.setItem(event.getNewSlot(), null);
            mage.checkWand();
            return;
        }
        if (NMSUtils.isTemporary(next)) {
            inventory.setItem(event.getNewSlot(), null);
            mage.checkWand();
            return;
        }
        Wand activeWand = mage.getActiveWand();
        boolean isSkill = Wand.isSkill(next);
        boolean bl = isQuickCast = activeWand != null && activeWand.isQuickCast() && activeWand.isInventoryOpen();
        if (isSkill || isQuickCast) {
            MageSpell spell = mage.getSpell(Wand.getSpell(next));
            if (spell != null) {
                if (activeWand != null) {
                    activeWand.cast(spell);
                } else {
                    spell.cast();
                }
            }
            event.setCancelled(true);
            return;
        }
        if (activeWand != null && activeWand.isInventoryOpen()) {
            if (!Wand.isWand(next)) {
                this.controller.onPlayerActivateIcon(mage, activeWand, next);
                int previousSlot = event.getPreviousSlot();
                ItemStack previous = inventory.getItem(previousSlot);
                String previousId = Wand.getWandId(previous);
                if (previousId != null && previousId.equals(activeWand.getId())) {
                    player.getInventory().setItem(previousSlot, activeWand.getItem());
                }
            }
            event.setCancelled(true);
        } else {
            mage.checkWand(next);
        }
        activeWand = mage.getActiveWand();
        if (activeWand == null && next != null && next.getType() == Material.MAP) {
            mage.setLastHeldMapId(next.getDurability());
        }
    }

    @EventHandler
    public void onPlayerSwapItem(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage == null) {
            return;
        }
        com.elmakers.mine.bukkit.api.wand.Wand apiWand = mage.getActiveWand();
        if (apiWand == null || !(apiWand instanceof Wand)) {
            return;
        }
        Wand activeWand = (Wand)apiWand;
        if (activeWand.performAction(activeWand.getSwapAction())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Wand wand;
        boolean droppedWand;
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.controller.getRegisteredMage((Entity)player);
        if (apiMage == null || !(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        if (mage.getActiveGUI() != null) {
            event.setCancelled(true);
            return;
        }
        final Wand activeWand = mage.getActiveWand();
        ItemStack droppedItem = event.getItemDrop().getItemStack();
        boolean cancelEvent = false;
        String droppedId = Wand.getWandId(droppedItem);
        boolean bl = droppedWand = droppedId != null && activeWand != null && activeWand.getId().equals(droppedId);
        if (droppedWand && activeWand.isUndroppable()) {
            activeWand.checkItem(droppedItem);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.controller.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    activeWand.performAction(activeWand.getDropAction());
                }
            });
            cancelEvent = true;
        } else if (activeWand != null) {
            if (droppedWand) {
                String activeId;
                activeWand.deactivate();
                if (Wand.hasActiveWand(player) && (activeId = Wand.getWandId(player.getItemInHand())) != null && activeWand.getId().equals(activeId)) {
                    player.setItemInHand(new ItemStack(Material.AIR, 1));
                }
            } else if (activeWand.isInventoryOpen()) {
                if (!this.controller.isSpellDroppingEnabled()) {
                    cancelEvent = true;
                } else {
                    this.controller.removeItemFromWand(activeWand, droppedItem);
                }
            }
        } else if (this.openOnSneakDrop && !player.isSneaking() && event.getPlayer().getItemOnCursor().getType() == Material.AIR) {
            PlayerInventory inventory = player.getInventory();
            for (int i = 0; i < 9; ++i) {
                ItemStack item = inventory.getItem(i);
                if (item == null || Wand.getWandId(item) == null) continue;
                final int previouslySelected = inventory.getHeldItemSlot();
                inventory.setHeldItemSlot(i);
                final Wand newWand = mage.checkWand();
                if (null == newWand) {
                    inventory.setHeldItemSlot(previouslySelected);
                    continue;
                }
                new BukkitRunnable(){

                    public void run() {
                        newWand.openInventory();
                        newWand.setStoredSlot(previouslySelected);
                    }
                }.runTaskLater(mage.getController().getPlugin(), 0L);
                break;
            }
            cancelEvent = true;
        }
        if (!cancelEvent && Wand.Undroppable && Wand.isWand(droppedItem) && !player.hasPermission("Magic.wand.override_drop") && (wand = new Wand(this.controller, droppedItem)).isUndroppable() && wand.isBound()) {
            cancelEvent = true;
        }
        if (cancelEvent) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.controller.getRegisteredMage((Entity)event.getPlayer());
        if (apiMage == null || !(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        mage.restoreRespawnInventories();
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerInteractArmorStand(PlayerArmorStandManipulateEvent event) {
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage == null) {
            return;
        }
        com.elmakers.mine.bukkit.api.wand.Wand wand = mage.checkWand();
        if (wand != null) {
            if (wand.isUndroppable()) {
                event.setCancelled(true);
                return;
            }
            wand.deactivate();
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        boolean isPlaceable;
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.controller.getRegisteredMage((Entity)player);
        if (apiMage == null || !(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        Wand wand = mage.checkWand();
        Entity clickedEntity = event.getRightClicked();
        boolean bl = isPlaceable = clickedEntity instanceof ItemFrame || clickedEntity instanceof ArmorStand;
        if (wand != null && isPlaceable) {
            if (wand.isUndroppable()) {
                event.setCancelled(true);
                return;
            }
            wand.deactivate();
        }
        if (this.controller.isNPC(event.getRightClicked())) {
            if (wand != null) {
                wand.closeInventory();
            }
            mage.checkLastClick(0L);
        } else {
            ItemStack itemInHand = player.getItemInHand();
            if (Wand.isSpell(itemInHand) || Wand.isBrush(itemInHand) || Wand.isUpgrade(itemInHand)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean isSwing;
        boolean handleRightClick;
        if (!this.controller.isLoaded()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getItemInHand();
        if (Wand.isSpell(itemInHand) || Wand.isBrush(itemInHand) || Wand.isUpgrade(itemInHand)) {
            event.setCancelled(true);
            return;
        }
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.controller.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        Action action = event.getAction();
        Wand wand = mage.checkWand();
        boolean bl = handleRightClick = action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK;
        if (action == Action.RIGHT_CLICK_BLOCK) {
            Material material = event.getClickedBlock().getType();
            boolean bl2 = handleRightClick = !this.controller.isInteractable(event.getClickedBlock());
            if (wand != null && (material == Material.SIGN_POST || material == Material.WALL_SIGN)) {
                wand.closeInventory();
            }
        }
        if (handleRightClick && this.allowOffhandCasting && mage.offhandCast()) {
            if (this.cancelInteractOnCast) {
                event.setCancelled(true);
            }
            return;
        }
        if (itemInHand != null && (action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK) && this.controller.isWearable(itemInHand)) {
            if (wand != null) {
                wand.deactivate();
            }
            this.controller.onArmorUpdated(mage);
            return;
        }
        if (wand == null) {
            return;
        }
        Messages messages = this.controller.getMessages();
        if (!this.controller.hasWandPermission(player)) {
            return;
        }
        if (!this.controller.hasWandPermission(player, wand)) {
            wand.deactivate();
            mage.sendMessage(messages.get("wand.no_permission").replace("$wand", wand.getName()));
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (wand.hasSpellProgression() && this.controller.isSPEnabled() && clickedBlock != null && clickedBlock.getType() != Material.AIR && this.enchantBlockMaterial != null && this.enchantBlockMaterial.is(clickedBlock)) {
            MageSpell spell = null;
            if (player.isSneaking()) {
                spell = this.enchantSneakClickSpell != null ? mage.getSpell(this.enchantSneakClickSpell) : null;
            } else {
                MageSpell mageSpell = spell = this.enchantClickSpell != null ? mage.getSpell(this.enchantClickSpell) : null;
            }
            if (spell != null) {
                spell.cast();
                event.setCancelled(true);
                return;
            }
        }
        if (!mage.checkLastClick(this.clickCooldown)) {
            event.setCancelled(true);
            return;
        }
        boolean bl3 = isSwing = action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK;
        if (isSwing) {
            wand.playEffects("swing");
        }
        if (isSwing && !wand.isUpgrade()) {
            if (wand.performAction(wand.getLeftClickAction()) && this.cancelInteractOnCast) {
                event.setCancelled(true);
            }
            return;
        }
        if (handleRightClick && wand.performAction(wand.getRightClickAction())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.controller.getMage(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerKick(PlayerKickEvent event) {
        this.handlePlayerQuitEvent((PlayerEvent)event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.handlePlayerQuitEvent((PlayerEvent)event);
    }

    protected void handlePlayerQuitEvent(PlayerEvent event) {
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage != null) {
            if (mage instanceof Mage) {
                ((Mage)mage).onPlayerQuit(event);
            }
            this.controller.playerQuit(mage);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChangeWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage mage = this.controller.getMage(player);
        mage.checkWand();
    }

    @EventHandler
    public void onPlayerGameModeChange(PlayerGameModeChangeEvent event) {
        if (event.getNewGameMode() == GameMode.CREATIVE) {
            Player player = event.getPlayer();
            com.elmakers.mine.bukkit.api.magic.Mage mage = this.controller.getMage(player);
            com.elmakers.mine.bukkit.api.wand.Wand activeWand = mage.getActiveWand();
            if (activeWand != null) {
                activeWand.closeInventory();
            }
            if (this.enableCreativeModeEjecting) {
                boolean ejected = false;
                if (activeWand != null) {
                    activeWand.deactivate();
                }
                PlayerInventory inventory = player.getInventory();
                ItemStack[] contents = inventory.getContents();
                for (int i = 0; i < contents.length; ++i) {
                    ItemStack item = contents[i];
                    if (!Wand.isWand(item)) continue;
                    ejected = true;
                    inventory.setItem(i, null);
                    player.getWorld().dropItemNaturally(player.getLocation(), item);
                }
                if (ejected) {
                    mage.sendMessage("Ejecting wands, creative mode will destroy them!");
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.controller.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        if (mage.hasStoredInventory()) {
            event.setCancelled(true);
            if (mage.addToStoredInventory(event.getItem().getItemStack())) {
                event.getItem().remove();
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerPrePickupItem(PlayerPickupItemEvent event) {
        Wand activeWand;
        Item item = event.getItem();
        ItemStack pickup = item.getItemStack();
        if (NMSUtils.isTemporary(pickup) || item.hasMetadata("temporary")) {
            item.remove();
            event.setCancelled(true);
            return;
        }
        boolean isWand = Wand.isWand(pickup);
        if (event.getPlayer().getGameMode() == GameMode.CREATIVE && isWand && this.enableCreativeModeEjecting) {
            event.setCancelled(true);
            return;
        }
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.controller.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        Messages messages = this.controller.getMessages();
        if (isWand) {
            Wand wand = new Wand(this.controller, pickup);
            if (!wand.canUse(player)) {
                mage.sendMessage(messages.get("wand.bound").replace("$name", wand.getOwner()));
                event.setCancelled(true);
                Item droppedItem = event.getItem();
                Vector velocity = droppedItem.getVelocity();
                velocity.setY(velocity.getY() * 2.0 + 1.0);
                droppedItem.setVelocity(velocity);
                return;
            }
            if (this.controller.removeLostWand(wand.getId())) {
                this.controller.info("Player " + mage.getName() + " picked up wand " + wand.getName() + ", id " + wand.getId());
            }
        }
        if ((activeWand = mage.getActiveWand()) != null && activeWand.isModifiable() && (Wand.isSpell(pickup) || Wand.isBrush(pickup) || Wand.isUpgrade(pickup) || Wand.isSP(pickup)) && activeWand.addItem(pickup)) {
            event.getItem().remove();
            event.setCancelled(true);
            return;
        }
        if (!mage.hasStoredInventory()) {
            PlayerInventory inventory = event.getPlayer().getInventory();
            ItemStack inHand = inventory.getItemInHand();
            if (isWand && (inHand == null || inHand.getType() == Material.AIR)) {
                Wand wand = new Wand(this.controller, pickup);
                event.setCancelled(true);
                event.getItem().remove();
                inventory.setItem(inventory.getHeldItemSlot(), pickup);
                wand.activate(mage);
            }
        }
    }
}

