/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class CheckBlockAction
extends BaseSpellAction {
    private Set<Material> allowed;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        this.allowed = spell.getController().getMaterialSet(parameters.getString("allowed"));
    }

    @Override
    public SpellResult perform(CastContext context) {
        MaterialBrush brush = context.getBrush();
        Block block = context.getTargetBlock();
        if (block == null) {
            return SpellResult.STOP;
        }
        if (this.allowed != null) {
            if (!this.allowed.contains(block.getType())) {
                return SpellResult.STOP;
            }
        } else {
            if (brush != null && brush.isErase() ? !context.hasBreakPermission(block) : !context.hasBuildPermission(block)) {
                return SpellResult.STOP;
            }
            if (!context.isDestructible(block)) {
                return SpellResult.STOP;
            }
        }
        return SpellResult.CAST;
    }

    @Override
    public boolean requiresTarget() {
        return false;
    }
}

