/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.traders;

import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.traders.TradersController;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.logging.Level;
import net.dandielo.core.items.dItem;
import net.dandielo.core.items.serialize.Attribute;
import net.dandielo.core.items.serialize.ItemAttribute;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

@Attribute(name="Magic Wand", key="magic_wand", priority=5)
public class WandAttr
extends ItemAttribute {
    private String wandData;

    public WandAttr(dItem item, String key) {
        super(item, key);
    }

    public boolean onRefactor(ItemStack itemStack) {
        MagicAPI api = MagicPlugin.getAPI();
        if (!api.isWand(itemStack)) {
            return false;
        }
        Wand wand = new Wand(TradersController.getController(), itemStack);
        YamlConfiguration saveData = new YamlConfiguration();
        wand.saveProperties((ConfigurationSection)saveData);
        this.wandData = saveData.saveToString();
        return true;
    }

    public boolean deserialize(String itemData) {
        if (itemData == null || itemData.isEmpty()) {
            return false;
        }
        this.wandData = itemData.replace("{sp}", " ").replace("{co}", ":").replace("{cr}", "\n");
        return true;
    }

    public String serialize() {
        if (this.wandData == null) {
            this.wandData = "";
        }
        String escaped = this.wandData.replace(" ", "{sp}").replace(":", "{co}").replace("\n", "{cr}");
        return escaped;
    }

    public void onAssign(ItemStack itemStack, boolean unused) {
        if (itemStack != null && this.wandData != null && !this.wandData.isEmpty()) {
            Wand wand = Wand.createWand(TradersController.getController(), itemStack);
            YamlConfiguration saveData = new YamlConfiguration();
            try {
                saveData.loadFromString(this.wandData);
                wand.loadProperties((ConfigurationSection)saveData);
                wand.save();
            }
            catch (InvalidConfigurationException ex) {
                TradersController.getController().getLogger().log(Level.WARNING, "Error deserializing wand data", ex);
            }
        }
    }

    public boolean similar(ItemAttribute other) {
        if (other instanceof WandAttr) {
            return this.wandData.equals(((WandAttr)other).wandData);
        }
        return false;
    }

    public boolean equals(ItemAttribute other) {
        if (other instanceof WandAttr) {
            return this.wandData.equals(((WandAttr)other).wandData);
        }
        return false;
    }
}

