/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

public class RepairItemAction
extends BaseSpellAction {
    private boolean armor;
    private boolean heldItem;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.armor = parameters.getBoolean("armor", false);
        this.heldItem = parameters.getBoolean("held_item", false);
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity entity = context.getTargetEntity();
        if (entity instanceof LivingEntity && (this.armor || this.heldItem)) {
            ItemStack item;
            boolean repaired = false;
            LivingEntity li = (LivingEntity)entity;
            EntityEquipment equipment = li.getEquipment();
            if (equipment == null) {
                return SpellResult.NO_TARGET;
            }
            if (this.armor) {
                item = equipment.getHelmet();
                repaired = this.repair(item) || repaired;
                item = equipment.getChestplate();
                repaired = this.repair(item) || repaired;
                item = equipment.getLeggings();
                repaired = this.repair(item) || repaired;
                item = equipment.getBoots();
                boolean bl = repaired = this.repair(item) || repaired;
            }
            if (this.heldItem) {
                item = equipment.getItemInHand();
                repaired = this.repair(item) || repaired;
            }
            return repaired ? SpellResult.CAST : SpellResult.NO_TARGET;
        }
        if (entity == null || !(entity instanceof Item)) {
            return SpellResult.NO_TARGET;
        }
        Item item = (Item)entity;
        ItemStack itemStack = item.getItemStack();
        return this.repair(itemStack) ? SpellResult.CAST : SpellResult.NO_TARGET;
    }

    protected boolean repair(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return false;
        }
        short maxDurability = itemStack.getType().getMaxDurability();
        if (maxDurability <= 0 || itemStack.getDurability() <= 0) {
            return false;
        }
        itemStack.setDurability((short)0);
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }
}

