/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseTeleportAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.LostWand;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class RecallAction
extends BaseTeleportAction
implements GUIAction {
    private static final Material DefaultWaypointMaterial = Material.BEACON;
    private boolean allowCrossWorld = true;
    private Map<String, ConfigurationSection> warps = new HashMap<String, ConfigurationSection>();
    private Map<String, ConfigurationSection> commands = new HashMap<String, ConfigurationSection>();
    private List<RecallType> enabledTypes = new ArrayList<RecallType>();
    private Map<Integer, Waypoint> options = new HashMap<Integer, Waypoint>();
    private CastContext context;
    private ConfigurationSection parameters;
    private int protectionTime;
    private String markerKey = "recall_marker";
    private String unlockKey = "recall_warps";
    private static MaterialAndData defaultMaterial = new MaterialAndData(DefaultWaypointMaterial);

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public void deactivated() {
        if (this.context != null) {
            this.context.getMage().removeItemsWithTag("waypoint");
        }
    }

    @Override
    public void dragged(InventoryDragEvent event) {
        event.setCancelled(true);
    }

    @Override
    public void clicked(InventoryClickEvent event) {
        Waypoint waypoint;
        event.setCancelled(true);
        if (this.context == null) {
            event.getWhoClicked().closeInventory();
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (InventoryUtils.hasMeta(item, "move_marker")) {
            if (this.placeMarker(this.context.getLocation().getBlock())) {
                this.context.sendMessageKey("target_selected");
            }
            this.context.getMage().deactivateGUI();
            return;
        }
        if (item == null || item.getType() == Material.AIR) {
            this.context.getMage().deactivateGUI();
        }
        int slot = event.getRawSlot();
        if (event.getSlotType() == InventoryType.SlotType.CONTAINER && (waypoint = this.options.get(slot)) != null) {
            Mage mage = this.context.getMage();
            Player player = mage.getPlayer();
            mage.deactivateGUI();
            this.tryTeleport(player, waypoint);
        }
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.parameters = parameters;
        this.context = context;
        this.markerKey = parameters.getString("marker_key", "recall_marker");
        this.unlockKey = parameters.getString("unlock_key", "recall_warps");
        this.protectionTime = parameters.getInt("protection_duration", 0);
        this.allowCrossWorld = parameters.getBoolean("allow_cross_world", true);
    }

    @Override
    public SpellResult perform(CastContext context) {
        this.context = context;
        this.enabledTypes.clear();
        this.warps.clear();
        this.commands.clear();
        Mage mage = context.getMage();
        MageController controller = context.getController();
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        HashSet<String> unlockedWarps = new HashSet<String>();
        ConfigurationSection mageData = mage.getData();
        String unlockedString = mageData.getString(this.unlockKey);
        if (unlockedString != null && !unlockedString.isEmpty()) {
            unlockedWarps.addAll(Arrays.asList(StringUtils.split((String)unlockedString, (String)",")));
        }
        ConfigurationSection warpConfig = null;
        if (this.parameters.contains("warps")) {
            warpConfig = ConfigurationUtils.getConfigurationSection(this.parameters, "warps");
        }
        ConfigurationSection commandConfig = null;
        if (this.parameters.contains("commands")) {
            commandConfig = ConfigurationUtils.getConfigurationSection(this.parameters, "commands");
        }
        if (this.parameters.contains("unlock")) {
            ConfigurationSection config;
            String unlockWarp = this.parameters.getString("unlock");
            if (unlockWarp == null || unlockWarp.isEmpty() || unlockedWarps.contains(unlockWarp)) {
                return SpellResult.NO_ACTION;
            }
            if (warpConfig == null && commandConfig == null) {
                return SpellResult.FAIL;
            }
            unlockedWarps.add(unlockWarp);
            unlockedString = StringUtils.join(unlockedWarps, (String)",");
            mageData.set(this.unlockKey, (Object)unlockedString);
            String warpName = unlockWarp;
            ConfigurationSection configurationSection = config = warpConfig == null ? null : warpConfig.getConfigurationSection(unlockWarp);
            if (config != null) {
                warpName = config.getString("name", warpName);
            } else {
                ConfigurationSection configurationSection2 = config = commandConfig == null ? null : commandConfig.getConfigurationSection(unlockWarp);
                if (config != null) {
                    warpName = config.getString("name", warpName);
                }
            }
            String unlockMessage = context.getMessage("unlock_warp").replace("$name", warpName);
            context.sendMessage(unlockMessage);
            return SpellResult.CAST;
        }
        if (this.parameters.contains("lock")) {
            String lockWarpString = this.parameters.getString("lock");
            String[] lockWarps = StringUtils.split((String)lockWarpString, (char)',');
            boolean locked = false;
            for (String lockWarp : lockWarps) {
                if (!unlockedWarps.contains(lockWarp)) continue;
                locked = true;
                unlockedWarps.remove(lockWarp);
            }
            if (locked) {
                unlockedString = StringUtils.join(unlockedWarps, (String)",");
                mageData.set(this.unlockKey, (Object)unlockedString);
            }
            return locked ? SpellResult.DEACTIVATE : SpellResult.NO_ACTION;
        }
        Location playerLocation = mage.getLocation();
        for (RecallType testType : RecallType.values()) {
            boolean isLocked;
            ConfigurationSection config;
            if (testType == RecallType.WARP) {
                if (warpConfig == null) continue;
                Set warpKeys = warpConfig.getKeys(false);
                for (String warpKey : warpKeys) {
                    config = warpConfig.getConfigurationSection(warpKey);
                    isLocked = config.getBoolean("locked", false);
                    if (isLocked && !unlockedWarps.contains(warpKey)) continue;
                    this.warps.put(warpKey, config);
                }
                continue;
            }
            if (testType == RecallType.COMMAND) {
                if (commandConfig == null) continue;
                Set commandKeys = commandConfig.getKeys(false);
                for (String commandKey : commandKeys) {
                    config = commandConfig.getConfigurationSection(commandKey);
                    isLocked = config.getBoolean("locked", false);
                    if (isLocked && !unlockedWarps.contains(commandKey)) continue;
                    this.commands.put(commandKey, config);
                }
                continue;
            }
            if (!this.parameters.getBoolean("allow_" + testType.name().toLowerCase(), true)) continue;
            this.enabledTypes.add(testType);
        }
        if (this.warps.size() > 0) {
            this.enabledTypes.add(RecallType.WARP);
        }
        if (this.commands.size() > 0) {
            this.enabledTypes.add(RecallType.COMMAND);
        }
        if (this.parameters.contains("warp")) {
            String warpName = this.parameters.getString("warp");
            Waypoint waypoint = this.getWarp(warpName);
            if (this.tryTeleport(player, waypoint)) {
                return SpellResult.CAST;
            }
            return SpellResult.FAIL;
        }
        if (this.parameters.contains("command")) {
            String commandName = this.parameters.getString("command");
            Waypoint waypoint = this.getCommand(context, commandName);
            if (this.tryTeleport(player, waypoint)) {
                return SpellResult.CAST;
            }
            return SpellResult.FAIL;
        }
        if (this.parameters.contains("type")) {
            RecallType recallType;
            String typeString = this.parameters.getString("type", "");
            if (this.parameters.getBoolean("allow_marker", true)) {
                if (typeString.equalsIgnoreCase("remove")) {
                    if (this.removeMarker()) {
                        return SpellResult.TARGET_SELECTED;
                    }
                    return SpellResult.FAIL;
                }
                if (typeString.equalsIgnoreCase("place")) {
                    Block block = context.getLocation().getBlock();
                    if (this.parameters.getBoolean("marker_requires_build", true) && !context.hasBuildPermission(block)) {
                        return SpellResult.NO_TARGET;
                    }
                    if (this.hasMarker()) {
                        this.showMarkerConfirm(context);
                        return SpellResult.CAST;
                    }
                    if (this.placeMarker(block)) {
                        return SpellResult.TARGET_SELECTED;
                    }
                    return SpellResult.FAIL;
                }
            }
            if ((recallType = RecallType.valueOf(typeString.toUpperCase())) == null) {
                controller.getLogger().warning("Unknown recall type " + typeString);
                return SpellResult.FAIL;
            }
            Waypoint location = this.getWaypoint(player, recallType, 0, this.parameters, context);
            if (this.tryTeleport(player, location)) {
                return SpellResult.CAST;
            }
            return SpellResult.FAIL;
        }
        LinkedList<Waypoint> allWaypoints = new LinkedList<Waypoint>();
        for (RecallType selectedType : this.enabledTypes) {
            Waypoint targetLocation;
            if (selectedType == RecallType.WARP) {
                for (String warpKey : this.warps.keySet()) {
                    targetLocation = this.getWarp(warpKey);
                    if (targetLocation == null || !targetLocation.isValid(this.allowCrossWorld, playerLocation)) continue;
                    allWaypoints.add(targetLocation);
                }
                continue;
            }
            if (selectedType == RecallType.COMMAND) {
                for (String commandKey : this.commands.keySet()) {
                    targetLocation = this.getCommand(context, commandKey);
                    if (targetLocation == null || !targetLocation.isValid(this.allowCrossWorld, playerLocation)) continue;
                    allWaypoints.add(targetLocation);
                }
                continue;
            }
            if (selectedType == RecallType.WAND) {
                List<LostWand> lostWands = mage.getLostWands();
                for (int i = 0; i < lostWands.size(); ++i) {
                    targetLocation = this.getWaypoint(player, selectedType, i, this.parameters, context);
                    if (targetLocation == null || !targetLocation.isValid(this.allowCrossWorld, playerLocation)) continue;
                    allWaypoints.add(targetLocation);
                }
                continue;
            }
            if (selectedType == RecallType.FIELDS) {
                Map<String, Location> fields = controller.getHomeLocations(player);
                if (fields == null) continue;
                for (Map.Entry<String, Location> fieldEntry : fields.entrySet()) {
                    Location location = fieldEntry.getValue().clone();
                    location.setX(location.getX() + 0.5);
                    location.setZ(location.getZ() + 0.5);
                    allWaypoints.add(new Waypoint(RecallType.FIELDS, location, fieldEntry.getKey(), context.getMessage("cast_field"), context.getMessage("no_target_field"), context.getMessage("description_field", ""), this.getIcon(context, this.parameters, "icon_field"), true));
                }
                continue;
            }
            Waypoint targetLocation2 = this.getWaypoint(player, selectedType, 0, this.parameters, context);
            if (targetLocation2 == null || !targetLocation2.isValid(this.allowCrossWorld, playerLocation)) continue;
            allWaypoints.add(targetLocation2);
        }
        if (allWaypoints.size() == 0) {
            return SpellResult.NO_TARGET;
        }
        this.options.clear();
        Collections.sort(allWaypoints);
        String inventoryTitle = context.getMessage("title", "Recall");
        int invSize = (int)Math.ceil((float)allWaypoints.size() / 9.0f) * 9;
        Inventory displayInventory = CompatibilityUtils.createInventory(null, invSize, inventoryTitle);
        int index = 0;
        for (Waypoint waypoint : allWaypoints) {
            ItemMeta meta;
            ItemStack waypointItem = controller.isUrlIconsEnabled() && waypoint.iconURL != null && !waypoint.iconURL.isEmpty() ? InventoryUtils.getURLSkull(waypoint.iconURL) : waypoint.icon.getItemStack(1);
            ItemMeta itemMeta = meta = waypointItem == null ? null : waypointItem.getItemMeta();
            if (meta == null) {
                waypointItem = new ItemStack(DefaultWaypointMaterial);
                meta = waypointItem.getItemMeta();
                controller.getLogger().warning("Invalid waypoint icon for " + waypoint.name);
            }
            meta.setDisplayName(waypoint.name);
            if (waypoint.description != null && waypoint.description.length() > 0) {
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(waypoint.description);
                meta.setLore(lore);
            }
            waypointItem.setItemMeta(meta);
            waypointItem = InventoryUtils.makeReal(waypointItem);
            InventoryUtils.hideFlags(waypointItem, (byte)63);
            InventoryUtils.setMeta(waypointItem, "waypoint", "true");
            displayInventory.setItem(index, waypointItem);
            this.options.put(index, waypoint);
            ++index;
        }
        mage.activateGUI(this, displayInventory);
        return SpellResult.CAST;
    }

    protected Waypoint getUnknownWarp(String warpKey) {
        MageController controller = this.context.getController();
        Location warpLocation = controller.getWarp(warpKey);
        if (warpLocation == null || warpLocation.getWorld() == null) {
            return null;
        }
        String castMessage = this.context.getMessage("cast_warp").replace("$name", warpKey);
        String failMessage = this.context.getMessage("no_target_warp").replace("$name", warpKey);
        return new Waypoint(RecallType.WARP, warpLocation, warpKey, castMessage, failMessage, "", null, null);
    }

    protected void showMarkerConfirm(CastContext context) {
        this.options.clear();
        String inventoryTitle = context.getMessage("move_marker_title", "Move Marker");
        Inventory displayInventory = CompatibilityUtils.createInventory(null, 9, inventoryTitle);
        MaterialAndData iconType = this.getIcon(context, this.parameters, "icon_move_marker");
        ItemStack markerItem = iconType.getItemStack(1);
        ItemMeta meta = markerItem.getItemMeta();
        meta.setDisplayName(context.getMessage("title_move_marker"));
        String description = context.getMessage("description_move_marker");
        if (description != null && description.length() > 0) {
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(description);
            meta.setLore(lore);
        }
        markerItem.setItemMeta(meta);
        markerItem = InventoryUtils.makeReal(markerItem);
        InventoryUtils.hideFlags(markerItem, (byte)63);
        InventoryUtils.setMeta(markerItem, "move_marker", "true");
        displayInventory.setItem(4, markerItem);
        context.getMage().activateGUI(this, displayInventory);
    }

    protected Waypoint getWarp(String warpKey) {
        if (this.warps == null) {
            return this.getUnknownWarp(warpKey);
        }
        ConfigurationSection config = this.warps.get(warpKey);
        if (config == null) {
            return this.getUnknownWarp(warpKey);
        }
        MageController controller = this.context.getController();
        String warpName = config.getString("name", warpKey);
        String castMessage = this.context.getMessage("cast_warp").replace("$name", warpName);
        String failMessage = this.context.getMessage("no_target_warp").replace("$name", warpName);
        String title = this.context.getMessage("title_warp").replace("$name", warpName);
        String description = config.getString("description");
        String iconURL = config.getString("icon_url");
        MaterialAndData icon = this.getIcon(this.context, config, "icon");
        Location warpLocation = controller.getWarp(warpKey);
        if (warpLocation == null || warpLocation.getWorld() == null) {
            String serverName = config.getString("server", null);
            if (serverName != null) {
                return new Waypoint(RecallType.WARP, warpKey, serverName, title, castMessage, failMessage, description, icon, iconURL);
            }
            return null;
        }
        return new Waypoint(RecallType.WARP, warpLocation, title, castMessage, failMessage, description, icon, iconURL);
    }

    protected Waypoint getCommand(CastContext context, String commandKey) {
        if (this.commands == null) {
            return null;
        }
        ConfigurationSection config = this.commands.get(commandKey);
        if (config == null) {
            return null;
        }
        String commandName = config.getString("name", commandKey);
        String castMessage = context.getMessage("cast_warp").replace("$name", commandName);
        String failMessage = context.getMessage("no_target_warp").replace("$name", commandName);
        String title = context.getMessage("title_warp").replace("$name", commandName);
        String description = config.getString("description");
        String iconURL = config.getString("icon_url");
        String command = context.parameterize(config.getString("command"));
        boolean op = config.getBoolean("op", false);
        boolean console = config.getBoolean("console", false);
        MaterialAndData icon = this.getIcon(context, config, "icon");
        return new Waypoint(RecallType.COMMAND, command, op, console, title, castMessage, failMessage, description, icon, iconURL);
    }

    protected Waypoint getWaypoint(Player player, RecallType type, int index, ConfigurationSection parameters, CastContext context) {
        Mage mage = context.getMage();
        MageController controller = context.getController();
        switch (type) {
            case MARKER: {
                Location location = ConfigurationUtils.getLocation(mage.getData(), this.markerKey);
                return new Waypoint(type, location, context.getMessage("title_marker"), context.getMessage("cast_marker"), context.getMessage("no_target_marker"), context.getMessage("description_marker", ""), this.getIcon(context, parameters, "icon_marker"), true);
            }
            case DEATH: {
                Waypoint death = new Waypoint(type, mage.getLastDeathLocation(), "Last Death", context.getMessage("cast_death"), context.getMessage("no_target_death"), context.getMessage("description_death", ""), this.getIcon(context, parameters, "icon_death"), true);
                death.safe = false;
                return death;
            }
            case SPAWN: {
                return new Waypoint(type, context.getWorld().getSpawnLocation(), context.getMessage("title_spawn"), context.getMessage("cast_spawn"), context.getMessage("no_target_spawn"), context.getMessage("description_spawn", ""), this.getIcon(context, parameters, "icon_spawn"), false);
            }
            case TOWN: {
                return new Waypoint(type, controller.getTownLocation(player), context.getMessage("title_town"), context.getMessage("cast_town"), context.getMessage("no_target_town"), context.getMessage("description_town", ""), this.getIcon(context, parameters, "icon_town"), false);
            }
            case HOME: {
                Location bedLocation;
                Location location = bedLocation = player == null ? null : player.getBedSpawnLocation();
                if (bedLocation != null) {
                    bedLocation.setX(bedLocation.getX() + 0.5);
                    bedLocation.setZ(bedLocation.getZ() + 0.5);
                }
                return new Waypoint(type, bedLocation, context.getMessage("title_home"), context.getMessage("cast_home"), context.getMessage("no_target_home"), context.getMessage("description_home", ""), this.getIcon(context, parameters, "icon_home"), false);
            }
            case WAND: {
                List<LostWand> lostWands = mage.getLostWands();
                if (lostWands == null || index < 0 || index >= lostWands.size()) {
                    return null;
                }
                return new Waypoint(type, lostWands.get(index).getLocation(), context.getMessage("title_wand"), context.getMessage("cast_wand"), context.getMessage("no_target_wand"), context.getMessage("description_wand", ""), this.getIcon(context, parameters, "icon_wand"), true);
            }
        }
        return null;
    }

    protected MaterialAndData getIcon(CastContext context, ConfigurationSection parameters, String key) {
        String iconKey = parameters.getString(key);
        if (iconKey.isEmpty()) {
            return null;
        }
        MaterialAndData material = ConfigurationUtils.getMaterialAndData(parameters, key);
        if (material == null || !material.isValid() || material.getMaterial() == null) {
            context.getLogger().warning("Invalid material specified for " + context.getSpell().getKey() + " " + key + ": " + iconKey);
            return null;
        }
        return material;
    }

    protected boolean removeMarker() {
        Mage mage = this.context.getMage();
        ConfigurationSection mageData = mage.getData();
        Location location = ConfigurationUtils.getLocation(mageData, this.markerKey);
        if (location == null) {
            return false;
        }
        mageData.set(this.markerKey, null);
        return true;
    }

    protected boolean hasMarker() {
        Mage mage = this.context.getMage();
        ConfigurationSection mageData = mage.getData();
        Location location = ConfigurationUtils.getLocation(mageData, this.markerKey);
        return location != null;
    }

    protected boolean tryTeleport(Player player, Waypoint waypoint) {
        Location targetLocation;
        Mage mage = this.context.getMage();
        if (waypoint == null) {
            return false;
        }
        if (waypoint.isCommand()) {
            if (waypoint.asConsole) {
                try {
                    player.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), waypoint.command);
                }
                catch (Exception ex) {
                    this.context.getLogger().log(Level.WARNING, "Error running command as console " + waypoint.command, ex);
                }
            } else {
                CommandSender sender = mage.getCommandSender();
                boolean isOp = sender.isOp();
                if (waypoint.opPlayer && !isOp) {
                    sender.setOp(true);
                }
                try {
                    player.getServer().dispatchCommand(sender, waypoint.command);
                }
                catch (Exception ex) {
                    this.context.getLogger().log(Level.WARNING, "Error running command " + waypoint.command, ex);
                }
                if (waypoint.opPlayer && !isOp) {
                    sender.setOp(false);
                }
            }
            mage.enableSuperProtection(this.protectionTime);
            return true;
        }
        Location location = targetLocation = waypoint == null ? null : waypoint.location;
        if (targetLocation == null) {
            if (waypoint != null) {
                String serverName = waypoint.serverName;
                String warpName = waypoint.warpName;
                if (warpName != null && serverName != null) {
                    this.context.getController().warpPlayerToServer(player, serverName, warpName);
                }
                this.context.sendMessage(waypoint.failMessage);
            }
            return false;
        }
        if (!this.allowCrossWorld && !mage.getLocation().getWorld().equals(targetLocation.getWorld())) {
            this.context.sendMessageKey("cross_world_disallowed");
            return false;
        }
        if (waypoint.maintainDirection) {
            Location playerLocation = player.getLocation();
            targetLocation.setYaw(playerLocation.getYaw());
            targetLocation.setPitch(playerLocation.getPitch());
        }
        mage.enableSuperProtection(this.protectionTime);
        if (this.context.teleport((Entity)player, targetLocation, this.verticalSearchDistance, waypoint.safe, waypoint.safe)) {
            this.context.castMessage(waypoint.message);
        } else {
            this.context.castMessage(waypoint.failMessage);
        }
        return true;
    }

    protected boolean placeMarker(Block target) {
        if (target == null) {
            return false;
        }
        Mage mage = this.context.getMage();
        ConfigurationSection mageData = mage.getData();
        Location location = ConfigurationUtils.getLocation(mageData, this.markerKey);
        this.context.registerForUndo(new UndoMarkerMove(mage, location));
        if (location != null) {
            this.context.sendMessageKey("cast_marker_move");
        } else {
            this.context.sendMessageKey("cast_marker_place");
        }
        location = this.context.getLocation();
        location.setX((double)target.getX() + 0.5);
        location.setY((double)target.getY());
        location.setZ((double)target.getZ() + 0.5);
        mageData.set(this.markerKey, (Object)ConfigurationUtils.fromLocation(location));
        return true;
    }

    private class Waypoint
    implements Comparable<Waypoint> {
        public final RecallType type;
        public final String name;
        public final String description;
        public final Location location;
        public final String message;
        public final String failMessage;
        public final MaterialAndData icon;
        public final String iconURL;
        public final String command;
        public final boolean opPlayer;
        public final boolean asConsole;
        public final boolean maintainDirection;
        public final String warpName;
        public final String serverName;
        public boolean safe = true;

        public Waypoint(RecallType type, Location location, String name, String message, String failMessage, String description, MaterialAndData icon, boolean maintainDirection) {
            this.name = name;
            this.type = type;
            this.location = location;
            this.message = message;
            this.description = description;
            this.failMessage = failMessage;
            this.icon = icon == null ? defaultMaterial : icon;
            this.iconURL = null;
            this.command = null;
            this.opPlayer = false;
            this.asConsole = false;
            this.maintainDirection = maintainDirection;
            this.serverName = null;
            this.warpName = null;
        }

        public Waypoint(RecallType type, Location location, String name, String message, String failMessage, String description, MaterialAndData icon, String iconURL) {
            this.name = name;
            this.type = type;
            this.location = location;
            this.message = message;
            this.description = description;
            this.failMessage = failMessage;
            this.icon = icon == null ? defaultMaterial : icon;
            this.iconURL = iconURL;
            this.command = null;
            this.opPlayer = false;
            this.asConsole = false;
            this.maintainDirection = false;
            this.serverName = null;
            this.warpName = null;
        }

        public Waypoint(RecallType type, String warpName, String serverName, String name, String message, String failMessage, String description, MaterialAndData icon, String iconURL) {
            this.name = name;
            this.type = type;
            this.location = null;
            this.warpName = warpName;
            this.serverName = serverName;
            this.message = message;
            this.description = description;
            this.failMessage = failMessage;
            this.icon = icon == null ? defaultMaterial : icon;
            this.iconURL = iconURL;
            this.command = null;
            this.opPlayer = false;
            this.asConsole = false;
            this.maintainDirection = false;
        }

        public Waypoint(RecallType type, String command, boolean opPlayer, boolean asConsole, String name, String message, String failMessage, String description, MaterialAndData icon, String iconURL) {
            this.name = name;
            this.type = type;
            this.location = null;
            this.message = message;
            this.description = description;
            this.failMessage = failMessage;
            this.icon = icon == null ? defaultMaterial : icon;
            this.iconURL = iconURL;
            this.command = command;
            this.opPlayer = opPlayer;
            this.asConsole = asConsole;
            this.maintainDirection = false;
            this.serverName = null;
            this.warpName = null;
        }

        @Override
        public int compareTo(Waypoint o) {
            if (this.type != o.type) {
                if (this.type == RecallType.COMMAND) {
                    return -1;
                }
                if (o.type == RecallType.COMMAND) {
                    return 1;
                }
                if (this.type == RecallType.WARP) {
                    return -1;
                }
                if (o.type == RecallType.WARP) {
                    return 1;
                }
            }
            return this.name.compareTo(o.name);
        }

        public boolean isValid(boolean crossWorld, Location source) {
            if (this.isCommand()) {
                return true;
            }
            if (this.location == null || this.location.getWorld() == null) {
                return this.serverName != null && this.warpName != null;
            }
            return crossWorld || source.getWorld().equals(this.location.getWorld());
        }

        public boolean isCommand() {
            return this.command != null;
        }
    }

    private static enum RecallType {
        COMMAND,
        WARP,
        DEATH,
        SPAWN,
        HOME,
        WAND,
        MARKER,
        TOWN,
        FIELDS;

    }

    private class UndoMarkerMove
    implements Runnable {
        private final Location location;
        private final Mage mage;

        public UndoMarkerMove(Mage mage, Location currentLocation) {
            this.location = currentLocation;
            this.mage = mage;
        }

        @Override
        public void run() {
            this.mage.getData().set(RecallAction.this.markerKey, (Object)ConfigurationUtils.fromLocation(this.location));
        }
    }
}

