/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.utility.Base64Coder;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryUtils
extends NMSUtils {
    public static boolean saveTagsToItem(ConfigurationSection tags, ItemStack item) {
        Object handle = InventoryUtils.getHandle(item);
        if (handle == null) {
            return false;
        }
        Object tag = InventoryUtils.getTag(handle);
        if (tag == null) {
            return false;
        }
        return InventoryUtils.saveTagsToNBT(tags, tag, null, false, false);
    }

    public static boolean saveTagsToNBT(ConfigurationSection tags, Object node, String[] tagNames) {
        return InventoryUtils.saveTagsToNBT(tags, node, tagNames, true, true);
    }

    public static boolean saveTagsToNBT(ConfigurationSection tags, Object node, String[] tagNames, boolean clean, boolean strings) {
        if (node == null) {
            Bukkit.getLogger().warning("Trying to save tags to a null node");
            return false;
        }
        if (!class_NBTTagCompound.isAssignableFrom(node.getClass())) {
            Bukkit.getLogger().warning("Trying to save tags to a non-CompoundTag");
            return false;
        }
        if (tagNames == null) {
            Set keys = tags.getKeys(false);
            tagNames = new String[keys.size()];
            int index = 0;
            for (String key : keys) {
                tagNames[index++] = key;
            }
        }
        for (String tagName : tagNames) {
            String value = tags.getString(tagName);
            if (clean && (value == null || value.length() == 0 || value.equals("0") || value.equals("0.0") || value.equals("false"))) {
                InventoryUtils.removeMeta(node, tagName);
                continue;
            }
            if (strings) {
                InventoryUtils.setMeta(node, tagName, value);
                continue;
            }
            if (tags.isBoolean(tagName)) {
                InventoryUtils.setMetaBoolean(node, tagName, tags.getBoolean(tagName));
                continue;
            }
            if (tags.isDouble(tagName)) {
                InventoryUtils.setMetaDouble(node, tagName, tags.getDouble(tagName));
                continue;
            }
            if (tags.isInt(tagName)) {
                InventoryUtils.setMetaInt(node, tagName, tags.getInt(tagName));
                continue;
            }
            if (tags.isConfigurationSection(tagName)) {
                Object newNode = InventoryUtils.createNode(node, tagName);
                InventoryUtils.saveTagsToNBT(tags.getConfigurationSection(tagName), newNode, null, clean, strings);
                continue;
            }
            if (tags.isList(tagName)) {
                Collection<ConfigurationSection> nodeList = ConfigurationUtils.getNodeList(tags, tagName);
                try {
                    Object listMeta = class_NBTTagList.newInstance();
                    for (ConfigurationSection nodeConfig : nodeList) {
                        Object newNode = class_NBTTagCompound.newInstance();
                        InventoryUtils.saveTagsToNBT(nodeConfig, newNode, null, clean, strings);
                        class_NBTTagList_addMethod.invoke(listMeta, newNode);
                    }
                    class_NBTTagCompound_setMethod.invoke(node, tagName, listMeta);
                }
                catch (Exception exception) {}
                continue;
            }
            if (!tags.isString(tagName)) continue;
            InventoryUtils.setMeta(node, tagName, tags.getString(tagName));
        }
        return true;
    }

    public static boolean loadTagsFromNBT(ConfigurationSection tags, Object node, String[] tagNames) {
        if (node == null) {
            Bukkit.getLogger().warning("Trying to load tags from a null node");
            return false;
        }
        if (!class_NBTTagCompound.isAssignableFrom(node.getClass())) {
            Bukkit.getLogger().warning("Trying to load tags from a non-CompoundTag");
            return false;
        }
        for (String tagName : tagNames) {
            String meta = InventoryUtils.getMeta(node, tagName);
            if (meta == null || meta.length() <= 0) continue;
            ConfigurationUtils.set(tags, tagName, meta);
        }
        return true;
    }

    public static boolean loadAllTagsFromNBT(ConfigurationSection tags, Object tag) {
        if (tag == null || class_NBTTagCompound_getKeysMethod == null) {
            return false;
        }
        try {
            Set keys = (Set)class_NBTTagCompound_getKeysMethod.invoke(tag, new Object[0]);
            for (String tagName : keys) {
                Object metaBase = class_NBTTagCompound_getMethod.invoke(tag, tagName);
                if (metaBase == null) continue;
                if (class_NBTTagCompound.isAssignableFrom(metaBase.getClass())) {
                    ConfigurationSection newSection = tags.createSection(tagName);
                    InventoryUtils.loadAllTagsFromNBT(newSection, metaBase);
                    continue;
                }
                tags.set(tagName, (Object)metaBase.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean loadAllTagsFromNBT(ConfigurationSection tags, ItemStack item) {
        if (item == null) {
            return false;
        }
        Object handle = InventoryUtils.getHandle(item);
        if (handle == null) {
            return false;
        }
        Object tag = InventoryUtils.getTag(handle);
        if (tag == null) {
            return false;
        }
        return InventoryUtils.loadAllTagsFromNBT(tags, tag);
    }

    public static boolean inventorySetItem(Inventory inventory, int index, ItemStack item) {
        try {
            Method setItemMethod = class_CraftInventoryCustom.getMethod("setItem", Integer.TYPE, ItemStack.class);
            setItemMethod.invoke((Object)inventory, index, item);
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean setInventoryResults(Inventory inventory, ItemStack item) {
        try {
            Method getResultsMethod = inventory.getClass().getMethod("getResultInventory", new Class[0]);
            Object inv = getResultsMethod.invoke((Object)inventory, new Object[0]);
            Method setItemMethod = inv.getClass().getMethod("setItem", Integer.TYPE, class_ItemStack);
            setItemMethod.invoke(inv, 0, InventoryUtils.getHandle(item));
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static ItemStack getURLSkull(String url) {
        return InventoryUtils.getURLSkull(url, "MHF_Question", UUID.randomUUID(), null);
    }

    public static ItemStack getURLSkull(URL url) {
        return InventoryUtils.getURLSkull(url, "MHF_Question", UUID.randomUUID(), null);
    }

    public static ItemStack getURLSkull(String url, String ownerName, UUID id, String itemName) {
        try {
            return InventoryUtils.getURLSkull(new URL(url), ownerName, id, itemName);
        }
        catch (MalformedURLException e) {
            Bukkit.getLogger().log(Level.WARNING, "Malformed URL: " + url, e);
            return new ItemStack(Material.SKULL_ITEM, 1, 0, Byte.valueOf((byte)3));
        }
    }

    public static ItemStack getURLSkull(URL url, String ownerName, UUID id, String itemName) {
        ItemStack skull = new ItemStack(Material.SKULL_ITEM, 1, 0, Byte.valueOf((byte)3));
        if (itemName != null) {
            ItemMeta meta = skull.getItemMeta();
            if (itemName != null) {
                meta.setDisplayName(itemName);
            }
            skull.setItemMeta(meta);
        }
        try {
            skull = InventoryUtils.makeReal(skull);
            Object skullOwner = InventoryUtils.createNode(skull, "SkullOwner");
            InventoryUtils.setMeta(skullOwner, "Id", id.toString());
            InventoryUtils.setMeta(skullOwner, "Name", ownerName);
            Object properties = InventoryUtils.createNode(skullOwner, "Properties");
            Object listMeta = class_NBTTagList.newInstance();
            Object textureNode = class_NBTTagCompound.newInstance();
            String textureJSON = "{textures:{SKIN:{url:\"" + url + "\"}}}";
            String encoded = Base64Coder.encodeString(textureJSON);
            InventoryUtils.setMeta(textureNode, "Value", encoded);
            class_NBTTagList_addMethod.invoke(listMeta, textureNode);
            class_NBTTagCompound_setMethod.invoke(properties, "textures", listMeta);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return skull;
    }

    public static String getProfileURL(Object profile) {
        String url = null;
        if (profile == null) {
            return null;
        }
        try {
            Multimap properties = (Multimap)class_GameProfile_properties.get(profile);
            Collection textures = properties.get((Object)"textures");
            if (textures != null && textures.size() > 0) {
                Object textureProperty = textures.iterator().next();
                String texture = (String)class_GameProfileProperty_value.get(textureProperty);
                String decoded = Base64Coder.decodeString(texture);
                url = decoded.replace("{textures:{SKIN:{url:\"", "").replace("\"}}}", "").trim();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return url;
    }

    public static String getSkullURL(ItemStack skull) {
        return InventoryUtils.getProfileURL(InventoryUtils.getSkullProfile(skull.getItemMeta()));
    }

    public static ItemStack getPlayerSkull(String playerName) {
        return InventoryUtils.getPlayerSkull(playerName, UUID.randomUUID(), null);
    }

    public static ItemStack getPlayerSkull(String playerName, String itemName) {
        return InventoryUtils.getPlayerSkull(playerName, UUID.randomUUID(), itemName);
    }

    public static ItemStack getPlayerSkull(String playerName, UUID uuid) {
        return InventoryUtils.getPlayerSkull(playerName, uuid, null);
    }

    public static ItemStack getPlayerSkull(String playerName, UUID uuid, String itemName) {
        return InventoryUtils.getURLSkull("http://skins.minecraft.net/MinecraftSkins/" + playerName + ".png", playerName, uuid, itemName);
    }

    public static ItemStack getPlayerSkull(Player player) {
        return InventoryUtils.getPlayerSkull(player, null);
    }

    public static ItemStack getPlayerSkull(Player player, String itemName) {
        return InventoryUtils.getPlayerSkull(player.getName(), player.getUniqueId(), itemName);
    }

    public static Object getSkullProfile(ItemMeta itemMeta) {
        Object profile = null;
        try {
            if (itemMeta == null || !class_CraftMetaSkull.isInstance(itemMeta)) {
                return null;
            }
            profile = class_CraftMetaSkull_profile.get(itemMeta);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return profile;
    }

    public static boolean setSkullProfile(ItemMeta itemMeta, Object data) {
        try {
            if (itemMeta == null || !class_CraftMetaSkull.isInstance(itemMeta)) {
                return false;
            }
            class_CraftMetaSkull_profile.set(itemMeta, data);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void setCount(ItemStack stack, int count) {
        if (stack == null) {
            return;
        }
        try {
            Object handle = InventoryUtils.getHandle(stack);
            if (handle == null) {
                return;
            }
            class_ItemStack_count.set(handle, count);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void wrapText(String text, int maxLength, Collection<String> list) {
        while (text.length() > maxLength) {
            int spaceIndex = text.lastIndexOf(32, maxLength);
            if (spaceIndex <= 0) {
                list.add(text);
                return;
            }
            list.add(text.substring(0, spaceIndex));
            text = text.substring(spaceIndex);
        }
        list.add(text);
    }

    public static boolean hasItem(Mage mage, String itemName) {
        return InventoryUtils.hasItem(mage.getInventory(), itemName);
    }

    public static boolean hasItem(Inventory inventory, String itemName) {
        ItemStack[] items;
        if (inventory == null) {
            return false;
        }
        for (ItemStack item : items = inventory.getContents()) {
            String displayName;
            if (item == null || !item.hasItemMeta() || (displayName = item.getItemMeta().getDisplayName()) == null || !displayName.equals(itemName)) continue;
            return true;
        }
        return false;
    }

    public static void openSign(Player player, Location signBlock) {
        try {
            Object tileEntity = InventoryUtils.getTileEntity(signBlock);
            Object playerHandle = InventoryUtils.getHandle(player);
            if (tileEntity != null && playerHandle != null) {
                class_EntityPlayer_openSignMethod.invoke(playerHandle, tileEntity);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void makeKeep(ItemStack itemStack) {
        InventoryUtils.setMeta(itemStack, "keep", "true");
    }

    public static boolean isKeep(ItemStack itemStack) {
        return InventoryUtils.hasMeta(itemStack, "keep");
    }

    public static void applyEnchantments(ItemStack item, ConfigurationSection enchantConfig) {
        if (item == null || enchantConfig == null) {
            return;
        }
        Set enchantKeys = enchantConfig.getKeys(false);
        for (String enchantKey : enchantKeys) {
            try {
                Enchantment enchantment = Enchantment.getByName((String)enchantKey.toUpperCase());
                item.addUnsafeEnchantment(enchantment, enchantConfig.getInt(enchantKey));
            }
            catch (Exception ex) {
                Bukkit.getLogger().warning("Invalid enchantment: " + enchantKey);
            }
        }
    }
}

