/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration;

import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class LibsDisguiseManager {
    private final Plugin plugin;
    private final Plugin disguisePlugin;

    public LibsDisguiseManager(Plugin owningPlugin, Plugin disguisePlugin) {
        this.plugin = owningPlugin;
        this.disguisePlugin = disguisePlugin;
    }

    public boolean initialize() {
        return this.disguisePlugin != null && this.disguisePlugin instanceof LibsDisguises;
    }

    public boolean isDisguised(Entity entity) {
        return DisguiseAPI.isDisguised((Entity)entity);
    }

    public boolean disguise(Entity entity, ConfigurationSection configuration) {
        String disguiseName = configuration.getString("type");
        if (disguiseName == null || disguiseName.isEmpty()) {
            return false;
        }
        try {
            DisguiseType disguiseType = DisguiseType.valueOf((String)disguiseName.toUpperCase());
            MobDisguise disguise = null;
            switch (disguiseType) {
                case PLAYER: {
                    PlayerDisguise playerDisguise = new PlayerDisguise(configuration.getString("name"));
                    String skin = configuration.getString("skin");
                    if (skin != null) {
                        playerDisguise.setSkin(skin);
                    }
                    disguise = playerDisguise;
                    break;
                }
                default: {
                    disguise = new MobDisguise(disguiseType);
                }
            }
            DisguiseAPI.disguiseEntity((Entity)entity, (Disguise)disguise);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }
}

