/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effect;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SoundEffect
implements com.elmakers.mine.bukkit.api.effect.SoundEffect {
    private Sound sound;
    private String customSound;
    private float volume = 1.0f;
    private float pitch = 1.0f;
    private int range = 0;

    public SoundEffect(Sound sound) {
        this.sound = sound;
        this.customSound = null;
    }

    public SoundEffect(String key) {
        if (key != null && key.length() > 0) {
            String[] pieces = StringUtils.split((String)key, (char)',');
            String soundName = pieces[0];
            if (soundName.indexOf(46) < 0) {
                try {
                    this.sound = Sound.valueOf((String)soundName.toUpperCase());
                }
                catch (Exception ex) {
                    this.sound = null;
                    this.customSound = soundName;
                }
            } else {
                this.customSound = soundName;
            }
            if (pieces.length > 1) {
                try {
                    this.volume = Float.parseFloat(pieces[1]);
                }
                catch (Exception ex) {
                    this.volume = 1.0f;
                }
            }
            if (pieces.length > 2) {
                try {
                    this.pitch = Float.parseFloat(pieces[2]);
                }
                catch (Exception ex) {
                    this.pitch = 1.0f;
                }
            }
        }
    }

    @Override
    public String getCustomSound() {
        return this.customSound;
    }

    @Override
    public Sound getSound() {
        return this.sound;
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public String toString() {
        return this.sound.name() + "," + this.volume + "," + this.pitch;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SoundEffect)) {
            return false;
        }
        SoundEffect otherEffect = (SoundEffect)other;
        return this.sound != otherEffect.sound || this.pitch != otherEffect.pitch || this.volume != otherEffect.volume;
    }

    @Override
    public int getRange() {
        return this.range;
    }

    @Override
    public void play(Plugin plugin, Location sourceLocation) {
        if (sourceLocation == null || plugin == null) {
            return;
        }
        try {
            if (this.customSound != null) {
                int range = this.range;
                if (range <= 0) {
                    range = (int)((double)this.volume > 1.0 ? 16.0 * (double)this.volume : 16.0);
                }
                int rangeSquared = range * range;
                Collection players = plugin.getServer().getOnlinePlayers();
                for (Player player : players) {
                    Location location = player.getLocation();
                    if (!location.getWorld().equals(sourceLocation.getWorld()) || !(location.distanceSquared(sourceLocation) <= (double)rangeSquared)) continue;
                    player.playSound(sourceLocation, this.customSound, this.volume, this.pitch);
                }
            }
            if (this.sound != null) {
                sourceLocation.getWorld().playSound(sourceLocation, this.sound, this.volume, this.pitch);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void play(Plugin plugin, Entity entity) {
        if (entity == null || plugin == null) {
            return;
        }
        Location sourceLocation = entity.getLocation();
        try {
            if (this.customSound != null) {
                if (this.range > 0) {
                    int rangeSquared = this.range * this.range;
                    Collection players = plugin.getServer().getOnlinePlayers();
                    for (Player player : players) {
                        Location location = player.getLocation();
                        if (!location.getWorld().equals(sourceLocation.getWorld()) || !(location.distanceSquared(sourceLocation) <= (double)rangeSquared)) continue;
                        player.playSound(sourceLocation, this.customSound, this.volume, this.pitch);
                    }
                } else if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.playSound(sourceLocation, this.customSound, this.volume, this.pitch);
                }
            }
            if (this.sound != null) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.playSound(sourceLocation, this.sound, this.volume, this.pitch);
                } else {
                    sourceLocation.getWorld().playSound(sourceLocation, this.sound, this.volume, this.pitch);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

