/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.SafetyUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class VelocityAction
extends BaseSpellAction {
    private double livingEntitySpeed;
    private double itemSpeed;
    private double defaultSpeed;
    private double minSpeed;
    private double maxSpeed;
    private int maxSpeedAtElevation;
    private double pushDirection;
    private int yOffset;
    private int exemptionDuration;
    private double maxMagnitude;
    private double maxLength;
    private boolean additive;
    private Vector direction;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.defaultSpeed = parameters.getDouble("speed", 1.0);
        this.livingEntitySpeed = parameters.getDouble("living_entity_speed", this.defaultSpeed);
        this.itemSpeed = parameters.getDouble("item_speed", this.defaultSpeed);
        this.maxSpeedAtElevation = parameters.getInt("max_altitude", 64);
        this.minSpeed = parameters.getDouble("min_speed", 0.0);
        this.maxSpeed = parameters.getDouble("max_speed", 0.0);
        this.pushDirection = parameters.getDouble("push", 0.0);
        this.yOffset = parameters.getInt("y_offset", 0);
        this.direction = ConfigurationUtils.getVector(parameters, "direction");
        this.exemptionDuration = parameters.getInt("exemption_duration", (int)(this.maxSpeed * 2000.0));
        this.maxMagnitude = parameters.getDouble("max_magnitude", 0.0);
        this.maxLength = this.maxMagnitude * this.maxMagnitude;
        this.additive = parameters.getBoolean("additive", false);
    }

    @Override
    public SpellResult perform(CastContext context) {
        Vector velocity;
        Entity entity = context.getTargetEntity();
        if (entity instanceof Hanging) {
            return SpellResult.NO_TARGET;
        }
        Entity mountEntity = entity.getVehicle();
        while (mountEntity != null) {
            entity = mountEntity;
            mountEntity = entity.getVehicle();
        }
        double magnitude = this.defaultSpeed;
        if (entity instanceof LivingEntity) {
            magnitude = this.livingEntitySpeed;
        } else if (entity instanceof Item) {
            magnitude = this.itemSpeed;
        }
        if (this.minSpeed > 0.0 || this.maxSpeed > 0.0) {
            int height;
            Block playerBlock = context.getLocation().getBlock();
            for (height = 0; height < this.maxSpeedAtElevation && playerBlock.getType() == Material.AIR; ++height) {
                playerBlock = playerBlock.getRelative(BlockFace.DOWN);
            }
            double heightModifier = this.maxSpeedAtElevation > 0 ? (double)height / (double)this.maxSpeedAtElevation : 1.0;
            magnitude = this.minSpeed + (this.maxSpeed - this.minSpeed) * heightModifier;
        }
        Vector vector = velocity = this.direction == null ? context.getDirection() : this.direction.clone();
        if (this.pushDirection != 0.0) {
            Location to = entity.getLocation();
            Location from = context.getLocation();
            Vector toVector = new Vector(to.getBlockX(), to.getBlockY(), to.getBlockZ());
            Vector fromVector = new Vector(from.getBlockX(), from.getBlockY(), from.getBlockZ());
            velocity = toVector;
            velocity.subtract(fromVector);
            if (velocity.lengthSquared() < Double.MIN_NORMAL) {
                velocity = context.getDirection();
            }
            velocity.normalize().multiply(this.pushDirection);
        }
        if (context.getLocation().getBlockY() >= 256) {
            velocity.setY(0);
        } else if (this.yOffset != 0) {
            velocity.setY(velocity.getY() + (double)this.yOffset);
        }
        velocity.multiply(magnitude);
        if (this.additive) {
            velocity = entity.getVelocity().clone().add(velocity);
        }
        if (this.maxLength != 0.0 && velocity.lengthSquared() > this.maxLength) {
            velocity = velocity.normalize().multiply(this.maxMagnitude);
            magnitude = this.maxMagnitude;
        }
        context.registerVelocity(entity);
        context.registerMoved(entity);
        if (this.exemptionDuration > 0 && entity instanceof Player) {
            context.getController().addFlightExemption((Player)entity, this.exemptionDuration);
        }
        context.getMage().sendDebugMessage(ChatColor.AQUA + "Applying velocity of " + ChatColor.BLUE + velocity + ChatColor.AQUA + " to " + ChatColor.DARK_AQUA + entity.getType() + ChatColor.AQUA + " from magnitude of " + ChatColor.BLUE + magnitude, 11);
        SafetyUtils.setVelocity(entity, velocity);
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("push");
        parameters.add("speed");
        parameters.add("living_entity_speed");
        parameters.add("item_speed");
        parameters.add("min_speed");
        parameters.add("max_speed");
        parameters.add("max_altitude");
        parameters.add("exemption_duration");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("push")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("speed") || parameterKey.equals("living_entity_speed") || parameterKey.equals("item_speed") || parameterKey.equals("min_speed") || parameterKey.equals("max_speed") || parameterKey.equals("max_altitude")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }
}

