/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseProjectileAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.SafetyUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ThrowBlockAction
extends BaseProjectileAction {
    private double speedMin;
    private double speedMax;
    private float fallDamage;
    private int maxDamage;
    private boolean consumeBlocks = false;
    private boolean consumeVariants = true;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        double itemSpeed = parameters.getDouble("speed", (double)0.6f);
        this.speedMin = parameters.getDouble("speed_min", itemSpeed);
        this.speedMax = parameters.getDouble("speed_max", itemSpeed);
        int damage = parameters.getInt("damage", 0);
        this.fallDamage = (float)parameters.getDouble("fall_damage", (double)damage);
        this.maxDamage = parameters.getInt("max_damage", damage);
        this.consumeBlocks = parameters.getBoolean("consume", false);
        this.consumeVariants = parameters.getBoolean("consume_variants", true);
    }

    @Override
    public SpellResult start(CastContext context) {
        Location location = context.getLocation();
        if (!context.hasBuildPermission(location.getBlock())) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        location.setY(location.getY() - 1.0);
        MaterialBrush buildWith = context.getBrush();
        buildWith.setTarget(location);
        if (buildWith.isErase() || buildWith.getMaterial() == Material.AIR) {
            return SpellResult.NO_TARGET;
        }
        if (this.consumeBlocks && !context.isConsumeFree()) {
            ItemStack requires;
            Mage mage = context.getMage();
            UndoList undoList = context.getUndoList();
            if (undoList != null) {
                undoList.setConsumed(true);
            }
            if (!mage.hasItem(requires = buildWith.getItemStack(1), this.consumeVariants)) {
                String requiresMessage = context.getMessage("insufficient_resources");
                context.sendMessage(requiresMessage.replace("$cost", buildWith.getName()));
                return SpellResult.STOP;
            }
            mage.removeItem(requires, this.consumeVariants);
        }
        Material material = buildWith.getMaterial();
        byte data = buildWith.getBlockData();
        Vector direction = context.getDirection();
        double speed = context.getRandom().nextDouble() * (this.speedMax - this.speedMin) + this.speedMin;
        direction.normalize().multiply(speed);
        Vector up = new Vector(0, 1, 0);
        Vector perp = new Vector();
        perp.copy(direction);
        perp.crossProduct(up);
        location = context.getEyeLocation();
        FallingBlock falling = context.getWorld().spawnFallingBlock(location, material, data);
        if (falling == null) {
            return SpellResult.FAIL;
        }
        this.track(context, (Entity)falling);
        if (!this.consumeBlocks) {
            falling.setDropItem(false);
        }
        SafetyUtils.setVelocity((Entity)falling, direction);
        if (this.maxDamage > 0 && this.fallDamage > 0.0f) {
            CompatibilityUtils.setFallingBlockDamage(falling, this.fallDamage, this.maxDamage);
        }
        return this.checkTracking(context);
    }

    @Override
    public boolean requiresBuildPermission() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean usesBrush() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("speed");
        parameters.add("speed_min");
        parameters.add("speed_max");
        parameters.add("damage");
        parameters.add("max_damage");
        parameters.add("fall_damage");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("speed") || parameterKey.equals("speed_max") || parameterKey.equals("speed_min") || parameterKey.equals("damage") || parameterKey.equals("max_damage") || parameterKey.equals("fall_damage")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

