/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.util.Vector;

public class ThrustSpell
extends TargetingSpell {
    protected Integer taskId;
    public static int tickSpan = 2;
    protected int targetHeight = 0;
    protected int checkCounter = 0;
    protected int groundHeight = 0;
    protected float hoverHeight = 0.0f;
    protected long lastTick = 0L;
    protected int checkFrequency = 10;
    protected int maxTerrainChangeHeight = 4;
    protected int defaultHoverHeight = 5;
    protected int elevateRate = 32;
    protected int maxSpeedAtElevation = 32;
    protected int maxSpeed = 20;
    protected int minSpeed = 6;
    protected float gravity = 0.98f;
    protected double overallScale = 1.0;
    protected static LevitateAction action = null;

    protected void checkForGround() {
        this.checkCounter = 0;
        Location playerLocation = this.getLocation();
        World world = playerLocation.getWorld();
        Block targetBlock = world.getBlockAt(playerLocation);
        targetBlock = targetBlock.getRelative(BlockFace.DOWN);
        int newGroundHeight = targetBlock.getY();
        while (targetBlock.getType() == Material.AIR && newGroundHeight > 1) {
            --newGroundHeight;
            targetBlock = targetBlock.getRelative(BlockFace.DOWN);
        }
        if (this.groundHeight == 0 || this.targetHeight == 0) {
            this.hoverHeight = this.mage.getEntity().getLocation().getBlockY() - newGroundHeight;
            if (this.hoverHeight < (float)this.defaultHoverHeight) {
                this.hoverHeight = this.defaultHoverHeight;
            }
        } else if (Math.abs(newGroundHeight - this.groundHeight) > this.maxTerrainChangeHeight) {
            this.hoverHeight = this.targetHeight - newGroundHeight;
        }
        this.groundHeight = newGroundHeight;
        this.updateTargetHeight();
    }

    protected void updateTargetHeight() {
        this.targetHeight = (int)(this.hoverHeight + (float)this.groundHeight);
        if (this.targetHeight > 255) {
            this.targetHeight = 255;
        }
    }

    @Override
    public boolean isActive() {
        return this.taskId != null && !this.mage.isDead() && this.mage.isOnline();
    }

    public void scheduleForce(Runnable runnable) {
        this.taskId = null;
        if (!this.mage.isDead() && this.mage.isOnline()) {
            Plugin plugin = this.controller.getPlugin();
            this.taskId = Bukkit.getScheduler().scheduleSyncDelayedTask(plugin, (Runnable)new LevitateAction(this), (long)tickSpan);
        }
    }

    protected void applyForce() {
        if (!this.isActive()) {
            return;
        }
        Entity entity = this.mage.getEntity();
        if (entity == null) {
            this.deactivate();
            return;
        }
        float timeDeltaSeconds = (float)(System.currentTimeMillis() - this.lastTick) / 1000.0f;
        Vector force = new Vector(0.0f, this.gravity * timeDeltaSeconds, 0.0f);
        float elevateMagnitude = (float)this.elevateRate * timeDeltaSeconds;
        float speedMinMagnitude = (float)this.minSpeed * timeDeltaSeconds;
        float speedMaxMagnitude = (float)this.maxSpeed * timeDeltaSeconds;
        Location playerLocation = this.mage.getEntity().getLocation();
        float pitch = playerLocation.getPitch();
        float yaw = playerLocation.getYaw();
        Vector scaledForce = force.clone();
        int playerHeight = playerLocation.getBlockY();
        int heightDelta = this.targetHeight - playerHeight;
        if (heightDelta > 0) {
            int heightBoost = heightDelta > 16 ? 16 : heightDelta;
            scaledForce.multiply(heightBoost);
        } else if (heightDelta < 0) {
            scaledForce.setY(0);
        }
        Vector aim = new Vector(0.0 - Math.sin(Math.toRadians(yaw)), 0.0 - Math.sin(Math.toRadians(pitch += 15.0f)), Math.cos(Math.toRadians(yaw)));
        aim.normalize();
        if (heightDelta < 5 && pitch < -45.0f) {
            this.hoverHeight = (float)((double)this.hoverHeight + (double)elevateMagnitude * aim.getY());
            if (this.hoverHeight > 255.0f) {
                this.hoverHeight = 255.0f;
            }
            if (this.hoverHeight < (float)this.defaultHoverHeight) {
                this.hoverHeight = this.defaultHoverHeight;
            }
            this.updateTargetHeight();
        }
        if (this.checkCounter++ > this.checkFrequency) {
            this.checkForGround();
        }
        float multiplier = speedMinMagnitude;
        Player player = this.mage.getPlayer();
        if (player == null || !player.isSneaking()) {
            int heightFactor = this.hoverHeight > (float)this.maxSpeedAtElevation ? this.maxSpeedAtElevation : (int)this.hoverHeight;
            multiplier *= speedMaxMagnitude * (float)heightFactor / (float)this.maxSpeedAtElevation;
        }
        float verticalMultipler = 1.0f - (float)Math.abs(aim.getY());
        aim.multiply(multiplier * verticalMultipler);
        aim.setY(0);
        scaledForce.add(aim);
        scaledForce.multiply(this.overallScale);
        if (scaledForce.lengthSquared() > 0.001) {
            entity.setVelocity(scaledForce);
        }
        this.lastTick = System.currentTimeMillis();
    }

    @Override
    public void onDeactivate() {
        if (this.taskId != null) {
            BukkitScheduler scheduler = Bukkit.getScheduler();
            scheduler.cancelTask(this.taskId.intValue());
        }
        this.taskId = null;
    }

    @Override
    public void onActivate() {
        Entity entity = this.mage.getEntity();
        if (entity == null) {
            return;
        }
        this.onDeactivate();
        this.scheduleForce(new LevitateAction(this));
    }

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        this.overallScale = parameters.getDouble("scale", 1.0);
        this.lastTick = System.currentTimeMillis();
        this.hoverHeight = this.defaultHoverHeight;
        Entity entity = this.mage.getEntity();
        if (entity == null) {
            return SpellResult.ENTITY_REQUIRED;
        }
        if (this.isActive()) {
            this.deactivate();
            return SpellResult.DEACTIVATE;
        }
        this.activate();
        return SpellResult.CAST;
    }

    public class LevitateAction
    implements Runnable {
        private final ThrustSpell spell;

        public LevitateAction(ThrustSpell spell) {
            this.spell = spell;
        }

        @Override
        public void run() {
            this.spell.applyForce();
            this.spell.scheduleForce(this);
        }
    }
}

