/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.effect.builtin.EffectRing;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.HorseJumpEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class LevitateSpell
extends TargetingSpell
implements Listener {
    private static final BlockFace[] CHECK_FACES = new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH};
    private static final float defaultFlySpeed = 0.1f;
    private static Class<?> worldClass;
    private final int safetyLength = 10000;
    private float flySpeed = 0.0f;
    private int flyDelay = 2;
    private int startDelay = 0;
    private int autoDeactivateHeight = 0;
    private int boostTicksRemaining = 0;
    private double castBoost = 0.0;
    private int boostTicks = 0;
    private double yBoost = 2.0;
    private float thrustSpeed = 0.0f;
    private int thrustFrequency = 1;
    private int deactivateFrequency = 10;
    private ThrustAction thrust;
    private double crashDistance = 0.0;
    private double slowMultiplier = 1.0;
    private int maxHeight;
    private int maxHeightAboveGround;
    private boolean flight = true;
    private boolean mountSilent = true;
    private boolean mountBaby = false;
    private boolean smallArmorStand = false;
    private boolean useArmorStand = false;
    private boolean armorStandMarker = false;
    private boolean useHelmet = false;
    private Material mountItem = null;
    private Vector armorStandArm = null;
    private Vector armorStandHead = null;
    private Vector armorStandBody = null;
    private double pitchAmount = 0.0;
    private double yawAmount = 0.0;
    private double rollAmount = 0.0;
    private ArmorStand armorStand = null;
    private EntityType mountType = null;
    private Entity mountEntity = null;
    private Horse.Variant mountHorseVariant = null;
    private Horse.Color mountHorseColor = null;
    private Horse.Style mountHorseStyle = null;
    private double maxMountBoost = 1.0;
    private double mountBoostPerJump = 0.5;
    private double mountHealth = 8.0;
    private int slowReduceBoostTicks = 4;
    private int mountBoostTicks = 80;
    private boolean mountInvisible = true;
    private int forceSneak = 0;
    private double moveDistance = 0.0;
    private double sneakMoveDistance = -1.0;
    private CreatureSpawnEvent.SpawnReason mountSpawnReason = CreatureSpawnEvent.SpawnReason.CUSTOM;
    private Vector directionOffset = null;
    private Double directionForceY = null;
    private Vector direction = null;
    private boolean grounded = false;
    private boolean stashItem = false;
    private ItemStack heldItem = null;
    private int heldItemSlot = 0;
    private int mountBoostTicksRemaining = 0;
    private static LevitateListener listener;
    private Collection<PotionEffect> crashEffects;
    private Sound effectSound = null;
    private int effectSoundInterval = 20;
    private int effectSoundCounter = 0;
    private float effectSoundVolume = 1.0f;
    private float effectSoundPitch = 1.0f;
    private ParticleEffect effectParticle = null;
    private float effectParticleData = 0.0f;
    private int effectParticleCount = 0;
    private int effectParticleInterval = 20;
    private int effectParticleCounter = 0;
    private EffectRing effectPlayer = null;

    protected void thrust() {
        double move;
        boolean checkHeight;
        boolean isSneaking;
        if (this.thrustSpeed == 0.0f) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        this.mage.enableFallProtection(10000, this);
        if (this.mountEntity != null) {
            Entity currentPassenger;
            Entity currentMount = player.getVehicle();
            if (currentMount != this.mountEntity) {
                this.crash();
                return;
            }
            if (this.armorStand != null && (currentPassenger = this.armorStand.getPassenger()) != this.mountEntity) {
                this.crash();
                return;
            }
        }
        boolean bl = isSneaking = this.mage.isPlayer() ? this.mage.getPlayer().isSneaking() : false;
        if (!this.flight && isSneaking) {
            this.land();
            return;
        }
        boolean bl2 = checkHeight = this.autoDeactivateHeight > 0 && isSneaking;
        if (checkHeight) {
            int height;
            Block block = player.getLocation().getBlock();
            for (height = 0; height < this.autoDeactivateHeight && block.getType() == Material.AIR; ++height) {
                block = block.getRelative(BlockFace.DOWN);
            }
            if (height < this.autoDeactivateHeight) {
                this.land();
                return;
            }
        }
        Location location = this.getLocation();
        Vector mageDirection = this.getDirection().clone();
        if (this.directionForceY != null) {
            mageDirection.setY(this.directionForceY.doubleValue());
        }
        if (this.directionOffset != null) {
            mageDirection.add(this.directionOffset);
        }
        boolean sneaking = player.isSneaking() || this.forceSneak > 0;
        double d = move = this.sneakMoveDistance >= 0.0 && sneaking ? this.sneakMoveDistance : this.moveDistance;
        if (this.direction == null || move <= 0.0 || this.grounded) {
            this.direction = mageDirection;
        } else {
            double moveDistanceSquared = move * move;
            double distanceSquared = this.direction.distanceSquared(mageDirection);
            if (distanceSquared <= moveDistanceSquared) {
                this.direction = mageDirection;
            } else {
                Vector targetDirection = mageDirection.subtract(this.direction).normalize().multiply(move);
                this.direction.add(targetDirection);
            }
        }
        this.grounded = false;
        if (this.maxHeight > 0 && player.getLocation().getY() >= (double)this.maxHeight) {
            this.direction.setY(-1);
            this.grounded = true;
        } else if (this.maxHeightAboveGround > 0) {
            Block block = player.getLocation().getBlock();
            for (int height = 0; height < this.maxHeightAboveGround && block.getType() == Material.AIR; ++height) {
                block = block.getRelative(BlockFace.DOWN);
            }
            if (block.getType() == Material.AIR) {
                this.direction.setY(-1);
                this.grounded = true;
            }
        }
        this.direction.normalize();
        if (this.crashDistance > 0.0) {
            Vector threshold = this.direction.clone().multiply(this.crashDistance);
            if (this.checkForCrash(this.mage.getEyeLocation(), threshold)) {
                this.crash();
                return;
            }
            if (this.checkForCrash(this.mage.getLocation(), threshold)) {
                this.crash();
                return;
            }
        }
        double boost = this.thrustSpeed;
        if (this.mage.getPlayer().isSneaking() || this.forceSneak > 0) {
            --this.forceSneak;
            if (this.slowReduceBoostTicks > 0) {
                this.mountBoostTicksRemaining = Math.max(0, this.mountBoostTicksRemaining - this.slowReduceBoostTicks);
                this.updateMountHealth();
            }
            if (this.mountBoostTicksRemaining == 0) {
                boost *= this.slowMultiplier;
            }
        }
        if (this.mountBoostTicksRemaining > 0 && this.mountBoostTicks > 0) {
            boost += this.maxMountBoost * ((double)this.mountBoostTicksRemaining / (double)this.mountBoostTicks);
            --this.mountBoostTicksRemaining;
            this.updateMountHealth();
        } else if (this.boostTicksRemaining > 0) {
            boost += this.castBoost;
            --this.boostTicksRemaining;
        }
        this.direction.multiply(boost);
        if (this.mountEntity != null) {
            ArmorStand activeArmorStand;
            Object object = this.armorStand != null ? this.armorStand : (activeArmorStand = this.mountEntity instanceof ArmorStand ? (ArmorStand)this.mountEntity : null);
            if (activeArmorStand != null) {
                activeArmorStand.setVelocity(this.direction);
                CompatibilityUtils.setYawPitch((Entity)activeArmorStand, location.getYaw() + (float)this.yawAmount, location.getPitch());
                if (this.pitchAmount != 0.0) {
                    if (this.armorStandHead == null && this.useHelmet) {
                        activeArmorStand.setHeadPose(new EulerAngle(this.pitchAmount * (double)location.getPitch() / 180.0 * Math.PI, 0.0, 0.0));
                    } else if (!this.useHelmet) {
                        EulerAngle armPose = activeArmorStand.getRightArmPose();
                        armPose.setY(this.pitchAmount * (double)location.getPitch() / 180.0 * Math.PI);
                        armPose.setZ(this.rollAmount);
                        activeArmorStand.setRightArmPose(armPose);
                    }
                }
            } else {
                this.mountEntity.setVelocity(this.direction);
            }
        } else {
            player.setVelocity(this.direction);
        }
        if (this.effectParticle != null && this.effectParticleCounter++ % this.effectParticleInterval == 0) {
            if (this.effectPlayer == null) {
                this.effectPlayer = new EffectRing(this.controller.getPlugin());
                this.effectPlayer.setParticleCount(2);
                this.effectPlayer.setIterations(2);
                this.effectPlayer.setRadius(2.0f);
                this.effectPlayer.setSize(5);
                this.effectPlayer.setMaterial(location.getBlock().getRelative(BlockFace.DOWN));
            }
            this.effectPlayer.setParticleType(this.effectParticle);
            this.effectPlayer.setParticleData(this.effectParticleData);
            this.effectPlayer.setParticleCount(this.effectParticleCount);
            this.effectPlayer.start(player.getEyeLocation(), null);
        }
        if (this.effectSound != null && this.controller.soundsEnabled() && this.effectSoundCounter++ % this.effectSoundInterval == 0) {
            this.mage.getLocation().getWorld().playSound(location, this.effectSound, this.effectSoundVolume, this.effectSoundPitch);
        }
    }

    protected void crash() {
        this.deactivate(true, false);
        this.sendMessage(this.getMessage("crash"));
        this.mage.deactivateAllSpells();
        this.playEffects("crash");
        LivingEntity livingEntity = this.mage.getLivingEntity();
        if (this.crashEffects != null && livingEntity != null && this.crashEffects.size() > 0) {
            CompatibilityUtils.applyPotionEffects(livingEntity, this.crashEffects);
        }
    }

    protected boolean checkForCrash(Location source, Vector threshold) {
        Block facingBlock = source.getBlock();
        Block targetBlock = source.add(threshold).getBlock();
        return !targetBlock.equals(facingBlock) && !this.isPassthrough(targetBlock.getType());
    }

    protected boolean checkActive() {
        if (!this.isActive()) {
            return false;
        }
        Entity entity = this.mage.getEntity();
        if (entity == null || entity.isDead()) {
            return false;
        }
        return !(entity instanceof Player) || ((Player)entity).isOnline();
    }

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Player player = this.mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        this.direction = null;
        this.directionOffset = ConfigurationUtils.getVector(parameters, "direction_offset");
        this.directionForceY = ConfigurationUtils.getDouble(parameters, "direction_y", null);
        this.flight = parameters.getBoolean("flight", true);
        int checkHeight = parameters.getInt("check_height", 4);
        this.startDelay = parameters.getInt("start_delay", 0);
        this.flyDelay = parameters.getInt("fly_delay", 2);
        this.slowMultiplier = parameters.getDouble("slow", 1.0);
        this.castBoost = parameters.getDouble("boost", 0.0);
        this.deactivateFrequency = parameters.getInt("auto_deactivate", 10);
        this.yBoost = parameters.getDouble("y_boost", 2.0);
        this.flySpeed = (float)parameters.getDouble("speed", 0.0);
        this.thrustSpeed = (float)parameters.getDouble("thrust", 0.0);
        this.thrustFrequency = parameters.getInt("thrust_interval", this.thrustFrequency);
        this.autoDeactivateHeight = parameters.getInt("auto_deactivate", 0);
        this.maxHeight = parameters.getInt("max_height", 0);
        this.maxHeightAboveGround = parameters.getInt("max_height_above_ground", 0);
        this.boostTicks = parameters.getInt("boost_ticks", 1);
        this.crashDistance = parameters.getDouble("crash_distance", 0.0);
        this.slowReduceBoostTicks = parameters.getInt("slow_ticks", 4);
        this.moveDistance = parameters.getDouble("steer_speed", 0.0);
        this.sneakMoveDistance = parameters.getDouble("slow_steer_speed", -1.0);
        this.mountItem = parameters.contains("mount_item") ? ConfigurationUtils.getMaterial(parameters, "mount_item") : null;
        this.mountBaby = parameters.getBoolean("mount_baby", false);
        this.useHelmet = parameters.getBoolean("armor_stand_helmet", false);
        this.useArmorStand = parameters.getBoolean("armor_stand", false);
        this.armorStandMarker = parameters.getBoolean("armor_stand_marker", false);
        this.smallArmorStand = parameters.getBoolean("armor_stand_small", false);
        this.armorStandArm = ConfigurationUtils.getVector(parameters, "armor_stand_arm");
        this.armorStandHead = ConfigurationUtils.getVector(parameters, "armor_stand_head");
        this.armorStandBody = ConfigurationUtils.getVector(parameters, "armor_stand_body");
        this.pitchAmount = ConfigurationUtils.getDouble(parameters, "armor_stand_pitch", 0.0);
        this.yawAmount = ConfigurationUtils.getDouble(parameters, "armor_stand_yaw", 0.0);
        this.rollAmount = ConfigurationUtils.getDouble(parameters, "armor_stand_roll", 0.0);
        this.maxMountBoost = parameters.getDouble("mount_boost", 1.0);
        this.mountBoostPerJump = parameters.getDouble("mount_boost_per_jump", 0.5);
        this.mountBoostTicks = parameters.getInt("mount_boost_ticks", 40);
        this.mountHealth = parameters.getDouble("mount_health", 2.0);
        this.mountInvisible = parameters.getBoolean("mount_invisible", true);
        this.mountSilent = parameters.getBoolean("mount_silent", true);
        this.stashItem = parameters.getBoolean("stash_item", false);
        this.mountBoostTicks = (int)((float)this.mountBoostTicks + this.mage.getPower() * (float)parameters.getInt("power_mount_boost_ticks", 0));
        this.mountHealth += (double)this.mage.getPower() * parameters.getDouble("power_mount_health", 0.0);
        if (this.moveDistance != 0.0) {
            this.moveDistance += (double)this.mage.getPower() * parameters.getDouble("power_steer_speed", 0.0);
        }
        this.mountBoostPerJump += (double)this.mage.getPower() * parameters.getDouble("power_mount_boost_per_jump", 0.0);
        this.slowReduceBoostTicks = (int)((double)this.slowReduceBoostTicks + (double)this.mage.getPower() * parameters.getDouble("power_slow_ticks", 0.0));
        if (this.moveDistance < 0.0) {
            this.moveDistance = 0.0;
        }
        if (parameters.contains("effect_particle")) {
            this.parseParticleEffect(parameters.getString("effect_particle"));
            this.effectParticleData = 0.0f;
        } else {
            this.effectParticle = null;
        }
        if (parameters.contains("effect_sound")) {
            this.parseSoundEffect(parameters.getString("effect_sound"));
        } else {
            this.effectSound = null;
        }
        this.effectParticleData = (float)parameters.getDouble("effect_particle_data", (double)this.effectParticleData);
        this.effectParticleCount = parameters.getInt("effect_particle_count", this.effectParticleCount);
        this.effectParticleInterval = parameters.getInt("effect_particle_interval", this.effectParticleInterval);
        this.effectSoundInterval = parameters.getInt("effect_sound_interval", this.effectSoundInterval);
        this.effectSoundVolume = (float)parameters.getDouble("effect_sound_volume", (double)this.effectSoundVolume);
        this.effectSoundPitch = (float)parameters.getDouble("effect_sound_pitch", (double)this.effectSoundPitch);
        this.effectSoundCounter = 0;
        this.effectParticleCounter = 0;
        if (parameters.contains("mount_reason")) {
            String reasonText = parameters.getString("mount_reason").toUpperCase();
            try {
                this.mountSpawnReason = CreatureSpawnEvent.SpawnReason.valueOf((String)reasonText);
            }
            catch (Exception ex) {
                this.sendMessage("Unknown spawn reason: " + reasonText);
                return SpellResult.FAIL;
            }
        }
        if (parameters.contains("mount_type")) {
            try {
                String entityType = parameters.getString("mount_type");
                this.mountType = EntityType.valueOf((String)entityType.toUpperCase());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return SpellResult.FAIL;
            }
        } else {
            this.mountType = null;
        }
        if (parameters.contains("mount_variant")) {
            try {
                String variantString = parameters.getString("mount_variant");
                this.mountHorseVariant = Horse.Variant.valueOf((String)variantString.toUpperCase());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return SpellResult.FAIL;
            }
        } else {
            this.mountHorseVariant = Horse.Variant.HORSE;
        }
        if (parameters.contains("mount_color")) {
            try {
                String colorString = parameters.getString("mount_color");
                this.mountHorseColor = Horse.Color.valueOf((String)colorString.toUpperCase());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return SpellResult.FAIL;
            }
        } else {
            this.mountHorseColor = Horse.Color.WHITE;
        }
        if (parameters.contains("mount_style")) {
            try {
                String styleString = parameters.getString("mount_style");
                this.mountHorseStyle = Horse.Style.valueOf((String)styleString.toUpperCase());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return SpellResult.FAIL;
            }
        } else {
            this.mountHorseStyle = Horse.Style.NONE;
        }
        this.crashEffects = LevitateSpell.getPotionEffects(parameters);
        double speedBonus = parameters.getDouble("power_speed", 0.0);
        double boostBonus = parameters.getDouble("power_boost", 0.0);
        double maxSpeedBonus = parameters.getDouble("power_mount_boost", 0.0);
        this.thrustSpeed = (float)((double)this.thrustSpeed + (double)this.mage.getPower() * speedBonus);
        this.castBoost += (double)this.mage.getPower() * boostBonus;
        this.maxMountBoost += (double)this.mage.getPower() * maxSpeedBonus;
        if (this.isActive()) {
            if (this.castBoost != 0.0) {
                this.boostTicksRemaining += this.boostTicks;
                return SpellResult.ALTERNATE;
            }
            if (this.mountEntity != null && this.thrust != null) {
                return SpellResult.NO_ACTION;
            }
            this.land();
            return SpellResult.DEACTIVATE;
        }
        if (this.mountType != null) {
            Location testLocation = this.getEyeLocation();
            for (BlockFace facing : CHECK_FACES) {
                Block block = testLocation.getBlock().getRelative(facing);
                if (this.isOkToStandIn(block.getType())) continue;
                return SpellResult.FAIL;
            }
            Block block = testLocation.getBlock();
            for (int i = 0; i < checkHeight; ++i) {
                if (!this.isOkToStandIn(block.getType())) {
                    return SpellResult.FAIL;
                }
                block = block.getRelative(BlockFace.UP);
            }
        }
        if (this.stashItem) {
            PlayerInventory inventory = player.getInventory();
            this.heldItemSlot = inventory.getHeldItemSlot();
        }
        this.activate();
        return SpellResult.CAST;
    }

    protected void parseSoundEffect(String effectSoundName) {
        if (effectSoundName.length() > 0) {
            String soundName = effectSoundName.toUpperCase();
            try {
                this.effectSound = Sound.valueOf((String)soundName);
            }
            catch (Exception ex) {
                this.effectSound = null;
            }
        } else {
            this.effectSound = null;
        }
    }

    protected void parseParticleEffect(String effectParticleName) {
        if (effectParticleName.length() > 0) {
            String particleName = effectParticleName.toUpperCase();
            try {
                this.effectParticle = ParticleEffect.valueOf(particleName);
            }
            catch (Exception ex) {
                this.effectParticle = null;
            }
        } else {
            this.effectParticle = null;
        }
    }

    public void boost(double amount) {
        if (this.maxMountBoost > 0.0 && this.mountBoostTicks > 0) {
            if (this.mountBoostTicksRemaining == 0) {
                this.playEffects("boost");
            }
            this.mountBoostTicksRemaining = (int)Math.min((double)this.mountBoostTicksRemaining + this.mountBoostPerJump * (double)this.mountBoostTicks * amount, (double)this.mountBoostTicks);
            this.updateMountHealth();
        }
    }

    protected void updateMountHealth() {
        if (this.mountEntity != null && this.mountBoostTicks > 0 && this.mountEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)this.mountEntity;
            double maxHealth = living.getMaxHealth();
            double health = Math.min(0.5 + maxHealth * (double)this.mountBoostTicksRemaining / (double)this.mountBoostTicks, maxHealth);
            living.setHealth(health);
        }
    }

    public void land() {
        this.deactivate(true, false);
    }

    @Override
    public void onDeactivate() {
        Player player;
        this.mage.enableFallProtection(10000, this);
        if (this.thrust != null) {
            this.thrust.stop();
            this.thrust = null;
        }
        Entity mageEntity = this.mage.getEntity();
        if (this.mountEntity != null) {
            Plugin plugin = this.controller.getPlugin();
            if (mageEntity != null) {
                mageEntity.eject();
            }
            if (this.armorStand != null) {
                this.armorStand.removeMetadata("notarget", plugin);
                this.armorStand.removeMetadata("broom", plugin);
                this.armorStand.remove();
            }
            if (this.mountEntity instanceof Horse) {
                Horse horse = (Horse)this.mountEntity;
                horse.getInventory().clear();
            }
            if (this.mountEntity instanceof Pig) {
                Pig pig = (Pig)this.mountEntity;
                pig.setSaddle(false);
            }
            this.mountEntity.eject();
            this.mountEntity.setPassenger(null);
            this.mountEntity.removeMetadata("notarget", plugin);
            this.mountEntity.removeMetadata("broom", plugin);
            CompatibilityUtils.setInvulnerable(this.mountEntity, false);
            if (this.mountEntity instanceof LivingEntity) {
                ((LivingEntity)this.mountEntity).setHealth(0.0);
            }
            this.mountEntity.remove();
            this.mountEntity = null;
        }
        if ((player = this.mage.getPlayer()) == null) {
            return;
        }
        this.controller.removeFlightExemption(player);
        if (this.flySpeed > 0.0f && this.flight) {
            player.setFlySpeed(0.1f);
        }
        if (this.heldItem != null) {
            Inventory inventory = this.mage.getInventory();
            ItemStack current = inventory.getItem(this.heldItemSlot);
            inventory.setItem(this.heldItemSlot, this.heldItem);
            if (player.getInventory().getHeldItemSlot() == this.heldItemSlot && Wand.isWand(this.heldItem)) {
                Wand wand = new Wand((MagicController)this.controller, this.heldItem);
                wand.activate(this.mage);
            }
            if (current != null && current.getType() != Material.AIR) {
                this.controller.giveItemToPlayer(player, current);
            }
            this.heldItem = null;
        }
        if (this.flight) {
            player.setFlying(false);
            player.setAllowFlight(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onActivate() {
        final Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        this.direction = null;
        this.mountBoostTicksRemaining = 0;
        this.boostTicksRemaining = 0;
        this.controller.addFlightExemption(player);
        if (this.stashItem) {
            final PlayerInventory inventory = player.getInventory();
            this.heldItem = inventory.getItem(this.heldItemSlot);
            Plugin plugin = this.controller.getPlugin();
            plugin.getServer().getScheduler().scheduleSyncDelayedTask(plugin, new Runnable(){

                @Override
                public void run() {
                    com.elmakers.mine.bukkit.api.wand.Wand wand = LevitateSpell.this.mage.getActiveWand();
                    if (wand != null) {
                        wand.deactivate();
                    }
                    LevitateSpell.this.heldItem = inventory.getItem(LevitateSpell.this.heldItemSlot);
                    inventory.setItem(LevitateSpell.this.heldItemSlot, null);
                }
            }, 1L);
        } else {
            this.heldItem = null;
        }
        if (this.flySpeed > 0.0f) {
            player.setFlySpeed(this.flySpeed * 0.1f);
        }
        if (this.thrustSpeed > 0.0f) {
            if (this.thrust != null) {
                this.thrust.stop();
            }
            this.thrust = new ThrustAction(this, this.thrustFrequency + this.flyDelay + this.startDelay, this.thrustFrequency);
        } else if (this.deactivateFrequency > 0) {
            this.thrust = new ThrustAction(this, this.deactivateFrequency + this.flyDelay + this.startDelay, this.deactivateFrequency);
        }
        if (this.mountType != null) {
            Location location = this.mage.getLocation();
            World world = location.getWorld();
            Entity entity = null;
            try {
                Object nmsWorld;
                Constructor<?> constructor;
                Object nmsEntity;
                Class<?> mountClass;
                String mountName = this.mountType.getName();
                if (mountName.indexOf("Entity") != 0) {
                    mountName = "Entity" + mountName;
                }
                if ((mountClass = NMSUtils.getBukkitClass("net.minecraft.server." + mountName)) == null) {
                    this.mage.sendMessage("Invalid entity type: " + this.mountType + " (" + this.mountType.getName() + ")");
                    return;
                }
                if (worldClass == null) {
                    worldClass = NMSUtils.getBukkitClass("net.minecraft.server.World");
                }
                if ((entity = NMSUtils.getBukkitEntity(nmsEntity = (constructor = mountClass.getConstructor(worldClass)).newInstance(nmsWorld = NMSUtils.getHandle(world)))) == null) {
                    this.mage.sendMessage("Failed to spawn entity of type: " + this.mountType + " (" + this.mountType.getName() + ")");
                    return;
                }
                if (entity instanceof LivingEntity && this.mountInvisible) {
                    ((LivingEntity)entity).addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 0x2000000, 0));
                }
                if (entity instanceof Tameable) {
                    ((Tameable)entity).setTamed(true);
                }
                if (this.mountSilent) {
                    CompatibilityUtils.setSilent(entity, true);
                }
                Method setLocationMethod = mountClass.getMethod("setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
                setLocationMethod.invoke(nmsEntity, location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
                this.controller.setForceSpawn(true);
                try {
                    CompatibilityUtils.addToWorld(world, entity, this.mountSpawnReason);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.controller.setForceSpawn(false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (entity != null) {
                this.mountEntity = entity;
                CompatibilityUtils.setInvulnerable(this.mountEntity);
                if (entity instanceof Horse) {
                    Horse horse = (Horse)this.mountEntity;
                    horse.setTamed(true);
                    horse.setOwner((AnimalTamer)player);
                    horse.setAdult();
                    horse.setStyle(this.mountHorseStyle);
                    horse.setVariant(this.mountHorseVariant);
                    horse.setColor(this.mountHorseColor);
                    horse.getInventory().setSaddle(new ItemStack(Material.SADDLE, 1));
                    if (this.mountItem != null) {
                        horse.getInventory().setArmor(new ItemStack(this.mountItem, 1));
                    }
                    if (this.mountBaby) {
                        horse.setBaby();
                    }
                }
                if (entity instanceof Pig) {
                    Pig pig = (Pig)entity;
                    pig.setSaddle(true);
                    if (this.mountBaby) {
                        pig.setBaby();
                    }
                }
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)this.mountEntity;
                    living.setHealth(0.5);
                    living.setMaxHealth(this.mountHealth);
                }
                if (entity instanceof ArmorStand) {
                    ArmorStand armorStand = (ArmorStand)entity;
                    this.configureArmorStand(armorStand);
                } else if (this.useArmorStand) {
                    this.armorStand = CompatibilityUtils.spawnArmorStand(this.mage.getLocation());
                    this.configureArmorStand(this.armorStand);
                    this.armorStand.setPassenger(this.mountEntity);
                    this.armorStand.setMetadata("notarget", (MetadataValue)new FixedMetadataValue(this.controller.getPlugin(), (Object)true));
                    this.armorStand.setMetadata("broom", (MetadataValue)new FixedMetadataValue(this.controller.getPlugin(), (Object)true));
                    this.controller.setForceSpawn(true);
                    try {
                        CompatibilityUtils.addToWorld(this.mage.getLocation().getWorld(), (Entity)this.armorStand, this.mountSpawnReason);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    this.controller.setForceSpawn(false);
                } else {
                    this.armorStand = null;
                }
                this.mountEntity.setPassenger(this.mage.getEntity());
                this.mountEntity.setMetadata("notarget", (MetadataValue)new FixedMetadataValue(this.controller.getPlugin(), (Object)true));
                this.mountEntity.setMetadata("broom", (MetadataValue)new FixedMetadataValue(this.controller.getPlugin(), (Object)true));
                if (listener == null) {
                    listener = new LevitateListener(this.controller);
                    Plugin plugin = this.controller.getPlugin();
                    plugin.getServer().getPluginManager().registerEvents((Listener)listener, plugin);
                }
            }
        }
        this.grounded = false;
        if (this.maxHeight > 0 && player.getLocation().getY() >= (double)this.maxHeight) {
            this.grounded = true;
        } else if (this.maxHeightAboveGround > 0) {
            Block block = player.getLocation().getBlock();
            for (int height = 0; height < this.maxHeightAboveGround && block.getType() == Material.AIR; block = block.getRelative(BlockFace.DOWN), ++height) {
            }
            if (block.getType() == Material.AIR) {
                this.grounded = true;
            }
        }
        if (!this.grounded) {
            Vector velocity = player.getVelocity();
            velocity.setY(velocity.getY() + this.yBoost);
            if (this.mountEntity != null) {
                if (this.armorStand != null) {
                    this.armorStand.setVelocity(velocity);
                } else {
                    this.mountEntity.setVelocity(velocity);
                }
            } else {
                player.setVelocity(velocity);
            }
        }
        if (this.flight) {
            Bukkit.getScheduler().scheduleSyncDelayedTask(this.controller.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    player.setAllowFlight(true);
                    player.setFlying(true);
                }
            }, (long)this.flyDelay);
        }
    }

    protected void configureArmorStand(ArmorStand armorStand) {
        if (this.useHelmet) {
            armorStand.setHelmet(this.heldItem);
        } else {
            armorStand.setItemInHand(this.heldItem);
        }
        armorStand.setMetadata("notarget", (MetadataValue)new FixedMetadataValue(this.controller.getPlugin(), (Object)true));
        armorStand.setMetadata("broom", (MetadataValue)new FixedMetadataValue(this.controller.getPlugin(), (Object)true));
        if (this.mountInvisible) {
            CompatibilityUtils.setInvisible(armorStand, true);
        }
        if (this.armorStandMarker) {
            CompatibilityUtils.setMarker(armorStand, true);
        }
        CompatibilityUtils.setGravity(armorStand, false);
        CompatibilityUtils.setDisabledSlots(armorStand, 0x1F1F00);
        if (this.armorStandArm != null) {
            armorStand.setRightArmPose(new EulerAngle(this.armorStandArm.getX(), this.armorStandArm.getY(), this.armorStandArm.getZ()));
        }
        if (this.armorStandHead != null) {
            armorStand.setHeadPose(new EulerAngle(this.armorStandHead.getX(), this.armorStandHead.getY(), this.armorStandHead.getZ()));
        }
        if (this.armorStandBody != null) {
            armorStand.setBodyPose(new EulerAngle(this.armorStandBody.getX(), this.armorStandBody.getY(), this.armorStandBody.getZ()));
        }
        if (this.smallArmorStand) {
            CompatibilityUtils.setSmall(armorStand, true);
        }
        Location location = this.mage.getLocation();
        CompatibilityUtils.setYawPitch((Entity)armorStand, location.getYaw() + (float)this.yawAmount, location.getPitch());
    }

    public void forceSneak(int ticks) {
        this.forceSneak = ticks;
    }

    @Override
    public MaterialAndData getEffectMaterial() {
        Block block = this.mage.getEntity().getLocation().getBlock();
        block = block.getRelative(BlockFace.DOWN);
        return new com.elmakers.mine.bukkit.block.MaterialAndData(block);
    }

    public boolean isFlightEnabled() {
        return this.flight;
    }

    static {
        listener = null;
    }

    private class LevitateListener
    implements Listener {
        private final MageController controller;

        public LevitateListener(MageController controller) {
            this.controller = controller;
        }

        @EventHandler
        public void onHorseJump(HorseJumpEvent event) {
            Horse horse = event.getEntity();
            if (horse.hasMetadata("broom")) {
                Entity passenger = horse.getPassenger();
                Mage mage = this.controller.getMage(passenger);
                Set<Spell> active = mage.getActiveSpells();
                for (Spell spell : active) {
                    if (!(spell instanceof LevitateSpell)) continue;
                    LevitateSpell levitate = (LevitateSpell)spell;
                    levitate.boost(event.getPower());
                }
            }
        }

        @EventHandler
        public void onInventoryOpen(InventoryOpenEvent event) {
            HumanEntity player = event.getPlayer();
            Entity mount = player.getVehicle();
            if (mount != null && mount.hasMetadata("broom")) {
                event.setCancelled(true);
            }
        }

        @EventHandler
        public void onVehicleExit(VehicleExitEvent event) {
            Vehicle vehicle = event.getVehicle();
            if (vehicle.hasMetadata("broom")) {
                event.setCancelled(true);
                Entity passenger = vehicle.getPassenger();
                Mage mage = this.controller.getMage(passenger);
                Set<Spell> active = mage.getActiveSpells();
                for (Spell spell : active) {
                    if (!(spell instanceof LevitateSpell)) continue;
                    LevitateSpell levitate = (LevitateSpell)spell;
                    levitate.forceSneak(10);
                }
            }
        }
    }

    private class ThrustAction
    implements Runnable {
        private final LevitateSpell spell;
        private final int taskId;

        public ThrustAction(LevitateSpell spell, int delay, int interval) {
            Plugin plugin = spell.getMage().getController().getPlugin();
            this.spell = spell;
            BukkitScheduler scheduler = Bukkit.getScheduler();
            this.taskId = scheduler.scheduleSyncRepeatingTask(plugin, (Runnable)this, (long)delay, (long)interval);
        }

        public void stop() {
            Bukkit.getScheduler().cancelTask(this.taskId);
        }

        @Override
        public void run() {
            if (!this.spell.canCast(this.spell.getLocation())) {
                this.spell.land();
                return;
            }
            if (!this.spell.checkActive()) {
                return;
            }
            Entity entity = this.spell.getMage().getEntity();
            if (entity == null || entity.isDead()) {
                this.spell.land();
                return;
            }
            if (entity instanceof Player && (!((Player)entity).isOnline() || this.spell.isFlightEnabled() && !((Player)entity).isFlying())) {
                this.spell.land();
                return;
            }
            this.spell.thrust();
        }
    }
}

