/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.math;

import com.elmakers.mine.bukkit.slikey.effectlib.math.Transform;
import com.elmakers.mine.bukkit.slikey.effectlib.math.Transforms;
import com.elmakers.mine.bukkit.slikey.effectlib.util.VectorUtils;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.Vector;

public class VectorTransform {
    private Transform xTransform;
    private Transform yTransform;
    private Transform zTransform;
    private boolean orient;

    public VectorTransform(ConfigurationSection configuration) {
        this.xTransform = Transforms.loadTransform(configuration, "x");
        this.yTransform = Transforms.loadTransform(configuration, "y");
        this.zTransform = Transforms.loadTransform(configuration, "z");
        this.orient = configuration.getBoolean("orient", true);
    }

    public Vector get(Location source, double t) {
        Double xValue = this.xTransform.get(t);
        Double yValue = this.yTransform.get(t);
        Double zValue = this.zTransform.get(t);
        Vector result = new Vector(xValue.doubleValue(), yValue.doubleValue(), zValue.doubleValue());
        if (this.orient && source != null) {
            result = VectorUtils.rotateVector(result, source);
        }
        return result;
    }
}

