/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.effect;

import com.elmakers.mine.bukkit.slikey.effectlib.Effect;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectType;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationTransform;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.VectorUtils;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class EquationEffect
extends Effect {
    public ParticleEffect particle = ParticleEffect.REDSTONE;
    public String xEquation = "t";
    public String yEquation = "0";
    public String zEquation = "0";
    public String variable = "t";
    public int particles = 1;
    public String x2Equation = null;
    public String y2Equation = null;
    public String z2Equation = null;
    public String variable2 = "y";
    public int particles2 = 0;
    public boolean orient = true;
    public boolean cycle = false;
    private EquationTransform xTransform;
    private EquationTransform yTransform;
    private EquationTransform zTransform;
    private EquationTransform x2Transform;
    private EquationTransform y2Transform;
    private EquationTransform z2Transform;
    private int step;

    public EquationEffect(EffectManager effectManager) {
        super(effectManager);
        this.type = EffectType.REPEATING;
        this.period = 1;
        this.iterations = 100;
        this.step = 0;
    }

    @Override
    public void onRun() {
        if (this.xTransform == null) {
            this.xTransform = new EquationTransform(this.xEquation, this.variable);
            this.yTransform = new EquationTransform(this.yEquation, this.variable);
            this.zTransform = new EquationTransform(this.zEquation, this.variable);
            if (this.x2Equation != null && this.y2Equation != null && this.z2Equation != null && this.particles2 > 0) {
                this.x2Transform = new EquationTransform(this.x2Equation, this.variable, this.variable2);
                this.y2Transform = new EquationTransform(this.y2Equation, this.variable, this.variable2);
                this.z2Transform = new EquationTransform(this.z2Equation, this.variable, this.variable2);
            }
        }
        Location location = this.getLocation();
        for (int i = 0; i < this.particles; ++i) {
            Double xValue = this.xTransform.get((double)this.step);
            Double yValue = this.yTransform.get((double)this.step);
            Double zValue = this.zTransform.get((double)this.step);
            Vector result = new Vector(xValue.doubleValue(), yValue.doubleValue(), zValue.doubleValue());
            if (this.orient) {
                result = VectorUtils.rotateVector(result, location);
            }
            Location targetLocation = location.clone();
            targetLocation.add(result);
            this.display(this.particle, targetLocation);
            if (this.x2Transform != null && this.y2Transform != null && this.z2Transform != null) {
                for (int j = 0; j < this.particles2; ++j) {
                    Double x2Value = this.x2Transform.get(this.step, j);
                    Double y2Value = this.y2Transform.get(this.step, j);
                    Double z2Value = this.z2Transform.get(this.step, j);
                    Location target2Location = targetLocation.clone();
                    target2Location.setX(target2Location.getX() + x2Value);
                    target2Location.setY(target2Location.getY() + y2Value);
                    target2Location.setZ(target2Location.getZ() + z2Value);
                    this.display(this.particle, target2Location);
                }
            }
            ++this.step;
        }
        if (this.cycle) {
            this.step = 0;
        }
    }
}

