/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.event.MagicMobDeathEvent;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.entity.EntityData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class MobController
implements Listener {
    private MageController controller;
    private final Map<String, EntityData> mobs = new HashMap<String, EntityData>();
    private final Map<String, EntityData> mobsByName = new HashMap<String, EntityData>();

    public MobController(MageController controller) {
        this.controller = controller;
    }

    public void load(ConfigurationSection configuration) {
        Set mobKeys = configuration.getKeys(false);
        for (String mobKey : mobKeys) {
            ConfigurationSection mobConfiguration = configuration.getConfigurationSection(mobKey);
            if (!mobConfiguration.getBoolean("enabled", true)) {
                // empty if block
            }
            EntityData mob = new EntityData(this.controller, mobConfiguration);
            mob.setKey(mobKey);
            this.mobs.put(mobKey, mob);
            String mobName = mob.getName();
            if (mobName == null || mobName.isEmpty()) continue;
            this.mobsByName.put(mobName, mob);
        }
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.HIGHEST)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        EntityData customMob;
        LivingEntity entity = event.getEntity();
        String customName = entity.getCustomName();
        if (customName != null && (customMob = this.mobsByName.get(customName)) != null) {
            customMob.modify(this.controller, (Entity)entity);
            event.setCancelled(false);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onEntityTarget(EntityTargetEvent event) {
        if (event.isCancelled() || !event.getEntity().hasMetadata("docile")) {
            return;
        }
        if (event.getReason() == EntityTargetEvent.TargetReason.CLOSEST_PLAYER) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity died = entity;
        String name = died.getCustomName();
        if (name == null || name.isEmpty()) {
            return;
        }
        EntityData mob = this.mobsByName.get(name);
        if (mob == null) {
            return;
        }
        MagicMobDeathEvent deathEvent = new MagicMobDeathEvent(this.controller, mob, event);
        Bukkit.getPluginManager().callEvent((Event)deathEvent);
        if (!died.hasMetadata("nodrops")) {
            mob.modifyDrops(this.controller, event);
        }
        died.setCustomNameVisible(false);
        died.setCustomName(null);
    }

    public int getCount() {
        return this.mobs.size();
    }

    public Set<String> getKeys() {
        return this.mobs.keySet();
    }

    public EntityData get(String key) {
        return this.mobs.get(key);
    }

    public EntityData getByName(String name) {
        return this.mobsByName.get(name);
    }
}

