/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.item.ItemData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class ItemController
implements Listener {
    private MageController controller;
    private final Map<String, ItemData> items = new HashMap<String, ItemData>();
    private final Map<ItemStack, ItemData> itemsByStack = new HashMap<ItemStack, ItemData>();

    public ItemController(MageController controller) {
        this.controller = controller;
    }

    public void load(ConfigurationSection configuration) {
        Set itemKeys = configuration.getKeys(false);
        for (String itemKey : itemKeys) {
            ConfigurationSection itemConfig = configuration.getConfigurationSection(itemKey);
            if (itemConfig != null) {
                this.loadItem(itemKey, itemConfig);
                continue;
            }
            this.controller.getLogger().warning("Improperly formatted item: " + itemKey);
        }
    }

    public void loadItem(String itemKey, ConfigurationSection configuration) {
        try {
            ItemData magicItem = new ItemData(itemKey, configuration);
            this.items.put(itemKey, magicItem);
            this.itemsByStack.put(magicItem.getItemStack(1), magicItem);
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.WARNING, "An error occurred while processing the item: " + itemKey, ex);
        }
    }

    public int getCount() {
        return this.items.size();
    }

    public Set<String> getKeys() {
        return this.items.keySet();
    }

    public ItemData get(String key) {
        return this.items.get(key);
    }

    public ItemData getOrCreate(String key) {
        ItemData data = this.get(key);
        if (data == null) {
            try {
                data = new ItemData(key);
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.WARNING, "Error creating item: " + key, ex);
            }
        }
        return data;
    }

    public ItemData get(ItemStack item) {
        return this.itemsByStack.get(item);
    }

    public void remove(String key) {
        ItemData existing = this.items.get(key);
        if (existing != null) {
            this.itemsByStack.remove(existing.getItemStack(1));
        }
        this.items.remove(key);
    }
}

