/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.entity.EntityArmorStandData;
import com.elmakers.mine.bukkit.entity.EntityExtraData;
import com.elmakers.mine.bukkit.entity.EntityHorseData;
import com.elmakers.mine.bukkit.item.ItemData;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Rotation;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Colorable;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class EntityData
implements com.elmakers.mine.bukkit.api.entity.EntityData,
Cloneable {
    protected static Map<UUID, WeakReference<Entity>> respawned = new HashMap<UUID, WeakReference<Entity>>();
    protected String key;
    protected WeakReference<Entity> entity;
    protected UUID uuid;
    protected EntityType type;
    protected EntityExtraData extraData;
    protected Location location;
    protected Vector relativeLocation;
    protected boolean hasMoved;
    protected boolean isTemporary;
    private boolean respawn;
    protected String name;
    protected Art art;
    protected BlockFace facing;
    protected Rotation rotation;
    protected ItemStack item;
    protected Double maxHealth;
    protected Double health;
    protected Integer airLevel;
    protected boolean isBaby;
    protected boolean isVillager;
    protected int fireTicks;
    protected DyeColor dyeColor;
    protected Skeleton.SkeletonType skeletonType;
    protected Ocelot.Type ocelotType;
    protected Villager.Profession villagerProfession;
    protected Rabbit.Type rabbitType;
    protected Collection<PotionEffect> potionEffects;
    protected Vector velocity;
    protected boolean hasPotionEffects;
    protected boolean hasVelocity;
    protected boolean isHanging;
    protected boolean isLiving;
    protected boolean isProjectile;
    protected com.elmakers.mine.bukkit.api.item.ItemData itemInHand;
    protected com.elmakers.mine.bukkit.api.item.ItemData helmet;
    protected com.elmakers.mine.bukkit.api.item.ItemData chestplate;
    protected com.elmakers.mine.bukkit.api.item.ItemData leggings;
    protected com.elmakers.mine.bukkit.api.item.ItemData boots;
    protected Integer xp;
    protected Integer dropXp;
    protected boolean defaultDrops;
    protected List<String> drops;
    protected long tickInterval;
    protected LinkedList<WeightedPair<String>> spells;
    protected boolean requiresTarget;

    public EntityData(Entity entity) {
        this(entity.getLocation(), entity);
    }

    public EntityData(Location location, Entity entity) {
        this.entity = null;
        this.uuid = null;
        this.hasMoved = false;
        this.isTemporary = false;
        this.respawn = false;
        this.name = null;
        this.rabbitType = null;
        this.potionEffects = null;
        this.velocity = null;
        this.hasPotionEffects = false;
        this.hasVelocity = false;
        this.isHanging = false;
        this.isLiving = false;
        this.isProjectile = false;
        this.setEntity(entity);
        this.isTemporary = entity.hasMetadata("temporary");
        this.isLiving = entity instanceof LivingEntity;
        this.isHanging = entity instanceof Hanging;
        this.isProjectile = entity instanceof Projectile;
        this.type = entity.getType();
        this.location = location;
        this.fireTicks = entity.getFireTicks();
        this.name = entity.getCustomName();
        try {
            this.velocity = entity.getVelocity();
        }
        catch (Exception ex) {
            this.velocity = null;
        }
        if (entity instanceof Hanging) {
            Hanging hanging = (Hanging)entity;
            try {
                this.facing = hanging.getFacing();
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.WARNING, "Error reading HangingEntity " + entity + " of type " + (entity == null ? "null" : entity.getType()), ex);
            }
        }
        if (entity instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)entity;
            this.health = li.getHealth();
            this.potionEffects = li.getActivePotionEffects();
            this.airLevel = li.getRemainingAir();
            this.maxHealth = li.getMaxHealth();
            this.itemInHand = this.getItem(li.getEquipment().getItemInHand());
            this.helmet = this.getItem(li.getEquipment().getHelmet());
            this.chestplate = this.getItem(li.getEquipment().getChestplate());
            this.leggings = this.getItem(li.getEquipment().getLeggings());
            this.boots = this.getItem(li.getEquipment().getBoots());
        }
        if (entity instanceof Ageable) {
            Ageable ageable = (Ageable)entity;
            boolean bl = this.isBaby = !ageable.isAdult();
        }
        if (entity instanceof Colorable) {
            Colorable colorable = (Colorable)entity;
            this.dyeColor = colorable.getColor();
        }
        if (entity instanceof Painting) {
            Painting painting = (Painting)entity;
            this.art = painting.getArt();
        } else if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            this.item = itemFrame.getItem();
            this.rotation = ((ItemFrame)entity).getRotation();
        } else if (entity instanceof Item) {
            Item droppedItem = (Item)entity;
            this.item = droppedItem.getItemStack();
        } else if (entity instanceof Horse) {
            this.extraData = new EntityHorseData((Horse)entity);
        } else if (entity instanceof Skeleton) {
            Skeleton skeleton = (Skeleton)entity;
            this.skeletonType = skeleton.getSkeletonType();
        } else if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            this.villagerProfession = villager.getProfession();
        } else if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            this.dyeColor = wolf.getCollarColor();
        } else if (entity instanceof Ocelot) {
            Ocelot ocelot = (Ocelot)entity;
            this.ocelotType = ocelot.getCatType();
        } else if (entity instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)entity;
            this.rabbitType = rabbit.getRabbitType();
        } else if (entity instanceof ArmorStand) {
            this.extraData = new EntityArmorStandData((ArmorStand)entity);
        } else if (entity instanceof ExperienceOrb) {
            this.xp = ((ExperienceOrb)entity).getExperience();
        } else if (entity instanceof Zombie) {
            this.isVillager = ((Zombie)entity).isVillager();
        }
    }

    private com.elmakers.mine.bukkit.api.item.ItemData getItem(ItemStack item) {
        return item == null ? null : new ItemData(item);
    }

    public EntityData(EntityType type) {
        this.entity = null;
        this.uuid = null;
        this.hasMoved = false;
        this.isTemporary = false;
        this.respawn = false;
        this.name = null;
        this.rabbitType = null;
        this.potionEffects = null;
        this.velocity = null;
        this.hasPotionEffects = false;
        this.hasVelocity = false;
        this.isHanging = false;
        this.isLiving = false;
        this.isProjectile = false;
        this.type = type;
    }

    public EntityData(MageController controller, ConfigurationSection parameters) {
        block34: {
            String entityName;
            this.entity = null;
            this.uuid = null;
            this.hasMoved = false;
            this.isTemporary = false;
            this.respawn = false;
            this.name = null;
            this.rabbitType = null;
            this.potionEffects = null;
            this.velocity = null;
            this.hasPotionEffects = false;
            this.hasVelocity = false;
            this.isHanging = false;
            this.isLiving = false;
            this.isProjectile = false;
            this.name = parameters.getString("name");
            if (this.name != null) {
                this.name = ChatColor.translateAlternateColorCodes((char)'&', (String)this.name);
            }
            if (parameters.contains("health")) {
                this.maxHealth = this.health = Double.valueOf(parameters.getDouble("health", 1.0));
            }
            if (parameters.contains("max_health")) {
                this.maxHealth = parameters.getDouble("max_health", 1.0);
            }
            if ((entityName = parameters.getString("type")) != null) {
                this.type = EntityData.parseEntityType(entityName);
                if (this.type == null) {
                    controller.getLogger().log(Level.WARNING, " Invalid entity type: " + entityName);
                }
            }
            this.tickInterval = parameters.getLong("cast_interval", 0L);
            if (parameters.contains("cast")) {
                this.spells = new LinkedList();
                RandomUtils.populateStringProbabilityMap(this.spells, parameters.getConfigurationSection("cast"));
            }
            this.requiresTarget = parameters.getBoolean("cast_requires_target", true);
            Collection<ConfigurationSection> potionEffectList = ConfigurationUtils.getNodeList(parameters, "potion_effects");
            if (potionEffectList != null) {
                this.potionEffects = new ArrayList<PotionEffect>();
                for (ConfigurationSection potionEffectSection : potionEffectList) {
                    try {
                        PotionEffectType effectType = PotionEffectType.getByName((String)potionEffectSection.getString("type").toUpperCase());
                        int ticks = (int)(potionEffectSection.getLong("duration", 3600000L) / 50L);
                        ticks = potionEffectSection.getInt("ticks", ticks);
                        int amplifier = potionEffectSection.getInt("amplifier", 0);
                        boolean ambient = potionEffectSection.getBoolean("ambient", true);
                        boolean particles = potionEffectSection.getBoolean("particles", true);
                        this.potionEffects.add(new PotionEffect(effectType, ticks, amplifier, ambient, particles));
                    }
                    catch (Exception ex) {
                        controller.getLogger().log(Level.WARNING, "Invalid potion effect type: " + potionEffectSection.getString("type", "(null)"), ex);
                    }
                }
                this.hasPotionEffects = !this.potionEffects.isEmpty();
            }
            this.defaultDrops = parameters.getBoolean("default_drops", true);
            if (parameters.contains("xp")) {
                this.xp = parameters.getInt("xp");
            }
            if (parameters.contains("drop_xp")) {
                this.dropXp = parameters.getInt("drop_xp");
            }
            this.drops = ConfigurationUtils.getStringList(parameters, "drops");
            try {
                if (this.type == EntityType.HORSE) {
                    EntityHorseData horseData = new EntityHorseData();
                    if (parameters.contains("horse_variant")) {
                        try {
                            String variantString = parameters.getString("horse_variant");
                            horseData.variant = Horse.Variant.valueOf((String)variantString.toUpperCase());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (parameters.contains("horse_color")) {
                        try {
                            String colorString = parameters.getString("horse_color");
                            horseData.color = Horse.Color.valueOf((String)colorString.toUpperCase());
                        }
                        catch (Exception ex) {
                            controller.getLogger().log(Level.WARNING, "Invalid horse_color: " + parameters.getString("horse_color"), ex);
                        }
                    }
                    if (parameters.contains("horse_style")) {
                        try {
                            String styleString = parameters.getString("horse_style");
                            horseData.style = Horse.Style.valueOf((String)styleString.toUpperCase());
                        }
                        catch (Exception ex) {
                            controller.getLogger().log(Level.WARNING, "Invalid horse_style: " + parameters.getString("horse_style"), ex);
                        }
                    }
                    if (parameters.contains("horse_jump_strength")) {
                        horseData.jumpStrength = parameters.getDouble("horse_jump_strength");
                    }
                    this.extraData = horseData;
                    break block34;
                }
                if (this.type == EntityType.SKELETON && parameters.contains("skeleton_type")) {
                    this.skeletonType = Skeleton.SkeletonType.valueOf((String)parameters.getString("skeleton_type").toUpperCase());
                } else if (this.type == EntityType.OCELOT && parameters.contains("ocelot_type")) {
                    this.ocelotType = Ocelot.Type.valueOf((String)parameters.getString("ocelot_type").toUpperCase());
                } else if (this.type == EntityType.RABBIT && parameters.contains("rabbit_type")) {
                    this.rabbitType = Rabbit.Type.valueOf((String)parameters.getString("rabbit_type").toUpperCase());
                } else if (this.type == EntityType.VILLAGER && parameters.contains("villager_profession")) {
                    this.villagerProfession = Villager.Profession.valueOf((String)parameters.getString("villager_profession").toUpperCase());
                } else if (this.type == EntityType.ZOMBIE && parameters.contains("zombie_type")) {
                    this.isVillager = parameters.getString("zombie_type").equalsIgnoreCase("villager");
                }
            }
            catch (Exception ex) {
                controller.getLogger().log(Level.WARNING, "Invalid entity type or sub-type", ex);
            }
        }
        MaterialAndData itemData = ConfigurationUtils.getMaterialAndData(parameters, "item");
        this.item = itemData == null ? null : itemData.getItemStack(parameters.getInt("amount", 1));
        this.itemInHand = controller.getOrCreateItem(parameters.getString("item"));
        this.helmet = controller.getOrCreateItem(parameters.getString("helmet"));
        this.chestplate = controller.getOrCreateItem(parameters.getString("chestplate"));
        this.leggings = controller.getOrCreateItem(parameters.getString("leggings"));
        this.boots = controller.getOrCreateItem(parameters.getString("boots"));
    }

    public static EntityData loadPainting(Vector location, Art art, BlockFace direction) {
        EntityData data = new EntityData(EntityType.PAINTING);
        data.facing = direction;
        data.relativeLocation = location.clone();
        data.art = art;
        return data;
    }

    public static EntityData loadItemFrame(Vector location, ItemStack item, BlockFace direction, Rotation rotation) {
        EntityData data = new EntityData(EntityType.ITEM_FRAME);
        data.facing = direction;
        data.relativeLocation = location.clone();
        data.rotation = rotation;
        data.item = item;
        return data;
    }

    public void setEntity(Entity entity) {
        this.entity = entity == null ? null : new WeakReference<Entity>(entity);
        this.uuid = entity == null ? null : entity.getUniqueId();
    }

    public static EntityType parseEntityType(String typeString) {
        if (typeString == null) {
            return null;
        }
        EntityType returnType = null;
        try {
            returnType = EntityType.valueOf((String)typeString.toUpperCase());
        }
        catch (Exception ex) {
            returnType = null;
        }
        if (returnType == null) {
            returnType = EntityType.fromName((String)typeString);
        }
        return returnType;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public EntityType getType() {
        return this.type;
    }

    @Override
    public Art getArt() {
        return this.art;
    }

    @Override
    public BlockFace getFacing() {
        return this.facing;
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public double getHealth() {
        return this.health;
    }

    protected Entity trySpawn(CreatureSpawnEvent.SpawnReason reason) {
        Entity spawned = null;
        if (this.type != null && this.type != EntityType.PLAYER) {
            try {
                if (reason != null) {
                    spawned = CompatibilityUtils.spawnEntity(this.location, this.type, reason);
                } else {
                    switch (this.type) {
                        case PAINTING: {
                            spawned = CompatibilityUtils.spawnPainting(this.location, this.facing, this.art);
                            break;
                        }
                        case ITEM_FRAME: {
                            spawned = CompatibilityUtils.spawnItemFrame(this.location, this.facing, this.rotation, this.item);
                            break;
                        }
                        case DROPPED_ITEM: {
                            spawned = this.location.getWorld().dropItem(this.location, this.item);
                            break;
                        }
                        default: {
                            spawned = this.location.getWorld().spawnEntity(this.location, this.type);
                        }
                    }
                }
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.WARNING, "Error restoring entity type " + this.getType() + " at " + this.getLocation(), ex);
            }
        }
        return spawned;
    }

    @Override
    public EntityData getRelativeTo(Location center) {
        EntityData copy = this.clone();
        if (copy != null) {
            if (this.relativeLocation != null) {
                copy.location = center.clone().add(this.relativeLocation);
            } else if (this.location != null) {
                copy.location = this.location.clone();
            }
        }
        return copy;
    }

    @Override
    public Entity spawn() {
        return this.spawn(null, null);
    }

    @Override
    public Entity spawn(Location location) {
        return this.spawn(null, location, null);
    }

    @Override
    public Entity spawn(MageController controller, Location location) {
        return this.spawn(controller, location, null);
    }

    public Entity spawn(MageController controller, Location location, CreatureSpawnEvent.SpawnReason reason) {
        if (location != null) {
            this.location = location;
        } else if (this.location == null) {
            return null;
        }
        Entity spawned = this.trySpawn(reason);
        if (spawned != null) {
            this.modify(controller, spawned);
        }
        return spawned;
    }

    @Override
    public Entity undo() {
        Entity entity = this.getEntity();
        if (!(!this.respawn || this.isTemporary || this.uuid == null || entity != null && entity.isValid() && !entity.isDead() || entity instanceof Player)) {
            WeakReference<Entity> respawnedEntity = respawned.get(this.uuid);
            if (respawnedEntity != null) {
                entity = (Entity)respawnedEntity.get();
            } else {
                entity = this.trySpawn(null);
                if (entity != null) {
                    respawned.put(this.uuid, new WeakReference<Entity>(entity));
                }
                entity.setMetadata("nodrops", (MetadataValue)new FixedMetadataValue(MagicPlugin.getAPI().getPlugin(), (Object)true));
            }
            this.setEntity(entity);
        }
        this.modify(entity);
        return entity;
    }

    @Override
    public boolean modify(Entity entity) {
        return this.modify(null, entity);
    }

    @Override
    public boolean modify(MageController controller, Entity entity) {
        com.elmakers.mine.bukkit.api.magic.Mage apiMage;
        if (entity == null || entity.getType() != this.type) {
            return false;
        }
        boolean isPlayer = entity instanceof Player;
        if (this.extraData != null) {
            this.extraData.apply(entity);
        }
        entity.setFireTicks(this.fireTicks);
        if (entity instanceof Ageable) {
            Ageable ageable = (Ageable)entity;
            if (this.isBaby) {
                ageable.setBaby();
            } else {
                ageable.setAdult();
            }
        }
        if (entity instanceof Colorable && this.dyeColor != null) {
            Colorable colorable = (Colorable)entity;
            colorable.setColor(this.dyeColor);
        }
        if (entity instanceof Painting) {
            Painting painting = (Painting)entity;
            if (this.art != null) {
                painting.setArt(this.art, true);
            }
            if (this.facing != null) {
                painting.setFacingDirection(this.facing, true);
            }
        } else if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            itemFrame.setItem(this.item);
            if (this.facing != null) {
                itemFrame.setFacingDirection(this.facing, true);
            }
        } else if (entity instanceof Item) {
            Item droppedItem = (Item)entity;
            droppedItem.setItemStack(this.item);
        } else if (entity instanceof Skeleton && this.skeletonType != null) {
            Skeleton skeleton = (Skeleton)entity;
            skeleton.setSkeletonType(this.skeletonType);
        } else if (entity instanceof Villager && this.villagerProfession != null) {
            Villager villager = (Villager)entity;
            villager.setProfession(this.villagerProfession);
        } else if (entity instanceof Wolf && this.dyeColor != null) {
            Wolf wolf = (Wolf)entity;
            wolf.setCollarColor(this.dyeColor);
        } else if (entity instanceof Ocelot && this.ocelotType != null) {
            Ocelot ocelot = (Ocelot)entity;
            ocelot.setCatType(this.ocelotType);
        } else if (entity instanceof Rabbit && this.rabbitType != null) {
            Rabbit rabbit = (Rabbit)entity;
            rabbit.setRabbitType(this.rabbitType);
        } else if (entity instanceof ExperienceOrb && this.xp != null) {
            ((ExperienceOrb)entity).setExperience(this.xp.intValue());
        }
        if (entity instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)entity;
            if (this.hasPotionEffects) {
                Collection currentEffects = li.getActivePotionEffects();
                for (PotionEffect effect : currentEffects) {
                    li.removePotionEffect(effect.getType());
                }
                if (this.potionEffects != null) {
                    for (PotionEffect effect : this.potionEffects) {
                        li.addPotionEffect(effect);
                    }
                }
            }
            try {
                if (!isPlayer) {
                    this.copyEquipmentTo(li);
                    if (this.maxHealth != null) {
                        li.setMaxHealth(this.maxHealth.doubleValue());
                    }
                }
                if (this.health != null) {
                    li.setHealth(Math.min(this.health, li.getMaxHealth()));
                }
                if (this.airLevel != null) {
                    li.setRemainingAir(Math.min(this.airLevel, li.getRemainingAir()));
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        if (!isPlayer && this.name != null && this.name.length() > 0) {
            entity.setCustomName(this.name);
        }
        if (this.hasMoved && this.location != null) {
            entity.teleport(this.location);
        }
        if (this.hasVelocity && this.velocity != null) {
            entity.setVelocity(this.velocity);
        }
        if (controller != null && this.spells != null && this.tickInterval >= 0L && (apiMage = controller.getMage(entity)) instanceof Mage) {
            ((Mage)apiMage).setEntityData(this);
        }
        return true;
    }

    public void copyEquipmentTo(LivingEntity entity) {
        if (this.itemInHand != null) {
            entity.getEquipment().setItemInHand(this.itemInHand.getItemStack(1));
        }
        if (this.helmet != null) {
            entity.getEquipment().setHelmet(this.helmet.getItemStack(1));
        }
        if (this.chestplate != null) {
            entity.getEquipment().setChestplate(this.chestplate.getItemStack(1));
        }
        if (this.leggings != null) {
            entity.getEquipment().setLeggings(this.leggings.getItemStack(1));
        }
        if (this.boots != null) {
            entity.getEquipment().setBoots(this.boots.getItemStack(1));
        }
    }

    @Override
    public void setHasMoved(boolean moved) {
        this.hasMoved = moved;
    }

    public void setHasPotionEffects(boolean changed) {
        this.hasPotionEffects = changed;
    }

    public void setHasVelocity(boolean hasVelocity) {
        this.hasVelocity = hasVelocity;
    }

    public boolean isHanging() {
        return this.isHanging;
    }

    public boolean isLiving() {
        return this.isLiving;
    }

    public boolean isProjectile() {
        return this.isProjectile;
    }

    public Entity getEntity() {
        return this.entity == null ? null : (Entity)this.entity.get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public EntityData clone() {
        try {
            return (EntityData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void removed(Entity entity) {
        if (this.extraData != null) {
            this.extraData.removed(entity);
        }
    }

    public boolean isRespawn() {
        return this.respawn;
    }

    public void setRespawn(boolean respawn) {
        this.respawn = respawn;
    }

    public void modifyDrops(MageController controller, EntityDeathEvent event) {
        if (this.dropXp != null) {
            event.setDroppedExp(this.dropXp.intValue());
        }
        List dropList = event.getDrops();
        if (!this.defaultDrops) {
            dropList.clear();
        }
        if (this.drops != null) {
            for (String key : this.drops) {
                ItemStack item = controller.createItem(key);
                if (item == null) continue;
                dropList.add(item);
            }
        }
    }

    @Override
    public String describe() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.name;
        }
        if (this.type == null) {
            return "Unknown";
        }
        String name = this.type.name();
        if (this.skeletonType != null) {
            name = name + ":" + this.skeletonType;
        } else if (this.villagerProfession != null) {
            name = name + ":" + this.villagerProfession;
        } else if (this.ocelotType != null) {
            name = name + ":" + this.ocelotType;
        } else if (this.rabbitType != null) {
            name = name + ":" + this.rabbitType;
        }
        return name;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public long getTickInterval() {
        return this.tickInterval;
    }

    public void tick(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        Creature creature;
        if (this.spells == null) {
            return;
        }
        LivingEntity entity = mage.getLivingEntity();
        Creature creature2 = creature = entity instanceof Creature ? (Creature)entity : null;
        if (this.requiresTarget && (creature == null || creature.getTarget() == null)) {
            return;
        }
        String castSpell = (String)RandomUtils.weightedRandom(this.spells);
        if (castSpell.length() > 0) {
            String[] parameters = null;
            Spell spell = null;
            if (!castSpell.equalsIgnoreCase("none")) {
                if (castSpell.contains(" ")) {
                    parameters = StringUtils.split((String)castSpell, (char)' ');
                    castSpell = parameters[0];
                    parameters = Arrays.copyOfRange(parameters, 1, parameters.length);
                }
                spell = mage.getSpell(castSpell);
            }
            if (spell != null) {
                spell.cast(parameters);
            }
        }
    }
}

