/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;

public class AutomatonLevel {
    private final LinkedList<WeightedPair<String>> tickSpells;
    private final LinkedList<WeightedPair<String>> deathSpells;
    private final Integer delay;
    private final Integer moveRange;
    private final Integer dropXp;
    private final Integer birthRange;
    private final Integer liveRange;
    private final Integer radius;
    private final Integer yRadius;

    public AutomatonLevel(int level, Integer[] levels, ConfigurationSection template) {
        int levelIndex = 0;
        int nextLevelIndex = 0;
        float distance = 0.0f;
        if (levels != null) {
            for (levelIndex = 0; levelIndex < levels.length; ++levelIndex) {
                if (level == levels[levelIndex] || levelIndex == levels.length - 1) {
                    nextLevelIndex = levelIndex;
                    distance = 0.0f;
                    break;
                }
                if (level <= levels[levelIndex]) continue;
                nextLevelIndex = levelIndex + 1;
                int previousLevel = levels[levelIndex];
                int nextLevel = levels[nextLevelIndex];
                distance = (float)(level - previousLevel) / (float)(nextLevel - previousLevel);
            }
        }
        if (template.contains("cast")) {
            this.tickSpells = new LinkedList();
            RandomUtils.populateStringProbabilityMap(this.tickSpells, template.getConfigurationSection("cast"), levelIndex, nextLevelIndex, distance);
        } else {
            this.tickSpells = null;
        }
        if (template.contains("death_cast")) {
            this.deathSpells = new LinkedList();
            RandomUtils.populateStringProbabilityMap(this.deathSpells, template.getConfigurationSection("death_cast"), levelIndex, nextLevelIndex, distance);
        } else {
            this.deathSpells = null;
        }
        this.delay = template.contains("delay") ? Integer.valueOf((int)RandomUtils.lerp(template.getString("delay").split(","), levelIndex, nextLevelIndex, distance)) : null;
        this.moveRange = template.contains("move") ? Integer.valueOf((int)RandomUtils.lerp(template.getString("move").split(","), levelIndex, nextLevelIndex, distance)) : null;
        this.dropXp = template.contains("drop_xp") ? Integer.valueOf((int)RandomUtils.lerp(template.getString("drop_xp").split(","), levelIndex, nextLevelIndex, distance)) : null;
        this.birthRange = template.contains("birth_range") ? Integer.valueOf((int)RandomUtils.lerp(template.getString("birth_range").split(","), levelIndex, nextLevelIndex, distance)) : null;
        this.liveRange = template.contains("live_range") ? Integer.valueOf((int)RandomUtils.lerp(template.getString("live_range").split(","), levelIndex, nextLevelIndex, distance)) : null;
        this.radius = template.contains("radius") ? Integer.valueOf((int)RandomUtils.lerp(template.getString("radius").split(","), levelIndex, nextLevelIndex, distance)) : null;
        this.yRadius = template.contains("yradius") ? Integer.valueOf((int)RandomUtils.lerp(template.getString("yradius").split(","), levelIndex, nextLevelIndex, distance)) : null;
    }

    public int getYRadius(int yRadius) {
        return this.yRadius != null ? this.yRadius : yRadius;
    }

    public int getRadius(int radius) {
        return this.radius != null ? this.radius : radius;
    }

    public int getLiveRangeSquared(int liveRangeSquared) {
        return this.liveRange != null ? this.liveRange * this.liveRange : liveRangeSquared;
    }

    public int getBirthRangeSquared(int birthRangeSquared) {
        return this.birthRange != null ? this.birthRange * this.birthRange : birthRangeSquared;
    }

    public int getDelay(int delay) {
        return this.delay != null ? this.delay : delay;
    }

    public int getMoveRangeSquared(int moveRangeSquared) {
        return this.moveRange != null ? this.moveRange * this.moveRange : moveRangeSquared;
    }

    public int getDropXp(int dropXp) {
        return this.dropXp != null ? this.dropXp : dropXp;
    }

    public void onDeath(Mage mage, MaterialAndData birthMaterial) {
        String deathSpell;
        if (this.deathSpells != null && this.deathSpells.size() > 0 && (deathSpell = (String)RandomUtils.weightedRandom(this.deathSpells)) != null && deathSpell.length() > 0) {
            this.castSpell(deathSpell, mage, birthMaterial);
        }
    }

    public void onTick(Mage mage, MaterialAndData birthMaterial) {
        String tickSpell;
        if (this.tickSpells != null && this.tickSpells.size() > 0 && (tickSpell = (String)RandomUtils.weightedRandom(this.tickSpells)).length() > 0) {
            this.castSpell(tickSpell, mage, birthMaterial);
        }
    }

    protected void castSpell(String spellCommand, Mage mage, MaterialAndData birthMaterial) {
        MageSpell spell;
        if (spellCommand == null || spellCommand.length() == 0 || spellCommand.equals("none")) {
            return;
        }
        String[] pieces = null;
        if (spellCommand.contains(" ")) {
            pieces = StringUtils.split((String)spellCommand, (char)' ');
            spellCommand = pieces[0];
        }
        String[] parameters = null;
        if (pieces != null && pieces.length > 1) {
            parameters = new String[pieces.length - 1];
            for (int i = 1; i < pieces.length; ++i) {
                parameters[i - 1] = pieces[i].replace("$birth", birthMaterial.getMaterial().name().toLowerCase());
            }
        }
        if ((spell = mage.getSpell(spellCommand)) != null) {
            spell.cast(parameters);
        }
    }
}

