/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import com.elmakers.mine.bukkit.protection.NCPAPI;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class NCPManager {
    private boolean enabled = true;
    private NCPAPI ncp;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled && this.ncp != null;
    }

    public void initialize(Plugin plugin) {
        this.ncp = null;
        if (this.enabled) {
            Plugin ncpPlugin = plugin.getServer().getPluginManager().getPlugin("NoCheatPlus");
            if (ncpPlugin != null) {
                this.ncp = new NCPAPI(plugin, ncpPlugin);
                plugin.getLogger().info("NoCheatPlus found, adding exemption handlers.");
            } else {
                plugin.getLogger().info("NoCheatPlus not found, will not integrate.");
            }
        } else {
            plugin.getLogger().info("NoCheatPlus integration disabled, enable this in config.yml if you find Magic triggering NCP violations");
        }
    }

    public void addFlightExemption(Player player, int duration) {
        if (this.ncp != null) {
            this.ncp.addFlightExemption(player, duration);
        }
    }
}

