/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class WearAction
extends BaseSpellAction {
    private MaterialAndData material;
    private boolean useItem;
    private Map<Enchantment, Integer> enchantments;
    private int slotNumber;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        if (parameters.contains("enchantments")) {
            this.enchantments = new HashMap<Enchantment, Integer>();
            ConfigurationSection enchantConfig = ConfigurationUtils.getConfigurationSection(parameters, "enchantments");
            Set enchantKeys = enchantConfig.getKeys(false);
            for (String enchantKey : enchantKeys) {
                try {
                    Enchantment enchantment = Enchantment.getByName((String)enchantKey.toUpperCase());
                    this.enchantments.put(enchantment, enchantConfig.getInt(enchantKey));
                }
                catch (Exception ex) {
                    spell.getController().getLogger().warning("Invalid enchantment: " + enchantKey);
                }
            }
        }
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.material = ConfigurationUtils.getMaterialAndData(parameters, "material");
        this.useItem = parameters.getBoolean("use_item", false);
        this.slotNumber = parameters.getInt("armor_slot", 3);
        this.slotNumber = Math.max(Math.min(this.slotNumber, 3), 0);
    }

    @Override
    public SpellResult perform(CastContext context) {
        ItemStack[] armor;
        ItemStack itemStack;
        Material baseMaterial;
        Block targetBlock;
        Entity entity = context.getTargetEntity();
        if (entity == null) {
            if (!context.getTargetsCaster()) {
                return SpellResult.NO_TARGET;
            }
            entity = context.getEntity();
        }
        if (entity == null || !(entity instanceof Player)) {
            return SpellResult.NO_TARGET;
        }
        Player player = (Player)entity;
        MaterialAndData material = this.material;
        MageController controller = context.getController();
        com.elmakers.mine.bukkit.api.magic.Mage mage = controller.getMage(player);
        if (this.useItem) {
            ItemStack itemInHand;
            Wand activeWand = mage.getActiveWand();
            if (activeWand != context.getWand()) {
                return SpellResult.NO_TARGET;
            }
            if (activeWand != null) {
                activeWand.deactivate();
            }
            if ((itemInHand = player.getItemInHand()) == null || itemInHand.getType() == Material.AIR) {
                return SpellResult.FAIL;
            }
            ItemStack[] armor2 = player.getInventory().getArmorContents();
            ItemStack currentItem = armor2[this.slotNumber];
            armor2[this.slotNumber] = itemInHand;
            player.getInventory().setArmorContents(armor2);
            if (!InventoryUtils.isTemporary(currentItem)) {
                player.setItemInHand(currentItem);
            } else {
                player.setItemInHand(new ItemStack(Material.AIR));
            }
            if (mage instanceof Mage) {
                ((Mage)mage).armorUpdated();
            }
            return SpellResult.CAST;
        }
        if (material == null && (context.getSpell().usesBrush() || context.getSpell().hasBrushOverride())) {
            material = context.getBrush();
        }
        if (material == null && (targetBlock = context.getTargetBlock()) != null && ((baseMaterial = (material = new com.elmakers.mine.bukkit.block.MaterialAndData(targetBlock)).getMaterial()).getId() == 176 || baseMaterial.getId() == 177)) {
            ((com.elmakers.mine.bukkit.block.MaterialAndData)material).setMaterialId(425);
        }
        if (entity == null || !(entity instanceof Player) || material == null || material.getMaterial() == Material.AIR) {
            return SpellResult.NO_TARGET;
        }
        ItemStack wearItem = material.getItemStack(1);
        ItemMeta meta = wearItem.getItemMeta();
        String displayName = context.getMessage("hat_name", "");
        displayName = context.getMessage("wear_name", displayName);
        String materialName = material.getName();
        if (materialName == null || materialName.isEmpty()) {
            materialName = "?";
        }
        if (displayName != null && !displayName.isEmpty()) {
            meta.setDisplayName(displayName.replace("$hat", materialName).replace("$item", materialName));
        }
        ArrayList<String> lore = new ArrayList<String>();
        String loreLine = context.getMessage("hat_lore");
        loreLine = context.getMessage("wear_lore", loreLine);
        lore.add(loreLine);
        meta.setLore(lore);
        wearItem.setItemMeta(meta);
        wearItem = InventoryUtils.makeReal(wearItem);
        NMSUtils.makeTemporary(wearItem, context.getMessage("removed").replace("$hat", materialName).replace("$item", materialName));
        if (this.enchantments != null) {
            wearItem.addUnsafeEnchantments(this.enchantments);
        }
        if ((itemStack = (armor = player.getInventory().getArmorContents())[this.slotNumber]) != null && itemStack.getType() != Material.AIR) {
            ItemStack replacement;
            if (NMSUtils.isTemporary(itemStack) && (replacement = NMSUtils.getReplacement(itemStack)) != null) {
                itemStack = replacement;
            }
            if (itemStack != null) {
                NMSUtils.setReplacement(wearItem, itemStack);
            }
        }
        armor[this.slotNumber] = wearItem;
        player.getInventory().setArmorContents(armor);
        armor = player.getInventory().getArmorContents();
        ItemStack helmetItem = armor[this.slotNumber];
        if (!NMSUtils.isTemporary(helmetItem)) {
            armor[this.slotNumber] = itemStack;
            player.getInventory().setArmorContents(armor);
            return SpellResult.NO_TARGET;
        }
        context.registerForUndo(new WeearUndoAction(mage, this.slotNumber));
        if (mage instanceof Mage) {
            ((Mage)mage).armorUpdated();
        }
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("material");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("material")) {
            examples.addAll(MagicPlugin.getAPI().getBrushes());
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    private class WeearUndoAction
    implements Runnable {
        private final com.elmakers.mine.bukkit.api.magic.Mage mage;
        private final int slotNumber;

        public WeearUndoAction(com.elmakers.mine.bukkit.api.magic.Mage mage, int slotNumber) {
            this.mage = mage;
            this.slotNumber = slotNumber;
        }

        @Override
        public void run() {
            Player player = this.mage.getPlayer();
            if (player == null) {
                return;
            }
            ItemStack[] armor = player.getInventory().getArmorContents();
            ItemStack currentItem = armor[this.slotNumber];
            if (NMSUtils.isTemporary(currentItem)) {
                ItemStack replacement;
                armor[this.slotNumber] = replacement = NMSUtils.getReplacement(currentItem);
                player.getInventory().setArmorContents(armor);
            }
            if (this.mage instanceof Mage) {
                ((Mage)this.mage).armorUpdated();
            }
        }
    }
}

