/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.Vector;

public class VolumeAction
extends CompoundAction {
    public static final float DEGTORAD = (float)Math.PI / 180;
    private static final int DEFAULT_RADIUS = 2;
    protected boolean autoOrient;
    protected boolean autoPitch;
    protected double radius;
    protected double radiusSquared;
    protected int spiralRadius;
    protected int currentRadius;
    protected float centerProbability;
    protected float outerProbability;
    protected double xSize;
    protected double ySize;
    protected double zSize;
    protected double radiusPadding;
    protected int xSizeCeil;
    protected int ySizeCeil;
    protected int zSizeCeil;
    protected double thickness;
    protected int yStart;
    protected int yEnd;
    private int xOffset;
    private int zOffset;
    private int dy;
    private int dx;
    private int dz;
    private int xDirection;
    private int zDirection;
    private int startRadius;
    private Vector min;
    private Vector max;
    private VolumeType volumeType;
    private boolean useBrushSize;
    private boolean centerY;
    private boolean centerX;
    private boolean centerZ;
    private boolean replaceTarget;
    private Material replaceMaterial;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.radiusPadding = parameters.getDouble("radius_padding", 0.25);
        this.radius = parameters.getDouble("radius", 2.0);
        this.xSize = parameters.getDouble("x_size", this.radius);
        this.ySize = parameters.getDouble("y_size", this.radius);
        this.zSize = parameters.getDouble("z_size", this.radius);
        this.centerY = parameters.getBoolean("center_y", true);
        this.centerX = parameters.getBoolean("center_x", true);
        this.centerZ = parameters.getBoolean("center_z", true);
        this.thickness = parameters.getDouble("thickness", 0.0);
        this.autoOrient = parameters.getBoolean("orient", false);
        this.autoPitch = parameters.getBoolean("orient_pitch", this.autoOrient);
        this.centerProbability = (float)parameters.getDouble("probability", 1.0);
        this.outerProbability = (float)parameters.getDouble("probability", 1.0);
        this.centerProbability = (float)parameters.getDouble("center_probability", (double)this.centerProbability);
        this.outerProbability = (float)parameters.getDouble("outer_probability", (double)this.outerProbability);
        this.useBrushSize = parameters.getBoolean("use_brush_size", false);
        this.replaceTarget = parameters.getBoolean("replace", false);
        String typeString = parameters.getString("volume_type");
        if (typeString != null) {
            try {
                this.volumeType = VolumeType.valueOf(typeString.toUpperCase());
            }
            catch (Exception ex) {
                this.volumeType = VolumeType.SPIRAL;
            }
        } else {
            this.volumeType = VolumeType.SPIRAL;
        }
    }

    protected boolean calculateSize(CastContext context) {
        if (this.useBrushSize) {
            MaterialBrush brush = context.getBrush();
            if (!brush.isReady()) {
                return false;
            }
            Vector bounds = brush.getSize();
            this.xSize = (int)Math.ceil(bounds.getX() / 2.0) + 1;
            this.ySize = (int)Math.ceil(bounds.getY() / 2.0) + 1;
            this.zSize = (int)Math.ceil(bounds.getZ() / 2.0) + 1;
            if (this.volumeType == VolumeType.SPIRAL) {
                this.xSize = Math.max(this.xSize, this.zSize);
                this.zSize = Math.max(this.xSize, this.zSize);
            }
            this.centerY = false;
            context.getMage().sendDebugMessage(ChatColor.GREEN + "Brush Size: " + ChatColor.GRAY + this.xSize + "," + this.ySize + "," + this.zSize, 2);
        } else {
            this.xSize = (double)context.getMage().getRadiusMultiplier() * this.xSize;
            this.ySize = (double)context.getMage().getRadiusMultiplier() * this.ySize;
            this.zSize = (double)context.getMage().getRadiusMultiplier() * this.zSize;
        }
        if (this.volumeType == VolumeType.SPIRAL && this.xSize != this.zSize) {
            this.volumeType = VolumeType.YZX;
        }
        this.xSizeCeil = (int)Math.ceil(this.xSize);
        this.ySizeCeil = (int)Math.ceil(this.ySize);
        this.zSizeCeil = (int)Math.ceil(this.zSize);
        if (this.centerY) {
            this.yStart = -this.ySizeCeil;
            this.yEnd = this.ySizeCeil;
        } else {
            this.yStart = 0;
            this.yEnd = this.ySizeCeil * 2;
        }
        this.xOffset = !this.centerX ? this.xSizeCeil : 0;
        this.zOffset = !this.centerZ ? this.zSizeCeil : 0;
        if (this.volumeType != VolumeType.SPIRAL) {
            this.min = new Vector(-this.xSizeCeil, this.yStart, -this.zSizeCeil);
            this.max = new Vector(this.xSizeCeil, this.yEnd, this.zSizeCeil);
        }
        this.radius = Math.max(this.xSize, this.zSize);
        this.spiralRadius = (int)Math.ceil(this.radius);
        this.radius = Math.max(this.radius, this.ySize);
        this.radiusSquared = (this.radius + this.radiusPadding) * (this.radius + this.radiusPadding);
        this.startRadius = this.getStartRadius();
        return true;
    }

    protected int getStartRadius() {
        return 0;
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        MaterialBrush brush = context.getBrush();
        brush.setTarget(context.getTargetLocation());
    }

    protected void resetCounters() {
        if (this.volumeType == VolumeType.SPIRAL) {
            this.currentRadius = this.startRadius;
            this.dx = -Math.min(this.startRadius, this.xSizeCeil);
            this.dy = this.yStart;
            this.dz = -Math.min(this.startRadius, this.zSizeCeil);
            this.xDirection = 1;
            this.zDirection = 0;
        } else {
            this.dx = this.min.getBlockX();
            this.dy = this.min.getBlockY();
            this.dz = this.min.getBlockZ();
        }
    }

    public static Vector rotate(float yaw, float pitch, double x, double y, double z) {
        float angle = -yaw * ((float)Math.PI / 180);
        double sinYaw = Math.sin(angle);
        double cosYaw = Math.cos(angle);
        angle = pitch * ((float)Math.PI / 180);
        double sinPitch = Math.sin(angle);
        double cosPitch = Math.cos(angle);
        double pitchedZ = y * sinPitch + z * cosPitch;
        double finalX = x * cosYaw + pitchedZ * sinYaw + 0.5;
        double finalY = y * cosPitch - z * sinPitch + 0.5;
        double finalZ = -x * sinYaw + pitchedZ * cosYaw + 0.5;
        return new Vector(finalX, finalY, finalZ);
    }

    protected boolean nextYZX(CastContext context) {
        ++this.dy;
        if (this.dy > this.max.getBlockY()) {
            this.dy = this.min.getBlockY();
            ++this.dz;
            if (this.dz > this.max.getBlockZ()) {
                this.dz = this.min.getBlockZ();
                ++this.dx;
            }
        }
        return this.dx <= this.max.getBlockX() && this.dy <= this.max.getBlockY() && this.dz <= this.max.getBlockZ();
    }

    protected boolean nextYXZ(CastContext context) {
        ++this.dy;
        if (this.dy > this.max.getBlockY()) {
            this.dy = this.min.getBlockY();
            ++this.dx;
            if (this.dx > this.max.getBlockX()) {
                this.dx = this.min.getBlockX();
                ++this.dz;
            }
        }
        return this.dx <= this.max.getBlockX() && this.dy <= this.max.getBlockY() && this.dz <= this.max.getBlockZ();
    }

    protected boolean nextSpiral(CastContext context) {
        ++this.dy;
        if (this.dy > this.yEnd) {
            this.dy = this.yStart;
            int nextX = this.dx + this.xDirection;
            int nextZ = this.dz + this.zDirection;
            int endX = Math.min(this.currentRadius, this.xSizeCeil);
            int endZ = Math.min(this.currentRadius, this.zSizeCeil);
            if (this.xDirection == 0 && this.zDirection == -1 && nextX <= -endX && nextZ <= -endZ || this.currentRadius == 0) {
                ++this.currentRadius;
                this.dx = -this.currentRadius;
                this.dz = -this.currentRadius;
                this.xDirection = 1;
                this.zDirection = 0;
            } else if (nextX > this.currentRadius || nextZ > endZ || nextX < -endX || nextZ < -endZ) {
                if (this.xDirection == 1 && this.zDirection == 0) {
                    this.xDirection = 0;
                    this.zDirection = 1;
                    this.dz += this.zDirection;
                } else if (this.xDirection == 0 && this.zDirection == 1) {
                    this.xDirection = -1;
                    this.zDirection = 0;
                    this.dx += this.xDirection;
                } else {
                    this.xDirection = 0;
                    this.zDirection = -1;
                    this.dz += this.zDirection;
                }
            } else {
                this.dx = nextX;
                this.dz = nextZ;
            }
        }
        return this.currentRadius <= this.spiralRadius;
    }

    @Override
    public SpellResult start(CastContext context) {
        if (!this.calculateSize(context)) {
            return SpellResult.PENDING;
        }
        this.replaceMaterial = this.replaceTarget ? context.getTargetBlock().getType() : null;
        this.resetCounters();
        return SpellResult.NO_ACTION;
    }

    @Override
    public boolean next(CastContext context) {
        if (this.radius < 1.0) {
            return false;
        }
        boolean result = false;
        switch (this.volumeType) {
            case SPIRAL: {
                result = this.nextSpiral(context);
                break;
            }
            case YZX: {
                result = this.nextYZX(context);
                break;
            }
            case YXZ: {
                result = this.nextYXZ(context);
            }
        }
        return result;
    }

    @Override
    public SpellResult step(CastContext context) {
        SpellResult result = SpellResult.NO_ACTION;
        boolean singleBlock = this.radius < 1.0;
        boolean validBlock = singleBlock ? true : this.containsPoint(this.dx, this.dy, this.dz);
        float probability = this.centerProbability;
        if (!singleBlock && this.centerProbability != this.outerProbability) {
            float weight = Math.abs((float)this.dx + (float)this.dz) / ((float)this.spiralRadius * 2.0f);
            probability = RandomUtils.lerp(Float.valueOf(this.centerProbability), Float.valueOf(this.outerProbability), weight).floatValue();
        }
        boolean bl = validBlock = validBlock && (probability >= 1.0f || context.getRandom().nextDouble() <= (double)probability);
        if (validBlock) {
            Block block = context.getTargetBlock();
            Vector offset = new Vector();
            if (this.autoOrient) {
                Location location = this.actionContext.getLocation();
                offset.setX(this.dx + this.xOffset);
                offset.setY(this.dy);
                offset.setZ(this.dz + this.zOffset);
                float pitch = this.autoPitch ? location.getPitch() : 0.0f;
                Block originalBlock = block.getRelative(offset.getBlockX(), offset.getBlockY(), offset.getBlockZ());
                this.actionContext.setTargetSourceLocation(originalBlock.getRelative(-this.xOffset, 0, -this.zOffset).getLocation());
                offset = VolumeAction.rotate(location.getYaw(), pitch, offset.getX(), offset.getY(), offset.getZ());
            } else {
                offset.setX(this.dx);
                offset.setY(this.dy);
                offset.setZ(this.dz);
            }
            Block targetBlock = block.getRelative(offset.getBlockX(), offset.getBlockY(), offset.getBlockZ());
            if (this.replaceMaterial == null || targetBlock.getType() == this.replaceMaterial) {
                this.actionContext.setTargetLocation(targetBlock.getLocation());
                result = this.startActions();
            }
        } else {
            this.skippedActions(context);
        }
        return result;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    protected boolean containsPoint(int x, int y, int z) {
        return this.thickness == 0.0 || (double)x > this.radius - this.thickness || (double)y > this.radius - this.thickness || (double)z > this.radius - this.thickness;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("radius");
        parameters.add("probability");
        parameters.add("center_probability");
        parameters.add("outer_probability");
        parameters.add("use_brush_size");
        parameters.add("thickness");
        parameters.add("orient");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        super.getParameterOptions(spell, parameterKey, examples);
        if (parameterKey.equals("radius") || parameterKey.equals("thickness")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("probability") || parameterKey.equals("center_probability") || parameterKey.equals("outer_probability")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_PERCENTAGES));
        } else if (parameterKey.equals("orient") || parameterKey.equals("use_brush_size")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        }
    }

    @Override
    public int getActionCount() {
        int volume = (1 + this.xSizeCeil * 2) * (1 + this.ySizeCeil * 2) * (1 + this.zSizeCeil * 2);
        return volume * super.getActionCount();
    }

    private static enum VolumeType {
        SPIRAL,
        YZX,
        YXZ;

    }
}

