/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.Target;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SignSpell
extends BlockSpell {
    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        String typeString = parameters.getString("type", "");
        boolean autoGive = parameters.getBoolean("auto_give", false);
        boolean editSign = parameters.getBoolean("edit", false);
        Entity sourceEntity = this.mage.getEntity();
        if (sourceEntity == null) {
            return SpellResult.ENTITY_REQUIRED;
        }
        if (typeString.equals("give") || autoGive && this.isLookingUp()) {
            Player player = this.mage.getPlayer();
            if (player == null) {
                return SpellResult.PLAYER_REQUIRED;
            }
            this.castMessage(this.getMessage("cast_give"));
            this.controller.giveItemToPlayer(player, new ItemStack(Material.SIGN, 4));
            return SpellResult.CAST;
        }
        Target target = this.getTarget();
        Block block = target.getBlock();
        if (target.isValid() && block != null) {
            Block targetBlock = this.getPreviousBlock();
            if (targetBlock == null || !this.hasBuildPermission(targetBlock)) {
                return SpellResult.INSUFFICIENT_PERMISSION;
            }
            if (targetBlock.getRelative(BlockFace.DOWN).getType() == Material.AIR) {
                targetBlock.setType(Material.WALL_SIGN);
                switch (block.getFace(targetBlock)) {
                    case NORTH: {
                        targetBlock.setData((byte)2);
                        break;
                    }
                    case SOUTH: {
                        targetBlock.setData((byte)3);
                        break;
                    }
                    case WEST: {
                        targetBlock.setData((byte)4);
                        break;
                    }
                    case EAST: {
                        targetBlock.setData((byte)5);
                        break;
                    }
                    default: {
                        targetBlock.setData((byte)0);
                        break;
                    }
                }
            } else {
                float yaw;
                targetBlock.setType(Material.SIGN_POST);
                for (yaw = this.getLocation().getYaw() - 157.5f; yaw < 0.0f; yaw += 360.0f) {
                }
                while (yaw >= 360.0f) {
                    yaw -= 360.0f;
                }
                targetBlock.setData((byte)(yaw * 15.0f / 360.0f));
            }
            if (targetBlock.getState() instanceof Sign) {
                Sign sign = (Sign)targetBlock.getState();
                String playerName = this.controller.getEntityDisplayName(sourceEntity);
                playerName = this.mage.getController().getMessagePrefix() + playerName;
                sign.setLine(0, playerName);
                sign.setLine(1, this.getMessage("sign_message"));
                Date currentDate = new Date();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
                sign.setLine(2, dateFormat.format(currentDate));
                sign.setLine(3, timeFormat.format(currentDate));
                sign.update();
                this.registerForUndo(targetBlock);
                this.registerForUndo();
                this.controller.updateBlock(targetBlock);
                if (editSign && sourceEntity instanceof Player) {
                    Player player = (Player)sourceEntity;
                    InventoryUtils.openSign(player, targetBlock.getLocation());
                }
                return SpellResult.CAST;
            }
            return SpellResult.FAIL;
        }
        if (target.hasEntity() && target.getEntity() instanceof Player) {
            return SpellResult.CAST;
        }
        return SpellResult.NO_TARGET;
    }
}

