/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapView;

public class MapSpell
extends TargetingSpell {
    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        World world = this.getWorld();
        MapView newMap = Bukkit.createMap((World)world);
        Location location = this.getLocation();
        newMap.setCenterX(location.getBlockX());
        newMap.setCenterZ(location.getBlockZ());
        MapView.Scale scale = newMap.getScale();
        String scaleType = parameters.getString("scale");
        if (scaleType != null) {
            try {
                scale = MapView.Scale.valueOf((String)scaleType.toUpperCase());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        newMap.setScale(scale);
        ItemStack newMapItem = new ItemStack(Material.MAP, 1, newMap.getId());
        world.dropItemNaturally(this.getLocation(), newMapItem);
        return SpellResult.CAST;
    }
}

