/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.action.TeleportTask;
import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.batch.Batch;
import com.elmakers.mine.bukkit.api.batch.SpellBatch;
import com.elmakers.mine.bukkit.api.batch.UndoBatch;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.data.BrushData;
import com.elmakers.mine.bukkit.api.data.MageData;
import com.elmakers.mine.bukkit.api.data.SpellData;
import com.elmakers.mine.bukkit.api.data.UndoData;
import com.elmakers.mine.bukkit.api.effect.SoundEffect;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellEventType;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.LostWand;
import com.elmakers.mine.bukkit.api.wand.WandUpgradePath;
import com.elmakers.mine.bukkit.block.UndoQueue;
import com.elmakers.mine.bukkit.effect.HoloUtils;
import com.elmakers.mine.bukkit.effect.Hologram;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.magic.MageLoadTask;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.spell.ActionSpell;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandManaMode;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.util.Vector;

public class Mage
implements CostReducer,
com.elmakers.mine.bukkit.api.magic.Mage {
    protected static int AUTOMATA_ONLINE_TIMEOUT = 5000;
    public static double WAND_LOCATION_OFFSET = 0.5;
    public static double WAND_LOCATION_VERTICAL_OFFSET = 0.0;
    public static int JUMP_EFFECT_FLIGHT_EXEMPTION_DURATION = 0;
    private static final Set<Material> EMPTY_MATERIAL_SET = new HashSet<Material>();
    private static String defaultMageName = "Mage";
    private static String SKILL_POINT_KEY = "sp";
    protected final String id;
    protected ConfigurationSection data = new MemoryConfiguration();
    protected Map<String, SpellData> spellData = new HashMap<String, SpellData>();
    protected WeakReference<Player> _player;
    protected WeakReference<Entity> _entity;
    protected WeakReference<CommandSender> _commandSender;
    protected boolean hasEntity;
    protected String playerName;
    protected final MagicController controller;
    protected CommandSender debugger;
    protected HashMap<String, MageSpell> spells = new HashMap();
    private Wand activeWand = null;
    private Wand soulWand = null;
    private Map<String, Wand> boundWands = new HashMap<String, Wand>();
    private final Collection<Listener> quitListeners = new HashSet<Listener>();
    private final Collection<Listener> deathListeners = new HashSet<Listener>();
    private final Collection<Listener> damageListeners = new HashSet<Listener>();
    private final Set<MageSpell> activeSpells = new HashSet<MageSpell>();
    private UndoQueue undoQueue = null;
    private LinkedList<Batch> pendingBatches = new LinkedList();
    private boolean loading = false;
    private int debugLevel = 0;
    private boolean quiet = false;
    private EntityData entityData;
    private long lastTick;
    private Map<PotionEffectType, Integer> effectivePotionEffects = new HashMap<PotionEffectType, Integer>();
    protected float damageReduction = 0.0f;
    protected float damageReductionPhysical = 0.0f;
    protected float damageReductionProjectiles = 0.0f;
    protected float damageReductionFalling = 0.0f;
    protected float damageReductionFire = 0.0f;
    protected float damageReductionExplosions = 0.0f;
    protected long superProtectionExpiration = 0L;
    private Map<Integer, Wand> activeArmor = new HashMap<Integer, Wand>();
    private Location location;
    private float costReduction = 0.0f;
    private float cooldownReduction = 0.0f;
    private long cooldownExpiration = 0L;
    private float powerMultiplier = 1.0f;
    private long lastClick = 0L;
    private long lastCast = 0L;
    private long blockPlaceTimeout = 0L;
    private Location lastDeathLocation = null;
    private final com.elmakers.mine.bukkit.block.MaterialBrush brush;
    private long fallProtection = 0L;
    private long fallProtectionCount = 1L;
    private BaseSpell fallingSpell = null;
    private boolean isNewPlayer = true;
    private GUIAction gui = null;
    private Hologram hologram;
    private Integer hologramTaskId = null;
    private boolean hologramIsVisible = false;
    private Map<Integer, ItemStack> respawnInventory;
    private Map<Integer, ItemStack> respawnArmor;
    private List<ItemStack> restoreInventory;
    private boolean restoreOpenWand;
    private Float restoreExperience;
    private Integer restoreLevel;
    private boolean virtualExperience = false;
    private String destinationWarp;

    public Mage(String id, MagicController controller) {
        this.id = id;
        this.controller = controller;
        this.brush = new com.elmakers.mine.bukkit.block.MaterialBrush((com.elmakers.mine.bukkit.api.magic.Mage)this, Material.DIRT, 0);
        this._player = new WeakReference<Object>(null);
        this._entity = new WeakReference<Object>(null);
        this._commandSender = new WeakReference<Object>(null);
        this.hasEntity = false;
    }

    public void setCostReduction(float reduction) {
        this.costReduction = reduction;
    }

    @Override
    public boolean hasStoredInventory() {
        return this.activeWand != null && this.activeWand.hasStoredInventory();
    }

    @Override
    public Set<Spell> getActiveSpells() {
        return new HashSet<Spell>(this.activeSpells);
    }

    public Inventory getStoredInventory() {
        return this.activeWand != null ? this.activeWand.getStoredInventory() : null;
    }

    @Override
    public void setLocation(Location location) {
        LivingEntity entity = this.getLivingEntity();
        if (entity != null && location != null) {
            entity.teleport(location);
            return;
        }
        this.location = location;
    }

    public void setLocation(Location location, boolean direction) {
        if (!direction) {
            if (this.location == null) {
                this.location = location;
            } else {
                this.location.setX(location.getX());
                this.location.setY(location.getY());
                this.location.setZ(location.getZ());
            }
        } else {
            this.location = location;
        }
    }

    public void clearCache() {
        if (this.brush != null) {
            this.brush.clearSchematic();
        }
    }

    public void setCooldownReduction(float reduction) {
        this.cooldownReduction = reduction;
    }

    public void setPowerMultiplier(float mutliplier) {
        this.powerMultiplier = mutliplier;
    }

    public boolean usesMana() {
        return this.activeWand == null ? false : this.activeWand.usesMana();
    }

    public boolean addToStoredInventory(ItemStack item) {
        return this.activeWand == null ? false : this.activeWand.addToStoredInventory(item);
    }

    public boolean cancel() {
        boolean result = false;
        for (MageSpell spell : this.spells.values()) {
            result = spell.cancel() || result;
        }
        return result;
    }

    public void onPlayerQuit(PlayerEvent event) {
        Player player = this.getPlayer();
        if (player == null || player != event.getPlayer()) {
            return;
        }
        ArrayList<Listener> active = new ArrayList<Listener>(this.quitListeners);
        for (Listener listener : active) {
            this.callEvent(listener, (Event)event);
        }
    }

    public void onPlayerDeath(EntityDeathEvent event) {
        Player player = this.getPlayer();
        if (player == null || player != event.getEntity()) {
            return;
        }
        if (!player.hasMetadata("arena")) {
            this.lastDeathLocation = player.getLocation();
        }
        ArrayList<Listener> active = new ArrayList<Listener>(this.deathListeners);
        for (Listener listener : active) {
            this.callEvent(listener, (Event)event);
        }
    }

    public void onPlayerCombust(EntityCombustEvent event) {
        if (this.activeWand != null && this.activeWand.getDamageReductionFire() > 0.0f) {
            event.getEntity().setFireTicks(0);
            event.setCancelled(true);
        }
    }

    protected void callEvent(Listener listener, Event event) {
        for (Method method : listener.getClass().getMethods()) {
            Class<?>[] parameters;
            if (!method.isAnnotationPresent(EventHandler.class) || (parameters = method.getParameterTypes()).length != 1 || !parameters[0].isAssignableFrom(event.getClass())) continue;
            try {
                method.invoke((Object)listener, event);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void onPlayerDamage(EntityDamageEvent event) {
        EntityDamageEvent.DamageCause cause;
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        ArrayList<Listener> active = new ArrayList<Listener>(this.damageListeners);
        for (Listener listener : active) {
            this.callEvent(listener, (Event)event);
            if (!event.isCancelled()) continue;
            break;
        }
        if ((cause = event.getCause()) == EntityDamageEvent.DamageCause.FALL) {
            if (this.fallProtectionCount > 0L && this.fallProtection > 0L && this.fallProtection > System.currentTimeMillis()) {
                event.setCancelled(true);
                --this.fallProtectionCount;
                if (this.fallingSpell != null) {
                    double scale = 1.0;
                    LivingEntity li = this.getLivingEntity();
                    if (li != null) {
                        scale = event.getDamage() / li.getMaxHealth();
                    }
                    this.fallingSpell.playEffects("land", (float)scale, player.getLocation().getBlock().getRelative(BlockFace.DOWN));
                }
                if (this.fallProtectionCount <= 0L) {
                    this.fallProtection = 0L;
                    this.fallingSpell = null;
                }
                return;
            }
            this.fallingSpell = null;
        }
        if (this.isSuperProtected()) {
            event.setCancelled(true);
            if (player.getFireTicks() > 0) {
                player.setFireTicks(0);
            }
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        float reduction = 0.0f;
        reduction = this.damageReduction * this.controller.getMaxDamageReduction();
        switch (cause) {
            case CONTACT: 
            case ENTITY_ATTACK: {
                reduction += this.damageReductionPhysical * this.controller.getMaxDamageReductionPhysical();
                break;
            }
            case PROJECTILE: {
                reduction += this.damageReductionProjectiles * this.controller.getMaxDamageReductionProjectiles();
                break;
            }
            case FALL: {
                reduction += this.damageReductionFalling * this.controller.getMaxDamageReductionFalling();
                break;
            }
            case FIRE: 
            case FIRE_TICK: 
            case LAVA: {
                if (this.damageReductionFire > 0.0f && player.getFireTicks() > 0) {
                    player.setFireTicks(0);
                }
                reduction += this.damageReductionFire * this.controller.getMaxDamageReductionFire();
                break;
            }
            case BLOCK_EXPLOSION: 
            case ENTITY_EXPLOSION: {
                reduction += this.damageReductionExplosions * this.controller.getMaxDamageReductionExplosions();
            }
        }
        if (reduction >= 1.0f) {
            event.setCancelled(true);
            return;
        }
        double damage = event.getDamage();
        if (reduction > 0.0f) {
            if ((damage = (double)(1.0f - reduction) * damage) <= 0.0) {
                damage = 0.1;
            }
            event.setDamage(damage);
        }
        if (damage > 0.0) {
            Iterator iterator = this.pendingBatches.iterator();
            while (iterator.hasNext()) {
                SpellBatch spellBatch;
                Spell spell;
                double cancelOnDamage;
                Batch batch = (Batch)iterator.next();
                if (!(batch instanceof SpellBatch) || !((cancelOnDamage = (spell = (spellBatch = (SpellBatch)batch).getSpell()).cancelOnDamage()) > 0.0) || !(cancelOnDamage < damage)) continue;
                if (!spell.cancel()) {
                    spell.sendMessage(spell.getMessage("cancel"));
                }
                batch.finish();
                iterator.remove();
            }
        }
    }

    @Override
    public void unbindAll() {
        this.boundWands.clear();
    }

    @Override
    public void unbind(com.elmakers.mine.bukkit.api.wand.Wand wand) {
        String template = wand.getTemplateKey();
        if (template != null) {
            this.boundWands.remove(template);
        }
    }

    public void setActiveWand(Wand activeWand) {
        String template;
        if (this.activeWand == activeWand) {
            return;
        }
        this.activeWand = activeWand;
        if (activeWand != null && activeWand.isBound() && activeWand.canUse(this.getPlayer()) && (template = activeWand.getTemplateKey()) != null && !template.isEmpty()) {
            this.boundWands.put(template, activeWand);
        }
        this.blockPlaceTimeout = System.currentTimeMillis() + 200L;
        this.updateEquipmentEffects();
    }

    public long getBlockPlaceTimeout() {
        return this.blockPlaceTimeout;
    }

    @Override
    public void castMessage(String message) {
        if (message == null || message.length() == 0 || this.quiet) {
            return;
        }
        CommandSender sender = this.getCommandSender();
        if (sender != null && this.controller.showCastMessages() && this.controller.showMessages()) {
            sender.sendMessage(this.controller.getCastMessagePrefix() + message);
        }
    }

    @Override
    public void sendMessage(String message) {
        if (message == null || message.length() == 0 || this.quiet) {
            return;
        }
        CommandSender sender = this.getCommandSender();
        if (sender != null && this.controller.showMessages()) {
            sender.sendMessage(this.controller.getMessagePrefix() + message);
        }
    }

    public void clearBuildingMaterial() {
        this.brush.setMaterial(this.controller.getDefaultMaterial(), (short)1);
    }

    @Override
    public void playSoundEffect(SoundEffect soundEffect) {
        if (!this.controller.soundsEnabled() || soundEffect == null) {
            return;
        }
        soundEffect.play((Plugin)this.controller.getPlugin(), this.getEntity());
    }

    @Override
    public UndoQueue getUndoQueue() {
        if (this.undoQueue == null) {
            this.undoQueue = new UndoQueue(this);
            this.undoQueue.setMaxSize(this.controller.getUndoQueueDepth());
        }
        return this.undoQueue;
    }

    @Override
    public UndoList getLastUndoList() {
        if (this.undoQueue == null || this.undoQueue.isEmpty()) {
            return null;
        }
        return this.undoQueue.getLast();
    }

    @Override
    public boolean prepareForUndo(UndoList undoList) {
        if (undoList == null) {
            return false;
        }
        if (undoList.bypass()) {
            return true;
        }
        UndoQueue queue = this.getUndoQueue();
        queue.add(undoList);
        return true;
    }

    @Override
    public boolean registerForUndo(UndoList undoList) {
        if (!this.prepareForUndo(undoList)) {
            return false;
        }
        int autoUndo = this.controller.getAutoUndoInterval();
        if (autoUndo > 0 && undoList.getScheduledUndo() == 0) {
            undoList.setScheduleUndo(autoUndo);
        } else {
            undoList.updateScheduledUndo();
        }
        if (undoList.isScheduled()) {
            this.controller.scheduleUndo(undoList);
        }
        return true;
    }

    @Override
    public void addUndoBatch(UndoBatch batch) {
        this.pendingBatches.addLast(batch);
        this.controller.addPending(this);
    }

    protected void setPlayer(Player player) {
        if (player != null) {
            this.playerName = player.getName();
            this._player = new WeakReference<Player>(player);
            this._entity = new WeakReference<Player>(player);
            this._commandSender = new WeakReference<Player>(player);
            this.hasEntity = true;
        } else {
            this._player.clear();
            this._entity.clear();
            this._commandSender.clear();
            this.hasEntity = false;
        }
    }

    protected void setEntity(Entity entity) {
        if (entity != null) {
            LivingEntity li;
            String customName;
            this.playerName = entity.getType().name().toLowerCase().replace("_", " ");
            if (entity instanceof LivingEntity && (customName = (li = (LivingEntity)entity).getCustomName()) != null && customName.length() > 0) {
                this.playerName = customName;
            }
            this._entity = new WeakReference<Entity>(entity);
            this.hasEntity = true;
        } else {
            this._entity.clear();
            this.hasEntity = false;
        }
    }

    protected void setCommandSender(CommandSender sender) {
        if (sender != null) {
            this._commandSender = new WeakReference<CommandSender>(sender);
            if (sender instanceof BlockCommandSender) {
                BlockCommandSender commandBlock = (BlockCommandSender)sender;
                this.playerName = commandBlock.getName();
                Location location = this.getLocation();
                if (location == null) {
                    location = commandBlock.getBlock().getLocation();
                } else {
                    Location blockLocation = commandBlock.getBlock().getLocation();
                    location.setX(blockLocation.getX());
                    location.setY(blockLocation.getY());
                    location.setZ(blockLocation.getZ());
                }
                this.setLocation(location, false);
            } else {
                this.setLocation(null);
            }
        } else {
            this._commandSender.clear();
            this.setLocation(null);
        }
    }

    protected void onLoad(MageData data) {
        try {
            Player player;
            Collection<SpellData> spellDataList;
            Collection<SpellData> collection = spellDataList = data == null ? null : data.getSpellData();
            if (spellDataList != null) {
                for (SpellData spellData : spellDataList) {
                    this.spellData.put(spellData.getKey(), spellData);
                }
            }
            if ((player = this.getPlayer()) != null) {
                if (this.controller.isInventoryBackupEnabled()) {
                    if (this.restoreInventory != null) {
                        this.controller.getLogger().info("Restoring saved inventory for player " + player.getName() + " - did the server not shut down properly?");
                        if (this.activeWand != null) {
                            this.activeWand.deactivate();
                        }
                        PlayerInventory inventory = player.getInventory();
                        for (int slot = 0; slot < this.restoreInventory.size(); ++slot) {
                            ItemStack item = this.restoreInventory.get(slot);
                            if (item instanceof ItemStack) {
                                inventory.setItem(slot, item);
                                continue;
                            }
                            inventory.setItem(slot, null);
                        }
                        this.restoreInventory = null;
                    }
                    if (this.restoreExperience != null) {
                        player.setExp(this.restoreExperience.floatValue());
                        this.restoreExperience = null;
                    }
                    if (this.restoreLevel != null) {
                        player.setLevel(this.restoreLevel.intValue());
                        this.restoreLevel = null;
                    }
                }
                if (this.activeWand == null) {
                    String welcomeWand = this.controller.getWelcomeWand();
                    Wand wand = Wand.getActiveWand(this.controller, player);
                    if (wand != null) {
                        wand.activate(this);
                    } else if (this.isNewPlayer && welcomeWand.length() > 0) {
                        this.isNewPlayer = false;
                        wand = Wand.createWand(this.controller, welcomeWand);
                        if (wand != null) {
                            wand.takeOwnership(player, false, false);
                            this.giveItem(wand.getItem());
                            this.controller.getLogger().info("Gave welcome wand " + wand.getName() + " to " + player.getName());
                        } else {
                            this.controller.getLogger().warning("Unable to give welcome wand '" + welcomeWand + "' to " + player.getName());
                        }
                    }
                }
                if (this.activeWand != null && this.restoreOpenWand && !this.activeWand.isInventoryOpen()) {
                    this.activeWand.openInventory();
                }
                this.restoreOpenWand = false;
            }
            this.armorUpdated();
            this.loading = false;
        }
        catch (Exception ex) {
            this.controller.getLogger().warning("Error finalizing player data for " + this.playerName + ": " + ex.getMessage());
        }
    }

    protected void finishLoad(MageData data) {
        MageLoadTask loadTask = new MageLoadTask(this, data);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.controller.getPlugin(), (Runnable)loadTask, 1L);
    }

    @Override
    public boolean load(MageData data) {
        try {
            if (data == null) {
                this.finishLoad(data);
                return true;
            }
            this.boundWands.clear();
            Map<String, ItemStack> boundWandItems = data.getBoundWands();
            if (boundWandItems != null) {
                for (ItemStack boundWandItem : boundWandItems.values()) {
                    Wand boundWand = new Wand(this.controller, boundWandItem);
                    this.boundWands.put(boundWand.getTemplateKey(), boundWand);
                }
            }
            this.data = data.getExtraData();
            com.elmakers.mine.bukkit.api.wand.Wand apiWand = data.getSoulWand();
            if (apiWand instanceof Wand) {
                this.soulWand = (Wand)apiWand;
            }
            this.cooldownExpiration = data.getCooldownExpiration();
            this.fallProtectionCount = data.getFallProtectionCount();
            this.fallProtection = data.getFallProtectionDuration();
            if (this.fallProtectionCount > 0L && this.fallProtection > 0L) {
                this.fallProtection = System.currentTimeMillis() + this.fallProtection;
            }
            this.isNewPlayer = false;
            this.playerName = data.getName();
            this.lastDeathLocation = data.getLastDeathLocation();
            this.lastCast = data.getLastCast();
            this.destinationWarp = data.getDestinationWarp();
            if (this.destinationWarp != null) {
                if (!this.destinationWarp.isEmpty()) {
                    Location destination = this.controller.getWarp(this.destinationWarp);
                    if (destination != null) {
                        MagicPlugin plugin = this.controller.getPlugin();
                        this.controller.info("Warping " + this.getEntity().getName() + " to " + this.destinationWarp + " on login");
                        TeleportTask task = new TeleportTask(this.getController(), this.getEntity(), destination, 4, true, true, null);
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, (Runnable)task, 1L);
                    } else {
                        this.controller.info("Failed to warp " + this.getEntity().getName() + " to " + this.destinationWarp + " on login, warp doesn't exist");
                    }
                }
                this.destinationWarp = null;
            }
            this.getUndoQueue().load(data.getUndoData());
            this.respawnInventory = data.getRespawnInventory();
            this.respawnArmor = data.getRespawnArmor();
            this.restoreOpenWand = data.isOpenWand();
            BrushData brushData = data.getBrushData();
            if (brushData != null) {
                this.brush.load(brushData);
            }
            if (this.controller.isInventoryBackupEnabled()) {
                this.restoreInventory = data.getStoredInventory();
                this.restoreLevel = data.getStoredLevel();
                this.restoreExperience = data.getStoredExperience();
            }
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.WARNING, "Failed to load player data for " + this.playerName, ex);
            return false;
        }
        this.finishLoad(data);
        return true;
    }

    @Override
    public boolean save(MageData data) {
        if (this.loading) {
            return false;
        }
        try {
            data.setName(this.getName());
            data.setId(this.getId());
            data.setLastCast(this.lastCast);
            data.setLastDeathLocation(this.lastDeathLocation);
            data.setLocation(this.location);
            data.setDestinationWarp(this.destinationWarp);
            data.setCooldownExpiration(this.cooldownExpiration);
            long now = System.currentTimeMillis();
            if (this.fallProtectionCount > 0L && this.fallProtection > now) {
                data.setFallProtectionCount(this.fallProtectionCount);
                data.setFallProtectionDuration(this.fallProtection - now);
            } else {
                data.setFallProtectionCount(0L);
                data.setFallProtectionDuration(0L);
            }
            BrushData brushData = new BrushData();
            this.brush.save(brushData);
            data.setBrushData(brushData);
            UndoData undoData = new UndoData();
            this.getUndoQueue().save(undoData);
            data.setUndoData(undoData);
            for (MageSpell spell : this.spells.values()) {
                SpellData spellData = new SpellData(spell.getKey());
                spell.save(spellData);
                this.spellData.put(spellData.getKey(), spellData);
            }
            data.setSpellData(this.spellData.values());
            if (this.boundWands.size() > 0) {
                HashMap<String, ItemStack> wandItems = new HashMap<String, ItemStack>();
                for (Map.Entry<String, Wand> wandEntry : this.boundWands.entrySet()) {
                    wandItems.put(wandEntry.getKey(), wandEntry.getValue().getItem());
                }
                data.setBoundWands(wandItems);
            }
            data.setSoulWand(this.soulWand);
            data.setRespawnArmor(this.respawnArmor);
            data.setRespawnInventory(this.respawnInventory);
            data.setOpenWand(false);
            if (this.activeWand != null) {
                if (this.activeWand.hasStoredInventory()) {
                    data.setStoredInventory(Arrays.asList(this.activeWand.getStoredInventory().getContents()));
                }
                if (this.activeWand.isInventoryOpen()) {
                    data.setOpenWand(true);
                }
            }
            data.setExtraData(this.data);
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().log(Level.WARNING, "Failed to save player data for " + this.playerName, ex);
            return false;
        }
        return true;
    }

    public boolean checkLastClick(long maxInterval) {
        long now = System.currentTimeMillis();
        long previous = this.lastClick;
        this.lastClick = now;
        return previous <= 0L || previous + maxInterval < now;
    }

    protected void removeActiveEffects() {
        LivingEntity entity = this.getLivingEntity();
        if (entity == null) {
            return;
        }
        Collection activeEffects = entity.getActivePotionEffects();
        for (PotionEffect effect : activeEffects) {
            if (effect.getDuration() <= 0x3FFFFFFF) continue;
            entity.removePotionEffect(effect.getType());
        }
    }

    public void sendMessageKey(String key) {
        this.sendMessage(this.controller.getMessages().get(key, key));
    }

    public Wand checkWand(ItemStack itemInHand) {
        String activeId;
        Player player = this.getPlayer();
        if (this.isLoading() || player == null) {
            return null;
        }
        String itemId = Wand.getWandId(itemInHand);
        String string = activeId = this.activeWand != null ? this.activeWand.getId() : null;
        if (itemId != null && activeId == null || activeId != null && itemId == null || itemId != null && activeId != null && !itemId.equals(activeId)) {
            if (this.activeWand != null) {
                this.activeWand.deactivate();
            }
            if (itemInHand != null && itemId != null && this.controller.hasWandPermission(player)) {
                Wand newActiveWand = new Wand(this.controller, itemInHand);
                newActiveWand.activate(this);
            }
        }
        return this.activeWand;
    }

    @Override
    public Wand checkWand() {
        Player player = this.getPlayer();
        if (this.isLoading() || player == null) {
            return null;
        }
        return this.checkWand(player.getItemInHand());
    }

    @Override
    public void tick() {
        Player player;
        if (this.entityData != null) {
            long now = System.currentTimeMillis();
            if (this.lastTick != 0L) {
                long tickInterval = this.entityData.getTickInterval();
                if (now - this.lastTick > tickInterval) {
                    this.entityData.tick(this);
                    this.lastTick = now;
                }
            } else {
                this.lastTick = now;
            }
        }
        if ((player = this.getPlayer()) != null && player.isOnline()) {
            this.checkWand();
            if (this.activeWand != null) {
                this.activeWand.tick();
            } else if (this.virtualExperience) {
                this.resetSentExperience();
            }
            if (JUMP_EFFECT_FLIGHT_EXEMPTION_DURATION > 0 && player.hasPotionEffect(PotionEffectType.JUMP)) {
                this.controller.addFlightExemption(player, JUMP_EFFECT_FLIGHT_EXEMPTION_DURATION);
            }
            for (Wand armorWand : this.activeArmor.values()) {
                armorWand.updateEffects(this);
            }
            ArrayList<MageSpell> active = new ArrayList<MageSpell>(this.activeSpells);
            for (MageSpell spell : active) {
                spell.tick();
                if (spell.isActive()) continue;
                this.deactivateSpell(spell);
            }
        }
    }

    public int processPendingBatches(int maxBlockUpdates) {
        int updated = 0;
        if (this.pendingBatches.size() > 0) {
            ArrayList<Batch> processBatches = new ArrayList<Batch>(this.pendingBatches);
            this.pendingBatches.clear();
            for (Batch batch : processBatches) {
                if (updated < maxBlockUpdates) {
                    int batchUpdated = batch.process(maxBlockUpdates - updated);
                    updated += batchUpdated;
                }
                if (batch.isFinished()) continue;
                this.pendingBatches.add(batch);
            }
        }
        return updated;
    }

    public boolean hasPendingBatches() {
        return this.pendingBatches.size() > 0;
    }

    public void setLastHeldMapId(int mapId) {
        this.brush.setMapId(mapId);
    }

    protected void loadSpells(Map<String, ConfigurationSection> spellConfiguration) {
        if (spellConfiguration == null) {
            return;
        }
        ArrayList<MageSpell> currentSpells = new ArrayList<MageSpell>(this.spells.values());
        for (MageSpell spell : currentSpells) {
            String key = spell.getKey();
            if (spellConfiguration.containsKey(key)) {
                ConfigurationSection template = spellConfiguration.get(key);
                String className = template.getString("class");
                if (className == null) {
                    className = ActionSpell.class.getName();
                }
                if (!spell.getClass().getName().contains(className)) {
                    SpellData spellData = new SpellData(key);
                    spell.save(spellData);
                    this.spells.remove(key);
                    this.spellData.put(key, spellData);
                    continue;
                }
                spell.loadTemplate(key, template);
                continue;
            }
            this.spells.remove(key);
        }
    }

    public boolean isNewPlayer() {
        return this.isNewPlayer;
    }

    public void clearNewPlayer() {
        this.isNewPlayer = false;
    }

    @Override
    public Collection<Batch> getPendingBatches() {
        ArrayList<Batch> pending = new ArrayList<Batch>();
        pending.addAll(this.pendingBatches);
        return pending;
    }

    @Override
    public String getName() {
        return this.playerName == null || this.playerName.length() == 0 ? defaultMageName : this.playerName;
    }

    @Override
    public String getDisplayName() {
        Entity entity = this.getEntity();
        if (entity == null) {
            return this.getName();
        }
        if (entity instanceof Player) {
            return ((Player)entity).getDisplayName();
        }
        return this.controller.getEntityDisplayName(entity);
    }

    public void setName(String name) {
        this.playerName = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Location getLocation() {
        if (this.location != null) {
            return this.location.clone();
        }
        LivingEntity livingEntity = this.getLivingEntity();
        if (livingEntity == null) {
            return null;
        }
        return livingEntity.getLocation();
    }

    @Override
    public Location getEyeLocation() {
        Entity entity = this.getEntity();
        if (entity != null) {
            return CompatibilityUtils.getEyeLocation(entity);
        }
        return this.getLocation();
    }

    @Override
    public Location getWandLocation() {
        Location wandLocation = this.getEyeLocation();
        if (wandLocation == null) {
            return null;
        }
        Location toTheRight = wandLocation.clone();
        toTheRight.setYaw(toTheRight.getYaw() + 90.0f);
        Vector wandDirection = toTheRight.getDirection();
        wandLocation = wandLocation.clone();
        wandLocation.add(wandDirection.multiply(WAND_LOCATION_OFFSET));
        wandLocation.setY(wandLocation.getY() + WAND_LOCATION_VERTICAL_OFFSET);
        return wandLocation;
    }

    @Override
    public Vector getDirection() {
        Location location = this.getLocation();
        if (location != null) {
            return location.getDirection();
        }
        return new Vector(0, 1, 0);
    }

    @Override
    public UndoList undo(Block target) {
        return this.getUndoQueue().undo(target);
    }

    @Override
    public Batch cancelPending() {
        return this.cancelPending(null, true);
    }

    @Override
    public Batch cancelPending(String spellKey) {
        return this.cancelPending(spellKey, true);
    }

    @Override
    public Batch cancelPending(boolean force) {
        return this.cancelPending(null, force);
    }

    @Override
    public int finishPendingUndo() {
        int finished = 0;
        if (this.pendingBatches.size() > 0) {
            ArrayList<Batch> batches = new ArrayList<Batch>();
            batches.addAll(this.pendingBatches);
            for (Batch batch : batches) {
                if (!(batch instanceof com.elmakers.mine.bukkit.batch.UndoBatch)) continue;
                while (!batch.isFinished()) {
                    batch.process(1000);
                }
                this.pendingBatches.remove(batch);
                ++finished;
            }
        }
        return finished;
    }

    public Batch cancelPending(String spellKey, boolean force) {
        Batch stoppedPending = null;
        if (this.pendingBatches.size() > 0) {
            ArrayList<Batch> batches = new ArrayList<Batch>();
            batches.addAll(this.pendingBatches);
            for (Batch batch : batches) {
                SpellBatch spellBatch;
                Spell spell;
                if ((spellKey != null || !force) && (!(batch instanceof SpellBatch) || (spell = (spellBatch = (SpellBatch)batch).getSpell()) == null || !force && !spell.isCancellable() || spellKey != null && !spell.getSpellKey().getBaseKey().equalsIgnoreCase(spellKey)) || batch instanceof com.elmakers.mine.bukkit.batch.UndoBatch) continue;
                if (force && batch instanceof SpellBatch && (spell = (spellBatch = (SpellBatch)batch).getSpell()) != null && !spell.cancel()) {
                    spell.sendMessage(spell.getMessage("cancel"));
                }
                batch.finish();
                this.pendingBatches.remove(batch);
                stoppedPending = batch;
            }
        }
        return stoppedPending;
    }

    @Override
    public UndoList undo() {
        return this.getUndoQueue().undo();
    }

    @Override
    public boolean commit() {
        return this.getUndoQueue().commit();
    }

    @Override
    public boolean hasCastPermission(Spell spell) {
        return spell.hasCastPermission(this.getCommandSender());
    }

    @Override
    public MageSpell getSpell(String key) {
        if (this.loading) {
            return null;
        }
        MageSpell playerSpell = this.spells.get(key);
        if (playerSpell == null) {
            SpellData spellData;
            playerSpell = this.createSpell(key);
            if (playerSpell != null && (spellData = this.spellData.get(key)) != null) {
                playerSpell.load(spellData);
            }
        } else {
            playerSpell.setMage(this);
        }
        return playerSpell;
    }

    protected MageSpell createSpell(String key) {
        MageSpell playerSpell = this.spells.get(key);
        if (playerSpell != null) {
            playerSpell.setMage(this);
            return playerSpell;
        }
        SpellTemplate spellTemplate = this.controller.getSpellTemplate(key);
        if (spellTemplate == null) {
            return null;
        }
        Spell newSpell = spellTemplate.createSpell();
        if (newSpell == null || !(newSpell instanceof MageSpell)) {
            return null;
        }
        playerSpell = (MageSpell)newSpell;
        this.spells.put(newSpell.getKey(), playerSpell);
        playerSpell.setMage(this);
        return playerSpell;
    }

    @Override
    public Collection<Spell> getSpells() {
        ArrayList<Spell> export = new ArrayList<Spell>(this.spells.values());
        return export;
    }

    @Override
    public void activateSpell(Spell spell) {
        if (spell instanceof MageSpell) {
            MageSpell mageSpell = (MageSpell)spell;
            this.activeSpells.add(mageSpell);
            mageSpell.setActive(true);
        }
    }

    @Override
    public void deactivateSpell(Spell spell) {
        this.activeSpells.remove(spell);
        if (spell instanceof MageSpell) {
            ((MageSpell)spell).deactivate();
        }
    }

    @Override
    public void deactivateAllSpells() {
        this.deactivateAllSpells(false, false);
    }

    @Override
    public void deactivateAllSpells(boolean force, boolean quiet) {
        ArrayList<MageSpell> active = new ArrayList<MageSpell>(this.activeSpells);
        for (MageSpell spell : active) {
            if (!spell.deactivate(force, quiet)) continue;
            this.activeSpells.remove(spell);
        }
        this.cancelPending(false);
    }

    @Override
    public boolean isCostFree() {
        if (this.getPlayer() == null) {
            return true;
        }
        return this.getCostReduction() > 1.0f;
    }

    @Override
    public boolean isConsumeFree() {
        return this.activeWand != null && this.activeWand.isConsumeFree();
    }

    @Override
    public boolean isSuperProtected() {
        if (this.superProtectionExpiration != 0L) {
            if (System.currentTimeMillis() > this.superProtectionExpiration) {
                this.superProtectionExpiration = 0L;
            } else {
                return true;
            }
        }
        return this.activeWand != null && this.activeWand.isSuperProtected();
    }

    @Override
    public boolean isSuperPowered() {
        return this.activeWand != null && this.activeWand.isSuperPowered();
    }

    @Override
    public float getCostReduction() {
        return this.activeWand == null ? this.costReduction + this.controller.getCostReduction() : this.activeWand.getCostReduction() + this.costReduction;
    }

    @Override
    public float getConsumeReduction() {
        return this.activeWand == null ? 0.0f : this.activeWand.getConsumeReduction();
    }

    @Override
    public float getCostScale() {
        return 1.0f;
    }

    @Override
    public float getCooldownReduction() {
        return this.activeWand == null ? this.cooldownReduction + this.controller.getCooldownReduction() : this.activeWand.getCooldownReduction() + this.cooldownReduction;
    }

    @Override
    public boolean isCooldownFree() {
        return this.getCooldownReduction() > 1.0f;
    }

    @Override
    public long getRemainingCooldown() {
        long remaining = 0L;
        if (this.cooldownExpiration > 0L) {
            long now = System.currentTimeMillis();
            if (this.cooldownExpiration > now) {
                remaining = this.cooldownExpiration - now;
            } else {
                this.cooldownExpiration = 0L;
            }
        }
        return remaining;
    }

    @Override
    public void clearCooldown() {
        this.cooldownExpiration = 0L;
    }

    @Override
    public void setRemainingCooldown(long ms) {
        this.cooldownExpiration = Math.max(ms + System.currentTimeMillis(), this.cooldownExpiration);
    }

    @Override
    public Color getEffectColor() {
        if (this.activeWand == null) {
            return null;
        }
        return this.activeWand.getEffectColor();
    }

    @Override
    public String getEffectParticleName() {
        if (this.activeWand == null) {
            return null;
        }
        ParticleEffect particle = this.activeWand.getEffectParticle();
        return particle == null ? null : particle.name();
    }

    @Override
    public void onCast(Spell spell, SpellResult result) {
        this.lastCast = System.currentTimeMillis();
        if (spell != null) {
            this.controller.onCast(this, spell, result);
        }
    }

    @Override
    public float getPower() {
        float power = Math.min(this.controller.getMaxPower(), this.activeWand == null ? 0.0f : this.activeWand.getPower());
        return power * this.powerMultiplier;
    }

    @Override
    public boolean isRestricted(Material material) {
        Player player = this.getPlayer();
        if (player != null && player.hasPermission("Magic.bypass_restricted")) {
            return false;
        }
        return this.controller.isRestricted(material);
    }

    @Override
    public MageController getController() {
        return this.controller;
    }

    @Override
    public Set<Material> getRestrictedMaterials() {
        if (this.isSuperPowered()) {
            return EMPTY_MATERIAL_SET;
        }
        return this.controller.getRestrictedMaterials();
    }

    @Override
    public boolean isPVPAllowed(Location location) {
        return this.controller.isPVPAllowed(this.getPlayer(), location == null ? this.getLocation() : location);
    }

    @Override
    public boolean hasBuildPermission(Block block) {
        return this.controller.hasBuildPermission(this.getPlayer(), block);
    }

    @Override
    public boolean hasBreakPermission(Block block) {
        return this.controller.hasBreakPermission(this.getPlayer(), block);
    }

    @Override
    public boolean isIndestructible(Block block) {
        return this.controller.isIndestructible(block);
    }

    @Override
    public boolean isDestructible(Block block) {
        return this.controller.isDestructible(block);
    }

    @Override
    public boolean isDead() {
        LivingEntity entity = this.getLivingEntity();
        if (entity != null) {
            return entity.isDead();
        }
        CommandSender sender = this.getCommandSender();
        if (sender == null || !(sender instanceof BlockCommandSender)) {
            return true;
        }
        BlockCommandSender commandBlock = (BlockCommandSender)sender;
        Block block = commandBlock.getBlock();
        if (!block.getChunk().isLoaded()) {
            return true;
        }
        return block.getType() != Material.COMMAND;
    }

    @Override
    public boolean isOnline() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.isOnline();
        }
        CommandSender sender = this.getCommandSender();
        if (sender == null || !(sender instanceof BlockCommandSender)) {
            return true;
        }
        return this.lastCast > System.currentTimeMillis() - (long)AUTOMATA_ONLINE_TIMEOUT;
    }

    @Override
    public boolean isPlayer() {
        Player player = this.getPlayer();
        return player != null;
    }

    @Override
    public boolean hasLocation() {
        return this.getLocation() != null;
    }

    @Override
    public Inventory getInventory() {
        if (this.hasStoredInventory()) {
            return this.getStoredInventory();
        }
        Player player = this.getPlayer();
        if (player != null) {
            return player.getInventory();
        }
        return null;
    }

    @Override
    public int removeItem(ItemStack itemStack, boolean allowVariants) {
        int amount = itemStack == null ? 0 : itemStack.getAmount();
        Inventory inventory = this.getInventory();
        ItemStack[] contents = inventory.getContents();
        for (int index = 0; amount > 0 && index < contents.length; ++index) {
            ItemStack item = contents[index];
            if (item == null || (allowVariants || !itemStack.isSimilar(item)) && (!allowVariants || itemStack.getType() != item.getType() || item.getItemMeta() != null && item.getItemMeta().getDisplayName() != null)) continue;
            if (amount >= item.getAmount()) {
                amount -= item.getAmount();
                inventory.setItem(index, null);
                continue;
            }
            item.setAmount(item.getAmount() - amount);
            amount = 0;
        }
        return amount;
    }

    @Override
    public boolean hasItem(ItemStack itemStack, boolean allowVariants) {
        ItemStack[] contents;
        int amount;
        int n = amount = itemStack == null ? 0 : itemStack.getAmount();
        if (amount <= 0) {
            return true;
        }
        Inventory inventory = this.getInventory();
        for (ItemStack item : contents = inventory.getContents()) {
            if (item == null || (allowVariants || !itemStack.isSimilar(item)) && (!allowVariants || itemStack.getType() != item.getType() || item.getItemMeta() != null && item.getItemMeta().getDisplayName() != null) || (amount -= item.getAmount()) > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int removeItem(ItemStack itemStack) {
        return this.removeItem(itemStack, false);
    }

    @Override
    public boolean hasItem(ItemStack itemStack) {
        return this.hasItem(itemStack, false);
    }

    @Override
    public Wand getSoulWand() {
        if (this.soulWand == null) {
            this.soulWand = new Wand(this.controller);
        }
        return this.soulWand;
    }

    @Override
    public Wand getActiveWand() {
        return this.activeWand;
    }

    @Override
    public MaterialBrush getBrush() {
        return this.brush;
    }

    @Override
    public float getDamageMultiplier() {
        float maxPowerMultiplier = this.controller.getMaxDamagePowerMultiplier() - 1.0f;
        return 1.0f + maxPowerMultiplier * this.getPower();
    }

    @Override
    public float getRangeMultiplier() {
        if (this.activeWand == null) {
            return 1.0f;
        }
        float maxPowerMultiplier = this.controller.getMaxRangePowerMultiplier() - 1.0f;
        float maxPowerMultiplierMax = this.controller.getMaxRangePowerMultiplierMax();
        float multiplier = 1.0f + maxPowerMultiplier * this.getPower();
        return Math.min(multiplier, maxPowerMultiplierMax);
    }

    @Override
    public float getConstructionMultiplier() {
        float maxPowerMultiplier = this.controller.getMaxConstructionPowerMultiplier() - 1.0f;
        return 1.0f + maxPowerMultiplier * this.getPower();
    }

    @Override
    public float getRadiusMultiplier() {
        if (this.activeWand == null) {
            return 1.0f;
        }
        float maxPowerMultiplier = this.controller.getMaxRadiusPowerMultiplier() - 1.0f;
        float maxPowerMultiplierMax = this.controller.getMaxRadiusPowerMultiplierMax();
        float multiplier = 1.0f + maxPowerMultiplier * this.getPower();
        return Math.min(multiplier, maxPowerMultiplierMax);
    }

    @Override
    public float getMana() {
        return this.activeWand == null ? 0.0f : this.activeWand.getMana();
    }

    @Override
    public void removeMana(float mana) {
        if (this.activeWand != null) {
            this.activeWand.removeMana(mana);
        }
    }

    @Override
    public void removeExperience(int xp) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        float expProgress = player.getExp();
        int expLevel = player.getLevel();
        while ((expProgress > 0.0f || expLevel > 0) && xp > 0) {
            if (expProgress > 0.0f) {
                float expToLevel = Wand.getExpToLevel(expLevel);
                int expAtLevel = (int)(expProgress * expToLevel);
                if (expAtLevel > xp) {
                    xp = 0;
                    expProgress = (float)(expAtLevel -= xp) / expToLevel;
                    continue;
                }
                expProgress = 0.0f;
                xp -= expAtLevel;
                continue;
            }
            if ((xp -= Wand.getExpToLevel(--expLevel - 1)) >= 0) continue;
            expProgress = (float)(-xp) / (float)Wand.getExpToLevel(expLevel);
            xp = 0;
        }
        player.setExp(Math.max(0.0f, Math.min(1.0f, expProgress)));
        player.setLevel(Math.max(0, expLevel));
    }

    @Override
    public int getLevel() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getLevel();
        }
        return 0;
    }

    @Override
    public void setLevel(int level) {
        Player player = this.getPlayer();
        if (player != null) {
            player.setLevel(level);
        }
    }

    @Override
    public int getExperience() {
        Player player = this.getPlayer();
        if (player == null) {
            return 0;
        }
        float expProgress = player.getExp();
        int expLevel = player.getLevel();
        return Wand.getExperience(expLevel, expProgress);
    }

    @Override
    public void giveExperience(int xp) {
        Player player = this.getPlayer();
        if (player != null) {
            player.giveExp(xp);
        }
    }

    public void sendExperience(float exp, int level) {
        Player player = this.getPlayer();
        if (player != null) {
            CompatibilityUtils.sendExperienceUpdate(player, exp, level);
            this.virtualExperience = true;
        }
    }

    public void resetSentExperience() {
        Player player = this.getPlayer();
        if (player != null) {
            CompatibilityUtils.sendExperienceUpdate(player, player.getExp(), player.getLevel());
        }
        this.virtualExperience = false;
    }

    @Override
    public boolean addBatch(Batch batch) {
        if (this.pendingBatches.size() >= this.controller.getPendingQueueDepth()) {
            this.controller.getLogger().info("Rejected spell cast for " + this.getName() + ", already has " + this.pendingBatches.size() + " pending, limit: " + this.controller.getPendingQueueDepth());
            return false;
        }
        this.pendingBatches.addLast(batch);
        this.controller.addPending(this);
        return true;
    }

    @Override
    public void registerEvent(SpellEventType type, Listener spell) {
        switch (type) {
            case PLAYER_QUIT: {
                if (this.quitListeners.contains(spell)) break;
                this.quitListeners.add(spell);
                break;
            }
            case PLAYER_DAMAGE: {
                if (this.damageListeners.contains(spell)) break;
                this.damageListeners.add(spell);
                break;
            }
            case PLAYER_DEATH: {
                if (this.deathListeners.contains(spell)) break;
                this.deathListeners.add(spell);
            }
        }
    }

    @Override
    public void unregisterEvent(SpellEventType type, Listener spell) {
        switch (type) {
            case PLAYER_DAMAGE: {
                this.damageListeners.remove(spell);
                break;
            }
            case PLAYER_QUIT: {
                this.quitListeners.remove(spell);
                break;
            }
            case PLAYER_DEATH: {
                this.deathListeners.remove(spell);
            }
        }
    }

    @Override
    public Player getPlayer() {
        return (Player)this._player.get();
    }

    @Override
    public Entity getEntity() {
        return (Entity)this._entity.get();
    }

    @Override
    public LivingEntity getLivingEntity() {
        Entity entity = (Entity)this._entity.get();
        return entity != null && entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    @Override
    public CommandSender getCommandSender() {
        return (CommandSender)this._commandSender.get();
    }

    @Override
    public List<LostWand> getLostWands() {
        Entity entity = this.getEntity();
        Collection<LostWand> allWands = this.controller.getLostWands();
        ArrayList<LostWand> mageWands = new ArrayList<LostWand>();
        if (entity == null) {
            return mageWands;
        }
        String playerId = entity.getUniqueId().toString();
        for (LostWand lostWand : allWands) {
            String owner = lostWand.getOwnerId();
            if (owner == null || !owner.equals(playerId)) continue;
            mageWands.add(lostWand);
        }
        return mageWands;
    }

    @Override
    public Location getLastDeathLocation() {
        return this.lastDeathLocation;
    }

    @Override
    public void showHoloText(Location location, String text, int duration) {
        if (!this.isPlayer()) {
            return;
        }
        final Player player = this.getPlayer();
        if (this.hologram == null) {
            this.hologram = HoloUtils.createHoloText(location, text);
        } else {
            if (this.hologramIsVisible) {
                this.hologram.hide(player);
            }
            this.hologram.teleport(location);
            this.hologram.setLabel(text);
        }
        this.hologram.show(player);
        BukkitScheduler scheduler = Bukkit.getScheduler();
        if (this.hologramTaskId != null) {
            scheduler.cancelTask(this.hologramTaskId.intValue());
        }
        if (duration > 0) {
            scheduler.scheduleSyncDelayedTask((Plugin)this.controller.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    Mage.this.hologram.hide(player);
                    Mage.this.hologramIsVisible = false;
                }
            }, (long)duration);
        }
    }

    @Override
    public void enableFallProtection(int ms, Spell protector) {
        this.enableFallProtection(ms, 1, protector);
    }

    @Override
    public void enableFallProtection(int ms, int count, Spell protector) {
        long nextTime;
        if (ms <= 0 || count <= 0) {
            return;
        }
        if (protector != null && protector instanceof BaseSpell) {
            this.fallingSpell = (BaseSpell)protector;
        }
        if ((nextTime = System.currentTimeMillis() + (long)ms) > this.fallProtection) {
            this.fallProtection = nextTime;
        }
        if ((long)count > this.fallProtectionCount) {
            this.fallProtectionCount = count;
        }
    }

    @Override
    public void enableFallProtection(int ms) {
        this.enableFallProtection(ms, null);
    }

    @Override
    public void enableSuperProtection(int ms) {
        if (ms <= 0) {
            return;
        }
        long nextTime = System.currentTimeMillis() + (long)ms;
        if (nextTime > this.superProtectionExpiration) {
            this.superProtectionExpiration = nextTime;
        }
    }

    @Override
    public void clearSuperProtection() {
        this.superProtectionExpiration = 0L;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    @Override
    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public boolean isValid() {
        if (!this.hasEntity) {
            return true;
        }
        Entity entity = this.getEntity();
        if (entity == null) {
            return false;
        }
        if (this.controller.isNPC(entity)) {
            return true;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.isOnline();
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return !living.isDead();
        }
        return entity.isValid();
    }

    @Override
    public boolean restoreWand() {
        Wand tempWand;
        String template;
        ItemStack[] inventory;
        if (this.boundWands.size() == 0) {
            return false;
        }
        Player player = this.getPlayer();
        if (player == null) {
            return false;
        }
        HashSet<String> foundTemplates = new HashSet<String>();
        for (ItemStack item : inventory = this.getInventory().getContents()) {
            if (!Wand.isWand(item) || (template = (tempWand = new Wand(this.controller, item)).getTemplateKey()) == null) continue;
            foundTemplates.add(template);
        }
        for (ItemStack item : inventory = player.getEnderChest().getContents()) {
            if (!Wand.isWand(item) || (template = (tempWand = new Wand(this.controller, item)).getTemplateKey()) == null) continue;
            foundTemplates.add(template);
        }
        int givenWands = 0;
        for (Map.Entry<String, Wand> wandEntry : this.boundWands.entrySet()) {
            if (foundTemplates.contains(wandEntry.getKey())) continue;
            ++givenWands;
            ItemStack wandItem = wandEntry.getValue().duplicate().getItem();
            wandItem.setAmount(1);
            this.giveItem(wandItem);
        }
        return givenWands > 0;
    }

    @Override
    public boolean isStealth() {
        if (this.isSneaking()) {
            return true;
        }
        return this.activeWand != null && this.activeWand.isStealth();
    }

    @Override
    public boolean isSneaking() {
        Player player = this.getPlayer();
        return player != null && player.isSneaking();
    }

    @Override
    public ConfigurationSection getData() {
        if (this.loading) {
            return new MemoryConfiguration();
        }
        return this.data;
    }

    public void onGUIDeactivate() {
        GUIAction previousGUI = this.gui;
        this.gui = null;
        if (previousGUI != null) {
            previousGUI.deactivated();
        }
    }

    @Override
    public void activateGUI(GUIAction action, Inventory inventory) {
        Player player = this.getPlayer();
        if (player != null) {
            this.controller.disableItemSpawn();
            try {
                player.closeInventory();
                if (inventory != null) {
                    this.gui = action;
                    player.openInventory(inventory);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            this.controller.enableItemSpawn();
        }
        this.gui = action;
    }

    @Override
    public void continueGUI(GUIAction action, Inventory inventory) {
        Player player = this.getPlayer();
        if (player != null) {
            this.controller.disableItemSpawn();
            try {
                if (inventory != null) {
                    this.gui = action;
                    player.openInventory(inventory);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            this.controller.enableItemSpawn();
        }
        this.gui = action;
    }

    @Override
    public void deactivateGUI() {
        this.activateGUI(null, null);
    }

    @Override
    public GUIAction getActiveGUI() {
        return this.gui;
    }

    @Override
    public int getDebugLevel() {
        return this.debugLevel;
    }

    @Override
    public void setDebugger(CommandSender sender) {
        this.debugger = sender;
    }

    @Override
    public CommandSender getDebugger() {
        return this.debugger;
    }

    @Override
    public void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    @Override
    public void sendDebugMessage(String message) {
        this.sendDebugMessage(message, 1);
    }

    @Override
    public void debugPermissions(CommandSender sender, Spell spell) {
        Wand wand = this.getActiveWand();
        Location location = this.getLocation();
        if (spell == null && wand != null) {
            spell = wand.getActiveSpell();
        }
        sender.sendMessage(ChatColor.GOLD + "Permission check for " + ChatColor.AQUA + this.getDisplayName());
        sender.sendMessage(ChatColor.GOLD + "  id " + ChatColor.DARK_AQUA + this.getId());
        sender.sendMessage(ChatColor.GOLD + " at " + ChatColor.AQUA + ChatColor.BLUE + location.getBlockX() + " " + location.getBlockY() + " " + location.getBlockZ() + " " + ChatColor.DARK_BLUE + location.getWorld().getName());
        Player player = this.getPlayer();
        boolean hasBypass = false;
        boolean hasPVPBypass = false;
        boolean hasBuildBypass = false;
        boolean hasBreakBypass = false;
        if (player != null) {
            hasBypass = player.hasPermission("Magic.bypass");
            hasPVPBypass = player.hasPermission("Magic.bypass_pvp");
            hasBuildBypass = player.hasPermission("Magic.bypass_build");
            sender.sendMessage(ChatColor.AQUA + " Has bypass: " + Mage.formatBoolean(hasBypass, true, null));
            sender.sendMessage(ChatColor.AQUA + " Has PVP bypass: " + Mage.formatBoolean(hasPVPBypass, true, null));
            sender.sendMessage(ChatColor.AQUA + " Has Build bypass: " + Mage.formatBoolean(hasBuildBypass, true, null));
            sender.sendMessage(ChatColor.AQUA + " Has Break bypass: " + Mage.formatBoolean(hasBreakBypass, true, null));
        }
        boolean buildPermissionRequired = spell == null ? false : spell.requiresBuildPermission();
        boolean breakPermissionRequired = spell == null ? false : spell.requiresBreakPermission();
        boolean pvpRestricted = spell == null ? false : spell.isPvpRestricted();
        sender.sendMessage(ChatColor.AQUA + " Can build: " + Mage.formatBoolean(this.hasBuildPermission(location.getBlock()), hasBuildBypass || !buildPermissionRequired ? null : Boolean.valueOf(true)));
        sender.sendMessage(ChatColor.AQUA + " Can break: " + Mage.formatBoolean(this.hasBreakPermission(location.getBlock()), hasBreakBypass || !breakPermissionRequired ? null : Boolean.valueOf(true)));
        sender.sendMessage(ChatColor.AQUA + " Can pvp: " + Mage.formatBoolean(this.isPVPAllowed(location), hasPVPBypass || !pvpRestricted ? null : Boolean.valueOf(true)));
        boolean isPlayer = player != null;
        boolean spellDisguiseRestricted = spell == null ? false : spell.isDisguiseRestricted();
        sender.sendMessage(ChatColor.AQUA + " Is disguised: " + Mage.formatBoolean(this.controller.isDisguised(this.getEntity()), null, isPlayer && spellDisguiseRestricted ? Boolean.valueOf(true) : null));
        WorldBorder border = location.getWorld().getWorldBorder();
        double borderSize = border.getSize();
        if (borderSize < 5.0E7) {
            borderSize = borderSize / 2.0 - (double)border.getWarningDistance();
            Location offset = location.subtract(border.getCenter());
            boolean isOutsideBorder = offset.getX() < -borderSize || offset.getX() > borderSize || offset.getZ() < -borderSize || offset.getZ() > borderSize;
            sender.sendMessage(ChatColor.AQUA + " Is in world border (" + ChatColor.GRAY + borderSize + ChatColor.AQUA + "): " + Mage.formatBoolean(!isOutsideBorder, true, false));
        }
        if (spell != null) {
            sender.sendMessage(ChatColor.AQUA + " Has pnode " + ChatColor.GOLD + spell.getPermissionNode() + ChatColor.AQUA + ": " + Mage.formatBoolean(spell.hasCastPermission((CommandSender)player), hasBypass ? null : Boolean.valueOf(true)));
            sender.sendMessage(ChatColor.AQUA + " Region override: " + Mage.formatBoolean(this.controller.getRegionCastPermission(player, spell, location), hasBypass ? null : Boolean.valueOf(true)));
            sender.sendMessage(ChatColor.AQUA + " Field override: " + Mage.formatBoolean(this.controller.getPersonalCastPermission(player, spell, location), hasBypass ? null : Boolean.valueOf(true)));
            MaterialBrush brush = spell.getBrush();
            if (brush != null) {
                sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " is erase: " + Mage.formatBoolean(brush.isErase(), null));
            }
            sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " requires build: " + Mage.formatBoolean(spell.requiresBuildPermission(), null, true, true));
            sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " requires break: " + Mage.formatBoolean(spell.requiresBreakPermission(), null, true, true));
            sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " requires pvp: " + Mage.formatBoolean(spell.isPvpRestricted(), null, true, true));
            sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " allowed while disguised: " + Mage.formatBoolean(!spell.isDisguiseRestricted(), null, false, true));
            if (spell instanceof BaseSpell) {
                boolean buildPermission = ((BaseSpell)spell).hasBuildPermission(location.getBlock());
                sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " has build: " + Mage.formatBoolean(buildPermission, hasBuildBypass || !spell.requiresBuildPermission() ? null : Boolean.valueOf(true)));
                boolean breakPermission = ((BaseSpell)spell).hasBreakPermission(location.getBlock());
                sender.sendMessage(ChatColor.GOLD + " " + spell.getName() + ChatColor.AQUA + " has break: " + Mage.formatBoolean(breakPermission, hasBreakBypass || !spell.requiresBreakPermission() ? null : Boolean.valueOf(true)));
            }
            sender.sendMessage(ChatColor.AQUA + " Can cast " + ChatColor.GOLD + spell.getName() + ChatColor.AQUA + ": " + Mage.formatBoolean(spell.canCast(location)));
        }
    }

    public static String formatBoolean(Boolean flag, Boolean greenState) {
        return Mage.formatBoolean(flag, greenState, greenState == null ? null : Boolean.valueOf(greenState == false), false);
    }

    public static String formatBoolean(Boolean flag) {
        return Mage.formatBoolean(flag, true, false, false);
    }

    public static String formatBoolean(Boolean flag, Boolean greenState, Boolean redState) {
        return Mage.formatBoolean(flag, greenState, redState, false);
    }

    public static String formatBoolean(Boolean flag, Boolean greenState, Boolean redState, boolean dark) {
        String text;
        if (flag == null) {
            return ChatColor.GRAY + "none";
        }
        String string = text = flag != false ? "true" : "false";
        if (greenState != null && flag == greenState) {
            return (dark ? ChatColor.DARK_GREEN : ChatColor.GREEN) + text;
        }
        if (redState != null && flag == redState) {
            return (dark ? ChatColor.DARK_RED : ChatColor.RED) + text;
        }
        return ChatColor.GRAY + text;
    }

    @Override
    public void sendDebugMessage(String message, int level) {
        if (this.debugLevel >= level && message != null && !message.isEmpty()) {
            CommandSender sender = this.debugger;
            if (sender == null) {
                sender = this.getCommandSender();
            }
            if (sender != null) {
                sender.sendMessage(this.controller.getMessagePrefix() + message);
            }
        }
    }

    public void clearRespawnInventories() {
        this.respawnArmor = null;
        this.respawnInventory = null;
    }

    public void restoreRespawnInventories() {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        if (this.respawnArmor != null) {
            ItemStack[] armor = inventory.getArmorContents();
            for (Map.Entry<Integer, ItemStack> entry : this.respawnArmor.entrySet()) {
                armor[entry.getKey().intValue()] = entry.getValue();
            }
            player.getInventory().setArmorContents(armor);
            this.armorUpdated();
        }
        if (this.respawnInventory != null) {
            for (Map.Entry<Integer, ItemStack> entry : this.respawnInventory.entrySet()) {
                inventory.setItem(entry.getKey().intValue(), entry.getValue());
            }
        }
        this.clearRespawnInventories();
        this.armorUpdated();
    }

    public void addToRespawnInventory(int slot, ItemStack item) {
        if (this.respawnInventory == null) {
            this.respawnInventory = new HashMap<Integer, ItemStack>();
        }
        this.respawnInventory.put(slot, item);
    }

    public void addToRespawnArmor(int slot, ItemStack item) {
        if (this.respawnArmor == null) {
            this.respawnArmor = new HashMap<Integer, ItemStack>();
        }
        this.respawnArmor.put(slot, item);
    }

    @Override
    public void giveItem(ItemStack itemStack) {
        Wand activeWand = this.getActiveWand();
        if (activeWand != null && activeWand.addItem(itemStack)) {
            return;
        }
        if (this.hasStoredInventory()) {
            this.addToStoredInventory(itemStack);
            return;
        }
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack inHand = inventory.getItemInHand();
        if (inHand == null || inHand.getType() == Material.AIR) {
            inventory.setItemInHand(itemStack);
            itemStack = inventory.getItemInHand();
            if (Wand.isWand(itemStack)) {
                Wand wand = new Wand(this.controller, itemStack);
                wand.activate(this);
            } else if (itemStack.getType() == Material.MAP) {
                this.setLastHeldMapId(itemStack.getDurability());
            }
        } else {
            HashMap returned = player.getInventory().addItem(new ItemStack[]{itemStack});
            if (returned.size() > 0) {
                player.getWorld().dropItem(player.getLocation(), itemStack);
            }
        }
    }

    public void armorUpdated() {
        this.activeArmor.clear();
        Player player = this.getPlayer();
        if (player != null) {
            ItemStack[] armor = player.getInventory().getArmorContents();
            for (int index = 0; index < armor.length; ++index) {
                ItemStack armorItem = armor[index];
                if (!Wand.isWand(armorItem)) continue;
                this.activeArmor.put(index, new Wand(this.controller, armorItem));
            }
        }
        if (this.activeWand != null) {
            this.activeWand.armorUpdated();
        }
        this.updateEquipmentEffects();
    }

    protected void updateEquipmentEffects() {
        this.damageReduction = 0.0f;
        this.damageReductionPhysical = 0.0f;
        this.damageReductionProjectiles = 0.0f;
        this.damageReductionFalling = 0.0f;
        this.damageReductionFire = 0.0f;
        this.damageReductionExplosions = 0.0f;
        this.effectivePotionEffects.clear();
        if (this.activeWand != null && !this.activeWand.isPassive()) {
            this.damageReduction += this.activeWand.getDamageReduction();
            this.damageReductionPhysical += this.activeWand.getDamageReductionPhysical();
            this.damageReductionProjectiles += this.activeWand.getDamageReductionProjectiles();
            this.damageReductionFalling += this.activeWand.getDamageReductionFalling();
            this.damageReductionFire += this.activeWand.getDamageReductionFire();
            this.damageReductionExplosions += this.activeWand.getDamageReductionExplosions();
            this.effectivePotionEffects.putAll(this.activeWand.getPotionEffects());
        }
        for (Wand armorWand : this.activeArmor.values()) {
            if (armorWand == null) continue;
            this.damageReduction += armorWand.getDamageReduction();
            this.damageReductionPhysical += armorWand.getDamageReductionPhysical();
            this.damageReductionProjectiles += armorWand.getDamageReductionProjectiles();
            this.damageReductionFalling += armorWand.getDamageReductionFalling();
            this.damageReductionFire += armorWand.getDamageReductionFire();
            this.damageReductionExplosions += armorWand.getDamageReductionExplosions();
            this.effectivePotionEffects.putAll(armorWand.getPotionEffects());
        }
        this.damageReduction = Math.min(this.damageReduction, 1.0f);
        this.damageReductionPhysical = Math.min(this.damageReductionPhysical, 1.0f);
        this.damageReductionProjectiles = Math.min(this.damageReductionProjectiles, 1.0f);
        this.damageReductionFalling = Math.min(this.damageReductionFalling, 1.0f);
        this.damageReductionFire = Math.min(this.damageReductionFire, 1.0f);
        this.damageReductionExplosions = Math.min(this.damageReductionExplosions, 1.0f);
        LivingEntity entity = this.getLivingEntity();
        if (entity != null) {
            Collection activeEffects = entity.getActivePotionEffects();
            for (PotionEffect potionEffect : activeEffects) {
                if (this.effectivePotionEffects.containsKey(potionEffect.getType()) || potionEffect.getDuration() <= 0x1FFFFFFF) continue;
                entity.removePotionEffect(potionEffect.getType());
            }
            for (Map.Entry entry : this.effectivePotionEffects.entrySet()) {
                PotionEffect effect = new PotionEffect((PotionEffectType)entry.getKey(), Integer.MAX_VALUE, ((Integer)entry.getValue()).intValue(), true);
                CompatibilityUtils.applyPotionEffect(entity, effect);
            }
        }
    }

    public Collection<Wand> getActiveArmor() {
        return this.activeArmor.values();
    }

    @Override
    public void deactivate() {
        if (this.activeWand != null) {
            this.activeWand.deactivate();
        }
        this.deactivateAllSpells(true, true);
        this.removeActiveEffects();
    }

    @Override
    public void undoScheduled() {
        int finished;
        int undid;
        if (this.undoQueue != null && (undid = this.undoQueue.undoScheduled()) != 0) {
            this.controller.info("Player " + this.getName() + " logging out, auto-undid " + undid + " spells");
        }
        if ((finished = this.finishPendingUndo()) != 0) {
            this.controller.info("Player " + this.getName() + " logging out, fast-forwarded undo for " + finished + " spells");
        }
        if (this.undoQueue != null && !this.undoQueue.isEmpty()) {
            if (this.controller.commitOnQuit()) {
                this.controller.info("Player logging out, committing constructions: " + this.getName());
                this.undoQueue.commit();
            } else {
                this.controller.info("Player " + this.getName() + " logging out with " + this.undoQueue.getSize() + " spells in their undo queue");
            }
        }
    }

    @Override
    public void removeItemsWithTag(String tag) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack[] contents = inventory.getContents();
        for (int index = 0; index < contents.length; ++index) {
            ItemStack item = contents[index];
            if (item == null || item.getType() == Material.AIR || !InventoryUtils.hasMeta(item, tag)) continue;
            inventory.setItem(index, null);
        }
        boolean modified = false;
        ItemStack[] armor = inventory.getArmorContents();
        for (int index = 0; index < armor.length; ++index) {
            ItemStack item = armor[index];
            if (item == null || item.getType() == Material.AIR || !InventoryUtils.hasMeta(item, tag)) continue;
            modified = true;
            armor[index] = null;
        }
        if (modified) {
            inventory.setArmorContents(armor);
        }
    }

    @Override
    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    @Override
    public boolean isQuiet() {
        return this.quiet;
    }

    public void setDestinationWarp(String warp) {
        this.destinationWarp = warp;
    }

    @Override
    public boolean isAtMaxSkillPoints() {
        return this.getSkillPoints() >= this.controller.getSPMaximum();
    }

    @Override
    public int getSkillPoints() {
        if (this.data.contains(SKILL_POINT_KEY)) {
            if (this.data.isString(SKILL_POINT_KEY)) {
                try {
                    this.data.set(SKILL_POINT_KEY, (Object)Integer.parseInt(this.data.getString(SKILL_POINT_KEY)));
                }
                catch (Exception ex) {
                    this.data.set(SKILL_POINT_KEY, (Object)0);
                }
            }
            return this.data.getInt(SKILL_POINT_KEY);
        }
        return 0;
    }

    @Override
    public void addSkillPoints(int delta) {
        int current = this.getSkillPoints();
        this.setSkillPoints(current + delta);
    }

    @Override
    public void setSkillPoints(int amount) {
        boolean firstEarn = !this.data.contains(SKILL_POINT_KEY);
        amount = Math.max(amount, 0);
        int limit = this.controller.getSPMaximum();
        if (limit > 0) {
            amount = Math.min(amount, limit);
        }
        this.data.set(SKILL_POINT_KEY, (Object)amount);
        if (this.activeWand != null && Wand.spMode != WandManaMode.NONE) {
            if (firstEarn) {
                this.sendMessage(this.activeWand.getMessage("sp_instructions"));
            }
            this.activeWand.updateMana();
        }
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand getBoundWand(String template) {
        return this.boundWands.get(template);
    }

    @Override
    public WandUpgradePath getBoundWandPath(String templateKey) {
        com.elmakers.mine.bukkit.api.wand.Wand boundWand = this.boundWands.get(templateKey);
        if (boundWand != null) {
            return boundWand.getPath();
        }
        return null;
    }

    public void setEntityData(EntityData entityData) {
        this.entityData = entityData;
    }
}

