/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effect.builtin;

import com.elmakers.mine.bukkit.effect.EffectRepeating;
import com.elmakers.mine.bukkit.slikey.effectlib.util.DynamicLocation;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EffectTrail
extends EffectRepeating {
    protected Double length;
    protected double size;
    protected Vector direction;

    public EffectTrail() {
    }

    public EffectTrail(Plugin plugin) {
        super(plugin);
    }

    @Override
    public void load(Plugin plugin, ConfigurationSection configuration) {
        this.iterations = 8;
        super.load(plugin, configuration);
        this.length = ConfigurationUtils.getDouble(configuration, "length", this.length);
    }

    @Override
    public void play() {
        Location target = this.getTarget();
        Location origin = this.getOrigin();
        this.size = this.length != null ? this.length : (target != null && origin != null ? origin.distance(target) : 0.0);
        if (this.size < 1.0) {
            this.stop();
            return;
        }
        this.direction = this.getDirection();
        super.play();
    }

    @Override
    public void iterate() {
        Location origin = this.getOrigin();
        Location target = this.getTarget();
        if (origin == null) {
            return;
        }
        Vector delta = this.direction.clone();
        Location source = origin.clone();
        if (this.playAtOrigin) {
            source.add(delta.multiply(this.scale(this.size) + 1.0));
        }
        if (target != null && this.playAtTarget) {
            target = target.clone();
            target.add(delta.multiply(-this.scale(this.size) + 1.0));
        }
        this.playEffect(new DynamicLocation(source, this.getOriginEntity()), new DynamicLocation(target, this.getTargetEntity()));
    }

    @Override
    protected void checkLocations() {
        Location target = this.getTarget();
        Location origin = this.getOrigin();
        if (target == null && origin != null) {
            Vector delta = origin.getDirection().clone().normalize();
            target = origin.clone();
            target.add(delta.multiply(this.size + 1.0));
        }
        super.checkLocations();
    }
}

